#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdint.h>
#include <sys/mman.h>
#include <errno.h>
#include <string.h>


// Stratix 10 HPS Register Map
// https://www.intel.com/content/www/us/en/programmable/hps/stratix-10/hps.html

//////// HPS2FPGA LW Bridge ///////////
// FPGA_bridge_lwsoc2fpga_2M
// https://www.intel.com/content/www/us/en/programmable/hps/stratix-10/hps.html
#define LWHPS2FPGA_BASE ( 0xf9000000 )  //LWHPS2FPGA_memory
#define LWHPS2FPGA_SPAN ( 0x200000 )  // 2MB
#define LWHPS2FPGA_MASK ( LWHPS2FPGA_SPAN - 1 )


#define  periph_led_pio 0x1080 // GHRD/qsys_top/qsys_top.html
#define  periph_led_mask 0x01



int main() {
    void* virtual_base;
    int fd;
    int loop_count;
    //int led_direction;
    int led_mask;
    void* h2p_lw_led_addr;
    const int blink_dur_sec = 30;

    // map the address space for the LED registers into user space so we can interact with them.
    // we'll actually map in the entire CSR span of the HPS since we want to access various registers within that span

    if ((fd = open("/dev/mem", (O_RDWR | O_SYNC))) == -1) {
        printf("ERROR: could not open \"/dev/mem\"...\n");
        return(1);
    }
    //printf("LWHPS2FPGA_SPAN=0x%x\n", LWHPS2FPGA_SPAN);
    virtual_base = mmap(NULL, LWHPS2FPGA_SPAN, (PROT_READ | PROT_WRITE), MAP_SHARED, fd, LWHPS2FPGA_BASE );

    if (virtual_base == MAP_FAILED) {
        printf("ERROR: mmap() failed...\n");
        printf("errno : %s\n", strerror(errno));
        close(fd);
        return(1);
    }

    h2p_lw_led_addr = virtual_base + ((unsigned long)(periph_led_pio) & (unsigned long)(LWHPS2FPGA_MASK ));


	// blink LED. one per second. total blink 30 second
	loop_count = 0;
	led_mask = periph_led_mask;
	printf("blink led %d seconds\r\n", blink_dur_sec);
	while (loop_count < blink_dur_sec*2) {
		printf("led %s\r\n", (led_mask & periph_led_mask)?"on":"off");
        // control led
        *(uint32_t*)h2p_lw_led_addr = ~led_mask;
        
        led_mask = ~led_mask;
        loop_count ++;
        		
        // wait 500ms
        usleep(500 * 1000);		
	}
	

    // clean up our memory mapping and exit

    if (munmap(virtual_base, LWHPS2FPGA_SPAN ) != 0) {
        printf("ERROR: munmap() failed...\n");
        close(fd);
        return(1);
    }

    close(fd);


    return(0);
}
