#**************************************************************
# This .sdc file is created by Terasic Tool.
# Users are recommended to modify this file to match users logic.
#**************************************************************

#**************************************************************
# Create Clock
#**************************************************************
create_clock -period "125.0 MHz" -name ENETB_RX_CLK [get_ports ENETB_RX_CLK]
create_clock -period "125.0 MHz" -name ENETB_RX_CLK_ext

create_generated_clock -source [get_pins {soc_inst|s10_hps|altera_stratix10_hps_inst|fpga_interfaces|peripheral_emac1~emac1_gmii_txclk}] \
                      -name ENETB_GTX_CLK_ext [get_ports {ENETB_GTX_CLK}]

####################################################
#NETB
# TSE MAC 
set_min_delay  2 -from * -to [get_ports {ENETB_MDC ENETB_MDIO ENETB_RESET_n}]
set_max_delay 10 -from * -to [get_ports {ENETB_MDC ENETB_MDIO ENETB_RESET_n}]

set_min_delay  0 -from [get_ports {ENETB_MDIO}] -to *
set_max_delay  6 -from [get_ports {ENETB_MDIO}] -to *

###############
# input
#**************************************************************
# Input Delay Constraints (Center aligned, Same Edge Analysis)
#**************************************************************
## max delay = tsu (2.5) + skew (0.075)
## min delay = -thd (0.5) - skew (0.075)

# Tco max = T - setup time = 8 - 2.5 = 5.5ns  -1.5ns = 4ns + skew (0.026) = 4.026
# Tco min = hold time = 0.5ns -1.5ns = -1ns - skew (0.026) = -1.026

# Constraint the path to the rising edge of the phy clock
set_input_delay -clock ENETB_RX_CLK_ext -max  4.026 [get_ports {ENETB_RX_DV ENETB_RX_ER ENETB_RX_DATA*}]
set_input_delay -clock ENETB_RX_CLK_ext -min -1.026 [get_ports {ENETB_RX_DV ENETB_RX_ER ENETB_RX_DATA*}]

# Constraint the path to the falling edge of the phy clock
set_input_delay -clock ENETB_RX_CLK_ext -max  4.026 [get_ports {ENETB_RX_DV ENETB_RX_ER ENETB_RX_DATA*}] -clock_fall -add_delay
set_input_delay -clock ENETB_RX_CLK_ext -min -1.026 [get_ports {ENETB_RX_DV ENETB_RX_ER ENETB_RX_DATA*}] -clock_fall -add_delay 
   

set_multicycle_path -setup -rise_from [get_clocks {ENETB_RX_CLK_ext}]  -rise_to [get_clocks {ENETB_RX_CLK}] 0
set_multicycle_path -setup -fall_from [get_clocks {ENETB_RX_CLK_ext}]  -fall_to [get_clocks {ENETB_RX_CLK}] 0 

###############
# output

#**************************************************************
# Output Delay Constraints (Edge Aligned, Same Edge Capture)
#**************************************************************   
## max delay = tsu (2.0) + skew (0.075) 
## min delay = -thd (0) - skew (0.075) 
  
# max delay = TD max + Tsu = 0 + 2.0 = 2ns -1.5ns = 0.5ns + skew (0.015) = 0.515
# min delay = TD min – Thd = 0 – 0 = 0ns -1.5ns = -1.5ns - skew (0.015) = -1.515
 
# Constraint the path to the rising edge of the phy clock
set_output_delay -clock ENETB_GTX_CLK_ext -max  0.515 [get_ports {ENETB_TX_EN ENETB_TX_ER ENETB_TX_DATA*}]
set_output_delay -clock ENETB_GTX_CLK_ext -min -1.515 [get_ports {ENETB_TX_EN ENETB_TX_ER FMCA_ENETB_TX_DATANET0_TX_D*}]

# Constraint the path to the falling edge of the phy clock
set_output_delay -clock ENETB_GTX_CLK_ext -max  0.515 [get_ports {ENETB_TX_EN ENETB_TX_ER ENETB_TX_DATA*}] -clock_fall -add_delay
set_output_delay -clock ENETB_GTX_CLK_ext -min -1.515 [get_ports {ENETB_TX_EN ENETB_TX_ER ENETB_TX_DATA*}] -clock_fall -add_delay 




