// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

module state_machine_counter #(
parameter INTR_TYPE = 1'b1
)(
   clk,
	reset_n,
	pulse_irq_counter_stop,
	global_enable_reg,
	counter_start,
	counter_stop,
	enable,
	c_idle,
	level_reset,
	data_store
);

input wire clk;
input wire reset_n;
input wire pulse_irq_counter_stop;
input wire global_enable_reg;
input wire counter_start;
input wire counter_stop;

output reg enable;
output reg level_reset;
output reg data_store;
output reg c_idle;

reg [1:0] state ;
reg [1:0] next_state ;

localparam IDLE  =2'b00;
localparam START =2'b01;
localparam STOP  =2'b10;
localparam STORE =2'b11;

//State machine Sequential logic 

always @ (posedge clk or negedge reset_n)
begin
       if (!reset_n) state <= IDLE;
       else          state<= next_state;
end


//State Machine Transitional conditions

always @(state or counter_start or counter_stop or pulse_irq_counter_stop or global_enable_reg) 
      begin
           case (state)
               IDLE: if (counter_start==1'b0 || global_enable_reg == 1'b0 || pulse_irq_counter_stop==1'b1) begin
					           next_state = IDLE;  // active low reset signal	
                       end else begin                         
							     next_state = START;
							  end
               START: if (global_enable_reg == 1'b0) begin
							     next_state = IDLE;
                            end 
					   else if ((INTR_TYPE == 0 & counter_stop==1'b1) |(INTR_TYPE == 1 & pulse_irq_counter_stop==1'b1))
					        begin
							     next_state = STOP;
					    	end
					   else
					       begin
						        next_state = START;
						   end
               STOP: begin
				  	           next_state = STORE;
							  end  
               STORE: begin
					           next_state = IDLE;
							  end
              default:next_state = IDLE; 
     endcase
end


//combo logic function to control counter

always @ (state) begin
        case (state)
          IDLE: begin
		           enable = 1'b0;
					  level_reset = 1'b0;
		 			  data_store = 1'b0;
					  c_idle = 1'b1;
		        end
          START: begin
		           enable = 1'b1;
					  level_reset = 1'b1;
					  data_store = 1'b0;
					  c_idle = 1'b0;
		        end 
          STOP: begin
		           enable = 1'b0;
					  level_reset = 1'b1;
					  data_store = 1'b0;
					  c_idle = 1'b0;
		        end 
          STORE: begin
		           enable = 1'b0;
					  level_reset = 1'b1;
					  data_store = 1'b1;
					  c_idle = 1'b0;
		        end
        endcase
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "AtUsn6TsPz8XMlrVQQ7FY+GKOFQjhv6+bgyaFJNPwlm07QQZAWfY7SZ5BPG++1dJBcuxu/c4GWevFlLjyZXPdk1IdpNArTGmeeMEGa2YkbgyZyI22hjFY6CyFMr3O/td8WaWBIcco/697t23BTRMQdP/MGZxG1plXSJCovDCK8PZg/im9xQgJ+46BtQqmDaw6iCMLfK1TEoD8ye8Kphtw8K2sSoiGYnkIDJc280danKl5SLoCMxKNoJwgsjZKxgzAN5gJLnZg7ZwB2TLUJ5iVvZrFcOqLySIqNxtZ1SaCXxIG9wDklBugzPg5CtQT/YajJQJ4vdF9CNYkZqxuMu4G+it/0McrJ/37RElohIiq7MP05uqLyQfFMPUNrNbMM3GDf5fWo6vYSameOVdo7k/ZfGyOnwBWvX4f9t75rEUY02WxB0Vuc66aDq3GfpX8t5DRx1grxPNQ6EY+wf4abtzmRO3FyVmA12Xr/CRGvqkxCgQrJzpxALpN20s4+J0qcWPkREsJYmuv5cXAqFud6HiD3F1XkA1DCjln/Ni04jhouikHjtTraG3t2VbuvTtpo+fZa4pLHvShBvFvDjHPPLegmQUIpi/jYJQhFsXypOEzKUAxrcbiOtfrXaRr0mBCbxaCpJVDod4J+I/iSvQWAHz7q4QwH37b3rCcHcxunku6NNw+JCt22rQ39Iqj7LIeBS1P5XiEtARTdlc9qzXblefHboX/ZPCZh/ROy2sRKdBT6vQ53sCJuPITJLxNSfCfp5QSf5J9DrGXVez4MWNE6bMP3pjfOFFy5te5UGAUTIpbnfAfdD1i+vHpMrE3W7K9U95EoKSV+cL7ya0muu3ML56uzzyZWk3ESYgXWKDS6BmlffJGJfSf1pPrKxQlZDNMv39S/s8phtO9aRGXuc+UTN8eBbXVrmQMKQ8hAOA24SfoR5Yab9ji9AgRcNDLNBTeIq5oE7INnbsyl1i8x6wld6nXQcU0DoB5T6pp7p+Y06B4BC0OD2SU/c05KZ8vMK3K60i"
`endif