// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

module irq_detector #(
parameter INTR_TYPE = 1'b1
)(
   clk,
	reset_n,
	irq,
	counter_start,
	counter_stop
);

input   wire  clk;
input   wire  irq;
input   wire  reset_n;
output  wire  counter_start;
output  wire  counter_stop;

reg irq_d;

always @ (posedge clk or negedge reset_n)
   if (~reset_n) begin
        irq_d <= 1'b0;
   end
   else begin
	     irq_d <= irq;
   end
	
generate
if (INTR_TYPE == 1'b0) begin	
	
 assign counter_stop = ~irq & irq_d;
 assign counter_start = irq & ~irq_d;
 
end else begin

  assign counter_start = irq & ~irq_d;
  assign counter_stop = 1'b0;
  
end
endgenerate

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "AtUsn6TsPz8XMlrVQQ7FY+GKOFQjhv6+bgyaFJNPwlm07QQZAWfY7SZ5BPG++1dJBcuxu/c4GWevFlLjyZXPdk1IdpNArTGmeeMEGa2YkbgyZyI22hjFY6CyFMr3O/td8WaWBIcco/697t23BTRMQdP/MGZxG1plXSJCovDCK8PZg/im9xQgJ+46BtQqmDaw6iCMLfK1TEoD8ye8Kphtw8K2sSoiGYnkIDJc280danJX3iOiun038FAXaBb6gnvm+5BVRwYIwfj1LdpPH7YdHGD17PT1uj8zPtnvlauE/TS95XgyU9DKsLqrcjHY9kVybEC1kZFfsbeaoVUlU2u5kZ5gcsP9NaMKwmx9w8zxn/Dm14f2enIh7ajuPDoj/RsTjNST1C638mS6f5Re4OV+MQFVg0gqanLVl1GV5xY26B+KY36XgrVAipsB0KqwWVljCV2ixd1O6Y1aBSveGWwJx5sh3x57zefcROaP7YJyQ0T3nEsajfCRbAAcusk67DFoKlAcHrd4x/a3QDS1PKwEhpOYCCa0Gzf9dHIYUpL1YuflqKDUBUgcWvd2D/ELObQ4khgUNjhoxK5GytD/2CaLT4P4joT6kwNv4+lzRbXUqRDnfwuNLp1lT9elNnKE/1DGEp4fADweskBPz3gF2pzFx7I8d+rvkydKLjioqE1w4vBqB2908LuSnhBIFbvttcTvK7ANuA06cm1Ky3o3QhWMZIu65r/Wm05s9G6TNErsghoFHOMqgCCrOb1riKT1yboAJNneuRFLrI3Bex3Xuw9zqiK/6R1PE8Thg2ylB9tDiXXVqOosb/2mnurkLgi9SFJkTCrnNn40SsRavgzNg1xLd3oYKhswQHZN2emAcKivmbSpTV06AGvjWrDyv+ldWi+E2T9hgTxjZX3/ruCInXpbbkY5xmQbMIiletrODzkFxRSX+lJJflAqDBsr8vnMSoOYtfdsbOEVFWwHxiPiubk2qCi6e1d+1gC+5bpJQgweK9e/TPkbmixnsE+u1KJCZ+80"
`endif