// hps_m.v

// Generated using ACDS version 24.3 212

`timescale 1 ps / 1 ps
module hps_m (
		input  wire        clk_clk,              //          clk.clk,           Clock Input
		input  wire        clk_reset_reset,      //    clk_reset.reset,         Reset Input
		output wire        master_reset_reset,   // master_reset.reset,         Reset Output
		output wire [31:0] master_address,       //       master.address,       Address output of Avalon Memory Mapped Host
		input  wire [31:0] master_readdata,      //             .readdata,      Read Data input to Avalon Memory Mapped Host
		output wire        master_read,          //             .read,          Read command from Avalon Memory Mapped Host
		output wire        master_write,         //             .write,         Write command from Avalon Memory Mapped Host
		output wire [31:0] master_writedata,     //             .writedata,     Write Data from Avalon Memory Mapped Host
		input  wire        master_waitrequest,   //             .waitrequest,   Wait request from Avalon Memory Mapped Agent, indicates agent is not ready
		input  wire        master_readdatavalid, //             .readdatavalid, Valid read data indication from Avalon Memory Mapped Agent
		output wire [3:0]  master_byteenable     //             .byteenable,    Indicates valid write data/read data location
	);

	hps_m_altera_jtag_avalon_master_191_unfwqdy #(
		.USE_PLI     (0),
		.PLI_PORT    (50000),
		.FIFO_DEPTHS (2)
	) altera_jtag_avalon_master_inst (
		.clk_clk              (clk_clk),              //   input,   width = 1,          clk.clk
		.clk_reset_reset      (clk_reset_reset),      //   input,   width = 1,    clk_reset.reset
		.master_reset_reset   (master_reset_reset),   //  output,   width = 1, master_reset.reset
		.master_address       (master_address),       //  output,  width = 32,       master.address
		.master_readdata      (master_readdata),      //   input,  width = 32,             .readdata
		.master_read          (master_read),          //  output,   width = 1,             .read
		.master_write         (master_write),         //  output,   width = 1,             .write
		.master_writedata     (master_writedata),     //  output,  width = 32,             .writedata
		.master_waitrequest   (master_waitrequest),   //   input,   width = 1,             .waitrequest
		.master_readdatavalid (master_readdatavalid), //   input,   width = 1,             .readdatavalid
		.master_byteenable    (master_byteenable)     //  output,   width = 4,             .byteenable
	);

endmodule
