// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// --------------------------------------------------------------------------------
//| Avalon ST Idle Inserter 
// --------------------------------------------------------------------------------

`timescale 1ns / 100ps
module altera_avalon_st_idle_inserter (

      // Interface: clk
      input              clk,
      input              reset_n,
      // Interface: ST in
      output reg         in_ready,
      input              in_valid,
      input      [7: 0]  in_data,

      // Interface: ST out 
      input              out_ready,
      output reg         out_valid,
      output reg [7: 0]  out_data
);

   // ---------------------------------------------------------------------
   //| Signal Declarations
   // ---------------------------------------------------------------------

   reg  received_esc;
   wire escape_char, idle_char;

   // ---------------------------------------------------------------------
   //| Thingofamagick
   // ---------------------------------------------------------------------

   assign idle_char = (in_data == 8'h4a);
   assign escape_char = (in_data == 8'h4d);

   always @(posedge clk or negedge reset_n) begin
      if (!reset_n) begin
         received_esc <= 0; 
      end else begin
         if (in_valid & out_ready) begin
            if ((idle_char | escape_char) & ~received_esc & out_ready) begin
                 received_esc <= 1;
            end else begin
                 received_esc <= 0;
            end
         end
      end
   end

   always @* begin
      //we are always valid
      out_valid = 1'b1;
      in_ready = out_ready & (~in_valid | ((~idle_char & ~escape_char) | received_esc));
      out_data = (~in_valid) ? 8'h4a :    //if input is not valid, insert idle
                 (received_esc) ? in_data ^ 8'h20 : //escaped once, send data XOR'd
                 (idle_char | escape_char) ? 8'h4d : //input needs escaping, send escape_char
                 in_data; //send data
   end
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "VudRjuN0tk1dliq/IZQS+q6A3SwrLYgqCGAOiZv6F7upYp/VWDT/TGkE2+r3VsSMpoY/9177GbiXiuHLiFHjByPXYvWCf2+RVLxekQxp9S/K2P8ezIyFtWg0BRLwe9ztN5krrnwZdjpoQ0u8sXAqllkXKlv7b8JRiMxdE4uGu+2hX7MvV2mRvO7errmCrVl0uXMUjAnriNrHGqd9XmJgpXHjMHklF2UpcodnVU9qRuIK+iIiyI/+lR2iXpu/iosIElrchnKVKRgsVmrut03st31o0EyzxOmBvJOCz08sM+YtTk14qmgsOhLWHN10H+1Y6d+e9a0ggRFUWBI+71eoQbBS1y6U4ydLLFGMi/jtIHw33GMmJbJsFE6/YtL6aJcriL0UUJbRNsRF6QCwzRuqHgFqeBFdMzH9Z3dk52NTNCSLeyiX7JTrUAs4S0PsBrK+NZO3+7hE6/7FcXwWD9ceDAVyslgX5nRyUCqsL4jCFQUmoAx4oUhiOQRKcb7O0YND2hoizlaKOY8p/OlYKjuhRFFQkWhWWrnVOY+6MEem9epuHmeIs+nj3Kmh1d6tVR7bLmWWxweUgGXCPoJZ2OXa7ZVroMqyi9DarycOvFUTqsqwhxJk1GpOgf9CIOWca0ze+gJpOR3xgB8WfCKuI3FEzHmMhmEMIioaCwz0WQHieg2QKhPxnIijOKPOXB0rWwB7zZG4RzfVkekhy/tWNlkDAIPZIcS99fUAVsspAcwJobCgTFKlny/sx4uD3Yyg+Rzh2Jx/oNufdNNHsfZZqZRuERr0mcPEQtY2hpqGmsDJ3nvriZyy9GMRMPrlYXYaVgdjlPoKVja9+LjQOgRLl1ThMwdDvmrgb20UFBEfRJFzPZKytEECcXAAEBKKrwXqzUeKEnpw4TeJ7j6jMEepgtOgywcbH6HudmEznc+eZ5GC8qiewtpCyaGJO+wGWCM+NZO460YKP6Z2jLeiDiC/HCCzXANTZSGY3fijL/aOr8yJ/Z/FepwhAYZHODMyIgRGiacx"
`endif