// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// $Id: //acds/rel/24.3/ip/iconnect/merlin/altera_reset_controller/altera_reset_synchronizer.v#1 $
// $Revision: #1 $
// $Date: 2024/08/01 $

// -----------------------------------------------
// Reset Synchronizer
// -----------------------------------------------
`timescale 1 ns / 1 ns

module altera_reset_synchronizer
#(
    parameter ASYNC_RESET = 1,
    parameter DEPTH       = 2
)
(
    input   reset_in /* synthesis ALTERA_ATTRIBUTE = "SUPPRESS_DA_RULE_INTERNAL=R101" */,

    input   clk,
    output  reset_out
);

    // -----------------------------------------------
    // Synchronizer register chain. We cannot reuse the
    // standard synchronizer in this implementation 
    // because our timing constraints are different.
    //
    // Instead of cutting the timing path to the d-input 
    // on the first flop we need to cut the aclr input.
    // 
    // We omit the "preserve" attribute on the final
    // output register, so that the synthesis tool can
    // duplicate it where needed.
    // -----------------------------------------------
    (*preserve*) reg [DEPTH-1:0] altera_reset_synchronizer_int_chain;
    reg altera_reset_synchronizer_int_chain_out;

    generate if (ASYNC_RESET) begin

        // -----------------------------------------------
        // Assert asynchronously, deassert synchronously.
        // -----------------------------------------------
        always @(posedge clk or posedge reset_in) begin
            if (reset_in) begin
                altera_reset_synchronizer_int_chain <= {DEPTH{1'b1}};
                altera_reset_synchronizer_int_chain_out <= 1'b1;
            end
            else begin
                altera_reset_synchronizer_int_chain[DEPTH-2:0] <= altera_reset_synchronizer_int_chain[DEPTH-1:1];
                altera_reset_synchronizer_int_chain[DEPTH-1] <= 0;
                altera_reset_synchronizer_int_chain_out <= altera_reset_synchronizer_int_chain[0];
            end
        end

        assign reset_out = altera_reset_synchronizer_int_chain_out;
     
    end else begin

        // -----------------------------------------------
        // Assert synchronously, deassert synchronously.
        // -----------------------------------------------
        always @(posedge clk) begin
            altera_reset_synchronizer_int_chain[DEPTH-2:0] <= altera_reset_synchronizer_int_chain[DEPTH-1:1];
            altera_reset_synchronizer_int_chain[DEPTH-1] <= reset_in;
            altera_reset_synchronizer_int_chain_out <= altera_reset_synchronizer_int_chain[0];
        end

        assign reset_out = altera_reset_synchronizer_int_chain_out;
 
    end
    endgenerate

endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "VudRjuN0tk1dliq/IZQS+q6A3SwrLYgqCGAOiZv6F7upYp/VWDT/TGkE2+r3VsSMpoY/9177GbiXiuHLiFHjByPXYvWCf2+RVLxekQxp9S/K2P8ezIyFtWg0BRLwe9ztN5krrnwZdjpoQ0u8sXAqllkXKlv7b8JRiMxdE4uGu+2hX7MvV2mRvO7errmCrVl0uXMUjAnriNrHGqd9XmJgpXHjMHklF2UpcodnVU9qRuK7T+hgC7CbS4c3yA59IjYdh69mzQmlbXU1Iq2+8XWcSk3DUntNgZ4AUGs89kYeyVGs00GgA5eivH4D+9Ucqr8c4xjrgX0ClBKh405gWfBqKyLfLmCnPmmAtP4x9rlfj6hc4qcd4NxtuffPnMTfUImc5RBATy0JB+4ZwX42e3hM3A2Xy7gsJiRdk87n30ILqNJhpNeqalkCnb3GlqzExWOAOCZr1Y0EMu+t5txCbRYA9sNzz1AZtgq0lq3ky2RO+wos20nOp2kuohQS+INGRr4bS9E3dgouWjFMRuw87gDokpcATo6dAyq6pqkhVHu+9iOzpFDmUuI+g+Azl4riOxcvm0zb3u0kVcV75TckN5BT5YBPQNsIeSBs/+60vm0bzCM57q2q3E8IQpNIIRLsdypxqZ51uhLLZbqqwB5Ujj+5VOSuVwc6TFOI9jtc7kMJyKXtzYfUSbn4F/TDAoWGwH8+5FF2Xfx+BR9b3enMqI7dMPvCcX49gtrxwjDKDHx2fD3CRIvFj0hU7dIJVaBK9xKilDnmuZ4fKcC6Pvz0GMqM4CrgbflZ2TtN8sCurxC6FLIYtq1348wMez+b3XcbdQc1fiHNt14LHCz40RFwHpvD445SGql3AVwZrVk1FJCpDS0kcAdxxnw7H2a21BnVtHw1Zg3uLbZQzrbenY/720dqxpKyrGRVwdP8uwjrefTsb6XEWa+l5wXGpEd10gJOhepMuxdvyJOdNHt/0qa49IhiI1LSfMhtxdEPdqVESlmbuwRP0wDrLRCbTWmvbBR6ue7w"
`endif