// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// --------------------------------------------------------------------------------
//| Avalon ST Idle Remover 
// --------------------------------------------------------------------------------

`timescale 1ns / 100ps
module altera_avalon_st_idle_remover (

      // Interface: clk
      input              clk,
      input              reset_n,
      // Interface: ST in
      output reg         in_ready,
      input              in_valid,
      input      [7: 0]  in_data,

      // Interface: ST out 
      input              out_ready,
      output reg         out_valid,
      output reg [7: 0]  out_data
);

   // ---------------------------------------------------------------------
   //| Signal Declarations
   // ---------------------------------------------------------------------

   reg  received_esc;
   wire escape_char, idle_char;

   // ---------------------------------------------------------------------
   //| Thingofamagick
   // ---------------------------------------------------------------------

   assign idle_char = (in_data == 8'h4a);
   assign escape_char = (in_data == 8'h4d);

   always @(posedge clk or negedge reset_n) begin
      if (!reset_n) begin
         received_esc <= 0; 
      end else begin
         if (in_valid & in_ready) begin
            if (escape_char & ~received_esc) begin
                 received_esc <= 1;
            end else if (out_valid) begin
                 received_esc <= 0;
            end
         end
      end
   end

   always @* begin
      in_ready = out_ready;
      //out valid when in_valid.  Except when we get idle or escape
      //however, if we have received an escape character, then we are valid
      out_valid = in_valid & ~idle_char & (received_esc | ~escape_char);
      out_data = received_esc ? (in_data ^ 8'h20) : in_data;
   end
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "VudRjuN0tk1dliq/IZQS+q6A3SwrLYgqCGAOiZv6F7upYp/VWDT/TGkE2+r3VsSMpoY/9177GbiXiuHLiFHjByPXYvWCf2+RVLxekQxp9S/K2P8ezIyFtWg0BRLwe9ztN5krrnwZdjpoQ0u8sXAqllkXKlv7b8JRiMxdE4uGu+2hX7MvV2mRvO7errmCrVl0uXMUjAnriNrHGqd9XmJgpXHjMHklF2UpcodnVU9qRuJl4rBfg0riN/xLHWwYjIGdWD9DH5SSCi3lEu3whPFDwHZbzuf/5s+IXzY7Ciyk7XANXJnQSSjD/x2TOVUXgryoIMXpCLqx+U8tBno2kU47Hu7U8um7U+hDpOGr3nXbRVYzK5aV+Ls9q3lIBWRD9ki2KX9sUsoY7en8lEGeFH2npt0ZPcK8VXzJy4XY3Jj5ll8KPb7Bzgtd990QTz9zg7TOEIeHYil+KZ2u/rnf+pIZT7Jc6rEuXeZJLC/7SS8d2FlfO+XiG9/qsPv78N0vpX2vjn3bec78dXPpK7/iPi5A7yNIndV/3RW167cwaYQ2dfPJ0CdcDyy6yOMNjDmDMJiFdX7wijPh8uvuPVdI8KNw1Kc/0Nq9ROz9qAwHj4eea85mCxJAzvhW4w606xje7Do8LzGYR+JiQc3ta0fUYJNFfgkUoQybuvT+dytplOge0EAP6ksmtamwoEP8xGL8FYdyCTHgGBXl6M0i7Lbs/X9khJXt0Wj5xpf9xM/gipdxQasyvdqA4egRX3FJCaZEz/qqnDGQYIDKDxA1lM1z0oz5IzyXI6woOiV2X+jJJDzU2DCbbsrXVtlNFtWOPlvqAkof+T/I/R4UOZQ2OvtVmCUEbXwZ9hKBIBhOBqVWcEsGxIH+XGE54G9Gp1NdhZm4eOTXWtpEDh1Cgc1U3RtXs3yJzX2urN5LlHGpp1qWQ71ZVWSv0ZB7SH3vQMIspNjbx4zLPYn7tqkBkrjEIoXUQmp1SjWWSh+5VzlCNOqCk6qryIzc/Q8BPeb7pfaR8BNhWzub"
`endif