// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module altsource_probe_top
#(
    parameter lpm_type = "altsource_probe",     // required by the coding standard
    parameter lpm_hint = "UNUSED",              // required by the coding standard 

    parameter sld_auto_instance_index = "YES",  // Yes, if the instance index should be automatically assigned.
    parameter sld_instance_index = 0,           // unique identifier for the altsource_probe instance.
    parameter sld_node_info_parameter = 4746752 + sld_instance_index,   // The NODE ID to uniquely identify this node on the hub.  Type ID: 9 Version: 0 Inst: 0 MFG ID 110 -- ***NOTE*** this parameter cannot be called SLD_NODE_INFO or Quartus Standard will think it's an ISSP impl.
    parameter sld_ir_width = 4,                 
                                        
    parameter instance_id = "UNUSED",           // optional name for the instance.
    parameter probe_width = 1,                  // probe port width
    parameter source_width= 1,                  // source port width
    parameter source_initial_value = "0",       // initial source port value
    parameter enable_metastability = "NO"       // yes to add two register
)
(
    input [probe_width - 1 : 0] probe,       // probe inputs
    output [source_width - 1 : 0] source,    // source outputs
    input source_clk,                        // clock of the registers used to metastabilize the source output
    input tri1 source_ena                    // enable of the registers used to metastabilize the source output
);

    altsource_probe #(
        .lpm_type(lpm_type),
        .lpm_hint(lpm_hint),   
        .sld_auto_instance_index(sld_auto_instance_index),
        .sld_instance_index(sld_instance_index),
        .SLD_NODE_INFO(sld_node_info_parameter),
        .sld_ir_width(sld_ir_width),                          
        .instance_id(instance_id),
        .probe_width(probe_width),
        .source_width(source_width),
        .source_initial_value(source_initial_value),
        .enable_metastability(enable_metastability)
    )issp_impl
    (
        .probe(probe),
        .source(source),
        .source_clk(source_clk),
        .source_ena(source_ena)
    );
    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5atRsNqsVtytczkANLDFJWE67z9chmAi87z5bDA+CSDaeiegxHd+TMpAtWvg59OgXSqwjCNaFcco6K+JOT3Pah+RCeX9YtF5xGrT1ve/98Eot2Qw73nvhXl4JK24AP6AnO61l4G93HXndWN+9O27FfBxmgGsl777pPOCYeme0tFGvXE2uJj6tsNFc7ni0HVvEocwQFJWgqAKj0faph8pubAzaa7Op6W0IudTCGajV+J/dN4ZvoI9GORxNw2BR63zIbI8S4Y7HdOWo/qEphK7NLXqFCfbjYMiHCNOTvPHN2w2mzM2jHEzesLubYe9EImpXzIHlqP2MlNI4iqB/aGMx9E2cY3/XAOIT/ukaw3UxAghUi8lvID5rElaq7BtSeYq6DdCKJtBEDSLzY4oV0CpWqjE2kX8wZGqHDfi53ogqSm6F2mgCgZwGbk4zwXT9DzedhTCcgl30lCdGpsBHnmBdVzm/DKVhx7i4MtWhtEYRf16MPy+D9LmezCTzlxvqFiWn7eb/M1KhbPk7KlISSj7stc5SlHlQSO4sSMysvHKutgE8/hDEAAEig27yVhQ4lbGCfsUoQOhBCB1oDrMdJC28rEVRE10Ag2SVJbE9Ks+RZn/Najn7COc0HO3oUS+bjhkseGt5Mv1+xAAhbwXuqrZn9ch/bfvx6tBqP83UjzJwsreZF2RiMpKQuqxuGpH1NoKNz7abCNDMNnoVhvL6twA2zmamreCwBo6+/GSfdhqGjYinh+u9zeYNSwf9giWVByCJQrqrt53cFhwO3dy0jBSWGwwZ5wa4wRwW4UCMPPdHbziCFUBfkqO0L7FRYmegee6gNp05qX4HZXCno2M6DrXE2hp4G9nMIJdBG4rPoPy2kzGOOUfzPXgMbqfDnS2552NwxV0IoEwJ78KwyFtLSRmvxQqZmUEB1z1qu95Zhz3MJsKDeWv5DvVDvv+oUbqikZQOXPu9z978lrFkzQaVQ2JW5IsrUHyn7dGDBF12ZMqiLoVEz0Qrk0jAZEuiQvBySRk"
`endif