	component s10_hps is
		port (
			h2f_rst                   : out   std_logic;                                          -- reset
			h2f_watchdog_rst          : out   std_logic;                                          -- reset_n
			f2h_stm_hwevents          : in    std_logic_vector(42 downto 0)   := (others => 'X'); -- stm_hwevents
			hps_emif_emif_to_hps      : in    std_logic_vector(4095 downto 0) := (others => 'X'); -- emif_to_hps
			hps_emif_hps_to_emif      : out   std_logic_vector(4095 downto 0);                    -- hps_to_emif
			hps_emif_emif_to_gp       : in    std_logic                       := 'X';             -- emif_to_gp
			hps_emif_gp_to_emif       : out   std_logic_vector(1 downto 0);                       -- gp_to_emif
			f2h_axi_clk               : in    std_logic                       := 'X';             -- clk
			f2h_axi_rst_n             : in    std_logic                       := 'X';             -- reset_n
			f2h_AWCACHE               : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awcache
			f2h_ARCACHE               : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arcache
			f2h_AWID                  : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awid
			f2h_AWADDR                : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- awaddr
			f2h_AWLEN                 : in    std_logic_vector(7 downto 0)    := (others => 'X'); -- awlen
			f2h_AWSIZE                : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- awsize
			f2h_AWBURST               : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- awburst
			f2h_AWLOCK                : in    std_logic                       := 'X';             -- awlock
			f2h_AWPROT                : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- awprot
			f2h_AWVALID               : in    std_logic                       := 'X';             -- awvalid
			f2h_AWREADY               : out   std_logic;                                          -- awready
			f2h_AWQOS                 : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awqos
			f2h_WDATA                 : in    std_logic_vector(127 downto 0)  := (others => 'X'); -- wdata
			f2h_WSTRB                 : in    std_logic_vector(15 downto 0)   := (others => 'X'); -- wstrb
			f2h_WLAST                 : in    std_logic                       := 'X';             -- wlast
			f2h_WVALID                : in    std_logic                       := 'X';             -- wvalid
			f2h_WREADY                : out   std_logic;                                          -- wready
			f2h_BID                   : out   std_logic_vector(3 downto 0);                       -- bid
			f2h_BRESP                 : out   std_logic_vector(1 downto 0);                       -- bresp
			f2h_BVALID                : out   std_logic;                                          -- bvalid
			f2h_BREADY                : in    std_logic                       := 'X';             -- bready
			f2h_ARID                  : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arid
			f2h_ARADDR                : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- araddr
			f2h_ARLEN                 : in    std_logic_vector(7 downto 0)    := (others => 'X'); -- arlen
			f2h_ARSIZE                : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- arsize
			f2h_ARBURST               : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- arburst
			f2h_ARLOCK                : in    std_logic                       := 'X';             -- arlock
			f2h_ARPROT                : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- arprot
			f2h_ARVALID               : in    std_logic                       := 'X';             -- arvalid
			f2h_ARREADY               : out   std_logic;                                          -- arready
			f2h_ARQOS                 : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arqos
			f2h_RID                   : out   std_logic_vector(3 downto 0);                       -- rid
			f2h_RDATA                 : out   std_logic_vector(127 downto 0);                     -- rdata
			f2h_RRESP                 : out   std_logic_vector(1 downto 0);                       -- rresp
			f2h_RLAST                 : out   std_logic;                                          -- rlast
			f2h_RVALID                : out   std_logic;                                          -- rvalid
			f2h_RREADY                : in    std_logic                       := 'X';             -- rready
			h2f_lw_axi_clk            : in    std_logic                       := 'X';             -- clk
			h2f_lw_axi_rst_n          : in    std_logic                       := 'X';             -- reset_n
			h2f_lw_AWID               : out   std_logic_vector(3 downto 0);                       -- awid
			h2f_lw_AWADDR             : out   std_logic_vector(20 downto 0);                      -- awaddr
			h2f_lw_AWLEN              : out   std_logic_vector(7 downto 0);                       -- awlen
			h2f_lw_AWSIZE             : out   std_logic_vector(2 downto 0);                       -- awsize
			h2f_lw_AWBURST            : out   std_logic_vector(1 downto 0);                       -- awburst
			h2f_lw_AWLOCK             : out   std_logic;                                          -- awlock
			h2f_lw_AWCACHE            : out   std_logic_vector(3 downto 0);                       -- awcache
			h2f_lw_AWPROT             : out   std_logic_vector(2 downto 0);                       -- awprot
			h2f_lw_AWVALID            : out   std_logic;                                          -- awvalid
			h2f_lw_AWREADY            : in    std_logic                       := 'X';             -- awready
			h2f_lw_WDATA              : out   std_logic_vector(31 downto 0);                      -- wdata
			h2f_lw_WSTRB              : out   std_logic_vector(3 downto 0);                       -- wstrb
			h2f_lw_WLAST              : out   std_logic;                                          -- wlast
			h2f_lw_WVALID             : out   std_logic;                                          -- wvalid
			h2f_lw_WREADY             : in    std_logic                       := 'X';             -- wready
			h2f_lw_BID                : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- bid
			h2f_lw_BRESP              : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- bresp
			h2f_lw_BVALID             : in    std_logic                       := 'X';             -- bvalid
			h2f_lw_BREADY             : out   std_logic;                                          -- bready
			h2f_lw_ARID               : out   std_logic_vector(3 downto 0);                       -- arid
			h2f_lw_ARADDR             : out   std_logic_vector(20 downto 0);                      -- araddr
			h2f_lw_ARLEN              : out   std_logic_vector(7 downto 0);                       -- arlen
			h2f_lw_ARSIZE             : out   std_logic_vector(2 downto 0);                       -- arsize
			h2f_lw_ARBURST            : out   std_logic_vector(1 downto 0);                       -- arburst
			h2f_lw_ARLOCK             : out   std_logic;                                          -- arlock
			h2f_lw_ARCACHE            : out   std_logic_vector(3 downto 0);                       -- arcache
			h2f_lw_ARPROT             : out   std_logic_vector(2 downto 0);                       -- arprot
			h2f_lw_ARVALID            : out   std_logic;                                          -- arvalid
			h2f_lw_ARREADY            : in    std_logic                       := 'X';             -- arready
			h2f_lw_RID                : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- rid
			h2f_lw_RDATA              : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- rdata
			h2f_lw_RRESP              : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- rresp
			h2f_lw_RLAST              : in    std_logic                       := 'X';             -- rlast
			h2f_lw_RVALID             : in    std_logic                       := 'X';             -- rvalid
			h2f_lw_RREADY             : out   std_logic;                                          -- rready
			h2f_axi_clk               : in    std_logic                       := 'X';             -- clk
			h2f_axi_rst_n             : in    std_logic                       := 'X';             -- reset_n
			h2f_AWID                  : out   std_logic_vector(3 downto 0);                       -- awid
			h2f_AWADDR                : out   std_logic_vector(31 downto 0);                      -- awaddr
			h2f_AWLEN                 : out   std_logic_vector(7 downto 0);                       -- awlen
			h2f_AWSIZE                : out   std_logic_vector(2 downto 0);                       -- awsize
			h2f_AWBURST               : out   std_logic_vector(1 downto 0);                       -- awburst
			h2f_AWLOCK                : out   std_logic;                                          -- awlock
			h2f_AWCACHE               : out   std_logic_vector(3 downto 0);                       -- awcache
			h2f_AWPROT                : out   std_logic_vector(2 downto 0);                       -- awprot
			h2f_AWVALID               : out   std_logic;                                          -- awvalid
			h2f_AWREADY               : in    std_logic                       := 'X';             -- awready
			h2f_WDATA                 : out   std_logic_vector(127 downto 0);                     -- wdata
			h2f_WSTRB                 : out   std_logic_vector(15 downto 0);                      -- wstrb
			h2f_WLAST                 : out   std_logic;                                          -- wlast
			h2f_WVALID                : out   std_logic;                                          -- wvalid
			h2f_WREADY                : in    std_logic                       := 'X';             -- wready
			h2f_BID                   : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- bid
			h2f_BRESP                 : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- bresp
			h2f_BVALID                : in    std_logic                       := 'X';             -- bvalid
			h2f_BREADY                : out   std_logic;                                          -- bready
			h2f_ARID                  : out   std_logic_vector(3 downto 0);                       -- arid
			h2f_ARADDR                : out   std_logic_vector(31 downto 0);                      -- araddr
			h2f_ARLEN                 : out   std_logic_vector(7 downto 0);                       -- arlen
			h2f_ARSIZE                : out   std_logic_vector(2 downto 0);                       -- arsize
			h2f_ARBURST               : out   std_logic_vector(1 downto 0);                       -- arburst
			h2f_ARLOCK                : out   std_logic;                                          -- arlock
			h2f_ARCACHE               : out   std_logic_vector(3 downto 0);                       -- arcache
			h2f_ARPROT                : out   std_logic_vector(2 downto 0);                       -- arprot
			h2f_ARVALID               : out   std_logic;                                          -- arvalid
			h2f_ARREADY               : in    std_logic                       := 'X';             -- arready
			h2f_RID                   : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- rid
			h2f_RDATA                 : in    std_logic_vector(127 downto 0)  := (others => 'X'); -- rdata
			h2f_RRESP                 : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- rresp
			h2f_RLAST                 : in    std_logic                       := 'X';             -- rlast
			h2f_RVALID                : in    std_logic                       := 'X';             -- rvalid
			h2f_RREADY                : out   std_logic;                                          -- rready
			f2sdram0_clk              : in    std_logic                       := 'X';             -- clk
			f2sdram0_rst_n            : in    std_logic                       := 'X';             -- reset_n
			f2sdram0_ARADDR           : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- araddr
			f2sdram0_ARBURST          : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- arburst
			f2sdram0_ARCACHE          : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arcache
			f2sdram0_ARID             : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arid
			f2sdram0_ARLEN            : in    std_logic_vector(7 downto 0)    := (others => 'X'); -- arlen
			f2sdram0_ARLOCK           : in    std_logic                       := 'X';             -- arlock
			f2sdram0_ARPROT           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- arprot
			f2sdram0_ARQOS            : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arqos
			f2sdram0_ARREADY          : out   std_logic;                                          -- arready
			f2sdram0_ARSIZE           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- arsize
			f2sdram0_ARVALID          : in    std_logic                       := 'X';             -- arvalid
			f2sdram0_AWADDR           : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- awaddr
			f2sdram0_AWBURST          : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- awburst
			f2sdram0_AWCACHE          : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awcache
			f2sdram0_AWID             : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awid
			f2sdram0_AWLEN            : in    std_logic_vector(7 downto 0)    := (others => 'X'); -- awlen
			f2sdram0_AWLOCK           : in    std_logic                       := 'X';             -- awlock
			f2sdram0_AWPROT           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- awprot
			f2sdram0_AWQOS            : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awqos
			f2sdram0_AWREADY          : out   std_logic;                                          -- awready
			f2sdram0_AWSIZE           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- awsize
			f2sdram0_AWVALID          : in    std_logic                       := 'X';             -- awvalid
			f2sdram0_WDATA            : in    std_logic_vector(127 downto 0)  := (others => 'X'); -- wdata
			f2sdram0_WLAST            : in    std_logic                       := 'X';             -- wlast
			f2sdram0_WREADY           : out   std_logic;                                          -- wready
			f2sdram0_WSTRB            : in    std_logic_vector(15 downto 0)   := (others => 'X'); -- wstrb
			f2sdram0_WVALID           : in    std_logic                       := 'X';             -- wvalid
			f2sdram0_BID              : out   std_logic_vector(3 downto 0);                       -- bid
			f2sdram0_BREADY           : in    std_logic                       := 'X';             -- bready
			f2sdram0_BRESP            : out   std_logic_vector(1 downto 0);                       -- bresp
			f2sdram0_BVALID           : out   std_logic;                                          -- bvalid
			f2sdram0_RDATA            : out   std_logic_vector(127 downto 0);                     -- rdata
			f2sdram0_RID              : out   std_logic_vector(3 downto 0);                       -- rid
			f2sdram0_RLAST            : out   std_logic;                                          -- rlast
			f2sdram0_RREADY           : in    std_logic                       := 'X';             -- rready
			f2sdram0_RRESP            : out   std_logic_vector(1 downto 0);                       -- rresp
			f2sdram0_RVALID           : out   std_logic;                                          -- rvalid
			f2sdram1_clk              : in    std_logic                       := 'X';             -- clk
			f2sdram1_rst_n            : in    std_logic                       := 'X';             -- reset_n
			f2sdram1_ARADDR           : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- araddr
			f2sdram1_ARBURST          : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- arburst
			f2sdram1_ARCACHE          : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arcache
			f2sdram1_ARID             : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arid
			f2sdram1_ARLEN            : in    std_logic_vector(7 downto 0)    := (others => 'X'); -- arlen
			f2sdram1_ARLOCK           : in    std_logic                       := 'X';             -- arlock
			f2sdram1_ARPROT           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- arprot
			f2sdram1_ARQOS            : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arqos
			f2sdram1_ARREADY          : out   std_logic;                                          -- arready
			f2sdram1_ARSIZE           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- arsize
			f2sdram1_ARVALID          : in    std_logic                       := 'X';             -- arvalid
			f2sdram1_AWADDR           : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- awaddr
			f2sdram1_AWBURST          : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- awburst
			f2sdram1_AWCACHE          : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awcache
			f2sdram1_AWID             : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awid
			f2sdram1_AWLEN            : in    std_logic_vector(7 downto 0)    := (others => 'X'); -- awlen
			f2sdram1_AWLOCK           : in    std_logic                       := 'X';             -- awlock
			f2sdram1_AWPROT           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- awprot
			f2sdram1_AWQOS            : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awqos
			f2sdram1_AWREADY          : out   std_logic;                                          -- awready
			f2sdram1_AWSIZE           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- awsize
			f2sdram1_AWVALID          : in    std_logic                       := 'X';             -- awvalid
			f2sdram1_WDATA            : in    std_logic_vector(127 downto 0)  := (others => 'X'); -- wdata
			f2sdram1_WLAST            : in    std_logic                       := 'X';             -- wlast
			f2sdram1_WREADY           : out   std_logic;                                          -- wready
			f2sdram1_WSTRB            : in    std_logic_vector(15 downto 0)   := (others => 'X'); -- wstrb
			f2sdram1_WVALID           : in    std_logic                       := 'X';             -- wvalid
			f2sdram1_BID              : out   std_logic_vector(3 downto 0);                       -- bid
			f2sdram1_BREADY           : in    std_logic                       := 'X';             -- bready
			f2sdram1_BRESP            : out   std_logic_vector(1 downto 0);                       -- bresp
			f2sdram1_BVALID           : out   std_logic;                                          -- bvalid
			f2sdram1_RDATA            : out   std_logic_vector(127 downto 0);                     -- rdata
			f2sdram1_RID              : out   std_logic_vector(3 downto 0);                       -- rid
			f2sdram1_RLAST            : out   std_logic;                                          -- rlast
			f2sdram1_RREADY           : in    std_logic                       := 'X';             -- rready
			f2sdram1_RRESP            : out   std_logic_vector(1 downto 0);                       -- rresp
			f2sdram1_RVALID           : out   std_logic;                                          -- rvalid
			f2sdram2_clk              : in    std_logic                       := 'X';             -- clk
			f2sdram2_rst_n            : in    std_logic                       := 'X';             -- reset_n
			f2sdram2_ARADDR           : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- araddr
			f2sdram2_ARBURST          : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- arburst
			f2sdram2_ARCACHE          : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arcache
			f2sdram2_ARID             : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arid
			f2sdram2_ARLEN            : in    std_logic_vector(7 downto 0)    := (others => 'X'); -- arlen
			f2sdram2_ARLOCK           : in    std_logic                       := 'X';             -- arlock
			f2sdram2_ARPROT           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- arprot
			f2sdram2_ARQOS            : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- arqos
			f2sdram2_ARREADY          : out   std_logic;                                          -- arready
			f2sdram2_ARSIZE           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- arsize
			f2sdram2_ARVALID          : in    std_logic                       := 'X';             -- arvalid
			f2sdram2_AWADDR           : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- awaddr
			f2sdram2_AWBURST          : in    std_logic_vector(1 downto 0)    := (others => 'X'); -- awburst
			f2sdram2_AWCACHE          : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awcache
			f2sdram2_AWID             : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awid
			f2sdram2_AWLEN            : in    std_logic_vector(7 downto 0)    := (others => 'X'); -- awlen
			f2sdram2_AWLOCK           : in    std_logic                       := 'X';             -- awlock
			f2sdram2_AWPROT           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- awprot
			f2sdram2_AWQOS            : in    std_logic_vector(3 downto 0)    := (others => 'X'); -- awqos
			f2sdram2_AWREADY          : out   std_logic;                                          -- awready
			f2sdram2_AWSIZE           : in    std_logic_vector(2 downto 0)    := (others => 'X'); -- awsize
			f2sdram2_AWVALID          : in    std_logic                       := 'X';             -- awvalid
			f2sdram2_WDATA            : in    std_logic_vector(127 downto 0)  := (others => 'X'); -- wdata
			f2sdram2_WLAST            : in    std_logic                       := 'X';             -- wlast
			f2sdram2_WREADY           : out   std_logic;                                          -- wready
			f2sdram2_WSTRB            : in    std_logic_vector(15 downto 0)   := (others => 'X'); -- wstrb
			f2sdram2_WVALID           : in    std_logic                       := 'X';             -- wvalid
			f2sdram2_BID              : out   std_logic_vector(3 downto 0);                       -- bid
			f2sdram2_BREADY           : in    std_logic                       := 'X';             -- bready
			f2sdram2_BRESP            : out   std_logic_vector(1 downto 0);                       -- bresp
			f2sdram2_BVALID           : out   std_logic;                                          -- bvalid
			f2sdram2_RDATA            : out   std_logic_vector(127 downto 0);                     -- rdata
			f2sdram2_RID              : out   std_logic_vector(3 downto 0);                       -- rid
			f2sdram2_RLAST            : out   std_logic;                                          -- rlast
			f2sdram2_RREADY           : in    std_logic                       := 'X';             -- rready
			f2sdram2_RRESP            : out   std_logic_vector(1 downto 0);                       -- rresp
			f2sdram2_RVALID           : out   std_logic;                                          -- rvalid
			f2h_irq_p0                : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- irq
			f2h_irq_p1                : in    std_logic_vector(31 downto 0)   := (others => 'X'); -- irq
			emac_ptp_ref_clk          : in    std_logic                       := 'X';             -- clk
			emac1_phy_mac_speed_o     : out   std_logic_vector(1 downto 0);                       -- phy_mac_speed_o
			emac1_phy_txd_o           : out   std_logic_vector(7 downto 0);                       -- phy_txd_o
			emac1_phy_txen_o          : out   std_logic;                                          -- phy_txen_o
			emac1_phy_txer_o          : out   std_logic;                                          -- phy_txer_o
			emac1_phy_rxdv_i          : in    std_logic                       := 'X';             -- phy_rxdv_i
			emac1_phy_rxer_i          : in    std_logic                       := 'X';             -- phy_rxer_i
			emac1_phy_rxd_i           : in    std_logic_vector(7 downto 0)    := (others => 'X'); -- phy_rxd_i
			emac1_phy_col_i           : in    std_logic                       := 'X';             -- phy_col_i
			emac1_phy_crs_i           : in    std_logic                       := 'X';             -- phy_crs_i
			emac1_gmii_mdo_o          : out   std_logic;                                          -- gmii_mdo_o
			emac1_gmii_mdo_o_e        : out   std_logic;                                          -- gmii_mdo_o_e
			emac1_gmii_mdi_i          : in    std_logic                       := 'X';             -- gmii_mdi_i
			emac1_ptp_pps_o           : out   std_logic;                                          -- ptp_pps_o
			emac1_ptp_aux_ts_trig_i   : in    std_logic                       := 'X';             -- ptp_aux_ts_trig_i
			emac1_ptp_tstmp_data      : out   std_logic;                                          -- ptp_tstmp_data
			emac1_ptp_tstmp_en        : out   std_logic;                                          -- ptp_tstmp_en
			emac1_gmii_mdc_o          : out   std_logic;                                          -- clk
			emac1_clk_rx_i            : in    std_logic                       := 'X';             -- clk
			emac1_clk_tx_i            : in    std_logic                       := 'X';             -- clk
			emac1_phy_txclk_o         : out   std_logic;                                          -- clk
			emac1_rst_clk_tx_n_o      : out   std_logic;                                          -- reset_n
			emac1_rst_clk_rx_n_o      : out   std_logic;                                          -- reset_n
			hps_io_phery_emac0_TX_CLK : out   std_logic;                                          -- hps_io_phery_emac0_TX_CLK
			hps_io_phery_emac0_TXD0   : out   std_logic;                                          -- hps_io_phery_emac0_TXD0
			hps_io_phery_emac0_TXD1   : out   std_logic;                                          -- hps_io_phery_emac0_TXD1
			hps_io_phery_emac0_TXD2   : out   std_logic;                                          -- hps_io_phery_emac0_TXD2
			hps_io_phery_emac0_TXD3   : out   std_logic;                                          -- hps_io_phery_emac0_TXD3
			hps_io_phery_emac0_RX_CTL : in    std_logic                       := 'X';             -- hps_io_phery_emac0_RX_CTL
			hps_io_phery_emac0_TX_CTL : out   std_logic;                                          -- hps_io_phery_emac0_TX_CTL
			hps_io_phery_emac0_RX_CLK : in    std_logic                       := 'X';             -- hps_io_phery_emac0_RX_CLK
			hps_io_phery_emac0_RXD0   : in    std_logic                       := 'X';             -- hps_io_phery_emac0_RXD0
			hps_io_phery_emac0_RXD1   : in    std_logic                       := 'X';             -- hps_io_phery_emac0_RXD1
			hps_io_phery_emac0_RXD2   : in    std_logic                       := 'X';             -- hps_io_phery_emac0_RXD2
			hps_io_phery_emac0_RXD3   : in    std_logic                       := 'X';             -- hps_io_phery_emac0_RXD3
			hps_io_phery_emac0_MDIO   : inout std_logic                       := 'X';             -- hps_io_phery_emac0_MDIO
			hps_io_phery_emac0_MDC    : out   std_logic;                                          -- hps_io_phery_emac0_MDC
			hps_io_phery_sdmmc_CMD    : inout std_logic                       := 'X';             -- hps_io_phery_sdmmc_CMD
			hps_io_phery_sdmmc_D0     : inout std_logic                       := 'X';             -- hps_io_phery_sdmmc_D0
			hps_io_phery_sdmmc_D1     : inout std_logic                       := 'X';             -- hps_io_phery_sdmmc_D1
			hps_io_phery_sdmmc_D2     : inout std_logic                       := 'X';             -- hps_io_phery_sdmmc_D2
			hps_io_phery_sdmmc_D3     : inout std_logic                       := 'X';             -- hps_io_phery_sdmmc_D3
			hps_io_phery_sdmmc_CCLK   : out   std_logic;                                          -- hps_io_phery_sdmmc_CCLK
			hps_io_phery_usb0_DATA0   : inout std_logic                       := 'X';             -- hps_io_phery_usb0_DATA0
			hps_io_phery_usb0_DATA1   : inout std_logic                       := 'X';             -- hps_io_phery_usb0_DATA1
			hps_io_phery_usb0_DATA2   : inout std_logic                       := 'X';             -- hps_io_phery_usb0_DATA2
			hps_io_phery_usb0_DATA3   : inout std_logic                       := 'X';             -- hps_io_phery_usb0_DATA3
			hps_io_phery_usb0_DATA4   : inout std_logic                       := 'X';             -- hps_io_phery_usb0_DATA4
			hps_io_phery_usb0_DATA5   : inout std_logic                       := 'X';             -- hps_io_phery_usb0_DATA5
			hps_io_phery_usb0_DATA6   : inout std_logic                       := 'X';             -- hps_io_phery_usb0_DATA6
			hps_io_phery_usb0_DATA7   : inout std_logic                       := 'X';             -- hps_io_phery_usb0_DATA7
			hps_io_phery_usb0_CLK     : in    std_logic                       := 'X';             -- hps_io_phery_usb0_CLK
			hps_io_phery_usb0_STP     : out   std_logic;                                          -- hps_io_phery_usb0_STP
			hps_io_phery_usb0_DIR     : in    std_logic                       := 'X';             -- hps_io_phery_usb0_DIR
			hps_io_phery_usb0_NXT     : in    std_logic                       := 'X';             -- hps_io_phery_usb0_NXT
			hps_io_phery_uart0_RX     : in    std_logic                       := 'X';             -- hps_io_phery_uart0_RX
			hps_io_phery_uart0_TX     : out   std_logic;                                          -- hps_io_phery_uart0_TX
			hps_io_phery_uart0_CTS_N  : in    std_logic                       := 'X';             -- hps_io_phery_uart0_CTS_N
			hps_io_phery_uart0_RTS_N  : out   std_logic;                                          -- hps_io_phery_uart0_RTS_N
			hps_io_phery_i2c1_SDA     : inout std_logic                       := 'X';             -- hps_io_phery_i2c1_SDA
			hps_io_phery_i2c1_SCL     : inout std_logic                       := 'X';             -- hps_io_phery_i2c1_SCL
			hps_io_hps_ocs_clk        : in    std_logic                       := 'X';             -- hps_io_hps_ocs_clk
			hps_io_gpio_gpio1_io18    : inout std_logic                       := 'X';             -- hps_io_gpio_gpio1_io18
			hps_io_gpio_gpio1_io19    : inout std_logic                       := 'X'              -- hps_io_gpio_gpio1_io19
		);
	end component s10_hps;

	u0 : component s10_hps
		port map (
			h2f_rst                   => CONNECTED_TO_h2f_rst,                   --          h2f_reset.reset
			h2f_watchdog_rst          => CONNECTED_TO_h2f_watchdog_rst,          --   h2f_watchdog_rst.reset_n
			f2h_stm_hwevents          => CONNECTED_TO_f2h_stm_hwevents,          --  f2h_stm_hw_events.stm_hwevents
			hps_emif_emif_to_hps      => CONNECTED_TO_hps_emif_emif_to_hps,      --           hps_emif.emif_to_hps
			hps_emif_hps_to_emif      => CONNECTED_TO_hps_emif_hps_to_emif,      --                   .hps_to_emif
			hps_emif_emif_to_gp       => CONNECTED_TO_hps_emif_emif_to_gp,       --                   .emif_to_gp
			hps_emif_gp_to_emif       => CONNECTED_TO_hps_emif_gp_to_emif,       --                   .gp_to_emif
			f2h_axi_clk               => CONNECTED_TO_f2h_axi_clk,               --      f2h_axi_clock.clk
			f2h_axi_rst_n             => CONNECTED_TO_f2h_axi_rst_n,             --      f2h_axi_reset.reset_n
			f2h_AWCACHE               => CONNECTED_TO_f2h_AWCACHE,               --      f2h_axi_slave.awcache
			f2h_ARCACHE               => CONNECTED_TO_f2h_ARCACHE,               --                   .arcache
			f2h_AWID                  => CONNECTED_TO_f2h_AWID,                  --                   .awid
			f2h_AWADDR                => CONNECTED_TO_f2h_AWADDR,                --                   .awaddr
			f2h_AWLEN                 => CONNECTED_TO_f2h_AWLEN,                 --                   .awlen
			f2h_AWSIZE                => CONNECTED_TO_f2h_AWSIZE,                --                   .awsize
			f2h_AWBURST               => CONNECTED_TO_f2h_AWBURST,               --                   .awburst
			f2h_AWLOCK                => CONNECTED_TO_f2h_AWLOCK,                --                   .awlock
			f2h_AWPROT                => CONNECTED_TO_f2h_AWPROT,                --                   .awprot
			f2h_AWVALID               => CONNECTED_TO_f2h_AWVALID,               --                   .awvalid
			f2h_AWREADY               => CONNECTED_TO_f2h_AWREADY,               --                   .awready
			f2h_AWQOS                 => CONNECTED_TO_f2h_AWQOS,                 --                   .awqos
			f2h_WDATA                 => CONNECTED_TO_f2h_WDATA,                 --                   .wdata
			f2h_WSTRB                 => CONNECTED_TO_f2h_WSTRB,                 --                   .wstrb
			f2h_WLAST                 => CONNECTED_TO_f2h_WLAST,                 --                   .wlast
			f2h_WVALID                => CONNECTED_TO_f2h_WVALID,                --                   .wvalid
			f2h_WREADY                => CONNECTED_TO_f2h_WREADY,                --                   .wready
			f2h_BID                   => CONNECTED_TO_f2h_BID,                   --                   .bid
			f2h_BRESP                 => CONNECTED_TO_f2h_BRESP,                 --                   .bresp
			f2h_BVALID                => CONNECTED_TO_f2h_BVALID,                --                   .bvalid
			f2h_BREADY                => CONNECTED_TO_f2h_BREADY,                --                   .bready
			f2h_ARID                  => CONNECTED_TO_f2h_ARID,                  --                   .arid
			f2h_ARADDR                => CONNECTED_TO_f2h_ARADDR,                --                   .araddr
			f2h_ARLEN                 => CONNECTED_TO_f2h_ARLEN,                 --                   .arlen
			f2h_ARSIZE                => CONNECTED_TO_f2h_ARSIZE,                --                   .arsize
			f2h_ARBURST               => CONNECTED_TO_f2h_ARBURST,               --                   .arburst
			f2h_ARLOCK                => CONNECTED_TO_f2h_ARLOCK,                --                   .arlock
			f2h_ARPROT                => CONNECTED_TO_f2h_ARPROT,                --                   .arprot
			f2h_ARVALID               => CONNECTED_TO_f2h_ARVALID,               --                   .arvalid
			f2h_ARREADY               => CONNECTED_TO_f2h_ARREADY,               --                   .arready
			f2h_ARQOS                 => CONNECTED_TO_f2h_ARQOS,                 --                   .arqos
			f2h_RID                   => CONNECTED_TO_f2h_RID,                   --                   .rid
			f2h_RDATA                 => CONNECTED_TO_f2h_RDATA,                 --                   .rdata
			f2h_RRESP                 => CONNECTED_TO_f2h_RRESP,                 --                   .rresp
			f2h_RLAST                 => CONNECTED_TO_f2h_RLAST,                 --                   .rlast
			f2h_RVALID                => CONNECTED_TO_f2h_RVALID,                --                   .rvalid
			f2h_RREADY                => CONNECTED_TO_f2h_RREADY,                --                   .rready
			h2f_lw_axi_clk            => CONNECTED_TO_h2f_lw_axi_clk,            --   h2f_lw_axi_clock.clk
			h2f_lw_axi_rst_n          => CONNECTED_TO_h2f_lw_axi_rst_n,          --   h2f_lw_axi_reset.reset_n
			h2f_lw_AWID               => CONNECTED_TO_h2f_lw_AWID,               --  h2f_lw_axi_master.awid
			h2f_lw_AWADDR             => CONNECTED_TO_h2f_lw_AWADDR,             --                   .awaddr
			h2f_lw_AWLEN              => CONNECTED_TO_h2f_lw_AWLEN,              --                   .awlen
			h2f_lw_AWSIZE             => CONNECTED_TO_h2f_lw_AWSIZE,             --                   .awsize
			h2f_lw_AWBURST            => CONNECTED_TO_h2f_lw_AWBURST,            --                   .awburst
			h2f_lw_AWLOCK             => CONNECTED_TO_h2f_lw_AWLOCK,             --                   .awlock
			h2f_lw_AWCACHE            => CONNECTED_TO_h2f_lw_AWCACHE,            --                   .awcache
			h2f_lw_AWPROT             => CONNECTED_TO_h2f_lw_AWPROT,             --                   .awprot
			h2f_lw_AWVALID            => CONNECTED_TO_h2f_lw_AWVALID,            --                   .awvalid
			h2f_lw_AWREADY            => CONNECTED_TO_h2f_lw_AWREADY,            --                   .awready
			h2f_lw_WDATA              => CONNECTED_TO_h2f_lw_WDATA,              --                   .wdata
			h2f_lw_WSTRB              => CONNECTED_TO_h2f_lw_WSTRB,              --                   .wstrb
			h2f_lw_WLAST              => CONNECTED_TO_h2f_lw_WLAST,              --                   .wlast
			h2f_lw_WVALID             => CONNECTED_TO_h2f_lw_WVALID,             --                   .wvalid
			h2f_lw_WREADY             => CONNECTED_TO_h2f_lw_WREADY,             --                   .wready
			h2f_lw_BID                => CONNECTED_TO_h2f_lw_BID,                --                   .bid
			h2f_lw_BRESP              => CONNECTED_TO_h2f_lw_BRESP,              --                   .bresp
			h2f_lw_BVALID             => CONNECTED_TO_h2f_lw_BVALID,             --                   .bvalid
			h2f_lw_BREADY             => CONNECTED_TO_h2f_lw_BREADY,             --                   .bready
			h2f_lw_ARID               => CONNECTED_TO_h2f_lw_ARID,               --                   .arid
			h2f_lw_ARADDR             => CONNECTED_TO_h2f_lw_ARADDR,             --                   .araddr
			h2f_lw_ARLEN              => CONNECTED_TO_h2f_lw_ARLEN,              --                   .arlen
			h2f_lw_ARSIZE             => CONNECTED_TO_h2f_lw_ARSIZE,             --                   .arsize
			h2f_lw_ARBURST            => CONNECTED_TO_h2f_lw_ARBURST,            --                   .arburst
			h2f_lw_ARLOCK             => CONNECTED_TO_h2f_lw_ARLOCK,             --                   .arlock
			h2f_lw_ARCACHE            => CONNECTED_TO_h2f_lw_ARCACHE,            --                   .arcache
			h2f_lw_ARPROT             => CONNECTED_TO_h2f_lw_ARPROT,             --                   .arprot
			h2f_lw_ARVALID            => CONNECTED_TO_h2f_lw_ARVALID,            --                   .arvalid
			h2f_lw_ARREADY            => CONNECTED_TO_h2f_lw_ARREADY,            --                   .arready
			h2f_lw_RID                => CONNECTED_TO_h2f_lw_RID,                --                   .rid
			h2f_lw_RDATA              => CONNECTED_TO_h2f_lw_RDATA,              --                   .rdata
			h2f_lw_RRESP              => CONNECTED_TO_h2f_lw_RRESP,              --                   .rresp
			h2f_lw_RLAST              => CONNECTED_TO_h2f_lw_RLAST,              --                   .rlast
			h2f_lw_RVALID             => CONNECTED_TO_h2f_lw_RVALID,             --                   .rvalid
			h2f_lw_RREADY             => CONNECTED_TO_h2f_lw_RREADY,             --                   .rready
			h2f_axi_clk               => CONNECTED_TO_h2f_axi_clk,               --      h2f_axi_clock.clk
			h2f_axi_rst_n             => CONNECTED_TO_h2f_axi_rst_n,             --      h2f_axi_reset.reset_n
			h2f_AWID                  => CONNECTED_TO_h2f_AWID,                  --     h2f_axi_master.awid
			h2f_AWADDR                => CONNECTED_TO_h2f_AWADDR,                --                   .awaddr
			h2f_AWLEN                 => CONNECTED_TO_h2f_AWLEN,                 --                   .awlen
			h2f_AWSIZE                => CONNECTED_TO_h2f_AWSIZE,                --                   .awsize
			h2f_AWBURST               => CONNECTED_TO_h2f_AWBURST,               --                   .awburst
			h2f_AWLOCK                => CONNECTED_TO_h2f_AWLOCK,                --                   .awlock
			h2f_AWCACHE               => CONNECTED_TO_h2f_AWCACHE,               --                   .awcache
			h2f_AWPROT                => CONNECTED_TO_h2f_AWPROT,                --                   .awprot
			h2f_AWVALID               => CONNECTED_TO_h2f_AWVALID,               --                   .awvalid
			h2f_AWREADY               => CONNECTED_TO_h2f_AWREADY,               --                   .awready
			h2f_WDATA                 => CONNECTED_TO_h2f_WDATA,                 --                   .wdata
			h2f_WSTRB                 => CONNECTED_TO_h2f_WSTRB,                 --                   .wstrb
			h2f_WLAST                 => CONNECTED_TO_h2f_WLAST,                 --                   .wlast
			h2f_WVALID                => CONNECTED_TO_h2f_WVALID,                --                   .wvalid
			h2f_WREADY                => CONNECTED_TO_h2f_WREADY,                --                   .wready
			h2f_BID                   => CONNECTED_TO_h2f_BID,                   --                   .bid
			h2f_BRESP                 => CONNECTED_TO_h2f_BRESP,                 --                   .bresp
			h2f_BVALID                => CONNECTED_TO_h2f_BVALID,                --                   .bvalid
			h2f_BREADY                => CONNECTED_TO_h2f_BREADY,                --                   .bready
			h2f_ARID                  => CONNECTED_TO_h2f_ARID,                  --                   .arid
			h2f_ARADDR                => CONNECTED_TO_h2f_ARADDR,                --                   .araddr
			h2f_ARLEN                 => CONNECTED_TO_h2f_ARLEN,                 --                   .arlen
			h2f_ARSIZE                => CONNECTED_TO_h2f_ARSIZE,                --                   .arsize
			h2f_ARBURST               => CONNECTED_TO_h2f_ARBURST,               --                   .arburst
			h2f_ARLOCK                => CONNECTED_TO_h2f_ARLOCK,                --                   .arlock
			h2f_ARCACHE               => CONNECTED_TO_h2f_ARCACHE,               --                   .arcache
			h2f_ARPROT                => CONNECTED_TO_h2f_ARPROT,                --                   .arprot
			h2f_ARVALID               => CONNECTED_TO_h2f_ARVALID,               --                   .arvalid
			h2f_ARREADY               => CONNECTED_TO_h2f_ARREADY,               --                   .arready
			h2f_RID                   => CONNECTED_TO_h2f_RID,                   --                   .rid
			h2f_RDATA                 => CONNECTED_TO_h2f_RDATA,                 --                   .rdata
			h2f_RRESP                 => CONNECTED_TO_h2f_RRESP,                 --                   .rresp
			h2f_RLAST                 => CONNECTED_TO_h2f_RLAST,                 --                   .rlast
			h2f_RVALID                => CONNECTED_TO_h2f_RVALID,                --                   .rvalid
			h2f_RREADY                => CONNECTED_TO_h2f_RREADY,                --                   .rready
			f2sdram0_clk              => CONNECTED_TO_f2sdram0_clk,              --     f2sdram0_clock.clk
			f2sdram0_rst_n            => CONNECTED_TO_f2sdram0_rst_n,            --     f2sdram0_reset.reset_n
			f2sdram0_ARADDR           => CONNECTED_TO_f2sdram0_ARADDR,           --      f2sdram0_data.araddr
			f2sdram0_ARBURST          => CONNECTED_TO_f2sdram0_ARBURST,          --                   .arburst
			f2sdram0_ARCACHE          => CONNECTED_TO_f2sdram0_ARCACHE,          --                   .arcache
			f2sdram0_ARID             => CONNECTED_TO_f2sdram0_ARID,             --                   .arid
			f2sdram0_ARLEN            => CONNECTED_TO_f2sdram0_ARLEN,            --                   .arlen
			f2sdram0_ARLOCK           => CONNECTED_TO_f2sdram0_ARLOCK,           --                   .arlock
			f2sdram0_ARPROT           => CONNECTED_TO_f2sdram0_ARPROT,           --                   .arprot
			f2sdram0_ARQOS            => CONNECTED_TO_f2sdram0_ARQOS,            --                   .arqos
			f2sdram0_ARREADY          => CONNECTED_TO_f2sdram0_ARREADY,          --                   .arready
			f2sdram0_ARSIZE           => CONNECTED_TO_f2sdram0_ARSIZE,           --                   .arsize
			f2sdram0_ARVALID          => CONNECTED_TO_f2sdram0_ARVALID,          --                   .arvalid
			f2sdram0_AWADDR           => CONNECTED_TO_f2sdram0_AWADDR,           --                   .awaddr
			f2sdram0_AWBURST          => CONNECTED_TO_f2sdram0_AWBURST,          --                   .awburst
			f2sdram0_AWCACHE          => CONNECTED_TO_f2sdram0_AWCACHE,          --                   .awcache
			f2sdram0_AWID             => CONNECTED_TO_f2sdram0_AWID,             --                   .awid
			f2sdram0_AWLEN            => CONNECTED_TO_f2sdram0_AWLEN,            --                   .awlen
			f2sdram0_AWLOCK           => CONNECTED_TO_f2sdram0_AWLOCK,           --                   .awlock
			f2sdram0_AWPROT           => CONNECTED_TO_f2sdram0_AWPROT,           --                   .awprot
			f2sdram0_AWQOS            => CONNECTED_TO_f2sdram0_AWQOS,            --                   .awqos
			f2sdram0_AWREADY          => CONNECTED_TO_f2sdram0_AWREADY,          --                   .awready
			f2sdram0_AWSIZE           => CONNECTED_TO_f2sdram0_AWSIZE,           --                   .awsize
			f2sdram0_AWVALID          => CONNECTED_TO_f2sdram0_AWVALID,          --                   .awvalid
			f2sdram0_WDATA            => CONNECTED_TO_f2sdram0_WDATA,            --                   .wdata
			f2sdram0_WLAST            => CONNECTED_TO_f2sdram0_WLAST,            --                   .wlast
			f2sdram0_WREADY           => CONNECTED_TO_f2sdram0_WREADY,           --                   .wready
			f2sdram0_WSTRB            => CONNECTED_TO_f2sdram0_WSTRB,            --                   .wstrb
			f2sdram0_WVALID           => CONNECTED_TO_f2sdram0_WVALID,           --                   .wvalid
			f2sdram0_BID              => CONNECTED_TO_f2sdram0_BID,              --                   .bid
			f2sdram0_BREADY           => CONNECTED_TO_f2sdram0_BREADY,           --                   .bready
			f2sdram0_BRESP            => CONNECTED_TO_f2sdram0_BRESP,            --                   .bresp
			f2sdram0_BVALID           => CONNECTED_TO_f2sdram0_BVALID,           --                   .bvalid
			f2sdram0_RDATA            => CONNECTED_TO_f2sdram0_RDATA,            --                   .rdata
			f2sdram0_RID              => CONNECTED_TO_f2sdram0_RID,              --                   .rid
			f2sdram0_RLAST            => CONNECTED_TO_f2sdram0_RLAST,            --                   .rlast
			f2sdram0_RREADY           => CONNECTED_TO_f2sdram0_RREADY,           --                   .rready
			f2sdram0_RRESP            => CONNECTED_TO_f2sdram0_RRESP,            --                   .rresp
			f2sdram0_RVALID           => CONNECTED_TO_f2sdram0_RVALID,           --                   .rvalid
			f2sdram1_clk              => CONNECTED_TO_f2sdram1_clk,              --     f2sdram1_clock.clk
			f2sdram1_rst_n            => CONNECTED_TO_f2sdram1_rst_n,            --     f2sdram1_reset.reset_n
			f2sdram1_ARADDR           => CONNECTED_TO_f2sdram1_ARADDR,           --      f2sdram1_data.araddr
			f2sdram1_ARBURST          => CONNECTED_TO_f2sdram1_ARBURST,          --                   .arburst
			f2sdram1_ARCACHE          => CONNECTED_TO_f2sdram1_ARCACHE,          --                   .arcache
			f2sdram1_ARID             => CONNECTED_TO_f2sdram1_ARID,             --                   .arid
			f2sdram1_ARLEN            => CONNECTED_TO_f2sdram1_ARLEN,            --                   .arlen
			f2sdram1_ARLOCK           => CONNECTED_TO_f2sdram1_ARLOCK,           --                   .arlock
			f2sdram1_ARPROT           => CONNECTED_TO_f2sdram1_ARPROT,           --                   .arprot
			f2sdram1_ARQOS            => CONNECTED_TO_f2sdram1_ARQOS,            --                   .arqos
			f2sdram1_ARREADY          => CONNECTED_TO_f2sdram1_ARREADY,          --                   .arready
			f2sdram1_ARSIZE           => CONNECTED_TO_f2sdram1_ARSIZE,           --                   .arsize
			f2sdram1_ARVALID          => CONNECTED_TO_f2sdram1_ARVALID,          --                   .arvalid
			f2sdram1_AWADDR           => CONNECTED_TO_f2sdram1_AWADDR,           --                   .awaddr
			f2sdram1_AWBURST          => CONNECTED_TO_f2sdram1_AWBURST,          --                   .awburst
			f2sdram1_AWCACHE          => CONNECTED_TO_f2sdram1_AWCACHE,          --                   .awcache
			f2sdram1_AWID             => CONNECTED_TO_f2sdram1_AWID,             --                   .awid
			f2sdram1_AWLEN            => CONNECTED_TO_f2sdram1_AWLEN,            --                   .awlen
			f2sdram1_AWLOCK           => CONNECTED_TO_f2sdram1_AWLOCK,           --                   .awlock
			f2sdram1_AWPROT           => CONNECTED_TO_f2sdram1_AWPROT,           --                   .awprot
			f2sdram1_AWQOS            => CONNECTED_TO_f2sdram1_AWQOS,            --                   .awqos
			f2sdram1_AWREADY          => CONNECTED_TO_f2sdram1_AWREADY,          --                   .awready
			f2sdram1_AWSIZE           => CONNECTED_TO_f2sdram1_AWSIZE,           --                   .awsize
			f2sdram1_AWVALID          => CONNECTED_TO_f2sdram1_AWVALID,          --                   .awvalid
			f2sdram1_WDATA            => CONNECTED_TO_f2sdram1_WDATA,            --                   .wdata
			f2sdram1_WLAST            => CONNECTED_TO_f2sdram1_WLAST,            --                   .wlast
			f2sdram1_WREADY           => CONNECTED_TO_f2sdram1_WREADY,           --                   .wready
			f2sdram1_WSTRB            => CONNECTED_TO_f2sdram1_WSTRB,            --                   .wstrb
			f2sdram1_WVALID           => CONNECTED_TO_f2sdram1_WVALID,           --                   .wvalid
			f2sdram1_BID              => CONNECTED_TO_f2sdram1_BID,              --                   .bid
			f2sdram1_BREADY           => CONNECTED_TO_f2sdram1_BREADY,           --                   .bready
			f2sdram1_BRESP            => CONNECTED_TO_f2sdram1_BRESP,            --                   .bresp
			f2sdram1_BVALID           => CONNECTED_TO_f2sdram1_BVALID,           --                   .bvalid
			f2sdram1_RDATA            => CONNECTED_TO_f2sdram1_RDATA,            --                   .rdata
			f2sdram1_RID              => CONNECTED_TO_f2sdram1_RID,              --                   .rid
			f2sdram1_RLAST            => CONNECTED_TO_f2sdram1_RLAST,            --                   .rlast
			f2sdram1_RREADY           => CONNECTED_TO_f2sdram1_RREADY,           --                   .rready
			f2sdram1_RRESP            => CONNECTED_TO_f2sdram1_RRESP,            --                   .rresp
			f2sdram1_RVALID           => CONNECTED_TO_f2sdram1_RVALID,           --                   .rvalid
			f2sdram2_clk              => CONNECTED_TO_f2sdram2_clk,              --     f2sdram2_clock.clk
			f2sdram2_rst_n            => CONNECTED_TO_f2sdram2_rst_n,            --     f2sdram2_reset.reset_n
			f2sdram2_ARADDR           => CONNECTED_TO_f2sdram2_ARADDR,           --      f2sdram2_data.araddr
			f2sdram2_ARBURST          => CONNECTED_TO_f2sdram2_ARBURST,          --                   .arburst
			f2sdram2_ARCACHE          => CONNECTED_TO_f2sdram2_ARCACHE,          --                   .arcache
			f2sdram2_ARID             => CONNECTED_TO_f2sdram2_ARID,             --                   .arid
			f2sdram2_ARLEN            => CONNECTED_TO_f2sdram2_ARLEN,            --                   .arlen
			f2sdram2_ARLOCK           => CONNECTED_TO_f2sdram2_ARLOCK,           --                   .arlock
			f2sdram2_ARPROT           => CONNECTED_TO_f2sdram2_ARPROT,           --                   .arprot
			f2sdram2_ARQOS            => CONNECTED_TO_f2sdram2_ARQOS,            --                   .arqos
			f2sdram2_ARREADY          => CONNECTED_TO_f2sdram2_ARREADY,          --                   .arready
			f2sdram2_ARSIZE           => CONNECTED_TO_f2sdram2_ARSIZE,           --                   .arsize
			f2sdram2_ARVALID          => CONNECTED_TO_f2sdram2_ARVALID,          --                   .arvalid
			f2sdram2_AWADDR           => CONNECTED_TO_f2sdram2_AWADDR,           --                   .awaddr
			f2sdram2_AWBURST          => CONNECTED_TO_f2sdram2_AWBURST,          --                   .awburst
			f2sdram2_AWCACHE          => CONNECTED_TO_f2sdram2_AWCACHE,          --                   .awcache
			f2sdram2_AWID             => CONNECTED_TO_f2sdram2_AWID,             --                   .awid
			f2sdram2_AWLEN            => CONNECTED_TO_f2sdram2_AWLEN,            --                   .awlen
			f2sdram2_AWLOCK           => CONNECTED_TO_f2sdram2_AWLOCK,           --                   .awlock
			f2sdram2_AWPROT           => CONNECTED_TO_f2sdram2_AWPROT,           --                   .awprot
			f2sdram2_AWQOS            => CONNECTED_TO_f2sdram2_AWQOS,            --                   .awqos
			f2sdram2_AWREADY          => CONNECTED_TO_f2sdram2_AWREADY,          --                   .awready
			f2sdram2_AWSIZE           => CONNECTED_TO_f2sdram2_AWSIZE,           --                   .awsize
			f2sdram2_AWVALID          => CONNECTED_TO_f2sdram2_AWVALID,          --                   .awvalid
			f2sdram2_WDATA            => CONNECTED_TO_f2sdram2_WDATA,            --                   .wdata
			f2sdram2_WLAST            => CONNECTED_TO_f2sdram2_WLAST,            --                   .wlast
			f2sdram2_WREADY           => CONNECTED_TO_f2sdram2_WREADY,           --                   .wready
			f2sdram2_WSTRB            => CONNECTED_TO_f2sdram2_WSTRB,            --                   .wstrb
			f2sdram2_WVALID           => CONNECTED_TO_f2sdram2_WVALID,           --                   .wvalid
			f2sdram2_BID              => CONNECTED_TO_f2sdram2_BID,              --                   .bid
			f2sdram2_BREADY           => CONNECTED_TO_f2sdram2_BREADY,           --                   .bready
			f2sdram2_BRESP            => CONNECTED_TO_f2sdram2_BRESP,            --                   .bresp
			f2sdram2_BVALID           => CONNECTED_TO_f2sdram2_BVALID,           --                   .bvalid
			f2sdram2_RDATA            => CONNECTED_TO_f2sdram2_RDATA,            --                   .rdata
			f2sdram2_RID              => CONNECTED_TO_f2sdram2_RID,              --                   .rid
			f2sdram2_RLAST            => CONNECTED_TO_f2sdram2_RLAST,            --                   .rlast
			f2sdram2_RREADY           => CONNECTED_TO_f2sdram2_RREADY,           --                   .rready
			f2sdram2_RRESP            => CONNECTED_TO_f2sdram2_RRESP,            --                   .rresp
			f2sdram2_RVALID           => CONNECTED_TO_f2sdram2_RVALID,           --                   .rvalid
			f2h_irq_p0                => CONNECTED_TO_f2h_irq_p0,                --           f2h_irq0.irq
			f2h_irq_p1                => CONNECTED_TO_f2h_irq_p1,                --           f2h_irq1.irq
			emac_ptp_ref_clk          => CONNECTED_TO_emac_ptp_ref_clk,          -- emac_ptp_ref_clock.clk
			emac1_phy_mac_speed_o     => CONNECTED_TO_emac1_phy_mac_speed_o,     --              emac1.phy_mac_speed_o
			emac1_phy_txd_o           => CONNECTED_TO_emac1_phy_txd_o,           --                   .phy_txd_o
			emac1_phy_txen_o          => CONNECTED_TO_emac1_phy_txen_o,          --                   .phy_txen_o
			emac1_phy_txer_o          => CONNECTED_TO_emac1_phy_txer_o,          --                   .phy_txer_o
			emac1_phy_rxdv_i          => CONNECTED_TO_emac1_phy_rxdv_i,          --                   .phy_rxdv_i
			emac1_phy_rxer_i          => CONNECTED_TO_emac1_phy_rxer_i,          --                   .phy_rxer_i
			emac1_phy_rxd_i           => CONNECTED_TO_emac1_phy_rxd_i,           --                   .phy_rxd_i
			emac1_phy_col_i           => CONNECTED_TO_emac1_phy_col_i,           --                   .phy_col_i
			emac1_phy_crs_i           => CONNECTED_TO_emac1_phy_crs_i,           --                   .phy_crs_i
			emac1_gmii_mdo_o          => CONNECTED_TO_emac1_gmii_mdo_o,          --                   .gmii_mdo_o
			emac1_gmii_mdo_o_e        => CONNECTED_TO_emac1_gmii_mdo_o_e,        --                   .gmii_mdo_o_e
			emac1_gmii_mdi_i          => CONNECTED_TO_emac1_gmii_mdi_i,          --                   .gmii_mdi_i
			emac1_ptp_pps_o           => CONNECTED_TO_emac1_ptp_pps_o,           --                   .ptp_pps_o
			emac1_ptp_aux_ts_trig_i   => CONNECTED_TO_emac1_ptp_aux_ts_trig_i,   --                   .ptp_aux_ts_trig_i
			emac1_ptp_tstmp_data      => CONNECTED_TO_emac1_ptp_tstmp_data,      --                   .ptp_tstmp_data
			emac1_ptp_tstmp_en        => CONNECTED_TO_emac1_ptp_tstmp_en,        --                   .ptp_tstmp_en
			emac1_gmii_mdc_o          => CONNECTED_TO_emac1_gmii_mdc_o,          --       emac1_md_clk.clk
			emac1_clk_rx_i            => CONNECTED_TO_emac1_clk_rx_i,            --    emac1_rx_clk_in.clk
			emac1_clk_tx_i            => CONNECTED_TO_emac1_clk_tx_i,            --    emac1_tx_clk_in.clk
			emac1_phy_txclk_o         => CONNECTED_TO_emac1_phy_txclk_o,         --      emac1_gtx_clk.clk
			emac1_rst_clk_tx_n_o      => CONNECTED_TO_emac1_rst_clk_tx_n_o,      --     emac1_tx_reset.reset_n
			emac1_rst_clk_rx_n_o      => CONNECTED_TO_emac1_rst_clk_rx_n_o,      --     emac1_rx_reset.reset_n
			hps_io_phery_emac0_TX_CLK => CONNECTED_TO_hps_io_phery_emac0_TX_CLK, --             hps_io.hps_io_phery_emac0_TX_CLK
			hps_io_phery_emac0_TXD0   => CONNECTED_TO_hps_io_phery_emac0_TXD0,   --                   .hps_io_phery_emac0_TXD0
			hps_io_phery_emac0_TXD1   => CONNECTED_TO_hps_io_phery_emac0_TXD1,   --                   .hps_io_phery_emac0_TXD1
			hps_io_phery_emac0_TXD2   => CONNECTED_TO_hps_io_phery_emac0_TXD2,   --                   .hps_io_phery_emac0_TXD2
			hps_io_phery_emac0_TXD3   => CONNECTED_TO_hps_io_phery_emac0_TXD3,   --                   .hps_io_phery_emac0_TXD3
			hps_io_phery_emac0_RX_CTL => CONNECTED_TO_hps_io_phery_emac0_RX_CTL, --                   .hps_io_phery_emac0_RX_CTL
			hps_io_phery_emac0_TX_CTL => CONNECTED_TO_hps_io_phery_emac0_TX_CTL, --                   .hps_io_phery_emac0_TX_CTL
			hps_io_phery_emac0_RX_CLK => CONNECTED_TO_hps_io_phery_emac0_RX_CLK, --                   .hps_io_phery_emac0_RX_CLK
			hps_io_phery_emac0_RXD0   => CONNECTED_TO_hps_io_phery_emac0_RXD0,   --                   .hps_io_phery_emac0_RXD0
			hps_io_phery_emac0_RXD1   => CONNECTED_TO_hps_io_phery_emac0_RXD1,   --                   .hps_io_phery_emac0_RXD1
			hps_io_phery_emac0_RXD2   => CONNECTED_TO_hps_io_phery_emac0_RXD2,   --                   .hps_io_phery_emac0_RXD2
			hps_io_phery_emac0_RXD3   => CONNECTED_TO_hps_io_phery_emac0_RXD3,   --                   .hps_io_phery_emac0_RXD3
			hps_io_phery_emac0_MDIO   => CONNECTED_TO_hps_io_phery_emac0_MDIO,   --                   .hps_io_phery_emac0_MDIO
			hps_io_phery_emac0_MDC    => CONNECTED_TO_hps_io_phery_emac0_MDC,    --                   .hps_io_phery_emac0_MDC
			hps_io_phery_sdmmc_CMD    => CONNECTED_TO_hps_io_phery_sdmmc_CMD,    --                   .hps_io_phery_sdmmc_CMD
			hps_io_phery_sdmmc_D0     => CONNECTED_TO_hps_io_phery_sdmmc_D0,     --                   .hps_io_phery_sdmmc_D0
			hps_io_phery_sdmmc_D1     => CONNECTED_TO_hps_io_phery_sdmmc_D1,     --                   .hps_io_phery_sdmmc_D1
			hps_io_phery_sdmmc_D2     => CONNECTED_TO_hps_io_phery_sdmmc_D2,     --                   .hps_io_phery_sdmmc_D2
			hps_io_phery_sdmmc_D3     => CONNECTED_TO_hps_io_phery_sdmmc_D3,     --                   .hps_io_phery_sdmmc_D3
			hps_io_phery_sdmmc_CCLK   => CONNECTED_TO_hps_io_phery_sdmmc_CCLK,   --                   .hps_io_phery_sdmmc_CCLK
			hps_io_phery_usb0_DATA0   => CONNECTED_TO_hps_io_phery_usb0_DATA0,   --                   .hps_io_phery_usb0_DATA0
			hps_io_phery_usb0_DATA1   => CONNECTED_TO_hps_io_phery_usb0_DATA1,   --                   .hps_io_phery_usb0_DATA1
			hps_io_phery_usb0_DATA2   => CONNECTED_TO_hps_io_phery_usb0_DATA2,   --                   .hps_io_phery_usb0_DATA2
			hps_io_phery_usb0_DATA3   => CONNECTED_TO_hps_io_phery_usb0_DATA3,   --                   .hps_io_phery_usb0_DATA3
			hps_io_phery_usb0_DATA4   => CONNECTED_TO_hps_io_phery_usb0_DATA4,   --                   .hps_io_phery_usb0_DATA4
			hps_io_phery_usb0_DATA5   => CONNECTED_TO_hps_io_phery_usb0_DATA5,   --                   .hps_io_phery_usb0_DATA5
			hps_io_phery_usb0_DATA6   => CONNECTED_TO_hps_io_phery_usb0_DATA6,   --                   .hps_io_phery_usb0_DATA6
			hps_io_phery_usb0_DATA7   => CONNECTED_TO_hps_io_phery_usb0_DATA7,   --                   .hps_io_phery_usb0_DATA7
			hps_io_phery_usb0_CLK     => CONNECTED_TO_hps_io_phery_usb0_CLK,     --                   .hps_io_phery_usb0_CLK
			hps_io_phery_usb0_STP     => CONNECTED_TO_hps_io_phery_usb0_STP,     --                   .hps_io_phery_usb0_STP
			hps_io_phery_usb0_DIR     => CONNECTED_TO_hps_io_phery_usb0_DIR,     --                   .hps_io_phery_usb0_DIR
			hps_io_phery_usb0_NXT     => CONNECTED_TO_hps_io_phery_usb0_NXT,     --                   .hps_io_phery_usb0_NXT
			hps_io_phery_uart0_RX     => CONNECTED_TO_hps_io_phery_uart0_RX,     --                   .hps_io_phery_uart0_RX
			hps_io_phery_uart0_TX     => CONNECTED_TO_hps_io_phery_uart0_TX,     --                   .hps_io_phery_uart0_TX
			hps_io_phery_uart0_CTS_N  => CONNECTED_TO_hps_io_phery_uart0_CTS_N,  --                   .hps_io_phery_uart0_CTS_N
			hps_io_phery_uart0_RTS_N  => CONNECTED_TO_hps_io_phery_uart0_RTS_N,  --                   .hps_io_phery_uart0_RTS_N
			hps_io_phery_i2c1_SDA     => CONNECTED_TO_hps_io_phery_i2c1_SDA,     --                   .hps_io_phery_i2c1_SDA
			hps_io_phery_i2c1_SCL     => CONNECTED_TO_hps_io_phery_i2c1_SCL,     --                   .hps_io_phery_i2c1_SCL
			hps_io_hps_ocs_clk        => CONNECTED_TO_hps_io_hps_ocs_clk,        --                   .hps_io_hps_ocs_clk
			hps_io_gpio_gpio1_io18    => CONNECTED_TO_hps_io_gpio_gpio1_io18,    --                   .hps_io_gpio_gpio1_io18
			hps_io_gpio_gpio1_io19    => CONNECTED_TO_hps_io_gpio_gpio1_io19     --                   .hps_io_gpio_gpio1_io19
		);

