module s10_hps (
		output wire          h2f_rst,                   //          h2f_reset.reset
		output wire          h2f_watchdog_rst,          //   h2f_watchdog_rst.reset_n
		input  wire [42:0]   f2h_stm_hwevents,          //  f2h_stm_hw_events.stm_hwevents
		input  wire [4095:0] hps_emif_emif_to_hps,      //           hps_emif.emif_to_hps
		output wire [4095:0] hps_emif_hps_to_emif,      //                   .hps_to_emif
		input  wire          hps_emif_emif_to_gp,       //                   .emif_to_gp
		output wire [1:0]    hps_emif_gp_to_emif,       //                   .gp_to_emif
		input  wire          f2h_axi_clk,               //      f2h_axi_clock.clk
		input  wire          f2h_axi_rst_n,             //      f2h_axi_reset.reset_n
		input  wire [3:0]    f2h_AWCACHE,               //      f2h_axi_slave.awcache
		input  wire [3:0]    f2h_ARCACHE,               //                   .arcache
		input  wire [3:0]    f2h_AWID,                  //                   .awid
		input  wire [31:0]   f2h_AWADDR,                //                   .awaddr
		input  wire [7:0]    f2h_AWLEN,                 //                   .awlen
		input  wire [2:0]    f2h_AWSIZE,                //                   .awsize
		input  wire [1:0]    f2h_AWBURST,               //                   .awburst
		input  wire          f2h_AWLOCK,                //                   .awlock
		input  wire [2:0]    f2h_AWPROT,                //                   .awprot
		input  wire          f2h_AWVALID,               //                   .awvalid
		output wire          f2h_AWREADY,               //                   .awready
		input  wire [3:0]    f2h_AWQOS,                 //                   .awqos
		input  wire [127:0]  f2h_WDATA,                 //                   .wdata
		input  wire [15:0]   f2h_WSTRB,                 //                   .wstrb
		input  wire          f2h_WLAST,                 //                   .wlast
		input  wire          f2h_WVALID,                //                   .wvalid
		output wire          f2h_WREADY,                //                   .wready
		output wire [3:0]    f2h_BID,                   //                   .bid
		output wire [1:0]    f2h_BRESP,                 //                   .bresp
		output wire          f2h_BVALID,                //                   .bvalid
		input  wire          f2h_BREADY,                //                   .bready
		input  wire [3:0]    f2h_ARID,                  //                   .arid
		input  wire [31:0]   f2h_ARADDR,                //                   .araddr
		input  wire [7:0]    f2h_ARLEN,                 //                   .arlen
		input  wire [2:0]    f2h_ARSIZE,                //                   .arsize
		input  wire [1:0]    f2h_ARBURST,               //                   .arburst
		input  wire          f2h_ARLOCK,                //                   .arlock
		input  wire [2:0]    f2h_ARPROT,                //                   .arprot
		input  wire          f2h_ARVALID,               //                   .arvalid
		output wire          f2h_ARREADY,               //                   .arready
		input  wire [3:0]    f2h_ARQOS,                 //                   .arqos
		output wire [3:0]    f2h_RID,                   //                   .rid
		output wire [127:0]  f2h_RDATA,                 //                   .rdata
		output wire [1:0]    f2h_RRESP,                 //                   .rresp
		output wire          f2h_RLAST,                 //                   .rlast
		output wire          f2h_RVALID,                //                   .rvalid
		input  wire          f2h_RREADY,                //                   .rready
		input  wire          h2f_lw_axi_clk,            //   h2f_lw_axi_clock.clk
		input  wire          h2f_lw_axi_rst_n,          //   h2f_lw_axi_reset.reset_n
		output wire [3:0]    h2f_lw_AWID,               //  h2f_lw_axi_master.awid
		output wire [20:0]   h2f_lw_AWADDR,             //                   .awaddr
		output wire [7:0]    h2f_lw_AWLEN,              //                   .awlen
		output wire [2:0]    h2f_lw_AWSIZE,             //                   .awsize
		output wire [1:0]    h2f_lw_AWBURST,            //                   .awburst
		output wire          h2f_lw_AWLOCK,             //                   .awlock
		output wire [3:0]    h2f_lw_AWCACHE,            //                   .awcache
		output wire [2:0]    h2f_lw_AWPROT,             //                   .awprot
		output wire          h2f_lw_AWVALID,            //                   .awvalid
		input  wire          h2f_lw_AWREADY,            //                   .awready
		output wire [31:0]   h2f_lw_WDATA,              //                   .wdata
		output wire [3:0]    h2f_lw_WSTRB,              //                   .wstrb
		output wire          h2f_lw_WLAST,              //                   .wlast
		output wire          h2f_lw_WVALID,             //                   .wvalid
		input  wire          h2f_lw_WREADY,             //                   .wready
		input  wire [3:0]    h2f_lw_BID,                //                   .bid
		input  wire [1:0]    h2f_lw_BRESP,              //                   .bresp
		input  wire          h2f_lw_BVALID,             //                   .bvalid
		output wire          h2f_lw_BREADY,             //                   .bready
		output wire [3:0]    h2f_lw_ARID,               //                   .arid
		output wire [20:0]   h2f_lw_ARADDR,             //                   .araddr
		output wire [7:0]    h2f_lw_ARLEN,              //                   .arlen
		output wire [2:0]    h2f_lw_ARSIZE,             //                   .arsize
		output wire [1:0]    h2f_lw_ARBURST,            //                   .arburst
		output wire          h2f_lw_ARLOCK,             //                   .arlock
		output wire [3:0]    h2f_lw_ARCACHE,            //                   .arcache
		output wire [2:0]    h2f_lw_ARPROT,             //                   .arprot
		output wire          h2f_lw_ARVALID,            //                   .arvalid
		input  wire          h2f_lw_ARREADY,            //                   .arready
		input  wire [3:0]    h2f_lw_RID,                //                   .rid
		input  wire [31:0]   h2f_lw_RDATA,              //                   .rdata
		input  wire [1:0]    h2f_lw_RRESP,              //                   .rresp
		input  wire          h2f_lw_RLAST,              //                   .rlast
		input  wire          h2f_lw_RVALID,             //                   .rvalid
		output wire          h2f_lw_RREADY,             //                   .rready
		input  wire          h2f_axi_clk,               //      h2f_axi_clock.clk
		input  wire          h2f_axi_rst_n,             //      h2f_axi_reset.reset_n
		output wire [3:0]    h2f_AWID,                  //     h2f_axi_master.awid
		output wire [31:0]   h2f_AWADDR,                //                   .awaddr
		output wire [7:0]    h2f_AWLEN,                 //                   .awlen
		output wire [2:0]    h2f_AWSIZE,                //                   .awsize
		output wire [1:0]    h2f_AWBURST,               //                   .awburst
		output wire          h2f_AWLOCK,                //                   .awlock
		output wire [3:0]    h2f_AWCACHE,               //                   .awcache
		output wire [2:0]    h2f_AWPROT,                //                   .awprot
		output wire          h2f_AWVALID,               //                   .awvalid
		input  wire          h2f_AWREADY,               //                   .awready
		output wire [127:0]  h2f_WDATA,                 //                   .wdata
		output wire [15:0]   h2f_WSTRB,                 //                   .wstrb
		output wire          h2f_WLAST,                 //                   .wlast
		output wire          h2f_WVALID,                //                   .wvalid
		input  wire          h2f_WREADY,                //                   .wready
		input  wire [3:0]    h2f_BID,                   //                   .bid
		input  wire [1:0]    h2f_BRESP,                 //                   .bresp
		input  wire          h2f_BVALID,                //                   .bvalid
		output wire          h2f_BREADY,                //                   .bready
		output wire [3:0]    h2f_ARID,                  //                   .arid
		output wire [31:0]   h2f_ARADDR,                //                   .araddr
		output wire [7:0]    h2f_ARLEN,                 //                   .arlen
		output wire [2:0]    h2f_ARSIZE,                //                   .arsize
		output wire [1:0]    h2f_ARBURST,               //                   .arburst
		output wire          h2f_ARLOCK,                //                   .arlock
		output wire [3:0]    h2f_ARCACHE,               //                   .arcache
		output wire [2:0]    h2f_ARPROT,                //                   .arprot
		output wire          h2f_ARVALID,               //                   .arvalid
		input  wire          h2f_ARREADY,               //                   .arready
		input  wire [3:0]    h2f_RID,                   //                   .rid
		input  wire [127:0]  h2f_RDATA,                 //                   .rdata
		input  wire [1:0]    h2f_RRESP,                 //                   .rresp
		input  wire          h2f_RLAST,                 //                   .rlast
		input  wire          h2f_RVALID,                //                   .rvalid
		output wire          h2f_RREADY,                //                   .rready
		input  wire          f2sdram0_clk,              //     f2sdram0_clock.clk
		input  wire          f2sdram0_rst_n,            //     f2sdram0_reset.reset_n
		input  wire [31:0]   f2sdram0_ARADDR,           //      f2sdram0_data.araddr
		input  wire [1:0]    f2sdram0_ARBURST,          //                   .arburst
		input  wire [3:0]    f2sdram0_ARCACHE,          //                   .arcache
		input  wire [3:0]    f2sdram0_ARID,             //                   .arid
		input  wire [7:0]    f2sdram0_ARLEN,            //                   .arlen
		input  wire          f2sdram0_ARLOCK,           //                   .arlock
		input  wire [2:0]    f2sdram0_ARPROT,           //                   .arprot
		input  wire [3:0]    f2sdram0_ARQOS,            //                   .arqos
		output wire          f2sdram0_ARREADY,          //                   .arready
		input  wire [2:0]    f2sdram0_ARSIZE,           //                   .arsize
		input  wire          f2sdram0_ARVALID,          //                   .arvalid
		input  wire [31:0]   f2sdram0_AWADDR,           //                   .awaddr
		input  wire [1:0]    f2sdram0_AWBURST,          //                   .awburst
		input  wire [3:0]    f2sdram0_AWCACHE,          //                   .awcache
		input  wire [3:0]    f2sdram0_AWID,             //                   .awid
		input  wire [7:0]    f2sdram0_AWLEN,            //                   .awlen
		input  wire          f2sdram0_AWLOCK,           //                   .awlock
		input  wire [2:0]    f2sdram0_AWPROT,           //                   .awprot
		input  wire [3:0]    f2sdram0_AWQOS,            //                   .awqos
		output wire          f2sdram0_AWREADY,          //                   .awready
		input  wire [2:0]    f2sdram0_AWSIZE,           //                   .awsize
		input  wire          f2sdram0_AWVALID,          //                   .awvalid
		input  wire [127:0]  f2sdram0_WDATA,            //                   .wdata
		input  wire          f2sdram0_WLAST,            //                   .wlast
		output wire          f2sdram0_WREADY,           //                   .wready
		input  wire [15:0]   f2sdram0_WSTRB,            //                   .wstrb
		input  wire          f2sdram0_WVALID,           //                   .wvalid
		output wire [3:0]    f2sdram0_BID,              //                   .bid
		input  wire          f2sdram0_BREADY,           //                   .bready
		output wire [1:0]    f2sdram0_BRESP,            //                   .bresp
		output wire          f2sdram0_BVALID,           //                   .bvalid
		output wire [127:0]  f2sdram0_RDATA,            //                   .rdata
		output wire [3:0]    f2sdram0_RID,              //                   .rid
		output wire          f2sdram0_RLAST,            //                   .rlast
		input  wire          f2sdram0_RREADY,           //                   .rready
		output wire [1:0]    f2sdram0_RRESP,            //                   .rresp
		output wire          f2sdram0_RVALID,           //                   .rvalid
		input  wire          f2sdram1_clk,              //     f2sdram1_clock.clk
		input  wire          f2sdram1_rst_n,            //     f2sdram1_reset.reset_n
		input  wire [31:0]   f2sdram1_ARADDR,           //      f2sdram1_data.araddr
		input  wire [1:0]    f2sdram1_ARBURST,          //                   .arburst
		input  wire [3:0]    f2sdram1_ARCACHE,          //                   .arcache
		input  wire [3:0]    f2sdram1_ARID,             //                   .arid
		input  wire [7:0]    f2sdram1_ARLEN,            //                   .arlen
		input  wire          f2sdram1_ARLOCK,           //                   .arlock
		input  wire [2:0]    f2sdram1_ARPROT,           //                   .arprot
		input  wire [3:0]    f2sdram1_ARQOS,            //                   .arqos
		output wire          f2sdram1_ARREADY,          //                   .arready
		input  wire [2:0]    f2sdram1_ARSIZE,           //                   .arsize
		input  wire          f2sdram1_ARVALID,          //                   .arvalid
		input  wire [31:0]   f2sdram1_AWADDR,           //                   .awaddr
		input  wire [1:0]    f2sdram1_AWBURST,          //                   .awburst
		input  wire [3:0]    f2sdram1_AWCACHE,          //                   .awcache
		input  wire [3:0]    f2sdram1_AWID,             //                   .awid
		input  wire [7:0]    f2sdram1_AWLEN,            //                   .awlen
		input  wire          f2sdram1_AWLOCK,           //                   .awlock
		input  wire [2:0]    f2sdram1_AWPROT,           //                   .awprot
		input  wire [3:0]    f2sdram1_AWQOS,            //                   .awqos
		output wire          f2sdram1_AWREADY,          //                   .awready
		input  wire [2:0]    f2sdram1_AWSIZE,           //                   .awsize
		input  wire          f2sdram1_AWVALID,          //                   .awvalid
		input  wire [127:0]  f2sdram1_WDATA,            //                   .wdata
		input  wire          f2sdram1_WLAST,            //                   .wlast
		output wire          f2sdram1_WREADY,           //                   .wready
		input  wire [15:0]   f2sdram1_WSTRB,            //                   .wstrb
		input  wire          f2sdram1_WVALID,           //                   .wvalid
		output wire [3:0]    f2sdram1_BID,              //                   .bid
		input  wire          f2sdram1_BREADY,           //                   .bready
		output wire [1:0]    f2sdram1_BRESP,            //                   .bresp
		output wire          f2sdram1_BVALID,           //                   .bvalid
		output wire [127:0]  f2sdram1_RDATA,            //                   .rdata
		output wire [3:0]    f2sdram1_RID,              //                   .rid
		output wire          f2sdram1_RLAST,            //                   .rlast
		input  wire          f2sdram1_RREADY,           //                   .rready
		output wire [1:0]    f2sdram1_RRESP,            //                   .rresp
		output wire          f2sdram1_RVALID,           //                   .rvalid
		input  wire          f2sdram2_clk,              //     f2sdram2_clock.clk
		input  wire          f2sdram2_rst_n,            //     f2sdram2_reset.reset_n
		input  wire [31:0]   f2sdram2_ARADDR,           //      f2sdram2_data.araddr
		input  wire [1:0]    f2sdram2_ARBURST,          //                   .arburst
		input  wire [3:0]    f2sdram2_ARCACHE,          //                   .arcache
		input  wire [3:0]    f2sdram2_ARID,             //                   .arid
		input  wire [7:0]    f2sdram2_ARLEN,            //                   .arlen
		input  wire          f2sdram2_ARLOCK,           //                   .arlock
		input  wire [2:0]    f2sdram2_ARPROT,           //                   .arprot
		input  wire [3:0]    f2sdram2_ARQOS,            //                   .arqos
		output wire          f2sdram2_ARREADY,          //                   .arready
		input  wire [2:0]    f2sdram2_ARSIZE,           //                   .arsize
		input  wire          f2sdram2_ARVALID,          //                   .arvalid
		input  wire [31:0]   f2sdram2_AWADDR,           //                   .awaddr
		input  wire [1:0]    f2sdram2_AWBURST,          //                   .awburst
		input  wire [3:0]    f2sdram2_AWCACHE,          //                   .awcache
		input  wire [3:0]    f2sdram2_AWID,             //                   .awid
		input  wire [7:0]    f2sdram2_AWLEN,            //                   .awlen
		input  wire          f2sdram2_AWLOCK,           //                   .awlock
		input  wire [2:0]    f2sdram2_AWPROT,           //                   .awprot
		input  wire [3:0]    f2sdram2_AWQOS,            //                   .awqos
		output wire          f2sdram2_AWREADY,          //                   .awready
		input  wire [2:0]    f2sdram2_AWSIZE,           //                   .awsize
		input  wire          f2sdram2_AWVALID,          //                   .awvalid
		input  wire [127:0]  f2sdram2_WDATA,            //                   .wdata
		input  wire          f2sdram2_WLAST,            //                   .wlast
		output wire          f2sdram2_WREADY,           //                   .wready
		input  wire [15:0]   f2sdram2_WSTRB,            //                   .wstrb
		input  wire          f2sdram2_WVALID,           //                   .wvalid
		output wire [3:0]    f2sdram2_BID,              //                   .bid
		input  wire          f2sdram2_BREADY,           //                   .bready
		output wire [1:0]    f2sdram2_BRESP,            //                   .bresp
		output wire          f2sdram2_BVALID,           //                   .bvalid
		output wire [127:0]  f2sdram2_RDATA,            //                   .rdata
		output wire [3:0]    f2sdram2_RID,              //                   .rid
		output wire          f2sdram2_RLAST,            //                   .rlast
		input  wire          f2sdram2_RREADY,           //                   .rready
		output wire [1:0]    f2sdram2_RRESP,            //                   .rresp
		output wire          f2sdram2_RVALID,           //                   .rvalid
		input  wire [31:0]   f2h_irq_p0,                //           f2h_irq0.irq
		input  wire [31:0]   f2h_irq_p1,                //           f2h_irq1.irq
		input  wire          emac_ptp_ref_clk,          // emac_ptp_ref_clock.clk
		output wire [1:0]    emac1_phy_mac_speed_o,     //              emac1.phy_mac_speed_o
		output wire [7:0]    emac1_phy_txd_o,           //                   .phy_txd_o
		output wire          emac1_phy_txen_o,          //                   .phy_txen_o
		output wire          emac1_phy_txer_o,          //                   .phy_txer_o
		input  wire          emac1_phy_rxdv_i,          //                   .phy_rxdv_i
		input  wire          emac1_phy_rxer_i,          //                   .phy_rxer_i
		input  wire [7:0]    emac1_phy_rxd_i,           //                   .phy_rxd_i
		input  wire          emac1_phy_col_i,           //                   .phy_col_i
		input  wire          emac1_phy_crs_i,           //                   .phy_crs_i
		output wire          emac1_gmii_mdo_o,          //                   .gmii_mdo_o
		output wire          emac1_gmii_mdo_o_e,        //                   .gmii_mdo_o_e
		input  wire          emac1_gmii_mdi_i,          //                   .gmii_mdi_i
		output wire          emac1_ptp_pps_o,           //                   .ptp_pps_o
		input  wire          emac1_ptp_aux_ts_trig_i,   //                   .ptp_aux_ts_trig_i
		output wire          emac1_ptp_tstmp_data,      //                   .ptp_tstmp_data
		output wire          emac1_ptp_tstmp_en,        //                   .ptp_tstmp_en
		output wire          emac1_gmii_mdc_o,          //       emac1_md_clk.clk
		input  wire          emac1_clk_rx_i,            //    emac1_rx_clk_in.clk
		input  wire          emac1_clk_tx_i,            //    emac1_tx_clk_in.clk
		output wire          emac1_phy_txclk_o,         //      emac1_gtx_clk.clk
		output wire          emac1_rst_clk_tx_n_o,      //     emac1_tx_reset.reset_n
		output wire          emac1_rst_clk_rx_n_o,      //     emac1_rx_reset.reset_n
		output wire          hps_io_phery_emac0_TX_CLK, //             hps_io.hps_io_phery_emac0_TX_CLK
		output wire          hps_io_phery_emac0_TXD0,   //                   .hps_io_phery_emac0_TXD0
		output wire          hps_io_phery_emac0_TXD1,   //                   .hps_io_phery_emac0_TXD1
		output wire          hps_io_phery_emac0_TXD2,   //                   .hps_io_phery_emac0_TXD2
		output wire          hps_io_phery_emac0_TXD3,   //                   .hps_io_phery_emac0_TXD3
		input  wire          hps_io_phery_emac0_RX_CTL, //                   .hps_io_phery_emac0_RX_CTL
		output wire          hps_io_phery_emac0_TX_CTL, //                   .hps_io_phery_emac0_TX_CTL
		input  wire          hps_io_phery_emac0_RX_CLK, //                   .hps_io_phery_emac0_RX_CLK
		input  wire          hps_io_phery_emac0_RXD0,   //                   .hps_io_phery_emac0_RXD0
		input  wire          hps_io_phery_emac0_RXD1,   //                   .hps_io_phery_emac0_RXD1
		input  wire          hps_io_phery_emac0_RXD2,   //                   .hps_io_phery_emac0_RXD2
		input  wire          hps_io_phery_emac0_RXD3,   //                   .hps_io_phery_emac0_RXD3
		inout  wire          hps_io_phery_emac0_MDIO,   //                   .hps_io_phery_emac0_MDIO
		output wire          hps_io_phery_emac0_MDC,    //                   .hps_io_phery_emac0_MDC
		inout  wire          hps_io_phery_sdmmc_CMD,    //                   .hps_io_phery_sdmmc_CMD
		inout  wire          hps_io_phery_sdmmc_D0,     //                   .hps_io_phery_sdmmc_D0
		inout  wire          hps_io_phery_sdmmc_D1,     //                   .hps_io_phery_sdmmc_D1
		inout  wire          hps_io_phery_sdmmc_D2,     //                   .hps_io_phery_sdmmc_D2
		inout  wire          hps_io_phery_sdmmc_D3,     //                   .hps_io_phery_sdmmc_D3
		output wire          hps_io_phery_sdmmc_CCLK,   //                   .hps_io_phery_sdmmc_CCLK
		inout  wire          hps_io_phery_usb0_DATA0,   //                   .hps_io_phery_usb0_DATA0
		inout  wire          hps_io_phery_usb0_DATA1,   //                   .hps_io_phery_usb0_DATA1
		inout  wire          hps_io_phery_usb0_DATA2,   //                   .hps_io_phery_usb0_DATA2
		inout  wire          hps_io_phery_usb0_DATA3,   //                   .hps_io_phery_usb0_DATA3
		inout  wire          hps_io_phery_usb0_DATA4,   //                   .hps_io_phery_usb0_DATA4
		inout  wire          hps_io_phery_usb0_DATA5,   //                   .hps_io_phery_usb0_DATA5
		inout  wire          hps_io_phery_usb0_DATA6,   //                   .hps_io_phery_usb0_DATA6
		inout  wire          hps_io_phery_usb0_DATA7,   //                   .hps_io_phery_usb0_DATA7
		input  wire          hps_io_phery_usb0_CLK,     //                   .hps_io_phery_usb0_CLK
		output wire          hps_io_phery_usb0_STP,     //                   .hps_io_phery_usb0_STP
		input  wire          hps_io_phery_usb0_DIR,     //                   .hps_io_phery_usb0_DIR
		input  wire          hps_io_phery_usb0_NXT,     //                   .hps_io_phery_usb0_NXT
		input  wire          hps_io_phery_uart0_RX,     //                   .hps_io_phery_uart0_RX
		output wire          hps_io_phery_uart0_TX,     //                   .hps_io_phery_uart0_TX
		input  wire          hps_io_phery_uart0_CTS_N,  //                   .hps_io_phery_uart0_CTS_N
		output wire          hps_io_phery_uart0_RTS_N,  //                   .hps_io_phery_uart0_RTS_N
		inout  wire          hps_io_phery_i2c1_SDA,     //                   .hps_io_phery_i2c1_SDA
		inout  wire          hps_io_phery_i2c1_SCL,     //                   .hps_io_phery_i2c1_SCL
		input  wire          hps_io_hps_ocs_clk,        //                   .hps_io_hps_ocs_clk
		inout  wire          hps_io_gpio_gpio1_io18,    //                   .hps_io_gpio_gpio1_io18
		inout  wire          hps_io_gpio_gpio1_io19     //                   .hps_io_gpio_gpio1_io19
	);
endmodule

