// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



//
// Intel Stratix10 HPS AXI Soft IP wrappers.
//


module one_hps_interface_ddr (
    input  wire [4095:0] io48_b_cdata_pb0_in,
    output wire [4095:0] io48_b_iod_pb0_out
    
);

assign io48_b_iod_pb0_out = io48_b_cdata_pb0_in;

//fourteennm_hps_interface_ddr emif_interface(
// .io48_b_iod_pb0_out( io48_b_iod_pb0_out[199:0]),
// .io48_b_cdata_pb0_in(io48_b_cdata_pb0_in[199:0])
//);


endmodule

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
`timescale 1 ps / 1 ps
module fourteennm_hps_rl_fpga2sdram 
#( parameter WDTH0 = 128, parameter WDTH1 = 128, parameter WDTH2 = 128,
   parameter ADTH0 =  37, parameter ADTH1 =  37, parameter ADTH2 =  37)(
    input  wire           f2s_sdram0_clk,
    input  wire           f2s_sdram1_clk,
    input  wire           f2s_sdram2_clk,
    input  wire           f2s_sdram0_rst_n,
    input  wire           f2s_sdram1_rst_n,
    input  wire           f2s_sdram2_rst_n,
    input  wire [    2:0] fpga2sdram0_ready_latency,
    input  wire [    2:0] fpga2sdram1_ready_latency,
    input  wire [    2:0] fpga2sdram2_ready_latency,        
    input  wire           fpga2sdram0_ar_lock,
    input  wire           fpga2sdram0_ar_valid,
    input  wire           fpga2sdram0_aw_lock,
    input  wire           fpga2sdram0_aw_valid,
    input  wire           fpga2sdram0_b_ready,
    input  wire           fpga2sdram0_r_ready,
    input  wire           fpga2sdram0_w_last,
    input  wire           fpga2sdram0_w_valid,
    input  wire           fpga2sdram1_ar_lock,
    input  wire           fpga2sdram1_ar_valid,
    input  wire           fpga2sdram1_aw_lock,
    input  wire           fpga2sdram1_aw_valid,
    input  wire           fpga2sdram1_b_ready,
    input  wire           fpga2sdram1_r_ready,
    input  wire           fpga2sdram1_w_last,
    input  wire           fpga2sdram1_w_valid,
    input  wire           fpga2sdram2_ar_lock,
    input  wire           fpga2sdram2_ar_valid,
    input  wire           fpga2sdram2_aw_lock,
    input  wire           fpga2sdram2_aw_valid,
    input  wire           fpga2sdram2_b_ready,
    input  wire           fpga2sdram2_r_ready,
    input  wire           fpga2sdram2_w_last,
    input  wire           fpga2sdram2_w_valid,
    input  wire [ 37-1:0] fpga2sdram0_ar_addr,
    input  wire [    1:0] fpga2sdram0_ar_burst,
    input  wire [    3:0] fpga2sdram0_ar_cache,
    input  wire [    3:0] fpga2sdram0_ar_id,
    input  wire [    7:0] fpga2sdram0_ar_len,
    input  wire [    2:0] fpga2sdram0_ar_prot,
    input  wire [    3:0] fpga2sdram0_ar_qos,
    input  wire [    2:0] fpga2sdram0_ar_size,
    input  wire [ 37-1:0] fpga2sdram0_aw_addr,
    input  wire [    1:0] fpga2sdram0_aw_burst,
    input  wire [    3:0] fpga2sdram0_aw_cache,
    input  wire [    3:0] fpga2sdram0_aw_id,
    input  wire [    7:0] fpga2sdram0_aw_len,
    input  wire [    2:0] fpga2sdram0_aw_prot,
    input  wire [    3:0] fpga2sdram0_aw_qos,
    input  wire [    2:0] fpga2sdram0_aw_size,
    input  wire [    3:0] fpga2sdram0_port_size_config,
    input  wire [128-1:0] fpga2sdram0_w_data,
    input  wire [ 16-1:0] fpga2sdram0_w_strb,
    
    input  wire [ 37-1:0] fpga2sdram1_ar_addr,
    input  wire [    1:0] fpga2sdram1_ar_burst,
    input  wire [    3:0] fpga2sdram1_ar_cache,
    input  wire [    3:0] fpga2sdram1_ar_id,
    input  wire [    7:0] fpga2sdram1_ar_len,
    input  wire [    2:0] fpga2sdram1_ar_prot,
    input  wire [    3:0] fpga2sdram1_ar_qos,
    input  wire [    2:0] fpga2sdram1_ar_size,
    input  wire [ 37-1:0] fpga2sdram1_aw_addr,
    input  wire [    1:0] fpga2sdram1_aw_burst,
    input  wire [    3:0] fpga2sdram1_aw_cache,
    input  wire [    3:0] fpga2sdram1_aw_id,
    input  wire [    7:0] fpga2sdram1_aw_len,
    input  wire [    2:0] fpga2sdram1_aw_prot,
    input  wire [    3:0] fpga2sdram1_aw_qos,
    input  wire [    2:0] fpga2sdram1_aw_size,
    input  wire [    3:0] fpga2sdram1_port_size_config,
    input  wire [128-1:0] fpga2sdram1_w_data,
    input  wire [ 16-1:0] fpga2sdram1_w_strb,
    input  wire [ 37-1:0] fpga2sdram2_ar_addr,
    input  wire [    1:0] fpga2sdram2_ar_burst,
    input  wire [    3:0] fpga2sdram2_ar_cache,
    input  wire [    3:0] fpga2sdram2_ar_id,
    input  wire [    7:0] fpga2sdram2_ar_len,
    input  wire [    2:0] fpga2sdram2_ar_prot,
    input  wire [    3:0] fpga2sdram2_ar_qos,
    input  wire [    2:0] fpga2sdram2_ar_size,
    input  wire [ 37-1:0] fpga2sdram2_aw_addr,
    input  wire [    1:0] fpga2sdram2_aw_burst,
    input  wire [    3:0] fpga2sdram2_aw_cache,
    input  wire [    3:0] fpga2sdram2_aw_id,
    input  wire [    7:0] fpga2sdram2_aw_len,
    input  wire [    2:0] fpga2sdram2_aw_prot,
    input  wire [    3:0] fpga2sdram2_aw_qos,
    input  wire [    2:0] fpga2sdram2_aw_size,
    input  wire [    3:0] fpga2sdram2_port_size_config,
    input  wire [128-1:0] fpga2sdram2_w_data,
    input  wire [ 16-1:0] fpga2sdram2_w_strb,
    
    output wire             fpga2sdram0_ar_ready,
    output wire             fpga2sdram0_aw_ready,
    output wire             fpga2sdram0_b_valid,
    output wire             fpga2sdram0_r_last,
    output wire             fpga2sdram0_r_valid,
    output wire             fpga2sdram0_w_ready,
    output wire             fpga2sdram1_ar_ready,
    output wire             fpga2sdram1_aw_ready,
    output wire             fpga2sdram1_b_valid,
    output wire             fpga2sdram1_r_last,
    output wire             fpga2sdram1_r_valid,
    output wire             fpga2sdram1_w_ready,
    output wire             fpga2sdram2_ar_ready,
    output wire             fpga2sdram2_aw_ready,
    output wire             fpga2sdram2_b_valid,
    output wire             fpga2sdram2_r_last,
    output wire             fpga2sdram2_r_valid,
    output wire             fpga2sdram2_w_ready,
    output wire [      3:0] fpga2sdram0_b_id,
    output wire [      1:0] fpga2sdram0_b_resp,
    output wire [WDTH0-1:0] fpga2sdram0_r_data,
    output wire [      3:0] fpga2sdram0_r_id,
    output wire [      1:0] fpga2sdram0_r_resp,
    output wire [      3:0] fpga2sdram1_b_id,
    output wire [      1:0] fpga2sdram1_b_resp,
    output wire [WDTH1-1:0] fpga2sdram1_r_data,
    output wire [      3:0] fpga2sdram1_r_id,
    output wire [      1:0] fpga2sdram1_r_resp,
    output wire [      3:0] fpga2sdram2_b_id,
    output wire [      1:0] fpga2sdram2_b_resp,
    output wire [WDTH2-1:0] fpga2sdram2_r_data,
    output wire [      3:0] fpga2sdram2_r_id,
    output wire [      1:0] fpga2sdram2_r_resp
);

    //Celan size warnings
    wire [127:0] fpga2sdram0_r_data_full;
    wire [127:0] fpga2sdram1_r_data_full;
    wire [127:0] fpga2sdram2_r_data_full;
    assign fpga2sdram0_r_data = fpga2sdram0_r_data_full[WDTH0-1:0];
    assign fpga2sdram1_r_data = fpga2sdram1_r_data_full[WDTH1-1:0];
    assign fpga2sdram2_r_data = fpga2sdram2_r_data_full[WDTH2-1:0];

    
    wire           fpga2sdram0_ar_lock_s1;
    wire           fpga2sdram0_ar_valid_s1;
    wire           fpga2sdram0_aw_lock_s1;
    wire           fpga2sdram0_aw_valid_s1;
    wire           fpga2sdram0_b_ready_s1;
    wire           fpga2sdram0_r_ready_s1;
    wire           fpga2sdram0_w_last_s1;
    wire           fpga2sdram0_w_valid_s1;
    wire           fpga2sdram1_ar_lock_s1;
    wire           fpga2sdram1_ar_valid_s1;
    wire           fpga2sdram1_aw_lock_s1;
    wire           fpga2sdram1_aw_valid_s1;
    wire           fpga2sdram1_b_ready_s1;
    wire           fpga2sdram1_r_ready_s1;
    wire           fpga2sdram1_w_last_s1;
    wire           fpga2sdram1_w_valid_s1;
    wire           fpga2sdram2_ar_lock_s1;
    wire           fpga2sdram2_ar_valid_s1;
    wire           fpga2sdram2_aw_lock_s1;
    wire           fpga2sdram2_aw_valid_s1;
    wire           fpga2sdram2_b_ready_s1;
    wire           fpga2sdram2_r_ready_s1;
    wire           fpga2sdram2_w_last_s1;
    wire           fpga2sdram2_w_valid_s1;
    wire [ 37-1:0] fpga2sdram0_ar_addr_s1;
    wire [    1:0] fpga2sdram0_ar_burst_s1;
    wire [    3:0] fpga2sdram0_ar_cache_s1;
    wire [    3:0] fpga2sdram0_ar_id_s1;
    wire [    7:0] fpga2sdram0_ar_len_s1;
    wire [    2:0] fpga2sdram0_ar_prot_s1;
    wire [    3:0] fpga2sdram0_ar_qos_s1;
    wire [    2:0] fpga2sdram0_ar_size_s1;
    wire [ 37-1:0] fpga2sdram0_aw_addr_s1;
    wire [    1:0] fpga2sdram0_aw_burst_s1;
    wire [    3:0] fpga2sdram0_aw_cache_s1;
    wire [    3:0] fpga2sdram0_aw_id_s1;
    wire [    7:0] fpga2sdram0_aw_len_s1;
    wire [    2:0] fpga2sdram0_aw_prot_s1;
    wire [    3:0] fpga2sdram0_aw_qos_s1;
    wire [    2:0] fpga2sdram0_aw_size_s1;
    wire [128-1:0] fpga2sdram0_w_data_s1;
    wire [ 16-1:0] fpga2sdram0_w_strb_s1;
    
    wire [ 37-1:0] fpga2sdram1_ar_addr_s1;
    wire [    1:0] fpga2sdram1_ar_burst_s1;
    wire [    3:0] fpga2sdram1_ar_cache_s1;
    wire [    3:0] fpga2sdram1_ar_id_s1;
    wire [    7:0] fpga2sdram1_ar_len_s1;
    wire [    2:0] fpga2sdram1_ar_prot_s1;
    wire [    3:0] fpga2sdram1_ar_qos_s1;
    wire [    2:0] fpga2sdram1_ar_size_s1;
    wire [ 37-1:0] fpga2sdram1_aw_addr_s1;
    wire [    1:0] fpga2sdram1_aw_burst_s1;
    wire [    3:0] fpga2sdram1_aw_cache_s1;
    wire [    3:0] fpga2sdram1_aw_id_s1;
    wire [    7:0] fpga2sdram1_aw_len_s1;
    wire [    2:0] fpga2sdram1_aw_prot_s1;
    wire [    3:0] fpga2sdram1_aw_qos_s1;
    wire [    2:0] fpga2sdram1_aw_size_s1;
    wire [128-1:0] fpga2sdram1_w_data_s1;
    wire [ 16-1:0] fpga2sdram1_w_strb_s1;
    wire [ 37-1:0] fpga2sdram2_ar_addr_s1;
    wire [    1:0] fpga2sdram2_ar_burst_s1;
    wire [    3:0] fpga2sdram2_ar_cache_s1;
    wire [    3:0] fpga2sdram2_ar_id_s1;
    wire [    7:0] fpga2sdram2_ar_len_s1;
    wire [    2:0] fpga2sdram2_ar_prot_s1;
    wire [    3:0] fpga2sdram2_ar_qos_s1;
    wire [    2:0] fpga2sdram2_ar_size_s1;
    wire [ 37-1:0] fpga2sdram2_aw_addr_s1;
    wire [    1:0] fpga2sdram2_aw_burst_s1;
    wire [    3:0] fpga2sdram2_aw_cache_s1;
    wire [    3:0] fpga2sdram2_aw_id_s1;
    wire [    7:0] fpga2sdram2_aw_len_s1;
    wire [    2:0] fpga2sdram2_aw_prot_s1;
    wire [    3:0] fpga2sdram2_aw_qos_s1;
    wire [    2:0] fpga2sdram2_aw_size_s1;
    wire [128-1:0] fpga2sdram2_w_data_s1;
    wire [ 16-1:0] fpga2sdram2_w_strb_s1;
    
    wire           fpga2sdram0_ar_ready_s1;
    wire           fpga2sdram0_aw_ready_s1;
    wire           fpga2sdram0_b_valid_s1;
    wire           fpga2sdram0_r_last_s1;
    wire           fpga2sdram0_r_valid_s1;
    wire           fpga2sdram0_w_ready_s1;
    wire           fpga2sdram1_ar_ready_s1;
    wire           fpga2sdram1_aw_ready_s1;
    wire           fpga2sdram1_b_valid_s1;
    wire           fpga2sdram1_r_last_s1;
    wire           fpga2sdram1_r_valid_s1;
    wire           fpga2sdram1_w_ready_s1;
    wire           fpga2sdram2_ar_ready_s1;
    wire           fpga2sdram2_aw_ready_s1;
    wire           fpga2sdram2_b_valid_s1;
    wire           fpga2sdram2_r_last_s1;
    wire           fpga2sdram2_r_valid_s1;
    wire           fpga2sdram2_w_ready_s1;
    wire [    3:0] fpga2sdram0_b_id_s1;
    wire [    1:0] fpga2sdram0_b_resp_s1;
    wire [128-1:0] fpga2sdram0_r_data_s1;
    wire [    3:0] fpga2sdram0_r_id_s1;
    wire [    1:0] fpga2sdram0_r_resp_s1;
    wire [    3:0] fpga2sdram1_b_id_s1;
    wire [    1:0] fpga2sdram1_b_resp_s1;
    wire [128-1:0] fpga2sdram1_r_data_s1;
    wire [    3:0] fpga2sdram1_r_id_s1;
    wire [    1:0] fpga2sdram1_r_resp_s1;
    wire [    3:0] fpga2sdram2_b_id_s1;
    wire [    1:0] fpga2sdram2_b_resp_s1;
    wire [128-1:0] fpga2sdram2_r_data_s1;
    wire [    3:0] fpga2sdram2_r_id_s1;
    wire [    1:0] fpga2sdram2_r_resp_s1;

f2sdram_ready_latency_adapter f2s_sdram0_adapter (
    .ar_clk(f2s_sdram0_clk),     //                     input
    .ar_rst_n(f2s_sdram0_rst_n),     //                   input
    .aw_clk(f2s_sdram0_clk),     //                     input
    .aw_rst_n(f2s_sdram0_rst_n),     //                   input
    .b_clk(f2s_sdram0_clk),     //                      input
    .b_rst_n(f2s_sdram0_rst_n),     //                    input
    .r_clk(f2s_sdram0_clk),     //                      input
    .r_rst_n(f2s_sdram0_rst_n),     //                    input
    .w_clk(f2s_sdram0_clk),     //                      input
    .w_rst_n(f2s_sdram0_rst_n),     //                    input

    .ar_ready_latency(fpga2sdram0_ready_latency),     //           input [2:0]
    .ar_valid_latency(fpga2sdram0_ready_latency),     //           input [2:0]
    .aw_ready_latency(fpga2sdram0_ready_latency),     //           input [2:0]
    .aw_valid_latency(fpga2sdram0_ready_latency),     //           input [2:0]
    .w_ready_latency(fpga2sdram0_ready_latency),     //            input [2:0]
    .w_valid_latency(fpga2sdram0_ready_latency),     //            input [2:0]
    .r_ready_latency(fpga2sdram0_ready_latency),     //            input [2:0]
    .r_valid_latency(fpga2sdram0_ready_latency),     //            input [2:0]
    .b_ready_latency(fpga2sdram0_ready_latency),     //            input [2:0]
    .b_valid_latency(fpga2sdram0_ready_latency),     //            input [2:0]
    .ar_ready_s1(fpga2sdram0_ar_ready_s1),     //                input
    .ar_addr_m1(fpga2sdram0_ar_addr),     //                 input    [36:0]
    .ar_burst_m1(fpga2sdram0_ar_burst),     //                input     [1:0]
    .ar_cache_m1(fpga2sdram0_ar_cache),     //                input     [3:0]
    .ar_id_m1(fpga2sdram0_ar_id),     //                   input     [3:0]
    .ar_len_m1(fpga2sdram0_ar_len),     //                  input     [7:0]
    .ar_lock_m1(fpga2sdram0_ar_lock),     //                 input
    .ar_prot_m1(fpga2sdram0_ar_prot),     //                 input     [2:0]
    .ar_qos_m1(fpga2sdram0_ar_qos),     //                  input     [3:0]
    .ar_size_m1(fpga2sdram0_ar_size),     //                 input     [2:0]
    .ar_valid_m1(fpga2sdram0_ar_valid),     //                input
    
    .aw_ready_s1(fpga2sdram0_aw_ready_s1),     //                input
    .aw_addr_m1(fpga2sdram0_aw_addr),     //                 input    [36:0]
    .aw_burst_m1(fpga2sdram0_aw_burst),     //                input     [1:0]
    .aw_cache_m1(fpga2sdram0_aw_cache),     //                input     [3:0]
    .aw_id_m1(fpga2sdram0_aw_id),     //                   input     [3:0]
    .aw_len_m1(fpga2sdram0_aw_len),     //                  input     [7:0]
    .aw_lock_m1(fpga2sdram0_aw_lock),     //                 input
    .aw_prot_m1(fpga2sdram0_aw_prot),     //                 input     [2:0]
    .aw_qos_m1(fpga2sdram0_aw_qos),     //                  input     [3:0]
    .aw_size_m1(fpga2sdram0_aw_size),     //                 input     [2:0]
    .aw_valid_m1(fpga2sdram0_aw_valid),     //                input
    
    .w_data_m1(fpga2sdram0_w_data),     //                  input  [127:0]
    .w_last_m1(fpga2sdram0_w_last),     //                  input
    .w_strb_m1(fpga2sdram0_w_strb),     //                  input    [15:0]
    .w_valid_m1(fpga2sdram0_w_valid),     //                 input
    .w_ready_s1(fpga2sdram0_w_ready_s1),     //                 input
    
    .b_id_s1(fpga2sdram0_b_id_s1),     //                    input     [3:0]
    .b_resp_s1(fpga2sdram0_b_resp_s1),     //                  input     [1:0]
    .b_valid_s1(fpga2sdram0_b_valid_s1),     //                 input
    .b_ready_m1(fpga2sdram0_b_ready),     //                 input
    
    .r_data_s1(fpga2sdram0_r_data_s1),     //                  input   [127:0]
    .r_id_s1(fpga2sdram0_r_id_s1),     //                    input     [3:0]
    .r_last_s1(fpga2sdram0_r_last_s1),     //                  input
    .r_resp_s1(fpga2sdram0_r_resp_s1),     //                  input     [1:0]
    .r_valid_s1(fpga2sdram0_r_valid_s1),     //                 input
    .r_ready_m1(fpga2sdram0_r_ready),     //                 input
    
    .ar_addr_s1(fpga2sdram0_ar_addr_s1),     //                 output   [36:0]
    .ar_burst_s1(fpga2sdram0_ar_burst_s1),     //                output    [1:0]
    .ar_cache_s1(fpga2sdram0_ar_cache_s1),     //                output    [3:0]
    .ar_id_s1(fpga2sdram0_ar_id_s1),     //                   output    [3:0]
    .ar_len_s1(fpga2sdram0_ar_len_s1),     //                  output    [7:0]
    .ar_lock_s1(fpga2sdram0_ar_lock_s1),     //                 output
    .ar_prot_s1(fpga2sdram0_ar_prot_s1),     //                 output    [2:0]
    .ar_qos_s1(fpga2sdram0_ar_qos_s1),     //                  output    [3:0]
    .ar_size_s1(fpga2sdram0_ar_size_s1),     //                 output    [2:0]
    .ar_valid_s1(fpga2sdram0_ar_valid_s1),     //                output
    .ar_ready_m1(fpga2sdram0_ar_ready),     //                output
    
    .aw_addr_s1(fpga2sdram0_aw_addr_s1),     //                 output   [36:0]
    .aw_burst_s1(fpga2sdram0_aw_burst_s1),     //                output    [1:0]
    .aw_cache_s1(fpga2sdram0_aw_cache_s1),     //                output    [3:0]
    .aw_id_s1(fpga2sdram0_aw_id_s1),     //                   output    [3:0]
    .aw_len_s1(fpga2sdram0_aw_len_s1),     //                  output    [7:0]
    .aw_lock_s1(fpga2sdram0_aw_lock_s1),     //                 output
    .aw_prot_s1(fpga2sdram0_aw_prot_s1),     //                 output    [2:0]
    .aw_qos_s1(fpga2sdram0_aw_qos_s1),     //                  output    [3:0]
    .aw_size_s1(fpga2sdram0_aw_size_s1),     //                 output    [2:0]
    .aw_valid_s1(fpga2sdram0_aw_valid_s1),     //                output
    .aw_ready_m1(fpga2sdram0_aw_ready),     //                output
    
    .b_id_m1(fpga2sdram0_b_id),     //                    output    [3:0]
    .b_resp_m1(fpga2sdram0_b_resp),     //                  output    [1:0]
    .b_valid_m1(fpga2sdram0_b_valid),     //                 output
    .b_ready_s1(fpga2sdram0_b_ready_s1),     //                 output
    
    .r_data_m1(fpga2sdram0_r_data_full),     //                  output  [127:0]
    .r_id_m1(fpga2sdram0_r_id),     //                    output    [3:0]
    .r_last_m1(fpga2sdram0_r_last),     //                  output
    .r_resp_m1(fpga2sdram0_r_resp),     //                  output    [1:0]
    .r_valid_m1(fpga2sdram0_r_valid),     //                 output
    .r_ready_s1(fpga2sdram0_r_ready_s1),     //                 output
    
    .w_data_s1(fpga2sdram0_w_data_s1),     //                  output  [127:0]
    .w_last_s1(fpga2sdram0_w_last_s1),     //                  output
    .w_strb_s1(fpga2sdram0_w_strb_s1),     //                  output   [15:0]
    .w_valid_s1(fpga2sdram0_w_valid_s1),     //                 output
    .w_ready_m1(fpga2sdram0_w_ready)  //                         output
);


f2sdram_ready_latency_adapter f2s_sdram1_adapter (
    .ar_clk(f2s_sdram1_clk),     //                     input
    .ar_rst_n(f2s_sdram1_rst_n),     //                   input
    .aw_clk(f2s_sdram1_clk),     //                     input
    .aw_rst_n(f2s_sdram1_rst_n),     //                   input
    .b_clk(f2s_sdram1_clk),     //                      input
    .b_rst_n(f2s_sdram1_rst_n),     //                    input
    .r_clk(f2s_sdram1_clk),     //                      input
    .r_rst_n(f2s_sdram1_rst_n),     //                    input
    .w_clk(f2s_sdram1_clk),     //                      input
    .w_rst_n(f2s_sdram1_rst_n),     //                    input

    .ar_ready_latency(fpga2sdram1_ready_latency),     //           input [2:0]
    .ar_valid_latency(fpga2sdram1_ready_latency),     //           input [2:0]
    .aw_ready_latency(fpga2sdram1_ready_latency),     //           input [2:0]
    .aw_valid_latency(fpga2sdram1_ready_latency),     //           input [2:0]
    .w_ready_latency(fpga2sdram1_ready_latency),     //            input [2:0]
    .w_valid_latency(fpga2sdram1_ready_latency),     //            input [2:0]
    .r_ready_latency(fpga2sdram1_ready_latency),     //            input [2:0]
    .r_valid_latency(fpga2sdram1_ready_latency),     //            input [2:0]
    .b_ready_latency(fpga2sdram1_ready_latency),     //            input [2:0]
    .b_valid_latency(fpga2sdram1_ready_latency),     //            input [2:0]
    .ar_ready_s1(fpga2sdram1_ar_ready_s1),     //                input
    .ar_addr_m1(fpga2sdram1_ar_addr),     //                 input    [36:0]
    .ar_burst_m1(fpga2sdram1_ar_burst),     //                input     [1:0]
    .ar_cache_m1(fpga2sdram1_ar_cache),     //                input     [3:0]
    .ar_id_m1(fpga2sdram1_ar_id),     //                   input     [3:0]
    .ar_len_m1(fpga2sdram1_ar_len),     //                  input     [7:0]
    .ar_lock_m1(fpga2sdram1_ar_lock),     //                 input
    .ar_prot_m1(fpga2sdram1_ar_prot),     //                 input     [2:0]
    .ar_qos_m1(fpga2sdram1_ar_qos),     //                  input     [3:0]
    .ar_size_m1(fpga2sdram1_ar_size),     //                 input     [2:0]
    .ar_valid_m1(fpga2sdram1_ar_valid),     //                input
    
    .aw_ready_s1(fpga2sdram1_aw_ready_s1),     //                input
    .aw_addr_m1(fpga2sdram1_aw_addr),     //                 input    [36:0]
    .aw_burst_m1(fpga2sdram1_aw_burst),     //                input     [1:0]
    .aw_cache_m1(fpga2sdram1_aw_cache),     //                input     [3:0]
    .aw_id_m1(fpga2sdram1_aw_id),     //                   input     [3:0]
    .aw_len_m1(fpga2sdram1_aw_len),     //                  input     [7:0]
    .aw_lock_m1(fpga2sdram1_aw_lock),     //                 input
    .aw_prot_m1(fpga2sdram1_aw_prot),     //                 input     [2:0]
    .aw_qos_m1(fpga2sdram1_aw_qos),     //                  input     [3:0]
    .aw_size_m1(fpga2sdram1_aw_size),     //                 input     [2:0]
    .aw_valid_m1(fpga2sdram1_aw_valid),     //                input
    
    .w_data_m1(fpga2sdram1_w_data),     //                  input  [127:0]
    .w_last_m1(fpga2sdram1_w_last),     //                  input
    .w_strb_m1(fpga2sdram1_w_strb),     //                  input    [15:0]
    .w_valid_m1(fpga2sdram1_w_valid),     //                 input
    .w_ready_s1(fpga2sdram1_w_ready_s1),     //                 input
    
    .b_id_s1(fpga2sdram1_b_id_s1),     //                    input     [3:0]
    .b_resp_s1(fpga2sdram1_b_resp_s1),     //                  input     [1:0]
    .b_valid_s1(fpga2sdram1_b_valid_s1),     //                 input
    .b_ready_m1(fpga2sdram1_b_ready),     //                 input
    
    .r_data_s1(fpga2sdram1_r_data_s1),     //                  input   [127:0]
    .r_id_s1(fpga2sdram1_r_id_s1),     //                    input     [3:0]
    .r_last_s1(fpga2sdram1_r_last_s1),     //                  input
    .r_resp_s1(fpga2sdram1_r_resp_s1),     //                  input     [1:0]
    .r_valid_s1(fpga2sdram1_r_valid_s1),     //                 input
    .r_ready_m1(fpga2sdram1_r_ready),     //                 input
    
    .ar_addr_s1(fpga2sdram1_ar_addr_s1),     //                 output   [36:0]
    .ar_burst_s1(fpga2sdram1_ar_burst_s1),     //                output    [1:0]
    .ar_cache_s1(fpga2sdram1_ar_cache_s1),     //                output    [3:0]
    .ar_id_s1(fpga2sdram1_ar_id_s1),     //                   output    [3:0]
    .ar_len_s1(fpga2sdram1_ar_len_s1),     //                  output    [7:0]
    .ar_lock_s1(fpga2sdram1_ar_lock_s1),     //                 output
    .ar_prot_s1(fpga2sdram1_ar_prot_s1),     //                 output    [2:0]
    .ar_qos_s1(fpga2sdram1_ar_qos_s1),     //                  output    [3:0]
    .ar_size_s1(fpga2sdram1_ar_size_s1),     //                 output    [2:0]
    .ar_valid_s1(fpga2sdram1_ar_valid_s1),     //                output
    .ar_ready_m1(fpga2sdram1_ar_ready),     //                output
    
    .aw_addr_s1(fpga2sdram1_aw_addr_s1),     //                 output   [36:0]
    .aw_burst_s1(fpga2sdram1_aw_burst_s1),     //                output    [1:0]
    .aw_cache_s1(fpga2sdram1_aw_cache_s1),     //                output    [3:0]
    .aw_id_s1(fpga2sdram1_aw_id_s1),     //                   output    [3:0]
    .aw_len_s1(fpga2sdram1_aw_len_s1),     //                  output    [7:0]
    .aw_lock_s1(fpga2sdram1_aw_lock_s1),     //                 output
    .aw_prot_s1(fpga2sdram1_aw_prot_s1),     //                 output    [2:0]
    .aw_qos_s1(fpga2sdram1_aw_qos_s1),     //                  output    [3:0]
    .aw_size_s1(fpga2sdram1_aw_size_s1),     //                 output    [2:0]
    .aw_valid_s1(fpga2sdram1_aw_valid_s1),     //                output
    .aw_ready_m1(fpga2sdram1_aw_ready),     //                output
    
    .b_id_m1(fpga2sdram1_b_id),     //                    output    [3:0]
    .b_resp_m1(fpga2sdram1_b_resp),     //                  output    [1:0]
    .b_valid_m1(fpga2sdram1_b_valid),     //                 output
    .b_ready_s1(fpga2sdram1_b_ready_s1),     //                 output
    
    .r_data_m1(fpga2sdram1_r_data_full),     //                  output  [127:0]
    .r_id_m1(fpga2sdram1_r_id),     //                    output    [3:0]
    .r_last_m1(fpga2sdram1_r_last),     //                  output
    .r_resp_m1(fpga2sdram1_r_resp),     //                  output    [1:0]
    .r_valid_m1(fpga2sdram1_r_valid),     //                 output
    .r_ready_s1(fpga2sdram1_r_ready_s1),     //                 output
    
    .w_data_s1(fpga2sdram1_w_data_s1),     //                  output  [127:0]
    .w_last_s1(fpga2sdram1_w_last_s1),     //                  output
    .w_strb_s1(fpga2sdram1_w_strb_s1),     //                  output   [15:0]
    .w_valid_s1(fpga2sdram1_w_valid_s1),     //                 output
    .w_ready_m1(fpga2sdram1_w_ready)  //                         output
);


f2sdram_ready_latency_adapter f2s_sdram2_adapter (
    .ar_clk(f2s_sdram2_clk),     //                     input
    .ar_rst_n(f2s_sdram2_rst_n),     //                   input
    .aw_clk(f2s_sdram2_clk),     //                     input
    .aw_rst_n(f2s_sdram2_rst_n),     //                   input
    .b_clk(f2s_sdram2_clk),     //                      input
    .b_rst_n(f2s_sdram2_rst_n),     //                    input
    .r_clk(f2s_sdram2_clk),     //                      input
    .r_rst_n(f2s_sdram2_rst_n),     //                    input
    .w_clk(f2s_sdram2_clk),     //                      input
    .w_rst_n(f2s_sdram2_rst_n),     //                    input

    .ar_ready_latency(fpga2sdram2_ready_latency),     //           input [2:0]
    .ar_valid_latency(fpga2sdram2_ready_latency),     //           input [2:0]
    .aw_ready_latency(fpga2sdram2_ready_latency),     //           input [2:0]
    .aw_valid_latency(fpga2sdram2_ready_latency),     //           input [2:0]
    .w_ready_latency(fpga2sdram2_ready_latency),     //            input [2:0]
    .w_valid_latency(fpga2sdram2_ready_latency),     //            input [2:0]
    .r_ready_latency(fpga2sdram2_ready_latency),     //            input [2:0]
    .r_valid_latency(fpga2sdram2_ready_latency),     //            input [2:0]
    .b_ready_latency(fpga2sdram2_ready_latency),     //            input [2:0]
    .b_valid_latency(fpga2sdram2_ready_latency),     //            input [2:0]
    .ar_ready_s1(fpga2sdram2_ar_ready_s1),     //                input
    .ar_addr_m1(fpga2sdram2_ar_addr),     //                 input    [36:0]
    .ar_burst_m1(fpga2sdram2_ar_burst),     //                input     [1:0]
    .ar_cache_m1(fpga2sdram2_ar_cache),     //                input     [3:0]
    .ar_id_m1(fpga2sdram2_ar_id),     //                   input     [3:0]
    .ar_len_m1(fpga2sdram2_ar_len),     //                  input     [7:0]
    .ar_lock_m1(fpga2sdram2_ar_lock),     //                 input
    .ar_prot_m1(fpga2sdram2_ar_prot),     //                 input     [2:0]
    .ar_qos_m1(fpga2sdram2_ar_qos),     //                  input     [3:0]
    .ar_size_m1(fpga2sdram2_ar_size),     //                 input     [2:0]
    .ar_valid_m1(fpga2sdram2_ar_valid),     //                input
    
    .aw_ready_s1(fpga2sdram2_aw_ready_s1),     //                input
    .aw_addr_m1(fpga2sdram2_aw_addr),     //                 input    [36:0]
    .aw_burst_m1(fpga2sdram2_aw_burst),     //                input     [1:0]
    .aw_cache_m1(fpga2sdram2_aw_cache),     //                input     [3:0]
    .aw_id_m1(fpga2sdram2_aw_id),     //                   input     [3:0]
    .aw_len_m1(fpga2sdram2_aw_len),     //                  input     [7:0]
    .aw_lock_m1(fpga2sdram2_aw_lock),     //                 input
    .aw_prot_m1(fpga2sdram2_aw_prot),     //                 input     [2:0]
    .aw_qos_m1(fpga2sdram2_aw_qos),     //                  input     [3:0]
    .aw_size_m1(fpga2sdram2_aw_size),     //                 input     [2:0]
    .aw_valid_m1(fpga2sdram2_aw_valid),     //                input
    
    .w_data_m1(fpga2sdram2_w_data),     //                  input  [127:0]
    .w_last_m1(fpga2sdram2_w_last),     //                  input
    .w_strb_m1(fpga2sdram2_w_strb),     //                  input    [15:0]
    .w_valid_m1(fpga2sdram2_w_valid),     //                 input
    .w_ready_s1(fpga2sdram2_w_ready_s1),     //                 input
    
    .b_id_s1(fpga2sdram2_b_id_s1),     //                    input     [3:0]
    .b_resp_s1(fpga2sdram2_b_resp_s1),     //                  input     [1:0]
    .b_valid_s1(fpga2sdram2_b_valid_s1),     //                 input
    .b_ready_m1(fpga2sdram2_b_ready),     //                 input
    
    .r_data_s1(fpga2sdram2_r_data_s1),     //                  input   [127:0]
    .r_id_s1(fpga2sdram2_r_id_s1),     //                    input     [3:0]
    .r_last_s1(fpga2sdram2_r_last_s1),     //                  input
    .r_resp_s1(fpga2sdram2_r_resp_s1),     //                  input     [1:0]
    .r_valid_s1(fpga2sdram2_r_valid_s1),     //                 input
    .r_ready_m1(fpga2sdram2_r_ready),     //                 input
    
    .ar_addr_s1(fpga2sdram2_ar_addr_s1),     //                 output   [36:0]
    .ar_burst_s1(fpga2sdram2_ar_burst_s1),     //                output    [1:0]
    .ar_cache_s1(fpga2sdram2_ar_cache_s1),     //                output    [3:0]
    .ar_id_s1(fpga2sdram2_ar_id_s1),     //                   output    [3:0]
    .ar_len_s1(fpga2sdram2_ar_len_s1),     //                  output    [7:0]
    .ar_lock_s1(fpga2sdram2_ar_lock_s1),     //                 output
    .ar_prot_s1(fpga2sdram2_ar_prot_s1),     //                 output    [2:0]
    .ar_qos_s1(fpga2sdram2_ar_qos_s1),     //                  output    [3:0]
    .ar_size_s1(fpga2sdram2_ar_size_s1),     //                 output    [2:0]
    .ar_valid_s1(fpga2sdram2_ar_valid_s1),     //                output
    .ar_ready_m1(fpga2sdram2_ar_ready),     //                output
    
    .aw_addr_s1(fpga2sdram2_aw_addr_s1),     //                 output   [36:0]
    .aw_burst_s1(fpga2sdram2_aw_burst_s1),     //                output    [1:0]
    .aw_cache_s1(fpga2sdram2_aw_cache_s1),     //                output    [3:0]
    .aw_id_s1(fpga2sdram2_aw_id_s1),     //                   output    [3:0]
    .aw_len_s1(fpga2sdram2_aw_len_s1),     //                  output    [7:0]
    .aw_lock_s1(fpga2sdram2_aw_lock_s1),     //                 output
    .aw_prot_s1(fpga2sdram2_aw_prot_s1),     //                 output    [2:0]
    .aw_qos_s1(fpga2sdram2_aw_qos_s1),     //                  output    [3:0]
    .aw_size_s1(fpga2sdram2_aw_size_s1),     //                 output    [2:0]
    .aw_valid_s1(fpga2sdram2_aw_valid_s1),     //                output
    .aw_ready_m1(fpga2sdram2_aw_ready),     //                output
    
    .b_id_m1(fpga2sdram2_b_id),     //                    output    [3:0]
    .b_resp_m1(fpga2sdram2_b_resp),     //                  output    [1:0]
    .b_valid_m1(fpga2sdram2_b_valid),     //                 output
    .b_ready_s1(fpga2sdram2_b_ready_s1),     //                 output
    
    .r_data_m1(fpga2sdram2_r_data_full),     //                  output  [127:0]
    .r_id_m1(fpga2sdram2_r_id),     //                    output    [3:0]
    .r_last_m1(fpga2sdram2_r_last),     //                  output
    .r_resp_m1(fpga2sdram2_r_resp),     //                  output    [1:0]
    .r_valid_m1(fpga2sdram2_r_valid),     //                 output
    .r_ready_s1(fpga2sdram2_r_ready_s1),     //                 output
    
    .w_data_s1(fpga2sdram2_w_data_s1),     //                  output  [127:0]
    .w_last_s1(fpga2sdram2_w_last_s1),     //                  output
    .w_strb_s1(fpga2sdram2_w_strb_s1),     //                  output   [15:0]
    .w_valid_s1(fpga2sdram2_w_valid_s1),     //                 output
    .w_ready_m1(fpga2sdram2_w_ready)  //                         output
);



fourteennm_hps_interface_fpga2sdram f2sdram_rl(
    .f2s_sdram0_ar_clk(f2s_sdram0_clk),
    .f2s_sdram0_aw_clk(f2s_sdram0_clk),
    .f2s_sdram0_b_clk(f2s_sdram0_clk),
    .f2s_sdram0_clk(f2s_sdram0_clk),
    .f2s_sdram0_r_clk(f2s_sdram0_clk),
    .f2s_sdram0_w_clk(f2s_sdram0_clk),
    .f2s_sdram1_ar_clk(f2s_sdram1_clk),
    .f2s_sdram1_aw_clk(f2s_sdram1_clk),
    .f2s_sdram1_b_clk(f2s_sdram1_clk),
    .f2s_sdram1_clk(f2s_sdram1_clk),
    .f2s_sdram1_r_clk(f2s_sdram1_clk),
    .f2s_sdram1_w_clk(f2s_sdram1_clk),
    .f2s_sdram2_ar_clk(f2s_sdram2_clk),
    .f2s_sdram2_aw_clk(f2s_sdram2_clk),
    .f2s_sdram2_b_clk(f2s_sdram2_clk),
    .f2s_sdram2_clk(f2s_sdram2_clk),
    .f2s_sdram2_r_clk(f2s_sdram2_clk),
    .f2s_sdram2_w_clk(f2s_sdram2_clk),
    .fpga2sdram0_ar_lock(fpga2sdram0_ar_lock_s1),
    .fpga2sdram0_ar_valid(fpga2sdram0_ar_valid_s1),
    .fpga2sdram0_aw_lock(fpga2sdram0_aw_lock_s1),
    .fpga2sdram0_aw_valid(fpga2sdram0_aw_valid_s1),
    .fpga2sdram0_b_ready(fpga2sdram0_b_ready_s1),
    .fpga2sdram0_r_ready(fpga2sdram0_r_ready_s1),
    .fpga2sdram0_w_last(fpga2sdram0_w_last_s1),
    .fpga2sdram0_w_valid(fpga2sdram0_w_valid_s1),
    .fpga2sdram1_ar_lock(fpga2sdram1_ar_lock_s1),
    .fpga2sdram1_ar_valid(fpga2sdram1_ar_valid_s1),
    .fpga2sdram1_aw_lock(fpga2sdram1_aw_lock_s1),
    .fpga2sdram1_aw_valid(fpga2sdram1_aw_valid_s1),
    .fpga2sdram1_b_ready(fpga2sdram1_b_ready_s1),
    .fpga2sdram1_r_ready(fpga2sdram1_r_ready_s1),
    .fpga2sdram1_w_last(fpga2sdram1_w_last_s1),
    .fpga2sdram1_w_valid(fpga2sdram1_w_valid_s1),
    .fpga2sdram2_ar_lock(fpga2sdram2_ar_lock_s1),
    .fpga2sdram2_ar_valid(fpga2sdram2_ar_valid_s1),
    .fpga2sdram2_aw_lock(fpga2sdram2_aw_lock_s1),
    .fpga2sdram2_aw_valid(fpga2sdram2_aw_valid_s1),
    .fpga2sdram2_b_ready(fpga2sdram2_b_ready_s1),
    .fpga2sdram2_r_ready(fpga2sdram2_r_ready_s1),
    .fpga2sdram2_w_last(fpga2sdram2_w_last_s1),
    .fpga2sdram2_w_valid(fpga2sdram2_w_valid_s1),
    .fpga2sdram0_ar_addr(fpga2sdram0_ar_addr_s1),
    .fpga2sdram0_ar_burst(fpga2sdram0_ar_burst_s1),
    .fpga2sdram0_ar_cache(fpga2sdram0_ar_cache_s1),
    .fpga2sdram0_ar_id(fpga2sdram0_ar_id_s1),
    .fpga2sdram0_ar_len(fpga2sdram0_ar_len_s1),
    .fpga2sdram0_ar_prot(fpga2sdram0_ar_prot_s1),
    .fpga2sdram0_ar_qos(fpga2sdram0_ar_qos_s1),
    .fpga2sdram0_ar_size(fpga2sdram0_ar_size_s1),
    .fpga2sdram0_aw_addr(fpga2sdram0_aw_addr_s1),
    .fpga2sdram0_aw_burst(fpga2sdram0_aw_burst_s1),
    .fpga2sdram0_aw_cache(fpga2sdram0_aw_cache_s1),
    .fpga2sdram0_aw_id(fpga2sdram0_aw_id_s1),
    .fpga2sdram0_aw_len(fpga2sdram0_aw_len_s1),
    .fpga2sdram0_aw_prot(fpga2sdram0_aw_prot_s1),
    .fpga2sdram0_aw_qos(fpga2sdram0_aw_qos_s1),
    .fpga2sdram0_aw_size(fpga2sdram0_aw_size_s1),
    .fpga2sdram0_port_size_config(fpga2sdram0_port_size_config),
    .fpga2sdram0_w_data(fpga2sdram0_w_data_s1),
    .fpga2sdram0_w_strb(fpga2sdram0_w_strb_s1),
    .fpga2sdram1_ar_addr(fpga2sdram1_ar_addr_s1),
    .fpga2sdram1_ar_burst(fpga2sdram1_ar_burst_s1),
    .fpga2sdram1_ar_cache(fpga2sdram1_ar_cache_s1),
    .fpga2sdram1_ar_id(fpga2sdram1_ar_id_s1),
    .fpga2sdram1_ar_len(fpga2sdram1_ar_len_s1),
    .fpga2sdram1_ar_prot(fpga2sdram1_ar_prot_s1),
    .fpga2sdram1_ar_qos(fpga2sdram1_ar_qos_s1),
    .fpga2sdram1_ar_size(fpga2sdram1_ar_size_s1),
    .fpga2sdram1_aw_addr(fpga2sdram1_aw_addr_s1),
    .fpga2sdram1_aw_burst(fpga2sdram1_aw_burst_s1),
    .fpga2sdram1_aw_cache(fpga2sdram1_aw_cache_s1),
    .fpga2sdram1_aw_id(fpga2sdram1_aw_id_s1),
    .fpga2sdram1_aw_len(fpga2sdram1_aw_len_s1),
    .fpga2sdram1_aw_prot(fpga2sdram1_aw_prot_s1),
    .fpga2sdram1_aw_qos(fpga2sdram1_aw_qos_s1),
    .fpga2sdram1_aw_size(fpga2sdram1_aw_size_s1),
    .fpga2sdram1_port_size_config(fpga2sdram1_port_size_config),
    .fpga2sdram1_w_data(fpga2sdram1_w_data_s1),
    .fpga2sdram1_w_strb(fpga2sdram1_w_strb_s1),
    .fpga2sdram2_ar_addr(fpga2sdram2_ar_addr_s1),
    .fpga2sdram2_ar_burst(fpga2sdram2_ar_burst_s1),
    .fpga2sdram2_ar_cache(fpga2sdram2_ar_cache_s1),
    .fpga2sdram2_ar_id(fpga2sdram2_ar_id_s1),
    .fpga2sdram2_ar_len(fpga2sdram2_ar_len_s1),
    .fpga2sdram2_ar_prot(fpga2sdram2_ar_prot_s1),
    .fpga2sdram2_ar_qos(fpga2sdram2_ar_qos_s1),
    .fpga2sdram2_ar_size(fpga2sdram2_ar_size_s1),
    .fpga2sdram2_aw_addr(fpga2sdram2_aw_addr_s1),
    .fpga2sdram2_aw_burst(fpga2sdram2_aw_burst_s1),
    .fpga2sdram2_aw_cache(fpga2sdram2_aw_cache_s1),
    .fpga2sdram2_aw_id(fpga2sdram2_aw_id_s1),
    .fpga2sdram2_aw_len(fpga2sdram2_aw_len_s1),
    .fpga2sdram2_aw_prot(fpga2sdram2_aw_prot_s1),
    .fpga2sdram2_aw_qos(fpga2sdram2_aw_qos_s1),
    .fpga2sdram2_aw_size(fpga2sdram2_aw_size_s1),
    .fpga2sdram2_port_size_config(fpga2sdram2_port_size_config),
    .fpga2sdram2_w_data(fpga2sdram2_w_data_s1),
    .fpga2sdram2_w_strb(fpga2sdram2_w_strb_s1),
    .fpga2sdram0_ar_ready(fpga2sdram0_ar_ready_s1),
    .fpga2sdram0_aw_ready(fpga2sdram0_aw_ready_s1),
    .fpga2sdram0_b_valid(fpga2sdram0_b_valid_s1),
    .fpga2sdram0_r_last(fpga2sdram0_r_last_s1),
    .fpga2sdram0_r_valid(fpga2sdram0_r_valid_s1),
    .fpga2sdram0_w_ready(fpga2sdram0_w_ready_s1),
    .fpga2sdram1_ar_ready(fpga2sdram1_ar_ready_s1),
    .fpga2sdram1_aw_ready(fpga2sdram1_aw_ready_s1),
    .fpga2sdram1_b_valid(fpga2sdram1_b_valid_s1),
    .fpga2sdram1_r_last(fpga2sdram1_r_last_s1),
    .fpga2sdram1_r_valid(fpga2sdram1_r_valid_s1),
    .fpga2sdram1_w_ready(fpga2sdram1_w_ready_s1),
    .fpga2sdram2_ar_ready(fpga2sdram2_ar_ready_s1),
    .fpga2sdram2_aw_ready(fpga2sdram2_aw_ready_s1),
    .fpga2sdram2_b_valid(fpga2sdram2_b_valid_s1),
    .fpga2sdram2_r_last(fpga2sdram2_r_last_s1),
    .fpga2sdram2_r_valid(fpga2sdram2_r_valid_s1),
    .fpga2sdram2_w_ready(fpga2sdram2_w_ready_s1),
    .fpga2sdram0_b_id(fpga2sdram0_b_id_s1),
    .fpga2sdram0_b_resp(fpga2sdram0_b_resp_s1),
    .fpga2sdram0_r_data(fpga2sdram0_r_data_s1),
    .fpga2sdram0_r_id(fpga2sdram0_r_id_s1),
    .fpga2sdram0_r_resp(fpga2sdram0_r_resp_s1),
    .fpga2sdram1_b_id(fpga2sdram1_b_id_s1),
    .fpga2sdram1_b_resp(fpga2sdram1_b_resp_s1),
    .fpga2sdram1_r_data(fpga2sdram1_r_data_s1),
    .fpga2sdram1_r_id(fpga2sdram1_r_id_s1),
    .fpga2sdram1_r_resp(fpga2sdram1_r_resp_s1),
    .fpga2sdram2_b_id(fpga2sdram2_b_id_s1),
    .fpga2sdram2_b_resp(fpga2sdram2_b_resp_s1),
    .fpga2sdram2_r_data(fpga2sdram2_r_data_s1),
    .fpga2sdram2_r_id(fpga2sdram2_r_id_s1),
    .fpga2sdram2_r_resp(fpga2sdram2_r_resp_s1));
    
endmodule

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
`timescale 1 ps / 1 ps
module fourteennm_hps_rl_interface_fpga2hps #( parameter WDTH = 128 , parameter ADDR = 44 )(
    input  wire              clk,
    input  wire              ac_ready,
    input  wire              ar_lock,
    input  wire              ar_valid,
    input  wire              aw_lock,
    input  wire              aw_valid,
    input  wire              b_ready,
    input  wire              cd_last,
    input  wire              cd_valid,
    input  wire              cr_valid,
    input  wire              is_ace_port_config,
    input  wire              r_ack,
    input  wire              readylatency_port_config,
    input  wire              r_ready,
    input  wire              w_ack,
    input  wire              w_last,
    input  wire              w_valid,
    input  wire              rst_n,

    input  wire [  44-1:0] ar_addr,
    input  wire [       1:0] ar_bar,
    input  wire [       1:0] ar_burst,
    input  wire [       3:0] ar_cache,
    input  wire [       1:0] ar_domain,
    input  wire [       3:0] ar_id,
    input  wire [       7:0] ar_len,
    input  wire [       2:0] ar_prot,
    input  wire [       3:0] ar_qos,
    input  wire [       2:0] ar_size,
    input  wire [       3:0] ar_snoop,
    input  wire [  44-1:0] aw_addr,
    input  wire [       1:0] aw_bar,
    input  wire [       1:0] aw_burst,
    input  wire [       3:0] aw_cache,
    input  wire [       1:0] aw_domain,
    input  wire [       3:0] aw_id,
    input  wire [       7:0] aw_len,
    input  wire [       2:0] aw_prot,
    input  wire [       3:0] aw_qos,
    input  wire [       2:0] aw_size,
    input  wire [       2:0] aw_snoop,
    input  wire [128  -1:0] cd_data,
    input  wire [       4:0] cr_resp,
    input  wire [       9:0] rsb_sid,
    input  wire [       4:0] rsb_ssd,
    input  wire [128  -1:0] w_data,
    input  wire [       9:0] wsb_sid,
    input  wire [       4:0] wsb_ssd,
    input  wire [16-1:0] w_strb,
    input  wire [       2:0] ready_latency,
        
    output wire              ac_valid,
    output wire              ar_ready,
    output wire              aw_ready,
    output wire              b_valid,
    output wire              cd_ready,
    output wire              cr_ready,
    output wire              r_last,
    output wire              r_valid,
    output wire              w_ready,
    output wire [  ADDR-1:0] ac_addr,
    output wire [       2:0] ac_prot,
    output wire [       3:0] ac_snoop,
    output wire [       3:0] b_id,
    output wire [       1:0] b_resp,
    output wire [WDTH  -1:0] r_data,
    output wire [       3:0] r_id,
    output wire [       1:0] r_resp
);

    wire [43:0] ac_addr_full;
    assign ac_addr = ac_addr_full[ADDR-1:0];
    
    
    wire              ac_ready_s1;
    wire              ar_lock_s1;
    wire              ar_valid_s1;
    wire              aw_lock_s1;
    wire              aw_valid_s1;
    wire              b_ready_s1;
    wire              cd_last_s1;
    wire              cd_valid_s1;
    wire              cr_valid_s1;
    wire              r_ack_s1;
    wire              r_ready_s1;
    wire              w_ack_s1;
    wire              w_last_s1;
    wire              w_valid_s1;

    wire [    44-1:0] ar_addr_s1;
    wire [       1:0] ar_bar_s1;
    wire [       1:0] ar_burst_s1;
    wire [       3:0] ar_cache_s1;
    wire [       1:0] ar_domain_s1;
    wire [       3:0] ar_id_s1;
    wire [       7:0] ar_len_s1;
    wire [       2:0] ar_prot_s1;
    wire [       3:0] ar_qos_s1;
    wire [       2:0] ar_size_s1;
    wire [       3:0] ar_snoop_s1;
    wire [    44-1:0] aw_addr_s1;
    wire [       1:0] aw_bar_s1;
    wire [       1:0] aw_burst_s1;
    wire [       3:0] aw_cache_s1;
    wire [       1:0] aw_domain_s1;
    wire [       3:0] aw_id_s1;
    wire [       7:0] aw_len_s1;
    wire [       2:0] aw_prot_s1;
    wire [       3:0] aw_qos_s1;
    wire [       2:0] aw_size_s1;
    wire [       3:0] aw_snoop_s1;
    wire [ 128  -1:0] cd_data_s1;
    wire [       4:0] cr_resp_s1;
 // wire [       9:0] rsb_sid_s1;
 // wire [       4:0] rsb_ssd_s1;
    wire [ 128  -1:0] w_data_s1;
 // wire [       9:0] wsb_sid_s1;
 // wire [       4:0] wsb_ssd_s1;
    wire [    16-1:0] w_strb_s1;
        
    wire              ac_valid_s1;
    wire              ar_ready_s1;
    wire              aw_ready_s1;
    wire              b_valid_s1;
    wire              cd_ready_s1;
    wire              cr_ready_s1;
    wire              r_last_s1;
    wire              r_valid_s1;
    wire              w_ready_s1;
    wire [  44-1:0] ac_addr_s1;
    wire [       2:0] ac_prot_s1;
    wire [       3:0] ac_snoop_s1;
    wire [       3:0] b_id_s1;
    wire [       1:0] b_resp_s1;
    wire [128  -1:0] r_data_s1;
    wire [       3:0] r_id_s1;
    wire [       1:0] r_resp_s1;
    
    
f2s_ready_latency_adapter f2s_adapter (
    .ar_clk(clk),      //                        input
    .ar_rst_n(rst_n),      //                      input
    .aw_clk(clk),      //                        input
    .aw_rst_n(rst_n),      //                      input
    .b_clk(clk),      //                         input
    .b_rst_n(rst_n),      //                       input
    .r_clk(clk),      //                         input
    .r_rst_n(rst_n),      //                       input
    .w_clk(clk),      //                         input
    .w_rst_n(rst_n),      //                       input
    .ac_clk(clk),      //                        input
    .ac_rst_n(rst_n),      //                      input
    .cr_clk(clk),      //                        input
    .cr_rst_n(rst_n),      //                      input
    .cd_clk(clk),      //                        input
    .cd_rst_n(rst_n),      //                      input

    .ar_ready_latency(ready_latency),      //              input [2:0]
    .ar_valid_latency(ready_latency),      //              input [2:0]
    .aw_ready_latency(ready_latency),      //              input [2:0]
    .aw_valid_latency(ready_latency),      //              input [2:0]
    .w_ready_latency(ready_latency),      //               input [2:0]
    .w_valid_latency(ready_latency),      //               input [2:0]
    .r_ready_latency(ready_latency),      //               input [2:0]
    .r_valid_latency(ready_latency),      //               input [2:0]
    .b_ready_latency(ready_latency),      //               input [2:0]
    .b_valid_latency(ready_latency),      //               input [2:0]
    .ac_valid_latency(ready_latency),      //              input [2:0]
    .ac_ready_latency(ready_latency),      //              input [2:0]
    .cr_valid_latency(ready_latency),      //              input [2:0]
    .cr_ready_latency(ready_latency),      //              input [2:0]
    .cd_valid_latency(ready_latency),      //              input [2:0]
    .cd_ready_latency(ready_latency),      //              input [2:0]
    .ack_latency(ready_latency),      //                   input [2:0]


    .ar_ready_s1(ar_ready_s1),      //                   input
    .ar_addr_m1(ar_addr),      //                    input    [43:0]
    .ar_burst_m1(ar_burst),      //                   input     [1:0]
    .ar_cache_m1(ar_cache),      //                   input     [3:0]
    .ar_id_m1(ar_id),      //                      input     [3:0]
    .ar_len_m1(ar_len),      //                     input     [7:0]
    .ar_lock_m1(ar_lock),      //                    input
    .ar_prot_m1(ar_prot),      //                    input     [2:0]
    .ar_qos_m1(ar_qos),      //                     input     [3:0]
    .ar_size_m1(ar_size),      //                    input     [2:0]
    .ar_valid_m1(ar_valid),      //                   input
    .ar_domain_m1(ar_domain),      //                  input     [1:0]
    .ar_snoop_m1(ar_snoop),      //                   input     [3:0]
    .ar_bar_m1(ar_bar),      //                     input     [1:0]
                                       
    .aw_ready_s1(aw_ready_s1),      //                   input
    .aw_addr_m1(aw_addr),      //                    input    [43:0]
    .aw_burst_m1(aw_burst),      //                   input     [1:0]
    .aw_cache_m1(aw_cache),      //                   input     [3:0]
    .aw_id_m1(aw_id),      //                      input     [3:0]
    .aw_len_m1(aw_len),      //                     input     [7:0]
    .aw_lock_m1(aw_lock),      //                    input
    .aw_prot_m1(aw_prot),      //                    input     [2:0]
    .aw_qos_m1(aw_qos),      //                     input     [3:0]
    .aw_size_m1(aw_size),      //                    input     [2:0]
    .aw_valid_m1(aw_valid),      //                   input
    .aw_domain_m1(aw_domain),      //                  input     [1:0]
    .aw_snoop_m1({1'b0, aw_snoop}),      //                   input     [3:0]
    .aw_bar_m1(aw_bar),      //                     input     [1:0]
                                       
    .w_data_m1(w_data),      //                     input   [127:0]
    .w_last_m1(w_last),      //                     input
    .w_strb_m1(w_strb),      //                     input    [15:0]
    .w_valid_m1(w_valid),      //                    input
    .w_ready_s1(w_ready_s1),      //                    input
    .w_ack_m1(w_ack),      //                      input
                                       
    .b_id_s1(b_id_s1),      //                       input     [3:0]
    .b_resp_s1(b_resp_s1),      //                     input     [1:0]
    .b_valid_s1(b_valid_s1),      //                    input
    .b_ready_m1(b_ready),      //                    input
                                       
    .r_data_s1(r_data_s1),      //                     input   [127:0]
    .r_id_s1(r_id_s1),      //                       input     [3:0]
    .r_last_s1(r_last_s1),      //                     input
    .r_resp_s1(r_resp_s1),      //                     input     [1:0]
    .r_valid_s1(r_valid_s1),      //                    input
    .r_ready_m1(r_ready),      //                    input
    .r_ack_m1(r_ack),      //                      input
                                       
    .ac_ready_m1(ac_ready),      //                   input
    .ac_prot_s1 (ac_prot_s1),      //                   input [2:0]
    .ac_valid_s1(ac_valid_s1),      //                   input
    .ac_snoop_s1(ac_snoop_s1),      //                   input [3:0]
    .ac_addr_s1 (ac_addr_s1),      //                   input [43:0]
                                       
    .cr_ready_s1(cr_ready_s1),      //                   input
    .cr_valid_m1(cr_valid),      //                   input
    .cr_resp_m1 (cr_resp),      //                   input  [4:0]
                                       
    .cd_ready_s1(cd_ready_s1),      //                   input
    .cd_valid_m1(cd_valid),      //                   input
    .cd_data_m1 (cd_data),      //                   input  [127:0]
    .cd_last_m1 (cd_last),      //                   input
                                       
    .ar_addr_s1(ar_addr_s1),      //                    output   [43:0]
    .ar_burst_s1(ar_burst_s1),      //                   output    [1:0]
    .ar_cache_s1(ar_cache_s1),      //                   output    [3:0]
    .ar_id_s1(ar_id_s1),      //                      output    [3:0]
    .ar_len_s1(ar_len_s1),      //                     output    [7:0]
    .ar_lock_s1(ar_lock_s1),      //                    output
    .ar_prot_s1(ar_prot_s1),      //                    output    [2:0]
    .ar_qos_s1(ar_qos_s1),      //                     output    [3:0]
    .ar_size_s1(ar_size_s1),      //                    output    [2:0]
    .ar_valid_s1(ar_valid_s1),      //                   output
    .ar_ready_m1(ar_ready),      //                   output
    .ar_domain_s1(ar_domain_s1),      //                  output    [1:0]
    .ar_snoop_s1(ar_snoop_s1),      //                   output    [3:0]
    .ar_bar_s1(ar_bar_s1),      //                     output    [1:0]
                                       
    .aw_addr_s1(aw_addr_s1),      //                    output   [43:0]
    .aw_burst_s1(aw_burst_s1),      //                   output    [1:0]
    .aw_cache_s1(aw_cache_s1),      //                   output    [3:0]
    .aw_id_s1(aw_id_s1),      //                      output    [3:0]
    .aw_len_s1(aw_len_s1),      //                     output    [7:0]
    .aw_lock_s1(aw_lock_s1),      //                    output
    .aw_prot_s1(aw_prot_s1),      //                    output    [2:0]
    .aw_qos_s1(aw_qos_s1),      //                     output    [3:0]
    .aw_size_s1(aw_size_s1),      //                    output    [2:0]
    .aw_valid_s1(aw_valid_s1),      //                   output
    .aw_ready_m1(aw_ready),      //                   output
    .aw_domain_s1(aw_domain_s1),      //                  output    [1:0]
    .aw_snoop_s1(aw_snoop_s1),      //                   output    [3:0]
    .aw_bar_s1(aw_bar_s1),      //                     output    [1:0]
                                       
    .b_id_m1(b_id),      //                       output    [3:0]
    .b_resp_m1(b_resp),      //                     output    [1:0]
    .b_valid_m1(b_valid),      //                    output
    .b_ready_s1(b_ready_s1),      //                    output
                                       
    .r_data_m1(r_data),      //                     output  [127:0]
    .r_id_m1(r_id),      //                       output    [3:0]
    .r_last_m1(r_last),      //                     output
    .r_resp_m1(r_resp),      //                     output    [1:0]
    .r_valid_m1(r_valid),      //                    output
    .r_ready_s1(r_ready_s1),      //                    output
    .r_ack_s1(r_ack_s1),      //                      output
                                       
    .w_data_s1(w_data_s1),      //                     output  [127:0]
    .w_last_s1(w_last_s1),      //                     output
    .w_strb_s1(w_strb_s1),      //                     output   [15:0]
    .w_valid_s1(w_valid_s1),      //                    output
    .w_ready_m1(w_ready),      //                    output
    .w_ack_s1(w_ack_s1),      //                      output
                                       
    .ac_ready_s1(ac_ready_s1),      //                  output
    .ac_prot_m1(ac_prot),      //                  output [2:0]
    .ac_valid_m1(ac_valid),      //                  output
    .ac_snoop_m1(ac_snoop),      //                  output [3:0]
    .ac_addr_m1(ac_addr_full),      //                  output [43:0]
                                       
    .cr_ready_m1(cr_ready),      //                  output
    .cr_valid_s1(cr_valid_s1),      //                  output
    .cr_resp_s1(cr_resp_s1),      //                  output  [4:0]
                                       
    .cd_ready_m1(cd_ready),      //                  output
    .cd_valid_s1(cd_valid_s1),      //                  output
    .cd_data_s1(cd_data_s1),      //                  output  [127:0]
    .cd_last_s1(cd_last_s1)       //                  output
);


fourteennm_hps_interface_fpga2hps f2h_rl(
    .ac_clk(clk),
    .acready(ac_ready_s1),
    .ar_clk(clk),
    .arlock(ar_lock_s1),
    .arvalid(ar_valid_s1),
    .aw_clk(clk),
    .awlock(aw_lock_s1),
    .awvalid(aw_valid_s1),
    .b_clk(clk),
    .bready(b_ready_s1),
    .cd_clk(clk),
    .cdlast(cd_last_s1),
    .cdvalid(cd_valid_s1),
    .cr_clk(clk),
    .crvalid(cr_valid_s1),
    .is_ace_port_config_s(is_ace_port_config),
    .r_clk(clk),
    .rack(r_ack_s1),
    .readylatency_port_config(readylatency_port_config),
    .rready(r_ready_s1),
    .w_clk(clk),
    .wack(w_ack_s1),
    .wlast(w_last_s1),
    .wvalid(w_valid_s1),
    .araddr(ar_addr_s1),
    .arbar(ar_bar_s1),
    .arburst(ar_burst_s1),
    .arcache(ar_cache_s1),
    .ardomain(ar_domain_s1),
    .arid(ar_id_s1),
    .arlen(ar_len_s1),
    .arprot(ar_prot_s1),
    .arqos(ar_qos_s1),
    .arsize(ar_size_s1),
    .arsnoop(ar_snoop_s1),
    .awaddr(aw_addr_s1),
    .awbar(aw_bar_s1),
    .awburst(aw_burst_s1),
    .awcache(aw_cache_s1),
    .awdomain(aw_domain_s1),
    .awid(aw_id_s1),
    .awlen(aw_len_s1),
    .awprot(aw_prot_s1),
    .awqos(aw_qos_s1),
    .awsize(aw_size_s1),
    .awsnoop(aw_snoop_s1[2:0]),
    .cddata(cd_data_s1),
    .crresp(cr_resp_s1),
    .rsb_sid(rsb_sid),
    .rsb_ssd(rsb_ssd),
    .wdata(w_data_s1),
    .wsb_sid(wsb_sid),
    .wsb_ssd(wsb_ssd),
    .wstrb(w_strb_s1),
    .acvalid(ac_valid_s1),
    .arready(ar_ready_s1),
    .awready(aw_ready_s1),
    .bvalid(b_valid_s1),
    .cdready(cd_ready_s1),
    .crready(cr_ready_s1),
    .rlast(r_last_s1),
    .rvalid(r_valid_s1),
    .wready(w_ready_s1),
    .acaddr(ac_addr_s1),
    .acprot(ac_prot_s1),
    .acsnoop(ac_snoop_s1),
    .bid(b_id_s1),
    .bresp(b_resp_s1),
    .rdata(r_data_s1),
    .rid(r_id_s1),
    .rresp(r_resp_s1));
defparam f2h_rl.data_width = WDTH;

endmodule


 
//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
`timescale 1 ps / 1 ps
module fourteennm_hps_rl_interface_hps2fpga #(parameter WDTH = 16, parameter ADDR = 32 )(  
    input  wire             ar_ready,
    input  wire             aw_ready,
    input  wire             b_valid,
    input  wire             clk,
    input  wire             port_size_config_0,
    input  wire             port_size_config_1,
    input  wire             port_size_config_2,
    input  wire             r_last,
    input  wire             r_valid,
    input  wire             w_ready,
    input  wire  [     3:0] b_id,
    input  wire  [     1:0] b_resp,
    input  wire  [128-1:0] r_data,
    input  wire  [     3:0] r_id,
    input  wire  [     1:0] r_resp,
    input  wire             rst_n,
    input  wire  [     2:0] ready_latency,
        
    output wire               ar_lock,
    output wire               ar_valid,
    output wire               aw_lock,
    output wire               aw_valid,
    output wire               b_ready,
    output wire               r_ready,
    output wire               w_last,
    output wire               w_valid,
    output wire  [  ADDR-1:0] ar_addr,
    output wire  [       1:0] ar_burst,
    output wire  [       3:0] ar_cache,
    output wire  [       3:0] ar_id,
    output wire  [       7:0] ar_len,
    output wire  [       2:0] ar_prot,
    output wire  [       2:0] ar_size,
    output wire  [  ADDR-1:0] aw_addr,
    output wire  [       1:0] aw_burst,
    output wire  [       3:0] aw_cache,
    output wire  [       3:0] aw_id,
    output wire  [       7:0] aw_len,
    output wire  [       2:0] aw_prot,
    output wire  [       2:0] aw_size,
    output wire  [WDTH  -1:0] w_data,
    output wire  [WDTH/8-1:0] w_strb
);

    wire [ 31:0] ar_addr_full;
    wire [ 31:0] aw_addr_full;
    wire [127:0] w_data_full;
    wire [ 15:0] w_strb_full;
    
    assign ar_addr = ar_addr_full[ADDR-1:0];
    assign aw_addr = aw_addr_full[ADDR-1:0];
    assign w_data  = w_data_full[WDTH-1:0];
    assign w_strb  = w_strb_full[WDTH/8-1:0];

    wire             ar_ready_m1;
    wire             aw_ready_m1;
    wire             b_valid_m1;
    wire             r_last_m1;
    wire             r_valid_m1;
    wire             w_ready_m1;
    wire  [     3:0] b_id_m1;
    wire  [     1:0] b_resp_m1;
    wire  [128-1:0] r_data_m1;
    wire  [     3:0] r_id_m1;
    wire  [     1:0] r_resp_m1;
    
    wire               ar_lock_m1;
    wire               ar_valid_m1;
    wire               aw_lock_m1;
    wire               aw_valid_m1;
    wire               b_ready_m1;
    wire               r_ready_m1;
    wire               w_last_m1;
    wire               w_valid_m1;
    wire  [  32-1:0] ar_addr_m1;
    wire  [       1:0] ar_burst_m1;
    wire  [       3:0] ar_cache_m1;
    wire  [       3:0] ar_id_m1;
    wire  [       7:0] ar_len_m1;
    wire  [       2:0] ar_prot_m1;
    wire  [       2:0] ar_size_m1;
    wire  [  32-1:0] aw_addr_m1;
    wire  [       1:0] aw_burst_m1;
    wire  [       3:0] aw_cache_m1;
    wire  [       3:0] aw_id_m1;
    wire  [       7:0] aw_len_m1;
    wire  [       2:0] aw_prot_m1;
    wire  [       2:0] aw_size_m1;
    wire  [128  -1:0] w_data_m1;
    wire  [16-1:0] w_strb_m1;


h2f_ready_latency_adapter h2d_adapter(
    .ar_clk(clk),      //                     input           
    .ar_rst_n(rst_n),      //                   input           
    .aw_clk(clk),      //                     input           
    .aw_rst_n(rst_n),      //                   input           
    .b_clk(clk),      //                      input           
    .b_rst_n(rst_n),      //                    input           
    .r_clk(clk),      //                      input           
    .r_rst_n(rst_n),      //                    input           
    .w_clk(clk),      //                      input           
    .w_rst_n(rst_n),      //                    input           
                                                          
    .ar_ready_latency(ready_latency),      //           input [2:0]     
    .ar_valid_latency(ready_latency),      //           input [2:0]     
    .aw_ready_latency(ready_latency),      //           input [2:0]     
    .aw_valid_latency(ready_latency),      //           input [2:0]     
    .w_ready_latency(ready_latency),      //            input [2:0]     
    .w_valid_latency(ready_latency),      //            input [2:0]     
    .r_ready_latency(ready_latency),      //            input [2:0]     
    .r_valid_latency(ready_latency),      //            input [2:0]     
    .b_ready_latency(ready_latency),      //            input [2:0]     
    .b_valid_latency(ready_latency),      //            input [2:0]     
                                                          
    .ar_ready_s1(ar_ready),      //                input           
    .ar_addr_m1(ar_addr_m1),      //                 input    [31:0] 
    .ar_burst_m1(ar_burst_m1),      //                input     [1:0] 
    .ar_cache_m1(ar_cache_m1),      //                input     [3:0] 
    .ar_id_m1(ar_id_m1),      //                   input     [3:0] 
    .ar_len_m1(ar_len_m1),      //                  input     [7:0] 
    .ar_lock_m1(ar_lock_m1),      //                 input           
    .ar_prot_m1(ar_prot_m1),      //                 input     [2:0] 
    .ar_qos_m1(4'b0000),      //                  input     [3:0] 
    .ar_size_m1(ar_size_m1),      //                 input     [2:0] 
    .ar_valid_m1(ar_valid_m1),      //                input           
                                                          
    .aw_ready_s1(aw_ready),      //                input           
    .aw_addr_m1(aw_addr_m1),      //                 input    [31:0] 
    .aw_burst_m1(aw_burst_m1),      //                input     [1:0] 
    .aw_cache_m1(aw_cache_m1),      //                input     [3:0] 
    .aw_id_m1(aw_id_m1),      //                   input     [3:0] 
    .aw_len_m1(aw_len_m1),      //                  input     [7:0] 
    .aw_lock_m1(aw_lock_m1),      //                 input           
    .aw_prot_m1(aw_prot_m1),      //                 input     [2:0] 
    .aw_qos_m1(4'b0000),      //                  input     [3:0] 
    .aw_size_m1(aw_size_m1),      //                 input     [2:0] 
    .aw_valid_m1(aw_valid_m1),      //                input           
                                                          
    .w_data_m1(w_data_m1),      //                  input  [`-1:0]  
    .w_last_m1(w_last_m1),      //                  input           
    .w_strb_m1(w_strb_m1),      //                  input    [15:0] 
    .w_valid_m1(w_valid_m1),      //                 input           
    .w_ready_s1(w_ready),      //                 input           
                                                          
    .b_id_s1(b_id),      //                    input     [3:0] 
    .b_resp_s1(b_resp),      //                  input     [1:0] 
    .b_valid_s1(b_valid),      //                 input           
    .b_ready_m1(b_ready_m1),      //                 input           
                                                          
    .r_data_s1(r_data),      //                  input  [`-1:0]  
    .r_id_s1(r_id),      //                    input     [3:0] 
    .r_last_s1(r_last),      //                  input           
    .r_resp_s1(r_resp),      //                  input     [1:0] 
    .r_valid_s1(r_valid),      //                 input           
    .r_ready_m1(r_ready_m1),      //                 input           
                                                          
    .ar_addr_s1(ar_addr_full),      //                 output   [31:0] 
    .ar_burst_s1(ar_burst),      //                output    [1:0] 
    .ar_cache_s1(ar_cache),      //                output    [3:0] 
    .ar_id_s1(ar_id),      //                   output    [3:0] 
    .ar_len_s1(ar_len),      //                  output    [7:0] 
    .ar_lock_s1(ar_lock),      //                 output          
    .ar_prot_s1(ar_prot),      //                 output    [2:0] 
    .ar_qos_s1(),      //                  output    [3:0] 
    .ar_size_s1(ar_size),      //                 output    [2:0] 
    .ar_valid_s1(ar_valid),      //                output          
    .ar_ready_m1(ar_ready_m1),      //                output          
                                                          
    .aw_addr_s1(aw_addr_full),      //                 output   [31:0] 
    .aw_burst_s1(aw_burst),      //                output    [1:0] 
    .aw_cache_s1(aw_cache),      //                output    [3:0] 
    .aw_id_s1(aw_id),      //                   output    [3:0] 
    .aw_len_s1(aw_len),      //                  output    [7:0] 
    .aw_lock_s1(aw_lock),      //                 output          
    .aw_prot_s1(aw_prot),      //                 output    [2:0] 
    .aw_qos_s1(),      //                  output    [3:0] 
    .aw_size_s1(aw_size),      //                 output    [2:0] 
    .aw_valid_s1(aw_valid),      //                output          
    .aw_ready_m1(aw_ready_m1),      //                output          
                                                          
    .b_id_m1(b_id_m1),      //                    output    [3:0] 
    .b_resp_m1(b_resp_m1),      //                  output    [1:0] 
    .b_valid_m1(b_valid_m1),      //                 output          
    .b_ready_s1(b_ready),      //                 output          
                                                          
    .r_data_m1(r_data_m1),      //                  output   [-1:0] 
    .r_id_m1(r_id_m1),      //                    output    [3:0] 
    .r_last_m1(r_last_m1),      //                  output          
    .r_resp_m1(r_resp_m1),      //                  output    [1:0] 
    .r_valid_m1(r_valid_m1),      //                 output          
    .r_ready_s1(r_ready),      //                 output          
                                                          
    .w_data_s1(w_data_full),      //                  output  [`-1:0] 
    .w_last_s1(w_last),      //                  output          
    .w_strb_s1(w_strb_full),      //                  output   [15:0] 
    .w_valid_s1(w_valid),      //                 output          
    .w_ready_m1(w_ready_m1)       //                   output          
);            


fourteennm_hps_interface_hps2fpga h2f_rl(
    .ar_clk(clk),
    .ar_ready(ar_ready_m1),
    .aw_clk(clk),
    .aw_ready(aw_ready_m1),
    .b_clk(clk),
    .b_valid(b_valid_m1),
    .clk(clk),
    .port_size_config_0(port_size_config_0),
    .port_size_config_1(port_size_config_1),
    .port_size_config_2(port_size_config_2),
    .r_clk(clk),
    .r_last(r_last_m1),
    .r_valid(r_valid_m1),
    .w_clk(clk),
    .w_ready(w_ready_m1),
    .b_id(b_id_m1),
    .b_resp(b_resp_m1),
    .r_data(r_data_m1),
    .r_id(r_id_m1),
    .r_resp(r_resp_m1),
    .ar_lock(ar_lock_m1),
    .ar_valid(ar_valid_m1),
    .aw_lock(aw_lock_m1),
    .aw_valid(aw_valid_m1),
    .b_ready(b_ready_m1),
    .r_ready(r_ready_m1),
    .w_last(w_last_m1),
    .w_valid(w_valid_m1),
    .ar_addr(ar_addr_m1),
    .ar_burst(ar_burst_m1),
    .ar_cache(ar_cache_m1),
    .ar_id(ar_id_m1),
    .ar_len(ar_len_m1),
    .ar_prot(ar_prot_m1),
    .ar_size(ar_size_m1),
    .aw_addr(aw_addr_m1),
    .aw_burst(aw_burst_m1),
    .aw_cache(aw_cache_m1),
    .aw_id(aw_id_m1),
    .aw_len(aw_len_m1),
    .aw_prot(aw_prot_m1),
    .aw_size(aw_size_m1),
    .w_data(w_data_m1),
    .w_strb(w_strb_m1));
defparam h2f_rl.data_width = WDTH;

endmodule
 
//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
`timescale 1 ps / 1 ps
(* altera_attribute = "-name MESSAGE_DISABLE 16735" *)
module fourteennm_hps_rl_interface_hps2fpga_light_weight#(parameter WDTH = 16, parameter ADDR = 32 )
( 
    input  wire        ar_ready,
    input  wire        aw_ready,
    input  wire        b_valid,
    input  wire        clk,
    input  wire        port_size_config_0,
    input  wire        port_size_config_1,
    input  wire        r_last,
    input  wire        r_valid,
    input  wire        w_ready,
    input  wire        rst_n, 
    input  wire [ 3:0] b_id,
    input  wire [ 1:0] b_resp,
    input  wire [31:0] r_data,
    input  wire [ 3:0] r_id,
    input  wire [ 1:0] r_resp,
    input  wire [ 2:0] ready_latency,
    output wire        ar_lock,
    output wire        ar_valid,
    output wire        aw_lock,
    output wire        aw_valid,
    output wire        b_ready,
    output wire        r_ready,
    output wire        w_last,
    output wire        w_valid,
    output wire [ADDR-1:0] ar_addr,
    output wire [ 1:0] ar_burst,
    output wire [ 3:0] ar_cache,
    output wire [ 3:0] ar_id,
    output wire [ 7:0] ar_len,
    output wire [ 2:0] ar_prot,
    output wire [ 2:0] ar_size,
    output wire [ADDR-1:0] aw_addr,
    output wire [ 1:0] aw_burst,
    output wire [ 3:0] aw_cache,
    output wire [ 3:0] aw_id,
    output wire [ 7:0] aw_len,
    output wire [ 2:0] aw_prot,
    output wire [ 2:0] aw_size,
    output wire [31:0] w_data,
    output wire [ 3:0] w_strb
);

    wire [31:0] ar_addr_full;
    wire [31:0] aw_addr_full;
    assign ar_addr = ar_addr_full[ADDR-1:0];
    assign aw_addr = aw_addr_full[ADDR-1:0];

wire        ar_ready_m1;                  // input  
wire        aw_ready_m1;                  // input  
wire        b_valid_m1;                   // input  
wire        r_last_m1;                    // input  
wire        r_valid_m1;                   // input  
wire        w_ready_m1;                   // input  
wire [ 3:0] b_id_m1;                      // input  
wire [ 1:0] b_resp_m1;                    // input  
wire [31:0] r_data_m1;                    // input  
wire [ 3:0] r_id_m1;                      // input  
wire [ 1:0] r_resp_m1;                    // input  
wire        ar_lock_m1;                   // output 
wire        ar_valid_m1;                  // output 
wire        aw_lock_m1;                   // output 
wire        aw_valid_m1;                  // output 
wire        b_ready_m1;                   // output 
wire        r_ready_m1;                   // output 
wire        w_last_m1;                    // output 
wire        w_valid_m1;                   // output 
wire [32-1:0] ar_addr_m1;                   // output 
wire [ 1:0] ar_burst_m1;                  // output 
wire [ 3:0] ar_cache_m1;                  // output 
wire [ 3:0] ar_id_m1;                     // output 
wire [ 7:0] ar_len_m1;                    // output 
wire [ 2:0] ar_prot_m1;                   // output 
wire [ 2:0] ar_size_m1;                   // output 
wire [32-1:0] aw_addr_m1;                   // output 
wire [ 1:0] aw_burst_m1;                  // output 
wire [ 3:0] aw_cache_m1;                  // output 
wire [ 3:0] aw_id_m1;                     // output 
wire [ 7:0] aw_len_m1;                    // output 
wire [ 2:0] aw_prot_m1;                   // output 
wire [ 2:0] aw_size_m1;                   // output 
wire [31:0] w_data_m1;                    // output 
wire [ 3:0] w_strb_m1;                    // output 


lwbridge_ready_latency_adapter rl_adapter(
    .ar_clk(clk),
    .ar_rst_n(rst_n),
    .aw_clk(clk),
    .aw_rst_n(rst_n),
    .b_clk(clk),
    .b_rst_n(rst_n),
    .r_clk(clk),
    .r_rst_n(rst_n),
    .w_clk(clk),
    .w_rst_n(rst_n),
    
    .ar_ready_latency(ready_latency),      // input      [2:0]    
    .ar_valid_latency(ready_latency),      // input      [2:0]    
    .aw_ready_latency(ready_latency),      // input      [2:0]    
    .aw_valid_latency(ready_latency),      // input      [2:0]    
    .w_ready_latency(ready_latency),       // input      [2:0]    
    .w_valid_latency(ready_latency),       // input      [2:0]    
    .r_ready_latency(ready_latency),       // input      [2:0]    
    .r_valid_latency(ready_latency),       // input      [2:0]    
    .b_ready_latency(ready_latency),       // input      [2:0]    
    .b_valid_latency(ready_latency),       // input      [2:0]    
    .ar_ready_s1(ar_ready),           // input               
    .ar_addr_m1(ar_addr_m1),            // input         [31:0]
    .ar_burst_m1( ar_burst_m1 ),           // input          [1:0]
    .ar_cache_m1( ar_cache_m1 ),           // input          [3:0]
    .ar_id_m1( ar_id_m1 ),              // input          [3:0]
    .ar_len_m1( ar_len_m1 ),             // input          [7:0]
    .ar_lock_m1( ar_lock_m1 ),            // input               
    .ar_prot_m1(ar_prot_m1),            // input          [2:0]
    .ar_qos_m1(4'b0000),             // input          [3:0]
    .ar_size_m1(ar_size_m1),            // input          [2:0]
    .ar_valid_m1(ar_valid_m1),           // input               
    .aw_ready_s1(aw_ready),           // input               
    .aw_addr_m1(aw_addr_m1),            // input         [31:0]
    .aw_burst_m1(aw_burst_m1),           // input          [1:0]
    .aw_cache_m1(aw_cache_m1),           // input          [3:0]
    .aw_id_m1(aw_id_m1),              // input          [3:0]
    .aw_len_m1(aw_len_m1),             // input          [7:0]
    .aw_lock_m1(aw_lock_m1),            // input               
    .aw_prot_m1(aw_prot_m1),            // input          [2:0]
    .aw_qos_m1(4'b000),             // input          [3:0]
    .aw_size_m1(aw_size_m1),            // input          [2:0]
    .aw_valid_m1(aw_valid_m1),           // input               
    .w_data_m1(w_data_m1),             // input         [31:0]
    .w_last_m1(w_last_m1),             // input               
    .w_strb_m1(w_strb_m1),             // input          [3:0]
    .w_valid_m1(w_valid_m1),            // input               
    .w_ready_s1(w_ready),            // input               
    .b_id_s1(b_id),               // input          [3:0]
    .b_resp_s1(b_resp),             // input          [1:0]
    .b_valid_s1(b_valid),            // input               
    .b_ready_m1(b_ready_m1),            // input               
    .r_data_s1(r_data),             // input         [31:0]
    .r_id_s1(r_id),               // input          [3:0]
    .r_last_s1(r_last),             // input               
    .r_resp_s1(r_resp),             // input          [1:0]
    .r_valid_s1(r_valid),            // input               
    .r_ready_m1(r_ready_m1),            // input               
    .ar_addr_s1(ar_addr_full),            // output        [31:0]
    .ar_burst_s1(ar_burst),           // output         [1:0]
    .ar_cache_s1(ar_cache),           // output         [3:0]
    .ar_id_s1(ar_id),              // output         [3:0]
    .ar_len_s1(ar_len),             // output         [7:0]
    .ar_lock_s1(ar_lock),            // output              
    .ar_prot_s1(ar_prot),            // output         [2:0]
    .ar_qos_s1(),             // output         [3:0]
    .ar_size_s1(ar_size),            // output         [2:0]
    .ar_valid_s1(ar_valid),           // output              
    .ar_ready_m1(ar_ready_m1),           // output              
    .aw_addr_s1(aw_addr_full),            // output        [31:0]
    .aw_burst_s1(aw_burst),           // output         [1:0]
    .aw_cache_s1(aw_cache),           // output         [3:0]
    .aw_id_s1(aw_id),              // output         [3:0]
    .aw_len_s1(aw_len),             // output         [7:0]
    .aw_lock_s1(aw_lock),            // output              
    .aw_prot_s1(aw_prot),            // output         [2:0]
    .aw_qos_s1(),             // output         [3:0]
    .aw_size_s1(aw_size),            // output         [2:0]
    .aw_valid_s1(aw_valid),           // output              
    .aw_ready_m1(aw_ready_m1),           // output              
    .b_id_m1(b_id_m1),               // output         [3:0]
    .b_resp_m1(b_resp_m1),             // output         [1:0]
    .b_valid_m1(b_valid_m1),            // output              
    .b_ready_s1(b_ready),            // output              
    .r_data_m1(r_data_m1),             // output        [31:0]
    .r_id_m1(r_id_m1),               // output         [3:0]
    .r_last_m1(r_last_m1),             // output              
    .r_resp_m1(r_resp_m1),             // output         [1:0]
    .r_valid_m1(r_valid_m1),            // output              
    .r_ready_s1(r_ready),            // output              
    .w_data_s1(w_data),             // output        [31:0]
    .w_last_s1(w_last),             // output              
    .w_strb_s1(w_strb),             // output         [3:0]
    .w_valid_s1(w_valid),            // output              
    .w_ready_m1(w_ready_m1)             // output              
    
    );

fourteennm_hps_interface_hps2fpga_light_weight h2flw_rl(
    .ar_clk(clk),
    .ar_ready(ar_ready_m1),
    .aw_clk(clk),
    .aw_ready(aw_ready_m1),
    .b_clk(clk),
    .b_valid(b_valid_m1),
    .clk(clk),
    .port_size_config_0(port_size_config_0),
    .port_size_config_1(port_size_config_1),
    .r_clk(clk),
    .r_last(r_last_m1),
    .r_valid(r_valid_m1),
    .w_clk(clk),
    .w_ready(w_ready_m1),
    .b_id(b_id_m1),
    .b_resp(b_resp_m1),
    .r_data(r_data_m1),
    .r_id(r_id_m1),
    .r_resp(r_resp_m1),
    .ar_lock(ar_lock_m1),
    .ar_valid(ar_valid_m1),
    .aw_lock(aw_lock_m1),
    .aw_valid(aw_valid_m1),
    .b_ready(b_ready_m1),
    .r_ready(r_ready_m1),
    .w_last(w_last_m1),
    .w_valid(w_valid_m1),
    .ar_addr(ar_addr_m1),
    .ar_burst(ar_burst_m1),
    .ar_cache(ar_cache_m1),
    .ar_id(ar_id_m1),
    .ar_len(ar_len_m1),
    .ar_prot(ar_prot_m1),
    .ar_size(ar_size_m1),
    .aw_addr(aw_addr_m1),
    .aw_burst(aw_burst_m1),
    .aw_cache(aw_cache_m1),
    .aw_id(aw_id_m1),
    .aw_len(aw_len_m1),
    .aw_prot(aw_prot_m1),
    .aw_size(aw_size_m1),
    .w_data(w_data_m1),
    .w_strb(w_strb_m1));
endmodule





//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
`timescale 1 ps / 1 ps
module fourteennm_hps_ddr_atb (
    input  wire               at_resetm_atb_mpfe,
    input  wire               at_clk_atb_mpfe,
    input  wire               soc_debug_bridge_m_clken
);

wire          afvalidm;
wire          atreadym;
wire          syncreqm;
wire          afreadym;
wire          atvalidm;
wire [ 1 : 0] atbytesm;
wire [31 : 0] atdatam;
wire [ 6 : 0] atidm;

fourteennm_hps_mpfe_interface hmi(
    .afvalidm(afvalidm),
    .atclk_atb_mpfe(at_clk_atb_mpfe),
    .atreadym(atreadym),
    .atresetn_atb_mpfe(at_resetm_atb_mpfe),
    .soc_debug_bridge_m_clken(soc_debug_bridge_m_clken),
    .syncreqm(syncreqm),
    .afreadym(afreadym),
    .atvalidm(atvalidm),
    .atbytesm(atbytesm),
    .atdatam(atdatam),
    .atidm(atidm));
wire          afready_atb_mpfe;
wire          atvalid_atb_mpfe;
wire [ 1 : 0] atbytes_atb_mpfe;
wire [31 : 0] atdata_atb_mpfe;
wire [ 6 : 0] atid_atb_mpfe;
wire          afvalid_atb_mpfe;
wire          atready_atb_mpfe;
wire          syncreq_atb_mpfe;

fourteennm_hps_interface_mpfe mhi(
    .afready_atb_mpfe(afready_atb_mpfe),
    .atclk_atb_mpfe(at_clk_atb_mpfe),
    .atresetn_atb_mpfe(at_resetm_atb_mpfe),
    .atvalid_atb_mpfe(atvalid_atb_mpfe),
    .atbytes_atb_mpfe(atbytes_atb_mpfe),
    .atdata_atb_mpfe(atdata_atb_mpfe),
    .atid_atb_mpfe(atid_atb_mpfe),
    .afvalid_atb_mpfe(afvalid_atb_mpfe),
    .atready_atb_mpfe(atready_atb_mpfe),
    .syncreq_atb_mpfe(syncreq_atb_mpfe));


mpfe_atb_pipeline pipeline(
    .atclk(at_clk_atb_mpfe),
    .atrstn(at_resetm_atb_mpfe),
    .atbytes_m(atbytesm),
    .atdata_m(atdatam),
    .atid_m(atidm),
    .atvalid_m(atvalidm),
    .atready_m(atreadym),
    .afvalid_m(afvalidm),
    .afready_m(afreadym), 
    .syncreq_m(syncreqm),

    .atbytes_s(atbytes_atb_mpfe),
    .atdata_s(atdata_atb_mpfe),
    .atid_s(atid_atb_mpfe),
    .atvalid_s(afvalid_atb_mpfe),
    .atready_s(atready_atb_mpfe),
    .afvalid_s(afready_atb_mpfe),
    .afready_s(atvalid_atb_mpfe), 
    .syncreq_s(syncreq_atb_mpfe) );
endmodule


// Description:
// This is a simple four-stage pipeline for connecting the MPFE ATB 
// (AMBA Trace Bus) master port to the HPS slave port.  

module mpfe_atb_pipeline (
   input atclk,
   input atrstn,

   input  [1:0] atbytes_m,
   input [31:0] atdata_m,
   input  [6:0] atid_m,
   input        atvalid_m,
   output       atready_m,
 
   output       afvalid_m,
   input        afready_m, 

   output       syncreq_m,

   output  [1:0] atbytes_s,
   output [31:0] atdata_s,
   output  [6:0] atid_s,
   output        atvalid_s,
   input         atready_s,
 
   input        afvalid_s,
   output       afready_s, 

   input        syncreq_s );

   localparam DEPTH = 4;

   reg  [1:0] atbytes [DEPTH-1:0];
   reg [31:0] atdata  [DEPTH-1:0];
   reg  [6:0] atid    [DEPTH-1:0];
   reg        atvalid [DEPTH-1:0];
   reg        atready [DEPTH-1:0];
 
   reg        afvalid [DEPTH-1:0];
   reg        afready [DEPTH-1:0];

   reg        syncreq [DEPTH-1:0];

   genvar i; 

   generate
      for (i=0; i<DEPTH; i=i+1) begin  :  pipeline
         always @(posedge atclk or negedge atrstn) begin
            if ( ~atrstn ) begin
                  atvalid[i] <= 0;
                  atready[i] <= 0;

                  afvalid[i] <= 0;
                  afready[i] <= 0;
          
                  syncreq[i] <= 0;
            end else begin
               if (i==0) begin
                  atbytes[0] <= atbytes_m;
                  atdata[0]  <= atdata_m;
                  atid[0]    <= atid_m;
                  atvalid[0] <= atvalid_m;
                  atready[0] <= atready_s;
 
                  afvalid[0] <= afvalid_s;
                  afready[0] <= afready_m;

                  syncreq[0] <= syncreq_s;
               end else begin
                  atbytes[i] <= atbytes[i-1];
                  atdata[i]  <= atdata[i-1];
                  atid[i]    <= atid[i-1];
                  atvalid[i] <= atvalid[i-1];
                  atready[i] <= atready[i-1];
 
                  afvalid[i] <= afvalid[i-1];
                  afready[i] <= afready[i-1];

                  syncreq[i] <= syncreq[i-1];
               end
            end
         end
      end
   endgenerate 

   assign atready_m  = atready[DEPTH-1]; 
   assign afvalid_m  = afvalid[DEPTH-1]; 
   assign syncreq_m  = syncreq[DEPTH-1]; 
   assign atbytes_s  = atbytes[DEPTH-1];
   assign atdata_s   = atdata[DEPTH-1];
   assign atid_s     = atid[DEPTH-1];
   assign atvalid_s  = atvalid[DEPTH-1]; 
   assign afready_s  = afready[DEPTH-1];

endmodule

 
 
 
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "oDDtlXUtB+UysQe7FAoTjxcfb3pKKZZLrS5gWp3sw6TuLTYbGGPlXrXcZ7+F6YBIPhJ5h3QXHIHqEBi+fZrdQvw8PmpPHeXxhJPA5NrJCYxLypp3uyWIvknCrKDV5VajPhu/6EDgrGyy1jEOeS9sSoWBjvWqcpNUXK9nvlOUVIV0xIHfWjY+W8oSdfc6y5vPRe0I38rOdGy+yVCaj9K659/1ZRR/+WygUMQoj4RbOhHLh9EFC+r47p1O3SqxChCvezKYpk2lLLbE3cMegoR9jlCYGVf8Ld2Jj5UIsbIWRgXuwQ/k54tHiWVaXcxdCW6XBfRz9rQv1+81Ja/ENS330spIk4XQ9smEqQFUn295ldhPX51AfbFD6DOpA0apBNTaoukn29KoaNr3QytnpMmg1MPyzN31Um8JJGf9QSOSBiWOBRvsuCuxUIN55oucHHWVmNmyZBQibAbIctJNx8c1NQ/ClJIbLrrq9GbNSiM3Xr2Euaqk3MUP088ESC2f6Y0fAtzvzU/3sGVHONYPE7W4G2cXH+G9FvZOyE3ov855GMpks0v3/BxNLhZkYjPUDQST5wZj54e5bXAKRa9BSuBhkrZaKW0mRUcUca8J6fCT1QbfaoWmq+ZU12pUwVFy0Ot5xfaulv1RQiaW2cz/bwDVKUgK9Il4hZctw3CtSd5Vm7TvZqvOT/eXdNpSbcT6wd8OAR4GtyykxfV+e1GUm7FSu3r80S6ypwoDSenQXdJC6ESYLjPhtj64DpOkJegRqu3LZ603tWAy95ptpjo6Fwo4dbWFSh/17e7Y1e/wwcdA+XLb7TxuyRCgZsyCVAMD5ZbjPBqafXHBo518cUZuYuBKZC28nkZYIf3zNCtnMn89WKsiAfh1LrOY9nOIk8llXCvT8TWCvVkTzlQtoSn8BDCPkOUYEUWVNAcHUwcE5Q3dppmdjobHcmmz6avqd0OlN8gKI+XeREHQL7dZh4e1AcPJ94G9wTfRAUkzUq5qm/+LOnOkc+uSBuykRqBCsHjlW6JG"
`endif