// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module altera_emif_arch_nd_buf_udir_df_i # (
   parameter OCT_CONTROL_WIDTH = 1,
   parameter CALIBRATED_OCT = 1
) (
   input  logic i,
   input  logic ibar,
   output logic o,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_stc,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_ptc
);
   timeunit 1ns;
   timeprecision 1ps;
   
   generate
      if (CALIBRATED_OCT) 
      begin : cal_oct   
         fourteennm_io_ibuf  # (
            .differential_mode ("true")
         ) ibuf (
            .i(i),
            .ibar(ibar),
            .o(o),
            .seriesterminationcontrol(oct_stc),
            .parallelterminationcontrol(oct_ptc),
            .dynamicterminationcontrol()
            );
      end else 
      begin : no_oct
         fourteennm_io_ibuf  # (
            .differential_mode ("true")
         ) ibuf (
            .i(i),
            .ibar(ibar),
            .o(o),
            .seriesterminationcontrol(),
            .parallelterminationcontrol(),
            .dynamicterminationcontrol()
            );      
      end
   endgenerate      
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "oDDtlXUtB+UysQe7FAoTjxcfb3pKKZZLrS5gWp3sw6TuLTYbGGPlXrXcZ7+F6YBIPhJ5h3QXHIHqEBi+fZrdQvw8PmpPHeXxhJPA5NrJCYxLypp3uyWIvknCrKDV5VajPhu/6EDgrGyy1jEOeS9sSoWBjvWqcpNUXK9nvlOUVIV0xIHfWjY+W8oSdfc6y5vPRe0I38rOdGy+yVCaj9K659/1ZRR/+WygUMQoj4RbOhFB0K2UiAiAM7XvRfINEiIdhNV6+CFDj0Zl74WqLdSbFj/hf8n/hl69RhAHco6++o7b6jxez8op3orFhe/9P0qtujV+3RyrxLCzji7eG2W8vLWf/CbPYppF1ifI+vHppS2lcovGVhj2kJX2me9smSWpBhz0FmAFBdLbqPRbr/on1kax5jRm5QRWGLdk4vefyEwV0I2pEU3CGdLdq3qIJIDIVkgeFNGeXHxnJO75SIEdPgdp7S6HLB7k/orxuK+wTg96aWXJpPSEL5X/hPxwYb9RaPaBYVwG2ZLnwR8PYs+F7oFK7lC9SsvdBt+VJGBIgmjygx5MoDmrlptMgWR47ECM6amDlc1BP/u4JUitU5EQNYCae7/DWrkHzhnrVr3waJY7cn7h84VqSRXv1Xt2txuo1ggJgcfQrR5kTOL9gZXf2Pu/YEzi0UPzOtQnGNvq9/bfQb6hlkZAVVLHLfhyur6xoAeZR0VjjCyJAC73DcryuEhI7R5wB3HmDep4yur3pcsVZf79w3B/CXeRoJ58RAW0n/wdw8HK8WwU6MLsJ2sqpVPSre/eKUQJFcwIkRZSi5tYGkpV1Zhdpu3J97EZuOAVLLpMg47vU8EOiAGbAwimGPG0prsE/gMbTX+Ccm1BHn9dhseeOIyD2qhie8hkOUNO7KOduSe2rTNEeNV1m/Z/8eNUv607Q5dpkH8eSQlJaTdUEd2+Dsj7hiqZstaTvveRwR3sUEepM2BdogyQB3ES8Y/PenS+uF0cYnDveEGdfBmfLCklsgPv40mQDQOynjtY"
`endif