#****************************************************************************
#
# SPDX-License-Identifier: MIT-0
# Copyright(c) 2019-2021 Intel Corporation.
#
#****************************************************************************
#
# Sample SDC for Agilex GHRD.
#
#****************************************************************************

set_time_format -unit ns -decimal_places 3

# 100MHz board input clock, 133.3333MHz for EMIF refclk
create_clock -name MAIN_CLOCK -period 10 [get_ports CLK_100_B3L]
create_clock -name MAIN_CLOCK -period 40 [get_ports CLK_25_B3L]
create_clock -name EMIF_REF_CLOCK -period 30 [get_ports DDR4A_REFCLK_p]

# sourcing JTAG related SDC
source ./jtag.sdc
source ./tse.sdc


# FPGA IO port constraints
set_false_path -from [get_ports {BUTTON[0]}] -to *
set_false_path -from [get_ports {BUTTON[1]}] -to *
set_false_path -from [get_ports {SW[0]}] -to *
set_false_path -from [get_ports {SW[1]}] -to *
set_false_path -from * -to [get_ports {LED[0]}]
set_false_path -from * -to [get_ports {LED[1]}]



set_false_path -from * -to [ get_ports ENETB_RST_n ]
set_output_delay -clock MAIN_CLOCK 5 [ get_ports ENETB_RST_n ]

set_false_path -from [get_ports {FPGA_RST}] -to *

set_false_path -from * -to {soc_inst|rst_controller_*altera_reset_synchronizer_int_chain[1]}
