// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Fri Jul 25 15:52:36 2025
// ============================================================================

`define ENABLE_DDR4A
//`define ENABLE_DDR4B
//`define ENABLE_XCVR
`define ENABLE_HPS
//`define ENABLE_PCIE
//`define ENABLE_MCIO
//`define ENABLE_QSFPA
//`define ENABLE_QSFPB

module ghrd_s10_top(

      ///////// CLOCK /////////
      input              CLK_100_B3A,
      input              CLK_100_B3L,
      input              CLK_25_B3L,

      ///////// Buttons /////////
      input    [ 1: 0]   BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   SW,

      ///////// LED /////////
      output   [ 1: 0]   LED, //LED is Low-Active

      ///////// Reset /////////
      input              FPGA_RST,
      input              HPS_RST,

`ifdef ENABLE_DDR4A
      ///////// DDR4A /////////
      input              DDR4A_REFCLK_p,
      output   [16: 0]   DDR4A_A,
      output   [ 1: 0]   DDR4A_BA,
      output   [ 0: 0]   DDR4A_BG,
      output             DDR4A_CK,
      output             DDR4A_CK_n,
      output             DDR4A_CKE,
      inout    [ 7: 0]   DDR4A_DQS,
      inout    [ 7: 0]   DDR4A_DQS_n,
      inout    [63: 0]   DDR4A_DQ,
      inout    [ 7: 0]   DDR4A_DBI_n,
      output             DDR4A_CS_n,
      output             DDR4A_RESET_n,
      output             DDR4A_ODT,
      output             DDR4A_PAR,
      input              DDR4A_ALERT_n,
      output             DDR4A_ACT_n,
      input              DDR4A_RZQ,
`endif /*ENABLE_DDR4A*/

`ifdef ENABLE_DDR4B
      ///////// DDR4B /////////
      input              DDR4B_REFCLK_p,
      output   [16: 0]   DDR4B_A,
      output   [ 1: 0]   DDR4B_BA,
      output   [ 0: 0]   DDR4B_BG,
      output             DDR4B_CK,
      output             DDR4B_CK_n,
      output             DDR4B_CKE,
      inout    [ 7: 0]   DDR4B_DQS,
      inout    [ 7: 0]   DDR4B_DQS_n,
      inout    [63: 0]   DDR4B_DQ,
      inout    [ 7: 0]   DDR4B_DBI_n,
      output             DDR4B_CS_n,
      output             DDR4B_RESET_n,
      output             DDR4B_ODT,
      output             DDR4B_PAR,
      input              DDR4B_ALERT_n,
      output             DDR4B_ACT_n,
      input              DDR4B_RZQ,
`endif /*ENABLE_DDR4B*/

      ///////// USBFX3 /////////
      output             USBFX3_RESET_n,
      output             USBFX3_PCLK,
      output             USBFX3_CTL0_SLCS_n,
      output             USBFX3_UART_TX,
      input              USBFX3_UART_RX,
      output             USBFX3_CTL10,
      output             USBFX3_CTL11_A1,
      output             USBFX3_CTL12_A0,
      input              USBFX3_CTL15_INT_n,
      output             USBFX3_CTL1_SLWR_n,
      output             USBFX3_CTL2_SLOE_n,
      output             USBFX3_CTL3_SLRD_n,
      input              USBFX3_CTL4_FLAGA,
      input              USBFX3_CTL5_FLAGB,
      input              USBFX3_CTL6_FLAGC,
      output             USBFX3_CTL7_PKTEND_n,
      input              USBFX3_CTL8_FLAGD,
      output             USBFX3_CTL9,
      inout    [31: 0]   USBFX3_DQ,
      inout              USBFX3_OTG_ID,
      output             USBFX3_USB_MODE,

      ///////// ENETB /////////
      input              ENETB_RX_CLK,
      input    [ 7: 0]   ENETB_RX_DATA,
      input              ENETB_RX_COL,
      input              ENETB_RX_CRS,
      input              ENETB_RX_DV,
      input              ENETB_RX_ER,
      output             ENETB_GTX_CLK,
      output   [ 7: 0]   ENETB_TX_DATA,
      output             ENETB_TX_EN,
      output             ENETB_TX_ER,
      input              ENETB_INT_n,
      output             ENETB_MDC,
      inout              ENETB_MDIO,
      output             ENETB_RESET_n,

      ///////// I2C for EEPROM (Si5341) /////////
      inout              FPGA_I2C_SCL,
      inout              FPGA_I2C_SDA,

      ///////// Power Monitor /////////
      inout              PM_I2C_SCL,
      inout              PM_I2C_SDA,
      input              PM_ALERT_n,

`ifdef ENABLE_PCIE
      ///////// PCIe Edge /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      input              PCIE_REFCLK_p, //CLK2_XCVR_1C_p
      output   [15: 0]   PCIE_TX_p,
      input    [15: 0]   PCIE_RX_p,
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFPA
      ///////// QSFPA /////////
      input              QSFPA_REFCLK_p, //LGBTCLK2_1L_p
      output   [ 3: 0]   QSFPA_TX_p,
      input    [ 3: 0]   QSFPA_RX_p,
      input              QSFPA_INTERRUPT_n,
      output             QSFPA_LP_MODE,
      input              QSFPA_MOD_PRS_n,
      output             QSFPA_MOD_SEL_n,
      output             QSFPA_RST_n,
      inout              QSFPA_SCL,
      inout              QSFPA_SDA,
`endif /*ENABLE_QSFPA*/

`ifdef ENABLE_QSFPB
      ///////// QSFPB /////////
      input              QSFPB_REFCLK_p, //LGBTCLK1_1M_p
      output   [ 3: 0]   QSFPB_TX_p,
      input    [ 3: 0]   QSFPB_RX_p,
      input              QSFPB_INTERRUPT_n,
      output             QSFPB_LP_MODE,
      input              QSFPB_MOD_PRS_n,
      output             QSFPB_MOD_SEL_n,
      output             QSFPB_RST_n,
      inout              QSFPB_SCL,
      inout              QSFPB_SDA,
`endif /*ENABLE_QSFPB*/

`ifdef ENABLE_XCVR
      ///////// Transceiver reference clock /////////
      input              XCVR_REFCLK1D_p,
      input              XCVR_REFCLK1E_p,
      input              XCVR_REFCLK1K_p,
      input              XCVR_REFCLK1L_p,
      input              XCVR_REFCLK1M_p,
`endif /*ENABLE_XCVR*/

`ifdef ENABLE_MCIO
      ///////// MCIO /////////
      inout              MCIO_SMBCLK,
      inout              MCIO_SMBDAT,
      input              MCIO_CONN_CLK_p, //RGBTCLK0_1K_p
      output   [ 7: 0]   MCIO_TX_p,
      input    [ 7: 0]   MCIO_RX_p,
      input              MCIO_PERST_n,
      input              MCIO_SMB_ALERT_n,
`endif /*ENABLE_MCIO*/

      ///////// EXP /////////
      input              EXP_EN,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_EMMC_CLK,
      inout              HPS_EMMC_CMD,
      inout    [ 3: 0]   HPS_EMMC_DATA,
      output             HPS_ENETA_MDC,
      inout              HPS_ENETA_MDIO,
      input              HPS_ENETA_RX_CLK,
      input              HPS_ENETA_RX_CTL,
      input    [ 3: 0]   HPS_ENETA_RX_DATA,
      output             HPS_ENETA_TX_CLK,
      output             HPS_ENETA_TX_CTL,
      output   [ 3: 0]   HPS_ENETA_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      input              HPS_OSC_CLK,
      input              HPS_UART_CTS,
      output             HPS_UART_RTS,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);

wire         system_clk_100;
wire         system_clk_100_internal;
wire         ninit_done;
wire         fpga_reset_n_debounced_wire;
reg          fpga_reset_n_debounced;
wire         src_reset_n;
wire         system_reset_n;
wire         system_reset_sync;
wire         h2f_reset;
assign system_reset_n = fpga_reset_n_debounced & src_reset_n & ~h2f_reset & ~ninit_done;

altera_reset_synchronizer #(
		.ASYNC_RESET (1),
		.DEPTH       (2)
) sys_rst_inst (
		.reset_in  (~system_reset_n),
		.clk       (system_clk_100),
		.reset_out (system_reset_sync)
);

assign system_clk_100   = CLK_100_B3L;
assign system_clk_100_internal  = system_clk_100;

wire [2-1:0]   fpga_led_pio;
wire [2-1:0]   fpga_dipsw_pio;
wire [2-1:0]   fpga_button_pio;

assign LED = fpga_led_pio;
assign fpga_dipsw_pio = SW;
assign fpga_button_pio = BUTTON;

wire [1:0]     fpga_debounced_buttons;
wire [0:0]     fpga_led_internal;
wire           heartbeat_led;
reg  [24:0]    heartbeat_count;
assign fpga_led_pio = {heartbeat_led,fpga_led_internal};
assign heartbeat_led = ~heartbeat_count[24];

wire [31:0]    f2h_irq1_irq;

wire emac1_mdi_i, emac1_mdo_oe, emac1_mdo_o;
wire emac1_phy_irq;
wire emac1_phy_rst_n;
assign ENETB_MDIO  = emac1_mdo_oe ? emac1_mdo_o : 1'bz;
assign emac1_mdi_i = ENETB_MDIO;
assign emac1_phy_irq = ENETB_INT_n;
assign ENETB_RESET_n = emac1_phy_rst_n;
assign emac1_phy_rst_n = ~system_reset_sync;
wire [42:0]    stm_hw_events;
assign stm_hw_events    = 43'b0;
assign f2h_irq1_irq    = {31'b0, ~emac1_phy_irq};


// Qsys Top module
qsys_top soc_inst (
		.src_prb_rst_sources_source             (src_reset_n),
		.reset_reset_n                          (~system_reset_sync),
		.clk_100_clk                            (system_clk_100_internal),
		.ninit_done_ninit_done                  (ninit_done),
		.led_pio_external_connection_in_port    (fpga_led_internal),
		.led_pio_external_connection_out_port   (fpga_led_internal),
		.dipsw_pio_external_connection_export   (fpga_dipsw_pio),
		.button_pio_external_connection_export  (fpga_debounced_buttons),
		.s10_hps_f2h_stm_hw_events_stm_hwevents (stm_hw_events),
		.emif_hps_pll_ref_clk_clk               (DDR4A_REFCLK_p),
		.emif_hps_mem_mem_ck                    (DDR4A_CK),
		.emif_hps_mem_mem_ck_n                  (DDR4A_CK_n),
		.emif_hps_mem_mem_a                     (DDR4A_A),
		.emif_hps_mem_mem_act_n                 (DDR4A_ACT_n),
		.emif_hps_mem_mem_ba                    (DDR4A_BA),
		.emif_hps_mem_mem_bg                    (DDR4A_BG),
		.emif_hps_mem_mem_cke                   (DDR4A_CKE),
		.emif_hps_mem_mem_cs_n                  (DDR4A_CS_n),
		.emif_hps_mem_mem_odt                   (DDR4A_ODT),
		.emif_hps_mem_mem_reset_n               (DDR4A_RESET_n),
		.emif_hps_mem_mem_par                   (DDR4A_PAR),
		.emif_hps_mem_mem_alert_n               (DDR4A_ALERT_n),
		.emif_hps_mem_mem_dqs                   (DDR4A_DQS),
		.emif_hps_mem_mem_dqs_n                 (DDR4A_DQS_n),
		.emif_hps_mem_mem_dq                    (DDR4A_DQ),
		.emif_hps_mem_mem_dbi_n                 (DDR4A_DBI_n),
		.emif_hps_oct_oct_rzqin                 (DDR4A_RZQ),
		.hps_io_hps_io_phery_emac0_TX_CLK       (HPS_ENETA_TX_CLK),
		.hps_io_hps_io_phery_emac0_RX_CLK       (HPS_ENETA_RX_CLK),
		.hps_io_hps_io_phery_emac0_TX_CTL       (HPS_ENETA_TX_CTL),
		.hps_io_hps_io_phery_emac0_RX_CTL       (HPS_ENETA_RX_CTL),
		.hps_io_hps_io_phery_emac0_TXD0         (HPS_ENETA_TX_DATA[0]),
		.hps_io_hps_io_phery_emac0_TXD1         (HPS_ENETA_TX_DATA[1]),
		.hps_io_hps_io_phery_emac0_RXD0         (HPS_ENETA_RX_DATA[0]),
		.hps_io_hps_io_phery_emac0_RXD1         (HPS_ENETA_RX_DATA[1]),
		.hps_io_hps_io_phery_emac0_TXD2         (HPS_ENETA_TX_DATA[2]),
		.hps_io_hps_io_phery_emac0_TXD3         (HPS_ENETA_TX_DATA[3]),
		.hps_io_hps_io_phery_emac0_RXD2         (HPS_ENETA_RX_DATA[2]),
		.hps_io_hps_io_phery_emac0_RXD3         (HPS_ENETA_RX_DATA[3]),
		.hps_io_hps_io_phery_emac0_MDIO         (HPS_ENETA_MDIO),
		.hps_io_hps_io_phery_emac0_MDC          (HPS_ENETA_MDC),
		.hps_io_hps_io_phery_sdmmc_CCLK         (HPS_EMMC_CLK),
		.hps_io_hps_io_phery_sdmmc_CMD          (HPS_EMMC_CMD),
		.hps_io_hps_io_phery_sdmmc_D0           (HPS_EMMC_DATA[0]),
		.hps_io_hps_io_phery_sdmmc_D1           (HPS_EMMC_DATA[1]),
		.hps_io_hps_io_phery_sdmmc_D2           (HPS_EMMC_DATA[2]),
		.hps_io_hps_io_phery_sdmmc_D3           (HPS_EMMC_DATA[3]),
		.hps_io_hps_io_phery_i2c1_SDA           (HPS_I2C_SDA),
		.hps_io_hps_io_phery_i2c1_SCL           (HPS_I2C_SCL),
		.hps_io_hps_io_phery_uart0_RX           (HPS_UART_RX),
		.hps_io_hps_io_phery_uart0_TX           (HPS_UART_TX),
		.hps_io_hps_io_phery_uart0_CTS_N        (HPS_UART_CTS),
		.hps_io_hps_io_phery_uart0_RTS_N        (HPS_UART_RTS),
		.hps_io_hps_io_phery_usb0_CLK           (HPS_USB_CLK),
		.hps_io_hps_io_phery_usb0_STP           (HPS_USB_STP),
		.hps_io_hps_io_phery_usb0_DIR           (HPS_USB_DIR),
		.hps_io_hps_io_phery_usb0_NXT           (HPS_USB_NXT),
		.hps_io_hps_io_phery_usb0_DATA0         (HPS_USB_DATA[0]),
		.hps_io_hps_io_phery_usb0_DATA1         (HPS_USB_DATA[1]),
		.hps_io_hps_io_phery_usb0_DATA2         (HPS_USB_DATA[2]),
		.hps_io_hps_io_phery_usb0_DATA3         (HPS_USB_DATA[3]),
		.hps_io_hps_io_phery_usb0_DATA4         (HPS_USB_DATA[4]),
		.hps_io_hps_io_phery_usb0_DATA5         (HPS_USB_DATA[5]),
		.hps_io_hps_io_phery_usb0_DATA6         (HPS_USB_DATA[6]),
		.hps_io_hps_io_phery_usb0_DATA7         (HPS_USB_DATA[7]),
		.hps_io_hps_io_gpio_gpio1_io18          (HPS_GPIO[0]),
		.hps_io_hps_io_gpio_gpio1_io19          (HPS_GPIO[1]),
		.f2h_irq1_irq                           (f2h_irq1_irq),
		.emac1_phy_mac_speed_o                  (),                 
		.emac1_phy_txd_o                        (ENETB_TX_DATA),                     
		.emac1_phy_txen_o                       (ENETB_TX_EN),                       
		.emac1_phy_txer_o                       (ENETB_TX_ER),                      
		.emac1_phy_rxdv_i                       (ENETB_RX_DV),                     
		.emac1_phy_rxer_i                       (ENETB_RX_ER),                      
		.emac1_phy_rxd_i                        (ENETB_RX_DATA),                       
		.emac1_phy_col_i                        (ENETB_RX_COL),                        
		.emac1_phy_crs_i                        (ENETB_RX_CRS),                       
		.emac1_gmii_mdo_o                       (emac1_mdo_o),                       
		.emac1_gmii_mdo_o_e                     (emac1_mdo_oe),                  
		.emac1_gmii_mdi_i                       (emac1_mdi_i),                  
		.emac1_ptp_pps_o                        (),                       
		.emac1_ptp_aux_ts_trig_i                (1'b0),               
		.emac1_ptp_tstmp_data                   (),                   
		.emac1_ptp_tstmp_en                     (),                     
		.emac1_mdc_clk                          (ENETB_MDC),                          
		.emac1_rx_clk_in_clk                    (ENETB_RX_CLK),                    
		.emac1_tx_clk_in_clk                    (CLK_25_B3L),                    
		.emac1_gtx_clk_clk                      (ENETB_GTX_CLK),                     
		.h2f_reset_reset                        (h2f_reset),
		.hps_io_hps_io_hps_ocs_clk              (HPS_OSC_CLK)

);


// debounce fpga_reset_n
debounce fpga_reset_n_debounce_inst (
		.clk          (system_clk_100_internal),
		.reset_n      (~ninit_done),
		.data_in      (~FPGA_RST),
		.data_out     (fpga_reset_n_debounced_wire)
);
defparam fpga_reset_n_debounce_inst.WIDTH = 1;
defparam fpga_reset_n_debounce_inst.POLARITY = "LOW";
defparam fpga_reset_n_debounce_inst.TIMEOUT = 10000;               // at 100Mhz this is a debounce time of 1ms
defparam fpga_reset_n_debounce_inst.TIMEOUT_WIDTH = 32;            // ceil(log2(TIMEOUT))

always @ (posedge system_clk_100_internal or posedge ninit_done)
begin
    if (ninit_done == 1'b1)
        fpga_reset_n_debounced <= 1'b0;
    else
        fpga_reset_n_debounced <= fpga_reset_n_debounced_wire;
end

// Debounce logic to clean out glitches within 1ms
debounce debounce_inst (
		.clk          (system_clk_100_internal),
		.reset_n      (~system_reset_sync),
		.data_in      (fpga_button_pio),
		.data_out     (fpga_debounced_buttons)
);
defparam debounce_inst.WIDTH = 2;
defparam debounce_inst.POLARITY = "LOW";
defparam debounce_inst.TIMEOUT = 10000;               // at 100Mhz this is a debounce time of 1ms
defparam debounce_inst.TIMEOUT_WIDTH = 32;            // ceil(log2(TIMEOUT))

always @(posedge system_clk_100_internal or posedge system_reset_sync) begin
  if (system_reset_sync)
    heartbeat_count <= 25'd0;
  else
    heartbeat_count <= heartbeat_count + 25'd1;
end

endmodule
