// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Fri Apr 11 16:25:12 2025
// ============================================================================


`define ENABLE_DDR4A
`define ENABLE_DDR4B
//`define ENABLE_XCVR
//`define ENABLE_HPS
//`define ENABLE_PCIE
//`define ENABLE_MCIO
//`define ENABLE_QSFPA
//`define ENABLE_QSFPB

module golden_top(

      ///////// CLOCK /////////
      input              CLK_100_B3A,
      input              CLK_100_B3L,
      input              CLK_25_B3L,

      ///////// Buttons /////////
      input    [ 1: 0]   BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   SW,

      ///////// LED /////////
      output   [ 1: 0]   LED, //LED is Low-Active

      ///////// Reset /////////
      input              FPGA_RST,
      input              HPS_RST,

`ifdef ENABLE_DDR4A
      ///////// DDR4A /////////
      input              DDR4A_REFCLK_p,
      output   [16: 0]   DDR4A_A,
      output   [ 1: 0]   DDR4A_BA,
      output   [ 0: 0]   DDR4A_BG,
      output             DDR4A_CK,
      output             DDR4A_CK_n,
      output             DDR4A_CKE,
      inout    [ 7: 0]   DDR4A_DQS,
      inout    [ 7: 0]   DDR4A_DQS_n,
      inout    [63: 0]   DDR4A_DQ,
      inout    [ 7: 0]   DDR4A_DBI_n,
      output             DDR4A_CS_n,
      output             DDR4A_RESET_n,
      output             DDR4A_ODT,
      output             DDR4A_PAR,
      input              DDR4A_ALERT_n,
      output             DDR4A_ACT_n,
      input              DDR4A_RZQ,
`endif /*ENABLE_DDR4A*/

`ifdef ENABLE_DDR4B
      ///////// DDR4B /////////
      input              DDR4B_REFCLK_p,
      output   [16: 0]   DDR4B_A,
      output   [ 1: 0]   DDR4B_BA,
      output   [ 0: 0]   DDR4B_BG,
      output             DDR4B_CK,
      output             DDR4B_CK_n,
      output             DDR4B_CKE,
      inout    [ 7: 0]   DDR4B_DQS,
      inout    [ 7: 0]   DDR4B_DQS_n,
      inout    [63: 0]   DDR4B_DQ,
      inout    [ 7: 0]   DDR4B_DBI_n,
      output             DDR4B_CS_n,
      output             DDR4B_RESET_n,
      output             DDR4B_ODT,
      output             DDR4B_PAR,
      input              DDR4B_ALERT_n,
      output             DDR4B_ACT_n,
      input              DDR4B_RZQ,
`endif /*ENABLE_DDR4B*/

      ///////// USBFX3 /////////
      output             USBFX3_RESET_n,
      output             USBFX3_PCLK,
      output             USBFX3_CTL0_SLCS_n,
      output             USBFX3_UART_TX,
      input              USBFX3_UART_RX,
      output             USBFX3_CTL10,
      output             USBFX3_CTL11_A1,
      output             USBFX3_CTL12_A0,
      input              USBFX3_CTL15_INT_n,
      output             USBFX3_CTL1_SLWR_n,
      output             USBFX3_CTL2_SLOE_n,
      output             USBFX3_CTL3_SLRD_n,
      input              USBFX3_CTL4_FLAGA,
      input              USBFX3_CTL5_FLAGB,
      input              USBFX3_CTL6_FLAGC,
      output             USBFX3_CTL7_PKTEND_n,
      input              USBFX3_CTL8_FLAGD,
      output             USBFX3_CTL9,
      inout    [31: 0]   USBFX3_DQ,
      inout              USBFX3_OTG_ID,
      output             USBFX3_USB_MODE,

      ///////// ENETB /////////
      input              ENETB_RX_CLK,
      input    [ 7: 0]   ENETB_RX_DATA,
      input              ENETB_RX_COL,
      input              ENETB_RX_CRS,
      input              ENETB_RX_DV,
      input              ENETB_RX_ER,
      output             ENETB_GTX_CLK,
      output   [ 7: 0]   ENETB_TX_DATA,
      output             ENETB_TX_EN,
      output             ENETB_TX_ER,
      input              ENETB_INT_n,
      output             ENETB_MDC,
      inout              ENETB_MDIO,
      output             ENETB_RESET_n,

      ///////// I2C for EEPROM (Si5341) /////////
      inout              FPGA_I2C_SCL,
      inout              FPGA_I2C_SDA,

      ///////// Power Monitor /////////
      inout              PM_I2C_SCL,
      inout              PM_I2C_SDA,
      input              PM_ALERT_n,

`ifdef ENABLE_PCIE
      ///////// PCIe Edge /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      input              PCIE_REFCLK_p, //CLK2_XCVR_1C_p
      output   [15: 0]   PCIE_TX_p,
      input    [15: 0]   PCIE_RX_p,
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFPA
      ///////// QSFPA /////////
      input              QSFPA_REFCLK_p, //LGBTCLK2_1L_p
      output   [ 3: 0]   QSFPA_TX_p,
      input    [ 3: 0]   QSFPA_RX_p,
      input              QSFPA_INTERRUPT_n,
      output             QSFPA_LP_MODE,
      input              QSFPA_MOD_PRS_n,
      output             QSFPA_MOD_SEL_n,
      output             QSFPA_RST_n,
      inout              QSFPA_SCL,
      inout              QSFPA_SDA,
`endif /*ENABLE_QSFPA*/

`ifdef ENABLE_QSFPB
      ///////// QSFPB /////////
      input              QSFPB_REFCLK_p, //LGBTCLK1_1M_p
      output   [ 3: 0]   QSFPB_TX_p,
      input    [ 3: 0]   QSFPB_RX_p,
      input              QSFPB_INTERRUPT_n,
      output             QSFPB_LP_MODE,
      input              QSFPB_MOD_PRS_n,
      output             QSFPB_MOD_SEL_n,
      output             QSFPB_RST_n,
      inout              QSFPB_SCL,
      inout              QSFPB_SDA,
`endif /*ENABLE_QSFPB*/

`ifdef ENABLE_XCVR
      ///////// Transceiver reference clock /////////
      input              XCVR_REFCLK1D_p,
      input              XCVR_REFCLK1E_p,
      input              XCVR_REFCLK1K_p,
      input              XCVR_REFCLK1L_p,
      input              XCVR_REFCLK1M_p,
`endif /*ENABLE_XCVR*/

`ifdef ENABLE_MCIO
      ///////// MCIO /////////
      inout              MCIO_SMBCLK,
      inout              MCIO_SMBDAT,
      input              MCIO_CONN_CLK_p, //RGBTCLK0_1K_p
      output   [ 7: 0]   MCIO_TX_p,
      input    [ 7: 0]   MCIO_RX_p,
      input              MCIO_PERST_n,
      input              MCIO_SMB_ALERT_n,
`endif /*ENABLE_MCIO*/

      ///////// EXP /////////
      input              EXP_EN,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_EMMC_CLK,
      inout              HPS_EMMC_CMD,
      inout    [ 3: 0]   HPS_EMMC_DATA,
      output             HPS_ENETA_MDC,
      inout              HPS_ENETA_MDIO,
      input              HPS_ENETA_RX_CLK,
      input              HPS_ENETA_RX_CTL,
      input    [ 3: 0]   HPS_ENETA_RX_DATA,
      output             HPS_ENETA_TX_CLK,
      output             HPS_ENETA_TX_CTL,
      output   [ 3: 0]   HPS_ENETA_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      input              HPS_OSC_CLK,
      input              HPS_UART_CTS,
      output             HPS_UART_RTS,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);



//=======================================================
//  REG/WIRE declarations
//=======================================================




//=======================================================
//  Structural coding
//=======================================================


//=======================================================
//  REG/WIRE declarations
//=======================================================
///////////////////////////// DDR4 x2 Verify ////////////////////////////////
wire afi_clk_a; // clock for test controllers
wire afi_clk_b; // clock for test controllers

/// test status ..
//DDR4 Verify (A)
parameter DDR4A_AVALON_ADDR_W = 26;
parameter DDR4A_AVALON_DATA_W = 512;
parameter DDR4A_BYTE_ENABLE = 64;
wire ddr4a_test_pass/*synthesis keep*/;
wire ddr4a_test_fail/*synthesis keep*/;
wire ddr4a_test_complete/*synthesis keep*/;
wire ddr4a_local_cal_success/*synthesis keep*/;
wire ddr4a_local_cal_fail/*synthesis keep*/;

/// test status ..
//DDR4 Verify (B)
parameter DDR4B_AVALON_ADDR_W = 26;
parameter DDR4B_AVALON_DATA_W = 512;
parameter DDR4B_BYTE_ENABLE = 64;
wire ddr4b_test_pass/*synthesis keep*/;
wire ddr4b_test_fail/*synthesis keep*/;
wire ddr4b_test_complete/*synthesis keep*/;
wire ddr4b_local_cal_success/*synthesis keep*/;
wire ddr4b_local_cal_fail/*synthesis keep*/;

wire global_reset;	
wire global_reset_NIOS;	
//=======================================================
//  Structural coding
//=======================================================
reg [17:0] SEED_p = 18'h3f0ab;


wire reset_n;
assign reset_n = !ninit_done;
wire ninit_done;

    reset_release reset_release_Inst (
        .ninit_done (ninit_done)  //  output,  width = 1, ninit_done.ninit_done
    );




	edge_detector edge_detector_Inst(

		.iCLK(CLK_100_B3A),
		.iRST_n(reset_n),
		.iIn(!BUTTON[1]),
		.oFallING_EDGE(),
		.oRISING_EDGE(),
		.oDEBOUNCE_OUT(global_reset)
	);





    DDR4A DDR4A_Inst (
        .local_reset_req     (global_reset),     //   input,    width = 1,    local_reset_req.local_reset_req
        .local_reset_done    (ddr4a_reset_done),    //  output,    width = 1, local_reset_status.local_reset_done
        .pll_ref_clk         (DDR4A_REFCLK_p),         //   input,    width = 1,        pll_ref_clk.clk
        .oct_rzqin           (DDR4A_RZQ),           //   input,    width = 1,                oct.oct_rzqin
        .mem_ck              (DDR4A_CK),              //  output,    width = 1,                mem.mem_ck
        .mem_ck_n            (DDR4A_CK_n),            //  output,    width = 1,                   .mem_ck_n
        .mem_a               (DDR4A_A),               //  output,   width = 17,                   .mem_a
        .mem_act_n           (DDR4A_ACT_n),           //  output,    width = 1,                   .mem_act_n
        .mem_ba              (DDR4A_BA),              //  output,    width = 2,                   .mem_ba
        .mem_bg              (DDR4A_BG),              //  output,    width = 2,                   .mem_bg
        .mem_cke             (DDR4A_CKE),             //  output,    width = 1,                   .mem_cke
        .mem_cs_n            (DDR4A_CS_n),            //  output,    width = 1,                   .mem_cs_n
        .mem_odt             (DDR4A_ODT),             //  output,    width = 1,                   .mem_odt
        .mem_reset_n         (DDR4A_RESET_n),         //  output,    width = 1,                   .mem_reset_n
        .mem_par             (DDR4A_PAR),             //  output,    width = 1,                   .mem_par
        .mem_alert_n         (DDR4A_ALERT_n),         //   input,    width = 1,                   .mem_alert_n
        .mem_dqs             (DDR4A_DQS),             //   inout,    width = 8,                   .mem_dqs
        .mem_dqs_n           (DDR4A_DQS_n),           //   inout,    width = 8,                   .mem_dqs_n
        .mem_dq              (DDR4A_DQ),              //   inout,   width = 64,                   .mem_dq
        .mem_dbi_n           (DDR4A_DBI_n),           //   inout,    width = 8,                   .mem_dbi_n
        .local_cal_success   (ddr4a_local_cal_success),   //  output,    width = 1,             status.local_cal_success
        .local_cal_fail      (ddr4a_local_cal_fail),      //  output,    width = 1,                   .local_cal_fail
        .emif_usr_reset_n    (ddr4a_emif_usr_reset_n),    //  output,    width = 1,   emif_usr_reset_n.reset_n
        .emif_usr_clk        (afi_clk_a),        //  output,    width = 1,       emif_usr_clk.clk
        .amm_ready_0         (ddr4a_avl_ready),         //  output,    width = 1,         ctrl_amm_0.waitrequest_n
        .amm_read_0          (ddr4a_avl_read_req),          //   input,    width = 1,                   .read
        .amm_write_0         (ddr4a_avl_write_req),         //   input,    width = 1,                   .write
        .amm_address_0       (ddr4a_avl_addr),       //   input,   width = 27,                   .address
        .amm_readdata_0      (ddr4a_avl_rdata),      //  output,  width = 512,                   .readdata
        .amm_writedata_0     (ddr4a_avl_wdata),     //   input,  width = 512,                   .writedata
        .amm_burstcount_0    (ddr4a_avl_size),    //   input,    width = 7,                   .burstcount
        .amm_byteenable_0    ({DDR4A_BYTE_ENABLE{1'b1}}),    //   input,   width = 64,                   .byteenable
        .amm_readdatavalid_0 (ddr4a_avl_rdata_valid)  //  output,    width = 1,                   .readdatavalid
    );


/////////////////// DDR4(A) Test ///////////////////
wire         ddr4a_avl_ready;                  //          avl.waitrequest_n
wire [DDR4A_AVALON_ADDR_W-1:0]  ddr4a_avl_addr;                   //             .address
wire         ddr4a_avl_rdata_valid;            //             .readdatavalid
wire [DDR4A_AVALON_DATA_W-1:0] ddr4a_avl_rdata;                  //             .readdata
wire [DDR4A_AVALON_DATA_W-1:0] ddr4a_avl_wdata;                  //             .writedata
wire         ddr4a_avl_read_req;               //             .read
wire         ddr4a_avl_write_req;              //             .write
wire [6:0]   ddr4a_avl_size;                   //             .burstcount
wire 			 ddr4a_emif_usr_reset_n;
wire 			 ddr4a_reset_done;	 
	 
Avalon_bus_RW_Test DDR4A_Verify(
		    .iCLK(afi_clk_a),
		    .iRST_n(ddr4a_emif_usr_reset_n ),
		    .insert_error(BUTTON[0]),
			 .SEED_p({SEED_p,SEED_p}),
			 
		    .local_init_done(ddr4a_local_cal_success),
		    .avl_waitrequest_n(ddr4a_avl_ready),                 
		    .avl_address(ddr4a_avl_addr),                      
		    .avl_readdatavalid(ddr4a_avl_rdata_valid),                 
		    .avl_readdata(ddr4a_avl_rdata),                      
		    .avl_writedata(ddr4a_avl_wdata),                     
		    .avl_read(ddr4a_avl_read_req),                          
		    .avl_write(ddr4a_avl_write_req),    
		    .avl_size(ddr4a_avl_size),
		
		    .drv_status_pass(ddr4a_test_pass),
		    .drv_status_fail(ddr4a_test_fail),
		    .drv_status_test_complete(ddr4a_test_complete)
		
);
defparam DDR4A_Verify.ADDR_W = DDR4A_AVALON_ADDR_W;
defparam DDR4A_Verify.DATA_W = DDR4A_AVALON_DATA_W;

	 
	 
	 
	 
    DDR4B DDR4B_Inst (
        .local_reset_req     (global_reset),     //   input,    width = 1,    local_reset_req.local_reset_req
        .local_reset_done    (ddr4b_reset_done),    //  output,    width = 1, local_reset_status.local_reset_done
        .pll_ref_clk         (DDR4B_REFCLK_p),         //   input,    width = 1,        pll_ref_clk.clk
        .oct_rzqin           (DDR4B_RZQ),           //   input,    width = 1,                oct.oct_rzqin
        .mem_ck              (DDR4B_CK),              //  output,    width = 1,                mem.mem_ck
        .mem_ck_n            (DDR4B_CK_n),            //  output,    width = 1,                   .mem_ck_n
        .mem_a               (DDR4B_A),               //  output,   width = 17,                   .mem_a
        .mem_act_n           (DDR4B_ACT_n),           //  output,    width = 1,                   .mem_act_n
        .mem_ba              (DDR4B_BA),              //  output,    width = 2,                   .mem_ba
        .mem_bg              (DDR4B_BG),              //  output,    width = 2,                   .mem_bg
        .mem_cke             (DDR4B_CKE),             //  output,    width = 1,                   .mem_cke
        .mem_cs_n            (DDR4B_CS_n),            //  output,    width = 1,                   .mem_cs_n
        .mem_odt             (DDR4B_ODT),             //  output,    width = 1,                   .mem_odt
        .mem_reset_n         (DDR4B_RESET_n),         //  output,    width = 1,                   .mem_reset_n
        .mem_par             (DDR4B_PAR),             //  output,    width = 1,                   .mem_par
        .mem_alert_n         (DDR4B_ALERT_n),         //   input,    width = 1,                   .mem_alert_n
        .mem_dqs             (DDR4B_DQS),             //   inout,    width = 8,                   .mem_dqs
        .mem_dqs_n           (DDR4B_DQS_n),           //   inout,    width = 8,                   .mem_dqs_n
        .mem_dq              (DDR4B_DQ),              //   inout,   width = 64,                   .mem_dq
        .mem_dbi_n           (DDR4B_DBI_n),           //   inout,    width = 8,                   .mem_dbi_n
        .local_cal_success   (ddr4b_local_cal_success),   //  output,    width = 1,             status.local_cal_success
        .local_cal_fail      (ddr4b_local_cal_fail),      //  output,    width = 1,                   .local_cal_fail
        .emif_usr_reset_n    (ddr4b_emif_usr_reset_n),    //  output,    width = 1,   emif_usr_reset_n.reset_n
        .emif_usr_clk        (afi_clk_b),        //  output,    width = 1,       emif_usr_clk.clk
        .amm_ready_0         (ddr4b_avl_ready),         //  output,    width = 1,         ctrl_amm_0.waitrequest_n
        .amm_read_0          (ddr4b_avl_read_req),          //   input,    width = 1,                   .read
        .amm_write_0         (ddr4b_avl_write_req),         //   input,    width = 1,                   .write
        .amm_address_0       (ddr4b_avl_addr),       //   input,   width = 27,                   .address
        .amm_readdata_0      (ddr4b_avl_rdata),      //  output,  width = 512,                   .readdata
        .amm_writedata_0     (ddr4b_avl_wdata),     //   input,  width = 512,                   .writedata
        .amm_burstcount_0    (ddr4b_avl_size),    //   input,    width = 7,                   .burstcount
        .amm_byteenable_0    ({DDR4B_BYTE_ENABLE{1'b1}}),    //   input,   width = 64,                   .byteenable
        .amm_readdatavalid_0 (ddr4b_avl_rdata_valid)  //  output,    width = 1,                   .readdatavalid
    );
	 
	 
///////////////// DDR4(B) Test ///////////////////
wire         ddr4b_avl_ready;                  //          avl.waitrequest_n
wire [DDR4B_AVALON_ADDR_W-1:0]  ddr4b_avl_addr;                   //             .address
wire         ddr4b_avl_rdata_valid;            //             .readdatavalid
wire [DDR4B_AVALON_DATA_W-1:0] ddr4b_avl_rdata;                  //             .readdata
wire [DDR4B_AVALON_DATA_W-1:0] ddr4b_avl_wdata;                  //             .writedata
wire         ddr4b_avl_read_req;               //             .read
wire         ddr4b_avl_write_req;              //             .write
wire [6:0]   ddr4b_avl_size;                   //             .burstcount
wire 			 ddr4b_emif_usr_reset_n;
wire 			 ddr4b_reset_done;


Avalon_bus_RW_Test DDR4B_Verify(
		    .iCLK(afi_clk_b),
		    .iRST_n(ddr4b_emif_usr_reset_n ),
		    .insert_error(BUTTON[0]),
			 .SEED_p({SEED_p,SEED_p}),
		
		    .local_init_done(ddr4b_local_cal_success),
		    .avl_waitrequest_n(ddr4b_avl_ready),                 
		    .avl_address(ddr4b_avl_addr),                      
		    .avl_readdatavalid(ddr4b_avl_rdata_valid),                 
		    .avl_readdata(ddr4b_avl_rdata),                      
		    .avl_writedata(ddr4b_avl_wdata),                     
		    .avl_read(ddr4b_avl_read_req),                          
		    .avl_write(ddr4b_avl_write_req),    
		    .avl_size(ddr4b_avl_size),
		
		    .drv_status_pass(ddr4b_test_pass),
		    .drv_status_fail(ddr4b_test_fail),
		    .drv_status_test_complete(ddr4b_test_complete)
		
);
defparam DDR4B_Verify.ADDR_W = DDR4B_AVALON_ADDR_W;
defparam DDR4B_Verify.DATA_W = DDR4B_AVALON_DATA_W;
	 
	 
	 
heart_beat  heart_beat_0 ( .CLK(CLK_100_B3A ),     .CLK_FREQ  (100_000_000) , . CK_1HZ (heart_led) );

assign LED[0] =  (ddr4a_local_cal_success) ?~(ddr4a_test_pass & ddr4a_test_complete):heart_led;
assign LED[1] =  (ddr4b_local_cal_success) ?~(ddr4b_test_pass & ddr4b_test_complete):heart_led;







endmodule
