// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module altera_emif_arch_nd_buf_udir_se_o #(
   parameter OCT_CONTROL_WIDTH = 1,
   parameter CALIBRATED_OCT = 1
) (
   input  logic i,
   output logic o,
   input  logic oe,
   input  logic emif_phy_in_a,
   input  logic emif_phy_in_b,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_stc,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_ptc
);
   timeunit 1ns;
   timeprecision 1ps;

   generate
      if (CALIBRATED_OCT) 
      begin : cal_oct
         fourteennm_io_obuf obuf (
            .i(i),
            .o(o),
            .seriesterminationcontrol(oct_stc),
            .parallelterminationcontrol(oct_ptc),
            .emif_phy_in({emif_phy_in_a, emif_phy_in_b}),
            .obar(),
            .oe(oe),
            .dynamicterminationcontrol(),
            .devoe()
            );    
      end else 
      begin : no_oct
         fourteennm_io_obuf obuf (
            .i(i),
            .o(o),
            .seriesterminationcontrol(),
            .parallelterminationcontrol(),
            .emif_phy_in({emif_phy_in_a, emif_phy_in_b}),
            .obar(),
            .oe(oe),
            .dynamicterminationcontrol(),
            .devoe()
            );    
      end
   endgenerate
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "oDDtlXUtB+UysQe7FAoTjxcfb3pKKZZLrS5gWp3sw6TuLTYbGGPlXrXcZ7+F6YBIPhJ5h3QXHIHqEBi+fZrdQvw8PmpPHeXxhJPA5NrJCYxLypp3uyWIvknCrKDV5VajPhu/6EDgrGyy1jEOeS9sSoWBjvWqcpNUXK9nvlOUVIV0xIHfWjY+W8oSdfc6y5vPRe0I38rOdGy+yVCaj9K659/1ZRR/+WygUMQoj4RbOhFW+LS/O6TgSLDlZxXqZkvCqbFbMZdaDd1Cv6/bwEeoVtWnwPVvR/f1/ILZ3pxnuxSFdKpgvwu6ficKdGNT80k7ACg5WDgKZTmZWjwyZV4YfBnKMCYxcw+NLcfRyqjfEeCh7h8khR2Uy8qwNuimCHGcfX2RjlxzWr2NV3N+kAmQ51tyEhwtC7HPEytdtOYUDeOeuqjLfPHcsMEOdzaePjUKlcnjLLqWjdlPSPM6Ubx5E9lpdBeGePNzZ6aRwxkbT2CojWAI8jS0mGS02WB+7r3xjuQZTLs445CkN/X2vGPzeAGPCpIFCavDp+0qU/rFfbrzxBjOFkiUI2Y4fHFe/zvFiFn2TrCWDwpZV3mmkjlo1eAWOUbYoyL25We3WZ5ARJSgxP4XsTwJnLc2mpDwOR4YiJ0i+ydWGD9Rlobx5NfEYtO2Efx1wTPcp6aSAwmn5eazZaslWY0eAz/f3RC6/A4ef8UfISAAEyGOUD7RX+br9RbzP1atHgFaKdVplbpuKIqGNhwP2k6URUPNG6I5qkdEHCzEe8NkBakujnFsGU3vD4JFoDOxfbs6UaXFZDNDjxwUgHclR+ZMSPXhmOOZ216myNCmkV7sqmSWwc89owo38Dul6ZLTzvhMjelbq3I4KqjC4O8FtPWZmX4EX3M/tZY4ltmb6Vnvr+rraN1o01rVOtMot1aMfco4xop1lOGwwzTmj8S2FM4oVGJH6oekxq1MliTkXJP4/hUQ/1646GzvEj7m1ry3iZhtzMgt2shXlzLKlRZM7FiHXyFBDF0TjPuR"
`endif