// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module altera_emif_arch_nd_buf_udir_cp_i # (
   parameter OCT_CONTROL_WIDTH = 1,
   parameter CALIBRATED_OCT = 1
) (
   input  logic i,
   input  logic ibar,
   output logic o,
   output logic obar,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_stc,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_ptc
);
   timeunit 1ns;
   timeprecision 1ps;
   
   generate
      if (CALIBRATED_OCT) 
      begin : cal_oct      
         fourteennm_io_ibuf ibuf(
            .i(i),
            .o(o),
            .ibar(),
            .seriesterminationcontrol(oct_stc),
            .parallelterminationcontrol(oct_ptc),
            .dynamicterminationcontrol()
            );
            
         fourteennm_io_ibuf ibuf_bar(
            .i(ibar),
            .o(obar),
            .ibar(),
            .seriesterminationcontrol(oct_stc),
            .parallelterminationcontrol(oct_ptc),
            .dynamicterminationcontrol()
            );
      end else 
      begin : no_oct
         fourteennm_io_ibuf ibuf(
            .i(i),
            .o(o),
            .ibar(),
            .seriesterminationcontrol(),
            .parallelterminationcontrol(),
            .dynamicterminationcontrol()
            );
            
         fourteennm_io_ibuf ibuf_bar(
            .i(ibar),
            .o(obar),
            .ibar(),
            .seriesterminationcontrol(),
            .parallelterminationcontrol(),
            .dynamicterminationcontrol()
            );      
      end
   endgenerate
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "oDDtlXUtB+UysQe7FAoTjxcfb3pKKZZLrS5gWp3sw6TuLTYbGGPlXrXcZ7+F6YBIPhJ5h3QXHIHqEBi+fZrdQvw8PmpPHeXxhJPA5NrJCYxLypp3uyWIvknCrKDV5VajPhu/6EDgrGyy1jEOeS9sSoWBjvWqcpNUXK9nvlOUVIV0xIHfWjY+W8oSdfc6y5vPRe0I38rOdGy+yVCaj9K659/1ZRR/+WygUMQoj4RbOhHMaGxTo8xTVFH/IfFnJA8TyDQ5y08DynUu7T2wYHIeYP+HGFjYiMk2IRiswfT3uGzXjlknntS6B1dBLau4c3z6cCrgjuCpMXfkQ3HDRf0CpIcxW/F9Q9kQnGchws0SxN0ouKpvlxMLB3JQ26TFIXribwgdJkqUjotyWm37sVW50iieZ9dk6G6cb1EtR3HxSdVVCS+XumKpICS6vaPXKnB0oDm9lih24flhgPWWykhJouX20RUP+Tc7VQLTTS0BekVNGaVbzFcBBdOMxMYWG6dqUkvqJ2tUII7SH/OHEYtM+XvDRkE9TRSm+VCtLlbrBjaRxi7w+ALPRW0vyR/T4pOF1Me0hXyG900i/QT59ZmZKRxfsLDJDY18j/jUXzvN3f+GwSjd0gla1I2YIGlsquTrnYShmUgSnS66Ok0rnglddNwQtDPMdSnlQK+QOBhEZPYcKBF+lJ/7m4bPLKRVMhrZUoXu5uy4TQTKMkPAygIadR0vLpkVN54kgaqDNM07m9x9q38qBLmxIGyhsTKDFRQPJbNh4v3rxQJ1mv6aAH8c/FyOHyosWw0mGd7dOfGY2ZBe4PnRJUF0ye9vLuWeKO0HCE9vi58Z6IeDfo2z23sIEBmrtTatWm55Yv38turU2q6WMtLdICARif26qBQyikYKAnHoSnJmUr5wOryjBkNEQFeowAj7Aqa4MAEwm1g7NIMJjiENuLQmSu6+Q03XIXGRqsrS+4rTbTlydo93ULmU5CgZ7Er1CD0USZBN8gIuD8UV6AFiszZHTgEQmZWtNP/j"
`endif