// ============================================================================
// Copyright (c) 2020 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  9F., No.176, Sec.2, Gongdao 5th Rd, East Dist, Hsinchu City, 30070. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================

// V1.0.0.0,   2021/12/04, richard init for MCDMA

#ifndef _INC_TERASIC_PCIE_MCDMA_H
#define _INC_TERASIC_PCIE_MCDMA_H

#include <stdint.h>
/* GNU C/C++ Compiler */
#if defined(__GNUC__)
#include <stdio.h>
#define __export
#define __cdecl
#define PCIE_LIB_NAME "./terasic_pcie_mcdma.so"
#else
#define PCIE_LIB_NAME "TERASIC_PCIE_MCDMA.DLL"
#define PCIE_LIB32_NAME "TERASIC_PCIE_MCDMA_32.DLL"
#endif

#ifdef __cplusplus
extern "C" {
#else
#include <stdbool.h>
#endif

#define PCIE_API __cdecl
typedef void* PCIE_HANDLE;
typedef uint64_t PCIE_ADDRESS;
typedef uint64_t PCIE_LOCAL_ADDRESS;


#define DEFAULT_PCIE_VID	 0x1172
#define DEFAULT_PCIE_DID	 0x0000
#define DEFAULT_PCIE_SUB_VID 0x0000
#define DEFAULT_PCIE_SUB_DID 0x0000

typedef enum {
	PCIE_BAR0 = 0,  // do not change it
	PCIE_BAR1,
	PCIE_BAR2,
	PCIE_BAR3,
	PCIE_BAR4,
	PCIE_BAR5
} PCIE_BAR;



#if 0
//================================================================================
// function prototype used for "static load library(.dll/.so)"
PCIE_HANDLE PCIE_API PCIE_Open(uint16_t wVendorID, uint16_t wDeviceID, uint16_t wSubVendorID, uint16_t wSubDeviceID, uint16_t wCardNum);
void PCIE_API PCIE_Close(PCIE_HANDLE hFPGA);
bool PCIE_API PCIE_Read32(PCIE_HANDLE hFPGA, PCIE_BAR PciBar, PCIE_ADDRESS PciAddress, uint32_t* pdwData);
bool PCIE_API PCIE_Write32(PCIE_HANDLE hFPGA, PCIE_BAR PciBar, PCIE_ADDRESS PciAddress, uint32_t dwData);
bool PCIE_API PCIE_DmaRead(PCIE_HANDLE hFPGA, PCIE_LOCAL_ADDRESS LocalAddress, void* pBuffer, uint64_t nBufSize64);
bool PCIE_API PCIE_DmaWrite(PCIE_HANDLE hFPGA, PCIE_LOCAL_ADDRESS LocalAddress, void* pData, uint64_t nDataSize64);
bool PCIE_API PCIE_ConfigRead32(PCIE_HANDLE hFPGA, uint32_t Offset, uint32_t* pData32);
bool PCIE_API PCIE_Read8(PCIE_HANDLE hFPGA, PCIE_BAR PciBar, PCIE_ADDRESS PciAddress, uint8_t* pByte);
bool PCIE_API PCIE_Write8(PCIE_HANDLE hFPGA, PCIE_BAR PciBar, PCIE_ADDRESS PciAddress, uint8_t Byte);
#else
//================================================================================
// function prototype used for "dynamic load library(.dll/.so)"
typedef PCIE_HANDLE(PCIE_API* LPPCIE_Open)(uint16_t wVendorID, uint16_t wDeviceID, uint16_t wSubVendorID, uint16_t wSubDeviceID, uint16_t wCardNum);
typedef void (PCIE_API* LPPCIE_Close)(PCIE_HANDLE hFPGA);
typedef bool (PCIE_API* LPPCIE_Read32)(PCIE_HANDLE hFPGA, PCIE_BAR PciBar, PCIE_ADDRESS PciAddress, uint32_t* pdwData);
typedef bool (PCIE_API* LPPCIE_Write32)(PCIE_HANDLE hFPGA, PCIE_BAR PciBar, PCIE_ADDRESS PciAddress, uint32_t dwData);
typedef bool (PCIE_API* LPPCIE_DmaRead) (PCIE_HANDLE hFPGA, PCIE_LOCAL_ADDRESS LocalAddress, void* pBuffer, uint64_t nBufSize64);
typedef bool (PCIE_API* LPPCIE_DmaWrite) (PCIE_HANDLE hFPGA, PCIE_LOCAL_ADDRESS LocalAddress, void* pData, uint64_t nDataSize64);
typedef bool (PCIE_API* LPPCIE_ConfigRead32) (PCIE_HANDLE hFPGA, uint32_t Offset, uint32_t* pData32);
typedef bool (PCIE_API* LPPCIE_Read8)(PCIE_HANDLE hFPGA, PCIE_BAR PciBar, PCIE_ADDRESS PciAddress, uint8_t* pByte);
typedef bool (PCIE_API* LPPCIE_Write8)(PCIE_HANDLE hFPGA, PCIE_BAR PciBar, PCIE_ADDRESS PciAddress, uint8_t Byte);
#endif

#ifdef __cplusplus
}
#endif

#endif /* _INC_TERASIC_PCIE_MCDMA_H */

