// pcie_ed_PIO_INTERPRETER.v

// Generated using ACDS version 24.3 212

`timescale 1 ps / 1 ps
module pcie_ed_PIO_INTERPRETER (
		input  wire         clk_i,               //            clock.clk
		input  wire         reset_i,             //            reset.reset
		input  wire         bam_read_i,          //   AVMM_BAM_Slave.read
		input  wire         bam_write_i,         //                 .write
		input  wire [29:0]  bam_address_i,       //                 .address
		input  wire [3:0]   bam_burstcount_i,    //                 .burstcount
		input  wire [63:0]  bam_byteenable_i,    //                 .byteenable
		input  wire [511:0] bam_writedata_i,     //                 .writedata
		output wire         bam_waitrequest_o,   //                 .waitrequest
		output wire [511:0] bam_readdata_o,      //                 .readdata
		output wire         bam_readdatavalid_o, //                 .readdatavalid
		output wire [1:0]   bam_response_o,      //                 .response
		output wire         bam_vfactive_o,      // AVMM_BAM_Conduit.vfenable
		output wire         bam_pfnum_o,         //                 .pfnum
		output wire         bam_vfnum_o,         //                 .vfnum
		output wire         bam_read_o,          //  AVMM_BAM_Master.read
		output wire         bam_write_o,         //                 .write
		output wire [26:0]  bam_address_o,       //                 .address
		output wire [3:0]   bam_burstcount_o,    //                 .burstcount
		output wire [63:0]  bam_byteenable_o,    //                 .byteenable
		output wire [511:0] bam_writedata_o,     //                 .writedata
		input  wire         bam_waitrequest_i,   //                 .waitrequest
		input  wire [511:0] bam_readdata_i,      //                 .readdata
		input  wire         bam_readdatavalid_i  //                 .readdatavalid
	);

	intel_pcie_bam_interpreter_hw #(
		.DEVICE_FAMILY ("Stratix 10"),
		.PFNUM_WIDTH   (1),
		.VFNUM_WIDTH   (1),
		.BAM_ENABLE    (1),
		.MAP_BAR       (1),
		.MAP_PF        (0),
		.MAP_VF        (0),
		.ADDR_WIDTH    (24),
		.DATA_WIDTH    (512),
		.BURST_WIDTH   (4)
	) pio_interpreter (
		.clk_i               (clk_i),               //   input,    width = 1,            clock.clk
		.reset_i             (reset_i),             //   input,    width = 1,            reset.reset
		.bam_read_i          (bam_read_i),          //   input,    width = 1,   AVMM_BAM_Slave.read
		.bam_write_i         (bam_write_i),         //   input,    width = 1,                 .write
		.bam_address_i       (bam_address_i),       //   input,   width = 30,                 .address
		.bam_burstcount_i    (bam_burstcount_i),    //   input,    width = 4,                 .burstcount
		.bam_byteenable_i    (bam_byteenable_i),    //   input,   width = 64,                 .byteenable
		.bam_writedata_i     (bam_writedata_i),     //   input,  width = 512,                 .writedata
		.bam_waitrequest_o   (bam_waitrequest_o),   //  output,    width = 1,                 .waitrequest
		.bam_readdata_o      (bam_readdata_o),      //  output,  width = 512,                 .readdata
		.bam_readdatavalid_o (bam_readdatavalid_o), //  output,    width = 1,                 .readdatavalid
		.bam_response_o      (bam_response_o),      //  output,    width = 2,                 .response
		.bam_vfactive_o      (bam_vfactive_o),      //  output,    width = 1, AVMM_BAM_Conduit.vfenable
		.bam_pfnum_o         (bam_pfnum_o),         //  output,    width = 1,                 .pfnum
		.bam_vfnum_o         (bam_vfnum_o),         //  output,    width = 1,                 .vfnum
		.bam_read_o          (bam_read_o),          //  output,    width = 1,  AVMM_BAM_Master.read
		.bam_write_o         (bam_write_o),         //  output,    width = 1,                 .write
		.bam_address_o       (bam_address_o),       //  output,   width = 27,                 .address
		.bam_burstcount_o    (bam_burstcount_o),    //  output,    width = 4,                 .burstcount
		.bam_byteenable_o    (bam_byteenable_o),    //  output,   width = 64,                 .byteenable
		.bam_writedata_o     (bam_writedata_o),     //  output,  width = 512,                 .writedata
		.bam_waitrequest_i   (bam_waitrequest_i),   //   input,    width = 1,                 .waitrequest
		.bam_readdata_i      (bam_readdata_i),      //   input,  width = 512,                 .readdata
		.bam_readdatavalid_i (bam_readdatavalid_i)  //   input,    width = 1,                 .readdatavalid
	);

endmodule
