// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// -----------------------------------------------------------------------
// Description: Active low reset synchronizer core which is replaced by
// special cells in synthesis
//------------------------------------------------------------------------
module sync_rst_n
  ( input  wire rst_n,     // Asynchronous reset
    input  wire clk,       // Clock to synchronize rst_n to
    input  wire tie_high,  // Tie high input
    output reg  rst_n_sync // Synchronized rst_n deassertion output  
  );

reg rst_n_sync1; /*synthesis preserve*/

// Reset synchronizer
// Assertion is asynchronous
// De-assertion is synchronous to clk
always @(negedge rst_n or posedge clk)
  begin
    if (rst_n == 1'b0)
      begin
        rst_n_sync1 <= 1'b0; 
        rst_n_sync  <= 1'b0; 
      end
    else
      begin
        rst_n_sync1 <= tie_high; 
        rst_n_sync  <= rst_n_sync1; 
      end 
  end 

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "4XbrOVIeeLrvyZMqXXXN+KmHxUT2jjJyNT/NlvO0NhwgJ3z9cxsvSMFPmYxdC6PV0UBPJDnAd621rCE49OQPxxLKaFbjgRhfiCstiira1qdgk598ylm4SY5RIZss0GmGFKQdxBl4e5lqOc3n3nHU3yPhk6vAxKr9kpouYCpwWNIcsg7d9SGirWXQftcgW03zfXxxix5PYdjGAooB3UkmfCuWGPnHSG19Q9aZ80CsUjO8zwdo2PuIJIcNJjWgy+Sqfbz2AEQxTzMMQSH0HD0E9tF7F/9LbB15mI8EzkQPziZ1eVS3XORL+A/W1KZE7ZY0D0N/8WSIC5eEUP5WPSrXimnj/XiOC6Ry1ZTS46Ru175KeELWQHhf72dvTcVDzm90RhVyzp+srNsIVdDu7vMIHHKH6f/bpkZjmok1gLGuwIRD3fOdOCY3r5tuY3mvZsZW+fAXAwEXdACEEcb+wC/pNb0WrlMeeKv7e1Xl7mqKOhliqRKz268mcznOACkEUTtFgJ5Y9Ar4ufePGAf59I7ycXYwfMEGAAzNg6ixaWaHKYTUpUxNiw4y+gm/7i5Fjb4z3rVpsiBQVTpJqo/Qk5QhgY8tpHhFHEDSt1SB5bYeTWEHODkr4B1Spd5T+TYjMiK6Itgni20Vc1qW7FE32pM+s36urJKhyqc5fpM5jpnzlRHojXxSdV40qygt6ZOsDUAYX6R44EwABzV38mwj2ABBxvzaFz4Ln3hkG15UjVp9814AMhI8HP6hHMSUq7vq2zjcMw/Uy++FZHbUJdzFU542SlUSrzKch3F/BMXCxVuEi8jEPU+BumU+qXkeQyaO3spnvg1F1xbGPx0MW2jsiACQ8i+6D4iUaJJiKIavC32mJw2T/x+Vc9//TeA+gl79BsXSdb8fE6AUcP3OqBFLdmPuknYwVia/brNzKyphI/PySUMtfeL5ZgQrB/nMk7NhgmZ8b+6qWILRQ/2jlvK6uxNhg/pdGgHE3sYr0PGS/tM+x2FwNTTJ3RhAkOnlf3JFPEzT"
`endif