// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module sync_pulse
  (
   input wr_clk,
   input rd_clk,
   input wr_rst_n,
   input rd_rst_n,
   input din,
   output dout
   );

    reg   din_lat,
          dout_lat;
    reg   din_sync_q;
    
    wire  din_sync,
          dout_sync;
        
    always @ (posedge wr_clk or negedge wr_rst_n)
      if (!wr_rst_n)
        din_lat <= 1'b0;
      else
        din_lat <= dout_sync ? 1'b0 : din? 1'b1 : din_lat;

    sync_bit u_din_sync (.clk(rd_clk), .rst_n(rd_rst_n), .din(din_lat), .dout(din_sync));
    sync_bit u_dout_sync (.clk(wr_clk), .rst_n(wr_rst_n), .din(dout_lat), .dout(dout_sync));
    assign dout = din_sync & ~din_sync_q;
    
    always @ (posedge rd_clk or negedge rd_rst_n)
      if (!rd_rst_n)
        begin
            dout_lat <= 1'b0;
            din_sync_q<=1'b0;
        end
      else
        begin
            dout_lat <= !din_sync? 1'b0 : din_sync ? 1'b1 : dout_lat;
            din_sync_q <= din_sync;
        end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "4XbrOVIeeLrvyZMqXXXN+KmHxUT2jjJyNT/NlvO0NhwgJ3z9cxsvSMFPmYxdC6PV0UBPJDnAd621rCE49OQPxxLKaFbjgRhfiCstiira1qdgk598ylm4SY5RIZss0GmGFKQdxBl4e5lqOc3n3nHU3yPhk6vAxKr9kpouYCpwWNIcsg7d9SGirWXQftcgW03zfXxxix5PYdjGAooB3UkmfCuWGPnHSG19Q9aZ80CsUjO0EwFBp+YtGBc7xObLhryaMTKN/LM9r+fjuYVEVQbCYm2qsVy32eSkTBrsdYxpRnjuW2nawEVQy24yn8TngOEXgYhPOKiZ7/lUBp3WrM63nwfKE6tBW2L+65Dq1snIZNk8L6ALj8p8stFPaRQOr5cNjcoO6uLi82hg8dNmLjrrofDMsKu1/OGT8+s3dA0wKnomvnLzqZ8yDnqGcyOocN2XMNxlW6DxEPjgBj47MaJg8zAOKuq9BtLad+LfyVdpw68kMsTN72Ta6TL9CbhvRiOpTeRYBwzRgr25oEFudcMe4jI2bafNZ3fw4Aa6/Fsp0QdtYthTwUs7BZzQiswEB6g6fLACkD6qzkOJQ4lB9tDpF4YV3O00yp13LXxRaZkh3tspa1w5pMFFjWaJC3jv4LWu7HOtTPjmIQob3FRlQr6vxnfTXjbuTv5Y6rlJQNF9Y3hBpNz7N3zjbdtHD6jhOK3h0BglH9lE3oTeQPCVX+njYkI85EFCjyRroD401lfqzgBoAe9BexCDndijCFxu5m8wTdW71qCxuSAV61O15mNAZOHEdFGl4gvyRVjAQwPLWK91fH9xvBqyq13NH1kWUnHP/m2B3LARWtARjulkAvnvoDiRas0zkYSZWCntSnBFL++t3HqUnSJ3ePA1gvdke/ehmTwg2MsrLVCZICWfT33O5yXv9afAoOL1J7EY4mF4J21FHtX9viZeuQ6uFIIl9r8B1oTE5S+z26P1rVfm9Ak37KdXSXiLxkuR0dhmix6GT/OIGqBAMMcndKgaMxj4WDC5"
`endif