// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module sync_bit
  #(
    parameter DWIDTH = 1,    // Sync Data input
    parameter RESET_VAL = 0  // Reset value
    )
    (
    input  logic              clk,     // clock
    input  logic              rst_n,   // async reset
    input  logic [DWIDTH-1:0] din,     // data in
    output logic [DWIDTH-1:0] dout     // data out
     );

   // Define wires/regs
  logic [(DWIDTH)-1:0] sync_regs_s1; /* synthesis preserve */
  logic [(DWIDTH)-1:0] sync_regs_s2; /* synthesis preserve */
  
  localparam reset_value = (RESET_VAL == 1) ? 1'b1 : 1'b0;  // To eliminate truncating warning

  `ifdef __ALTERA_STD__METASTABLE_SIM
     logic [DWIDTH-1:0]  next_din_s1;
     logic [DWIDTH-1:0]  din_last;
  
     event metastable_event; // hook for debug monitoring
  
     initial begin
        $display("%m: Info: Metastable event injection simulation mode enabled");
     end
  
     genvar i;
      generate
      for (i = 0; i < (DWIDTH); i=i+1) begin: meta_sim
        assign next_din_s1[i] = ((din_last[i] ^ din[i]) == 0) ? din[i] : $urandom_range(1,0);
      end
     endgenerate
  
     always @(posedge clk or negedge rst_n) begin
         if (rst_n == 0)
           din_last <= {(DWIDTH){reset_value}};
         else
           din_last <= din;
     end
  
     always @(negedge rst_n or posedge clk) begin
        if (rst_n == 1'b0) begin
           sync_regs_s1[DWIDTH-1:0] <= {(DWIDTH){reset_value}};
        end
        else begin
           sync_regs_s1[DWIDTH-1:0] <= next_din_s1;
        end
     end
  `else
  
     // NF: both FF stages have reset
     always @(negedge rst_n or posedge clk) begin
        if (rst_n == 1'b0) begin
           sync_regs_s1[DWIDTH-1:0] <= {(DWIDTH){reset_value}};
        end
        else begin
           sync_regs_s1[DWIDTH-1:0] <= din;
        end
     end
  
  `endif

   // Sync Always block
   always @(negedge rst_n or posedge clk) begin
      if (rst_n == 1'b0) begin
         sync_regs_s2[DWIDTH-1:0] <= {(DWIDTH){reset_value}};
      end
      else begin
         sync_regs_s2[DWIDTH-1:0] <= sync_regs_s1[(DWIDTH-1):0];
      end
   end

   assign dout = sync_regs_s2;
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "4XbrOVIeeLrvyZMqXXXN+KmHxUT2jjJyNT/NlvO0NhwgJ3z9cxsvSMFPmYxdC6PV0UBPJDnAd621rCE49OQPxxLKaFbjgRhfiCstiira1qdgk598ylm4SY5RIZss0GmGFKQdxBl4e5lqOc3n3nHU3yPhk6vAxKr9kpouYCpwWNIcsg7d9SGirWXQftcgW03zfXxxix5PYdjGAooB3UkmfCuWGPnHSG19Q9aZ80CsUjPnAO0ifefTI4GLcQtCg269q0PyeEuPyRC82etLMYGKemJ4gsRtgcajuJkhCMS1OIX4vY47T+hwgpYNsHEsj+poKOkDQRsxGge2uJSHXV90Gve7aBRG7CXsNmEILpUZxucheTFb7Wfct79w9V+qBEDzPfgoNg+Z3RZv0IouLsduZ+5zC6a3PquWx40dft7ogCFZHTRDmnTmEJOyQr1zPk5E9Mrg2Tp2zdt2S88BWQ+LOzlnpnSoA7hVvpiBcDL9TB9qDzDMzwms86y/S0fkAwM0YP+YMjXU71K7+9un8anMspMX2cKBm5uS4D6OuGPxqIUqQSNLWKGtpb10uq0+MCHmJaHTHcJmnMEJkNyj00BURzcUVpiRkIpshG+7UhKuu7cdF45piXl38Fui1ca1EhCDP/37H/tfUoSrrLyHBcApljN+kOrrI1+QeVczEr0WhCRBbJYcFVnoyfH/2T68SQwJ1CBcRg6O9dIwsI7eu6OtZyxMVOrt0sEV7H3KaG+A7KxmW8c+adYI8ZD6502YkvHomEqQYpk1kwUbwo+EOAD1bPq5/Mp17dWKwg2JSCH9M4wVPwKy7VhNnN1Q1rCwiEgVfXIj7xkea8OfFo5tRDI3INdz/Y6tEgAYHJlTD1ayo2+tBPMfM8pECySpCnnozs3MVq6XgQxK5fhFxY/5MfeNVVwH0Y4ryp45aVgN9kCVdX7ML+U/qhjNboEjWyc74cMkb/kk6Q8jsEQM+hdCcUniaf5PBkvVyIqayBuTre2hINdxrsMWKGPGnrQ5QweZaTSf"
`endif