// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

//`default_nettype none

module altera_pcie_s10_reset_delay_sync #(
  parameter                  WIDTH_RST              = 1,
  parameter                  NODENAME               = "altera_pcie_s10_reset_delay_sync" // Expecting Instance name
) (
  input                      clk,
  input                      rst_n,
  output [WIDTH_RST-1:0]     srst_n
);

  wire                       sync_rst_n;

  reg   [WIDTH_RST-1:0]      sync_rst_n_r /* synthesis dont_merge */;
  reg   [WIDTH_RST-1:0]      sync_rst_n_rr /* synthesis dont_merge */;

  assign srst_n              = sync_rst_n_rr;

  altera_std_synchronizer_nocut sync (.clk (clk), .reset_n (rst_n), .din (1'b1), .dout (sync_rst_n) );

  always @(posedge clk) begin
    sync_rst_n_r             <= {(WIDTH_RST){sync_rst_n}};
    sync_rst_n_rr            <= {(WIDTH_RST){sync_rst_n_r}};
  end


endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "4XbrOVIeeLrvyZMqXXXN+KmHxUT2jjJyNT/NlvO0NhwgJ3z9cxsvSMFPmYxdC6PV0UBPJDnAd621rCE49OQPxxLKaFbjgRhfiCstiira1qdgk598ylm4SY5RIZss0GmGFKQdxBl4e5lqOc3n3nHU3yPhk6vAxKr9kpouYCpwWNIcsg7d9SGirWXQftcgW03zfXxxix5PYdjGAooB3UkmfCuWGPnHSG19Q9aZ80CsUjOUcKJk154gRcHucGWiYAORxfsU/i3PatJymNntlSNofGAWjE87oJC1XMITaMECIS/eFMKS693QfUYKuYky0A6RkUMsgGNN6jtSdfFYMkXzcQ+Cjq0QnaWus/N4vob3MC/Iy4Q7jFxaGNZBxX25riXQJlVsO6ADs13Z0aIp4nW4ySthK2TawQIWJei7LTHRD6HwADgIOWwtOiqKyvzjmikh5mBuGXBxjBIWZxSQTBhrSaKU7qj8HMb/+jHEP1FgBUJAl/J6EqNFJEDou5VOKPQg5K4Plvpp7W5ezq1kJWU5Pkhmk3BTlYxTTBH2GcexzBwTFkatH9V7V14M/4meSiXo+R0riYIPDmDBTB8dgh88uTa14ZPEvvq2lejgUvkGRGAkPISxd3pt0WUrXe0ga9B6mNYwxAJDzB6c6AHUJ7dMv1toAQgDeLO1uoKk8uhOgZAasS4Wq+uYNeAk+g016gmxCI5FCHPuhraSPSpq1IB1JU6rNCGpyPGjtwWMi+4izQxIGgZm0V3ePQzhXbiKpaECQyS8nb4CL9j2yM+RNhstRuL/EOqVRRaEqYDfIvq+PTzSp8+bkkTIWyNmXfefVo8oaiACuUkAulSFgM66QJ8C3AypX+JcdZ4QBgiYNOeipS0JyLCo1IHv52nrflZ7iDvCLM5tUWR3DQVD7j3fioUzb1ODSPLgeaN9sYCcSZe8pVrA5OXzjb7BwCPPpV3zso0SeEodzinGAI/Y6+q2VjSuQQCsLWMLnBQ/FZpJ1VH9jhaj3GGZ8iCTtG+IyK9b8oTt"
`endif