// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// (C) 2001-2018 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module altera_s10_pcie_gen3x16_gpx3
  #(
     parameter     WIDTH = 4
  )(
   input logic        din_clk,
   input logic        din_rst,
   input logic [WIDTH-1:0]  din,
   input logic        dout_clk,
   input logic        dout_rst_n,
   output logic [WIDTH-1:0] dout
   );

    //binary to gray conversion
    logic [WIDTH-1:0] din_gry,
                din_gry_sync,
                din_bin;

   /*  assign din_gry[2] = din[2];
    assign din_gry[1] = din[2]^din[1];
    assign din_gry[0] = din[1]^din[0]; */

    //genvar i;
    always @ (posedge din_clk) begin
      if (din_rst) begin
        din_gry <= '0;
      end
      else begin
        din_gry[WIDTH - 1] <= din [WIDTH - 1];
        for (int i = 0; i < (WIDTH - 1); i=i+1) begin: gry_convert
          din_gry[i] <= din[i] ^ din[i+1];
        end    
      end   
    end   
    
    
    sync_bit #(.DWIDTH(WIDTH)) u_din_gry_sync (.clk(dout_clk), .rst_n(dout_rst_n), .din(din_gry), .dout(din_gry_sync));

    //assign din_bin = {din_gry_sync[2], din_gry_sync[1]^din_bin[2], din_gry_sync[0]^din_bin[1]};
    assign din_bin[WIDTH-1] = din_gry_sync[WIDTH-1];
/*     assign din_bin[3] = din_gry_sync[3] ^ din_bin[4];
    assign din_bin[2] = din_gry_sync[2] ^ din_bin[3];
    assign din_bin[1] = din_gry_sync[1] ^ din_bin[2];
    assign din_bin[0] = din_gry_sync[0] ^ din_bin[1]; */
    
    genvar i;
    generate
    for (i = 0; i < (WIDTH - 1); i=i+1) begin: bin_convert
      assign din_bin[i] = din_gry_sync[i] ^ din_bin[i+1];
    end
    
    endgenerate
    
    
    
    
    //convert back to binary
    always @ (posedge dout_clk)
      if (!dout_rst_n)
        dout <= '0;
      else
        dout <= din_bin;

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "4XbrOVIeeLrvyZMqXXXN+KmHxUT2jjJyNT/NlvO0NhwgJ3z9cxsvSMFPmYxdC6PV0UBPJDnAd621rCE49OQPxxLKaFbjgRhfiCstiira1qdgk598ylm4SY5RIZss0GmGFKQdxBl4e5lqOc3n3nHU3yPhk6vAxKr9kpouYCpwWNIcsg7d9SGirWXQftcgW03zfXxxix5PYdjGAooB3UkmfCuWGPnHSG19Q9aZ80CsUjNmhEg7Je+wVPDMgcKJzE/+g5+fUsZgPT/eDIWr7u9wPU5XWxyy/A1ZjxZSWMwk+rVLht+vSsCUy5zR5b+2KeLOldEWNvFsN4i7FofwOPQUAf1caUeJry/nm9pSDM3H5N10KWmKJSfmnWLDaof94NXtJpueHwM6uLSdwNMYcrddN8vATgY1rb6xeuk2H9Bewni618umu4sYwyAuClk1Q1mr8PYVj/mZHOPwQk7Ro00v8lTdEKV+5/GQOafW+tOzLpNXwCK0goa1VUrugIfe1FyhCDUE1xbqxHs7lSAiJ4z13n/J2zpoq8QC+EvLSR07jsJvGqHwWbcyL3zELjiZSCBUTlOaGQCSE/4yBtqnmbv9JKPgaO7JVsuq+aN+iEvwolmGdRnnd0r8Nq4z/2eDFFAJ8Zs7svYXTGjEd3EaP79HYsmcifCOOSIKwOjFSqgLfA1lwp8dlpg2uFjdoYg2VQ9/lWVEvyrbjA4HfHlKNC0vIpSJzv9BbrFnBKHraKNWY8ne5XCh8WTNDU643mXLtJn4wcRjWcGYrkR6a4nDDFzmJNhMjlbuGZW0f9jkruWpbbjlpC0+A6sH3oGipVg/78b+1i4fKYcuqHN93yLjol++DFz3clXdo4L+3qS6/Z1enMyRAKc0x0Dzc4OtjN6QjOswFq1KAsj/BtGHBd2GGgyt4PnrkWRi/q8YJtE5yzlR6nemyQxTaNwtcdtSuYrlFUsjBPmbfY+nYJspkYkLDqdfk2fS3I+wzk8bVMxQOilbdI4W6NCxxEM5AA6chSiXfWG+"
`endif