// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps
// baeckler - 06-02-2016


// DESCRIPTION
// Wrapper for MLAB hardware cells in typical arrangement

module alt_mlab #(
    parameter DEVICE_FAMILY 	= "Stratix 10",
	parameter WIDTH = 20,
	parameter ADDR_WIDTH = 5,
	parameter SIM_EMULATE = 1'b0   // this may not be exactly the same at the fine grain timing level 
)
(
	input wclk,
	input wena,
	input [ADDR_WIDTH-1:0] waddr_reg,
	input [WIDTH-1:0] wdata_reg,
	input [ADDR_WIDTH-1:0] raddr,
	output [WIDTH-1:0] rdata		
);

genvar i;
generate
	if (!SIM_EMULATE) begin
		/////////////////////////////////////////////
		// hardware cells

		// the fourteen nm only (the Stratix 10) needs another data register
		reg [WIDTH-1:0] wdata_reg_2;
		always @(posedge wclk) wdata_reg_2 <= wdata_reg;
		
		for (i=0; i<WIDTH; i=i+1)  begin : ml
			wire wclk_w = wclk;  // workaround strange modelsim warning due to cell model tristate
            // Note: the stratix 5 cell is the same other than timing
			
			//stratixv_mlab_cell lrm (
			//twentynm_mlab_cell lrm (
                    fourteennm_mlab_cell lrm (
                        .clk0(wclk_w),
                        .ena0(wena),
                        
                        // synthesis translate off
                        .clk1(1'b0),
                        .ena1(1'b1),
                    //?	.ena2(1'b1),
                        .clr(1'b0),
                        .devclrn(1'b1),
                        .devpor(1'b1),
                        // synthesis translate on			

                        .portabyteenamasks(1'b1),
                        .portadatain(wdata_reg_2[i]),
                        .portaaddr(waddr_reg),
                        .portbaddr(raddr),
                        .portbdataout(rdata[i])			
                        
                    );

                    defparam lrm .mixed_port_feed_through_mode = "dont_care";
                    defparam lrm .logical_ram_name = "lrm";
                    defparam lrm .logical_ram_depth = 1 << ADDR_WIDTH;
                    defparam lrm .logical_ram_width = WIDTH;
                    defparam lrm .first_address = 0;
                    defparam lrm .last_address = (1 << ADDR_WIDTH)-1;
                    defparam lrm .first_bit_number = i;
                    defparam lrm .data_width = 1;
                    defparam lrm .address_width = ADDR_WIDTH;			
					
		end
	end
	else begin
		/////////////////////////////////////////////
		// sim equivalent

		localparam NUM_WORDS = (1 << ADDR_WIDTH);
		reg [WIDTH-1:0] storage [0:NUM_WORDS-1];
		integer k = 0;
		initial begin
			for (k=0; k<NUM_WORDS; k=k+1) begin
				storage[k] = 0;
			end
		end

		always @(posedge wclk) begin
			if (wena) storage [waddr_reg] <= wdata_reg;	
		end

		reg [WIDTH-1:0] rdata_b = 0;
		always @(*) begin
			rdata_b = storage[raddr];
		end
		
		assign rdata = rdata_b;
	end
	
endgenerate

endmodule	

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "4XbrOVIeeLrvyZMqXXXN+KmHxUT2jjJyNT/NlvO0NhwgJ3z9cxsvSMFPmYxdC6PV0UBPJDnAd621rCE49OQPxxLKaFbjgRhfiCstiira1qdgk598ylm4SY5RIZss0GmGFKQdxBl4e5lqOc3n3nHU3yPhk6vAxKr9kpouYCpwWNIcsg7d9SGirWXQftcgW03zfXxxix5PYdjGAooB3UkmfCuWGPnHSG19Q9aZ80CsUjO/V3S9Xq/Zp1XbgxRaEK6fC47IOf6zQWI4ezWS7fQesIJiXvcuf+7K0qi/lohKGnWwxwfQQzIpeWwoA5ixu6U1qp+cwLR8grWDGPW7aJ+cZjPuXllHSi5TcqKsCYpK81M4verWVxhufeWkvuwmg1eHenKbwHepcfpUKgGApb9Wto1Je+fWI2MttGf7MW6Ph+POiNzNh+VyEk6jHdQdDvlcDzU7SmTA4q+Po3CmiLduxxSRCFMYMYjUFvGJ+rO7duG4SHGiKqKXtQte1TKwf2o0T9x05cAJeEDRmDugji0fCOrYYiF0ghvl5csGbhQc30Jecfkq9hPCkuNHIO5TBvfac8un9QfjFMeeCheiohK+fYw89P+lnF/I9n/9jQ6fCYEfUFhSta49ipMPuvOtaf4xy5nBrf675UlEDE/rngsvy8eJaRF6C6HmB4eXQAWvHNr49Cu5Jv6RzUtSB5ShElhHoQa6gYElBRg1ObyAEpsVhD9vuDN7HGZhdTOwJs+GZsa9pkxNsCeDAqbLhYzQECbtDzFVvotDcyUIQjNj/sjRx9MjSzsQt/mjH9v0sYzswknqElqG92HnnJHASAEVol3GKcqoxzKa2QSC7z/jtFxVd//q5TY04oKnXZugNC/J4v1nuWZoPp55WR78PYzL3hATsFMSxKHYsf+E1oyIzIEEjgdpQXkRaBBoWbLo8FZRtVb4zumjKtkNXmEUUwJ6sPfZ7G7CYEFrWjnDyMqhd4tG1KLFwGrnvWjmybO1VN8TW+wV+0YtR9DjbmxJZi3Iyc5r"
`endif