// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



module altera_emif_arch_nd_cal_counter # (
   parameter IS_HPS = 0
) (
   input logic pll_ref_clk_int,
   input logic local_reset_req_int,
   input logic afi_cal_in_progress
);
   timeunit 1ps;
   timeprecision 1ps;

   typedef enum {
      INIT,
      IDLE,
      COUNT_CAL,
      STOP
   } counter_state_t;

   logic                         done;
   logic [31:0]                  clk_counter;

   generate
      if (IS_HPS == 0) begin : non_hps
         logic                         cal_done;
         logic                         reset_req_sync;
         logic                         cal_in_progress_sync;

         altera_std_synchronizer_nocut
         inst_sync_reset_n (
            .clk     (pll_ref_clk_int),
            .reset_n (1'b1),
            .din     (local_reset_req_int),
            .dout    (reset_req_sync)
         );

         altera_std_synchronizer_nocut
         inst_sync_cal_in_progress (
            .clk     (pll_ref_clk_int),
            .reset_n (1'b1),
            .din     (afi_cal_in_progress),
            .dout    (cal_in_progress_sync)
         );

         counter_state_t counter_state /* synthesis ignore_power_up */;

         assign done = ((counter_state == STOP) ? 1'b1 : 1'b0);

         always_ff @(posedge pll_ref_clk_int) begin
            if(reset_req_sync == 1'b1) begin
               counter_state <= INIT;
            end
            else begin
               case(counter_state)
                  INIT:
                  begin
                     clk_counter <= 32'h0;
                     counter_state <= IDLE;
                  end

                  IDLE:
                  begin
                     if (cal_in_progress_sync == 1'b1)
                     begin
                        counter_state <= COUNT_CAL;
                     end
                  end

                  COUNT_CAL:
                  begin
                     clk_counter[31:0] <= clk_counter[31:0] + 32'h0000_0001;

                     if (cal_in_progress_sync == 1'b0)
                     begin
                        counter_state <= STOP;
                     end
                  end

                  STOP:
                  begin
                     counter_state <= STOP;
                  end

                  default:
                  begin
                     counter_state <= INIT;
                  end
               endcase
            end
         end
      end else begin : hps
         assign done = 1'b1;
         assign clk_counter = '0;
      end
   endgenerate

`ifdef ALTERA_EMIF_ENABLE_ISSP
   altsource_probe #(
      .sld_auto_instance_index ("YES"),
      .sld_instance_index      (0),
      .instance_id             ("CALC"),
      .probe_width             (33),
      .source_width            (0),
      .source_initial_value    ("0"),
      .enable_metastability    ("NO")
      ) cal_counter_issp (
      .probe  ({done, clk_counter[31:0]})
   );
`endif

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "oDDtlXUtB+UysQe7FAoTjxcfb3pKKZZLrS5gWp3sw6TuLTYbGGPlXrXcZ7+F6YBIPhJ5h3QXHIHqEBi+fZrdQvw8PmpPHeXxhJPA5NrJCYxLypp3uyWIvknCrKDV5VajPhu/6EDgrGyy1jEOeS9sSoWBjvWqcpNUXK9nvlOUVIV0xIHfWjY+W8oSdfc6y5vPRe0I38rOdGy+yVCaj9K659/1ZRR/+WygUMQoj4RbOhHozCiXOb/ckENFhQ5nB4Na3RsnUN6bRDqJx/5gDtGd79kM0s7JlyFd0miNdkI9HqzyMv6m4VgculoMhsYisusqlPDyDTCmj6fz1Dpwc1hq7dAPPD/n4wXUZdBVoeoTJY9P4AMGKeOcjtvF+ydXVzYxvJ88B30+1Pqso6IRZN57BnudHbhqr/W6ttHfNj+6WmAlA+Y92F57gY7R9Un+HUmGWqc5La2iQMpMRKRSPt8lNgupJCgCm73U6fOiNctmleHZ9B2LnZlvbC4W8qtYsxfHHK+9l0aa5auF53ij4PIlsMrCoqPVtbQbtIvu1eq14dpPuVdQAP+wSvJqnY63GxCjADaMMcqZwmJpwI77zeBCpa+HfVd5j5Q9cfq3e7nvIB/mOvhkdtT28kog/+l0jKavZguzEGdm75tyVOzG1Nd5wuQb8UBcS4eqey8jsdlA0DNxH8S3bPRND1GVumhYCeHEP/0vtv2i/LXlkRLvHMvIrDNyTz0D41AO4om8AULtPYC5w1uXD1knZTd9qnQZIHWZhEO4PKSQ3KEcZWC63RZ25mbL05aM5A9o9HgL29KmnyE2qY187Uzphn0b689z5iwv1t1ph8v5pZhZnpvWImG2CHCp0h/27BSNxqX4oWXIR4TVlv6wCEoLwnMyck+JczC/uMEMZxhGuecXm3301ztwnG8NAymqsJV4x2L03X6jfTNu/DtFAz03rSNdxE1uF+fM7quSOdye4VBq+m5yYbwBZRHfZgK4ssk/17h4b/HK0mq9BjNWtU1zvfI4gwrz09LT"
`endif