// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module altera_emif_arch_nd_buf_udir_se_i #(
   parameter OCT_CONTROL_WIDTH = 1,
   parameter CALIBRATED_OCT = 1
) (
   input  logic i,
   output logic o,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_stc,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_ptc
);
   timeunit 1ns;
   timeprecision 1ps;

   generate
      if (CALIBRATED_OCT) 
      begin : cal_oct
         fourteennm_io_ibuf ibuf(
            .i(i),
            .o(o),
            .seriesterminationcontrol(oct_stc),
            .parallelterminationcontrol(oct_ptc),
            .ibar(),
            .dynamicterminationcontrol()
            );    
      end else 
      begin : no_oct
         fourteennm_io_ibuf ibuf(
            .i(i),
            .o(o),
            .seriesterminationcontrol(),
            .parallelterminationcontrol(),
            .ibar(),
            .dynamicterminationcontrol()
            );
      end
   endgenerate
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "oDDtlXUtB+UysQe7FAoTjxcfb3pKKZZLrS5gWp3sw6TuLTYbGGPlXrXcZ7+F6YBIPhJ5h3QXHIHqEBi+fZrdQvw8PmpPHeXxhJPA5NrJCYxLypp3uyWIvknCrKDV5VajPhu/6EDgrGyy1jEOeS9sSoWBjvWqcpNUXK9nvlOUVIV0xIHfWjY+W8oSdfc6y5vPRe0I38rOdGy+yVCaj9K659/1ZRR/+WygUMQoj4RbOhGM/N67yUl4efCCVil6B3/B7+FfK3X/heY251dReAmJx8jXNxfYrFjYwNl6XNjdMfYyGRL6U6yKv1p/HXvI7a+0kMiKE0g5BGIJC8eYpqlD3uAoz1Adb8vFoHOHFqmcy9lCAsNCg/y12nMLwJWapvlYKqiMd12XgNWnbHZUcWo+Wg073sjsW9qI2w4wsTRq9yrlvbWdRXtyL14K4URIHq5/lGnjVytePODmwHoCqp6iJs2jV6UVOlVKuq3YKFkR2oohgBy5nOTFw5rGh4FUKdvU1lfPNe19dw1HYweRQGXOCUzO1F/1KgPG5Bz9uAUHhgev1jxL304Nu28N8PyBCyIkQVSHgpj9JPw41L7nphYmhHIl+TSIIaTXtDfsdhcO037F8Q8hAMrR90M/FlUvIi1Ydxl6QOZLtwuaBoyEJ4tGbi8VPMYWWjWOKreLvR58S7q4EF+CuU01jhhgbdAwElW6ixl5uzEwKCIrkzE/gw4xgA0xsIURPMHEzH0WpSEIQrAhqOgyRHY4S5Lv246/ULU1eVLTNFhtc3R74CjwFUpKGjYUNOKwv080QGD+7qrbMhHZziu/GGWNNkvR+MXDPBQXJwn/mQNdnnjBCLhVzIcrtSK9e5iGKLgljaDa5TcvWutLked/FgbCFw2iPiQLX8iYgO0vprpbZ9CYqYrWchVCU77x+JyfQh5FM8TiduJ3ADa0ml2nuitplLxbA02DXn4+VIsm6R3mhhT5SLXvMcMnuhb3OFtYqQEGl6Y6PxBUaXek7wWDetA6EJPtu8RoN7MK"
`endif