// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



///////////////////////////////////////////////////////////////////////////////
// This module handles the creation of a conditional register stage.
// This module may be used to implement a synchronizer (with properly selected
// REGISTER value)
///////////////////////////////////////////////////////////////////////////////

// The following ensures that the register stage isn't synthesized into
// RAM-based shift-regs (especially if customer logic implements another follow-on
// pipeline stage). RAM-based shift-regs can degrade timing for C2P/P2C transfers.
(* altera_attribute = "-name AUTO_SHIFT_REGISTER_RECOGNITION OFF" *)

 module altera_emif_arch_nd_regs #(
   parameter REGISTER       = 0,
   parameter WIDTH          = 0
) (
   input  logic              clk,
   input  logic              reset_n,
   input  logic [WIDTH-1:0]  data_in,
   output logic [WIDTH-1:0]  data_out
) /* synthesis dont_merge */;
   timeunit 1ns;
   timeprecision 1ps;

   generate
      genvar stage;

      if (REGISTER == 0) begin : no_reg
         assign data_out = data_in;
      end else begin : regs
         logic [WIDTH-1:0] sr_out [(REGISTER > 0 ? REGISTER-1 : 0):0];

         assign data_out = sr_out[REGISTER-1];

         for (stage = 0; stage < REGISTER; stage = stage + 1)
         begin : stage_gen
            always_ff @(posedge clk or negedge reset_n) begin
               if (~reset_n) begin
                  sr_out[stage] <= '0;
               end else begin
                  sr_out[stage] <= (stage == 0) ? data_in : sr_out[stage-1];
               end
            end
         end
      end
   endgenerate
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "AkDMPQOIIBdUXJUhCY52t3tbYDqXLRT52E5ixmZO0uPIiLYJYXmvta4pFJ02IBPPGIT2TNlVDsKSvVYXIouIW3+7aiOKefqrRsAdehbNE32jACVZGhhWbzy3szTqf0uEFX9R013QJTOv5J6g1voik7ro4grooLGTSGkMVb4gcDO55U1rrsm6St9TUaqtK0kUq5O3EnV7TSjC5mQCTLijd71E/Cuksp1vhZhmO5ulHVDR1GoKLuIYXRbPUd+Ybmakpcy8QIVygiydGQjwdvqJZ4vF1rbISLo3s2uTXo9ctOrKKgUG9G7mpgeLl9qYxgqrhS2/5OynjBi3c59VVASej2Zx0Cqi3EfoVB1DXCHlLl5yB4/nwGhyK8YVq1/n5QnXBSGsks/sjraUna02Gb36XqbRRvtvamwJSlIJx7AGumzoJj7E3HmPGUGmNKf8CkPrS+U4mwxnhmlhXnbK9j6EJUUn8sQxEPdIofFteoG30Pb9phDqxUihBLsPEUCWqnbPYR2sJ+fc1y0qIYCORBl+9GxSJ2lB3OMg51U9vsnuxx1/TR7fhk9sr9Z3iXXoytkFuRsul2RQ0nobRa09EaHoQ+YSFOx670zL+ZN9X/KtDcjkg7ahEmbj/Sryu38s84wDug5UVjymDAnxEx928XKnjDkSMFbi3tKxKn7kCfmEGhGfItF+sDWiN1yEadV6qX35lYcRWr2533kIys/26xOruJOtYLQO5RjmNuoMvOT+j6nn4lT89u9WttO6pB890sF6jWksbFpO20fjcM1dtrX05pniwuvoohw9iii9CcRjvbU833ImzdmpKAO8tlqBXgJz/QY43Ku7ZMHBgr1eOdaEbtX31m1tUXGNnJrjeIRDLCUkKYhhfD84k95F+5tss5Uuwkg0V/lLZxdzfnFzm1bprnbFQFhuVE4a4+j/e8zi2k8gQ66IwWzFN2E1uxrS5q1pqakbheGa6WnWeKsE9+WisuHrR7UgdwiWvREQZEsNQnnT+QER+DEciKHoyxnjz4pA"
`endif