// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// $Id: //acds/rel/24.3/ip/iconnect/pd_components/altera_std_synchronizer/altera_std_synchronizer_bundle.v#1 $
// $Revision: #1 $
// $Date: 2024/08/01 $
//----------------------------------------------------------------
//
// File: altera_std_synchronizer_bundle.v
//
// Abstract: Bundle of bit synchronizers. 
//           WARNING: only use this to synchronize a bundle of 
//           *independent* single bit signals or a Gray encoded 
//           bus of signals. Also remember that pulses entering 
//           the synchronizer will be swallowed upon a metastable
//           condition if the pulse width is shorter than twice
//           the synchronizing clock period.
//
// Copyright (C) Altera Corporation 2008, All Rights Reserved
//----------------------------------------------------------------

module altera_std_synchronizer_bundle(
				     clk,
				     reset_n,
				     din,
				     dout
				     );
   parameter width = 1;
   parameter depth = 3;   
   
   input clk;
   input reset_n;
   input [width-1:0] din;
   output [width-1:0] dout;
   
   generate
      genvar i;
      for (i=0; i<width; i=i+1)
	begin : sync
	   altera_std_synchronizer #(.depth(depth))
                                   u (
				      .clk(clk), 
				      .reset_n(reset_n), 
				      .din(din[i]), 
				      .dout(dout[i])
				      );
	end
   endgenerate
   
endmodule 

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "1VqK2PjbLzbQ7LJhEK25f65oxFTaYCknitu/kZ6blg/25nFVVfvNZlPfzohOSZPKuNO4iT3ZRafVEb+HjF2homiPnDA4GF3PAVQA3wqf7VOmAaCpAhJLEsBpaLZjEztwOhj56eWbCoyJhxqcaD/s4BKAPomDLHAVi5m0XPy6aeCwrhHLIlQgAKrpaEwa3r1rJRv6kjkQVAnLykxXtvwSw/UIu5QrSN9hDAfv+GPyepPnve200P//nC5rvdgJq6/cPDVhCvSWMG2YzLyGLHxPEvmsGkQcCGRJTD5P9ruKC6d/OVmukJk2jnDeYYp+/S2gCO5O+Z0PZcQMeNkPkDlxcp6eNF3BE916TPxybtK2DdbrQMzqVPUbgUW7YH8ncDpVsWhxOb+06aiCiyzScNk4xvlTO7ROaswTuGZXdOFCTACRv9uriozaR47K4cU8vrMnRsi2hR+Rup2a03e6GYH1P+BAkmMmHcXv1DgUN1qP9n2wcjVApDAIHuHhn2W5kO4NOm+IRRiA6Wh32x8jIyosz0LEDFiJ2QETWc2qGvus0wjppOx/vCbs/NmuHf00IWHv8Cld0LDxFYryxMmEyQFihfIa+7QjoxcvWyM+JyBEre2ftNyPY7Q9FbaR/Ddcq7008kw3kbEo0cslhrcKgh4CIDl++IQIWQFjrfCD38qYoO23cy63XPBthTTUbKwAqF3fgeMUuXE5DXOMGbDsuBWQnjUfzrARlr9rVKhLNQgw3mphYORtl31YbGgLyjRtmlfjy3MS6j5QRzOWBYQ8m/HLHnmJvOPmO1k8+QgY1+wtuGuhwPmTvwzvq62CLLgDcbrl2Y20dYz4rZ4dDX8zR77mnqTEECXqPcw3KSbVhqx8GHD8QA9D2lhj0IPO+VdksxGmqYSyaueFvn1RNI6YSS2Q1UNtv4uK/F+zW0q0PavUkLpOxVRrmGJtDz8OmsYeRRISNiG0NXL92xz/bzVYNvV82WOyCjHsDNnr3+nwCBmAsGl05QW3Nqg/N2kwo8t7Av5Q"
`endif