	component pcie_ed_PIO_INTERPRETER is
		port (
			clk_i               : in  std_logic                      := 'X';             -- clk
			reset_i             : in  std_logic                      := 'X';             -- reset
			bam_read_i          : in  std_logic                      := 'X';             -- read
			bam_write_i         : in  std_logic                      := 'X';             -- write
			bam_address_i       : in  std_logic_vector(29 downto 0)  := (others => 'X'); -- address
			bam_burstcount_i    : in  std_logic_vector(3 downto 0)   := (others => 'X'); -- burstcount
			bam_byteenable_i    : in  std_logic_vector(31 downto 0)  := (others => 'X'); -- byteenable
			bam_writedata_i     : in  std_logic_vector(255 downto 0) := (others => 'X'); -- writedata
			bam_waitrequest_o   : out std_logic;                                         -- waitrequest
			bam_readdata_o      : out std_logic_vector(255 downto 0);                    -- readdata
			bam_readdatavalid_o : out std_logic;                                         -- readdatavalid
			bam_response_o      : out std_logic_vector(1 downto 0);                      -- response
			bam_vfactive_o      : out std_logic;                                         -- vfenable
			bam_pfnum_o         : out std_logic;                                         -- pfnum
			bam_vfnum_o         : out std_logic;                                         -- vfnum
			bam_read_o          : out std_logic;                                         -- read
			bam_write_o         : out std_logic;                                         -- write
			bam_address_o       : out std_logic_vector(26 downto 0);                     -- address
			bam_burstcount_o    : out std_logic_vector(3 downto 0);                      -- burstcount
			bam_byteenable_o    : out std_logic_vector(31 downto 0);                     -- byteenable
			bam_writedata_o     : out std_logic_vector(255 downto 0);                    -- writedata
			bam_waitrequest_i   : in  std_logic                      := 'X';             -- waitrequest
			bam_readdata_i      : in  std_logic_vector(255 downto 0) := (others => 'X'); -- readdata
			bam_readdatavalid_i : in  std_logic                      := 'X'              -- readdatavalid
		);
	end component pcie_ed_PIO_INTERPRETER;

	u0 : component pcie_ed_PIO_INTERPRETER
		port map (
			clk_i               => CONNECTED_TO_clk_i,               --            clock.clk
			reset_i             => CONNECTED_TO_reset_i,             --            reset.reset
			bam_read_i          => CONNECTED_TO_bam_read_i,          --   AVMM_BAM_Slave.read
			bam_write_i         => CONNECTED_TO_bam_write_i,         --                 .write
			bam_address_i       => CONNECTED_TO_bam_address_i,       --                 .address
			bam_burstcount_i    => CONNECTED_TO_bam_burstcount_i,    --                 .burstcount
			bam_byteenable_i    => CONNECTED_TO_bam_byteenable_i,    --                 .byteenable
			bam_writedata_i     => CONNECTED_TO_bam_writedata_i,     --                 .writedata
			bam_waitrequest_o   => CONNECTED_TO_bam_waitrequest_o,   --                 .waitrequest
			bam_readdata_o      => CONNECTED_TO_bam_readdata_o,      --                 .readdata
			bam_readdatavalid_o => CONNECTED_TO_bam_readdatavalid_o, --                 .readdatavalid
			bam_response_o      => CONNECTED_TO_bam_response_o,      --                 .response
			bam_vfactive_o      => CONNECTED_TO_bam_vfactive_o,      -- AVMM_BAM_Conduit.vfenable
			bam_pfnum_o         => CONNECTED_TO_bam_pfnum_o,         --                 .pfnum
			bam_vfnum_o         => CONNECTED_TO_bam_vfnum_o,         --                 .vfnum
			bam_read_o          => CONNECTED_TO_bam_read_o,          --  AVMM_BAM_Master.read
			bam_write_o         => CONNECTED_TO_bam_write_o,         --                 .write
			bam_address_o       => CONNECTED_TO_bam_address_o,       --                 .address
			bam_burstcount_o    => CONNECTED_TO_bam_burstcount_o,    --                 .burstcount
			bam_byteenable_o    => CONNECTED_TO_bam_byteenable_o,    --                 .byteenable
			bam_writedata_o     => CONNECTED_TO_bam_writedata_o,     --                 .writedata
			bam_waitrequest_i   => CONNECTED_TO_bam_waitrequest_i,   --                 .waitrequest
			bam_readdata_i      => CONNECTED_TO_bam_readdata_i,      --                 .readdata
			bam_readdatavalid_i => CONNECTED_TO_bam_readdatavalid_i  --                 .readdatavalid
		);

