// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1ps/1ps

module alt_xcvr_native_anlg_reset_seq_wrapper
#(	
	parameter CLK_FREQ_IN_HZ = 100000000,
	parameter DEFAULT_RESET_SEPARATION_NS = 100,
	parameter TX_ANALOG_RESET_SEPARATION_NS = 100,	
	parameter RX_ANALOG_RESET_SEPARATION_NS = 100,	
	parameter ENABLE_RESET_SEQUENCER = 0,	
	parameter TX_ENABLE = 1,
	parameter RX_ENABLE = 1,	
	parameter NUM_CHANNELS = 1,
	parameter REDUCED_RESET_SIM_TIME = 0
)(    
	input wire  [NUM_CHANNELS-1:0] tx_analog_reset,
	input wire  [NUM_CHANNELS-1:0] rx_analog_reset,	
	output wire [NUM_CHANNELS-1:0] tx_analogreset_stat,
	output wire [NUM_CHANNELS-1:0] rx_analogreset_stat,	
	output wire [NUM_CHANNELS-1:0] tx_analog_reset_out,
	output wire [NUM_CHANNELS-1:0] rx_analog_reset_out	
);

wire clk;
wire reset_n;

//***************************************************************************
// Getting the clock from Master TRS
//***************************************************************************
altera_s10_xcvr_clkout_endpoint clock_endpoint (	
	.clk_out(clk)
);	

//***************************************************************************
// Need to self-generate internal reset signal
//***************************************************************************
alt_xcvr_resync_std #(
	.SYNC_CHAIN_LENGTH(3),
	.INIT_VALUE(0)
) reset_n_generator (
	.clk	 (clk),
	.reset (1'b0),
	.d		 (1'b1),
	.q		 (reset_n)
);

//***************************************************************************
//*********************** Reset sequencer************************************
genvar ig;
generate	
	if (ENABLE_RESET_SEQUENCER) begin : g_trs		
		if (TX_ENABLE) begin
			// tx_analog_reset
			alt_xcvr_native_anlg_reset_seq #(	
				.CLK_FREQ_IN_HZ					      (CLK_FREQ_IN_HZ),
				.DEFAULT_RESET_SEPARATION_NS	(DEFAULT_RESET_SEPARATION_NS),
				.RESET_SEPARATION_NS			    (TX_ANALOG_RESET_SEPARATION_NS),	
				.NUM_RESETS						        (NUM_CHANNELS),
				.REDUCED_RESET_SIM_TIME       (REDUCED_RESET_SIM_TIME)
			) tx_anlg_reset_seq (
				.clk				    (clk),		
				.reset_n			  (reset_n),
				.reset_in			  (tx_analog_reset),
				.reset_out			(tx_analog_reset_out),
				.reset_stat_out	(tx_analogreset_stat)
			);

		end else begin
		   assign tx_analog_reset_out = {NUM_CHANNELS{1'b0}};
		   assign tx_analogreset_stat = {NUM_CHANNELS{1'b0}};
		end
		
		if (RX_ENABLE) begin
			// rx_analog_reset
			alt_xcvr_native_anlg_reset_seq #(	
				.CLK_FREQ_IN_HZ					      (CLK_FREQ_IN_HZ),
				.DEFAULT_RESET_SEPARATION_NS	(DEFAULT_RESET_SEPARATION_NS),
				.RESET_SEPARATION_NS			    (RX_ANALOG_RESET_SEPARATION_NS),	
				.NUM_RESETS						        (NUM_CHANNELS),
				.REDUCED_RESET_SIM_TIME       (REDUCED_RESET_SIM_TIME)
			) rx_anlg_reset_seq (
				.clk				    (clk),		
				.reset_n			  (reset_n),
				.reset_in			  (rx_analog_reset),
				.reset_out			(rx_analog_reset_out),
				.reset_stat_out	(rx_analogreset_stat)
			);

		end else begin
		   assign rx_analog_reset_out = {NUM_CHANNELS{1'b0}};
		   assign rx_analogreset_stat = {NUM_CHANNELS{1'b0}};
		end
	end else begin : g_no_trs
		
		assign tx_analogreset_stat = tx_analog_reset;	
		assign rx_analogreset_stat = rx_analog_reset;		
		assign tx_analog_reset_out = tx_analog_reset;
		assign rx_analog_reset_out = rx_analog_reset;

	end

endgenerate

//******************* End reset sequencer ***********************************
//***************************************************************************

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "opdVy43h6iNiR8xG87bmerDaXcSC3FhyOyT1oNCpTIictLSg3ZSNlowtASKN8wYiV5fUXl7Ly4t+I7vTfsM5xOKbUZpA1P2Ve34oRG6KIRIuRijDsCmTFF10umgF3/A8qX6Rbu8BsP0lO4HOGX6VKWZ8M8oaT1gDUFdLpzF4fAfvJXd+fc3EDkYIeu2yHWI4JH9ahX9IbTgnN93MN175TqIVeNuWyfpZpsvodCyAubOu7RitncAOC3oOenl1OlDkUwEInxrV881HCs5HV3itf8SrRUPCL4MR/l73Loi9o+vBjo/usqRMKRP45+LWIwHJy8bjRcoJrxEgSJXzKiYhfRAiKh0arsJCbS1PnMW4iicExMCySceikrLj2ZKsD96jH8U7aF3Mf3hGFClD+hx7Ea8yTmOJjR8N/vOGC92VPNwL4UEei7tFtD2TcBWcaUwXRnxSlyE6ByLSVxH/YncBPvASyZHVO1girGzO+N3OdB/5XwIh2Jt2AQx7pwdyn+Sln5vtYRf0+2J1PEvzU3Kgf3CnGTErdeHG7sqXeiXj8gux22413GJI91bRE2HNT9GSNnnzXRRoctWjOdRZ56synOMnv8H/JKxbE9M5ghjZuuKjaFuxKF3Hcy9rdL3USaYs0TMre1Zb9lH4nFELRnM540vNUT8n5J5NMzkwp55q4be1lMLIKS+dt/Fa8XSFbFxrf+H0wuwBRyzald6aOI2HDoLCOXZx12CPtC/yHfbLG26GcI3DempOZ6v4IYif6gi5taHwQvCJ+eEBBdmG91Iz3R7UzGMZIzd8k8nmelQbTR8CCtEDh3xFFdHYSaYmf2FE4XLaAQzYX+37I+lS92wxs/yQvQV9QN0pRD4ZRecg0pHuV42GXjoJWk6yxeEaBZ3LZ3CLx7gsacfypMvaNDh5rkXpCQGr8O88+czrxdTN3Ppm1lphAW6nbBRFd0lDJh4QLOyLkhJ4Y4437erIcF3K8WwGW1EmrfxHPtAG+IDuU7uaJxkW0JQmXq6bBixUqomR"
`endif