// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


 
//------------------------------------------------------------------
// filename: altera_xcvr_fpll_a10.sv
//
// Description : instantiates refclk_select_mux, master CGB and cmu_fpll atoms 
//
// Limitation  : Intended for Stratix10 
//
// Copyright (c) Altera Corporation 1997-2012
// All rights reserved
//-------------------------------------------------------------------
`timescale 1ps/1ps

/////////////// DPS phase_en pulse conversion module //////////////
module dps_pulse_ctrl_qjyjjoy (
    input  wire clk,            // the DPS clock
    input  wire rst,            // active high reset
    input  wire user_phase_en,  // the user's phase_en signal
    output reg  phase_en        // the phase_en signal for the IOPLL atom 
 );
 
    //-------------------------------------------------------------------------
    // States
    localparam IDLE        = 0,  // Idle state: user_phase_en = 0, phase_en = 0
               PULSE       = 1,  // Activate state: phase_en = 1
               PULSE2      = 2,  // second clk cycle for pulse
               PULSE3      = 3,  // third  clk cycle for pulse
               WAIT        = 4;  // Wait for user_phase_en to go low

    //-------------------------------------------------------------------------
    // FSM current and next states
    reg [2:0] state, next;     
    
    // State update
    always @(posedge clk) begin
        if (rst)    state <= IDLE;
        else        state <= next; 
    end  

    //-------------------------------------------------------------------------    
    // Next-state and output logic
    always @(*) begin
        next     = IDLE;  // Default next state 
        phase_en = 1'b0;  // Default output
        
        case (state)
            IDLE :  begin
                        if (user_phase_en)  next = PULSE;
                        else                next = IDLE;
                    end     
                         
            PULSE : begin
                        phase_en = 1'b1;
                        next     = PULSE2;
                    end
            PULSE2: begin
                        phase_en = 1'b1;
                        next     = PULSE3;
                    end
            PULSE3: begin
                        phase_en = 1'b1;
                        next     = WAIT;
                    end
                         
            WAIT :  begin         
                        if (~user_phase_en) next = IDLE;
                        else                next = WAIT;                  
                    end  
        endcase
    end
     
 endmodule

/* This module is used to correctly reset the DPS logic.
   It snoops the phase_en_in pulse and waits for the phase_done_in
   to be asserted by the fpll core. It then generates a phase_reset_out
   pulse that resets the DPS logic in the fpll core and finally
   generates a phase_done_out to send back to the user. phase_reset_in
   generated by the user is OR'ed in with the phase_reset_out generated
   by this module.
 */
module dps_reset_gen_qjyjjoy (
    input wire clk,               // DPS clock input
    input wire phase_reset_in,    // active high reset input
    input wire phase_en_in,       // phase_en input
    input wire phase_done_in,     // phase_done input		       
    output wire phase_reset_out,  // active high reset output
    output wire phase_done_out    // phase_done output 
 );
 
    //-------------------------------------------------------------------------
    // States
    localparam WAIT_PE_PULSE    = 4'd0,  // Wait for phase_en_in pulse 
               WAIT_CORE_DONE   = 4'd1,  // Wait for phase_done_in pulse
               GEN_RESET_DELAY  = 4'd2,  // Wait for N cycle before asserting phase_reset_out
               GEN_RESET_1      = 4'd3,  // First cycle of phase_reset_out assertion
               GEN_RESET_2      = 4'd4,  // Second cycle of phase_reset_out assertion
               GEN_RESET_DELAY_1 = 4'd5, // Wait for phase_done_in deassertion
               GEN_RESET_DELAY_2 = 4'd6, // Wait before deasserting phase_reset_out 1
               GEN_RESET_DELAY_3 = 4'd7, // Wait before deasserting phase_reset_out 2
               GEN_RESET_DELAY_4 = 4'd8, // Wait before deasserting phase_reset_out 3
               GEN_DONE_DELAY   = 4'd9,  // Wait cycle before asserting phase_done_out 1
               GEN_DONE_DELAY_1 = 4'd10,  // Wait cycle before asserting phase_done_out 2
               GEN_DONE_1       = 4'd11,  // First cycle of phase_done_out
               GEN_DONE_2       = 4'd12;  // Second cycle of phase_done_out
    localparam GEN_RESET_DELAY_COUNT = 6'd52; // Number of cycles after DONE assertions to wait before asserting reset
   
    //-------------------------------------------------------------------------
    // FSM current and next states
    reg [3:0] state, next;
    reg [5:0] clock_counter;
    wire      clock_counter_done;
 
    wire      phase_done_in_syncd;

    // Reset Delay Counter
    assign clock_counter_done = (clock_counter == GEN_RESET_DELAY_COUNT);
    always @(posedge clk) begin
       if (phase_reset_in)    clock_counter <= 6'd0;
       else if (state != GEN_RESET_DELAY) clock_counter <= 6'd0;
       else clock_counter <= clock_counter + 6'd1;
    end
   
    // State update
    always @(posedge clk) begin
        if (phase_reset_in)    state <= WAIT_PE_PULSE;
        else                   state <= next; 
    end  

    // Add additional phase_done_in synchronization
       altera_std_synchronizer_nocut #(
          .depth(3),
          .rst_value(0)
       )  synchronizer_nocut_inst  (
          .clk(clk), 
          .reset_n(1'b1), 
          .din (phase_done_in), 
          .dout(phase_done_in_syncd)
       );

    //-------------------------------------------------------------------------    
    // Next-state and output logic
    always @(*) begin
        next     = WAIT_PE_PULSE;  // Default next state
       
        case (state)
            WAIT_PE_PULSE : begin
                              if (phase_en_in)    next = WAIT_CORE_DONE;
                              else                next = WAIT_PE_PULSE;
                            end     
                         
            WAIT_CORE_DONE : begin
	                       if (phase_done_in_syncd) next = GEN_RESET_DELAY;
	                       else                     next = WAIT_CORE_DONE;
                             end
                         
            GEN_RESET_DELAY : begin
                               if (clock_counter_done) next = GEN_RESET_1;
                               else                    next = GEN_RESET_DELAY;
                              end  

            GEN_RESET_1     : begin         
                                next = GEN_RESET_2;
                              end  

	    GEN_RESET_2     : begin         
                                next = GEN_RESET_DELAY_1;
                              end  

	    GEN_RESET_DELAY_1 : begin
	                          if (!phase_done_in_syncd) next = GEN_RESET_DELAY_2;
	                          else                      next = GEN_RESET_DELAY_1;
	                        end
	  
	    GEN_RESET_DELAY_2 : begin
	                          next = GEN_RESET_DELAY_3;
	                        end

	    GEN_RESET_DELAY_3 : begin
	                          next = GEN_RESET_DELAY_4;
	                        end

	    GEN_RESET_DELAY_4 : begin
	                          next = GEN_DONE_DELAY;
	                        end
	  
	    GEN_DONE_DELAY  : begin         
                                next = GEN_DONE_DELAY_1;
                              end  

	    GEN_DONE_DELAY_1: begin         
                                next = GEN_DONE_1;
                              end  

	    GEN_DONE_1      : begin         
	                        next = GEN_DONE_2;
                              end  

	    GEN_DONE_2      : begin         
	                        next = WAIT_PE_PULSE;
                              end  
        endcase
    end

    assign phase_reset_out = (state == GEN_RESET_1) ||
			     (state == GEN_RESET_2) ||
			     (state == GEN_RESET_DELAY_1) ||
			     (state == GEN_RESET_DELAY_2) ||
			     (state == GEN_RESET_DELAY_3) ||
			     (state == GEN_RESET_DELAY_4) ||
			     phase_reset_in;
    assign phase_done_out = (state == GEN_DONE_1) ||
			    (state == GEN_DONE_2);


endmodule


//////////////  Main FPLL module ////////////////////

(* altera_attribute = "-name UNCONNECTED_OUTPUT_PORT_MESSAGE_LEVEL OFF" *)


module pcie_ed_DUT_altera_xcvr_fpll_s10_htile_1913_qjyjjoy
#(
  // H-Tile specific
  parameter cmu_fpll_bcm_silicon_rev       = "rev_off"               ,   // H-Tile Valid values: rev_off reva revb revc
  //cmu_fpll_cal_status should be forced to "fpll_cal_status_on" for correct lock behavior in simulation. In hardware, uC sets this.
  parameter cmu_fpll_cal_status            = "fpll_cal_status_on"    ,   // H-Tile Valid values: fpll_cal_status_on fpll_cal_status_off
  parameter cmu_fpll_cal_reserved          = "fpll_cal_reserved_off" ,   // H-Tile Valid values: fpll_cal_reserved_off fpll_cal_reserved_on
  parameter cmu_fpll_dyn_reconfig          = "fpll_dyn_reconfig_off" ,   // H-Tile Valid values: fpll_dyn_reconfig_off fpll_dyn_reconfig_on 
  parameter cmu_fpll_lckdet_sel            = "lckdet_sel_analog"     ,   // H-Tile Valid values: lckdet_sel_analog lckdet_sel_digital 
  parameter cmu_fpll_ppmdtct_lock_thresld  = "ppmdtct_lock_0"        ,   // H-Tile Valid values: "ppmdtct_lock_0" "ppmdtct_lock_1" "ppmdtct_lock_2" "ppmdtct_lock_3" "ppmdtct_lock_4" "ppmdtct_lock_5" "ppmdtct_lock_6" "ppmdtct_lock_7" 
  parameter cmu_fpll_ppmdtct_noclk_thresld = "ppmdtct_noclk_0"       ,   // H-Tile Valid values: "ppmdtct_noclk_0" "ppmdtct_noclk_1" "ppmdtct_noclk_2" "ppmdtct_noclk_3" "ppmdtct_noclk_4" "ppmdtct_noclk_5" "ppmdtct_noclk_6" "ppmdtct_noclk_7" 
  parameter cmu_fpll_ppmdtct_pll_sel       = "ppmdtct_sel_fpll"      ,   // H-Tile Valid values: "ppmdtct_sel_fpll" "ppmdtct_sel_lccmu" 
  parameter cmu_fpll_enable_hclk           = "true"                  ,
  parameter cmu_fpll_power_rail_er         = 0, //"000000000000"          ,
//  parameter cmu_fpll_powermode_ac_core     = "fpll_core_bypass_ac_1p0", 
//  parameter cmu_fpll_powermode_dc_core     = "fpll_core_bypass_dc_1p0", 
  parameter cmu_fpll_powermode_ac_vco     = "fpll_vco_ac_1p0", 
  parameter cmu_fpll_powermode_dc_vco     = "fpll_vco_dc_1p0", 
  parameter cmu_fpll_powermode_ac_lcnt     = "fpll_lcnt_bypass_ac_1p0", 
  parameter cmu_fpll_powermode_dc_lcnt     = "fpll_lcnt_bypass_dc_1p0", 
  parameter cmu_fpll_atb_atb               = "atb_selectdisable"     ,
  parameter cmu_fpll_powermode_ac_ccnt0    = "fpll_ccnt0_ac",
  parameter cmu_fpll_powermode_ac_ccnt1    = "fpll_ccnt1_ac",
  parameter cmu_fpll_powermode_ac_ccnt2    = "fpll_ccnt2_ac",
  parameter cmu_fpll_powermode_ac_ccnt3    = "fpll_ccnt3_ac",
  parameter cmu_fpll_powermode_dc_ccnt0    = "fpll_ccnt0_dc",
  parameter cmu_fpll_powermode_dc_ccnt1    = "fpll_ccnt1_dc",
  parameter cmu_fpll_powermode_dc_ccnt2    = "fpll_ccnt2_dc",
  parameter cmu_fpll_powermode_dc_ccnt3    = "fpll_ccnt3_dc",
  // End H-Tile specific
  // ct1_cmu_fpll_refclk_select parameters 
  parameter cmu_fpll_refclk_select_mux_mux0_inclk0_logical_to_physical_mapping      = "ref_iqclk0",
  parameter cmu_fpll_refclk_select_mux_mux0_inclk1_logical_to_physical_mapping      = "ref_iqclk1",
  parameter cmu_fpll_refclk_select_mux_mux0_inclk2_logical_to_physical_mapping      = "ref_iqclk2",
  parameter cmu_fpll_refclk_select_mux_mux0_inclk3_logical_to_physical_mapping      = "ref_iqclk3",
  parameter cmu_fpll_refclk_select_mux_mux0_inclk4_logical_to_physical_mapping      = "ref_iqclk4",
  parameter cmu_fpll_refclk_select_mux_mux1_inclk0_logical_to_physical_mapping      = "ref_iqclk0",
  parameter cmu_fpll_refclk_select_mux_mux1_inclk1_logical_to_physical_mapping      = "ref_iqclk1",
  parameter cmu_fpll_refclk_select_mux_mux1_inclk2_logical_to_physical_mapping      = "ref_iqclk2",
  parameter cmu_fpll_refclk_select_mux_mux1_inclk3_logical_to_physical_mapping      = "ref_iqclk3",
  parameter cmu_fpll_refclk_select_mux_mux1_inclk4_logical_to_physical_mapping      = "ref_iqclk4",
  parameter cmu_fpll_refclk_select_mux_refclk_select0                               = "ref_iqclk0",
  parameter cmu_fpll_refclk_select_mux_refclk_select1                               = "ref_iqclk0",
  parameter cmu_fpll_refclk_select_mux_clk_sel_override                             = "normal",
  parameter cmu_fpll_refclk_select_mux_clk_sel_override_value                       = "select_clk0",
  parameter cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_auto_clk_sw_en = "pll_auto_clk_sw_disabled",
  parameter cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_clk_loss_edge  = "pll_clk_loss_rising_edge",
  parameter cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_clk_loss_sw_en = "pll_clk_loss_sw_byps",
  parameter cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_manu_clk_sw_en = "pll_manu_clk_sw_disabled",
  parameter cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_sw_refclk_src  = "pll_sw_refclk_src_clk_0",
  parameter cmu_fpll_refclk_select_mux_silicon_rev                                  = "14nm_hssi",
  parameter cmu_fpll_refclk_select_mux_xpm_clkin_fpll_pll_clkin_0_src               = "pll_clkin_0_src_ref_clk",  
  parameter cmu_fpll_refclk_select_mux_xpm_clkin_fpll_pll_clkin_1_src               = "pll_clkin_1_src_ref_clk",
  // refclk_select bitvecs < 32 bits
  parameter [2:0] cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_clk_sw_dly = 0,
  // ct1_cmu_fpll parameters 
  parameter cmu_fpll_hssi_output_clock_frequency                     = "2500000000",
  parameter cmu_fpll_output_clock_frequency_0                        = "2500000000",
  parameter cmu_fpll_output_clock_frequency_1                        = "2500000000",
  parameter cmu_fpll_output_clock_frequency_2                        = "2500000000",
  parameter cmu_fpll_output_clock_frequency_3                        = "2500000000",
  parameter cmu_fpll_reference_clock_frequency                       = "100000000",
  parameter cmu_fpll_vco_frequency                                   = "10000000000",
  parameter cmu_fpll_analog_mode                                     = "user_custom",
  parameter cmu_fpll_bandwidth_range_high                            = "1",
  parameter cmu_fpll_bandwidth_range_low                             = "1",
  parameter cmu_fpll_bonding                                         = "pll_bonding",
  parameter cmu_fpll_bw_mode                                         = "mid_bw",
  parameter cmu_fpll_cali_ref_off                                    = "ref_on",
  parameter cmu_fpll_cali_vco_off                                    = "vco_on",
  parameter cmu_fpll_chgpmp_testmode                                 = "cp_normal",
  parameter cmu_fpll_compensation_mode                               = "direct",
  parameter cmu_fpll_datarate_bps                                    = "5000000000",
  parameter cmu_fpll_device_variant                                  = "device1",
  parameter cmu_fpll_f_max_band_0                                    = "1",
  parameter cmu_fpll_f_max_band_1                                    = "1",
  parameter cmu_fpll_f_max_band_2                                    = "1",
  parameter cmu_fpll_f_max_band_3                                    = "1",
  parameter cmu_fpll_f_max_band_4                                    = "1",
  parameter cmu_fpll_f_max_band_5                                    = "1",
  parameter cmu_fpll_f_max_band_6                                    = "1",
  parameter cmu_fpll_f_max_band_7                                    = "1",
  parameter cmu_fpll_f_max_band_8                                    = "1",
  parameter cmu_fpll_f_max_band_9                                    = "1",
  parameter cmu_fpll_f_max_div_two_bypass                            = "1",
  parameter cmu_fpll_f_max_pfd                                       = "1",
  parameter cmu_fpll_f_max_pfd_bonded                                = "1",
  parameter cmu_fpll_f_max_pfd_fractional                            = "1",
  parameter cmu_fpll_f_max_pfd_integer                               = "1",
  parameter cmu_fpll_f_max_vco                                       = "1",
  parameter cmu_fpll_f_max_vco_fractional                            = "1",
  parameter cmu_fpll_f_min_band_0                                    = "1",
  parameter cmu_fpll_f_min_band_1                                    = "1",
  parameter cmu_fpll_f_min_band_2                                    = "1",
  parameter cmu_fpll_f_min_band_3                                    = "1",
  parameter cmu_fpll_f_min_band_4                                    = "1",
  parameter cmu_fpll_f_min_band_5                                    = "1",
  parameter cmu_fpll_f_min_band_6                                    = "1",
  parameter cmu_fpll_f_min_band_7                                    = "1",
  parameter cmu_fpll_f_min_band_8                                    = "1",
  parameter cmu_fpll_f_min_band_9                                    = "1",
  parameter cmu_fpll_f_min_pfd                                       = "1",
  parameter cmu_fpll_f_min_vco                                       = "1",
  parameter cmu_fpll_f_out_c0                                        = "1",
  parameter cmu_fpll_f_out_c0_hz                                     = "1",
  parameter cmu_fpll_f_out_c1                                        = "1",
  parameter cmu_fpll_f_out_c1_hz                                     = "1",
  parameter cmu_fpll_f_out_c2                                        = "1",
  parameter cmu_fpll_f_out_c2_hz                                     = "1",
  parameter cmu_fpll_f_out_c3                                        = "1",
  parameter cmu_fpll_f_out_c3_hz                                     = "1",
  parameter cmu_fpll_feedback                                        = "normal",
  parameter cmu_fpll_cal_test_sel                                    = "sel_cal_out_7_to_0",
  parameter cmu_fpll_calibration                                     = "fpll_cal_enable",
  parameter cmu_fpll_cas_out_enable                                  = "fpll_cas_out_disable",
  parameter cmu_fpll_pll_l_counter                                   = 1,
  parameter cmu_fpll_cmu_rstn_value                                  = "cmu_normal",
  parameter cmu_fpll_hclk_out_enable                                 = "fpll_hclk_out_disable",
  parameter cmu_fpll_iqtxrxclk_out_enable                            = "fpll_iqtxrxclk_out_disable",
  parameter cmu_fpll_lpf_rstn_value                                  = "lpf_normal",
  parameter cmu_fpll_ppm_clk0_src                                    = "ppm_clk0_vss",
  parameter cmu_fpll_ppm_clk1_src                                    = "ppm_clk1_vss",
  parameter cmu_fpll_rstn_override                                   = "user_reset_normal",
  parameter cmu_fpll_initial_settings                                = "true",
  parameter cmu_fpll_input_tolerance                                 = 0,
  parameter cmu_fpll_is_otn                                          = "true",
  parameter cmu_fpll_is_pa_core                                      = "false",
  parameter cmu_fpll_is_sdi                                          = "true",
  parameter cmu_fpll_optimal                                         = "true",
  parameter cmu_fpll_out_freq                                        = "2500000000",
  parameter cmu_fpll_out_freq_hz                                     = "2500000000",
  parameter cmu_fpll_pfd_freq                                        = "100000000",
  parameter cmu_fpll_phase_shift_c0                                  = "1",
  parameter cmu_fpll_phase_shift_c1                                  = "1",
  parameter cmu_fpll_phase_shift_c2                                  = "1",
  parameter cmu_fpll_phase_shift_c3                                  = "1",
  parameter cmu_fpll_pll_vco_freq_band_0_fix_high                    = "pll_vco_freq_band_0_fix_high_1",
  parameter cmu_fpll_pll_vco_freq_band_1_fix_high                    = "pll_vco_freq_band_1_fix_high_1",
  parameter cmu_fpll_powerdown_mode                                  = "powerup",
  parameter cmu_fpll_primary_use                                     = "tx",
  parameter cmu_fpll_prot_mode                                       = "basic_tx",
  parameter cmu_fpll_refclk                                          = "1",
  parameter cmu_fpll_sup_mode                                        = "user_mode",
  parameter cmu_fpll_vco_freq                                        = "10000000000",
  parameter cmu_fpll_vco_freq_hz                                     = "10000000000",
  parameter cmu_fpll_c0_pllcout_enable                               = "pllcout_disable",
  parameter cmu_fpll_c0_cnt_min_tco                                  = "cnt_bypass_dly",
  parameter cmu_fpll_c0_m_cnt_in_src                                 = "m_cnt_in_src_ph_mux_clk",
  parameter cmu_fpll_c0_coarse_dly                                   = "pll_coarse_dly_setting0",
  parameter cmu_fpll_c0_fine_dly                                     = "pll_fine_dly_setting0",
  parameter cmu_fpll_c1_pllcout_enable                               = "pllcout_disable",
  parameter cmu_fpll_c1_cnt_min_tco                                  = "cnt_bypass_dly",
  parameter cmu_fpll_c1_m_cnt_in_src                                 = "m_cnt_in_src_ph_mux_clk",
  parameter cmu_fpll_c1_coarse_dly                                   = "pll_coarse_dly_setting0",
  parameter cmu_fpll_c1_fine_dly                                     = "pll_fine_dly_setting0",
  parameter cmu_fpll_c2_pllcout_enable                               = "pllcout_disable",
  parameter cmu_fpll_c2_cnt_min_tco                                  = "cnt_bypass_dly",
  parameter cmu_fpll_c2_m_cnt_in_src                                 = "m_cnt_in_src_ph_mux_clk",
  parameter cmu_fpll_c2_coarse_dly                                   = "pll_coarse_dly_setting0",
  parameter cmu_fpll_c2_fine_dly                                     = "pll_fine_dly_setting0",
  parameter cmu_fpll_c3_pllcout_enable                               = "pllcout_disable",
  parameter cmu_fpll_c3_cnt_min_tco                                  = "cnt_bypass_dly",
  parameter cmu_fpll_c3_m_cnt_in_src                                 = "m_cnt_in_src_ph_mux_clk",
  parameter cmu_fpll_c3_coarse_dly                                   = "pll_coarse_dly_setting0",
  parameter cmu_fpll_c3_fine_dly                                     = "pll_fine_dly_setting0",
  parameter cmu_fpll_cal_vco_count_length                            = "sel_8b_count",
  parameter cmu_fpll_refclk_source                                   = "normal_refclk",
  parameter cmu_fpll_vco_div_by_2_sel                                = "bypass_divide_by_2",
  parameter cmu_fpll_pfd_delay_compensation                          = "normal_delay",
  parameter cmu_fpll_pfd_pulse_width                                 = "pulse_width_setting0",
  parameter cmu_fpll_vccdreg_fb                                      = "vreg_fb5",
  parameter cmu_fpll_vccdreg_fw                                      = "vreg_fw5",
  parameter cmu_fpll_vreg0_atbsel                                    = "atb_disabled",
  parameter cmu_fpll_vreg1_atbsel                                    = "atb_disabled1",
  parameter cmu_fpll_fb_cmp_buf_dly                                  = "pll_cmp_buf_dly_setting0",
  parameter cmu_fpll_fb_fbclk_mux_1                                  = "pll_fbclk_mux_1_glb",
  parameter cmu_fpll_fb_fbclk_mux_2                                  = "pll_fbclk_mux_2_m_cnt",
  parameter cmu_fpll_iqfb_mux_iqclk_sel                              = "iqtxrxclk0",
  parameter cmu_fpll_chgpmp_compensation                             = "cp_mode_enable",
  parameter cmu_fpll_chgpmp_current_setting                          = "cp_current_setting25",
  parameter cmu_fpll_cp_current_boost                                = "normal_setting",
  parameter cmu_fpll_lf_3rd_pole_freq                                = "lf_3rd_pole_setting0",
  parameter cmu_fpll_lf_cbig                                         = "lf_cbig_setting4",
  parameter cmu_fpll_lf_order                                        = "lf_2nd_order",
  parameter cmu_fpll_lf_resistance                                   = "lf_res_setting1",
  parameter cmu_fpll_lf_ripplecap                                    = "lf_no_ripple",
  parameter cmu_fpll_vco_ph0_en                                      = "pll_vco_ph0_en",
  parameter cmu_fpll_vco_ph0_value                                   = "pll_vco_ph0_vss",
  parameter cmu_fpll_vco_ph1_en                                      = "pll_vco_ph1_dis_en",
  parameter cmu_fpll_vco_ph1_value                                   = "pll_vco_ph1_vss",
  parameter cmu_fpll_vco_ph2_en                                      = "pll_vco_ph2_dis_en",
  parameter cmu_fpll_vco_ph2_value                                   = "pll_vco_ph2_vss",
  parameter cmu_fpll_vco_ph3_en                                      = "pll_vco_ph3_dis_en",
  parameter cmu_fpll_vco_ph3_value                                   = "pll_vco_ph3_vss",
  parameter cmu_fpll_dsm_mode                                        = "dsm_mode_integer",
  parameter cmu_fpll_pll_dsm_out_sel                                 = "pll_dsm_disable",
  parameter cmu_fpll_pll_ecn_bypass                                  = "pll_ecn_bypass_disable",
  parameter cmu_fpll_pll_ecn_test_en                                 = "pll_ecn_test_disable",
  parameter cmu_fpll_pll_fractional_division                         = "1",
  parameter cmu_fpll_pll_fractional_value_ready                      = "pll_k_ready",
  parameter cmu_fpll_lcnt_l_cnt_bypass                               = "lcnt_normal",
  parameter cmu_fpll_lcnt_l_cnt_enable                               = "lcnt_en",
  parameter cmu_fpll_lockf_lock_fltr_test                            = "pll_lock_fltr_nrm",
  parameter cmu_fpll_mcnt_cnt_min_tco                                = "cnt_enable_dly",
  parameter cmu_fpll_mcnt_m_cnt_in_src                               = "m_cnt_in_src_ph_mux_clk",
  parameter cmu_fpll_mcnt_coarse_dly                                 = "pll_coarse_dly_setting0",
  parameter cmu_fpll_mcnt_fine_dly                                   = "pll_fine_dly_setting0",
  parameter cmu_fpll_ncnt_coarse_dly                                 = "pll_coarse_dly_setting0",
  parameter cmu_fpll_ncnt_fine_dly                                   = "pll_fine_dly_setting0",
  parameter cmu_fpll_ref_ref_buf_dly                                 = "pll_ref_buf_dly_setting0",
  parameter cmu_fpll_testmux_tclk_mux_en                             = "pll_tclk_mux_disabled",
  parameter cmu_fpll_testmux_tclk_sel                                = "pll_tclk_m_src",
  parameter cmu_fpll_dprio_broadcast_en                              = "dprio_dprio_broadcast_en_csr_ctrl_disable",
  parameter cmu_fpll_dprio_cvp_inter_sel                             = "dprio_cvp_inter_sel_csr_ctrl_disable",
  parameter cmu_fpll_dprio_force_inter_sel                           = "dprio_force_inter_sel_csr_ctrl_disable",
  parameter cmu_fpll_dprio_power_iso_en                              = "dprio_power_iso_en_csr_ctrl_disable",
  parameter cmu_fpll_dprio_status_select                             = "dprio_normal_status",
  parameter cmu_fpll_ctrl_nreset_prgmnvrt                            = "nreset_noninv",
  parameter cmu_fpll_ctrl_ctrl_override_setting                      = "pll_ctrl_enable",
  parameter cmu_fpll_ctrl_enable                                     = "pll_enabled",
  parameter cmu_fpll_ctrl_slf_rst                                    = "pll_slf_rst_off",
  parameter cmu_fpll_ctrl_test_enable                                = "pll_testen_off",
  parameter cmu_fpll_ctrl_plniotri_override                          = "plniotri_ctrl_disable",
  parameter cmu_fpll_ctrl_vccr_pd                                    = "vccd_powerup",
  parameter cmu_fpll_silicon_rev                                     = "14nm_hssi",
  parameter cmu_fpll_pll_op_mode                                     = "false",
  parameter cmu_fpll_bw_sel                                          = "auto",
  parameter cmu_fpll_duty_cycle_0                                    = 50,
  parameter cmu_fpll_duty_cycle_1                                    = 50,
  parameter cmu_fpll_duty_cycle_2                                    = 50,
  parameter cmu_fpll_duty_cycle_3                                    = 50,
  parameter cmu_fpll_is_cascaded_pll                                 = "false",
  //-----------------------------------------------------------------------------------------------
  // Adding the following parameters as an addendum following switching their
  // resolution stage to IPGEN.  IS mentioned that we are no longer concerned
  // about matching order or parameters in terp vs tcl so will simply collect
  // them here
  //-----------------------------------------------------------------------------------------------
  parameter [6:0] cmu_fpll_max_fractional_percentage                       = 1,
  parameter [6:0] cmu_fpll_min_fractional_percentage                       = 1,
  parameter cmu_fpll_output_tolerance                                = 0,
  parameter cmu_fpll_power_mode                                      = "mid_power",
  parameter cmu_fpll_power_rail_et                                   = 0, //"000000000000",
  parameter cmu_fpll_side                                            = "side_unknown",
  parameter cmu_fpll_speed_grade                                     = "e2",
  parameter cmu_fpll_top_or_bottom                                   = "tb_unknown",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_0_scratch0_src = "pll_clkin_0_scratch0_src_vss",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_0_scratch1_src = "pll_clkin_0_scratch1_src_vss",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_0_scratch2_src = "pll_clkin_0_scratch2_src_vss",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_0_scratch3_src = "pll_clkin_0_scratch3_src_vss",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_0_scratch4_src = "pll_clkin_0_scratch4_src_vss",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_1_scratch0_src = "pll_clkin_1_scratch0_src_vss",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_1_scratch1_src = "pll_clkin_1_scratch1_src_vss",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_1_scratch2_src = "pll_clkin_1_scratch2_src_vss",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_1_scratch3_src = "pll_clkin_1_scratch3_src_vss",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_pll_clkin_1_scratch4_src = "pll_clkin_1_scratch4_src_vss",
  parameter cmu_fpll_refclk_select_mux_powerdown_mode                            = "powerup",
  parameter cmu_fpll_refclk_select_mux_sup_mode                                  = "user_mode",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq0_scratch0_src    = "iq0_scratch0_power_down",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq0_scratch1_src    = "iq0_scratch1_power_down",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq0_scratch2_src    = "iq0_scratch2_power_down",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq0_scratch3_src    = "iq0_scratch3_power_down",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq0_scratch4_src    = "iq0_scratch4_power_down",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq1_scratch0_src    = "iq1_scratch0_power_down",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq1_scratch1_src    = "iq1_scratch1_power_down",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq1_scratch2_src    = "iq1_scratch2_power_down",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq1_scratch3_src    = "iq1_scratch3_power_down",
  parameter cmu_fpll_refclk_select_mux_pm_cmu_fpll_atom_fpll_iq1_scratch4_src    = "iq1_scratch4_power_down",
  parameter cmu_fpll_refclk_select_mux_xpm_iqref_mux0_iqclk_sel      = "power_down",
  parameter cmu_fpll_refclk_select_mux_xpm_iqref_mux1_iqclk_sel          = "power_down",
  // bitvecs < 32 bits
  parameter [3:0] cmu_fpll_cgb_div                                   = 1,                 
  parameter [5:0] cmu_fpll_l_counter                                 = 2,                  
  parameter [7:0] cmu_fpll_m_counter                                 = 50,                   
  parameter [8:0] cmu_fpll_m_counter_c0                              = 0,                    
  parameter [8:0] cmu_fpll_m_counter_c1                              = 0,                   
  parameter [8:0] cmu_fpll_m_counter_c2                              = 0,                    
  parameter [8:0] cmu_fpll_m_counter_c3                              = 0,                    
  parameter [5:0] cmu_fpll_n_counter                                 = 1,                  
  parameter [1:0] cmu_fpll_pll_vco_freq_band_0_dyn_high_bits         = 1,                   
  parameter [2:0] cmu_fpll_pll_vco_freq_band_0_dyn_low_bits          = 3,                   
  parameter [4:0] cmu_fpll_pll_vco_freq_band_0_fix                   = 21,                   
  parameter [1:0] cmu_fpll_pll_vco_freq_band_1_dyn_high_bits         = 1,                   
  parameter [2:0] cmu_fpll_pll_vco_freq_band_1_dyn_low_bits          = 3,                  
  parameter [4:0] cmu_fpll_pll_vco_freq_band_1_fix                   = 21,                 
  parameter [6:0] cmu_fpll_pma_width                                 = 64,                   
  parameter [7:0] cmu_fpll_set_input_freq_range                      = 255, //0               
  parameter [8:0] cmu_fpll_c0_cnt_div                                = 1,               
  parameter [1:0] cmu_fpll_c0_m_cnt_ph_mux_prst                      = 1,              
  parameter [7:0] cmu_fpll_c0_m_cnt_prst                             = 1,             
  parameter [8:0] cmu_fpll_c1_cnt_div                                = 1,            
  parameter [1:0] cmu_fpll_c1_m_cnt_ph_mux_prst                      = 1,           
  parameter [7:0] cmu_fpll_c1_m_cnt_prst                             = 1,          
  parameter [8:0] cmu_fpll_c2_cnt_div                                = 1,         
  parameter [1:0] cmu_fpll_c2_m_cnt_ph_mux_prst                      = 1,        
  parameter [7:0] cmu_fpll_c2_m_cnt_prst                             = 1,       
  parameter [8:0] cmu_fpll_c3_cnt_div                                = 1,      
  parameter [1:0] cmu_fpll_c3_m_cnt_ph_mux_prst                      = 1,     
  parameter [7:0] cmu_fpll_c3_m_cnt_prst                             = 1,    
  parameter [11:0] cmu_fpll_lockf_lock_fltr_cfg                      = 25,  
  parameter [2:0] cmu_fpll_lockf_unlock_fltr_cfg                     = 2,  
  parameter [8:0] cmu_fpll_mcnt_cnt_div                              = 1, 
  parameter [1:0] cmu_fpll_mcnt_m_cnt_ph_mux_prst                    = 0,
  parameter [7:0] cmu_fpll_mcnt_m_cnt_prst                           = 1,
  parameter [4:0] cmu_fpll_ncnt_ncnt_divide                          = 0,
  parameter [8:0] cmu_fpll_dprio_base_addr                           = 256,
  parameter [2:0] cmu_fpll_extra_csr                                 = 0,                   
  // other misc parameters 
  parameter hip_cal_en                                               = "disable",
  parameter calibration_en                                           = "enable",
  parameter enable_pcie_hip_connectivity                             = 0,
  parameter enable_clk_divider                                       = 0,
  parameter test_mode                                                = "false",
  parameter enable_dps                                               = 0,
  parameter direct_dps                                               = 1,
  // Master CGB parameters 
  parameter enable_mcgb                                              = 0,
  parameter enable_mcgb_reset                                        = 0,
  parameter enable_mcgb_debug_ports_parameters                       = 0,
  parameter hssi_pma_cgb_master_prot_mode                            = "basic_tx",
  parameter hssi_pma_cgb_master_silicon_rev                          = "14nm_hssi",
  parameter hssi_pma_cgb_master_x1_div_m_sel                         = "divbypass",
  parameter hssi_pma_cgb_master_cgb_enable_iqtxrxclk                 = "disable_iqtxrxclk",
  parameter hssi_pma_cgb_master_ser_mode                             = "sixty_four_bit",
  parameter hssi_pma_cgb_master_datarate_bps                         = "1002000000",
  parameter hssi_pma_cgb_master_cgb_power_down                       = "normal_cgb",
  parameter hssi_pma_cgb_master_observe_cgb_clocks                   = "observe_nothing",
  parameter hssi_pma_cgb_master_op_mode                              = "enabled",
  parameter hssi_pma_cgb_master_tx_ucontrol_reset_pcie               = "pcscorehip_controls_mcgb",
  parameter hssi_pma_cgb_master_vccdreg_output                       = "vccdreg_nominal",
  parameter hssi_pma_cgb_master_input_select                         = "lcpll_top",
  parameter hssi_pma_cgb_master_input_select_gen3                    = "not_used",
  parameter hssi_pma_cgb_master_power_rail_er                        = "0",
  parameter hssi_pma_cgb_master_powermode_ac_cgb_master              = "cgb_master_ac_ls_1p0",
  parameter hssi_pma_cgb_master_powermode_dc_cgb_master              = "powerdown_cgb_master", 
  

  //AVMM2 parameters
  parameter          hssi_avmm2_if_silicon_rev                       = "14nm5"                       ,//"14nm5"
  parameter          hssi_avmm2_if_calibration_type                  = "one_time"                    ,//"continuous" "one_time"
  parameter          hssi_avmm2_if_pcs_calibration_feature_en        = "avmm2_pcs_calibration_dis"   ,//"avmm2_pcs_calibration_dis" "avmm2_pcs_calibration_en"
  parameter          hssi_avmm2_if_pcs_arbiter_ctrl                  = "avmm2_arbiter_uc_sel"        ,//"avmm2_arbiter_pld_sel" "avmm2_arbiter_uc_sel"
  parameter          hssi_avmm2_if_pcs_cal_done                      = "avmm2_cal_done_assert"       ,//"avmm2_cal_done_assert" "avmm2_cal_done_deassert"
  parameter          hssi_avmm2_if_pcs_hip_cal_en                    = "disable"                     ,//"disable" "enable"
  parameter [4:0]    hssi_avmm2_if_pcs_cal_reserved                  = 5'd0                          ,//0:31
  parameter          hssi_avmm2_if_hssiadapt_hip_mode                = "disable_hip"                 ,//"debug_chnl" "disable_hip" "user_chnl"
  parameter          hssi_avmm2_if_pldadapt_hip_mode                 = "disable_hip"                 ,//"debug_chnl" "disable_hip" "user_chnl"
  parameter          hssi_avmm2_if_hssiadapt_avmm_osc_clock_setting  = "osc_clk_div_by1"             ,//"osc_clk_div_by1" "osc_clk_div_by2" "osc_clk_div_by4"
  parameter          hssi_avmm2_if_pldadapt_avmm_osc_clock_setting   = "osc_clk_div_by1"             ,//"osc_clk_div_by1" "osc_clk_div_by2" "osc_clk_div_by4"
  parameter          hssi_avmm2_if_hssiadapt_avmm_testbus_sel        = "avmm1_transfer_testbus"      ,//"avmm1_cmn_intf_testbus" "avmm1_transfer_testbus" "avmm2_transfer_testbus" "avmm_clk_dcg_testbus"
  parameter          hssi_avmm2_if_pldadapt_avmm_testbus_sel         = "avmm1_transfer_testbus"      ,//"avmm1_cmn_intf_testbus" "avmm1_transfer_testbus" "avmm2_transfer_testbus" "unused_testbus"
  parameter          hssi_avmm2_if_pldadapt_gate_dis                 = "disable"                     ,//"disable" "enable"
   

// reconfig multiprofile required ports + others
  parameter dbg_capability_reg_enable                                =0,
  parameter dbg_ctrl_soft_logic_enable                               =0,
  parameter dbg_embedded_debug_enable                                =0,
  parameter dbg_stat_soft_logic_enable                               =0,
  parameter dbg_user_identifier                                      =0,
  parameter rcfg_enable                                              =0,
  parameter rcfg_jtag_enable                                         =0,
  parameter rcfg_separate_avmm_busy                                  =0,

  parameter rcfg_profile_cnt                                         =0,
  parameter rcfg_emb_strm_enable                                     =0,


  parameter SIZE_AVMM_RDDATA_BUS = 32,
  parameter SIZE_AVMM_WRDATA_BUS = 32
)
(
  // general usage for core and HSSI
  input pll_refclk0,
  input pll_refclk1,          
  input pll_refclk2,          
  input pll_refclk3,          
  input pll_refclk4,          
  input pll_powerdown,
  input atx_to_fpll_cascade_clk,
  output wire tx_serial_clk,
  output wire pll_cascade_clk,
  output wire outclk,
  output wire [2:0] unused_pllcout,
  output wire outclk_div1,
  output wire outclk_div2,
  output wire outclk_div4,
  output wire pll_pcie_clk,
  output wire pll_locked,
  output wire pll_locked_hip,
  output wire pll_cal_busy,
  output wire hip_cal_done,
  
  // dps ports 
  input phase_reset, 
  input phase_enable, 
  input updn,
  input [3:0] cntsel,    
  input [2:0] num_phase_shifts,
  output wire phase_done, 

  // M CGB ports 
  input mcgb_aux_clk0,                                                                                             
  input mcgb_aux_clk1,                                                                                             
  input mcgb_aux_clk2,                                                                                             
//  input [1:0] mcgb_pcie_sw,
  input  mcgb_rst,
  output  mcgb_rst_stat,
  output wire [5:0] tx_bonding_clocks,
  output wire mcgb_serial_clk,                    
//  output wire [1:0] mcgb_pcie_sw_done,

  output wire clklow,
  output wire fref,

  input reconfig_clk0,
  input reconfig_reset0,
  input reconfig_write0,
  input reconfig_read0,
  input [10:0] reconfig_address0,                        
  input [SIZE_AVMM_WRDATA_BUS-1:0] reconfig_writedata0,
  output wire [SIZE_AVMM_RDDATA_BUS-1:0] reconfig_readdata0,
  output wire avmm_busy0,
  output wire reconfig_waitrequest0,

  input reconfig_clk1,
  input reconfig_reset1,
  input reconfig_write1,
  input reconfig_read1,
  input [10:0] reconfig_address1,
  input [SIZE_AVMM_WRDATA_BUS-1:0] reconfig_writedata1,
  output wire [SIZE_AVMM_RDDATA_BUS-1:0] reconfig_readdata1,
  output wire avmm_busy1,
  output wire reconfig_waitrequest1,
  output wire mcgb_cal_busy,   
  output wire mcgb_hip_cal_done, 

  input [1:0] pcie_sw, 
  output wire [1:0] pcie_sw_done,
  output wire [1:0] pld_hssi_osc_transfer_en

);
  localparam REFIQCLK_SIZE = 12;
  localparam REFCLK_CNT = 5;


wire pll_powerdown_wire;
wire mcgb_rst_wire;

// reconfig block inserted between pll_powerdown_wire and pll_powerdown
// so no need for the following line
// assign pll_powerdown_wire = pll_powerdown;

  generate 
     if (enable_mcgb && enable_mcgb_reset) begin
        wire clk;
        wire reset_n;

        //***************************************************************************
        // Getting the clock from Master TRS
        //***************************************************************************
        altera_s10_xcvr_clkout_endpoint clock_endpoint (  
     .clk_out(clk)
        );  

        //***************************************************************************
        // Need to self-generate internal reset signal
        //***************************************************************************
/*  // changing to altera_std_synchronizer_nocut
        alt_xcvr_resync_std #(
     .SYNC_CHAIN_LENGTH(3),
     .INIT_VALUE(0)
        ) reset_n_generator (
     .clk         (clk),
     .reset (1'b0),
     .d   (1'b1),
     .q   (reset_n)
        );
*/

       altera_std_synchronizer_nocut #(
           .depth(3),
           .rst_value(0)
          )  reset_n_generator  (
           .clk(clk), 
           .reset_n(1'b1), 
           .din (1'b1), 
           .dout(reset_n)
       );


        alt_xcvr_native_anlg_reset_seq #( 
          .CLK_FREQ_IN_HZ               (125000000),
    .DEFAULT_RESET_SEPARATION_NS  (200),
    .RESET_SEPARATION_NS          (200),  
    .NUM_RESETS                   (1)
        ) mcgb_rst_seq (
          .clk        (clk),    
          .reset_n      (reset_n),
          .reset_in     (mcgb_rst),
          .reset_out      (mcgb_rst_wire),
          .reset_stat_out   (mcgb_rst_stat)
        );      
     end else begin
        assign mcgb_rst_wire = mcgb_rst;
     end
  endgenerate

  wire refclk_sel_outclk; 
  wire pll_cout0; 
  wire pll_cout1; 
  wire pll_cout2; 
  wire pll_cout3; 

  // wire declarations for pll adapt connections 
  wire w_phase_reset; 
  wire w_phase_enable; 
  wire w_pll_powerdown;
  wire w_updn;
  wire [3:0] w_cntsel;
  wire [2:0] w_num_phase_shifts; 
  wire w_clklow; 
  wire w_fref; 
  wire w_pll_locked;
  wire w_phase_done;
  wire w_pll_cout0; 
  wire w_pll_cout1; 
  wire w_pll_cout2; 
  wire w_pll_cout3; 

  // Wire around the HIP
  wire pll_powerdown_adapt;
  wire pll_powerdown_fpll;
  wire mcgb_rst_adapt;
  wire mcgb_rst_mcgb;
  wire w_mcgb_rst; 
 
   // Wire for FPLL DPS
   wire final_phase_en;
   wire final_phase_reset;
   wire pre_phase_done;
 
  // define the avmm interfaces depending on whether master CGB is enabled or not. 
//  localparam avmm_interfaces = (enable_mcgb == 1) && (enable_mcgb_debug_ports_parameters==1) ? 2 : 1;
  localparam avmm_interfaces = (enable_mcgb == 1) ? 2 : 1;

  // upper 24 bits are not used, but should not be left at X
////  assign reconfig_readdata0[SIZE_AVMM_RDDATA_BUS-1:8] =  0;
  assign reconfig_readdata1[SIZE_AVMM_RDDATA_BUS-1:8] =  0;

  //// mcgb_serial_clk connection  
    // OPEN find a better way for the following parameters
   localparam SIZE_CGB_BONDING_CLK = 6;
   localparam SIZE_REFIQCLK = 12;

   localparam RCFG_ADDR_BITS = 11;
   
   assign mcgb_serial_clk = tx_bonding_clocks[SIZE_CGB_BONDING_CLK-1];


  //-----------------------------------
  // reconfigAVMM to pllAtoms internal wires  
  // interface #0 to PLL, interface #1 to CGB 
  wire [avmm_interfaces-1    :0]  pll_avmm_clk;
  //wire [avmm_interfaces-1    :0]  pll_avmm_rstn;
  wire [avmm_interfaces*8-1  :0]  pll_avmm_writedata;
  wire [avmm_interfaces*10-1 :0]  pll_avmm_address;
  wire [avmm_interfaces-1    :0]  pll_avmm_write;
  wire [avmm_interfaces-1    :0]  pll_avmm_read;

  wire [avmm_interfaces*8-1  :0]  pll_avmmreaddata_fpll;                        // NOTE only [7:0] is used
  wire [avmm_interfaces*8-1  :0]  pll_avmmreaddata_refclk;                    // NOTE only [7:0] is used
  wire [avmm_interfaces*8-1  :0]  pll_avmmreaddata_mcgb;                      // NOTE only [15:8] is used
  wire [avmm_interfaces-1    :0]  pll_blockselect_fpll;                         // NOTE only [0:0] is used
  wire [avmm_interfaces-1    :0]  pll_blockselect_refclk;                     // NOTE only [0:0] is used
  wire [avmm_interfaces-1    :0]  pll_blockselect_mcgb;                       // NOTE only [1:1] is used

  wire dummybit;
  //-----------------------------------
  
  wire            avmm_clk_refclk,       avmm_clk_fpll,       avmm_clk_mcgb;
  //wire          avmm_rstn_refclk,      avmm_rstn_fpll,      avmm_rstn_mcgb;
  wire [7:0]      avmm_writedata_refclk, avmm_writedata_fpll, avmm_writedata_mcgb;
  //wire [8:0]    avmm_address_refclk,   avmm_address_fpll,   avmm_address_mcgb;
  //wire [9:0]      avmm_address_refclk,   avmm_address_fpll,   avmm_address_mcgb;   
  wire [9:0]      avmm_address_refclk,   avmm_address_mcgb;   
  wire [8:0]  avmm_address_fpll;  

wire            avmm_write_refclk,     avmm_write_fpll,     avmm_write_mcgb;
  wire            avmm_read_refclk,      avmm_read_fpll,      avmm_read_mcgb;
  wire [7:0]      avmmreaddata_refclk,   avmmreaddata_fpll,   avmmreaddata_mcgb;
  wire            blockselect_refclk,    blockselect_fpll,    blockselect_mcgb;
   
  //-----------------------------------
  // reconfigAVMM to top wrapper wires  
  // interface #0 to PLL, interface #1 to CGB 
  wire [avmm_interfaces-1    :0]  reconfig_clk;
  wire [avmm_interfaces-1    :0]  reconfig_reset;
  wire [avmm_interfaces*8-1  :0]  reconfig_writedata;
  wire [avmm_interfaces*10-1 :0]  reconfig_address;
  wire [avmm_interfaces-1    :0]  reconfig_write;
  wire [avmm_interfaces-1    :0]  reconfig_read;
  wire [avmm_interfaces*8-1  :0]  reconfig_readdata;
  wire [avmm_interfaces-1    :0]  reconfig_waitrequest;
  wire [avmm_interfaces-1    :0]  avmm_busy;
  wire [avmm_interfaces-1    :0]  pld_cal_done;
  wire [avmm_interfaces-1    :0]  hip_cal_done_w;

  // AVMM reconfiguration signals for the hardware
  wire [avmm_interfaces-1:0]      avmm_write;
  wire [avmm_interfaces-1:0]      avmm_read;
  wire [avmm_interfaces-1:0]      avmm_waitrequest;
  wire [avmm_interfaces*8-1:0]    avmm_readdata;


   // AVMM reconfiguration signals for embedded debug
   wire [7:0]    debug_writedata;
   wire        debug_clk;
   wire        debug_reset;
   wire [10:0]   debug_address; 
   wire        debug_write;
   wire        debug_read;
   wire        debug_busy;
   wire        debug_waitrequest;
   wire [7:0]    debug_readdata;

   wire [avmm_interfaces-1:0]   pld_hssi_osc_transfer_en_wire;

  // optional OSC transfer enable assignment with and w/o MCGB
  generate
    if(avmm_interfaces == 1) 
      assign pld_hssi_osc_transfer_en = {1'b0,pld_hssi_osc_transfer_en_wire};
    else
      assign pld_hssi_osc_transfer_en = pld_hssi_osc_transfer_en_wire;
  endgenerate


  // avmm signals shared accross all interfaces
  assign reconfig_clk[0]              = debug_clk;
  assign reconfig_reset[0]            = debug_reset;
  assign reconfig_writedata[7:0]      = debug_writedata;
  assign reconfig_address[9:0]        = debug_address[9:0];
  assign reconfig_write[0]            = debug_write;
  assign reconfig_read[0]             = debug_read;
  assign debug_readdata               = reconfig_readdata[7:0];
  assign debug_waitrequest            = reconfig_waitrequest[0];

//  assign reconfig_readdata0[7:0]      = debug_readdata;
//  assign reconfig_waitrequest0        = debug_waitrequest;

//  assign reconfig_clk[0]              = reconfig_clk0;
//  assign reconfig_reset[0]            = reconfig_reset0;
//  assign reconfig_writedata[7:0]      = reconfig_writedata0[7:0];
//  assign reconfig_address[9:0]        = reconfig_address0[9:0];
//  assign reconfig_write[0]            = reconfig_write0;
//  assign reconfig_read[0]             = reconfig_read0;
//  assign reconfig_readdata0[7:0]      = reconfig_readdata[7:0];
//  assign reconfig_waitrequest0        = reconfig_waitrequest[0];

  assign avmm_busy0 = avmm_busy[0];
  assign hip_cal_done = hip_cal_done_w[0];
  //---
  assign mcgb_cal_busy = 1'b0;
  assign pll_cal_busy = ~pld_cal_done[0];

  generate
    if (avmm_interfaces == 2) begin
      assign reconfig_clk[1]              = reconfig_clk1;
      assign reconfig_reset[1]            = reconfig_reset1;
      assign reconfig_writedata[15:8]     = reconfig_writedata1[7:0];
      assign reconfig_address[19:10]      = reconfig_address1[9:0];
      assign reconfig_write[1]            = reconfig_write1;
      assign reconfig_read[1]             = reconfig_read1;
      assign reconfig_readdata1[7:0]      = reconfig_readdata[15:8];
      assign reconfig_waitrequest1        = reconfig_waitrequest[1];
      assign avmm_busy1                   = avmm_busy[1];
      //assign mcgb_cal_busy              = ~pld_cal_done[1];
      assign mcgb_hip_cal_done            = hip_cal_done_w[1];
     end else begin
      assign reconfig_readdata1[7:0]      = 8'b0;
      assign reconfig_waitrequest1        = 1'b0;
      assign avmm_busy1                   = 1'b0;
      assign mcgb_hip_cal_done            = 1'b0;
     end
  endgenerate
  
  assign pll_avmmreaddata_mcgb[7:0] = { 8 {1'b0} };                           // NOTE only [15:8] is used, hence [7:0] is tied-off to '0'
  assign pll_blockselect_mcgb[0:0] = {1'b0};                                  // NOTE only [1:1] is used, hence [0:0] is tied-off to '0'
  
  generate
   if (avmm_interfaces==2) begin
      assign pll_avmmreaddata_fpll[avmm_interfaces*8-1:8]     = { 8 {1'b0} };             // NOTE only [7:0] is used, hence [15:8] is tied-off to '0'
      assign pll_avmmreaddata_refclk[avmm_interfaces*8-1:8]   = { 8 {1'b0} };   // NOTE only [7:0] is used, hence [15:8] is tied-off to '0'
  
      assign pll_blockselect_fpll[avmm_interfaces-1:1]        = {1'b0};                      // NOTE only [0:0] is used, hence [1:1] is tied-off to '0'
      assign pll_blockselect_refclk[avmm_interfaces-1:1]      = {1'b0};            // NOTE only [0:0] is used, hence [1:1] is tied-off to '0'
  
      assign avmm_clk_mcgb                  = pll_avmm_clk[1];
      //assign avmm_rstn_mcgb               = pll_avmm_rstn[1];
      assign avmm_writedata_mcgb            = pll_avmm_writedata[15:8];
      //assign avmm_address_mcgb            = pll_avmm_address[17:9];
      assign avmm_address_mcgb              = pll_avmm_address[19:10];   
      assign avmm_write_mcgb                = pll_avmm_write[1];
      assign avmm_read_mcgb                 = pll_avmm_read[1];
      assign pll_avmmreaddata_mcgb[15:8]    = avmmreaddata_mcgb;
      assign pll_blockselect_mcgb[1]        = blockselect_mcgb;
   end
  endgenerate
  
  assign avmm_clk_refclk                    = pll_avmm_clk[0];
  //assign avmm_rstn_refclk                 = pll_avmm_rstn[0];
  assign avmm_writedata_refclk              = pll_avmm_writedata[7:0];
  //assign avmm_address_refclk              = pll_avmm_address[8:0];
  assign avmm_address_refclk                = pll_avmm_address[9:0];   
  assign avmm_write_refclk                  = pll_avmm_write[0];
  assign avmm_read_refclk                   = pll_avmm_read[0];
  assign pll_avmmreaddata_refclk[7:0]       = avmmreaddata_refclk;
  assign pll_blockselect_refclk[0]          = blockselect_refclk;

  assign avmm_clk_fpll                      = pll_avmm_clk[0];
  //assign avmm_rstn_fpll                   = pll_avmm_rstn[0];
  assign avmm_writedata_fpll                = pll_avmm_writedata[7:0];
  assign avmm_address_fpll                = pll_avmm_address[8:0];  // reg_addr in the atom is 9 bits.
  //assign avmm_address_fpll                  = pll_avmm_address[9:0];   
  assign avmm_write_fpll                    = pll_avmm_write[0];
  assign avmm_read_fpll                     = pll_avmm_read[0];
  assign pll_avmmreaddata_fpll[7:0]         = avmmreaddata_fpll;
  assign pll_blockselect_fpll[0]            = blockselect_fpll;
  
//---------------------------------------------------------------------------------------
// Reconfiguration Logic Wrapper
//  This wrapper contains CSR soft registers (user AVMM), a reconfig streamer, 
//  an ADME, and the arbiter for these three agents
//---------------------------------------------------------------------------------------
//TODO: check if this is set correctly
//TODO: check if RECONFIG_SHARED is set correctly
localparam lcl_adme_assgn_map = {" assignments {device_revision ",hssi_avmm2_if_silicon_rev,"}"};
localparam rcfg_shared        = 0;


alt_xcvr_pll_rcfg_opt_logic_qjyjjoy 
#(
  .dbg_user_identifier          (dbg_user_identifier                ),
  .dbg_embedded_debug_enable    (dbg_embedded_debug_enable          ),
  .dbg_capability_reg_enable    (dbg_capability_reg_enable          ),
  .dbg_stat_soft_logic_enable   (dbg_stat_soft_logic_enable         ),
  .dbg_ctrl_soft_logic_enable   (dbg_ctrl_soft_logic_enable         ),
  .en_master_cgb                (0                                  ),
  .INTERFACES                   (1                                  ),
  .ADDR_BITS                    (11                                 ),
  .ADME_SLAVE_MAP               ("altera_xcvr_fpll_s10_htile"       ),
  .ADME_ASSGN_MAP               (lcl_adme_assgn_map                 ),
  .RECONFIG_SHARED              (rcfg_enable && rcfg_shared         ),
  .JTAG_ENABLED                 (rcfg_enable && rcfg_jtag_enable    ),
  .RCFG_EMB_STRM_ENABLED        (rcfg_enable && rcfg_emb_strm_enable),
  .RCFG_PROFILE_CNT             (rcfg_profile_cnt                   )
) 
alt_xcvr_pll_optional_rcfg_logic 
(
  //User AVMM Interface
  .reconfig_clk                 (reconfig_clk0        ), //Input 
  .reconfig_reset               (reconfig_reset0      ), //Input
  .reconfig_write               (reconfig_write0      ), //Input
  .reconfig_read                (reconfig_read0       ), //Input
  .reconfig_address             (reconfig_address0    ), //Input
  .reconfig_writedata           (reconfig_writedata0  ), //Input
  .reconfig_readdata            (reconfig_readdata0   ), //Output 
  .reconfig_waitrequest         (reconfig_waitrequest0), //Output
  
  // Arbiter AVMM Master Interface (to PLL IPs)                     
  .avmm_clk                     (debug_clk           ), //Output
  .avmm_reset                   (debug_reset         ), //Output
  .avmm_write                   (debug_write         ), //Output
  .avmm_read                    (debug_read          ), //Output
  .avmm_address                 (debug_address       ), //Output
  .avmm_writedata               (debug_writedata     ), //Output
  .avmm_readdata                (debug_readdata      ), //Input
  .avmm_waitrequest             (debug_waitrequest   ), //Input
  
  // CSR soft register status inputs 
  .in_pll_powerdown             (pll_powerdown ),
  .in_pll_locked                (pll_locked    ),
  .in_pll_cal_busy              (pll_cal_busy  ),
  .in_avmm_busy                 (avmm_busy0    ),
  
  // CSR soft register status outputs 
  .out_pll_powerdown            (pll_powerdown_wire   )

);



   
   //***************** End Embedded JTAG and AVMM Expansion ********************
   //***************************************************************************


  localparam  MAX_CONVERSION_SIZE_ALT_XCVR_FPLL_S10 = 128;
  localparam  MAX_STRING_CHARS_ALT_XCVR_FPLL_S10  = 64;
  
  // STRING TO BINARY FUNCTION 
  function automatic [MAX_CONVERSION_SIZE_ALT_XCVR_FPLL_S10-1:0] str_2_bin_altera_xcvr_fpll_s10;
  input [MAX_STRING_CHARS_ALT_XCVR_FPLL_S10*8-1:0] instring;
  
  integer this_char;
  integer i;
  begin
    // Initialize accumulator
    str_2_bin_altera_xcvr_fpll_s10 = {MAX_CONVERSION_SIZE_ALT_XCVR_FPLL_S10{1'b0}};
    for(i=MAX_STRING_CHARS_ALT_XCVR_FPLL_S10-1;i>=0;i=i-1) begin
      this_char = instring[i*8+:8];
      // Add value of this digit
      if(this_char >= 48 && this_char <= 57)
        str_2_bin_altera_xcvr_fpll_s10 = (str_2_bin_altera_xcvr_fpll_s10 * 10) + (this_char - 48);
    end
  end
  endfunction

  // converting the following parameters into bitvec
  // cmu_fpll_atom bitvecs >= 32 bits (str2bin)
  localparam [127:0] temp_cmu_fpll_datarate_bps            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_datarate_bps);     
  localparam [127:0] temp_cmu_fpll_f_out_c0                = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_out_c0);   
  localparam [127:0] temp_cmu_fpll_f_out_c0_hz             = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_out_c0_hz);      
  localparam [127:0] temp_cmu_fpll_f_out_c1              = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_out_c1);   
  localparam [127:0] temp_cmu_fpll_f_out_c1_hz             = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_out_c1_hz);    
  localparam [127:0] temp_cmu_fpll_f_out_c2              = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_out_c2); 
  localparam [127:0] temp_cmu_fpll_f_out_c2_hz             = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_out_c2_hz);    
  localparam [127:0] temp_cmu_fpll_f_out_c3              = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_out_c3);   
  localparam [127:0] temp_cmu_fpll_f_out_c3_hz             = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_out_c3_hz);      
  localparam [127:0] temp_cmu_fpll_out_freq              = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_out_freq); 
  localparam [127:0] temp_cmu_fpll_out_freq_hz             = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_out_freq_hz);    
  localparam [127:0] temp_cmu_fpll_pfd_freq              = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_pfd_freq); 
  localparam [127:0] temp_cmu_fpll_phase_shift_c0      = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_phase_shift_c0);   
  localparam [127:0] temp_cmu_fpll_phase_shift_c1        = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_phase_shift_c1);     
  localparam [127:0] temp_cmu_fpll_phase_shift_c2          = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_phase_shift_c2);       
  localparam [127:0] temp_cmu_fpll_phase_shift_c3        = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_phase_shift_c3);     
  localparam [127:0] temp_cmu_fpll_refclk            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_refclk); 
  localparam [127:0] temp_cmu_fpll_vco_freq              = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_vco_freq); 
  localparam [127:0] temp_cmu_fpll_vco_freq_hz             = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_vco_freq_hz);    
  localparam [127:0] temp_cmu_fpll_pll_fractional_division = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_pll_fractional_division);    
 
  localparam [127:0] temp_cmu_fpll_f_max_band_0            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_0);
  localparam [127:0] temp_cmu_fpll_f_max_band_1            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_1);
  localparam [127:0] temp_cmu_fpll_f_max_band_2            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_2);
  localparam [127:0] temp_cmu_fpll_f_max_band_3            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_3);
  localparam [127:0] temp_cmu_fpll_f_max_band_4            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_4);
  localparam [127:0] temp_cmu_fpll_f_max_band_5            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_5);
  localparam [127:0] temp_cmu_fpll_f_max_band_6            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_6);
  localparam [127:0] temp_cmu_fpll_f_max_band_7            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_7);
  localparam [127:0] temp_cmu_fpll_f_max_band_8            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_8);
  localparam [127:0] temp_cmu_fpll_f_max_band_9            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_band_9);
  localparam [127:0] temp_cmu_fpll_f_max_div_two_bypass    = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_div_two_bypass);
  localparam [127:0] temp_cmu_fpll_f_max_pfd               = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_pfd);
  localparam [127:0] temp_cmu_fpll_f_max_pfd_bonded        = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_pfd_bonded);
  localparam [127:0] temp_cmu_fpll_f_max_pfd_fractional    = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_pfd_fractional);
  localparam [127:0] temp_cmu_fpll_f_max_pfd_integer       = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_pfd_integer);
  localparam [127:0] temp_cmu_fpll_f_max_vco               = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_vco);
  localparam [127:0] temp_cmu_fpll_f_max_vco_fractional    = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_max_vco_fractional);
  localparam [127:0] temp_cmu_fpll_f_min_band_0            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_0);
  localparam [127:0] temp_cmu_fpll_f_min_band_1            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_1);
  localparam [127:0] temp_cmu_fpll_f_min_band_2            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_2);
  localparam [127:0] temp_cmu_fpll_f_min_band_3            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_3);
  localparam [127:0] temp_cmu_fpll_f_min_band_4            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_4);
  localparam [127:0] temp_cmu_fpll_f_min_band_5            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_5);
  localparam [127:0] temp_cmu_fpll_f_min_band_6            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_6);
  localparam [127:0] temp_cmu_fpll_f_min_band_7            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_7);
  localparam [127:0] temp_cmu_fpll_f_min_band_8            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_8);
  localparam [127:0] temp_cmu_fpll_f_min_band_9            = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_band_9);
  localparam [127:0] temp_cmu_fpll_f_min_pfd               = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_pfd);
  localparam [127:0] temp_cmu_fpll_f_min_vco               = str_2_bin_altera_xcvr_fpll_s10(cmu_fpll_f_min_vco);



  // to avoid warnings 
  localparam [35:0] lcl_cmu_fpll_datarate_bps              = temp_cmu_fpll_datarate_bps [35:0];          
  localparam [35:0] lcl_cmu_fpll_f_out_c0                  = temp_cmu_fpll_f_out_c0 [35:0];              
  localparam [35:0] lcl_cmu_fpll_f_out_c0_hz               = temp_cmu_fpll_f_out_c0_hz [35:0];           
  localparam [35:0] lcl_cmu_fpll_f_out_c1              = temp_cmu_fpll_f_out_c1 [35:0];            
  localparam [35:0] lcl_cmu_fpll_f_out_c1_hz             = temp_cmu_fpll_f_out_c1_hz [35:0];             
  localparam [35:0] lcl_cmu_fpll_f_out_c2              = temp_cmu_fpll_f_out_c2 [35:0];              
  localparam [35:0] lcl_cmu_fpll_f_out_c2_hz             = temp_cmu_fpll_f_out_c2_hz [35:0];             
  localparam [35:0] lcl_cmu_fpll_f_out_c3              = temp_cmu_fpll_f_out_c3 [35:0];              
  localparam [35:0] lcl_cmu_fpll_f_out_c3_hz             = temp_cmu_fpll_f_out_c3_hz [35:0];             
  localparam [35:0] lcl_cmu_fpll_out_freq              = temp_cmu_fpll_out_freq [35:0];              
  localparam [35:0] lcl_cmu_fpll_out_freq_hz             = temp_cmu_fpll_out_freq_hz [35:0];             
  localparam [35:0] lcl_cmu_fpll_pfd_freq              = temp_cmu_fpll_pfd_freq [35:0];            
  localparam [35:0] lcl_cmu_fpll_phase_shift_c0          = temp_cmu_fpll_phase_shift_c0 [35:0];      
  localparam [35:0] lcl_cmu_fpll_phase_shift_c1            = temp_cmu_fpll_phase_shift_c1 [35:0];       
  localparam [35:0] lcl_cmu_fpll_phase_shift_c2            = temp_cmu_fpll_phase_shift_c2 [35:0];       
  localparam [35:0] lcl_cmu_fpll_phase_shift_c3            = temp_cmu_fpll_phase_shift_c3 [35:0];       
  localparam [35:0] lcl_cmu_fpll_refclk                = temp_cmu_fpll_refclk [35:0];         
  localparam [35:0] lcl_cmu_fpll_vco_freq              = temp_cmu_fpll_vco_freq [35:0];          
  localparam [35:0] lcl_cmu_fpll_vco_freq_hz             = temp_cmu_fpll_vco_freq_hz [35:0];         
  localparam [31:0] lcl_cmu_fpll_pll_fractional_division   = temp_cmu_fpll_pll_fractional_division [31:0];

localparam [35:0] lcl_cmu_fpll_f_max_band_0            = temp_cmu_fpll_f_max_band_0 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_band_1            = temp_cmu_fpll_f_max_band_1 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_band_2            = temp_cmu_fpll_f_max_band_2 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_band_3            = temp_cmu_fpll_f_max_band_3 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_band_4            = temp_cmu_fpll_f_max_band_4 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_band_5            = temp_cmu_fpll_f_max_band_5 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_band_6            = temp_cmu_fpll_f_max_band_6 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_band_7            = temp_cmu_fpll_f_max_band_7 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_band_8            = temp_cmu_fpll_f_max_band_8 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_band_9            = temp_cmu_fpll_f_max_band_9 [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_div_two_bypass    = temp_cmu_fpll_f_max_div_two_bypass [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_pfd               = temp_cmu_fpll_f_max_pfd [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_pfd_bonded        = temp_cmu_fpll_f_max_pfd_bonded [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_pfd_fractional    = temp_cmu_fpll_f_max_pfd_fractional [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_pfd_integer       = temp_cmu_fpll_f_max_pfd_integer [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_vco               = temp_cmu_fpll_f_max_vco [35:0];
localparam [35:0] lcl_cmu_fpll_f_max_vco_fractional    = temp_cmu_fpll_f_max_vco_fractional [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_0            = temp_cmu_fpll_f_min_band_0 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_1            = temp_cmu_fpll_f_min_band_1 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_2            = temp_cmu_fpll_f_min_band_2 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_3            = temp_cmu_fpll_f_min_band_3 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_4            = temp_cmu_fpll_f_min_band_4 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_5            = temp_cmu_fpll_f_min_band_5 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_6            = temp_cmu_fpll_f_min_band_6 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_7            = temp_cmu_fpll_f_min_band_7 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_8            = temp_cmu_fpll_f_min_band_8 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_band_9            = temp_cmu_fpll_f_min_band_9 [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_pfd               = temp_cmu_fpll_f_min_pfd [35:0];
localparam [35:0] lcl_cmu_fpll_f_min_vco               = temp_cmu_fpll_f_min_vco [35:0];


  


  // Master CGB atom bitvecs (str2bin)
  localparam [127:0] temp_hssi_pma_cgb_master_datarate_bps = str_2_bin_altera_xcvr_fpll_s10(hssi_pma_cgb_master_datarate_bps);
  // to avoid warnings 
  localparam [35:0] lcl_hssi_pma_cgb_master_datarate_bps   = temp_hssi_pma_cgb_master_datarate_bps [35:0];

  //-----------------------------------
  // instantiation of ct1_fpll_refclk_select
  ct1_cmu_fpll_refclk_select 
  #( 
    // H-Tile specific
    // TODO - These need to be modified once the atom is fixed (see case 414064)
    // Hardcoding IQCLK line selection for front-end and back-end mux physical setting until FB is fixed.
    .xpm_clkin_fpll_pll_clkin_0_src("pll_clkin_0_src_ref_clk"), 
    .xpm_iqref_mux0_iqclk_sel ("ref_iqclk0"),
    // End H-Tile specific
    .refclk_select0(cmu_fpll_refclk_select_mux_refclk_select0),                               
    .refclk_select1(cmu_fpll_refclk_select_mux_refclk_select1),                               
    .mux0_inclk0_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux0_inclk0_logical_to_physical_mapping),      
    .mux0_inclk1_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux0_inclk1_logical_to_physical_mapping),      
    .mux0_inclk2_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux0_inclk2_logical_to_physical_mapping),      
    .mux0_inclk3_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux0_inclk3_logical_to_physical_mapping),      
    .mux0_inclk4_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux0_inclk4_logical_to_physical_mapping),      
    .mux1_inclk0_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux1_inclk0_logical_to_physical_mapping),      
    .mux1_inclk1_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux1_inclk1_logical_to_physical_mapping),      
    .mux1_inclk2_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux1_inclk2_logical_to_physical_mapping),      
    .mux1_inclk3_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux1_inclk3_logical_to_physical_mapping),      
    .mux1_inclk4_logical_to_physical_mapping(cmu_fpll_refclk_select_mux_mux1_inclk4_logical_to_physical_mapping),
    .clk_sel_override(cmu_fpll_refclk_select_mux_clk_sel_override),                             
    .clk_sel_override_value(cmu_fpll_refclk_select_mux_clk_sel_override_value),                       
    //.xpm_clkin_fpll_pll_clkin_1_src(cmu_fpll_refclk_select_mux_xpm_clkin_fpll_pll_clkin_1_src), TODO: remove if it does not break C1. This should not need to be passed down. 
    .xpm_clkin_fpll_xpm_pll_so_pll_auto_clk_sw_en(cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_auto_clk_sw_en), 
    .xpm_clkin_fpll_xpm_pll_so_pll_clk_loss_edge(cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_clk_loss_edge),  
    .xpm_clkin_fpll_xpm_pll_so_pll_clk_loss_sw_en(cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_clk_loss_sw_en), 
    .xpm_clkin_fpll_xpm_pll_so_pll_manu_clk_sw_en(cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_manu_clk_sw_en), 
    .xpm_clkin_fpll_xpm_pll_so_pll_sw_refclk_src(cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_sw_refclk_src),  
    .silicon_rev(cmu_fpll_refclk_select_mux_silicon_rev),                                  
    //bitvec 
    .xpm_clkin_fpll_xpm_pll_so_pll_clk_sw_dly(cmu_fpll_refclk_select_mux_xpm_clkin_fpll_xpm_pll_so_pll_clk_sw_dly)     
                                                                
  ) fpll_refclk_select_inst (
    // Input Ports
    .lvpecl_in         (1'b0),
    .pll_cas_in        (1'b0),
    .core_refclk       (1'b0),
    .tx_rx_core_refclk (1'b0),
    .ref_iqclk         ({{(SIZE_REFIQCLK-REFCLK_CNT){1'b0}}, {pll_refclk4, pll_refclk3, pll_refclk2, pll_refclk1, pll_refclk0}}),
    .extswitch         (1'b0),
    .iqtxrxclk         (6'd0),

    // Output Ports
    .clk0bad(/* unconnected */),
    .clk1bad(/* unconnected */),
    .extswitch_buf(/* unconnected */),
    .clkout(refclk_sel_outclk),
    .pllclksel(/* unconnected */),

    //-----------------------------------          
    .avmmaddress(avmm_address_refclk),
    .avmmclk(avmm_clk_refclk),
    .avmmread(avmm_read_refclk),
    //.avmmrstn(avmm_rstn_refclk),
    .avmmwrite(avmm_write_refclk),
    .avmmwritedata(avmm_writedata_refclk),
    .avmmreaddata(avmmreaddata_refclk),
    .blockselect(blockselect_refclk)
    //-----------------------------------
  );

  assign pll_powerdown_fpll   = (enable_pcie_hip_connectivity) ? pll_powerdown   : w_pll_powerdown;
  assign pll_powerdown_adapt  = (enable_pcie_hip_connectivity) ? 1'b0            : ~pll_powerdown_wire;
  assign mcgb_rst_mcgb        = (enable_pcie_hip_connectivity) ? mcgb_rst        : w_mcgb_rst;
  assign mcgb_rst_adapt       = (enable_pcie_hip_connectivity) ? 1'b0            : ~mcgb_rst_wire;

  ct1_hssi_cr2_cmu_fpll
  #(
     //H-tile specific
    .bcm_silicon_rev                  (cmu_fpll_bcm_silicon_rev),  
    .cal_reserved                     (cmu_fpll_cal_reserved),
    .dyn_reconfig                     (cmu_fpll_dyn_reconfig),
    .lckdet_sel                       (cmu_fpll_lckdet_sel),
    .ppmdtct_lock_thresld             (cmu_fpll_ppmdtct_lock_thresld),
    .ppmdtct_noclk_thresld            (cmu_fpll_ppmdtct_noclk_thresld),
    .ppmdtct_pll_sel                  (cmu_fpll_ppmdtct_pll_sel),
    .enable_hclk                      (cmu_fpll_enable_hclk),
    .powermode_ac_vco                (cmu_fpll_powermode_ac_vco),
    .powermode_dc_vco                (cmu_fpll_powermode_dc_vco),
    .powermode_ac_lcnt                (cmu_fpll_powermode_ac_lcnt),
    .powermode_dc_lcnt                (cmu_fpll_powermode_dc_lcnt),
    .atb_atb                          (cmu_fpll_atb_atb), 
    .powermode_ac_ccnt0               (cmu_fpll_powermode_ac_ccnt0),
    .powermode_ac_ccnt1               (cmu_fpll_powermode_ac_ccnt1),
    .powermode_ac_ccnt2               (cmu_fpll_powermode_ac_ccnt2),
    .powermode_ac_ccnt3               (cmu_fpll_powermode_ac_ccnt3),
    .powermode_dc_ccnt0               (cmu_fpll_powermode_dc_ccnt0),
    .powermode_dc_ccnt1               (cmu_fpll_powermode_dc_ccnt1),
    .powermode_dc_ccnt2               (cmu_fpll_powermode_dc_ccnt2),
    .powermode_dc_ccnt3               (cmu_fpll_powermode_dc_ccnt3),
    // End H-tile specific
    //.atb_atb                          (cmu_fpll_atb_atb), 
    //.dprio_clk_vreg_boost             (cmu_fpll_dprio_clk_vreg_boost), 
    //.dprio_vreg1_boost                (cmu_fpll_dprio_vreg1_boost), 
    //.dprio_vreg_boost                 (cmu_fpll_dprio_vreg_boost), 


    .analog_mode                        (cmu_fpll_analog_mode), 
    .power_mode                         (cmu_fpll_power_mode),
    .side                               (cmu_fpll_side),
    .compensation_mode                  (cmu_fpll_compensation_mode), 
    .hssi_output_clock_frequency        (cmu_fpll_hssi_output_clock_frequency), 
    .output_clock_frequency_0           (cmu_fpll_output_clock_frequency_0), 
    .output_clock_frequency_1           (cmu_fpll_output_clock_frequency_1), 
    .output_clock_frequency_2           (cmu_fpll_output_clock_frequency_2), 
    .output_clock_frequency_3           (cmu_fpll_output_clock_frequency_3), 
    .reference_clock_frequency          (cmu_fpll_reference_clock_frequency), 
    .vco_frequency                      (cmu_fpll_vco_frequency), 
      .bw_mode                          (cmu_fpll_bw_mode),    
      .feedback                         (cmu_fpll_feedback), 
    .cal_status                         (cmu_fpll_cal_status), 
    .cal_test_sel                       (cmu_fpll_cal_test_sel), 
    .calibration                        (cmu_fpll_calibration), 
    .cas_out_enable                     (cmu_fpll_cas_out_enable), 
    .pll_l_counter                      (cmu_fpll_pll_l_counter), 
    .cmu_rstn_value                     (cmu_fpll_cmu_rstn_value), 
    .hclk_out_enable                    (cmu_fpll_hclk_out_enable), 
    .iqtxrxclk_out_enable               (cmu_fpll_iqtxrxclk_out_enable), 
    .lpf_rstn_value                     (cmu_fpll_lpf_rstn_value), 
    .ppm_clk0_src                       (cmu_fpll_ppm_clk0_src), 
    .ppm_clk1_src                       (cmu_fpll_ppm_clk1_src), 
    .rstn_override                      (cmu_fpll_rstn_override), 
    .initial_settings                   (cmu_fpll_initial_settings), 
    .is_otn                             (cmu_fpll_is_otn), 
    .is_pa_core                         (cmu_fpll_is_pa_core), 
    .is_sdi                             (cmu_fpll_is_sdi), 
    .optimal                            (cmu_fpll_optimal), 
    .powerdown_mode                     (cmu_fpll_powerdown_mode), 
    .primary_use                        (cmu_fpll_primary_use), 
    .prot_mode                          (cmu_fpll_prot_mode), 
    .sup_mode                           (cmu_fpll_sup_mode), 
    .c0_pllcout_enable                  (cmu_fpll_c0_pllcout_enable), 
    .c0_cnt_min_tco                     (cmu_fpll_c0_cnt_min_tco), 
    .c0_m_cnt_in_src                    (cmu_fpll_c0_m_cnt_in_src), 
    .c0_coarse_dly                      (cmu_fpll_c0_coarse_dly), 
    .c0_fine_dly                        (cmu_fpll_c0_fine_dly), 
    .c1_pllcout_enable                  (cmu_fpll_c1_pllcout_enable), 
    .c1_cnt_min_tco                     (cmu_fpll_c1_cnt_min_tco), 
    .c1_m_cnt_in_src                    (cmu_fpll_c1_m_cnt_in_src), 
    .c1_coarse_dly                      (cmu_fpll_c1_coarse_dly), 
    .c1_fine_dly                        (cmu_fpll_c1_fine_dly), 
    .c2_pllcout_enable                  (cmu_fpll_c2_pllcout_enable), 
    .c2_cnt_min_tco                     (cmu_fpll_c2_cnt_min_tco), 
    .c2_m_cnt_in_src                    (cmu_fpll_c2_m_cnt_in_src), 
    .c2_coarse_dly                      (cmu_fpll_c2_coarse_dly), 
    .c2_fine_dly                        (cmu_fpll_c2_fine_dly), 
    .c3_pllcout_enable                  (cmu_fpll_c3_pllcout_enable), 
    .c3_cnt_min_tco                     (cmu_fpll_c3_cnt_min_tco), 
    .c3_m_cnt_in_src                    (cmu_fpll_c3_m_cnt_in_src),    
    .c3_coarse_dly                      (cmu_fpll_c3_coarse_dly), 
    .c3_fine_dly                        (cmu_fpll_c3_fine_dly), 
    .cal_vco_count_length               (cmu_fpll_cal_vco_count_length), 
    .refclk_source                      (cmu_fpll_refclk_source), 
    .vco_div_by_2_sel                   (cmu_fpll_vco_div_by_2_sel), 
    .pfd_delay_compensation             (cmu_fpll_pfd_delay_compensation), 
    .pfd_pulse_width                    (cmu_fpll_pfd_pulse_width), 
    .vccdreg_fb                         (cmu_fpll_vccdreg_fb), 
    .vccdreg_fw                         (cmu_fpll_vccdreg_fw), 
    .vreg0_atbsel                       (cmu_fpll_vreg0_atbsel), 
    .vreg1_atbsel                       (cmu_fpll_vreg1_atbsel), 
    .fb_cmp_buf_dly                     (cmu_fpll_fb_cmp_buf_dly), 
    .fb_fbclk_mux_1                     (cmu_fpll_fb_fbclk_mux_1), 
    .fb_fbclk_mux_2                     (cmu_fpll_fb_fbclk_mux_2), 
    .iqfb_mux_iqclk_sel                 (cmu_fpll_iqfb_mux_iqclk_sel), 
    .chgpmp_compensation                (cmu_fpll_chgpmp_compensation), 
    .chgpmp_current_setting             (cmu_fpll_chgpmp_current_setting), 
    .cp_current_boost                   (cmu_fpll_cp_current_boost), 
    .lf_3rd_pole_freq                   (cmu_fpll_lf_3rd_pole_freq), 
    .lf_cbig                            (cmu_fpll_lf_cbig), 
    .lf_order                           (cmu_fpll_lf_order), 
    .lf_resistance                      (cmu_fpll_lf_resistance), 
    .lf_ripplecap                       (cmu_fpll_lf_ripplecap), 
    .vco_ph0_en                         (cmu_fpll_vco_ph0_en), 
    .vco_ph0_value                      (cmu_fpll_vco_ph0_value), 
    .vco_ph1_en                         (cmu_fpll_vco_ph1_en), 
    .vco_ph1_value                      (cmu_fpll_vco_ph1_value), 
    .vco_ph2_en                         (cmu_fpll_vco_ph2_en), 
    .vco_ph2_value                      (cmu_fpll_vco_ph2_value), 
    .vco_ph3_en                         (cmu_fpll_vco_ph3_en), 
    .vco_ph3_value                      (cmu_fpll_vco_ph3_value), 
    .dsm_mode                           (cmu_fpll_dsm_mode), 
    .pll_dsm_out_sel                    (cmu_fpll_pll_dsm_out_sel), 
    .pll_ecn_bypass                     (cmu_fpll_pll_ecn_bypass), 
    .pll_ecn_test_en                    (cmu_fpll_pll_ecn_test_en), 
    .pll_fractional_value_ready         (cmu_fpll_pll_fractional_value_ready), 
    .lcnt_l_cnt_bypass                  (cmu_fpll_lcnt_l_cnt_bypass), 
    .lcnt_l_cnt_enable                  (cmu_fpll_lcnt_l_cnt_enable), 
    .lockf_lock_fltr_test               (cmu_fpll_lockf_lock_fltr_test), 
    .mcnt_cnt_min_tco                   (cmu_fpll_mcnt_cnt_min_tco), 
    .mcnt_m_cnt_in_src                  (cmu_fpll_mcnt_m_cnt_in_src), 
    .mcnt_coarse_dly                    (cmu_fpll_mcnt_coarse_dly), 
    .mcnt_fine_dly                      (cmu_fpll_mcnt_fine_dly), 
    .ncnt_coarse_dly                    (cmu_fpll_ncnt_coarse_dly), 
    .ncnt_fine_dly                      (cmu_fpll_ncnt_fine_dly), 
    .ref_ref_buf_dly                    (cmu_fpll_ref_ref_buf_dly), 
    .testmux_tclk_mux_en                (cmu_fpll_testmux_tclk_mux_en), 
    .testmux_tclk_sel                   (cmu_fpll_testmux_tclk_sel), 
    .dprio_broadcast_en                 (cmu_fpll_dprio_broadcast_en), 
    .dprio_cvp_inter_sel                (cmu_fpll_dprio_cvp_inter_sel), 
    .dprio_force_inter_sel              (cmu_fpll_dprio_force_inter_sel), 
    .dprio_power_iso_en                 (cmu_fpll_dprio_power_iso_en), 
    .dprio_status_select                (cmu_fpll_dprio_status_select), 
    .ctrl_nreset_prgmnvrt               (cmu_fpll_ctrl_nreset_prgmnvrt), 
    .ctrl_ctrl_override_setting         (cmu_fpll_ctrl_ctrl_override_setting), 
    .ctrl_enable                        (cmu_fpll_ctrl_enable), 
    .ctrl_slf_rst                       (cmu_fpll_ctrl_slf_rst), 
    .ctrl_test_enable                   (cmu_fpll_ctrl_test_enable), 
    .ctrl_plniotri_override             (cmu_fpll_ctrl_plniotri_override), 
    .ctrl_vccr_pd                       (cmu_fpll_ctrl_vccr_pd), 
    .silicon_rev                        (cmu_fpll_silicon_rev), 
    .pll_op_mode                        (cmu_fpll_pll_op_mode), 
    .bw_sel                             (cmu_fpll_bw_sel), 
    .duty_cycle_0                       (cmu_fpll_duty_cycle_0), 
    .duty_cycle_1                       (cmu_fpll_duty_cycle_1), 
    .duty_cycle_2                       (cmu_fpll_duty_cycle_2), 
    .duty_cycle_3                       (cmu_fpll_duty_cycle_3), 
    .is_cascaded_pll                    (cmu_fpll_is_cascaded_pll), 
    .pll_vco_freq_band_0_fix_high       (cmu_fpll_pll_vco_freq_band_0_fix_high), 
    .pll_vco_freq_band_1_fix_high       (cmu_fpll_pll_vco_freq_band_1_fix_high), 
      // bitvec parameters < 32 bits  
    .cgb_div                            (cmu_fpll_cgb_div), 
    .l_counter                          (cmu_fpll_l_counter), 
    .m_counter                          (cmu_fpll_m_counter), 
    .m_counter_c0                       (cmu_fpll_m_counter_c0), 
    .m_counter_c1                       (cmu_fpll_m_counter_c1), 
    .m_counter_c2                       (cmu_fpll_m_counter_c2), 
    .m_counter_c3                       (cmu_fpll_m_counter_c3), 
    .n_counter                          (cmu_fpll_n_counter), 
    .pll_vco_freq_band_0_dyn_high_bits  (cmu_fpll_pll_vco_freq_band_0_dyn_high_bits), 
    .pll_vco_freq_band_0_dyn_low_bits   (cmu_fpll_pll_vco_freq_band_0_dyn_low_bits), 
    .pll_vco_freq_band_0_fix            (cmu_fpll_pll_vco_freq_band_0_fix), 
    .pll_vco_freq_band_1_dyn_high_bits  (cmu_fpll_pll_vco_freq_band_1_dyn_high_bits), 
    .pll_vco_freq_band_1_dyn_low_bits   (cmu_fpll_pll_vco_freq_band_1_dyn_low_bits), 
    .pll_vco_freq_band_1_fix            (cmu_fpll_pll_vco_freq_band_1_fix), 
    .pma_width                          (cmu_fpll_pma_width), 
    .set_input_freq_range               (cmu_fpll_set_input_freq_range), 
    .c0_cnt_div                         (cmu_fpll_c0_cnt_div), 
    .c0_m_cnt_ph_mux_prst               (cmu_fpll_c0_m_cnt_ph_mux_prst), 
    .c0_m_cnt_prst                      (cmu_fpll_c0_m_cnt_prst), 
    .c1_cnt_div                         (cmu_fpll_c1_cnt_div), 
    .c1_m_cnt_ph_mux_prst               (cmu_fpll_c1_m_cnt_ph_mux_prst), 
    .c1_m_cnt_prst                      (cmu_fpll_c1_m_cnt_prst), 
    .c2_cnt_div                         (cmu_fpll_c2_cnt_div), 
    .c2_m_cnt_ph_mux_prst               (cmu_fpll_c2_m_cnt_ph_mux_prst), 
    .c2_m_cnt_prst                      (cmu_fpll_c2_m_cnt_prst), 
    .c3_cnt_div                         (cmu_fpll_c3_cnt_div), 
    .c3_m_cnt_ph_mux_prst               (cmu_fpll_c3_m_cnt_ph_mux_prst), 
    .c3_m_cnt_prst                      (cmu_fpll_c3_m_cnt_prst), 
    .lockf_lock_fltr_cfg                (cmu_fpll_lockf_lock_fltr_cfg), 
    .lockf_unlock_fltr_cfg              (cmu_fpll_lockf_unlock_fltr_cfg), 
    .mcnt_cnt_div                       (cmu_fpll_mcnt_cnt_div), 
    .mcnt_m_cnt_ph_mux_prst             (cmu_fpll_mcnt_m_cnt_ph_mux_prst), 
    .mcnt_m_cnt_prst                    (cmu_fpll_mcnt_m_cnt_prst), 
    .ncnt_ncnt_divide                   (cmu_fpll_ncnt_ncnt_divide), 
    .dprio_base_addr                    (cmu_fpll_dprio_base_addr), 
    .extra_csr                          (cmu_fpll_extra_csr),
      
    .max_fractional_percentage          (cmu_fpll_max_fractional_percentage),
    .min_fractional_percentage          (cmu_fpll_min_fractional_percentage),

 
      // bitvecs >= 32 bits 
    .datarate_bps                 (lcl_cmu_fpll_datarate_bps), 
    .f_out_c0                     (lcl_cmu_fpll_f_out_c0), 
    .f_out_c0_hz                  (lcl_cmu_fpll_f_out_c0_hz), 
    .f_out_c1                     (lcl_cmu_fpll_f_out_c1), 
    .f_out_c1_hz                  (lcl_cmu_fpll_f_out_c1_hz), 
    .f_out_c2                     (lcl_cmu_fpll_f_out_c2), 
    .f_out_c2_hz                  (lcl_cmu_fpll_f_out_c2_hz), 
    .f_out_c3                     (lcl_cmu_fpll_f_out_c3), 
    .f_out_c3_hz                  (lcl_cmu_fpll_f_out_c3_hz), 
    .out_freq                     (lcl_cmu_fpll_out_freq), 
    .out_freq_hz                  (lcl_cmu_fpll_out_freq_hz), 
    .pfd_freq                     (lcl_cmu_fpll_pfd_freq), 
    .phase_shift_c0               (lcl_cmu_fpll_phase_shift_c0), 
    .phase_shift_c1               (lcl_cmu_fpll_phase_shift_c1), 
    .phase_shift_c2               (lcl_cmu_fpll_phase_shift_c2), 
    .phase_shift_c3               (lcl_cmu_fpll_phase_shift_c3), 
    .refclk                       (lcl_cmu_fpll_refclk), 
    .vco_freq                     (lcl_cmu_fpll_vco_freq), 
    .vco_freq_hz                  (lcl_cmu_fpll_vco_freq_hz), 
    .pll_fractional_division      (lcl_cmu_fpll_pll_fractional_division),

    .f_max_band_0                 (lcl_cmu_fpll_f_max_band_0),
    .f_max_band_1                 (lcl_cmu_fpll_f_max_band_1),
    .f_max_band_2                 (lcl_cmu_fpll_f_max_band_2),
    .f_max_band_3                 (lcl_cmu_fpll_f_max_band_3),
    .f_max_band_4                 (lcl_cmu_fpll_f_max_band_4),
    .f_max_band_5                 (lcl_cmu_fpll_f_max_band_5),
    .f_max_band_6                 (lcl_cmu_fpll_f_max_band_6),
    .f_max_band_7                 (lcl_cmu_fpll_f_max_band_7),
    .f_max_band_8                 (lcl_cmu_fpll_f_max_band_8),
    .f_max_band_9                 (lcl_cmu_fpll_f_max_band_9),
    .f_max_div_two_bypass         (lcl_cmu_fpll_f_max_div_two_bypass),
    .f_max_pfd                    (lcl_cmu_fpll_f_max_pfd),
    .f_max_pfd_bonded             (lcl_cmu_fpll_f_max_pfd_bonded),
    .f_max_pfd_fractional         (lcl_cmu_fpll_f_max_pfd_fractional),


    .f_max_pfd_integer            (lcl_cmu_fpll_f_max_pfd_integer),

    .f_max_vco                    (lcl_cmu_fpll_f_max_vco),
    .f_max_vco_fractional         (lcl_cmu_fpll_f_max_vco_fractional),
    .f_min_band_0                 (lcl_cmu_fpll_f_min_band_0),
    .f_min_band_1                 (lcl_cmu_fpll_f_min_band_1),
    .f_min_band_2                 (lcl_cmu_fpll_f_min_band_2),
    .f_min_band_3                 (lcl_cmu_fpll_f_min_band_3),
    .f_min_band_4                 (lcl_cmu_fpll_f_min_band_4),
    .f_min_band_5                 (lcl_cmu_fpll_f_min_band_5),
    .f_min_band_6                 (lcl_cmu_fpll_f_min_band_6),
    .f_min_band_7                 (lcl_cmu_fpll_f_min_band_7),
    .f_min_band_8                 (lcl_cmu_fpll_f_min_band_8),
    .f_min_band_9                 (lcl_cmu_fpll_f_min_band_9),
    .f_min_pfd                    (lcl_cmu_fpll_f_min_pfd),
    .f_min_vco                    (lcl_cmu_fpll_f_min_vco)
 
  
  ) fpll_inst (
     // Input Ports
    .core_refclk                  (1'b0 /*unconnected*/), 
    .csr_bufin                    (1'b0 /*unconnected*/), 
    .csr_clk                      (1'b0 /*unconnected*/), 
    .csr_en                       (1'b0 /*unconnected*/), 
    .csr_en_dly                   (1'b0 /*unconnected*/), 
    .csr_in                       (1'b0 /*unconnected*/), 
    .dprio_rst_n                  (1'b1 /*unconnected*/),
    .dps_rst_n                    (w_phase_reset), 
    .extswitch_buf                (1'b0 /*unconnected*/), 
    .fbclkin                      (1'b1), 
    .lc_to_fpll_refclk            (atx_to_fpll_cascade_clk), 
    .mdio_dis                     (1'b0 /*unconnected*/), 
    .nfrzdrv                      (1'b0 /*unconnected*/), 
    .nrpi_freeze                  (1'b0 /*unconnected*/), 
    .pfden                        (1'b1), 
    .phase_en                     (w_phase_enable),   
    .pllclksel                    (1'b0), 
    .pma_atpg_los_en_n            (1'b1 /*unconnected*/), 
    .pma_csr_test_dis             (1'b0 /*unconnected*/), 
    .refclkind                    (refclk_sel_outclk), 
    .rst_n                        (pll_powerdown_fpll), 
    .scan_mode_n                  (1'b1), 
    .scan_shift_n                 (1'b1), 
    .up_dn                        (w_updn), 
    .cnt_sel                      (w_cntsel),
    .fpll_ppm_clk                 (2'd0), 
    .iqtxrxclk                    (6'd0), 
    .num_phase_shifts             (w_num_phase_shifts), 

    // output ports                
    .clk0                         (tx_serial_clk), 
    .clk180                       (/*unconnected*/), 
    .clklow                       (w_clklow), 
    .csr_bufout                   (/*unconnected*/), 
    .csr_out                      (/*unconnected*/), 
    .fref                         (w_fref), 
    .hclk_out                     (pll_pcie_clk), 
    .iqtxrxclk_out                (pll_cascade_clk), 
    .lock                         (pll_locked_hip), 
    .phase_done                   (w_phase_done), 
    .pll_cas_out                  (/*unconnected*/), 
    .pllcout                      ({w_pll_cout3, w_pll_cout2, w_pll_cout1, w_pll_cout0}),     
    .ppm_clk                      (/*unconnected*/),
    
    // AVMM signals 
    //In FPLL sim model, the ICD ports for AVMM (reg_addr, write, read, writedata, readdata and block_select actually connect to the ICD RTL. THe virtual ports (avmm_*) are not used.
  .avmmclk                      (1'b0 /*unconnected*/), //avmm_clk_fpll),
  .avmmwritedata                (8'd0 /*unconnected*/), //avmm_writedata_fpll),
  .avmmaddress                  (10'd0 /*unconnected*/), //avmm_address_fpll),
  .avmmwrite                    (1'b0 /*unconnected*/), //avmm_write_fpll),
  .avmmread                     (1'b0 /*unconnected*/), //avmm_read__fpll),
  .avmmreaddata                 (/*unconnected*/),
  .blockselect                  (/*unconnected*/), //blockselect_fpll),

  .dprio_clk                    (avmm_clk_fpll),
    .reg_addr                     (avmm_address_fpll),
    .read                         (avmm_read_fpll), 
    .write                        (avmm_write_fpll), 
    .writedata                    (avmm_writedata_fpll),
    .readdata                     (avmmreaddata_fpll),
    .block_select                 (blockselect_fpll)
  );                                 
  //-----------------------------------
  
  localparam  avmm_busy_en                = rcfg_separate_avmm_busy ? "enable" : "disable";

  // Instantiating the AVMM2 wrapper 
  ct1_xcvr_avmm2 
  #(
    .avmm_interfaces                      (avmm_interfaces),
    .rcfg_enable                          (rcfg_enable),
    .enable_avmm                          (1),              
    .silicon_rev                          (hssi_avmm2_if_silicon_rev),      
    .calibration_type                     (hssi_avmm2_if_calibration_type),
    .pcs_calibration_feature_en           (hssi_avmm2_if_pcs_calibration_feature_en),
    .pcs_arbiter_ctrl                     (hssi_avmm2_if_pcs_arbiter_ctrl),
    .pcs_cal_done                         (hssi_avmm2_if_pcs_cal_done),
    .pcs_hip_cal_en                       (hssi_avmm2_if_pcs_hip_cal_en),
    .pcs_cal_reserved                     (hssi_avmm2_if_pcs_cal_reserved),
    .pldadapt_hip_mode                    (hssi_avmm2_if_pldadapt_hip_mode),
    .hssiadapt_hip_mode                   (hssi_avmm2_if_hssiadapt_hip_mode),
    .hssiadapt_avmm_osc_clock_setting     (hssi_avmm2_if_hssiadapt_avmm_osc_clock_setting),  
    .pldadapt_avmm_osc_clock_setting      (hssi_avmm2_if_pldadapt_avmm_osc_clock_setting), 
    .hssiadapt_avmm_testbus_sel           (hssi_avmm2_if_hssiadapt_avmm_testbus_sel),
    .pldadapt_avmm_testbus_sel            (hssi_avmm2_if_pldadapt_avmm_testbus_sel),
    .pldadapt_gate_dis                    (hssi_avmm2_if_pldadapt_gate_dis)  
  ) xcvr_avmm2_inst (

    .avmm_clk                             (reconfig_clk               ),
    .avmm_reset                           (reconfig_reset             ),
    .avmm_writedata                       (reconfig_writedata         ),
    .avmm_address                         (reconfig_address           ),
    .avmm_write                           (reconfig_write             ),
    .avmm_read                            (reconfig_read              ),
    .avmm_readdata                        (reconfig_readdata          ),
    .avmm_waitrequest                     (reconfig_waitrequest       ),
    .avmm_busy                            (avmm_busy                  ),

    .pld_cal_done                         (pld_cal_done               ),
    .hip_cal_done                         (hip_cal_done_w             ),

    .pll_avmm_clk                         (pll_avmm_clk               ),
    .pll_avmm_writedata                   (pll_avmm_writedata         ),
    .pll_avmm_address                     (pll_avmm_address           ),
    .pll_avmm_write                       (pll_avmm_write             ),
    .pll_avmm_read                        (pll_avmm_read              ),

    .pll_avmmreaddata_lc_pll              ({avmm_interfaces{8'b0}}    ), 
    .pll_avmmreaddata_lc_refclk_select    ({avmm_interfaces{8'b0}}    ), 
    .pll_blockselect_lc_pll               ({avmm_interfaces{1'b0}}    ),            
    .pll_blockselect_lc_refclk_select     ({avmm_interfaces{1'b0}}    ),  

    .pll_avmmreaddata_cgb_master          (pll_avmmreaddata_mcgb      ),                                        
    .pll_blockselect_cgb_master           (pll_blockselect_mcgb       ),

    .pll_avmmreaddata_cmu_fpll              (pll_avmmreaddata_fpll    ),
    .pll_avmmreaddata_cmu_fpll_refclk_select(pll_avmmreaddata_refclk  ),
    .pll_blockselect_cmu_fpll               (pll_blockselect_fpll     ),
    .pll_blockselect_cmu_fpll_refclk_select (pll_blockselect_refclk   ),

    //HIP signals
    .hip_avmm_read                        ({avmm_interfaces{1'b0}}    ),
    .hip_avmm_write                       ({avmm_interfaces{1'b0}}    ),
    .hip_avmm_reg_addr                    ({avmm_interfaces{21'b0}}   ),
    .hip_avmm_writedata                   ({avmm_interfaces{8'b0}}    ),
    .hip_aib_avmm_out                     ({avmm_interfaces{15'b0}}   ),
    .hip_avmm_readdata                    (                           ),
      .hip_avmm_readdatavalid               (                           ),
    .hip_avmm_writedone                   (                           ),
    .hip_avmm_reserved_out                (                           ),
    .hip_aib_avmm_clk                     (                           ),
    .hip_aib_avmm_in                      (                           ),
    .pld_hssi_osc_transfer_en         (pld_hssi_osc_transfer_en_wire)

  ); 

  // Instantiating PLD adapt atoms
  // PLL and mcgb PLD adapter atoms are required to interface with the core
  // all control/input signals will come to PLL through PLD adapter
  // all status signals are going to PLD core through PLD adapter

  ct1_cmu_fpll_pld_adapt cmu_fpll_pld_adapt_inst
  (
    //INPUTS
    //-------
    // core inputs 
    .avmmclk         ( avmm_clk_fpll ),
//    .dps_rst_n       ( phase_reset ),
    .dps_rst_n       ( ~final_phase_reset ), // dps workaround
    .extswitch_buf   (1'b0 /*unconnected*/ ),
    .pfden           ( 1'b1 ),
//    .phase_en        ( phase_enable ),
    .phase_en        ( final_phase_en),   // dps workaround
    .pllclksel       ( 1'b0 /*unconnected*/ ),
    .rst_n           ( pll_powerdown_adapt),
    .up_dn           ( updn ),
//    .cnt_sel         ( cntsel ),
    .cnt_sel         ( 4'd0 ),   // using cntr 0 to feed the core
    .fpll_ppm_clk    ( 2'd0 /*unconnected*/ ),
//    .num_phase_shifts( num_phase_shifts ),
    .num_phase_shifts( num_phase_shifts),   // if soft logic is used, this value should be 1.
    .fbclkin         ( 1'b0 /*unconnected*/ ),
   
    // fpll outputs
    .int_clk0_bad  ( 1'b0 ),
    .int_clk1_bad  ( 1'b0 ),
    .int_fbclkout  ( 1'b0 ),
    .int_clklow      ( w_clklow ),
    .int_fref        ( w_fref ),
    .int_lock        ( pll_locked_hip ),
    .int_phase_done  ( w_phase_done ),
    .int_pllcout     ( {w_pll_cout3, w_pll_cout2, w_pll_cout1, w_pll_cout0} ),

    //OUTPUTS
    //--------

    // fpll inputs 
    .int_dps_rst_n       ( w_phase_reset ),
    .int_extswitch_buf   ( ),
    .int_fbclkin         ( ),
    .int_pfden           ( ),
    .int_phase_en        ( w_phase_enable ),
    .int_pllclksel       ( ),
    .int_rst_n           ( w_pll_powerdown ),
    .int_up_dn           ( w_updn ),
    .int_cnt_sel         ( w_cntsel ),
    .int_fpll_ppm_clk    ( ),
    .int_num_phase_shifts( w_num_phase_shifts ),

    // core outputs 
    //.clk0_bad( ),
    //.clk1_bad( ),
    //.fbclkout( ),
    .clklow    ( clklow ),
    .fref      ( fref ),
    .lock      ( pll_locked),
//    .phase_done( phase_done ),
    .phase_done( pre_phase_done ),    // dps workaround
    .pllcout   ( {pll_cout3, pll_cout2, pll_cout1, pll_cout0} )
  
  );

  // direct core output
        assign outclk = pll_cout0;
  assign unused_pllcout = {pll_cout3, pll_cout2, pll_cout1}; 
  
  generate 
    if (enable_mcgb == 1) begin 

      
   ct1_hssi_cr2_pma_cgb_master
      #( 
        .prot_mode(hssi_pma_cgb_master_prot_mode),                
        .silicon_rev(hssi_pma_cgb_master_silicon_rev),            
        .x1_div_m_sel(hssi_pma_cgb_master_x1_div_m_sel),                
        .cgb_enable_iqtxrxclk(hssi_pma_cgb_master_cgb_enable_iqtxrxclk),       
        .ser_mode(hssi_pma_cgb_master_ser_mode),                   
        .cgb_power_down(hssi_pma_cgb_master_cgb_power_down),             
        .observe_cgb_clocks(hssi_pma_cgb_master_observe_cgb_clocks),          
        //.op_mode(hssi_pma_cgb_master_op_mode),                     
        //.tx_ucontrol_reset_pcie(hssi_pma_cgb_master_tx_ucontrol_reset_pcie),      
        .vccdreg_output(hssi_pma_cgb_master_vccdreg_output),            
        .input_select(hssi_pma_cgb_master_input_select), 
        .input_select_gen3(hssi_pma_cgb_master_input_select_gen3),         
        //bitvec 
        .datarate_bps(lcl_hssi_pma_cgb_master_datarate_bps)              
        ,
       .msel_er                 ("select_er"),  // H-Tile specific *TODO* // "select_er" "select_et"
       .xpll_calibration_mode   ("cal_off"),  // H-Tile specific // "cal_off" "uc_not_rst" "uc_rst_lf" "uc_rst_pll"
       .power_rail_er  (hssi_pma_cgb_master_power_rail_er), 
       .powermode_ac_cgb_master (hssi_pma_cgb_master_powermode_ac_cgb_master), 
       .powermode_dc_cgb_master (hssi_pma_cgb_master_powermode_dc_cgb_master) 
      ) pma_cgb_master_inst (

        .cgb_rstb(mcgb_rst_mcgb),                             
        .clk_fpll_b(mcgb_aux_clk2),

       // Changed default connection from FPLL core to MCGB to port clk_fpll_t
       // The aux_clk0 input is now connected to clk_lc_t
       // The mcgb tcl package has been modified to default to clk_fpll_t

//        .clk_fpll_t(mcgb_aux_clk0),
        .clk_fpll_t(tx_serial_clk),
        .clk_lc_b(mcgb_aux_clk1),
//        .clk_lc_t(tx_serial_clk),
        .clk_lc_t(mcgb_aux_clk0),

        .clkb_fpll_b( 1'b0 /*unused*/ ),
        .clkb_fpll_t( 1'b0 /*unused*/ ),
        .clkb_lc_b( 1'b0 /*unused*/ ),
        .clkb_lc_t( 1'b0 /*unused*/ ),

        .cpulse_out_bus(tx_bonding_clocks),                
        .tx_iqtxrxclk_out( /*unused*/ ),
        .pcie_sw_done(pcie_sw_done),
        .pcie_sw(pcie_sw),
        .tx_bonding_rstb(1'b1),

        //-----------------------------------          
        .avmmaddress(avmm_address_mcgb),
        .avmmclk(avmm_clk_mcgb),
        .avmmread(avmm_read_mcgb),
        //.avmmrstn(avmm_rstn_mcgb),
        .avmmwrite(avmm_write_mcgb),
        .avmmwritedata(avmm_writedata_mcgb),
        .avmmreaddata(avmmreaddata_mcgb),
        .blockselect(blockselect_mcgb)
        //----------------------------------- 
      );

      ct1_hssi_pma_cgb_master_pld_adapt pma_cgb_master_pld_adapt_inst 
      (
        // inputs
        .avmmclk(avmm_clk_mcgb), 
        .cgb_rstb(mcgb_rst_adapt),
        // outputs 
        .int_cgb_rstb(w_mcgb_rst)
      ); 

    end else begin 
      assign pcie_sw_done = 2'b0;
      assign tx_bonding_clocks = 6'b0;
    end 
  endgenerate 
  
  // Optionally include the clk divider atom if user enables it in the GUI
  // C2 is the dedicated counter to the core 
  generate 
    if (enable_clk_divider == 1) begin  
      if (hssi_avmm2_if_silicon_rev == "10nm6bcr2eb" ) begin
             tennm_clk_divider 
 //          		       #(
 //			       .test_mode(test_mode)
 //      		        )
          			clk_divider_inst (
          			// Input ports 
          			.inclk(pll_cout0), 
//        			.rst_n(1'b1), 
          			// Output ports 
          			.clock_div1(outclk_div1),
          			.clock_div2(outclk_div2),
          			.clock_div4(outclk_div4)
        			);
      end else begin
              fourteennm_clk_divider 
 //           			     #(
 //           			     .test_mode(test_mode)
 //           			     )
          			     clk_divider_inst (
          			     // Input ports 
          			     .inclk(pll_cout0), 
//        			     .rst_n(1'b1), 
          			     // Output ports 
          			     .clock_div1(outclk_div1),
          			     .clock_div2(outclk_div2),
          			     .clock_div4(outclk_div4)
        			     );
      end
    end 
  endgenerate 


/////////////////////////////  DPS logic //////////////////////////////////
//
//
  generate
    if (enable_dps == 1) begin
      if (direct_dps == 0) begin
  //-----------------------------------
  // Instantiate pulse-width control module
         dps_pulse_ctrl_qjyjjoy phase_en_pulse(
           .clk(reconfig_clk[0]),  // input clock to the HSSI AVMM
           .rst(phase_reset),
           .user_phase_en(phase_enable), 
           .phase_en(final_phase_en)      
         );

        //-----------------------------------
        // Instantiate dps reset generation
        dps_reset_gen_qjyjjoy dps_reset_gen_1 (
           .clk(reconfig_clk[0]),                  // input clock to the HSSI AVMM
           .phase_reset_in(phase_reset),        // active high reset input
           .phase_en_in(final_phase_en),        // phase_en input
           .phase_done_in(~pre_phase_done),     // phase_done input - this thing is actually active LOW           
           .phase_reset_out(final_phase_reset), // active high reset output
           .phase_done_out(phase_done)          // phase_done output                 
         );
      end else begin
        // user interface to adapt connections
        assign final_phase_reset = phase_reset;
        assign final_phase_en    = phase_enable;
        // adapt to user interface connections
        assign phase_done = ~pre_phase_done;
      end
   end else begin
     assign final_phase_en = 1'b0;
     assign final_phase_reset = 1'b1;
     
   end
  endgenerate

endmodule



