// mm_bridge_onchip_mem.v

// Generated using ACDS version 24.3 212

`timescale 1 ps / 1 ps
module mm_bridge_onchip_mem #(
		parameter DATA_WIDTH               = 256,
		parameter SYMBOL_WIDTH             = 8,
		parameter HDL_ADDR_WIDTH           = 19,
		parameter BURSTCOUNT_WIDTH         = 5,
		parameter PIPELINE_COMMAND         = 1,
		parameter PIPELINE_RESPONSE        = 1,
		parameter SYNC_RESET               = 1,
		parameter USE_WRITERESPONSE        = 0,
		parameter S0_WAITREQUEST_ALLOWANCE = 0,
		parameter M0_WAITREQUEST_ALLOWANCE = 0
	) (
		input  wire                        clk,              //   clk.clk
		input  wire                        reset,            // reset.reset
		output wire                        s0_waitrequest,   //    s0.waitrequest,   Wait request to Avalon Memory Mapped Host, indicates agent is not ready
		output wire [DATA_WIDTH-1:0]       s0_readdata,      //      .readdata,      Read Data output from Avalon Memory Mapped Agent
		output wire                        s0_readdatavalid, //      .readdatavalid, Valid read data indication from Avalon Memory Mapped Agent
		input  wire [BURSTCOUNT_WIDTH-1:0] s0_burstcount,    //      .burstcount,    Indicates number of burst transfers in each burst
		input  wire [DATA_WIDTH-1:0]       s0_writedata,     //      .writedata,     Write Data from Avalon Memory Mapped Host
		input  wire [HDL_ADDR_WIDTH-1:0]   s0_address,       //      .address,       Address output from Avalon Memory Mapped Host
		input  wire                        s0_write,         //      .write,         Write command from Avalon Memory Mapped Host
		input  wire                        s0_read,          //      .read,          Read command from Avalon Memory Mapped Host
		input  wire [31:0]                 s0_byteenable,    //      .byteenable,    Indicates valid read/write data location
		input  wire                        s0_debugaccess,   //      .debugaccess
		input  wire                        m0_waitrequest,   //    m0.waitrequest,   Wait request from Avalon Memory Mapped Agent, indicates agent is not ready
		input  wire [DATA_WIDTH-1:0]       m0_readdata,      //      .readdata,      Read Data input to Avalon Memory Mapped Host
		input  wire                        m0_readdatavalid, //      .readdatavalid, Valid read data indication from Avalon Memory Mapped Agent
		output wire [BURSTCOUNT_WIDTH-1:0] m0_burstcount,    //      .burstcount,    Indicates number of burst transfers in each burst
		output wire [DATA_WIDTH-1:0]       m0_writedata,     //      .writedata,     Write Data from Avalon Memory Mapped Host
		output wire [HDL_ADDR_WIDTH-1:0]   m0_address,       //      .address,       Address output from Avalon Memory Mapped Host
		output wire                        m0_write,         //      .write,         Write command from Avalon Memory Mapped Host
		output wire                        m0_read,          //      .read,          Read command from Avalon Memory Mapped Host
		output wire [31:0]                 m0_byteenable,    //      .byteenable,    Indicates valid read/write data location
		output wire                        m0_debugaccess    //      .debugaccess
	);

	mm_bridge_onchip_mem_altera_avalon_mm_bridge_2010_chqhhwi #(
		.DATA_WIDTH               (DATA_WIDTH),
		.SYMBOL_WIDTH             (SYMBOL_WIDTH),
		.HDL_ADDR_WIDTH           (HDL_ADDR_WIDTH),
		.BURSTCOUNT_WIDTH         (BURSTCOUNT_WIDTH),
		.PIPELINE_COMMAND         (PIPELINE_COMMAND),
		.PIPELINE_RESPONSE        (PIPELINE_RESPONSE),
		.SYNC_RESET               (SYNC_RESET),
		.USE_WRITERESPONSE        (USE_WRITERESPONSE),
		.S0_WAITREQUEST_ALLOWANCE (S0_WAITREQUEST_ALLOWANCE),
		.M0_WAITREQUEST_ALLOWANCE (M0_WAITREQUEST_ALLOWANCE)
	) mm_bridge_onchip_mem (
		.clk                   (clk),              //   input,                 width = 1,   clk.clk
		.reset                 (reset),            //   input,                 width = 1, reset.reset
		.s0_waitrequest        (s0_waitrequest),   //  output,                 width = 1,    s0.waitrequest
		.s0_readdata           (s0_readdata),      //  output,        width = DATA_WIDTH,      .readdata
		.s0_readdatavalid      (s0_readdatavalid), //  output,                 width = 1,      .readdatavalid
		.s0_burstcount         (s0_burstcount),    //   input,  width = BURSTCOUNT_WIDTH,      .burstcount
		.s0_writedata          (s0_writedata),     //   input,        width = DATA_WIDTH,      .writedata
		.s0_address            (s0_address),       //   input,    width = HDL_ADDR_WIDTH,      .address
		.s0_write              (s0_write),         //   input,                 width = 1,      .write
		.s0_read               (s0_read),          //   input,                 width = 1,      .read
		.s0_byteenable         (s0_byteenable),    //   input,                width = 32,      .byteenable
		.s0_debugaccess        (s0_debugaccess),   //   input,                 width = 1,      .debugaccess
		.m0_waitrequest        (m0_waitrequest),   //   input,                 width = 1,    m0.waitrequest
		.m0_readdata           (m0_readdata),      //   input,        width = DATA_WIDTH,      .readdata
		.m0_readdatavalid      (m0_readdatavalid), //   input,                 width = 1,      .readdatavalid
		.m0_burstcount         (m0_burstcount),    //  output,  width = BURSTCOUNT_WIDTH,      .burstcount
		.m0_writedata          (m0_writedata),     //  output,        width = DATA_WIDTH,      .writedata
		.m0_address            (m0_address),       //  output,    width = HDL_ADDR_WIDTH,      .address
		.m0_write              (m0_write),         //  output,                 width = 1,      .write
		.m0_read               (m0_read),          //  output,                 width = 1,      .read
		.m0_byteenable         (m0_byteenable),    //  output,                width = 32,      .byteenable
		.m0_debugaccess        (m0_debugaccess),   //  output,                 width = 1,      .debugaccess
		.s0_response           (),                 // (terminated),                                  
		.s0_writeresponsevalid (),                 // (terminated),                                  
		.m0_response           (2'b00),            // (terminated),                                  
		.m0_writeresponsevalid (1'b0)              // (terminated),                                  
	);

endmodule
