// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



///////////////////////////////////////////////////////////////////////////////
//
// Wrapper module for IO tiles
//
///////////////////////////////////////////////////////////////////////////////

module altera_emif_arch_nd_io_tiles_wrap #(
   parameter DIAG_SYNTH_FOR_SIM                      = 0,
   parameter DIAG_CPA_OUT_1_EN                       = 0,
   parameter DIAG_FAST_SIM                           = 0,
   parameter DIAG_SIM_VERBOSE_LEVEL                  = 2,
   parameter DIAG_SIM_MEMORY_PRELOAD                 = 0,
   parameter DIAG_SIM_MEMORY_PRELOAD_PRI_ABPHY_FILE  = "",
   parameter DIAG_SIM_MEMORY_PRELOAD_SEC_ABPHY_FILE  = "",
   parameter DIAG_SEQ_RESET_AUTO_RELEASE             = "avl",
   parameter DIAG_DB_RESET_AUTO_RELEASE              = "avl_release",
   parameter IS_HPS                                  = 0,
   parameter SILICON_REV                             = "",
   parameter PROTOCOL_ENUM                           = "",
   parameter PHY_PING_PONG_EN                        = 0,
   parameter DQS_BUS_MODE_ENUM                       = "",
   parameter USER_CLK_RATIO                          = 1,
   parameter PHY_HMC_CLK_RATIO                       = 1,
   parameter C2P_P2C_CLK_RATIO                       = 1,
   parameter PLL_VCO_TO_MEM_CLK_FREQ_RATIO           = 1,
   parameter PLL_VCO_FREQ_MHZ_INT                    = 0,
   parameter MEM_BURST_LENGTH                        = 0,
   parameter MEM_DATA_MASK_EN                        = 1,
   parameter PINS_PER_LANE                           = 1,
   parameter LANES_PER_TILE                          = 1,
   parameter PINS_IN_RTL_TILES                       = 1,
   parameter LANES_IN_RTL_TILES                      = 1,
   parameter NUM_OF_RTL_TILES                        = 1,
   parameter AC_PIN_MAP_SCHEME                       = "",
   parameter PRI_AC_TILE_INDEX                       = -1,
   parameter SEC_AC_TILE_INDEX                       = -1,
   parameter PRI_HMC_DBC_SHADOW_LANE_INDEX           = -1,
   parameter NUM_OF_HMC_PORTS                        = 1,
   parameter HMC_AVL_PROTOCOL_ENUM                   = "",
   parameter HMC_CTRL_DIMM_TYPE                      = "",

   parameter MEM_ROW_ADDR_WIDTH                      = 0,
   parameter MEM_COL_ADDR_WIDTH                      = 0,
   parameter PHY_CONFIG_ENUM        = "",
   parameter HMC_CFG_ADDR_ORDER     = "",
   parameter HMC_CFG_CS_ADDR_WIDTH  = "",
   parameter HMC_CFG_ROW_ADDR_WIDTH = "",
   
   parameter           PRI_HMC_CFG_PING_PONG_MODE              = "",
   parameter           PRI_HMC_CFG_CS_ADDR_WIDTH               = "",
   parameter           PRI_HMC_CFG_COL_ADDR_WIDTH              = "",
   parameter           PRI_HMC_CFG_ROW_ADDR_WIDTH              = "",
   parameter           PRI_HMC_CFG_BANK_ADDR_WIDTH             = "",
   parameter           PRI_HMC_CFG_BANK_GROUP_ADDR_WIDTH       = "",
   parameter           PRI_HMC_CFG_ADDR_ORDER                  = "",
   parameter           PRI_HMC_CFG_ARBITER_TYPE                = "",
   parameter           PRI_HMC_CFG_OPEN_PAGE_EN                = "",
   parameter           PRI_HMC_CFG_CTRL_ENABLE_RC              = "",
   parameter           PRI_HMC_CFG_DBC0_ENABLE_RC              = "",
   parameter           PRI_HMC_CFG_DBC1_ENABLE_RC              = "",
   parameter           PRI_HMC_CFG_DBC2_ENABLE_RC              = "",
   parameter           PRI_HMC_CFG_DBC3_ENABLE_RC              = "",
   parameter           PRI_HMC_CFG_CTRL_ENABLE_ECC             = "",
   parameter           PRI_HMC_CFG_DBC0_ENABLE_ECC             = "",
   parameter           PRI_HMC_CFG_DBC1_ENABLE_ECC             = "",
   parameter           PRI_HMC_CFG_DBC2_ENABLE_ECC             = "",
   parameter           PRI_HMC_CFG_DBC3_ENABLE_ECC             = "",
   parameter           PRI_HMC_CFG_REORDER_DATA                = "",
   parameter           PRI_HMC_CFG_REORDER_READ                = "",
   parameter           PRI_HMC_CFG_CTRL_REORDER_RDATA          = "",
   parameter           PRI_HMC_CFG_DBC0_REORDER_RDATA          = "",
   parameter           PRI_HMC_CFG_DBC1_REORDER_RDATA          = "",
   parameter           PRI_HMC_CFG_DBC2_REORDER_RDATA          = "",
   parameter           PRI_HMC_CFG_DBC3_REORDER_RDATA          = "",
   parameter [  1:  0] PRI_HMC_CFG_CTRL_SLOT_OFFSET            = 0,
   parameter [  1:  0] PRI_HMC_CFG_DBC0_SLOT_OFFSET            = 0,
   parameter [  1:  0] PRI_HMC_CFG_DBC1_SLOT_OFFSET            = 0,
   parameter [  1:  0] PRI_HMC_CFG_DBC2_SLOT_OFFSET            = 0,
   parameter [  1:  0] PRI_HMC_CFG_DBC3_SLOT_OFFSET            = 0,
   parameter           PRI_HMC_CFG_CTRL_SLOT_ROTATE_EN         = "",
   parameter           PRI_HMC_CFG_DBC0_SLOT_ROTATE_EN         = "",
   parameter           PRI_HMC_CFG_DBC1_SLOT_ROTATE_EN         = "",
   parameter           PRI_HMC_CFG_DBC2_SLOT_ROTATE_EN         = "",
   parameter           PRI_HMC_CFG_DBC3_SLOT_ROTATE_EN         = "",
   parameter [  3:  0] PRI_HMC_CFG_COL_CMD_SLOT                = 0,
   parameter [  3:  0] PRI_HMC_CFG_ROW_CMD_SLOT                = 0,
   parameter [ 31:  0] PRI_HMC_CFG_ROW_TO_COL_OFFSET           = 0,
   parameter [ 31:  0] PRI_HMC_CFG_ROW_TO_ROW_OFFSET           = 0,
   parameter [ 31:  0] PRI_HMC_CFG_COL_TO_COL_OFFSET           = 0,
   parameter [ 31:  0] PRI_HMC_CFG_COL_TO_DIFF_COL_OFFSET      = 0,
   parameter [ 31:  0] PRI_HMC_CFG_COL_TO_ROW_OFFSET           = 0,
   parameter [ 31:  0] PRI_HMC_CFG_SIDEBAND_OFFSET             = 0,
   parameter [ 15:  0] PRI_HMC_CFG_CS_TO_CHIP_MAPPING          = 0,
   parameter [ 31:  0] PRI_HMC_CFG_CTL_ODT_ENABLED             = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_ODT_ON                   = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_ODT_PERIOD               = 0,
   parameter [ 15:  0] PRI_HMC_CFG_READ_ODT_CHIP               = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_ODT_ON                   = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_ODT_PERIOD               = 0,
   parameter [ 15:  0] PRI_HMC_CFG_WRITE_ODT_CHIP              = 0,
   parameter           PRI_HMC_CFG_CMD_FIFO_RESERVE_EN         = "",
   parameter [  6:  0] PRI_HMC_CFG_RB_RESERVED_ENTRY           = 0,
   parameter [  6:  0] PRI_HMC_CFG_WB_RESERVED_ENTRY           = 0,
   parameter [  5:  0] PRI_HMC_CFG_STARVE_LIMIT                = 0,
   parameter [ 31:  0] PRI_HMC_CFG_PHY_DELAY_MISMATCH          = 0,
   parameter           PRI_HMC_CFG_DQSTRK_EN                   = "",
   parameter [  7:  0] PRI_HMC_CFG_DQSTRK_TO_VALID             = 0,
   parameter [  7:  0] PRI_HMC_CFG_DQSTRK_TO_VALID_LAST        = 0,
   parameter [ 31:  0] PRI_HMC_CFG_CTL_SHORT_DQSTRK_EN         = 0,
   parameter           PRI_HMC_CFG_PERIOD_DQSTRK_CTRL_EN       = "",
   parameter [ 15:  0] PRI_HMC_CFG_PERIOD_DQSTRK_INTERVAL      = 0,
   parameter           PRI_HMC_CFG_SHORT_DQSTRK_CTRL_EN        = "",
   parameter [ 31:  0] PRI_HMC_CFG_ENABLE_FAST_EXIT_PPD        = 0,
   parameter           PRI_HMC_CFG_USER_RFSH_EN                = "",
   parameter           PRI_HMC_CFG_GEAR_DOWN_EN                = "",
   parameter [ 31:  0] PRI_HMC_CFG_MEM_AUTO_PD_CYCLES          = 0,
   parameter [  5:  0] PRI_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC   = 0,
   parameter [  7:  0] PRI_HMC_MEMCLKGATE_SETTING              = 0,
   parameter [  6:  0] PRI_HMC_CFG_TCL                         = 0,
   parameter [  7:  0] PRI_HMC_CFG_16_ACT_TO_ACT               = 0,
   parameter [  7:  0] PRI_HMC_CFG_4_ACT_TO_ACT                = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_AL                       = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_CS_PER_DIMM              = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_RD_PREAMBLE              = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TCCD                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TCCD_S                   = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TCKESR                   = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TCKSRX                   = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TCL                      = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TCWL                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TDQSCKMAX                = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TFAW                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TMOD                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TPL                      = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TRAS                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TRC                      = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TRCD                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TREFI                    = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TRFC                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TRP                      = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TRRD                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TRRD_S                   = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TRTP                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TWR                      = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TWR_CRC_DM               = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TWTR                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TWTR_L_CRC_DM            = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TWTR_S                   = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TWTR_S_CRC_DM            = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TXP                      = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TXPDLL                   = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TXSR                     = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TZQCS                    = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_TZQOPER                  = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_WR_CRC                   = 0,
   parameter [ 31:  0] PRI_HMC_MEM_IF_WR_PREAMBLE              = 0,
   parameter [  5:  0] PRI_HMC_CFG_ACT_TO_ACT                  = 0,
   parameter [  5:  0] PRI_HMC_CFG_ACT_TO_ACT_DIFF_BANK        = 0,
   parameter [  5:  0] PRI_HMC_CFG_ACT_TO_ACT_DIFF_BG          = 0,
   parameter [  5:  0] PRI_HMC_CFG_ACT_TO_PCH                  = 0,
   parameter [  5:  0] PRI_HMC_CFG_ACT_TO_RDWR                 = 0,
   parameter [ 12:  0] PRI_HMC_CFG_ARF_PERIOD                  = 0,
   parameter [  7:  0] PRI_HMC_CFG_ARF_TO_VALID                = 0,
   parameter [  7:  0] PRI_HMC_CFG_MMR_CMD_TO_VALID            = 0,
   parameter [  4:  0] PRI_HMC_CFG_MPR_TO_VALID                = 0,
   parameter           PRI_HMC_CFG_MPS_DQSTRK_DISABLE          = "",
   parameter [  3:  0] PRI_HMC_CFG_MPS_EXIT_CKE_TO_CS          = 0,
   parameter [  3:  0] PRI_HMC_CFG_MPS_EXIT_CS_TO_CKE          = 0,
   parameter [  9:  0] PRI_HMC_CFG_MPS_TO_VALID                = 0,
   parameter           PRI_HMC_CFG_MPS_ZQCAL_DISABLE           = "",
   parameter [  3:  0] PRI_HMC_CFG_MRR_TO_VALID                = 0,
   parameter [  3:  0] PRI_HMC_CFG_MRS_TO_VALID                = 0,
   parameter [  5:  0] PRI_HMC_CFG_PCH_ALL_TO_VALID            = 0,
   parameter [  5:  0] PRI_HMC_CFG_PCH_TO_VALID                = 0,
   parameter [ 15:  0] PRI_HMC_CFG_PDN_PERIOD                  = 0,
   parameter [  5:  0] PRI_HMC_CFG_PDN_TO_VALID                = 0,
   parameter [  5:  0] PRI_HMC_CFG_POWER_SAVING_EXIT_CYC       = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_AP_TO_VALID              = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_TO_PCH                   = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_TO_RD                    = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_TO_RD_DIFF_BG            = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_TO_RD_DIFF_CHIP          = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_TO_WR                    = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_TO_WR_DIFF_BG            = 0,
   parameter [  5:  0] PRI_HMC_CFG_RD_TO_WR_DIFF_CHIP          = 0,
   parameter [  6:  0] PRI_HMC_CFG_RFSH_WARN_THRESHOLD         = 0,
   parameter [  2:  0] PRI_HMC_CFG_RLD3_MULTIBANK_REF_DELAY    = 0,
   parameter [ 15:  0] PRI_HMC_CFG_RLD3_REFRESH_SEQ0           = 0,
   parameter [ 15:  0] PRI_HMC_CFG_RLD3_REFRESH_SEQ1           = 0,
   parameter [ 15:  0] PRI_HMC_CFG_RLD3_REFRESH_SEQ2           = 0,
   parameter [ 15:  0] PRI_HMC_CFG_RLD3_REFRESH_SEQ3           = 0,
   parameter           PRI_HMC_CFG_SB_CG_DISABLE               = "",
   parameter [ 19:  0] PRI_HMC_CFG_SB_DDR4_MR3                 = 0,
   parameter [ 19:  0] PRI_HMC_CFG_SB_DDR4_MR4                 = 0,
   parameter [ 19:  0] PRI_HMC_CFG_SB_DDR4_MR5                 = 0,
   parameter           PRI_HMC_CFG_DDR4_MPS_ADDRMIRROR         = "",
   parameter           PRI_HMC_CFG_SRF_AUTOEXIT_EN             = "",
   parameter [  1:  0] PRI_HMC_CFG_SRF_ENTRY_EXIT_BLOCK        = 0,
   parameter [  9:  0] PRI_HMC_CFG_SRF_TO_VALID                = 0,
   parameter [  9:  0] PRI_HMC_CFG_SRF_TO_ZQ_CAL               = 0,
   parameter           PRI_HMC_CFG_SRF_ZQCAL_DISABLE           = "",
   parameter [ 31:  0] PRI_HMC_TEMP_4_ACT_TO_ACT               = 0,
   parameter [ 31:  0] PRI_HMC_TEMP_RD_TO_RD_DIFF_BG           = 0,
   parameter [ 31:  0] PRI_HMC_TEMP_WR_TO_RD                   = 0,
   parameter [ 31:  0] PRI_HMC_TEMP_WR_TO_RD_DIFF_BG           = 0,
   parameter [ 31:  0] PRI_HMC_TEMP_WR_TO_RD_DIFF_CHIP         = 0,
   parameter [ 31:  0] PRI_HMC_TEMP_WR_TO_WR_DIFF_BG           = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_AP_TO_VALID              = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_TO_PCH                   = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_TO_RD                    = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_TO_RD_DIFF_BG            = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_TO_RD_DIFF_CHIP          = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_TO_WR                    = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_TO_WR_DIFF_BG            = 0,
   parameter [  5:  0] PRI_HMC_CFG_WR_TO_WR_DIFF_CHIP          = 0,
   parameter [  8:  0] PRI_HMC_CFG_ZQCL_TO_VALID               = 0,
   parameter [  6:  0] PRI_HMC_CFG_ZQCS_TO_VALID               = 0,
   parameter [  8:  0] PRI_HMC_CHIP_ID                         = 0,
   parameter [  1:  0] PRI_HMC_CID_ADDR_WIDTH                  = 0,
   parameter           PRI_HMC_3DS_EN                          = "",
   parameter [  3:  0] PRI_HMC_3DS_LR_NUM0                     = 0,
   parameter [  3:  0] PRI_HMC_3DS_LR_NUM1                     = 0,
   parameter [  3:  0] PRI_HMC_3DS_LR_NUM2                     = 0,
   parameter [  3:  0] PRI_HMC_3DS_LR_NUM3                     = 0,
   parameter           PRI_HMC_3DS_PR_STAG_ENABLE              = "",
   parameter [  6:  0] PRI_HMC_3DS_REF2REF_DLR                 = 0,
   parameter           PRI_HMC_3DSREF_ACK_ON_DONE              = "",
   parameter           SEC_HMC_CFG_PING_PONG_MODE              = "",
   parameter           SEC_HMC_CFG_CS_ADDR_WIDTH               = "",
   parameter           SEC_HMC_CFG_COL_ADDR_WIDTH              = "",
   parameter           SEC_HMC_CFG_ROW_ADDR_WIDTH              = "",
   parameter           SEC_HMC_CFG_BANK_ADDR_WIDTH             = "",
   parameter           SEC_HMC_CFG_BANK_GROUP_ADDR_WIDTH       = "",
   parameter           SEC_HMC_CFG_ADDR_ORDER                  = "",
   parameter           SEC_HMC_CFG_ARBITER_TYPE                = "",
   parameter           SEC_HMC_CFG_OPEN_PAGE_EN                = "",
   parameter           SEC_HMC_CFG_CTRL_ENABLE_RC              = "",
   parameter           SEC_HMC_CFG_DBC0_ENABLE_RC              = "",
   parameter           SEC_HMC_CFG_DBC1_ENABLE_RC              = "",
   parameter           SEC_HMC_CFG_DBC2_ENABLE_RC              = "",
   parameter           SEC_HMC_CFG_DBC3_ENABLE_RC              = "",
   parameter           SEC_HMC_CFG_CTRL_ENABLE_ECC             = "",
   parameter           SEC_HMC_CFG_DBC0_ENABLE_ECC             = "",
   parameter           SEC_HMC_CFG_DBC1_ENABLE_ECC             = "",
   parameter           SEC_HMC_CFG_DBC2_ENABLE_ECC             = "",
   parameter           SEC_HMC_CFG_DBC3_ENABLE_ECC             = "",
   parameter           SEC_HMC_CFG_REORDER_DATA                = "",
   parameter           SEC_HMC_CFG_REORDER_READ                = "",
   parameter           SEC_HMC_CFG_CTRL_REORDER_RDATA          = "",
   parameter           SEC_HMC_CFG_DBC0_REORDER_RDATA          = "",
   parameter           SEC_HMC_CFG_DBC1_REORDER_RDATA          = "",
   parameter           SEC_HMC_CFG_DBC2_REORDER_RDATA          = "",
   parameter           SEC_HMC_CFG_DBC3_REORDER_RDATA          = "",
   parameter [  1:  0] SEC_HMC_CFG_CTRL_SLOT_OFFSET            = 0,
   parameter [  1:  0] SEC_HMC_CFG_DBC0_SLOT_OFFSET            = 0,
   parameter [  1:  0] SEC_HMC_CFG_DBC1_SLOT_OFFSET            = 0,
   parameter [  1:  0] SEC_HMC_CFG_DBC2_SLOT_OFFSET            = 0,
   parameter [  1:  0] SEC_HMC_CFG_DBC3_SLOT_OFFSET            = 0,
   parameter           SEC_HMC_CFG_CTRL_SLOT_ROTATE_EN         = "",
   parameter           SEC_HMC_CFG_DBC0_SLOT_ROTATE_EN         = "",
   parameter           SEC_HMC_CFG_DBC1_SLOT_ROTATE_EN         = "",
   parameter           SEC_HMC_CFG_DBC2_SLOT_ROTATE_EN         = "",
   parameter           SEC_HMC_CFG_DBC3_SLOT_ROTATE_EN         = "",
   parameter [  3:  0] SEC_HMC_CFG_COL_CMD_SLOT                = 0,
   parameter [  3:  0] SEC_HMC_CFG_ROW_CMD_SLOT                = 0,
   parameter [ 31:  0] SEC_HMC_CFG_ROW_TO_COL_OFFSET           = 0,
   parameter [ 31:  0] SEC_HMC_CFG_ROW_TO_ROW_OFFSET           = 0,
   parameter [ 31:  0] SEC_HMC_CFG_COL_TO_COL_OFFSET           = 0,
   parameter [ 31:  0] SEC_HMC_CFG_COL_TO_DIFF_COL_OFFSET      = 0,
   parameter [ 31:  0] SEC_HMC_CFG_COL_TO_ROW_OFFSET           = 0,
   parameter [ 31:  0] SEC_HMC_CFG_SIDEBAND_OFFSET             = 0,
   parameter [ 15:  0] SEC_HMC_CFG_CS_TO_CHIP_MAPPING          = 0,
   parameter [ 31:  0] SEC_HMC_CFG_CTL_ODT_ENABLED             = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_ODT_ON                   = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_ODT_PERIOD               = 0,
   parameter [ 15:  0] SEC_HMC_CFG_READ_ODT_CHIP               = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_ODT_ON                   = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_ODT_PERIOD               = 0,
   parameter [ 15:  0] SEC_HMC_CFG_WRITE_ODT_CHIP              = 0,
   parameter           SEC_HMC_CFG_CMD_FIFO_RESERVE_EN         = "",
   parameter [  6:  0] SEC_HMC_CFG_RB_RESERVED_ENTRY           = 0,
   parameter [  6:  0] SEC_HMC_CFG_WB_RESERVED_ENTRY           = 0,
   parameter [  5:  0] SEC_HMC_CFG_STARVE_LIMIT                = 0,
   parameter [ 31:  0] SEC_HMC_CFG_PHY_DELAY_MISMATCH          = 0,
   parameter           SEC_HMC_CFG_DQSTRK_EN                   = "",
   parameter [  7:  0] SEC_HMC_CFG_DQSTRK_TO_VALID             = 0,
   parameter [  7:  0] SEC_HMC_CFG_DQSTRK_TO_VALID_LAST        = 0,
   parameter [ 31:  0] SEC_HMC_CFG_CTL_SHORT_DQSTRK_EN         = 0,
   parameter           SEC_HMC_CFG_PERIOD_DQSTRK_CTRL_EN       = "",
   parameter [ 15:  0] SEC_HMC_CFG_PERIOD_DQSTRK_INTERVAL      = 0,
   parameter           SEC_HMC_CFG_SHORT_DQSTRK_CTRL_EN        = "",
   parameter [ 31:  0] SEC_HMC_CFG_ENABLE_FAST_EXIT_PPD        = 0,
   parameter           SEC_HMC_CFG_USER_RFSH_EN                = "",
   parameter           SEC_HMC_CFG_GEAR_DOWN_EN                = "",
   parameter [ 31:  0] SEC_HMC_CFG_MEM_AUTO_PD_CYCLES          = 0,
   parameter [  5:  0] SEC_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC   = 0,
   parameter [  7:  0] SEC_HMC_MEMCLKGATE_SETTING              = 0,
   parameter [  6:  0] SEC_HMC_CFG_TCL                         = 0,
   parameter [  7:  0] SEC_HMC_CFG_16_ACT_TO_ACT               = 0,
   parameter [  7:  0] SEC_HMC_CFG_4_ACT_TO_ACT                = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_AL                       = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_CS_PER_DIMM              = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_RD_PREAMBLE              = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TCCD                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TCCD_S                   = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TCKESR                   = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TCKSRX                   = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TCL                      = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TCWL                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TDQSCKMAX                = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TFAW                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TMOD                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TPL                      = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TRAS                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TRC                      = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TRCD                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TREFI                    = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TRFC                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TRP                      = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TRRD                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TRRD_S                   = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TRTP                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TWR                      = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TWR_CRC_DM               = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TWTR                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TWTR_L_CRC_DM            = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TWTR_S                   = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TWTR_S_CRC_DM            = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TXP                      = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TXPDLL                   = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TXSR                     = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TZQCS                    = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_TZQOPER                  = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_WR_CRC                   = 0,
   parameter [ 31:  0] SEC_HMC_MEM_IF_WR_PREAMBLE              = 0,
   parameter [  5:  0] SEC_HMC_CFG_ACT_TO_ACT                  = 0,
   parameter [  5:  0] SEC_HMC_CFG_ACT_TO_ACT_DIFF_BANK        = 0,
   parameter [  5:  0] SEC_HMC_CFG_ACT_TO_ACT_DIFF_BG          = 0,
   parameter [  5:  0] SEC_HMC_CFG_ACT_TO_PCH                  = 0,
   parameter [  5:  0] SEC_HMC_CFG_ACT_TO_RDWR                 = 0,
   parameter [ 12:  0] SEC_HMC_CFG_ARF_PERIOD                  = 0,
   parameter [  7:  0] SEC_HMC_CFG_ARF_TO_VALID                = 0,
   parameter [  7:  0] SEC_HMC_CFG_MMR_CMD_TO_VALID            = 0,
   parameter [  4:  0] SEC_HMC_CFG_MPR_TO_VALID                = 0,
   parameter           SEC_HMC_CFG_MPS_DQSTRK_DISABLE          = "",
   parameter [  3:  0] SEC_HMC_CFG_MPS_EXIT_CKE_TO_CS          = 0,
   parameter [  3:  0] SEC_HMC_CFG_MPS_EXIT_CS_TO_CKE          = 0,
   parameter [  9:  0] SEC_HMC_CFG_MPS_TO_VALID                = 0,
   parameter           SEC_HMC_CFG_MPS_ZQCAL_DISABLE           = "",
   parameter [  3:  0] SEC_HMC_CFG_MRR_TO_VALID                = 0,
   parameter [  3:  0] SEC_HMC_CFG_MRS_TO_VALID                = 0,
   parameter [  5:  0] SEC_HMC_CFG_PCH_ALL_TO_VALID            = 0,
   parameter [  5:  0] SEC_HMC_CFG_PCH_TO_VALID                = 0,
   parameter [ 15:  0] SEC_HMC_CFG_PDN_PERIOD                  = 0,
   parameter [  5:  0] SEC_HMC_CFG_PDN_TO_VALID                = 0,
   parameter [  5:  0] SEC_HMC_CFG_POWER_SAVING_EXIT_CYC       = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_AP_TO_VALID              = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_TO_PCH                   = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_TO_RD                    = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_TO_RD_DIFF_BG            = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_TO_RD_DIFF_CHIP          = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_TO_WR                    = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_TO_WR_DIFF_BG            = 0,
   parameter [  5:  0] SEC_HMC_CFG_RD_TO_WR_DIFF_CHIP          = 0,
   parameter [  6:  0] SEC_HMC_CFG_RFSH_WARN_THRESHOLD         = 0,
   parameter [  2:  0] SEC_HMC_CFG_RLD3_MULTIBANK_REF_DELAY    = 0,
   parameter [ 15:  0] SEC_HMC_CFG_RLD3_REFRESH_SEQ0           = 0,
   parameter [ 15:  0] SEC_HMC_CFG_RLD3_REFRESH_SEQ1           = 0,
   parameter [ 15:  0] SEC_HMC_CFG_RLD3_REFRESH_SEQ2           = 0,
   parameter [ 15:  0] SEC_HMC_CFG_RLD3_REFRESH_SEQ3           = 0,
   parameter           SEC_HMC_CFG_SB_CG_DISABLE               = "",
   parameter [ 19:  0] SEC_HMC_CFG_SB_DDR4_MR3                 = 0,
   parameter [ 19:  0] SEC_HMC_CFG_SB_DDR4_MR4                 = 0,
   parameter [ 19:  0] SEC_HMC_CFG_SB_DDR4_MR5                 = 0,
   parameter           SEC_HMC_CFG_DDR4_MPS_ADDRMIRROR         = "",
   parameter           SEC_HMC_CFG_SRF_AUTOEXIT_EN             = "",
   parameter [  1:  0] SEC_HMC_CFG_SRF_ENTRY_EXIT_BLOCK        = 0,
   parameter [  9:  0] SEC_HMC_CFG_SRF_TO_VALID                = 0,
   parameter [  9:  0] SEC_HMC_CFG_SRF_TO_ZQ_CAL               = 0,
   parameter           SEC_HMC_CFG_SRF_ZQCAL_DISABLE           = "",
   parameter [ 31:  0] SEC_HMC_TEMP_4_ACT_TO_ACT               = 0,
   parameter [ 31:  0] SEC_HMC_TEMP_RD_TO_RD_DIFF_BG           = 0,
   parameter [ 31:  0] SEC_HMC_TEMP_WR_TO_RD                   = 0,
   parameter [ 31:  0] SEC_HMC_TEMP_WR_TO_RD_DIFF_BG           = 0,
   parameter [ 31:  0] SEC_HMC_TEMP_WR_TO_RD_DIFF_CHIP         = 0,
   parameter [ 31:  0] SEC_HMC_TEMP_WR_TO_WR_DIFF_BG           = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_AP_TO_VALID              = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_TO_PCH                   = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_TO_RD                    = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_TO_RD_DIFF_BG            = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_TO_RD_DIFF_CHIP          = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_TO_WR                    = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_TO_WR_DIFF_BG            = 0,
   parameter [  5:  0] SEC_HMC_CFG_WR_TO_WR_DIFF_CHIP          = 0,
   parameter [  8:  0] SEC_HMC_CFG_ZQCL_TO_VALID               = 0,
   parameter [  6:  0] SEC_HMC_CFG_ZQCS_TO_VALID               = 0,
   parameter [  8:  0] SEC_HMC_CHIP_ID                         = 0,
   parameter [  1:  0] SEC_HMC_CID_ADDR_WIDTH                  = 0,
   parameter           SEC_HMC_3DS_EN                          = "",
   parameter [  3:  0] SEC_HMC_3DS_LR_NUM0                     = 0,
   parameter [  3:  0] SEC_HMC_3DS_LR_NUM1                     = 0,
   parameter [  3:  0] SEC_HMC_3DS_LR_NUM2                     = 0,
   parameter [  3:  0] SEC_HMC_3DS_LR_NUM3                     = 0,
   parameter           SEC_HMC_3DS_PR_STAG_ENABLE              = "",
   parameter [  6:  0] SEC_HMC_3DS_REF2REF_DLR                 = 0,
   parameter           SEC_HMC_3DSREF_ACK_ON_DONE              = "",
   
   parameter LANES_USAGE                             = 1'b0,
   parameter PINS_USAGE                              = 1'b0,
   parameter PINS_RATE                               = 1'b0,
   parameter DB_PINS_PROC_MODE                       = 1'b0,
   parameter PINS_DATA_IN_MODE                       = 1'b0,
   parameter PINS_OCT_MODE                           = 1'b0,
   parameter PINS_DCC_SPLIT                          = 1'b0,
   parameter CENTER_TIDS                             = 1'b0,
   parameter HMC_TIDS                                = 1'b0,
   parameter LANE_TIDS                               = 1'b0,
   parameter DBC_PIPE_LATS                           = 1'b0,
   parameter DB_PTR_PIPELINE_DEPTHS                  = 1'b0,
   parameter DB_SEQ_RD_EN_FULL_PIPELINES             = 1'b0,
   parameter PREAMBLE_MODE                           = "",
   parameter DBI_WR_ENABLE                           = "",
   parameter DBI_RD_ENABLE                           = "",
   parameter SWAP_DQS_A_B                            = "",
   parameter DQS_PACK_MODE                           = "",
   parameter OCT_SIZE                                = "",
   parameter DQSA_LGC_MODE                           = "",
   parameter DQSB_LGC_MODE                           = "",
   parameter [6:0] DBC_WB_RESERVED_ENTRY             = 4,
   parameter DLL_MODE                                = "",
   parameter [9:0] DLL_CODEWORD                      = 0,
   parameter PORT_MEM_DQ_WIDTH                       = 1,
   parameter PORT_MEM_DQS_WIDTH                      = 1,
   parameter PORT_DFT_ND_PA_DPRIO_REG_ADDR_WIDTH     = 1,
   parameter PORT_DFT_ND_PA_DPRIO_WRITEDATA_WIDTH    = 1,
   parameter PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH     = 1,
   
   parameter PORT_MEM_A_PINLOC                       = 0,
   parameter PORT_MEM_BA_PINLOC                      = 0,
   parameter PORT_MEM_BG_PINLOC                      = 0,
   parameter PORT_MEM_C_PINLOC                       = 0,
   parameter PORT_MEM_CS_N_PINLOC                    = 0,
   parameter PORT_MEM_ACT_N_PINLOC                   = 0,
   parameter PORT_MEM_DQ_PINLOC                      = 0,
   parameter PORT_MEM_DM_PINLOC                      = 0,
   parameter PORT_MEM_DBI_N_PINLOC                   = 0, 
   parameter PORT_MEM_RAS_N_PINLOC                   = 0,
   parameter PORT_MEM_CAS_N_PINLOC                   = 0,
   parameter PORT_MEM_WE_N_PINLOC                    = 0,
   parameter PORT_MEM_REF_N_PINLOC                   = 0,
   
   parameter PORT_MEM_WPS_N_PINLOC                   = 0,
   parameter PORT_MEM_RPS_N_PINLOC                   = 0,
   parameter PORT_MEM_BWS_N_PINLOC                   = 0,
   parameter PORT_MEM_DQA_PINLOC                     = 0,
   parameter PORT_MEM_DQB_PINLOC                     = 0,
   parameter PORT_MEM_Q_PINLOC                       = 0,
   parameter PORT_MEM_D_PINLOC                       = 0,
   parameter PORT_MEM_RWA_N_PINLOC                   = 0,
   parameter PORT_MEM_RWB_N_PINLOC                   = 0,
   parameter PORT_MEM_QKA_PINLOC                     = 0,
   parameter PORT_MEM_QKB_PINLOC                     = 0,
   parameter PORT_MEM_LDA_N_PINLOC                   = 0,
   parameter PORT_MEM_LDB_N_PINLOC                   = 0,
   parameter PORT_MEM_CK_PINLOC                      = 0,
   parameter PORT_MEM_DINVA_PINLOC                   = 0,
   parameter PORT_MEM_DINVB_PINLOC                   = 0,
   parameter PORT_MEM_AINV_PINLOC                    = 0,
   parameter PORT_MEM_DQS_PINLOC                     = 0,
   parameter PORT_MEM_QK_PINLOC                      = 0,
   parameter PORT_MEM_CQ_PINLOC                      = 0,
   
   parameter PORT_MEM_A_WIDTH                        = 0,
   parameter PORT_MEM_BA_WIDTH                       = 0,
   parameter PORT_MEM_BG_WIDTH                       = 0,
   parameter PORT_MEM_C_WIDTH                        = 0,
   parameter PORT_MEM_CS_N_WIDTH                     = 0,
   parameter PORT_MEM_ACT_N_WIDTH                    = 0,
   parameter PORT_MEM_DBI_N_WIDTH                    = 0,
   parameter PORT_MEM_RAS_N_WIDTH                    = 0,
   parameter PORT_MEM_CAS_N_WIDTH                    = 0,
   parameter PORT_MEM_WE_N_WIDTH                     = 0,
   parameter PORT_MEM_DM_WIDTH                       = 0,
   parameter PORT_MEM_REF_N_WIDTH                    = 0,
   parameter PORT_MEM_WPS_N_WIDTH                    = 0,
   parameter PORT_MEM_RPS_N_WIDTH                    = 0,
   parameter PORT_MEM_BWS_N_WIDTH                    = 0,
   parameter PORT_MEM_DQA_WIDTH                      = 0,
   parameter PORT_MEM_DQB_WIDTH                      = 0,
   parameter PORT_MEM_Q_WIDTH                        = 0,
   parameter PORT_MEM_D_WIDTH                        = 0,
   parameter PORT_MEM_RWA_N_WIDTH                    = 0,
   parameter PORT_MEM_RWB_N_WIDTH                    = 0,
   parameter PORT_MEM_QKA_WIDTH                      = 0,
   parameter PORT_MEM_QKB_WIDTH                      = 0,
   parameter PORT_MEM_LDA_N_WIDTH                    = 0,
   parameter PORT_MEM_LDB_N_WIDTH                    = 0,
   parameter PORT_MEM_CK_WIDTH                       = 0,
   parameter PORT_MEM_DINVA_WIDTH                    = 0,
   parameter PORT_MEM_DINVB_WIDTH                    = 0,
   parameter PORT_MEM_AINV_WIDTH                     = 0,
   parameter DIAG_USE_ABSTRACT_PHY                   = 0,
   parameter DIAG_ABSTRACT_PHY_WLAT                  = 0,
   parameter DIAG_ABSTRACT_PHY_RLAT                  = 0,
   parameter ABPHY_WRITE_PROTOCOL                    = 1,
   parameter DIAG_SIM_MEM_BYPASS_DQ_WIDTH                     = 1,
   parameter DIAG_SIM_MEM_BYPASS_ADDR_WIDTH                   = 1
) (
   // Reset related
   input logic                                                                                   core2seq_reset_req,           // For abstract phy support
   
   // Signals for various signals from PLL
   input  logic                                                                                  pll_locked,                   // Indicates PLL lock status
   input  logic                                                                                  pll_dll_clk,                  // PLL -> DLL output clock
   input  logic [7:0]                                                                            phy_clk_phs,                  // FR PHY clock signals (8 phases, 45-deg apart)
   input  logic [1:0]                                                                            phy_clk,                      // {phy_clk[1], phy_clk[0]}
   input  logic                                                                                  phy_fb_clk_to_tile,           // PHY feedback clock (to tile)
   output logic                                                                                  phy_fb_clk_to_pll,            // PHY feedback clock (to PLL)

   // Core clock signals from/to the Clock Phase Alignment (CPA) block
   output logic [1:0]                                                                            core_clks_from_cpa_pri,            // Core clock signals from the CPA of primary interface
   output logic [1:0]                                                                            core_clks_locked_cpa_pri,          // Core clock locked signals from the CPA of primary interface
   input  logic [1:0]                                                                            core_clks_fb_to_cpa_pri,           // Core clock feedback signals to the CPA of primary interface
   output logic [1:0]                                                                            core_clks_from_cpa_sec,            // Core clock signals from the CPA of secondary interface (ping-pong only)
   output logic [1:0]                                                                            core_clks_locked_cpa_sec,          // Core clock locked signals from the CPA of secondary interface (ping-pong only)
   input  logic [1:0]                                                                            core_clks_fb_to_cpa_sec,           // Core clock feedback signals to the CPA of secondary interface (ping-pong only)

   // Avalon interfaces between core and HMC
   input  logic [62:0]                                                                           core2ctl_avl_0,
   input  logic [62:0]                                                                           core2ctl_avl_1,
   input  logic                                                                                  core2ctl_avl_rd_data_ready_0,
   input  logic                                                                                  core2ctl_avl_rd_data_ready_1,
   output logic                                                                                  ctl2core_avl_cmd_ready_0,
   output logic                                                                                  ctl2core_avl_cmd_ready_1,
   output logic [12:0]                                                                           ctl2core_avl_rdata_id_0,
   output logic [12:0]                                                                           ctl2core_avl_rdata_id_1,
   input  logic                                                                                  core2l_wr_data_vld_ast_0,
   input  logic                                                                                  core2l_wr_data_vld_ast_1,
   input  logic                                                                                  core2l_rd_data_rdy_ast_0,
   input  logic                                                                                  core2l_rd_data_rdy_ast_1,

   // Avalon interfaces between core and lanes
   output logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0]                                       l2core_rd_data_vld_avl0,
   output logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0]                                       l2core_wr_data_rdy_ast,

   // ECC signals between core and lanes
   input  logic [12:0]                                                                           core2l_wr_ecc_info_0,
   input  logic [12:0]                                                                           core2l_wr_ecc_info_1,
   output logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][11:0]                                 l2core_wb_pointer_for_ecc,

   // Signals between core and data lanes
   input  logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][PINS_PER_LANE * 8 - 1:0]              core2l_data,
   output logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][PINS_PER_LANE * 8 - 1:0]              l2core_data,
   input  logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][PINS_PER_LANE * 4 - 1:0]              core2l_oe,
   input  logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][3:0]                                  core2l_rdata_en_full,
   input  logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][15:0]                                 core2l_mrnk_read,
   input  logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][15:0]                                 core2l_mrnk_write,
   output logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][3:0]                                  l2core_rdata_valid,
   output logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][5:0]                                  l2core_afi_rlat,
   output logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][5:0]                                  l2core_afi_wlat,
   output logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][5:0]                                  l2core_ioereg_locked,

   // AFI signals between tile and core
   input  [17:0]                                                                                 c2t_afi,
   output [26:0]                                                                                 t2c_afi,

   // Side-band signals between core and HMC
   input  logic [41:0]                                                                           core2ctl_sideband_0,
   output logic [13:0]                                                                           ctl2core_sideband_0,
   input  logic [41:0]                                                                           core2ctl_sideband_1,
   output logic [13:0]                                                                           ctl2core_sideband_1,

   // MMR signals between core and HMC
   output logic [33:0]                                                                           ctl2core_mmr_0,
   input  logic [50:0]                                                                           core2ctl_mmr_0,
   output logic [33:0]                                                                           ctl2core_mmr_1,
   input  logic [50:0]                                                                           core2ctl_mmr_1,

   // Signals between I/O buffers and lanes/tiles
   output logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_data,                  // lane-to-buffer data
   output logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_oe,                    // lane-to-buffer output-enable
   output logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_dtc,                   // lane-to-buffer dynamic-termination-control
   output logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_e_a,                   
   output logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_e_b,                   
   input  logic [PINS_IN_RTL_TILES-1:0]                                                          b2l_data,                  // buffer-to-lane data
   input  logic [LANES_IN_RTL_TILES-1:0]                                                         b2t_dqs,                   // buffer-to-tile DQS
   input  logic [LANES_IN_RTL_TILES-1:0]                                                         b2t_dqsb,                  // buffer-to-tile DQSb

   // Avalon-MM bus for the calibration commands between io_aux and tiles
   input  logic                                                                                  cal_bus_clk,
   input  logic                                                                                  cal_bus_avl_read,
   input  logic                                                                                  cal_bus_avl_write,
   input  logic [19:0]                                                                           cal_bus_avl_address,
   output logic [31:0]                                                                           cal_bus_avl_read_data,
   input  logic [31:0]                                                                           cal_bus_avl_write_data,

   // Ports for internal test and debug
   input  logic                                                                                  pa_dprio_clk,
   input  logic                                                                                  pa_dprio_read,
   input  logic [PORT_DFT_ND_PA_DPRIO_REG_ADDR_WIDTH-1:0]                                        pa_dprio_reg_addr,
   input  logic                                                                                  pa_dprio_rst_n,
   input  logic                                                                                  pa_dprio_write,
   input  logic [PORT_DFT_ND_PA_DPRIO_WRITEDATA_WIDTH-1:0]                                       pa_dprio_writedata,
   output logic                                                                                  pa_dprio_block_select,
   output logic [PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH-1:0]                                        pa_dprio_readdata,
   
   input logic                                                                                   afi_cal_success,
   output logic                                                                                  runAbstractPhySim
);
   timeunit 1ns;
   timeprecision 1ps;

   logic                                                                                  phy_fb_clk_to_pll_abphy;   
   logic [1:0]                                                                            core_clks_from_cpa_pri_abphy;   
   logic [1:0]                                                                            core_clks_locked_cpa_pri_abphy; 
   logic [1:0]                                                                            core_clks_from_cpa_sec_abphy;   
   logic [1:0]                                                                            core_clks_locked_cpa_sec_abphy; 
   logic                                                                                  ctl2core_avl_cmd_ready_0_abphy;
   logic                                                                                  ctl2core_avl_cmd_ready_1_abphy;
   logic [12:0]                                                                           ctl2core_avl_rdata_id_0_abphy;
   logic [12:0]                                                                           ctl2core_avl_rdata_id_1_abphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0]                                       l2core_rd_data_vld_avl0_abphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0]                                       l2core_wr_data_rdy_ast_abphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][11:0]                                 l2core_wb_pointer_for_ecc_abphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][PINS_PER_LANE * 8 - 1:0]              l2core_data_abphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][3:0]                                  l2core_rdata_valid_abphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][5:0]                                  l2core_afi_rlat_abphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][5:0]                                  l2core_afi_wlat_abphy;
   logic [26:0]                                                                           t2c_afi_abphy;   
   logic [13:0]                                                                           ctl2core_sideband_0_abphy;
   logic [13:0]                                                                           ctl2core_sideband_1_abphy;
   logic [33:0]                                                                           ctl2core_mmr_0_abphy;
   logic [33:0]                                                                           ctl2core_mmr_1_abphy;
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_data_abphy;         
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_oe_abphy;           
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_dtc_abphy;
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_e_a_abphy;
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_e_b_abphy;
   logic                                                                                  pa_dprio_block_select_abphy;
   logic [PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH-1:0]                                        pa_dprio_readdata_abphy;      
   
   logic                                                                                  phy_fb_clk_to_pll_nonabphy;   
   logic [1:0]                                                                            core_clks_from_cpa_pri_nonabphy;   
   logic [1:0]                                                                            core_clks_locked_cpa_pri_nonabphy; 
   logic [1:0]                                                                            core_clks_from_cpa_sec_nonabphy;   
   logic [1:0]                                                                            core_clks_locked_cpa_sec_nonabphy; 
   logic                                                                                  ctl2core_avl_cmd_ready_0_nonabphy;
   logic                                                                                  ctl2core_avl_cmd_ready_1_nonabphy;
   logic [12:0]                                                                           ctl2core_avl_rdata_id_0_nonabphy;
   logic [12:0]                                                                           ctl2core_avl_rdata_id_1_nonabphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0]                                       l2core_rd_data_vld_avl0_nonabphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0]                                       l2core_wr_data_rdy_ast_nonabphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][11:0]                                 l2core_wb_pointer_for_ecc_nonabphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][PINS_PER_LANE * 8 - 1:0]              l2core_data_nonabphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][3:0]                                  l2core_rdata_valid_nonabphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][5:0]                                  l2core_afi_rlat_nonabphy;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][5:0]                                  l2core_afi_wlat_nonabphy;
   logic [26:0]                                                                           t2c_afi_nonabphy;   
   logic [13:0]                                                                           ctl2core_sideband_0_nonabphy;
   logic [13:0]                                                                           ctl2core_sideband_1_nonabphy;
   logic [33:0]                                                                           ctl2core_mmr_0_nonabphy;
   logic [33:0]                                                                           ctl2core_mmr_1_nonabphy;
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_data_nonabphy;         
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_oe_nonabphy;           
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_dtc_nonabphy;
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_e_a_nonabphy;
   logic [PINS_IN_RTL_TILES-1:0]                                                          l2b_e_b_nonabphy;         
   logic                                                                                  pa_dprio_block_select_nonabphy;
   logic [PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH-1:0]                                        pa_dprio_readdata_nonabphy;
   
   logic                                                                                  core2seq_reset_req_iotile_in;
   logic                                                                                  pll_locked_iotile_in;
   logic                                                                                  pll_dll_clk_iotile_in;
   logic [7:0]                                                                            phy_clk_phs_iotile_in;
   logic [1:0]                                                                            phy_clk_iotile_in;
   logic                                                                                  phy_fb_clk_to_tile_iotile_in;
   logic [1:0]                                                                            core_clks_fb_to_cpa_pri_iotile_in;
   logic [1:0]                                                                            core_clks_fb_to_cpa_sec_iotile_in;
   logic [62:0]                                                                           core2ctl_avl_0_iotile_in;
   logic [62:0]                                                                           core2ctl_avl_1_iotile_in;
   logic                                                                                  core2ctl_avl_rd_data_ready_0_iotile_in;
   logic                                                                                  core2ctl_avl_rd_data_ready_1_iotile_in;
   logic                                                                                  core2l_wr_data_vld_ast_0_iotile_in;
   logic                                                                                  core2l_wr_data_vld_ast_1_iotile_in;
   logic                                                                                  core2l_rd_data_rdy_ast_0_iotile_in;
   logic                                                                                  core2l_rd_data_rdy_ast_1_iotile_in;
   logic [12:0]                                                                           core2l_wr_ecc_info_0_iotile_in;
   logic [12:0]                                                                           core2l_wr_ecc_info_1_iotile_in;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][PINS_PER_LANE * 8 - 1:0]              core2l_data_iotile_in;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][PINS_PER_LANE * 4 - 1:0]              core2l_oe_iotile_in;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][3:0]                                  core2l_rdata_en_full_iotile_in;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][15:0]                                 core2l_mrnk_read_iotile_in;
   logic [NUM_OF_RTL_TILES-1:0][LANES_PER_TILE-1:0][15:0]                                 core2l_mrnk_write_iotile_in;
   logic [17:0]                                                                           c2t_afi_iotile_in;
   logic [41:0]                                                                           core2ctl_sideband_0_iotile_in;
   logic [41:0]                                                                           core2ctl_sideband_1_iotile_in;
   logic [50:0]                                                                           core2ctl_mmr_0_iotile_in;
   logic [50:0]                                                                           core2ctl_mmr_1_iotile_in;
   logic [PINS_IN_RTL_TILES-1:0]                                                          b2l_data_iotile_in;
   logic [LANES_IN_RTL_TILES-1:0]                                                         b2t_dqs_iotile_in;
   logic [LANES_IN_RTL_TILES-1:0]                                                         b2t_dqsb_iotile_in;
   logic                                                                                  cal_bus_clk_iotile_in;
   logic                                                                                  cal_bus_avl_read_iotile_in;
   logic                                                                                  cal_bus_avl_write_iotile_in;
   logic [19:0]                                                                           cal_bus_avl_address_iotile_in;
   logic [31:0]                                                                           cal_bus_avl_write_data_iotile_in;
   logic                                                                                  pa_dprio_clk_iotile_in;
   logic                                                                                  pa_dprio_read_iotile_in;
   logic [PORT_DFT_ND_PA_DPRIO_REG_ADDR_WIDTH-1:0]                                        pa_dprio_reg_addr_iotile_in;
   logic                                                                                  pa_dprio_rst_n_iotile_in;
   logic                                                                                  pa_dprio_write_iotile_in;
   logic [PORT_DFT_ND_PA_DPRIO_WRITEDATA_WIDTH-1:0]                                       pa_dprio_writedata_iotile_in;
   
   
   altera_emif_arch_nd_io_tiles #(
      .DIAG_SYNTH_FOR_SIM                   (DIAG_SYNTH_FOR_SIM),
      .DIAG_CPA_OUT_1_EN                    (DIAG_CPA_OUT_1_EN),
      .DIAG_FAST_SIM                        (DIAG_FAST_SIM),
      .DIAG_SEQ_RESET_AUTO_RELEASE          (DIAG_SEQ_RESET_AUTO_RELEASE),
      .DIAG_DB_RESET_AUTO_RELEASE           (DIAG_DB_RESET_AUTO_RELEASE),
      .IS_HPS                               (IS_HPS),
      .SILICON_REV                          (SILICON_REV),
      .PROTOCOL_ENUM                        (PROTOCOL_ENUM),
      .PHY_PING_PONG_EN                     (PHY_PING_PONG_EN),
      .DQS_BUS_MODE_ENUM                    (DQS_BUS_MODE_ENUM),
      .USER_CLK_RATIO                       (USER_CLK_RATIO),
      .PHY_HMC_CLK_RATIO                    (PHY_HMC_CLK_RATIO),
      .C2P_P2C_CLK_RATIO                    (C2P_P2C_CLK_RATIO),
      .PLL_VCO_FREQ_MHZ_INT                 (PLL_VCO_FREQ_MHZ_INT),
      .PLL_VCO_TO_MEM_CLK_FREQ_RATIO        (PLL_VCO_TO_MEM_CLK_FREQ_RATIO),
      .MEM_BURST_LENGTH                     (MEM_BURST_LENGTH),
      .MEM_DATA_MASK_EN                     (MEM_DATA_MASK_EN),
      .NUM_OF_HMC_PORTS                     (NUM_OF_HMC_PORTS),
      .HMC_AVL_PROTOCOL_ENUM                (HMC_AVL_PROTOCOL_ENUM),
      .HMC_CTRL_DIMM_TYPE                   (HMC_CTRL_DIMM_TYPE),
      
      .PRI_HMC_CFG_PING_PONG_MODE           (PRI_HMC_CFG_PING_PONG_MODE),
      .PRI_HMC_CFG_CS_ADDR_WIDTH            (PRI_HMC_CFG_CS_ADDR_WIDTH),
      .PRI_HMC_CFG_COL_ADDR_WIDTH           (PRI_HMC_CFG_COL_ADDR_WIDTH),
      .PRI_HMC_CFG_ROW_ADDR_WIDTH           (PRI_HMC_CFG_ROW_ADDR_WIDTH),
      .PRI_HMC_CFG_BANK_ADDR_WIDTH          (PRI_HMC_CFG_BANK_ADDR_WIDTH),
      .PRI_HMC_CFG_BANK_GROUP_ADDR_WIDTH    (PRI_HMC_CFG_BANK_GROUP_ADDR_WIDTH),
      .PRI_HMC_CFG_ADDR_ORDER               (PRI_HMC_CFG_ADDR_ORDER),
      .PRI_HMC_CFG_ARBITER_TYPE             (PRI_HMC_CFG_ARBITER_TYPE),
      .PRI_HMC_CFG_OPEN_PAGE_EN             (PRI_HMC_CFG_OPEN_PAGE_EN),
      .PRI_HMC_CFG_CTRL_ENABLE_RC           (PRI_HMC_CFG_CTRL_ENABLE_RC),
      .PRI_HMC_CFG_DBC0_ENABLE_RC           (PRI_HMC_CFG_DBC0_ENABLE_RC),
      .PRI_HMC_CFG_DBC1_ENABLE_RC           (PRI_HMC_CFG_DBC1_ENABLE_RC),
      .PRI_HMC_CFG_DBC2_ENABLE_RC           (PRI_HMC_CFG_DBC2_ENABLE_RC),
      .PRI_HMC_CFG_DBC3_ENABLE_RC           (PRI_HMC_CFG_DBC3_ENABLE_RC),
      .PRI_HMC_CFG_CTRL_ENABLE_ECC          (PRI_HMC_CFG_CTRL_ENABLE_ECC),
      .PRI_HMC_CFG_DBC0_ENABLE_ECC          (PRI_HMC_CFG_DBC0_ENABLE_ECC),
      .PRI_HMC_CFG_DBC1_ENABLE_ECC          (PRI_HMC_CFG_DBC1_ENABLE_ECC),
      .PRI_HMC_CFG_DBC2_ENABLE_ECC          (PRI_HMC_CFG_DBC2_ENABLE_ECC),
      .PRI_HMC_CFG_DBC3_ENABLE_ECC          (PRI_HMC_CFG_DBC3_ENABLE_ECC),
      .PRI_HMC_CFG_REORDER_DATA             (PRI_HMC_CFG_REORDER_DATA),
      .PRI_HMC_CFG_REORDER_READ             (PRI_HMC_CFG_REORDER_READ),
      .PRI_HMC_CFG_CTRL_REORDER_RDATA       (PRI_HMC_CFG_CTRL_REORDER_RDATA),
      .PRI_HMC_CFG_DBC0_REORDER_RDATA       (PRI_HMC_CFG_DBC0_REORDER_RDATA),
      .PRI_HMC_CFG_DBC1_REORDER_RDATA       (PRI_HMC_CFG_DBC1_REORDER_RDATA),
      .PRI_HMC_CFG_DBC2_REORDER_RDATA       (PRI_HMC_CFG_DBC2_REORDER_RDATA),
      .PRI_HMC_CFG_DBC3_REORDER_RDATA       (PRI_HMC_CFG_DBC3_REORDER_RDATA),
      .PRI_HMC_CFG_CTRL_SLOT_OFFSET         (PRI_HMC_CFG_CTRL_SLOT_OFFSET),
      .PRI_HMC_CFG_DBC0_SLOT_OFFSET         (PRI_HMC_CFG_DBC0_SLOT_OFFSET),
      .PRI_HMC_CFG_DBC1_SLOT_OFFSET         (PRI_HMC_CFG_DBC1_SLOT_OFFSET),
      .PRI_HMC_CFG_DBC2_SLOT_OFFSET         (PRI_HMC_CFG_DBC2_SLOT_OFFSET),
      .PRI_HMC_CFG_DBC3_SLOT_OFFSET         (PRI_HMC_CFG_DBC3_SLOT_OFFSET),
      .PRI_HMC_CFG_CTRL_SLOT_ROTATE_EN      (PRI_HMC_CFG_CTRL_SLOT_ROTATE_EN),
      .PRI_HMC_CFG_DBC0_SLOT_ROTATE_EN      (PRI_HMC_CFG_DBC0_SLOT_ROTATE_EN),
      .PRI_HMC_CFG_DBC1_SLOT_ROTATE_EN      (PRI_HMC_CFG_DBC1_SLOT_ROTATE_EN),
      .PRI_HMC_CFG_DBC2_SLOT_ROTATE_EN      (PRI_HMC_CFG_DBC2_SLOT_ROTATE_EN),
      .PRI_HMC_CFG_DBC3_SLOT_ROTATE_EN      (PRI_HMC_CFG_DBC3_SLOT_ROTATE_EN),
      .PRI_HMC_CFG_COL_CMD_SLOT             (PRI_HMC_CFG_COL_CMD_SLOT),
      .PRI_HMC_CFG_ROW_CMD_SLOT             (PRI_HMC_CFG_ROW_CMD_SLOT),
      .PRI_HMC_CFG_ROW_TO_COL_OFFSET        (PRI_HMC_CFG_ROW_TO_COL_OFFSET),
      .PRI_HMC_CFG_ROW_TO_ROW_OFFSET        (PRI_HMC_CFG_ROW_TO_ROW_OFFSET),
      .PRI_HMC_CFG_COL_TO_COL_OFFSET        (PRI_HMC_CFG_COL_TO_COL_OFFSET),
      .PRI_HMC_CFG_COL_TO_DIFF_COL_OFFSET   (PRI_HMC_CFG_COL_TO_DIFF_COL_OFFSET),
      .PRI_HMC_CFG_COL_TO_ROW_OFFSET        (PRI_HMC_CFG_COL_TO_ROW_OFFSET),
      .PRI_HMC_CFG_SIDEBAND_OFFSET          (PRI_HMC_CFG_SIDEBAND_OFFSET),
      .PRI_HMC_CFG_CS_TO_CHIP_MAPPING       (PRI_HMC_CFG_CS_TO_CHIP_MAPPING),
      .PRI_HMC_CFG_CTL_ODT_ENABLED          (PRI_HMC_CFG_CTL_ODT_ENABLED),
      .PRI_HMC_CFG_RD_ODT_ON                (PRI_HMC_CFG_RD_ODT_ON),
      .PRI_HMC_CFG_RD_ODT_PERIOD            (PRI_HMC_CFG_RD_ODT_PERIOD),
      .PRI_HMC_CFG_READ_ODT_CHIP            (PRI_HMC_CFG_READ_ODT_CHIP),
      .PRI_HMC_CFG_WR_ODT_ON                (PRI_HMC_CFG_WR_ODT_ON),
      .PRI_HMC_CFG_WR_ODT_PERIOD            (PRI_HMC_CFG_WR_ODT_PERIOD),
      .PRI_HMC_CFG_WRITE_ODT_CHIP           (PRI_HMC_CFG_WRITE_ODT_CHIP),
      .PRI_HMC_CFG_CMD_FIFO_RESERVE_EN      (PRI_HMC_CFG_CMD_FIFO_RESERVE_EN),
      .PRI_HMC_CFG_RB_RESERVED_ENTRY        (PRI_HMC_CFG_RB_RESERVED_ENTRY),
      .PRI_HMC_CFG_WB_RESERVED_ENTRY        (PRI_HMC_CFG_WB_RESERVED_ENTRY),
      .PRI_HMC_CFG_STARVE_LIMIT             (PRI_HMC_CFG_STARVE_LIMIT),
      .PRI_HMC_CFG_PHY_DELAY_MISMATCH       (PRI_HMC_CFG_PHY_DELAY_MISMATCH),
      .PRI_HMC_CFG_DQSTRK_EN                (PRI_HMC_CFG_DQSTRK_EN),
      .PRI_HMC_CFG_DQSTRK_TO_VALID          (PRI_HMC_CFG_DQSTRK_TO_VALID),
      .PRI_HMC_CFG_DQSTRK_TO_VALID_LAST     (PRI_HMC_CFG_DQSTRK_TO_VALID_LAST),
      .PRI_HMC_CFG_CTL_SHORT_DQSTRK_EN      (PRI_HMC_CFG_CTL_SHORT_DQSTRK_EN),
      .PRI_HMC_CFG_PERIOD_DQSTRK_CTRL_EN    (PRI_HMC_CFG_PERIOD_DQSTRK_CTRL_EN),
      .PRI_HMC_CFG_PERIOD_DQSTRK_INTERVAL   (PRI_HMC_CFG_PERIOD_DQSTRK_INTERVAL),
      .PRI_HMC_CFG_SHORT_DQSTRK_CTRL_EN     (PRI_HMC_CFG_SHORT_DQSTRK_CTRL_EN),
      .PRI_HMC_CFG_ENABLE_FAST_EXIT_PPD     (PRI_HMC_CFG_ENABLE_FAST_EXIT_PPD),
      .PRI_HMC_CFG_USER_RFSH_EN             (PRI_HMC_CFG_USER_RFSH_EN),
      .PRI_HMC_CFG_GEAR_DOWN_EN             (PRI_HMC_CFG_GEAR_DOWN_EN),
      .PRI_HMC_CFG_MEM_AUTO_PD_CYCLES       (PRI_HMC_CFG_MEM_AUTO_PD_CYCLES),
      .PRI_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC (PRI_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC),
      .PRI_HMC_MEMCLKGATE_SETTING           (PRI_HMC_MEMCLKGATE_SETTING),
      .PRI_HMC_CFG_TCL                      (PRI_HMC_CFG_TCL),
      .PRI_HMC_CFG_16_ACT_TO_ACT            (PRI_HMC_CFG_16_ACT_TO_ACT),
      .PRI_HMC_CFG_4_ACT_TO_ACT             (PRI_HMC_CFG_4_ACT_TO_ACT),
      .PRI_HMC_MEM_IF_AL                    (PRI_HMC_MEM_IF_AL),
      .PRI_HMC_MEM_IF_CS_PER_DIMM           (PRI_HMC_MEM_IF_CS_PER_DIMM),
      .PRI_HMC_MEM_IF_RD_PREAMBLE           (PRI_HMC_MEM_IF_RD_PREAMBLE),
      .PRI_HMC_MEM_IF_TCCD                  (PRI_HMC_MEM_IF_TCCD),
      .PRI_HMC_MEM_IF_TCCD_S                (PRI_HMC_MEM_IF_TCCD_S),
      .PRI_HMC_MEM_IF_TCKESR                (PRI_HMC_MEM_IF_TCKESR),
      .PRI_HMC_MEM_IF_TCKSRX                (PRI_HMC_MEM_IF_TCKSRX),
      .PRI_HMC_MEM_IF_TCL                   (PRI_HMC_MEM_IF_TCL),
      .PRI_HMC_MEM_IF_TCWL                  (PRI_HMC_MEM_IF_TCWL),
      .PRI_HMC_MEM_IF_TDQSCKMAX             (PRI_HMC_MEM_IF_TDQSCKMAX),
      .PRI_HMC_MEM_IF_TFAW                  (PRI_HMC_MEM_IF_TFAW),
      .PRI_HMC_MEM_IF_TMOD                  (PRI_HMC_MEM_IF_TMOD),
      .PRI_HMC_MEM_IF_TPL                   (PRI_HMC_MEM_IF_TPL),
      .PRI_HMC_MEM_IF_TRAS                  (PRI_HMC_MEM_IF_TRAS),
      .PRI_HMC_MEM_IF_TRC                   (PRI_HMC_MEM_IF_TRC),
      .PRI_HMC_MEM_IF_TRCD                  (PRI_HMC_MEM_IF_TRCD),
      .PRI_HMC_MEM_IF_TREFI                 (PRI_HMC_MEM_IF_TREFI),
      .PRI_HMC_MEM_IF_TRFC                  (PRI_HMC_MEM_IF_TRFC),
      .PRI_HMC_MEM_IF_TRP                   (PRI_HMC_MEM_IF_TRP),
      .PRI_HMC_MEM_IF_TRRD                  (PRI_HMC_MEM_IF_TRRD),
      .PRI_HMC_MEM_IF_TRRD_S                (PRI_HMC_MEM_IF_TRRD_S),
      .PRI_HMC_MEM_IF_TRTP                  (PRI_HMC_MEM_IF_TRTP),
      .PRI_HMC_MEM_IF_TWR                   (PRI_HMC_MEM_IF_TWR),
      .PRI_HMC_MEM_IF_TWR_CRC_DM            (PRI_HMC_MEM_IF_TWR_CRC_DM),
      .PRI_HMC_MEM_IF_TWTR                  (PRI_HMC_MEM_IF_TWTR),
      .PRI_HMC_MEM_IF_TWTR_L_CRC_DM         (PRI_HMC_MEM_IF_TWTR_L_CRC_DM),
      .PRI_HMC_MEM_IF_TWTR_S                (PRI_HMC_MEM_IF_TWTR_S),
      .PRI_HMC_MEM_IF_TWTR_S_CRC_DM         (PRI_HMC_MEM_IF_TWTR_S_CRC_DM),
      .PRI_HMC_MEM_IF_TXP                   (PRI_HMC_MEM_IF_TXP),
      .PRI_HMC_MEM_IF_TXPDLL                (PRI_HMC_MEM_IF_TXPDLL),
      .PRI_HMC_MEM_IF_TXSR                  (PRI_HMC_MEM_IF_TXSR),
      .PRI_HMC_MEM_IF_TZQCS                 (PRI_HMC_MEM_IF_TZQCS),
      .PRI_HMC_MEM_IF_TZQOPER               (PRI_HMC_MEM_IF_TZQOPER),
      .PRI_HMC_MEM_IF_WR_CRC                (PRI_HMC_MEM_IF_WR_CRC),
      .PRI_HMC_MEM_IF_WR_PREAMBLE           (PRI_HMC_MEM_IF_WR_PREAMBLE),
      .PRI_HMC_CFG_ACT_TO_ACT               (PRI_HMC_CFG_ACT_TO_ACT),
      .PRI_HMC_CFG_ACT_TO_ACT_DIFF_BANK     (PRI_HMC_CFG_ACT_TO_ACT_DIFF_BANK),
      .PRI_HMC_CFG_ACT_TO_ACT_DIFF_BG       (PRI_HMC_CFG_ACT_TO_ACT_DIFF_BG),
      .PRI_HMC_CFG_ACT_TO_PCH               (PRI_HMC_CFG_ACT_TO_PCH),
      .PRI_HMC_CFG_ACT_TO_RDWR              (PRI_HMC_CFG_ACT_TO_RDWR),
      .PRI_HMC_CFG_ARF_PERIOD               (PRI_HMC_CFG_ARF_PERIOD),
      .PRI_HMC_CFG_ARF_TO_VALID             (PRI_HMC_CFG_ARF_TO_VALID),
      .PRI_HMC_CFG_MMR_CMD_TO_VALID         (PRI_HMC_CFG_MMR_CMD_TO_VALID),
      .PRI_HMC_CFG_MPR_TO_VALID             (PRI_HMC_CFG_MPR_TO_VALID),
      .PRI_HMC_CFG_MPS_DQSTRK_DISABLE       (PRI_HMC_CFG_MPS_DQSTRK_DISABLE),
      .PRI_HMC_CFG_MPS_EXIT_CKE_TO_CS       (PRI_HMC_CFG_MPS_EXIT_CKE_TO_CS),
      .PRI_HMC_CFG_MPS_EXIT_CS_TO_CKE       (PRI_HMC_CFG_MPS_EXIT_CS_TO_CKE),
      .PRI_HMC_CFG_MPS_TO_VALID             (PRI_HMC_CFG_MPS_TO_VALID),
      .PRI_HMC_CFG_MPS_ZQCAL_DISABLE        (PRI_HMC_CFG_MPS_ZQCAL_DISABLE),
      .PRI_HMC_CFG_MRR_TO_VALID             (PRI_HMC_CFG_MRR_TO_VALID),
      .PRI_HMC_CFG_MRS_TO_VALID             (PRI_HMC_CFG_MRS_TO_VALID),
      .PRI_HMC_CFG_PCH_ALL_TO_VALID         (PRI_HMC_CFG_PCH_ALL_TO_VALID),
      .PRI_HMC_CFG_PCH_TO_VALID             (PRI_HMC_CFG_PCH_TO_VALID),
      .PRI_HMC_CFG_PDN_PERIOD               (PRI_HMC_CFG_PDN_PERIOD),
      .PRI_HMC_CFG_PDN_TO_VALID             (PRI_HMC_CFG_PDN_TO_VALID),
      .PRI_HMC_CFG_POWER_SAVING_EXIT_CYC    (PRI_HMC_CFG_POWER_SAVING_EXIT_CYC),
      .PRI_HMC_CFG_RD_AP_TO_VALID           (PRI_HMC_CFG_RD_AP_TO_VALID),
      .PRI_HMC_CFG_RD_TO_PCH                (PRI_HMC_CFG_RD_TO_PCH),
      .PRI_HMC_CFG_RD_TO_RD                 (PRI_HMC_CFG_RD_TO_RD),
      .PRI_HMC_CFG_RD_TO_RD_DIFF_BG         (PRI_HMC_CFG_RD_TO_RD_DIFF_BG),
      .PRI_HMC_CFG_RD_TO_RD_DIFF_CHIP       (PRI_HMC_CFG_RD_TO_RD_DIFF_CHIP),
      .PRI_HMC_CFG_RD_TO_WR                 (PRI_HMC_CFG_RD_TO_WR),
      .PRI_HMC_CFG_RD_TO_WR_DIFF_BG         (PRI_HMC_CFG_RD_TO_WR_DIFF_BG),
      .PRI_HMC_CFG_RD_TO_WR_DIFF_CHIP       (PRI_HMC_CFG_RD_TO_WR_DIFF_CHIP),
      .PRI_HMC_CFG_RFSH_WARN_THRESHOLD      (PRI_HMC_CFG_RFSH_WARN_THRESHOLD),
      .PRI_HMC_CFG_RLD3_MULTIBANK_REF_DELAY (PRI_HMC_CFG_RLD3_MULTIBANK_REF_DELAY),
      .PRI_HMC_CFG_RLD3_REFRESH_SEQ0        (PRI_HMC_CFG_RLD3_REFRESH_SEQ0),
      .PRI_HMC_CFG_RLD3_REFRESH_SEQ1        (PRI_HMC_CFG_RLD3_REFRESH_SEQ1),
      .PRI_HMC_CFG_RLD3_REFRESH_SEQ2        (PRI_HMC_CFG_RLD3_REFRESH_SEQ2),
      .PRI_HMC_CFG_RLD3_REFRESH_SEQ3        (PRI_HMC_CFG_RLD3_REFRESH_SEQ3),
      .PRI_HMC_CFG_SB_CG_DISABLE            (PRI_HMC_CFG_SB_CG_DISABLE),
      .PRI_HMC_CFG_SB_DDR4_MR3              (PRI_HMC_CFG_SB_DDR4_MR3),
      .PRI_HMC_CFG_SB_DDR4_MR4              (PRI_HMC_CFG_SB_DDR4_MR4),
      .PRI_HMC_CFG_SB_DDR4_MR5              (PRI_HMC_CFG_SB_DDR4_MR5),
      .PRI_HMC_CFG_DDR4_MPS_ADDRMIRROR      (PRI_HMC_CFG_DDR4_MPS_ADDRMIRROR),
      .PRI_HMC_CFG_SRF_AUTOEXIT_EN          (PRI_HMC_CFG_SRF_AUTOEXIT_EN),
      .PRI_HMC_CFG_SRF_ENTRY_EXIT_BLOCK     (PRI_HMC_CFG_SRF_ENTRY_EXIT_BLOCK),
      .PRI_HMC_CFG_SRF_TO_VALID             (PRI_HMC_CFG_SRF_TO_VALID),
      .PRI_HMC_CFG_SRF_TO_ZQ_CAL            (PRI_HMC_CFG_SRF_TO_ZQ_CAL),
      .PRI_HMC_CFG_SRF_ZQCAL_DISABLE        (PRI_HMC_CFG_SRF_ZQCAL_DISABLE),
      .PRI_HMC_TEMP_4_ACT_TO_ACT            (PRI_HMC_TEMP_4_ACT_TO_ACT),
      .PRI_HMC_TEMP_RD_TO_RD_DIFF_BG        (PRI_HMC_TEMP_RD_TO_RD_DIFF_BG),
      .PRI_HMC_TEMP_WR_TO_RD                (PRI_HMC_TEMP_WR_TO_RD),
      .PRI_HMC_TEMP_WR_TO_RD_DIFF_BG        (PRI_HMC_TEMP_WR_TO_RD_DIFF_BG),
      .PRI_HMC_TEMP_WR_TO_RD_DIFF_CHIP      (PRI_HMC_TEMP_WR_TO_RD_DIFF_CHIP),
      .PRI_HMC_TEMP_WR_TO_WR_DIFF_BG        (PRI_HMC_TEMP_WR_TO_WR_DIFF_BG),
      .PRI_HMC_CFG_WR_AP_TO_VALID           (PRI_HMC_CFG_WR_AP_TO_VALID),
      .PRI_HMC_CFG_WR_TO_PCH                (PRI_HMC_CFG_WR_TO_PCH),
      .PRI_HMC_CFG_WR_TO_RD                 (PRI_HMC_CFG_WR_TO_RD),
      .PRI_HMC_CFG_WR_TO_RD_DIFF_BG         (PRI_HMC_CFG_WR_TO_RD_DIFF_BG),
      .PRI_HMC_CFG_WR_TO_RD_DIFF_CHIP       (PRI_HMC_CFG_WR_TO_RD_DIFF_CHIP),
      .PRI_HMC_CFG_WR_TO_WR                 (PRI_HMC_CFG_WR_TO_WR),
      .PRI_HMC_CFG_WR_TO_WR_DIFF_BG         (PRI_HMC_CFG_WR_TO_WR_DIFF_BG),
      .PRI_HMC_CFG_WR_TO_WR_DIFF_CHIP       (PRI_HMC_CFG_WR_TO_WR_DIFF_CHIP),
      .PRI_HMC_CFG_ZQCL_TO_VALID            (PRI_HMC_CFG_ZQCL_TO_VALID),
      .PRI_HMC_CFG_ZQCS_TO_VALID            (PRI_HMC_CFG_ZQCS_TO_VALID),
      .PRI_HMC_CHIP_ID                      (PRI_HMC_CHIP_ID),
      .PRI_HMC_CID_ADDR_WIDTH               (PRI_HMC_CID_ADDR_WIDTH),
      .PRI_HMC_3DS_EN                       (PRI_HMC_3DS_EN),
      .PRI_HMC_3DS_LR_NUM0                  (PRI_HMC_3DS_LR_NUM0),
      .PRI_HMC_3DS_LR_NUM1                  (PRI_HMC_3DS_LR_NUM1),
      .PRI_HMC_3DS_LR_NUM2                  (PRI_HMC_3DS_LR_NUM2),
      .PRI_HMC_3DS_LR_NUM3                  (PRI_HMC_3DS_LR_NUM3),
      .PRI_HMC_3DS_PR_STAG_ENABLE           (PRI_HMC_3DS_PR_STAG_ENABLE),
      .PRI_HMC_3DS_REF2REF_DLR              (PRI_HMC_3DS_REF2REF_DLR),
      .PRI_HMC_3DSREF_ACK_ON_DONE           (PRI_HMC_3DSREF_ACK_ON_DONE),
      .SEC_HMC_CFG_PING_PONG_MODE           (SEC_HMC_CFG_PING_PONG_MODE),
      .SEC_HMC_CFG_CS_ADDR_WIDTH            (SEC_HMC_CFG_CS_ADDR_WIDTH),
      .SEC_HMC_CFG_COL_ADDR_WIDTH           (SEC_HMC_CFG_COL_ADDR_WIDTH),
      .SEC_HMC_CFG_ROW_ADDR_WIDTH           (SEC_HMC_CFG_ROW_ADDR_WIDTH),
      .SEC_HMC_CFG_BANK_ADDR_WIDTH          (SEC_HMC_CFG_BANK_ADDR_WIDTH),
      .SEC_HMC_CFG_BANK_GROUP_ADDR_WIDTH    (SEC_HMC_CFG_BANK_GROUP_ADDR_WIDTH),
      .SEC_HMC_CFG_ADDR_ORDER               (SEC_HMC_CFG_ADDR_ORDER),
      .SEC_HMC_CFG_ARBITER_TYPE             (SEC_HMC_CFG_ARBITER_TYPE),
      .SEC_HMC_CFG_OPEN_PAGE_EN             (SEC_HMC_CFG_OPEN_PAGE_EN),
      .SEC_HMC_CFG_CTRL_ENABLE_RC           (SEC_HMC_CFG_CTRL_ENABLE_RC),
      .SEC_HMC_CFG_DBC0_ENABLE_RC           (SEC_HMC_CFG_DBC0_ENABLE_RC),
      .SEC_HMC_CFG_DBC1_ENABLE_RC           (SEC_HMC_CFG_DBC1_ENABLE_RC),
      .SEC_HMC_CFG_DBC2_ENABLE_RC           (SEC_HMC_CFG_DBC2_ENABLE_RC),
      .SEC_HMC_CFG_DBC3_ENABLE_RC           (SEC_HMC_CFG_DBC3_ENABLE_RC),
      .SEC_HMC_CFG_CTRL_ENABLE_ECC          (SEC_HMC_CFG_CTRL_ENABLE_ECC),
      .SEC_HMC_CFG_DBC0_ENABLE_ECC          (SEC_HMC_CFG_DBC0_ENABLE_ECC),
      .SEC_HMC_CFG_DBC1_ENABLE_ECC          (SEC_HMC_CFG_DBC1_ENABLE_ECC),
      .SEC_HMC_CFG_DBC2_ENABLE_ECC          (SEC_HMC_CFG_DBC2_ENABLE_ECC),
      .SEC_HMC_CFG_DBC3_ENABLE_ECC          (SEC_HMC_CFG_DBC3_ENABLE_ECC),
      .SEC_HMC_CFG_REORDER_DATA             (SEC_HMC_CFG_REORDER_DATA),
      .SEC_HMC_CFG_REORDER_READ             (SEC_HMC_CFG_REORDER_READ),
      .SEC_HMC_CFG_CTRL_REORDER_RDATA       (SEC_HMC_CFG_CTRL_REORDER_RDATA),
      .SEC_HMC_CFG_DBC0_REORDER_RDATA       (SEC_HMC_CFG_DBC0_REORDER_RDATA),
      .SEC_HMC_CFG_DBC1_REORDER_RDATA       (SEC_HMC_CFG_DBC1_REORDER_RDATA),
      .SEC_HMC_CFG_DBC2_REORDER_RDATA       (SEC_HMC_CFG_DBC2_REORDER_RDATA),
      .SEC_HMC_CFG_DBC3_REORDER_RDATA       (SEC_HMC_CFG_DBC3_REORDER_RDATA),
      .SEC_HMC_CFG_CTRL_SLOT_OFFSET         (SEC_HMC_CFG_CTRL_SLOT_OFFSET),
      .SEC_HMC_CFG_DBC0_SLOT_OFFSET         (SEC_HMC_CFG_DBC0_SLOT_OFFSET),
      .SEC_HMC_CFG_DBC1_SLOT_OFFSET         (SEC_HMC_CFG_DBC1_SLOT_OFFSET),
      .SEC_HMC_CFG_DBC2_SLOT_OFFSET         (SEC_HMC_CFG_DBC2_SLOT_OFFSET),
      .SEC_HMC_CFG_DBC3_SLOT_OFFSET         (SEC_HMC_CFG_DBC3_SLOT_OFFSET),
      .SEC_HMC_CFG_CTRL_SLOT_ROTATE_EN      (SEC_HMC_CFG_CTRL_SLOT_ROTATE_EN),
      .SEC_HMC_CFG_DBC0_SLOT_ROTATE_EN      (SEC_HMC_CFG_DBC0_SLOT_ROTATE_EN),
      .SEC_HMC_CFG_DBC1_SLOT_ROTATE_EN      (SEC_HMC_CFG_DBC1_SLOT_ROTATE_EN),
      .SEC_HMC_CFG_DBC2_SLOT_ROTATE_EN      (SEC_HMC_CFG_DBC2_SLOT_ROTATE_EN),
      .SEC_HMC_CFG_DBC3_SLOT_ROTATE_EN      (SEC_HMC_CFG_DBC3_SLOT_ROTATE_EN),
      .SEC_HMC_CFG_COL_CMD_SLOT             (SEC_HMC_CFG_COL_CMD_SLOT),
      .SEC_HMC_CFG_ROW_CMD_SLOT             (SEC_HMC_CFG_ROW_CMD_SLOT),
      .SEC_HMC_CFG_ROW_TO_COL_OFFSET        (SEC_HMC_CFG_ROW_TO_COL_OFFSET),
      .SEC_HMC_CFG_ROW_TO_ROW_OFFSET        (SEC_HMC_CFG_ROW_TO_ROW_OFFSET),
      .SEC_HMC_CFG_COL_TO_COL_OFFSET        (SEC_HMC_CFG_COL_TO_COL_OFFSET),
      .SEC_HMC_CFG_COL_TO_DIFF_COL_OFFSET   (SEC_HMC_CFG_COL_TO_DIFF_COL_OFFSET),
      .SEC_HMC_CFG_COL_TO_ROW_OFFSET        (SEC_HMC_CFG_COL_TO_ROW_OFFSET),
      .SEC_HMC_CFG_SIDEBAND_OFFSET          (SEC_HMC_CFG_SIDEBAND_OFFSET),
      .SEC_HMC_CFG_CS_TO_CHIP_MAPPING       (SEC_HMC_CFG_CS_TO_CHIP_MAPPING),
      .SEC_HMC_CFG_CTL_ODT_ENABLED          (SEC_HMC_CFG_CTL_ODT_ENABLED),
      .SEC_HMC_CFG_RD_ODT_ON                (SEC_HMC_CFG_RD_ODT_ON),
      .SEC_HMC_CFG_RD_ODT_PERIOD            (SEC_HMC_CFG_RD_ODT_PERIOD),
      .SEC_HMC_CFG_READ_ODT_CHIP            (SEC_HMC_CFG_READ_ODT_CHIP),
      .SEC_HMC_CFG_WR_ODT_ON                (SEC_HMC_CFG_WR_ODT_ON),
      .SEC_HMC_CFG_WR_ODT_PERIOD            (SEC_HMC_CFG_WR_ODT_PERIOD),
      .SEC_HMC_CFG_WRITE_ODT_CHIP           (SEC_HMC_CFG_WRITE_ODT_CHIP),
      .SEC_HMC_CFG_CMD_FIFO_RESERVE_EN      (SEC_HMC_CFG_CMD_FIFO_RESERVE_EN),
      .SEC_HMC_CFG_RB_RESERVED_ENTRY        (SEC_HMC_CFG_RB_RESERVED_ENTRY),
      .SEC_HMC_CFG_WB_RESERVED_ENTRY        (SEC_HMC_CFG_WB_RESERVED_ENTRY),
      .SEC_HMC_CFG_STARVE_LIMIT             (SEC_HMC_CFG_STARVE_LIMIT),
      .SEC_HMC_CFG_PHY_DELAY_MISMATCH       (SEC_HMC_CFG_PHY_DELAY_MISMATCH),
      .SEC_HMC_CFG_DQSTRK_EN                (SEC_HMC_CFG_DQSTRK_EN),
      .SEC_HMC_CFG_DQSTRK_TO_VALID          (SEC_HMC_CFG_DQSTRK_TO_VALID),
      .SEC_HMC_CFG_DQSTRK_TO_VALID_LAST     (SEC_HMC_CFG_DQSTRK_TO_VALID_LAST),
      .SEC_HMC_CFG_CTL_SHORT_DQSTRK_EN      (SEC_HMC_CFG_CTL_SHORT_DQSTRK_EN),
      .SEC_HMC_CFG_PERIOD_DQSTRK_CTRL_EN    (SEC_HMC_CFG_PERIOD_DQSTRK_CTRL_EN),
      .SEC_HMC_CFG_PERIOD_DQSTRK_INTERVAL   (SEC_HMC_CFG_PERIOD_DQSTRK_INTERVAL),
      .SEC_HMC_CFG_SHORT_DQSTRK_CTRL_EN     (SEC_HMC_CFG_SHORT_DQSTRK_CTRL_EN),
      .SEC_HMC_CFG_ENABLE_FAST_EXIT_PPD     (SEC_HMC_CFG_ENABLE_FAST_EXIT_PPD),
      .SEC_HMC_CFG_USER_RFSH_EN             (SEC_HMC_CFG_USER_RFSH_EN),
      .SEC_HMC_CFG_GEAR_DOWN_EN             (SEC_HMC_CFG_GEAR_DOWN_EN),
      .SEC_HMC_CFG_MEM_AUTO_PD_CYCLES       (SEC_HMC_CFG_MEM_AUTO_PD_CYCLES),
      .SEC_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC (SEC_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC),
      .SEC_HMC_MEMCLKGATE_SETTING           (SEC_HMC_MEMCLKGATE_SETTING),
      .SEC_HMC_CFG_TCL                      (SEC_HMC_CFG_TCL),
      .SEC_HMC_CFG_16_ACT_TO_ACT            (SEC_HMC_CFG_16_ACT_TO_ACT),
      .SEC_HMC_CFG_4_ACT_TO_ACT             (SEC_HMC_CFG_4_ACT_TO_ACT),
      .SEC_HMC_MEM_IF_AL                    (SEC_HMC_MEM_IF_AL),
      .SEC_HMC_MEM_IF_CS_PER_DIMM           (SEC_HMC_MEM_IF_CS_PER_DIMM),
      .SEC_HMC_MEM_IF_RD_PREAMBLE           (SEC_HMC_MEM_IF_RD_PREAMBLE),
      .SEC_HMC_MEM_IF_TCCD                  (SEC_HMC_MEM_IF_TCCD),
      .SEC_HMC_MEM_IF_TCCD_S                (SEC_HMC_MEM_IF_TCCD_S),
      .SEC_HMC_MEM_IF_TCKESR                (SEC_HMC_MEM_IF_TCKESR),
      .SEC_HMC_MEM_IF_TCKSRX                (SEC_HMC_MEM_IF_TCKSRX),
      .SEC_HMC_MEM_IF_TCL                   (SEC_HMC_MEM_IF_TCL),
      .SEC_HMC_MEM_IF_TCWL                  (SEC_HMC_MEM_IF_TCWL),
      .SEC_HMC_MEM_IF_TDQSCKMAX             (SEC_HMC_MEM_IF_TDQSCKMAX),
      .SEC_HMC_MEM_IF_TFAW                  (SEC_HMC_MEM_IF_TFAW),
      .SEC_HMC_MEM_IF_TMOD                  (SEC_HMC_MEM_IF_TMOD),
      .SEC_HMC_MEM_IF_TPL                   (SEC_HMC_MEM_IF_TPL),
      .SEC_HMC_MEM_IF_TRAS                  (SEC_HMC_MEM_IF_TRAS),
      .SEC_HMC_MEM_IF_TRC                   (SEC_HMC_MEM_IF_TRC),
      .SEC_HMC_MEM_IF_TRCD                  (SEC_HMC_MEM_IF_TRCD),
      .SEC_HMC_MEM_IF_TREFI                 (SEC_HMC_MEM_IF_TREFI),
      .SEC_HMC_MEM_IF_TRFC                  (SEC_HMC_MEM_IF_TRFC),
      .SEC_HMC_MEM_IF_TRP                   (SEC_HMC_MEM_IF_TRP),
      .SEC_HMC_MEM_IF_TRRD                  (SEC_HMC_MEM_IF_TRRD),
      .SEC_HMC_MEM_IF_TRRD_S                (SEC_HMC_MEM_IF_TRRD_S),
      .SEC_HMC_MEM_IF_TRTP                  (SEC_HMC_MEM_IF_TRTP),
      .SEC_HMC_MEM_IF_TWR                   (SEC_HMC_MEM_IF_TWR),
      .SEC_HMC_MEM_IF_TWR_CRC_DM            (SEC_HMC_MEM_IF_TWR_CRC_DM),
      .SEC_HMC_MEM_IF_TWTR                  (SEC_HMC_MEM_IF_TWTR),
      .SEC_HMC_MEM_IF_TWTR_L_CRC_DM         (SEC_HMC_MEM_IF_TWTR_L_CRC_DM),
      .SEC_HMC_MEM_IF_TWTR_S                (SEC_HMC_MEM_IF_TWTR_S),
      .SEC_HMC_MEM_IF_TWTR_S_CRC_DM         (SEC_HMC_MEM_IF_TWTR_S_CRC_DM),
      .SEC_HMC_MEM_IF_TXP                   (SEC_HMC_MEM_IF_TXP),
      .SEC_HMC_MEM_IF_TXPDLL                (SEC_HMC_MEM_IF_TXPDLL),
      .SEC_HMC_MEM_IF_TXSR                  (SEC_HMC_MEM_IF_TXSR),
      .SEC_HMC_MEM_IF_TZQCS                 (SEC_HMC_MEM_IF_TZQCS),
      .SEC_HMC_MEM_IF_TZQOPER               (SEC_HMC_MEM_IF_TZQOPER),
      .SEC_HMC_MEM_IF_WR_CRC                (SEC_HMC_MEM_IF_WR_CRC),
      .SEC_HMC_MEM_IF_WR_PREAMBLE           (SEC_HMC_MEM_IF_WR_PREAMBLE),
      .SEC_HMC_CFG_ACT_TO_ACT               (SEC_HMC_CFG_ACT_TO_ACT),
      .SEC_HMC_CFG_ACT_TO_ACT_DIFF_BANK     (SEC_HMC_CFG_ACT_TO_ACT_DIFF_BANK),
      .SEC_HMC_CFG_ACT_TO_ACT_DIFF_BG       (SEC_HMC_CFG_ACT_TO_ACT_DIFF_BG),
      .SEC_HMC_CFG_ACT_TO_PCH               (SEC_HMC_CFG_ACT_TO_PCH),
      .SEC_HMC_CFG_ACT_TO_RDWR              (SEC_HMC_CFG_ACT_TO_RDWR),
      .SEC_HMC_CFG_ARF_PERIOD               (SEC_HMC_CFG_ARF_PERIOD),
      .SEC_HMC_CFG_ARF_TO_VALID             (SEC_HMC_CFG_ARF_TO_VALID),
      .SEC_HMC_CFG_MMR_CMD_TO_VALID         (SEC_HMC_CFG_MMR_CMD_TO_VALID),
      .SEC_HMC_CFG_MPR_TO_VALID             (SEC_HMC_CFG_MPR_TO_VALID),
      .SEC_HMC_CFG_MPS_DQSTRK_DISABLE       (SEC_HMC_CFG_MPS_DQSTRK_DISABLE),
      .SEC_HMC_CFG_MPS_EXIT_CKE_TO_CS       (SEC_HMC_CFG_MPS_EXIT_CKE_TO_CS),
      .SEC_HMC_CFG_MPS_EXIT_CS_TO_CKE       (SEC_HMC_CFG_MPS_EXIT_CS_TO_CKE),
      .SEC_HMC_CFG_MPS_TO_VALID             (SEC_HMC_CFG_MPS_TO_VALID),
      .SEC_HMC_CFG_MPS_ZQCAL_DISABLE        (SEC_HMC_CFG_MPS_ZQCAL_DISABLE),
      .SEC_HMC_CFG_MRR_TO_VALID             (SEC_HMC_CFG_MRR_TO_VALID),
      .SEC_HMC_CFG_MRS_TO_VALID             (SEC_HMC_CFG_MRS_TO_VALID),
      .SEC_HMC_CFG_PCH_ALL_TO_VALID         (SEC_HMC_CFG_PCH_ALL_TO_VALID),
      .SEC_HMC_CFG_PCH_TO_VALID             (SEC_HMC_CFG_PCH_TO_VALID),
      .SEC_HMC_CFG_PDN_PERIOD               (SEC_HMC_CFG_PDN_PERIOD),
      .SEC_HMC_CFG_PDN_TO_VALID             (SEC_HMC_CFG_PDN_TO_VALID),
      .SEC_HMC_CFG_POWER_SAVING_EXIT_CYC    (SEC_HMC_CFG_POWER_SAVING_EXIT_CYC),
      .SEC_HMC_CFG_RD_AP_TO_VALID           (SEC_HMC_CFG_RD_AP_TO_VALID),
      .SEC_HMC_CFG_RD_TO_PCH                (SEC_HMC_CFG_RD_TO_PCH),
      .SEC_HMC_CFG_RD_TO_RD                 (SEC_HMC_CFG_RD_TO_RD),
      .SEC_HMC_CFG_RD_TO_RD_DIFF_BG         (SEC_HMC_CFG_RD_TO_RD_DIFF_BG),
      .SEC_HMC_CFG_RD_TO_RD_DIFF_CHIP       (SEC_HMC_CFG_RD_TO_RD_DIFF_CHIP),
      .SEC_HMC_CFG_RD_TO_WR                 (SEC_HMC_CFG_RD_TO_WR),
      .SEC_HMC_CFG_RD_TO_WR_DIFF_BG         (SEC_HMC_CFG_RD_TO_WR_DIFF_BG),
      .SEC_HMC_CFG_RD_TO_WR_DIFF_CHIP       (SEC_HMC_CFG_RD_TO_WR_DIFF_CHIP),
      .SEC_HMC_CFG_RFSH_WARN_THRESHOLD      (SEC_HMC_CFG_RFSH_WARN_THRESHOLD),
      .SEC_HMC_CFG_RLD3_MULTIBANK_REF_DELAY (SEC_HMC_CFG_RLD3_MULTIBANK_REF_DELAY),
      .SEC_HMC_CFG_RLD3_REFRESH_SEQ0        (SEC_HMC_CFG_RLD3_REFRESH_SEQ0),
      .SEC_HMC_CFG_RLD3_REFRESH_SEQ1        (SEC_HMC_CFG_RLD3_REFRESH_SEQ1),
      .SEC_HMC_CFG_RLD3_REFRESH_SEQ2        (SEC_HMC_CFG_RLD3_REFRESH_SEQ2),
      .SEC_HMC_CFG_RLD3_REFRESH_SEQ3        (SEC_HMC_CFG_RLD3_REFRESH_SEQ3),
      .SEC_HMC_CFG_SB_CG_DISABLE            (SEC_HMC_CFG_SB_CG_DISABLE),
      .SEC_HMC_CFG_SB_DDR4_MR3              (SEC_HMC_CFG_SB_DDR4_MR3),
      .SEC_HMC_CFG_SB_DDR4_MR4              (SEC_HMC_CFG_SB_DDR4_MR4),
      .SEC_HMC_CFG_SB_DDR4_MR5              (SEC_HMC_CFG_SB_DDR4_MR5),
      .SEC_HMC_CFG_DDR4_MPS_ADDRMIRROR      (SEC_HMC_CFG_DDR4_MPS_ADDRMIRROR),
      .SEC_HMC_CFG_SRF_AUTOEXIT_EN          (SEC_HMC_CFG_SRF_AUTOEXIT_EN),
      .SEC_HMC_CFG_SRF_ENTRY_EXIT_BLOCK     (SEC_HMC_CFG_SRF_ENTRY_EXIT_BLOCK),
      .SEC_HMC_CFG_SRF_TO_VALID             (SEC_HMC_CFG_SRF_TO_VALID),
      .SEC_HMC_CFG_SRF_TO_ZQ_CAL            (SEC_HMC_CFG_SRF_TO_ZQ_CAL),
      .SEC_HMC_CFG_SRF_ZQCAL_DISABLE        (SEC_HMC_CFG_SRF_ZQCAL_DISABLE),
      .SEC_HMC_TEMP_4_ACT_TO_ACT            (SEC_HMC_TEMP_4_ACT_TO_ACT),
      .SEC_HMC_TEMP_RD_TO_RD_DIFF_BG        (SEC_HMC_TEMP_RD_TO_RD_DIFF_BG),
      .SEC_HMC_TEMP_WR_TO_RD                (SEC_HMC_TEMP_WR_TO_RD),
      .SEC_HMC_TEMP_WR_TO_RD_DIFF_BG        (SEC_HMC_TEMP_WR_TO_RD_DIFF_BG),
      .SEC_HMC_TEMP_WR_TO_RD_DIFF_CHIP      (SEC_HMC_TEMP_WR_TO_RD_DIFF_CHIP),
      .SEC_HMC_TEMP_WR_TO_WR_DIFF_BG        (SEC_HMC_TEMP_WR_TO_WR_DIFF_BG),
      .SEC_HMC_CFG_WR_AP_TO_VALID           (SEC_HMC_CFG_WR_AP_TO_VALID),
      .SEC_HMC_CFG_WR_TO_PCH                (SEC_HMC_CFG_WR_TO_PCH),
      .SEC_HMC_CFG_WR_TO_RD                 (SEC_HMC_CFG_WR_TO_RD),
      .SEC_HMC_CFG_WR_TO_RD_DIFF_BG         (SEC_HMC_CFG_WR_TO_RD_DIFF_BG),
      .SEC_HMC_CFG_WR_TO_RD_DIFF_CHIP       (SEC_HMC_CFG_WR_TO_RD_DIFF_CHIP),
      .SEC_HMC_CFG_WR_TO_WR                 (SEC_HMC_CFG_WR_TO_WR),
      .SEC_HMC_CFG_WR_TO_WR_DIFF_BG         (SEC_HMC_CFG_WR_TO_WR_DIFF_BG),
      .SEC_HMC_CFG_WR_TO_WR_DIFF_CHIP       (SEC_HMC_CFG_WR_TO_WR_DIFF_CHIP),
      .SEC_HMC_CFG_ZQCL_TO_VALID            (SEC_HMC_CFG_ZQCL_TO_VALID),
      .SEC_HMC_CFG_ZQCS_TO_VALID            (SEC_HMC_CFG_ZQCS_TO_VALID),
      .SEC_HMC_CHIP_ID                      (SEC_HMC_CHIP_ID),
      .SEC_HMC_CID_ADDR_WIDTH               (SEC_HMC_CID_ADDR_WIDTH),
      .SEC_HMC_3DS_EN                       (SEC_HMC_3DS_EN),
      .SEC_HMC_3DS_LR_NUM0                  (SEC_HMC_3DS_LR_NUM0),
      .SEC_HMC_3DS_LR_NUM1                  (SEC_HMC_3DS_LR_NUM1),
      .SEC_HMC_3DS_LR_NUM2                  (SEC_HMC_3DS_LR_NUM2),
      .SEC_HMC_3DS_LR_NUM3                  (SEC_HMC_3DS_LR_NUM3),
      .SEC_HMC_3DS_PR_STAG_ENABLE           (SEC_HMC_3DS_PR_STAG_ENABLE),
      .SEC_HMC_3DS_REF2REF_DLR              (SEC_HMC_3DS_REF2REF_DLR),
      .SEC_HMC_3DSREF_ACK_ON_DONE           (SEC_HMC_3DSREF_ACK_ON_DONE),
      
      .PINS_PER_LANE                        (PINS_PER_LANE),
      .LANES_PER_TILE                       (LANES_PER_TILE),
      .PINS_IN_RTL_TILES                    (PINS_IN_RTL_TILES),
      .LANES_IN_RTL_TILES                   (LANES_IN_RTL_TILES),
      .NUM_OF_RTL_TILES                     (NUM_OF_RTL_TILES),
      .AC_PIN_MAP_SCHEME                    (AC_PIN_MAP_SCHEME),
      .PRI_AC_TILE_INDEX                    (PRI_AC_TILE_INDEX),
      .SEC_AC_TILE_INDEX                    (SEC_AC_TILE_INDEX),
      .PRI_HMC_DBC_SHADOW_LANE_INDEX        (PRI_HMC_DBC_SHADOW_LANE_INDEX),
      .LANES_USAGE                          (LANES_USAGE),
      .PINS_USAGE                           (PINS_USAGE),
      .PINS_RATE                            (PINS_RATE),
      .DB_PINS_PROC_MODE                    (DB_PINS_PROC_MODE),
      .PINS_DATA_IN_MODE                    (PINS_DATA_IN_MODE),
      .PINS_OCT_MODE                        (PINS_OCT_MODE),
      .PINS_DCC_SPLIT                       (PINS_DCC_SPLIT),
      .CENTER_TIDS                          (CENTER_TIDS),
      .HMC_TIDS                             (HMC_TIDS),
      .LANE_TIDS                            (LANE_TIDS),
      .DBC_PIPE_LATS                        (DBC_PIPE_LATS),
      .DB_PTR_PIPELINE_DEPTHS               (DB_PTR_PIPELINE_DEPTHS),
      .DB_SEQ_RD_EN_FULL_PIPELINES          (DB_SEQ_RD_EN_FULL_PIPELINES),
      .PREAMBLE_MODE                        (PREAMBLE_MODE),
      .DBI_WR_ENABLE                        (DBI_WR_ENABLE),
      .DBI_RD_ENABLE                        (DBI_RD_ENABLE),
      .SWAP_DQS_A_B                         (SWAP_DQS_A_B),
      .DQS_PACK_MODE                        (DQS_PACK_MODE),
      .OCT_SIZE                             (OCT_SIZE),
      .DQSA_LGC_MODE                        (DQSA_LGC_MODE),
      .DQSB_LGC_MODE                        (DQSB_LGC_MODE),
      .DBC_WB_RESERVED_ENTRY                (DBC_WB_RESERVED_ENTRY),
      .DLL_MODE                             (DLL_MODE),
      .DLL_CODEWORD                         (DLL_CODEWORD),
      .PORT_MEM_DQS_WIDTH                   (PORT_MEM_DQS_WIDTH),
      .PORT_MEM_DQ_WIDTH                    (PORT_MEM_DQ_WIDTH),
      .PORT_DFT_ND_PA_DPRIO_REG_ADDR_WIDTH  (PORT_DFT_ND_PA_DPRIO_REG_ADDR_WIDTH),
      .PORT_DFT_ND_PA_DPRIO_WRITEDATA_WIDTH (PORT_DFT_ND_PA_DPRIO_WRITEDATA_WIDTH),
      .PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH  (PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH),
      
      .DIAG_USE_ABSTRACT_PHY                (DIAG_USE_ABSTRACT_PHY),
      
      .PORT_MEM_DQS_PINLOC                  (PORT_MEM_DQS_PINLOC),
      .PORT_MEM_QK_PINLOC                   (PORT_MEM_QK_PINLOC),
      .PORT_MEM_QKA_PINLOC                  (PORT_MEM_QKA_PINLOC),
      .PORT_MEM_QKB_PINLOC                  (PORT_MEM_QKB_PINLOC),
      .PORT_MEM_CQ_PINLOC                   (PORT_MEM_CQ_PINLOC)
   ) io_tiles_inst (
      .core2seq_reset_req                      (core2seq_reset_req_iotile_in),
      .pll_locked                              (pll_locked_iotile_in),
      .pll_dll_clk                             (pll_dll_clk_iotile_in),
      .phy_clk_phs                             (phy_clk_phs_iotile_in),
      .phy_clk                                 (phy_clk_iotile_in),
      .phy_fb_clk_to_tile                      (phy_fb_clk_to_tile_iotile_in),
      .core_clks_fb_to_cpa_pri                 (core_clks_fb_to_cpa_pri_iotile_in),
      .core_clks_fb_to_cpa_sec                 (core_clks_fb_to_cpa_sec_iotile_in),
      .core2ctl_avl_0                          (core2ctl_avl_0_iotile_in),
      .core2ctl_avl_1                          (core2ctl_avl_1_iotile_in),
      .core2ctl_avl_rd_data_ready_0            (core2ctl_avl_rd_data_ready_0_iotile_in),
      .core2ctl_avl_rd_data_ready_1            (core2ctl_avl_rd_data_ready_1_iotile_in),
      .core2l_wr_data_vld_ast_0                (core2l_wr_data_vld_ast_0_iotile_in),
      .core2l_wr_data_vld_ast_1                (core2l_wr_data_vld_ast_1_iotile_in),
      .core2l_rd_data_rdy_ast_0                (core2l_rd_data_rdy_ast_0_iotile_in),
      .core2l_rd_data_rdy_ast_1                (core2l_rd_data_rdy_ast_1_iotile_in),
      .core2l_wr_ecc_info_0                    (core2l_wr_ecc_info_0_iotile_in),
      .core2l_wr_ecc_info_1                    (core2l_wr_ecc_info_1_iotile_in),
      .core2l_data                             (core2l_data_iotile_in),
      .core2l_oe                               (core2l_oe_iotile_in),
      .core2l_rdata_en_full                    (core2l_rdata_en_full_iotile_in),
      .core2l_mrnk_read                        (core2l_mrnk_read_iotile_in),
      .core2l_mrnk_write                       (core2l_mrnk_write_iotile_in),
      .c2t_afi                                 (c2t_afi_iotile_in),
      .core2ctl_sideband_0                     (core2ctl_sideband_0_iotile_in),
      .core2ctl_sideband_1                     (core2ctl_sideband_1_iotile_in),
      .core2ctl_mmr_0                          (core2ctl_mmr_0_iotile_in),
      .core2ctl_mmr_1                          (core2ctl_mmr_1_iotile_in),
      .b2l_data                                (b2l_data_iotile_in),
      .b2t_dqs                                 (b2t_dqs_iotile_in),
      .b2t_dqsb                                (b2t_dqsb_iotile_in),
      .cal_bus_clk                             (cal_bus_clk_iotile_in),
      .cal_bus_avl_read                        (cal_bus_avl_read_iotile_in),
      .cal_bus_avl_write                       (cal_bus_avl_write_iotile_in),
      .cal_bus_avl_address                     (cal_bus_avl_address_iotile_in),
      .cal_bus_avl_write_data                  (cal_bus_avl_write_data_iotile_in),
      .pa_dprio_clk                            (pa_dprio_clk_iotile_in),
      .pa_dprio_read                           (pa_dprio_read_iotile_in),
      .pa_dprio_reg_addr                       (pa_dprio_reg_addr_iotile_in),
      .pa_dprio_rst_n                          (pa_dprio_rst_n_iotile_in),
      .pa_dprio_write                          (pa_dprio_write_iotile_in),
      .pa_dprio_writedata                      (pa_dprio_writedata_iotile_in),
      .*
   );
   
   generate 
     if ( DIAG_USE_ABSTRACT_PHY==1 ) begin : abphy_tiles
       altera_emif_arch_nd_io_tiles_abphy # (
        .DIAG_SYNTH_FOR_SIM                   (DIAG_SYNTH_FOR_SIM),
        .DIAG_CPA_OUT_1_EN                    (DIAG_CPA_OUT_1_EN),
        .DIAG_FAST_SIM                        (DIAG_FAST_SIM),
        .MEM_ABPHY_VERBOSE                    (DIAG_SIM_VERBOSE_LEVEL >= 2),
        .DIAG_SEQ_RESET_AUTO_RELEASE          (DIAG_SEQ_RESET_AUTO_RELEASE),
        .DIAG_DB_RESET_AUTO_RELEASE           (DIAG_DB_RESET_AUTO_RELEASE),
        .DIAG_SIM_MEMORY_PRELOAD              (DIAG_SIM_MEMORY_PRELOAD),
        .DIAG_SIM_MEMORY_PRELOAD_PRI_ABPHY_FILE (DIAG_SIM_MEMORY_PRELOAD_PRI_ABPHY_FILE),
        .DIAG_SIM_MEMORY_PRELOAD_SEC_ABPHY_FILE (DIAG_SIM_MEMORY_PRELOAD_SEC_ABPHY_FILE),
        .IS_HPS                               (IS_HPS),
        .SILICON_REV                          (SILICON_REV),
        .PROTOCOL_ENUM                        (PROTOCOL_ENUM),
        .PHY_PING_PONG_EN                     (PHY_PING_PONG_EN),
        .DQS_BUS_MODE_ENUM                    (DQS_BUS_MODE_ENUM),
        .USER_CLK_RATIO                       (USER_CLK_RATIO),
        .PHY_HMC_CLK_RATIO                    (PHY_HMC_CLK_RATIO),
        .C2P_P2C_CLK_RATIO                    (C2P_P2C_CLK_RATIO),
        .PLL_VCO_FREQ_MHZ_INT                 (PLL_VCO_FREQ_MHZ_INT),
        .PLL_VCO_TO_MEM_CLK_FREQ_RATIO        (PLL_VCO_TO_MEM_CLK_FREQ_RATIO),
        .MEM_BURST_LENGTH                     (MEM_BURST_LENGTH),
        .MEM_DATA_MASK_EN                     (MEM_DATA_MASK_EN),
        .NUM_OF_HMC_PORTS                     (NUM_OF_HMC_PORTS),
        .HMC_AVL_PROTOCOL_ENUM                (HMC_AVL_PROTOCOL_ENUM),
        .HMC_CTRL_DIMM_TYPE                   (HMC_CTRL_DIMM_TYPE),
        
        .PRI_HMC_CFG_PING_PONG_MODE           (PRI_HMC_CFG_PING_PONG_MODE),
        .PRI_HMC_CFG_CS_ADDR_WIDTH            (PRI_HMC_CFG_CS_ADDR_WIDTH),
        .PRI_HMC_CFG_COL_ADDR_WIDTH           (PRI_HMC_CFG_COL_ADDR_WIDTH),
        .PRI_HMC_CFG_ROW_ADDR_WIDTH           (PRI_HMC_CFG_ROW_ADDR_WIDTH),
        .PRI_HMC_CFG_BANK_ADDR_WIDTH          (PRI_HMC_CFG_BANK_ADDR_WIDTH),
        .PRI_HMC_CFG_BANK_GROUP_ADDR_WIDTH    (PRI_HMC_CFG_BANK_GROUP_ADDR_WIDTH),
        .PRI_HMC_CFG_ADDR_ORDER               (PRI_HMC_CFG_ADDR_ORDER),
        .PRI_HMC_CFG_ARBITER_TYPE             (PRI_HMC_CFG_ARBITER_TYPE),
        .PRI_HMC_CFG_OPEN_PAGE_EN             (PRI_HMC_CFG_OPEN_PAGE_EN),
        .PRI_HMC_CFG_CTRL_ENABLE_RC           (PRI_HMC_CFG_CTRL_ENABLE_RC),
        .PRI_HMC_CFG_DBC0_ENABLE_RC           (PRI_HMC_CFG_DBC0_ENABLE_RC),
        .PRI_HMC_CFG_DBC1_ENABLE_RC           (PRI_HMC_CFG_DBC1_ENABLE_RC),
        .PRI_HMC_CFG_DBC2_ENABLE_RC           (PRI_HMC_CFG_DBC2_ENABLE_RC),
        .PRI_HMC_CFG_DBC3_ENABLE_RC           (PRI_HMC_CFG_DBC3_ENABLE_RC),
        .PRI_HMC_CFG_CTRL_ENABLE_ECC          (PRI_HMC_CFG_CTRL_ENABLE_ECC),
        .PRI_HMC_CFG_DBC0_ENABLE_ECC          (PRI_HMC_CFG_DBC0_ENABLE_ECC),
        .PRI_HMC_CFG_DBC1_ENABLE_ECC          (PRI_HMC_CFG_DBC1_ENABLE_ECC),
        .PRI_HMC_CFG_DBC2_ENABLE_ECC          (PRI_HMC_CFG_DBC2_ENABLE_ECC),
        .PRI_HMC_CFG_DBC3_ENABLE_ECC          (PRI_HMC_CFG_DBC3_ENABLE_ECC),
        .PRI_HMC_CFG_REORDER_DATA             (PRI_HMC_CFG_REORDER_DATA),
        .PRI_HMC_CFG_REORDER_READ             (PRI_HMC_CFG_REORDER_READ),
        .PRI_HMC_CFG_CTRL_REORDER_RDATA       (PRI_HMC_CFG_CTRL_REORDER_RDATA),
        .PRI_HMC_CFG_DBC0_REORDER_RDATA       (PRI_HMC_CFG_DBC0_REORDER_RDATA),
        .PRI_HMC_CFG_DBC1_REORDER_RDATA       (PRI_HMC_CFG_DBC1_REORDER_RDATA),
        .PRI_HMC_CFG_DBC2_REORDER_RDATA       (PRI_HMC_CFG_DBC2_REORDER_RDATA),
        .PRI_HMC_CFG_DBC3_REORDER_RDATA       (PRI_HMC_CFG_DBC3_REORDER_RDATA),
        .PRI_HMC_CFG_CTRL_SLOT_OFFSET         (PRI_HMC_CFG_CTRL_SLOT_OFFSET),
        .PRI_HMC_CFG_DBC0_SLOT_OFFSET         (PRI_HMC_CFG_DBC0_SLOT_OFFSET),
        .PRI_HMC_CFG_DBC1_SLOT_OFFSET         (PRI_HMC_CFG_DBC1_SLOT_OFFSET),
        .PRI_HMC_CFG_DBC2_SLOT_OFFSET         (PRI_HMC_CFG_DBC2_SLOT_OFFSET),
        .PRI_HMC_CFG_DBC3_SLOT_OFFSET         (PRI_HMC_CFG_DBC3_SLOT_OFFSET),
        .PRI_HMC_CFG_CTRL_SLOT_ROTATE_EN      (PRI_HMC_CFG_CTRL_SLOT_ROTATE_EN),
        .PRI_HMC_CFG_DBC0_SLOT_ROTATE_EN      (PRI_HMC_CFG_DBC0_SLOT_ROTATE_EN),
        .PRI_HMC_CFG_DBC1_SLOT_ROTATE_EN      (PRI_HMC_CFG_DBC1_SLOT_ROTATE_EN),
        .PRI_HMC_CFG_DBC2_SLOT_ROTATE_EN      (PRI_HMC_CFG_DBC2_SLOT_ROTATE_EN),
        .PRI_HMC_CFG_DBC3_SLOT_ROTATE_EN      (PRI_HMC_CFG_DBC3_SLOT_ROTATE_EN),
        .PRI_HMC_CFG_COL_CMD_SLOT             (PRI_HMC_CFG_COL_CMD_SLOT),
        .PRI_HMC_CFG_ROW_CMD_SLOT             (PRI_HMC_CFG_ROW_CMD_SLOT),
        .PRI_HMC_CFG_ROW_TO_COL_OFFSET        (PRI_HMC_CFG_ROW_TO_COL_OFFSET),
        .PRI_HMC_CFG_ROW_TO_ROW_OFFSET        (PRI_HMC_CFG_ROW_TO_ROW_OFFSET),
        .PRI_HMC_CFG_COL_TO_COL_OFFSET        (PRI_HMC_CFG_COL_TO_COL_OFFSET),
        .PRI_HMC_CFG_COL_TO_DIFF_COL_OFFSET   (PRI_HMC_CFG_COL_TO_DIFF_COL_OFFSET),
        .PRI_HMC_CFG_COL_TO_ROW_OFFSET        (PRI_HMC_CFG_COL_TO_ROW_OFFSET),
        .PRI_HMC_CFG_SIDEBAND_OFFSET          (PRI_HMC_CFG_SIDEBAND_OFFSET),
        .PRI_HMC_CFG_CS_TO_CHIP_MAPPING       (PRI_HMC_CFG_CS_TO_CHIP_MAPPING),
        .PRI_HMC_CFG_CTL_ODT_ENABLED          (PRI_HMC_CFG_CTL_ODT_ENABLED),
        .PRI_HMC_CFG_RD_ODT_ON                (PRI_HMC_CFG_RD_ODT_ON),
        .PRI_HMC_CFG_RD_ODT_PERIOD            (PRI_HMC_CFG_RD_ODT_PERIOD),
        .PRI_HMC_CFG_READ_ODT_CHIP            (PRI_HMC_CFG_READ_ODT_CHIP),
        .PRI_HMC_CFG_WR_ODT_ON                (PRI_HMC_CFG_WR_ODT_ON),
        .PRI_HMC_CFG_WR_ODT_PERIOD            (PRI_HMC_CFG_WR_ODT_PERIOD),
        .PRI_HMC_CFG_WRITE_ODT_CHIP           (PRI_HMC_CFG_WRITE_ODT_CHIP),
        .PRI_HMC_CFG_CMD_FIFO_RESERVE_EN      (PRI_HMC_CFG_CMD_FIFO_RESERVE_EN),
        .PRI_HMC_CFG_RB_RESERVED_ENTRY        (PRI_HMC_CFG_RB_RESERVED_ENTRY),
        .PRI_HMC_CFG_WB_RESERVED_ENTRY        (PRI_HMC_CFG_WB_RESERVED_ENTRY),
        .PRI_HMC_CFG_STARVE_LIMIT             (PRI_HMC_CFG_STARVE_LIMIT),
        .PRI_HMC_CFG_PHY_DELAY_MISMATCH       (PRI_HMC_CFG_PHY_DELAY_MISMATCH),
        .PRI_HMC_CFG_DQSTRK_EN                (PRI_HMC_CFG_DQSTRK_EN),
        .PRI_HMC_CFG_DQSTRK_TO_VALID          (PRI_HMC_CFG_DQSTRK_TO_VALID),
        .PRI_HMC_CFG_DQSTRK_TO_VALID_LAST     (PRI_HMC_CFG_DQSTRK_TO_VALID_LAST),
        .PRI_HMC_CFG_CTL_SHORT_DQSTRK_EN      (PRI_HMC_CFG_CTL_SHORT_DQSTRK_EN),
        .PRI_HMC_CFG_PERIOD_DQSTRK_CTRL_EN    (PRI_HMC_CFG_PERIOD_DQSTRK_CTRL_EN),
        .PRI_HMC_CFG_PERIOD_DQSTRK_INTERVAL   (PRI_HMC_CFG_PERIOD_DQSTRK_INTERVAL),
        .PRI_HMC_CFG_SHORT_DQSTRK_CTRL_EN     (PRI_HMC_CFG_SHORT_DQSTRK_CTRL_EN),
        .PRI_HMC_CFG_ENABLE_FAST_EXIT_PPD     (PRI_HMC_CFG_ENABLE_FAST_EXIT_PPD),
        .PRI_HMC_CFG_USER_RFSH_EN             (PRI_HMC_CFG_USER_RFSH_EN),
        .PRI_HMC_CFG_GEAR_DOWN_EN             (PRI_HMC_CFG_GEAR_DOWN_EN),
        .PRI_HMC_CFG_MEM_AUTO_PD_CYCLES       (PRI_HMC_CFG_MEM_AUTO_PD_CYCLES),
        .PRI_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC (PRI_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC),
        .PRI_HMC_MEMCLKGATE_SETTING           (PRI_HMC_MEMCLKGATE_SETTING),
        .PRI_HMC_CFG_TCL                      (PRI_HMC_CFG_TCL),
        .PRI_HMC_CFG_16_ACT_TO_ACT            (PRI_HMC_CFG_16_ACT_TO_ACT),
        .PRI_HMC_CFG_4_ACT_TO_ACT             (PRI_HMC_CFG_4_ACT_TO_ACT),
        .PRI_HMC_MEM_IF_AL                    (PRI_HMC_MEM_IF_AL),
        .PRI_HMC_MEM_IF_CS_PER_DIMM           (PRI_HMC_MEM_IF_CS_PER_DIMM),
        .PRI_HMC_MEM_IF_RD_PREAMBLE           (PRI_HMC_MEM_IF_RD_PREAMBLE),
        .PRI_HMC_MEM_IF_TCCD                  (PRI_HMC_MEM_IF_TCCD),
        .PRI_HMC_MEM_IF_TCCD_S                (PRI_HMC_MEM_IF_TCCD_S),
        .PRI_HMC_MEM_IF_TCKESR                (PRI_HMC_MEM_IF_TCKESR),
        .PRI_HMC_MEM_IF_TCKSRX                (PRI_HMC_MEM_IF_TCKSRX),
        .PRI_HMC_MEM_IF_TCL                   (PRI_HMC_MEM_IF_TCL),
        .PRI_HMC_MEM_IF_TCWL                  (PRI_HMC_MEM_IF_TCWL),
        .PRI_HMC_MEM_IF_TDQSCKMAX             (PRI_HMC_MEM_IF_TDQSCKMAX),
        .PRI_HMC_MEM_IF_TFAW                  (PRI_HMC_MEM_IF_TFAW),
        .PRI_HMC_MEM_IF_TMOD                  (PRI_HMC_MEM_IF_TMOD),
        .PRI_HMC_MEM_IF_TPL                   (PRI_HMC_MEM_IF_TPL),
        .PRI_HMC_MEM_IF_TRAS                  (PRI_HMC_MEM_IF_TRAS),
        .PRI_HMC_MEM_IF_TRC                   (PRI_HMC_MEM_IF_TRC),
        .PRI_HMC_MEM_IF_TRCD                  (PRI_HMC_MEM_IF_TRCD),
        .PRI_HMC_MEM_IF_TREFI                 (PRI_HMC_MEM_IF_TREFI),
        .PRI_HMC_MEM_IF_TRFC                  (PRI_HMC_MEM_IF_TRFC),
        .PRI_HMC_MEM_IF_TRP                   (PRI_HMC_MEM_IF_TRP),
        .PRI_HMC_MEM_IF_TRRD                  (PRI_HMC_MEM_IF_TRRD),
        .PRI_HMC_MEM_IF_TRRD_S                (PRI_HMC_MEM_IF_TRRD_S),
        .PRI_HMC_MEM_IF_TRTP                  (PRI_HMC_MEM_IF_TRTP),
        .PRI_HMC_MEM_IF_TWR                   (PRI_HMC_MEM_IF_TWR),
        .PRI_HMC_MEM_IF_TWR_CRC_DM            (PRI_HMC_MEM_IF_TWR_CRC_DM),
        .PRI_HMC_MEM_IF_TWTR                  (PRI_HMC_MEM_IF_TWTR),
        .PRI_HMC_MEM_IF_TWTR_L_CRC_DM         (PRI_HMC_MEM_IF_TWTR_L_CRC_DM),
        .PRI_HMC_MEM_IF_TWTR_S                (PRI_HMC_MEM_IF_TWTR_S),
        .PRI_HMC_MEM_IF_TWTR_S_CRC_DM         (PRI_HMC_MEM_IF_TWTR_S_CRC_DM),
        .PRI_HMC_MEM_IF_TXP                   (PRI_HMC_MEM_IF_TXP),
        .PRI_HMC_MEM_IF_TXPDLL                (PRI_HMC_MEM_IF_TXPDLL),
        .PRI_HMC_MEM_IF_TXSR                  (PRI_HMC_MEM_IF_TXSR),
        .PRI_HMC_MEM_IF_TZQCS                 (PRI_HMC_MEM_IF_TZQCS),
        .PRI_HMC_MEM_IF_TZQOPER               (PRI_HMC_MEM_IF_TZQOPER),
        .PRI_HMC_MEM_IF_WR_CRC                (PRI_HMC_MEM_IF_WR_CRC),
        .PRI_HMC_MEM_IF_WR_PREAMBLE           (PRI_HMC_MEM_IF_WR_PREAMBLE),
        .PRI_HMC_CFG_ACT_TO_ACT               (PRI_HMC_CFG_ACT_TO_ACT),
        .PRI_HMC_CFG_ACT_TO_ACT_DIFF_BANK     (PRI_HMC_CFG_ACT_TO_ACT_DIFF_BANK),
        .PRI_HMC_CFG_ACT_TO_ACT_DIFF_BG       (PRI_HMC_CFG_ACT_TO_ACT_DIFF_BG),
        .PRI_HMC_CFG_ACT_TO_PCH               (PRI_HMC_CFG_ACT_TO_PCH),
        .PRI_HMC_CFG_ACT_TO_RDWR              (PRI_HMC_CFG_ACT_TO_RDWR),
        .PRI_HMC_CFG_ARF_PERIOD               (PRI_HMC_CFG_ARF_PERIOD),
        .PRI_HMC_CFG_ARF_TO_VALID             (PRI_HMC_CFG_ARF_TO_VALID),
        .PRI_HMC_CFG_MMR_CMD_TO_VALID         (PRI_HMC_CFG_MMR_CMD_TO_VALID),
        .PRI_HMC_CFG_MPR_TO_VALID             (PRI_HMC_CFG_MPR_TO_VALID),
        .PRI_HMC_CFG_MPS_DQSTRK_DISABLE       (PRI_HMC_CFG_MPS_DQSTRK_DISABLE),
        .PRI_HMC_CFG_MPS_EXIT_CKE_TO_CS       (PRI_HMC_CFG_MPS_EXIT_CKE_TO_CS),
        .PRI_HMC_CFG_MPS_EXIT_CS_TO_CKE       (PRI_HMC_CFG_MPS_EXIT_CS_TO_CKE),
        .PRI_HMC_CFG_MPS_TO_VALID             (PRI_HMC_CFG_MPS_TO_VALID),
        .PRI_HMC_CFG_MPS_ZQCAL_DISABLE        (PRI_HMC_CFG_MPS_ZQCAL_DISABLE),
        .PRI_HMC_CFG_MRR_TO_VALID             (PRI_HMC_CFG_MRR_TO_VALID),
        .PRI_HMC_CFG_MRS_TO_VALID             (PRI_HMC_CFG_MRS_TO_VALID),
        .PRI_HMC_CFG_PCH_ALL_TO_VALID         (PRI_HMC_CFG_PCH_ALL_TO_VALID),
        .PRI_HMC_CFG_PCH_TO_VALID             (PRI_HMC_CFG_PCH_TO_VALID),
        .PRI_HMC_CFG_PDN_PERIOD               (PRI_HMC_CFG_PDN_PERIOD),
        .PRI_HMC_CFG_PDN_TO_VALID             (PRI_HMC_CFG_PDN_TO_VALID),
        .PRI_HMC_CFG_POWER_SAVING_EXIT_CYC    (PRI_HMC_CFG_POWER_SAVING_EXIT_CYC),
        .PRI_HMC_CFG_RD_AP_TO_VALID           (PRI_HMC_CFG_RD_AP_TO_VALID),
        .PRI_HMC_CFG_RD_TO_PCH                (PRI_HMC_CFG_RD_TO_PCH),
        .PRI_HMC_CFG_RD_TO_RD                 (PRI_HMC_CFG_RD_TO_RD),
        .PRI_HMC_CFG_RD_TO_RD_DIFF_BG         (PRI_HMC_CFG_RD_TO_RD_DIFF_BG),
        .PRI_HMC_CFG_RD_TO_RD_DIFF_CHIP       (PRI_HMC_CFG_RD_TO_RD_DIFF_CHIP),
        .PRI_HMC_CFG_RD_TO_WR                 (PRI_HMC_CFG_RD_TO_WR),
        .PRI_HMC_CFG_RD_TO_WR_DIFF_BG         (PRI_HMC_CFG_RD_TO_WR_DIFF_BG),
        .PRI_HMC_CFG_RD_TO_WR_DIFF_CHIP       (PRI_HMC_CFG_RD_TO_WR_DIFF_CHIP),
        .PRI_HMC_CFG_RFSH_WARN_THRESHOLD      (PRI_HMC_CFG_RFSH_WARN_THRESHOLD),
        .PRI_HMC_CFG_RLD3_MULTIBANK_REF_DELAY (PRI_HMC_CFG_RLD3_MULTIBANK_REF_DELAY),
        .PRI_HMC_CFG_RLD3_REFRESH_SEQ0        (PRI_HMC_CFG_RLD3_REFRESH_SEQ0),
        .PRI_HMC_CFG_RLD3_REFRESH_SEQ1        (PRI_HMC_CFG_RLD3_REFRESH_SEQ1),
        .PRI_HMC_CFG_RLD3_REFRESH_SEQ2        (PRI_HMC_CFG_RLD3_REFRESH_SEQ2),
        .PRI_HMC_CFG_RLD3_REFRESH_SEQ3        (PRI_HMC_CFG_RLD3_REFRESH_SEQ3),
        .PRI_HMC_CFG_SB_CG_DISABLE            (PRI_HMC_CFG_SB_CG_DISABLE),
        .PRI_HMC_CFG_SB_DDR4_MR3              (PRI_HMC_CFG_SB_DDR4_MR3),
        .PRI_HMC_CFG_SB_DDR4_MR4              (PRI_HMC_CFG_SB_DDR4_MR4),
        .PRI_HMC_CFG_SB_DDR4_MR5              (PRI_HMC_CFG_SB_DDR4_MR5),
        .PRI_HMC_CFG_DDR4_MPS_ADDRMIRROR      (PRI_HMC_CFG_DDR4_MPS_ADDRMIRROR),
        .PRI_HMC_CFG_SRF_AUTOEXIT_EN          (PRI_HMC_CFG_SRF_AUTOEXIT_EN),
        .PRI_HMC_CFG_SRF_ENTRY_EXIT_BLOCK     (PRI_HMC_CFG_SRF_ENTRY_EXIT_BLOCK),
        .PRI_HMC_CFG_SRF_TO_VALID             (PRI_HMC_CFG_SRF_TO_VALID),
        .PRI_HMC_CFG_SRF_TO_ZQ_CAL            (PRI_HMC_CFG_SRF_TO_ZQ_CAL),
        .PRI_HMC_CFG_SRF_ZQCAL_DISABLE        (PRI_HMC_CFG_SRF_ZQCAL_DISABLE),
        .PRI_HMC_TEMP_4_ACT_TO_ACT            (PRI_HMC_TEMP_4_ACT_TO_ACT),
        .PRI_HMC_TEMP_RD_TO_RD_DIFF_BG        (PRI_HMC_TEMP_RD_TO_RD_DIFF_BG),
        .PRI_HMC_TEMP_WR_TO_RD                (PRI_HMC_TEMP_WR_TO_RD),
        .PRI_HMC_TEMP_WR_TO_RD_DIFF_BG        (PRI_HMC_TEMP_WR_TO_RD_DIFF_BG),
        .PRI_HMC_TEMP_WR_TO_RD_DIFF_CHIP      (PRI_HMC_TEMP_WR_TO_RD_DIFF_CHIP),
        .PRI_HMC_TEMP_WR_TO_WR_DIFF_BG        (PRI_HMC_TEMP_WR_TO_WR_DIFF_BG),
        .PRI_HMC_CFG_WR_AP_TO_VALID           (PRI_HMC_CFG_WR_AP_TO_VALID),
        .PRI_HMC_CFG_WR_TO_PCH                (PRI_HMC_CFG_WR_TO_PCH),
        .PRI_HMC_CFG_WR_TO_RD                 (PRI_HMC_CFG_WR_TO_RD),
        .PRI_HMC_CFG_WR_TO_RD_DIFF_BG         (PRI_HMC_CFG_WR_TO_RD_DIFF_BG),
        .PRI_HMC_CFG_WR_TO_RD_DIFF_CHIP       (PRI_HMC_CFG_WR_TO_RD_DIFF_CHIP),
        .PRI_HMC_CFG_WR_TO_WR                 (PRI_HMC_CFG_WR_TO_WR),
        .PRI_HMC_CFG_WR_TO_WR_DIFF_BG         (PRI_HMC_CFG_WR_TO_WR_DIFF_BG),
        .PRI_HMC_CFG_WR_TO_WR_DIFF_CHIP       (PRI_HMC_CFG_WR_TO_WR_DIFF_CHIP),
        .PRI_HMC_CFG_ZQCL_TO_VALID            (PRI_HMC_CFG_ZQCL_TO_VALID),
        .PRI_HMC_CFG_ZQCS_TO_VALID            (PRI_HMC_CFG_ZQCS_TO_VALID),
        .PRI_HMC_CHIP_ID                      (PRI_HMC_CHIP_ID),
        .PRI_HMC_CID_ADDR_WIDTH               (PRI_HMC_CID_ADDR_WIDTH),
        .PRI_HMC_3DS_EN                       (PRI_HMC_3DS_EN),
        .PRI_HMC_3DS_LR_NUM0                  (PRI_HMC_3DS_LR_NUM0),
        .PRI_HMC_3DS_LR_NUM1                  (PRI_HMC_3DS_LR_NUM1),
        .PRI_HMC_3DS_LR_NUM2                  (PRI_HMC_3DS_LR_NUM2),
        .PRI_HMC_3DS_LR_NUM3                  (PRI_HMC_3DS_LR_NUM3),
        .PRI_HMC_3DS_PR_STAG_ENABLE           (PRI_HMC_3DS_PR_STAG_ENABLE),
        .PRI_HMC_3DS_REF2REF_DLR              (PRI_HMC_3DS_REF2REF_DLR),
        .PRI_HMC_3DSREF_ACK_ON_DONE           (PRI_HMC_3DSREF_ACK_ON_DONE),
        .SEC_HMC_CFG_PING_PONG_MODE           (SEC_HMC_CFG_PING_PONG_MODE),
        .SEC_HMC_CFG_CS_ADDR_WIDTH            (SEC_HMC_CFG_CS_ADDR_WIDTH),
        .SEC_HMC_CFG_COL_ADDR_WIDTH           (SEC_HMC_CFG_COL_ADDR_WIDTH),
        .SEC_HMC_CFG_ROW_ADDR_WIDTH           (SEC_HMC_CFG_ROW_ADDR_WIDTH),
        .SEC_HMC_CFG_BANK_ADDR_WIDTH          (SEC_HMC_CFG_BANK_ADDR_WIDTH),
        .SEC_HMC_CFG_BANK_GROUP_ADDR_WIDTH    (SEC_HMC_CFG_BANK_GROUP_ADDR_WIDTH),
        .SEC_HMC_CFG_ADDR_ORDER               (SEC_HMC_CFG_ADDR_ORDER),
        .SEC_HMC_CFG_ARBITER_TYPE             (SEC_HMC_CFG_ARBITER_TYPE),
        .SEC_HMC_CFG_OPEN_PAGE_EN             (SEC_HMC_CFG_OPEN_PAGE_EN),
        .SEC_HMC_CFG_CTRL_ENABLE_RC           (SEC_HMC_CFG_CTRL_ENABLE_RC),
        .SEC_HMC_CFG_DBC0_ENABLE_RC           (SEC_HMC_CFG_DBC0_ENABLE_RC),
        .SEC_HMC_CFG_DBC1_ENABLE_RC           (SEC_HMC_CFG_DBC1_ENABLE_RC),
        .SEC_HMC_CFG_DBC2_ENABLE_RC           (SEC_HMC_CFG_DBC2_ENABLE_RC),
        .SEC_HMC_CFG_DBC3_ENABLE_RC           (SEC_HMC_CFG_DBC3_ENABLE_RC),
        .SEC_HMC_CFG_CTRL_ENABLE_ECC          (SEC_HMC_CFG_CTRL_ENABLE_ECC),
        .SEC_HMC_CFG_DBC0_ENABLE_ECC          (SEC_HMC_CFG_DBC0_ENABLE_ECC),
        .SEC_HMC_CFG_DBC1_ENABLE_ECC          (SEC_HMC_CFG_DBC1_ENABLE_ECC),
        .SEC_HMC_CFG_DBC2_ENABLE_ECC          (SEC_HMC_CFG_DBC2_ENABLE_ECC),
        .SEC_HMC_CFG_DBC3_ENABLE_ECC          (SEC_HMC_CFG_DBC3_ENABLE_ECC),
        .SEC_HMC_CFG_REORDER_DATA             (SEC_HMC_CFG_REORDER_DATA),
        .SEC_HMC_CFG_REORDER_READ             (SEC_HMC_CFG_REORDER_READ),
        .SEC_HMC_CFG_CTRL_REORDER_RDATA       (SEC_HMC_CFG_CTRL_REORDER_RDATA),
        .SEC_HMC_CFG_DBC0_REORDER_RDATA       (SEC_HMC_CFG_DBC0_REORDER_RDATA),
        .SEC_HMC_CFG_DBC1_REORDER_RDATA       (SEC_HMC_CFG_DBC1_REORDER_RDATA),
        .SEC_HMC_CFG_DBC2_REORDER_RDATA       (SEC_HMC_CFG_DBC2_REORDER_RDATA),
        .SEC_HMC_CFG_DBC3_REORDER_RDATA       (SEC_HMC_CFG_DBC3_REORDER_RDATA),
        .SEC_HMC_CFG_CTRL_SLOT_OFFSET         (SEC_HMC_CFG_CTRL_SLOT_OFFSET),
        .SEC_HMC_CFG_DBC0_SLOT_OFFSET         (SEC_HMC_CFG_DBC0_SLOT_OFFSET),
        .SEC_HMC_CFG_DBC1_SLOT_OFFSET         (SEC_HMC_CFG_DBC1_SLOT_OFFSET),
        .SEC_HMC_CFG_DBC2_SLOT_OFFSET         (SEC_HMC_CFG_DBC2_SLOT_OFFSET),
        .SEC_HMC_CFG_DBC3_SLOT_OFFSET         (SEC_HMC_CFG_DBC3_SLOT_OFFSET),
        .SEC_HMC_CFG_CTRL_SLOT_ROTATE_EN      (SEC_HMC_CFG_CTRL_SLOT_ROTATE_EN),
        .SEC_HMC_CFG_DBC0_SLOT_ROTATE_EN      (SEC_HMC_CFG_DBC0_SLOT_ROTATE_EN),
        .SEC_HMC_CFG_DBC1_SLOT_ROTATE_EN      (SEC_HMC_CFG_DBC1_SLOT_ROTATE_EN),
        .SEC_HMC_CFG_DBC2_SLOT_ROTATE_EN      (SEC_HMC_CFG_DBC2_SLOT_ROTATE_EN),
        .SEC_HMC_CFG_DBC3_SLOT_ROTATE_EN      (SEC_HMC_CFG_DBC3_SLOT_ROTATE_EN),
        .SEC_HMC_CFG_COL_CMD_SLOT             (SEC_HMC_CFG_COL_CMD_SLOT),
        .SEC_HMC_CFG_ROW_CMD_SLOT             (SEC_HMC_CFG_ROW_CMD_SLOT),
        .SEC_HMC_CFG_ROW_TO_COL_OFFSET        (SEC_HMC_CFG_ROW_TO_COL_OFFSET),
        .SEC_HMC_CFG_ROW_TO_ROW_OFFSET        (SEC_HMC_CFG_ROW_TO_ROW_OFFSET),
        .SEC_HMC_CFG_COL_TO_COL_OFFSET        (SEC_HMC_CFG_COL_TO_COL_OFFSET),
        .SEC_HMC_CFG_COL_TO_DIFF_COL_OFFSET   (SEC_HMC_CFG_COL_TO_DIFF_COL_OFFSET),
        .SEC_HMC_CFG_COL_TO_ROW_OFFSET        (SEC_HMC_CFG_COL_TO_ROW_OFFSET),
        .SEC_HMC_CFG_SIDEBAND_OFFSET          (SEC_HMC_CFG_SIDEBAND_OFFSET),
        .SEC_HMC_CFG_CS_TO_CHIP_MAPPING       (SEC_HMC_CFG_CS_TO_CHIP_MAPPING),
        .SEC_HMC_CFG_CTL_ODT_ENABLED          (SEC_HMC_CFG_CTL_ODT_ENABLED),
        .SEC_HMC_CFG_RD_ODT_ON                (SEC_HMC_CFG_RD_ODT_ON),
        .SEC_HMC_CFG_RD_ODT_PERIOD            (SEC_HMC_CFG_RD_ODT_PERIOD),
        .SEC_HMC_CFG_READ_ODT_CHIP            (SEC_HMC_CFG_READ_ODT_CHIP),
        .SEC_HMC_CFG_WR_ODT_ON                (SEC_HMC_CFG_WR_ODT_ON),
        .SEC_HMC_CFG_WR_ODT_PERIOD            (SEC_HMC_CFG_WR_ODT_PERIOD),
        .SEC_HMC_CFG_WRITE_ODT_CHIP           (SEC_HMC_CFG_WRITE_ODT_CHIP),
        .SEC_HMC_CFG_CMD_FIFO_RESERVE_EN      (SEC_HMC_CFG_CMD_FIFO_RESERVE_EN),
        .SEC_HMC_CFG_RB_RESERVED_ENTRY        (SEC_HMC_CFG_RB_RESERVED_ENTRY),
        .SEC_HMC_CFG_WB_RESERVED_ENTRY        (SEC_HMC_CFG_WB_RESERVED_ENTRY),
        .SEC_HMC_CFG_STARVE_LIMIT             (SEC_HMC_CFG_STARVE_LIMIT),
        .SEC_HMC_CFG_PHY_DELAY_MISMATCH       (SEC_HMC_CFG_PHY_DELAY_MISMATCH),
        .SEC_HMC_CFG_DQSTRK_EN                (SEC_HMC_CFG_DQSTRK_EN),
        .SEC_HMC_CFG_DQSTRK_TO_VALID          (SEC_HMC_CFG_DQSTRK_TO_VALID),
        .SEC_HMC_CFG_DQSTRK_TO_VALID_LAST     (SEC_HMC_CFG_DQSTRK_TO_VALID_LAST),
        .SEC_HMC_CFG_CTL_SHORT_DQSTRK_EN      (SEC_HMC_CFG_CTL_SHORT_DQSTRK_EN),
        .SEC_HMC_CFG_PERIOD_DQSTRK_CTRL_EN    (SEC_HMC_CFG_PERIOD_DQSTRK_CTRL_EN),
        .SEC_HMC_CFG_PERIOD_DQSTRK_INTERVAL   (SEC_HMC_CFG_PERIOD_DQSTRK_INTERVAL),
        .SEC_HMC_CFG_SHORT_DQSTRK_CTRL_EN     (SEC_HMC_CFG_SHORT_DQSTRK_CTRL_EN),
        .SEC_HMC_CFG_ENABLE_FAST_EXIT_PPD     (SEC_HMC_CFG_ENABLE_FAST_EXIT_PPD),
        .SEC_HMC_CFG_USER_RFSH_EN             (SEC_HMC_CFG_USER_RFSH_EN),
        .SEC_HMC_CFG_GEAR_DOWN_EN             (SEC_HMC_CFG_GEAR_DOWN_EN),
        .SEC_HMC_CFG_MEM_AUTO_PD_CYCLES       (SEC_HMC_CFG_MEM_AUTO_PD_CYCLES),
        .SEC_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC (SEC_HMC_CFG_MEM_CLK_DISABLE_ENTRY_CYC),
        .SEC_HMC_MEMCLKGATE_SETTING           (SEC_HMC_MEMCLKGATE_SETTING),
        .SEC_HMC_CFG_TCL                      (SEC_HMC_CFG_TCL),
        .SEC_HMC_CFG_16_ACT_TO_ACT            (SEC_HMC_CFG_16_ACT_TO_ACT),
        .SEC_HMC_CFG_4_ACT_TO_ACT             (SEC_HMC_CFG_4_ACT_TO_ACT),
        .SEC_HMC_MEM_IF_AL                    (SEC_HMC_MEM_IF_AL),
        .SEC_HMC_MEM_IF_CS_PER_DIMM           (SEC_HMC_MEM_IF_CS_PER_DIMM),
        .SEC_HMC_MEM_IF_RD_PREAMBLE           (SEC_HMC_MEM_IF_RD_PREAMBLE),
        .SEC_HMC_MEM_IF_TCCD                  (SEC_HMC_MEM_IF_TCCD),
        .SEC_HMC_MEM_IF_TCCD_S                (SEC_HMC_MEM_IF_TCCD_S),
        .SEC_HMC_MEM_IF_TCKESR                (SEC_HMC_MEM_IF_TCKESR),
        .SEC_HMC_MEM_IF_TCKSRX                (SEC_HMC_MEM_IF_TCKSRX),
        .SEC_HMC_MEM_IF_TCL                   (SEC_HMC_MEM_IF_TCL),
        .SEC_HMC_MEM_IF_TCWL                  (SEC_HMC_MEM_IF_TCWL),
        .SEC_HMC_MEM_IF_TDQSCKMAX             (SEC_HMC_MEM_IF_TDQSCKMAX),
        .SEC_HMC_MEM_IF_TFAW                  (SEC_HMC_MEM_IF_TFAW),
        .SEC_HMC_MEM_IF_TMOD                  (SEC_HMC_MEM_IF_TMOD),
        .SEC_HMC_MEM_IF_TPL                   (SEC_HMC_MEM_IF_TPL),
        .SEC_HMC_MEM_IF_TRAS                  (SEC_HMC_MEM_IF_TRAS),
        .SEC_HMC_MEM_IF_TRC                   (SEC_HMC_MEM_IF_TRC),
        .SEC_HMC_MEM_IF_TRCD                  (SEC_HMC_MEM_IF_TRCD),
        .SEC_HMC_MEM_IF_TREFI                 (SEC_HMC_MEM_IF_TREFI),
        .SEC_HMC_MEM_IF_TRFC                  (SEC_HMC_MEM_IF_TRFC),
        .SEC_HMC_MEM_IF_TRP                   (SEC_HMC_MEM_IF_TRP),
        .SEC_HMC_MEM_IF_TRRD                  (SEC_HMC_MEM_IF_TRRD),
        .SEC_HMC_MEM_IF_TRRD_S                (SEC_HMC_MEM_IF_TRRD_S),
        .SEC_HMC_MEM_IF_TRTP                  (SEC_HMC_MEM_IF_TRTP),
        .SEC_HMC_MEM_IF_TWR                   (SEC_HMC_MEM_IF_TWR),
        .SEC_HMC_MEM_IF_TWR_CRC_DM            (SEC_HMC_MEM_IF_TWR_CRC_DM),
        .SEC_HMC_MEM_IF_TWTR                  (SEC_HMC_MEM_IF_TWTR),
        .SEC_HMC_MEM_IF_TWTR_L_CRC_DM         (SEC_HMC_MEM_IF_TWTR_L_CRC_DM),
        .SEC_HMC_MEM_IF_TWTR_S                (SEC_HMC_MEM_IF_TWTR_S),
        .SEC_HMC_MEM_IF_TWTR_S_CRC_DM         (SEC_HMC_MEM_IF_TWTR_S_CRC_DM),
        .SEC_HMC_MEM_IF_TXP                   (SEC_HMC_MEM_IF_TXP),
        .SEC_HMC_MEM_IF_TXPDLL                (SEC_HMC_MEM_IF_TXPDLL),
        .SEC_HMC_MEM_IF_TXSR                  (SEC_HMC_MEM_IF_TXSR),
        .SEC_HMC_MEM_IF_TZQCS                 (SEC_HMC_MEM_IF_TZQCS),
        .SEC_HMC_MEM_IF_TZQOPER               (SEC_HMC_MEM_IF_TZQOPER),
        .SEC_HMC_MEM_IF_WR_CRC                (SEC_HMC_MEM_IF_WR_CRC),
        .SEC_HMC_MEM_IF_WR_PREAMBLE           (SEC_HMC_MEM_IF_WR_PREAMBLE),
        .SEC_HMC_CFG_ACT_TO_ACT               (SEC_HMC_CFG_ACT_TO_ACT),
        .SEC_HMC_CFG_ACT_TO_ACT_DIFF_BANK     (SEC_HMC_CFG_ACT_TO_ACT_DIFF_BANK),
        .SEC_HMC_CFG_ACT_TO_ACT_DIFF_BG       (SEC_HMC_CFG_ACT_TO_ACT_DIFF_BG),
        .SEC_HMC_CFG_ACT_TO_PCH               (SEC_HMC_CFG_ACT_TO_PCH),
        .SEC_HMC_CFG_ACT_TO_RDWR              (SEC_HMC_CFG_ACT_TO_RDWR),
        .SEC_HMC_CFG_ARF_PERIOD               (SEC_HMC_CFG_ARF_PERIOD),
        .SEC_HMC_CFG_ARF_TO_VALID             (SEC_HMC_CFG_ARF_TO_VALID),
        .SEC_HMC_CFG_MMR_CMD_TO_VALID         (SEC_HMC_CFG_MMR_CMD_TO_VALID),
        .SEC_HMC_CFG_MPR_TO_VALID             (SEC_HMC_CFG_MPR_TO_VALID),
        .SEC_HMC_CFG_MPS_DQSTRK_DISABLE       (SEC_HMC_CFG_MPS_DQSTRK_DISABLE),
        .SEC_HMC_CFG_MPS_EXIT_CKE_TO_CS       (SEC_HMC_CFG_MPS_EXIT_CKE_TO_CS),
        .SEC_HMC_CFG_MPS_EXIT_CS_TO_CKE       (SEC_HMC_CFG_MPS_EXIT_CS_TO_CKE),
        .SEC_HMC_CFG_MPS_TO_VALID             (SEC_HMC_CFG_MPS_TO_VALID),
        .SEC_HMC_CFG_MPS_ZQCAL_DISABLE        (SEC_HMC_CFG_MPS_ZQCAL_DISABLE),
        .SEC_HMC_CFG_MRR_TO_VALID             (SEC_HMC_CFG_MRR_TO_VALID),
        .SEC_HMC_CFG_MRS_TO_VALID             (SEC_HMC_CFG_MRS_TO_VALID),
        .SEC_HMC_CFG_PCH_ALL_TO_VALID         (SEC_HMC_CFG_PCH_ALL_TO_VALID),
        .SEC_HMC_CFG_PCH_TO_VALID             (SEC_HMC_CFG_PCH_TO_VALID),
        .SEC_HMC_CFG_PDN_PERIOD               (SEC_HMC_CFG_PDN_PERIOD),
        .SEC_HMC_CFG_PDN_TO_VALID             (SEC_HMC_CFG_PDN_TO_VALID),
        .SEC_HMC_CFG_POWER_SAVING_EXIT_CYC    (SEC_HMC_CFG_POWER_SAVING_EXIT_CYC),
        .SEC_HMC_CFG_RD_AP_TO_VALID           (SEC_HMC_CFG_RD_AP_TO_VALID),
        .SEC_HMC_CFG_RD_TO_PCH                (SEC_HMC_CFG_RD_TO_PCH),
        .SEC_HMC_CFG_RD_TO_RD                 (SEC_HMC_CFG_RD_TO_RD),
        .SEC_HMC_CFG_RD_TO_RD_DIFF_BG         (SEC_HMC_CFG_RD_TO_RD_DIFF_BG),
        .SEC_HMC_CFG_RD_TO_RD_DIFF_CHIP       (SEC_HMC_CFG_RD_TO_RD_DIFF_CHIP),
        .SEC_HMC_CFG_RD_TO_WR                 (SEC_HMC_CFG_RD_TO_WR),
        .SEC_HMC_CFG_RD_TO_WR_DIFF_BG         (SEC_HMC_CFG_RD_TO_WR_DIFF_BG),
        .SEC_HMC_CFG_RD_TO_WR_DIFF_CHIP       (SEC_HMC_CFG_RD_TO_WR_DIFF_CHIP),
        .SEC_HMC_CFG_RFSH_WARN_THRESHOLD      (SEC_HMC_CFG_RFSH_WARN_THRESHOLD),
        .SEC_HMC_CFG_RLD3_MULTIBANK_REF_DELAY (SEC_HMC_CFG_RLD3_MULTIBANK_REF_DELAY),
        .SEC_HMC_CFG_RLD3_REFRESH_SEQ0        (SEC_HMC_CFG_RLD3_REFRESH_SEQ0),
        .SEC_HMC_CFG_RLD3_REFRESH_SEQ1        (SEC_HMC_CFG_RLD3_REFRESH_SEQ1),
        .SEC_HMC_CFG_RLD3_REFRESH_SEQ2        (SEC_HMC_CFG_RLD3_REFRESH_SEQ2),
        .SEC_HMC_CFG_RLD3_REFRESH_SEQ3        (SEC_HMC_CFG_RLD3_REFRESH_SEQ3),
        .SEC_HMC_CFG_SB_CG_DISABLE            (SEC_HMC_CFG_SB_CG_DISABLE),
        .SEC_HMC_CFG_SB_DDR4_MR3              (SEC_HMC_CFG_SB_DDR4_MR3),
        .SEC_HMC_CFG_SB_DDR4_MR4              (SEC_HMC_CFG_SB_DDR4_MR4),
        .SEC_HMC_CFG_SB_DDR4_MR5              (SEC_HMC_CFG_SB_DDR4_MR5),
        .SEC_HMC_CFG_DDR4_MPS_ADDRMIRROR      (SEC_HMC_CFG_DDR4_MPS_ADDRMIRROR),
        .SEC_HMC_CFG_SRF_AUTOEXIT_EN          (SEC_HMC_CFG_SRF_AUTOEXIT_EN),
        .SEC_HMC_CFG_SRF_ENTRY_EXIT_BLOCK     (SEC_HMC_CFG_SRF_ENTRY_EXIT_BLOCK),
        .SEC_HMC_CFG_SRF_TO_VALID             (SEC_HMC_CFG_SRF_TO_VALID),
        .SEC_HMC_CFG_SRF_TO_ZQ_CAL            (SEC_HMC_CFG_SRF_TO_ZQ_CAL),
        .SEC_HMC_CFG_SRF_ZQCAL_DISABLE        (SEC_HMC_CFG_SRF_ZQCAL_DISABLE),
        .SEC_HMC_TEMP_4_ACT_TO_ACT            (SEC_HMC_TEMP_4_ACT_TO_ACT),
        .SEC_HMC_TEMP_RD_TO_RD_DIFF_BG        (SEC_HMC_TEMP_RD_TO_RD_DIFF_BG),
        .SEC_HMC_TEMP_WR_TO_RD                (SEC_HMC_TEMP_WR_TO_RD),
        .SEC_HMC_TEMP_WR_TO_RD_DIFF_BG        (SEC_HMC_TEMP_WR_TO_RD_DIFF_BG),
        .SEC_HMC_TEMP_WR_TO_RD_DIFF_CHIP      (SEC_HMC_TEMP_WR_TO_RD_DIFF_CHIP),
        .SEC_HMC_TEMP_WR_TO_WR_DIFF_BG        (SEC_HMC_TEMP_WR_TO_WR_DIFF_BG),
        .SEC_HMC_CFG_WR_AP_TO_VALID           (SEC_HMC_CFG_WR_AP_TO_VALID),
        .SEC_HMC_CFG_WR_TO_PCH                (SEC_HMC_CFG_WR_TO_PCH),
        .SEC_HMC_CFG_WR_TO_RD                 (SEC_HMC_CFG_WR_TO_RD),
        .SEC_HMC_CFG_WR_TO_RD_DIFF_BG         (SEC_HMC_CFG_WR_TO_RD_DIFF_BG),
        .SEC_HMC_CFG_WR_TO_RD_DIFF_CHIP       (SEC_HMC_CFG_WR_TO_RD_DIFF_CHIP),
        .SEC_HMC_CFG_WR_TO_WR                 (SEC_HMC_CFG_WR_TO_WR),
        .SEC_HMC_CFG_WR_TO_WR_DIFF_BG         (SEC_HMC_CFG_WR_TO_WR_DIFF_BG),
        .SEC_HMC_CFG_WR_TO_WR_DIFF_CHIP       (SEC_HMC_CFG_WR_TO_WR_DIFF_CHIP),
        .SEC_HMC_CFG_ZQCL_TO_VALID            (SEC_HMC_CFG_ZQCL_TO_VALID),
        .SEC_HMC_CFG_ZQCS_TO_VALID            (SEC_HMC_CFG_ZQCS_TO_VALID),
        .SEC_HMC_CHIP_ID                      (SEC_HMC_CHIP_ID),
        .SEC_HMC_CID_ADDR_WIDTH               (SEC_HMC_CID_ADDR_WIDTH),
        .SEC_HMC_3DS_EN                       (SEC_HMC_3DS_EN),
        .SEC_HMC_3DS_LR_NUM0                  (SEC_HMC_3DS_LR_NUM0),
        .SEC_HMC_3DS_LR_NUM1                  (SEC_HMC_3DS_LR_NUM1),
        .SEC_HMC_3DS_LR_NUM2                  (SEC_HMC_3DS_LR_NUM2),
        .SEC_HMC_3DS_LR_NUM3                  (SEC_HMC_3DS_LR_NUM3),
        .SEC_HMC_3DS_PR_STAG_ENABLE           (SEC_HMC_3DS_PR_STAG_ENABLE),
        .SEC_HMC_3DS_REF2REF_DLR              (SEC_HMC_3DS_REF2REF_DLR),
        .SEC_HMC_3DSREF_ACK_ON_DONE           (SEC_HMC_3DSREF_ACK_ON_DONE),
        
        .PINS_PER_LANE                        (PINS_PER_LANE),
        .LANES_PER_TILE                       (LANES_PER_TILE),
        .PINS_IN_RTL_TILES                    (PINS_IN_RTL_TILES),
        .LANES_IN_RTL_TILES                   (LANES_IN_RTL_TILES),
        .NUM_OF_RTL_TILES                     (NUM_OF_RTL_TILES),
        .AC_PIN_MAP_SCHEME                    (AC_PIN_MAP_SCHEME),
        .PRI_AC_TILE_INDEX                    (PRI_AC_TILE_INDEX),
        .SEC_AC_TILE_INDEX                    (SEC_AC_TILE_INDEX),
        .PRI_HMC_DBC_SHADOW_LANE_INDEX        (PRI_HMC_DBC_SHADOW_LANE_INDEX),
        .LANES_USAGE                          (LANES_USAGE),
        .PINS_USAGE                           (PINS_USAGE),
        .PINS_RATE                            (PINS_RATE),
        .DB_PINS_PROC_MODE                    (DB_PINS_PROC_MODE),
        .PINS_DATA_IN_MODE                    (PINS_DATA_IN_MODE),
        .PINS_OCT_MODE                        (PINS_OCT_MODE),
        .PINS_DCC_SPLIT                       (PINS_DCC_SPLIT),
        .CENTER_TIDS                          (CENTER_TIDS),
        .HMC_TIDS                             (HMC_TIDS),
        .LANE_TIDS                            (LANE_TIDS),
        .DBC_PIPE_LATS                        (DBC_PIPE_LATS),
        .DB_PTR_PIPELINE_DEPTHS               (DB_PTR_PIPELINE_DEPTHS),
        .DB_SEQ_RD_EN_FULL_PIPELINES          (DB_SEQ_RD_EN_FULL_PIPELINES),
        .PREAMBLE_MODE                        (PREAMBLE_MODE),
        .DBI_WR_ENABLE                        (DBI_WR_ENABLE),
        .DBI_RD_ENABLE                        (DBI_RD_ENABLE),
        .SWAP_DQS_A_B                         (SWAP_DQS_A_B),
        .DQS_PACK_MODE                        (DQS_PACK_MODE),
        .OCT_SIZE                             (OCT_SIZE),
        .DQSA_LGC_MODE                        (DQSA_LGC_MODE),
        .DQSB_LGC_MODE                        (DQSB_LGC_MODE),
        .DBC_WB_RESERVED_ENTRY                (DBC_WB_RESERVED_ENTRY),
        .DLL_MODE                             (DLL_MODE),
        .DLL_CODEWORD                         (DLL_CODEWORD),
        .PORT_MEM_DQS_WIDTH                   (PORT_MEM_DQS_WIDTH),
        .PORT_MEM_DQ_WIDTH                    (PORT_MEM_DQ_WIDTH),
        .PORT_DFT_ND_PA_DPRIO_REG_ADDR_WIDTH  (PORT_DFT_ND_PA_DPRIO_REG_ADDR_WIDTH),
        .PORT_DFT_ND_PA_DPRIO_WRITEDATA_WIDTH (PORT_DFT_ND_PA_DPRIO_WRITEDATA_WIDTH),
        .PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH  (PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH),
        
        .PORT_MEM_A_PINLOC                    (PORT_MEM_A_PINLOC),
        .PORT_MEM_BA_PINLOC                   (PORT_MEM_BA_PINLOC),
        .PORT_MEM_BG_PINLOC                   (PORT_MEM_BG_PINLOC),
        .PORT_MEM_C_PINLOC                    (PORT_MEM_C_PINLOC),
        .PORT_MEM_CS_N_PINLOC                 (PORT_MEM_CS_N_PINLOC),
        .PORT_MEM_ACT_N_PINLOC                (PORT_MEM_ACT_N_PINLOC),
        .PORT_MEM_DQ_PINLOC                   (PORT_MEM_DQ_PINLOC),
        .PORT_MEM_DM_PINLOC                   (PORT_MEM_DM_PINLOC),
        .PORT_MEM_DBI_N_PINLOC                (PORT_MEM_DBI_N_PINLOC),
        .PORT_MEM_RAS_N_PINLOC                (PORT_MEM_RAS_N_PINLOC),
        .PORT_MEM_CAS_N_PINLOC                (PORT_MEM_CAS_N_PINLOC),
        .PORT_MEM_WE_N_PINLOC                 (PORT_MEM_WE_N_PINLOC),
        .PORT_MEM_REF_N_PINLOC                (PORT_MEM_REF_N_PINLOC),
        .PORT_MEM_WPS_N_PINLOC                (PORT_MEM_WPS_N_PINLOC),
        .PORT_MEM_RPS_N_PINLOC                (PORT_MEM_RPS_N_PINLOC),
        .PORT_MEM_BWS_N_PINLOC                (PORT_MEM_BWS_N_PINLOC),
        .PORT_MEM_DQA_PINLOC                  (PORT_MEM_DQA_PINLOC),
        .PORT_MEM_DQB_PINLOC                  (PORT_MEM_DQB_PINLOC),
        .PORT_MEM_Q_PINLOC                    (PORT_MEM_Q_PINLOC),
        .PORT_MEM_D_PINLOC                    (PORT_MEM_D_PINLOC),
        .PORT_MEM_RWA_N_PINLOC                (PORT_MEM_RWA_N_PINLOC),
        .PORT_MEM_RWB_N_PINLOC                (PORT_MEM_RWB_N_PINLOC),
        .PORT_MEM_QKA_PINLOC                  (PORT_MEM_QKA_PINLOC),
        .PORT_MEM_QKB_PINLOC                  (PORT_MEM_QKB_PINLOC),
        .PORT_MEM_LDA_N_PINLOC                (PORT_MEM_LDA_N_PINLOC),
        .PORT_MEM_LDB_N_PINLOC                (PORT_MEM_LDB_N_PINLOC),
        .PORT_MEM_CK_PINLOC                   (PORT_MEM_CK_PINLOC),
        .PORT_MEM_DINVA_PINLOC                (PORT_MEM_DINVA_PINLOC),
        .PORT_MEM_DINVB_PINLOC                (PORT_MEM_DINVB_PINLOC),
        .PORT_MEM_AINV_PINLOC                 (PORT_MEM_AINV_PINLOC),
        .PORT_MEM_DQS_PINLOC                  (PORT_MEM_DQS_PINLOC),
        .PORT_MEM_QK_PINLOC                   (PORT_MEM_QK_PINLOC),
        .PORT_MEM_CQ_PINLOC                   (PORT_MEM_CQ_PINLOC),
        .PORT_MEM_DM_WIDTH                    (PORT_MEM_DM_WIDTH),
        .PORT_MEM_A_WIDTH                     (PORT_MEM_A_WIDTH),
        .PORT_MEM_BA_WIDTH                    (PORT_MEM_BA_WIDTH),
        .PORT_MEM_BG_WIDTH                    (PORT_MEM_BG_WIDTH),
        .PORT_MEM_C_WIDTH                     (PORT_MEM_C_WIDTH),
        .PORT_MEM_CS_N_WIDTH                  (PORT_MEM_CS_N_WIDTH),
        .PORT_MEM_ACT_N_WIDTH                 (PORT_MEM_ACT_N_WIDTH),
        .PORT_MEM_DBI_N_WIDTH                 (PORT_MEM_DBI_N_WIDTH),
        .PORT_MEM_RAS_N_WIDTH                 (PORT_MEM_RAS_N_WIDTH),
        .PORT_MEM_CAS_N_WIDTH                 (PORT_MEM_CAS_N_WIDTH),
        .PORT_MEM_WE_N_WIDTH                  (PORT_MEM_WE_N_WIDTH),
        .PORT_MEM_REF_N_WIDTH                 (PORT_MEM_REF_N_WIDTH),
        .PORT_MEM_WPS_N_WIDTH                 (PORT_MEM_WPS_N_WIDTH),
        .PORT_MEM_RPS_N_WIDTH                 (PORT_MEM_RPS_N_WIDTH),
        .PORT_MEM_BWS_N_WIDTH                 (PORT_MEM_BWS_N_WIDTH),
        .PORT_MEM_DQA_WIDTH                   (PORT_MEM_DQA_WIDTH),
        .PORT_MEM_DQB_WIDTH                   (PORT_MEM_DQB_WIDTH),
        .PORT_MEM_Q_WIDTH                     (PORT_MEM_Q_WIDTH),
        .PORT_MEM_D_WIDTH                     (PORT_MEM_D_WIDTH),
        .PORT_MEM_RWA_N_WIDTH                 (PORT_MEM_RWA_N_WIDTH),
        .PORT_MEM_RWB_N_WIDTH                 (PORT_MEM_RWB_N_WIDTH),
        .PORT_MEM_QKA_WIDTH                   (PORT_MEM_QKA_WIDTH),
        .PORT_MEM_QKB_WIDTH                   (PORT_MEM_QKB_WIDTH),
        .PORT_MEM_LDA_N_WIDTH                 (PORT_MEM_LDA_N_WIDTH),
        .PORT_MEM_LDB_N_WIDTH                 (PORT_MEM_LDB_N_WIDTH),
        .PORT_MEM_CK_WIDTH                    (PORT_MEM_CK_WIDTH),
        .PORT_MEM_DINVA_WIDTH                 (PORT_MEM_DINVA_WIDTH),
        .PORT_MEM_DINVB_WIDTH                 (PORT_MEM_DINVB_WIDTH),
        .PORT_MEM_AINV_WIDTH                  (PORT_MEM_AINV_WIDTH),
        .DIAG_USE_ABSTRACT_PHY                (DIAG_USE_ABSTRACT_PHY),
        .DIAG_ABSTRACT_PHY_WLAT               (DIAG_ABSTRACT_PHY_WLAT),
        .DIAG_ABSTRACT_PHY_RLAT               (DIAG_ABSTRACT_PHY_RLAT),
        .ABPHY_WRITE_PROTOCOL                 (ABPHY_WRITE_PROTOCOL),
        .DIAG_SIM_MEM_BYPASS_DQ_WIDTH                       (DIAG_SIM_MEM_BYPASS_DQ_WIDTH),   
        .DIAG_SIM_MEM_BYPASS_ADDR_WIDTH                     (DIAG_SIM_MEM_BYPASS_ADDR_WIDTH),
        .PHY_CONFIG_ENUM                      (PHY_CONFIG_ENUM),
        .MEM_ROW_ADDR_WIDTH                    (MEM_ROW_ADDR_WIDTH),
        .MEM_COL_ADDR_WIDTH                    (MEM_COL_ADDR_WIDTH),
        .HMC_CFG_ADDR_ORDER                   (HMC_CFG_ADDR_ORDER),   
        .HMC_CFG_CS_ADDR_WIDTH                (HMC_CFG_CS_ADDR_WIDTH),
        .HMC_CFG_ROW_ADDR_WIDTH               (HMC_CFG_ROW_ADDR_WIDTH)
     ) io_tiles_abphy_inst (
        .*
     );
  end
     else begin : nonabphy_setoutputs
         assign phy_fb_clk_to_pll_abphy = 'd0;
         assign core_clks_from_cpa_pri_abphy = 'd0;
         assign core_clks_locked_cpa_pri_abphy = 'd0;
         assign core_clks_from_cpa_sec_abphy = 'd0;
         assign core_clks_locked_cpa_sec_abphy = 'd0;
         assign ctl2core_avl_cmd_ready_0_abphy = 'd0;
         assign ctl2core_avl_cmd_ready_1_abphy = 'd0;
         assign ctl2core_avl_rdata_id_0_abphy = 'd0;
         assign ctl2core_avl_rdata_id_1_abphy = 'd0;
         assign l2core_rd_data_vld_avl0_abphy = 'd0;
         assign l2core_wr_data_rdy_ast_abphy = 'd0;
         assign l2core_wb_pointer_for_ecc_abphy = 'd0;
         assign l2core_data_abphy = 'd0;
         assign l2core_rdata_valid_abphy = 'd0;
         assign l2core_afi_rlat_abphy = 'd0;
         assign l2core_afi_wlat_abphy = 'd0;
         assign t2c_afi_abphy = 'd0;
         assign ctl2core_sideband_0_abphy = 'd0;
         assign ctl2core_sideband_1_abphy = 'd0;
         assign ctl2core_mmr_0_abphy = 'd0;
         assign ctl2core_mmr_1_abphy = 'd0;
         assign l2b_data_abphy = 'd0;
         assign l2b_oe_abphy = 'd0;
         assign l2b_dtc_abphy = 'd0;
         assign l2b_e_a_abphy = 'd0;
         assign l2b_e_b_abphy = 'd0;
         assign pa_dprio_block_select_abphy = 'd0;
         assign pa_dprio_readdata_abphy = 'd0;
         assign runAbstractPhySim = 'd0;
     end
   endgenerate
   
   altera_emif_arch_nd_abphy_mux #(
      .DIAG_USE_ABSTRACT_PHY                (DIAG_USE_ABSTRACT_PHY),     
      .PINS_PER_LANE                        (PINS_PER_LANE),
      .LANES_PER_TILE                       (LANES_PER_TILE),
      .PINS_IN_RTL_TILES                    (PINS_IN_RTL_TILES),
      .NUM_OF_RTL_TILES                     (NUM_OF_RTL_TILES),    
      .PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH  (PORT_DFT_ND_PA_DPRIO_READDATA_WIDTH),  
      .PORT_DFT_ND_PA_DPRIO_REG_ADDR_WIDTH  (PORT_DFT_ND_PA_DPRIO_REG_ADDR_WIDTH),    
      .PORT_DFT_ND_PA_DPRIO_WRITEDATA_WIDTH (PORT_DFT_ND_PA_DPRIO_WRITEDATA_WIDTH),  
      .LANES_IN_RTL_TILES                   (LANES_IN_RTL_TILES)  
   ) altera_emif_arch_nd_abphy_mux_inst (
      .*
   );

   integer i, j;
   
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "AkDMPQOIIBdUXJUhCY52t3tbYDqXLRT52E5ixmZO0uPIiLYJYXmvta4pFJ02IBPPGIT2TNlVDsKSvVYXIouIW3+7aiOKefqrRsAdehbNE32jACVZGhhWbzy3szTqf0uEFX9R013QJTOv5J6g1voik7ro4grooLGTSGkMVb4gcDO55U1rrsm6St9TUaqtK0kUq5O3EnV7TSjC5mQCTLijd71E/Cuksp1vhZhmO5ulHVCtQUndUI9uU/Lu155kMNGADJgBE5477Al/CvWCd+7wphjS1wKR1Ep/hO/vU+2ZJ6ezLH6XKRW9TPKrHnEGxFlp3XElvhVul5nYhA7+NZSNjokQLahLPHq+sbuTOC1Llc/6pP/di5mSGZeRrPabH2XgWzrFaZvAZALG20/zHEGLJluR5ooX4qqWjwHMkmFxrtttTLKafIBI7IBfwbm0TMzSZM9yIi5GJTAOtTRVHxL3e8pkshJdSmRWbNlNDiMtCsQWBY6Av4VVzktQJCiW3rjxuOZka32PUapKzPSC2zRe/CpKs/KteHwbwIKcvklp4YjqXWL6yWM8QLCrPf/1Ntnisblu9pgUHO3p6sIUIPTMqxHyw1DchEuyzZNLwcKGVdbJ5Zp4aVX+Ww5AJGck+WAV37oHptTTZFxRcBjLz4Y5xxGW2XGSlMSeTDibrIhfUSYPfE2Vk47Gf2wfTz1kCQiA/ye5f8DBZ2KYRR2ASds8oCQxGN4mWvByX3YUUjXXBMUopgwzi7MEIVhlUp7iVREJPsJKSxelk7i4JeBHWnyMxE1BfrNGhpGz/XCWExg67Prenf58KDEdCAkfLPAF+pqy855bs9we8MeMcWPQqEG6pU5Pl3XxMYBsEAhdIf8ORKcEbKNMmtFLYIXIbtccffGvoVikSYEjNUDcOl+0TKBT14my5RcRhe5ULKumbyb1Cuh6Xz0Fcigh8FdwVGE7wg3Mtm/OsZ1Bi7V0oOPBMNa8yFLTUuGaUAwttIWr0IKmMv7BOFOD7iofbia9uDwvYcr2"
`endif