// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module altera_emif_arch_nd_buf_bdir_se #(
   parameter OCT_CONTROL_WIDTH = 1,
   parameter CALIBRATED_OCT = 1
) (
   inout  tri   io,
   output logic ibuf_o,
   input  logic obuf_i,
   input  logic obuf_oe,
   input  logic obuf_dtc,
   input  logic emif_phy_in_a,
   input  logic emif_phy_in_b,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_stc,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_ptc
);
   timeunit 1ns;
   timeprecision 1ps;
   
   generate
      if (CALIBRATED_OCT) 
      begin : cal_oct
         fourteennm_io_ibuf ibuf(
            .i(io),
            .o(ibuf_o),
            .seriesterminationcontrol(oct_stc),
            .parallelterminationcontrol(oct_ptc),
            .dynamicterminationcontrol(),
            .ibar()
            );
            
         fourteennm_io_obuf obuf (
            .i(obuf_i),
            .o(io),
            .oe(obuf_oe),
            .dynamicterminationcontrol(obuf_dtc),
            .seriesterminationcontrol(oct_stc),
            .parallelterminationcontrol(oct_ptc),
            .emif_phy_in({emif_phy_in_a, emif_phy_in_b}),
            .obar(),
            .devoe()
            );
      end else 
      begin : no_oct
         fourteennm_io_ibuf ibuf(
            .i(io),
            .o(ibuf_o),
            .seriesterminationcontrol(),
            .parallelterminationcontrol(),
            .dynamicterminationcontrol(),
            .ibar()
            );
            
         fourteennm_io_obuf obuf (
            .i(obuf_i),
            .o(io),
            .oe(obuf_oe),
            .dynamicterminationcontrol(),
            .seriesterminationcontrol(),
            .parallelterminationcontrol(),
            .emif_phy_in({emif_phy_in_a, emif_phy_in_b}),
            .obar(),
            .devoe()
            );      
      end
   endgenerate            
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "oDDtlXUtB+UysQe7FAoTjxcfb3pKKZZLrS5gWp3sw6TuLTYbGGPlXrXcZ7+F6YBIPhJ5h3QXHIHqEBi+fZrdQvw8PmpPHeXxhJPA5NrJCYxLypp3uyWIvknCrKDV5VajPhu/6EDgrGyy1jEOeS9sSoWBjvWqcpNUXK9nvlOUVIV0xIHfWjY+W8oSdfc6y5vPRe0I38rOdGy+yVCaj9K659/1ZRR/+WygUMQoj4RbOhEwYL05HujeIEv04HzHhKcZ/FkvgodNV4XzZLHta0wp4LS8u/clHsUKhgbCmodJ8Rv2R5YCZVapP+Fk7tcuYLlvf9FRr+URRqJSCXPL5eY2jD8HnB0Q37o4uzxDnNMjVDe8N3qJXKbX0b5ua4U83GjMTTvdu2X5ijN0Fb6wEXI1xMLN9RhsTr9JsqbPAcRMP6JATVoKDz9hzPboRr7lup+nex37d8K5Sh52tcjL2ewnC3PizTenhYYaCnQMuBOhZEChrVquwa8pzo19loCgC85lhd1QhxWNnrqjWu0jySW7jPjIwXIHd2q4+N0rqrTZvsNHKbZo+kf4UPH4ik2LUMMV85Pww00NZfqLFc2U4M+vjMe+QFqEBWktayZ4gJhhVGPmEoPX8j21O8fYSLVyg76ROYemaLEDknS9fLtD5YmCYkpEIBzvSpvswNwaC7FWfFXUX+3rcLkeXrfBylONrcSmBs6Ls+h4ja7TUGCNHhRc6k7eDJlNqme7T9pdDxTrK+uO+Gm9UkcOiUP+HkzDtgcXXMkLk2CUI+fT9m2cKosIu7aFf+BB07KUmcDODx+qX5+5MejJ8FYigjMXelnlp1nnhPxR5iXaT5YZjDjFx5NsEIoYX3FfoMeaR6JAr2idTvQICSz5P/Ls1QAL/AN+cR2D1BEvzOIXlT96K3dvUZlbFFXqRyumJp2MBFF1/N8QMEFEGcmjX8JQZzEzhYbWPNi3+Q5WxPL7BmuzkvNc5iOFBKmB0W2ilbzgz9hpU4yDLEM/RbSzVg/fJWfux9+t3znn"
`endif