// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module altera_emif_arch_nd_buf_udir_df_o #(
   parameter OCT_CONTROL_WIDTH = 1,
   parameter CALIBRATED_OCT = 1
) (
   input  logic i,
   input  logic ibar,
   output logic o,
   output logic obar,
   input  logic oein,
   input  logic oeinb,
   input  logic [1:0] emif_phy_in_a,
   input  logic [1:0] emif_phy_in_b,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_stc,
   input  logic [OCT_CONTROL_WIDTH-1:0] oct_ptc
);
   timeunit 1ns;
   timeprecision 1ps;

   localparam DCCEN = "true";

   logic pdiff_out_o;
   logic pdiff_out_obar;

   logic pdiff_out_oe;
   logic pdiff_out_oebar;
   logic[1:0] emif_phy_a;
   logic[1:0] emif_phy_b;

   fourteennm_pseudo_diff_out # (
      .feedthrough("true")
   ) pdiff_out (
      .i(i),
      .ibar(ibar),
      .o(pdiff_out_o),
      .obar(pdiff_out_obar),
      .oein(oein),
      .oebin(oeinb),
      .oeout(pdiff_out_oe),
      .oebout(pdiff_out_oebar),
      .emif_phy_out(emif_phy_a),
      .emif_phy_outb(emif_phy_b),
      .emif_phy_in (emif_phy_in_a),
      .emif_phy_inb(emif_phy_in_b),
      .dtcin(),
      .dtcbarin(),
      .dtc(),
      .dtcbar()
   );

   generate
      if (CALIBRATED_OCT)
      begin : cal_oct
         fourteennm_io_obuf # (
            .dccen(DCCEN)
         ) obuf (
            .i(pdiff_out_o),
            .o(o),
            .oe(pdiff_out_oe),
            .seriesterminationcontrol(oct_stc),
            .parallelterminationcontrol(oct_ptc),
            .emif_phy_in(emif_phy_a),
            .dynamicterminationcontrol(),
            .obar(),
            .devoe()
         );

         fourteennm_io_obuf # (
            .dccen(DCCEN)
         ) obuf_bar (
            .i(pdiff_out_obar),
            .o(obar),
            .oe(pdiff_out_oebar),
            .seriesterminationcontrol(oct_stc),
            .parallelterminationcontrol(oct_ptc),
            .emif_phy_in(emif_phy_b),
            .dynamicterminationcontrol(),
            .obar(),
            .devoe()
         );
      end else
      begin : no_oct
         fourteennm_io_obuf # (
            .dccen(DCCEN)
         ) obuf (
            .i(pdiff_out_o),
            .o(o),
            .oe(pdiff_out_oe),
            .seriesterminationcontrol(),
            .parallelterminationcontrol(),
             .emif_phy_in(emif_phy_a),
            .dynamicterminationcontrol(),
            .obar(),
            .devoe()
         );

         fourteennm_io_obuf # (
            .dccen(DCCEN)
         ) obuf_bar (
            .i(pdiff_out_obar),
            .o(obar),
            .oe(pdiff_out_oebar),
            .seriesterminationcontrol(),
            .emif_phy_in(emif_phy_b),
            .parallelterminationcontrol(),
            .dynamicterminationcontrol(),
            .obar(),
            .devoe()
         );
      end
   endgenerate

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "oDDtlXUtB+UysQe7FAoTjxcfb3pKKZZLrS5gWp3sw6TuLTYbGGPlXrXcZ7+F6YBIPhJ5h3QXHIHqEBi+fZrdQvw8PmpPHeXxhJPA5NrJCYxLypp3uyWIvknCrKDV5VajPhu/6EDgrGyy1jEOeS9sSoWBjvWqcpNUXK9nvlOUVIV0xIHfWjY+W8oSdfc6y5vPRe0I38rOdGy+yVCaj9K659/1ZRR/+WygUMQoj4RbOhGbCxHoheHezy59bOpf3hUg3Ja4bc16SmONQ/iwUbL0iPOTRr/d2JFLwQPjvQCNCDxm/TUcSVsMj280R/9+/CsfMMhFCt4cBL2vKDsm+CY87urA7H7zQgwvWDW2NkzujWEEnwpDZmJIUoi9yIHKVYpbOsHqPMVMe8k4J9g9hDgEyqgr2qfgxUe0LMvUGdr9THfVNCjxaOclKFoqpwg3pSsmEpfa1niuF05VmwWIW3Q5SQsEymvaYEfS5L4r9pHy6WiqtG/G3Ode0IlBdkC6OVHyogOLM8jWyBNyMOMNPPMZqDNRwBAPHDRoGxVIhZ8fo4GKeShA3j0iol+h2139UjSf33R6MfvUDxuXbuuGTWhirfZZdaVwit4dO8E1qrcZMYA8lsjbT9nXbZSEwK6w1sVxQDn/RVCSoUE5fwGCUdlzr/PVVp1oejD657XE8CVdnOhjhKdGLvbvmvH5eYzOma38MD1V6z6p3ZLjLTwOcGvfdK5xi0+ZXjF2ttqCWrOY1NS6BDhvFtgCGAITCyhAuh7Y6I6bul+FUUC335BwttNTLyVvicMHlKOAYSl9msTHSP3nrZe/Ch95o8hnn7VmSwxWxoCnYFwzRG/ueUaEJCOGvRiYvXzhTbRPeo5juoP60eT+ofOvOA7HGP8KLndk0HAzuWH6BbvvptA9rDwPV3HsSJqnwDd+WweuOL5SMq6onDQnL5lmhNf2FRSN7VO++xMTpgtNSNz3Qua43oJqHbrhIP0VeczwFZLbrhWGGva8keDrz+mTNbgFDUshuiL81pFp"
`endif