// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Fri Jul 25 14:12:09 2025
// ============================================================================

`define ENABLE_DDR4A
`define ENABLE_DDR4B
//`define ENABLE_XCVR
//`define ENABLE_HPS
//`define ENABLE_PCIE
`define ENABLE_MCIO
//`define ENABLE_QSFPA
//`define ENABLE_QSFPB

module golden_top(

      ///////// CLOCK /////////
      input              CLK_100_B3A,
      input              CLK_100_B3L,
      input              CLK_25_B3L,

      ///////// Buttons /////////
      input    [ 1: 0]   BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   SW,

      ///////// LED /////////
      output   [ 1: 0]   LED, //LED is Low-Active

      ///////// Reset /////////
      input              FPGA_RST,
      input              HPS_RST,

`ifdef ENABLE_DDR4A
      ///////// DDR4A /////////
      input              DDR4A_REFCLK_p,
      output   [16: 0]   DDR4A_A,
      output   [ 1: 0]   DDR4A_BA,
      output   [ 0: 0]   DDR4A_BG,
      output             DDR4A_CK,
      output             DDR4A_CK_n,
      output             DDR4A_CKE,
      inout    [ 7: 0]   DDR4A_DQS,
      inout    [ 7: 0]   DDR4A_DQS_n,
      inout    [63: 0]   DDR4A_DQ,
      inout    [ 7: 0]   DDR4A_DBI_n,
      output             DDR4A_CS_n,
      output             DDR4A_RESET_n,
      output             DDR4A_ODT,
      output             DDR4A_PAR,
      input              DDR4A_ALERT_n,
      output             DDR4A_ACT_n,
      input              DDR4A_RZQ,
`endif /*ENABLE_DDR4A*/

`ifdef ENABLE_DDR4B
      ///////// DDR4B /////////
      input              DDR4B_REFCLK_p,
      output   [16: 0]   DDR4B_A,
      output   [ 1: 0]   DDR4B_BA,
      output   [ 0: 0]   DDR4B_BG,
      output             DDR4B_CK,
      output             DDR4B_CK_n,
      output             DDR4B_CKE,
      inout    [ 7: 0]   DDR4B_DQS,
      inout    [ 7: 0]   DDR4B_DQS_n,
      inout    [63: 0]   DDR4B_DQ,
      inout    [ 7: 0]   DDR4B_DBI_n,
      output             DDR4B_CS_n,
      output             DDR4B_RESET_n,
      output             DDR4B_ODT,
      output             DDR4B_PAR,
      input              DDR4B_ALERT_n,
      output             DDR4B_ACT_n,
      input              DDR4B_RZQ,
`endif /*ENABLE_DDR4B*/

      ///////// USBFX3 /////////
      output             USBFX3_RESET_n,
      output             USBFX3_PCLK,
      output             USBFX3_CTL0_SLCS_n,
      output             USBFX3_UART_TX,
      input              USBFX3_UART_RX,
      output             USBFX3_CTL10,
      output             USBFX3_CTL11_A1,
      output             USBFX3_CTL12_A0,
      input              USBFX3_CTL15_INT_n,
      output             USBFX3_CTL1_SLWR_n,
      output             USBFX3_CTL2_SLOE_n,
      output             USBFX3_CTL3_SLRD_n,
      input              USBFX3_CTL4_FLAGA,
      input              USBFX3_CTL5_FLAGB,
      input              USBFX3_CTL6_FLAGC,
      output             USBFX3_CTL7_PKTEND_n,
      input              USBFX3_CTL8_FLAGD,
      output             USBFX3_CTL9,
      inout    [31: 0]   USBFX3_DQ,
      inout              USBFX3_OTG_ID,
      output             USBFX3_USB_MODE,

      ///////// ENETB /////////
      input              ENETB_RX_CLK,
      input    [ 7: 0]   ENETB_RX_DATA,
      input              ENETB_RX_COL,
      input              ENETB_RX_CRS,
      input              ENETB_RX_DV,
      input              ENETB_RX_ER,
      output             ENETB_GTX_CLK,
      output   [ 7: 0]   ENETB_TX_DATA,
      output             ENETB_TX_EN,
      output             ENETB_TX_ER,
      input              ENETB_INT_n,
      output             ENETB_MDC,
      inout              ENETB_MDIO,
      output             ENETB_RESET_n,

      ///////// I2C for EEPROM (Si5341) /////////
      inout              FPGA_I2C_SCL,
      inout              FPGA_I2C_SDA,

      ///////// Power Monitor /////////
      inout              PM_I2C_SCL,
      inout              PM_I2C_SDA,
      input              PM_ALERT_n,

`ifdef ENABLE_PCIE
      ///////// PCIe Edge /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      input              PCIE_REFCLK_p, //CLK2_XCVR_1C_p
      output   [15: 0]   PCIE_TX_p,
      input    [15: 0]   PCIE_RX_p,
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFPA
      ///////// QSFPA /////////
      input              QSFPA_REFCLK_p, //LGBTCLK2_1L_p
      output   [ 3: 0]   QSFPA_TX_p,
      input    [ 3: 0]   QSFPA_RX_p,
      input              QSFPA_INTERRUPT_n,
      output             QSFPA_LP_MODE,
      input              QSFPA_MOD_PRS_n,
      output             QSFPA_MOD_SEL_n,
      output             QSFPA_RST_n,
      inout              QSFPA_SCL,
      inout              QSFPA_SDA,
`endif /*ENABLE_QSFPA*/

`ifdef ENABLE_QSFPB
      ///////// QSFPB /////////
      input              QSFPB_REFCLK_p, //LGBTCLK1_1M_p
      output   [ 3: 0]   QSFPB_TX_p,
      input    [ 3: 0]   QSFPB_RX_p,
      input              QSFPB_INTERRUPT_n,
      output             QSFPB_LP_MODE,
      input              QSFPB_MOD_PRS_n,
      output             QSFPB_MOD_SEL_n,
      output             QSFPB_RST_n,
      inout              QSFPB_SCL,
      inout              QSFPB_SDA,
`endif /*ENABLE_QSFPB*/

`ifdef ENABLE_XCVR
      ///////// Transceiver reference clock /////////
      input              XCVR_REFCLK1D_p,
      input              XCVR_REFCLK1E_p,
      input              XCVR_REFCLK1K_p,
      input              XCVR_REFCLK1L_p,
      input              XCVR_REFCLK1M_p,
`endif /*ENABLE_XCVR*/

`ifdef ENABLE_MCIO
      ///////// MCIO /////////
      inout              MCIO_SMBCLK,
      inout              MCIO_SMBDAT,
      input              MCIO_CONN_CLK_p, //RGBTCLK0_1K_p
      output   [ 7: 0]   MCIO_TX_p,
      input    [ 7: 0]   MCIO_RX_p,
      input              MCIO_PERST_n,
      input              MCIO_SMB_ALERT_n,
`endif /*ENABLE_MCIO*/

      ///////// EXP /////////
      input              EXP_EN,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_EMMC_CLK,
      inout              HPS_EMMC_CMD,
      inout    [ 3: 0]   HPS_EMMC_DATA,
      output             HPS_ENETA_MDC,
      inout              HPS_ENETA_MDIO,
      input              HPS_ENETA_RX_CLK,
      input              HPS_ENETA_RX_CTL,
      input    [ 3: 0]   HPS_ENETA_RX_DATA,
      output             HPS_ENETA_TX_CLK,
      output             HPS_ENETA_TX_CTL,
      output   [ 3: 0]   HPS_ENETA_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      input              HPS_OSC_CLK,
      input              HPS_UART_CTS,
      output             HPS_UART_RTS,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);


//=======================================================
//  REG/WIRE declarations
//=======================================================

wire [1: 0] pio_led;
assign LED = ~pio_led;


//=======================================================
//  Structural coding
//=======================================================

pcie_ed u0 (
    .refclk_clk          (MCIO_CONN_CLK_p), //   input,  width = 1,     refclk.clk
    .pin_perst_npor      (~FPGA_RST),       //   input,  width = 1,  pin_perst.npor
    .pin_perst_pin_perst (MCIO_PERST_n),    //   input,  width = 1,           .pin_perst
    .hip_serial_rx_in0   (MCIO_RX_p[0]),    //   input,  width = 1, hip_serial.rx_in0
    .hip_serial_rx_in1   (MCIO_RX_p[1]),    //   input,  width = 1,           .rx_in1
    .hip_serial_rx_in2   (MCIO_RX_p[2]),    //   input,  width = 1,           .rx_in2
    .hip_serial_rx_in3   (MCIO_RX_p[3]),    //   input,  width = 1,           .rx_in3
    .hip_serial_rx_in4   (MCIO_RX_p[4]),    //   input,  width = 1,           .rx_in4
    .hip_serial_rx_in5   (MCIO_RX_p[5]),    //   input,  width = 1,           .rx_in5
    .hip_serial_rx_in6   (MCIO_RX_p[6]),    //   input,  width = 1,           .rx_in6
    .hip_serial_rx_in7   (MCIO_RX_p[7]),    //   input,  width = 1,           .rx_in7
    .hip_serial_tx_out0  (MCIO_TX_p[0]),    //  output,  width = 1,           .tx_out0
    .hip_serial_tx_out1  (MCIO_TX_p[1]),    //  output,  width = 1,           .tx_out1
    .hip_serial_tx_out2  (MCIO_TX_p[2]),    //  output,  width = 1,           .tx_out2
    .hip_serial_tx_out3  (MCIO_TX_p[3]),    //  output,  width = 1,           .tx_out3
    .hip_serial_tx_out4  (MCIO_TX_p[4]),    //  output,  width = 1,           .tx_out4
    .hip_serial_tx_out5  (MCIO_TX_p[5]),    //  output,  width = 1,           .tx_out5
    .hip_serial_tx_out6  (MCIO_TX_p[6]),    //  output,  width = 1,           .tx_out6
    .hip_serial_tx_out7  (MCIO_TX_p[7]),    //  output,  width = 1,           .tx_out7
    .pio_button_export   (~BUTTON),         //   input,  width = 2, pio_button.export
    .pio_led_export      (pio_led),         //  output,  width = 2,    pio_led.export

    // DDR4A
    .emif_s10_ddr4a_local_reset_req_local_reset_req     (1'b1),
    //   input,   width = 1,    emif_s10_ddr4a_local_reset_req.local_reset_req
    .emif_s10_ddr4a_local_reset_status_local_reset_done (),
    //  output,   width = 1, emif_s10_ddr4a_local_reset_status.local_reset_done
    .emif_s10_ddr4a_pll_ref_clk_clk                     (DDR4A_REFCLK_p),
    //   input,   width = 1,        emif_s10_ddr4a_pll_ref_clk.clk
    .emif_s10_ddr4a_oct_oct_rzqin                       (DDR4A_RZQ),
    //   input,   width = 1,                emif_s10_ddr4a_oct.oct_rzqin
    .emif_s10_ddr4a_mem_mem_ck                          (DDR4A_CK),
    //  output,   width = 1,                emif_s10_ddr4a_mem.mem_ck
    .emif_s10_ddr4a_mem_mem_ck_n                        (DDR4A_CK_n),
    //  output,   width = 1,                                  .mem_ck_n
    .emif_s10_ddr4a_mem_mem_a                           (DDR4A_A),
    //  output,  width = 17,                                  .mem_a
    .emif_s10_ddr4a_mem_mem_act_n                       (DDR4A_ACT_n),
    //  output,   width = 1,                                  .mem_act_n
    .emif_s10_ddr4a_mem_mem_ba                          (DDR4A_BA),
    //  output,   width = 2,                                  .mem_ba
    .emif_s10_ddr4a_mem_mem_bg                          (DDR4A_BG),
    //  output,   width = 1,                                  .mem_bg
    .emif_s10_ddr4a_mem_mem_cke                         (DDR4A_CKE),
    //  output,   width = 1,                                  .mem_cke
    .emif_s10_ddr4a_mem_mem_cs_n                        (DDR4A_CS_n),
    //  output,   width = 1,                                  .mem_cs_n
    .emif_s10_ddr4a_mem_mem_odt                         (DDR4A_ODT),
    //  output,   width = 1,                                  .mem_odt
    .emif_s10_ddr4a_mem_mem_reset_n                     (DDR4A_RESET_n),
    //  output,   width = 1,                                  .mem_reset_n
    .emif_s10_ddr4a_mem_mem_par                         (DDR4A_PAR),
    //  output,   width = 1,                                  .mem_par
    .emif_s10_ddr4a_mem_mem_alert_n                     (DDR4A_ALERT_n),
    //   input,   width = 1,                                  .mem_alert_n
    .emif_s10_ddr4a_mem_mem_dqs                         (DDR4A_DQS),
    //   inout,   width = 8,                                  .mem_dqs
    .emif_s10_ddr4a_mem_mem_dqs_n                       (DDR4A_DQS_n),
    //   inout,   width = 8,                                  .mem_dqs_n
    .emif_s10_ddr4a_mem_mem_dq                          (DDR4A_DQ),
    //   inout,  width = 64,                                  .mem_dq
    .emif_s10_ddr4a_mem_mem_dbi_n                       (DDR4A_DBI_n),
    //   inout,   width = 8,                                  .mem_dbi_n
    .emif_s10_ddr4a_status_local_cal_success            (),
    //  output,   width = 1,             emif_s10_ddr4a_status.local_cal_success
    .emif_s10_ddr4a_status_local_cal_fail               (),
    //  output,   width = 1,                                  .local_cal_fail

    // DDR4B
    .emif_s10_ddr4b_local_reset_req_local_reset_req     (1'b1),
    //   input,   width = 1,    emif_s10_ddr4b_local_reset_req.local_reset_req
    .emif_s10_ddr4b_local_reset_status_local_reset_done (),
    //  output,   width = 1, emif_s10_ddr4b_local_reset_status.local_reset_done
    .emif_s10_ddr4b_pll_ref_clk_clk                     (DDR4B_REFCLK_p),
    //   input,   width = 1,        emif_s10_ddr4b_pll_ref_clk.clk
    .emif_s10_ddr4b_oct_oct_rzqin                       (DDR4B_RZQ),
    //   input,   width = 1,                emif_s10_ddr4b_oct.oct_rzqin
    .emif_s10_ddr4b_mem_mem_ck                          (DDR4B_CK),
    //  output,   width = 1,                emif_s10_ddr4b_mem.mem_ck
    .emif_s10_ddr4b_mem_mem_ck_n                        (DDR4B_CK_n),
    //  output,   width = 1,                                  .mem_ck_n
    .emif_s10_ddr4b_mem_mem_a                           (DDR4B_A),
    //  output,  width = 17,                                  .mem_a
    .emif_s10_ddr4b_mem_mem_act_n                       (DDR4B_ACT_n),
    //  output,   width = 1,                                  .mem_act_n
    .emif_s10_ddr4b_mem_mem_ba                          (DDR4B_BA),
    //  output,   width = 2,                                  .mem_ba
    .emif_s10_ddr4b_mem_mem_bg                          (DDR4B_BG),
    //  output,   width = 1,                                  .mem_bg
    .emif_s10_ddr4b_mem_mem_cke                         (DDR4B_CKE),
    //  output,   width = 1,                                  .mem_cke
    .emif_s10_ddr4b_mem_mem_cs_n                        (DDR4B_CS_n),
    //  output,   width = 1,                                  .mem_cs_n
    .emif_s10_ddr4b_mem_mem_odt                         (DDR4B_ODT),
    //  output,   width = 1,                                  .mem_odt
    .emif_s10_ddr4b_mem_mem_reset_n                     (DDR4B_RESET_n),
    //  output,   width = 1,                                  .mem_reset_n
    .emif_s10_ddr4b_mem_mem_par                         (DDR4B_PAR),
    //  output,   width = 1,                                  .mem_par
    .emif_s10_ddr4b_mem_mem_alert_n                     (DDR4B_ALERT_n),
    //   input,   width = 1,                                  .mem_alert_n
    .emif_s10_ddr4b_mem_mem_dqs                         (DDR4B_DQS),
    //   inout,   width = 8,                                  .mem_dqs
    .emif_s10_ddr4b_mem_mem_dqs_n                       (DDR4B_DQS_n),
    //   inout,   width = 8,                                  .mem_dqs_n
    .emif_s10_ddr4b_mem_mem_dq                          (DDR4B_DQ),
    //   inout,  width = 64,                                  .mem_dq
    .emif_s10_ddr4b_mem_mem_dbi_n                       (DDR4B_DBI_n),
    //   inout,   width = 8,                                  .mem_dbi_n
    .emif_s10_ddr4b_status_local_cal_success            (),
    //  output,   width = 1,             emif_s10_ddr4b_status.local_cal_success
    .emif_s10_ddr4b_status_local_cal_fail               ()
    //  output,   width = 1,                                  .local_cal_fail
);



endmodule
