module USB_AUTO_DETECT ( 
 input  CLK_100  , 
 input  RESET , 
 inout [2:0] USBDP_SW_CNF , 
 output  USB_SSFX3_PATH_SELN,
 output  USB_SSFX3_PATH_OEN,
 output  USB20_OE_N  ,
 inout   TYPEC_PD_SLAVE_SCL ,
 inout   TYPEC_PD_SLAVE_SDA , 
 output  USB_ON , 
 output  DP_ON , 
 output  CC_POLARITY ,
 output  reg  USB30_RESET_DELAY   
); 
parameter SEC =100000000 ; 
//=======================================================
//  REG/WIRE declarations
//=======================================================
reg         fx3_oe ;
reg         dp_oe  ;
reg [1: 0]  usbdp_sw;
wire [7: 0] usbdp_sw_reg ;
wire        USB30 ; 
reg [31:0]  DELAY ;

//=======================================================
//  Structural coding
//=======================================================
assign  USB30 = (USBDP_SW_CNF[2:1]==2'b10 )?1:0 ;  
assign  {USB_SSFX3_PATH_SELN,USB_SSFX3_PATH_OEN} = {1'b1, ~USB30 };
assign  USB20_OE_N  = ~USB30 ;
assign  USB_ON      = USB30 ;

//----USB3.0 RESET  DELAY OUTPUT 
always @( negedge USB30 or posedge CLK_100  ) 
if (!USB30) begin 
                 DELAY             <=0 ;
					  USB30_RESET_DELAY <=1 ;//  
            end
else  if ( DELAY < 2*SEC ) 
  begin 
    DELAY<=DELAY +1 ; 
	 USB30_RESET_DELAY  <= (( DELAY > 1*SEC ) && ( DELAY < (3*SEC)/2 ))  ?0:1  ; 
end 


assign  DP_ON       = dp_oe;

assign  CC_POLARITY = USBDP_SW_CNF[0] ;// usbdp_sw_reg[4];


i2cSlave u_i2cSlave(
  .clk( CLK_100      ),
  .rst( RESET ),
  .scl( TYPEC_PD_SLAVE_SCL ),
  .sda( TYPEC_PD_SLAVE_SDA ),
  .myReg0(usbdp_sw_reg)
);

localparam MUX_CONFIG_ISOLATE   = 2'h0;
localparam MUX_CONFIG_SS_ONLY   = 2'h1;
localparam MUX_CONFIG_DP_4_LANE = 2'h2;
localparam MUX_CONFIG_DP_2_LANE = 2'h3;

always @(*) begin
    case (usbdp_sw_reg[6: 5])
        MUX_CONFIG_ISOLATE: begin
            /* Set mux to powerdown state. */
            usbdp_sw = 2'b00;
            fx3_oe   = 1'b0;
            dp_oe    = 1'b0;
        end
        MUX_CONFIG_SS_ONLY: begin
            /* Set mux to USB-only mode state. */
            usbdp_sw = 2'b10;
            fx3_oe   = 1'b1;
            dp_oe    = 1'b0;
        end
        MUX_CONFIG_DP_4_LANE: begin
            /* Set mux to 4-lane DP mode state. */
            usbdp_sw = 2'b01;
            fx3_oe   = 1'b0;
            dp_oe    = 1'b1;
        end
        //MUX_CONFIG_DP_2_LANE: begin
        //    /* Set mux to to 2-lane DP plus USB-only mode state. */
        //    usbdp_sw = 2'b11;
        //    fx3_oe = 1'b1;
        //    dp_oe = 1'b1;
        //end
        default: begin
            usbdp_sw = 2'b00;
            fx3_oe   = 1'b0;
            dp_oe    = 1'b0;
        end
    endcase
end

endmodule 