
//=======================================================
//  This code is generated by Terasic System Builder
//=======================================================

module USBC_FX3(

	//////////// CLOCK //////////
	input 		          		CLKUSR_100,
	input 		          		CLK_50_B2H,
	input 		          		CLK_50_B3H,

	//////////// KEY //////////
	input 		          		CPU_RESET_n,
	input 		     [1:0]		KEY,

	//////////// SW //////////
	input 		     [1:0]		SW,

	//////////// LED //////////
	output		     [1:0]		LED,

	//////////// SEG7 //////////
	output		          		HEX0_DP,
	output		     [6:0]		HEX0_D,
	output		          		HEX1_DP,
	output		     [6:0]		HEX1_D,

	//////////// USB Type-C //////////
	inout 		          		DP_AUX_SEL,
	output		          		DP_AUX_p,
	inout 		          		DP_DX_SEL,
	input 		          		DP_REFCLK_p,
	input 		     [3:0]		DP_RX_p,
	output		     [3:0]		DP_TX_p,
	inout 		          		I2C_INT,
	inout 		          		SRC_DP_HPD,
	input 		          		TYPEC_5V_EN,
	inout 		          		TYPEC_PD_SCL,
	inout 		          		TYPEC_PD_SDA,
	inout 		          		TYPEC_PD_SLAVE_SCL,
	inout 		          		TYPEC_PD_SLAVE_SDA,
	inout 		          		USB20_OE_n,
	inout 		          		USB20_SW,
	input 		     [2:0]		USBDP_SW_CNF,
	output 		          		USBFX3_CTL0_SLCS_n,
	inout 		          		USBFX3_CTL10,
	output 		          		USBFX3_CTL11_A1,
	output 		          		USBFX3_CTL12_A0,
	input 		          		USBFX3_CTL15_INT_n,
	output 		          		USBFX3_CTL1_SLWR_n,
	output 		          		USBFX3_CTL2_SLOE_n,
	output 		          		USBFX3_CTL3_SLRD_n,
	input 		          		USBFX3_CTL4_FLAGA,
	input 		          		USBFX3_CTL5_FLAGB,
	input 		          		USBFX3_CTL6,
	output 		          		USBFX3_CTL7_PKTEND_n,
	input 		          		USBFX3_CTL8,
	input 		          		USBFX3_CTL9,
	inout 		    [31:0]     USBFX3_DQ,
	input 		          		USBFX3_OTG_ID,
	output 		          		USBFX3_PCLK,
	output 		          		USBFX3_RESET_n,
	input 		          		USBFX3_UART_RX,
	output 		          		USBFX3_UART_TX,
	input 		          		USB_HOST_DEV_OE_n,
	input 		          		USB_HOST_DEV_SEL_n,
	input 		          		USB_REFCLK_p,
	input 		          		USB_RX_p,
	inout 		          		USB_SSFX3_PATH_OE_n,
	inout 		          		USB_SSFX3_PATH_SEL_n,
	output		          		USB_TX_p,

	//////////// FAN //////////
	input 		          		FAN_ALERT_n
);



//=======================================================
//  REG/WIRE declarations
//=======================================================
wire       CLK_100 ;
wire       CLK_100_HZ ;
wire [1:0] KEYY ; 
wire       CC_POLARITY ; 
wire       USB_ON  ;
wire       USB_RESET_DELAY  ; 
//=======================================================
//  Structural coding
//=======================================================

//--USB SETTING 

//assign {DP_AUX_SEL,DP_DX_SEL} : 2'b00;  //USB + dp source
                             //   2'b00;  //dp source
                             //   2'b01;  //dp sink
                             //   2'b01;  //USB + dp sink

assign  {DP_AUX_SEL,DP_DX_SEL} = 2'b00; //dp source
assign   USB20_SW              = 1'b1;

//---PLL 100MHZ
pll_100_test p_test(
      .rst     ( ~CPU_RESET_n ),      
      .refclk  ( CLK_50_B3H),		
      .outclk_0( CLK_100), 
      .outclk_1( ),        
      .locked  ( )		
   );
 
//--CLOCK TEST 
CLOCKMEM  g0(  .RESET   (0),  .CLK     ( USBFX3_PCLK  )  , .CLK_FREQ(100000000)  , .CK_1HZ  (CLK_100_HZ) ) ; 

//--KEY DisBounce
BUTDELY  kk0(  .CLK (CLK_50_B3H),  .KEYI(KEY[0]),  .KETO(KEYY[0]) );  
BUTDELY  kk1(  .CLK (CLK_50_B3H),  .KEYI(KEY[1]),  .KETO(KEYY[1]) );  

//--LED DISPLAY
assign  LED =  ~{ USB_ON , CC_POLARITY } ;

//--USB AUTO DETECT
USB_AUTO_DETECT  mc( 
      .CLK_100            (CLK_100            ), 
      .RESET              (~KEYY[1]           ), 
      .USBDP_SW_CNF       (USBDP_SW_CNF       ), 
      .USB_SSFX3_PATH_SELN(USB_SSFX3_PATH_SEL_n),
      .USB_SSFX3_PATH_OEN (USB_SSFX3_PATH_OE_n ),
		.TYPEC_PD_SLAVE_SCL(TYPEC_PD_SLAVE_SCL   ),
		.TYPEC_PD_SLAVE_SDA(TYPEC_PD_SLAVE_SDA  ),
      .USB20_OE_N         (USB20_OE_n         ),
      .USB_ON             (USB_ON           ), 
      .CC_POLARITY        (CC_POLARITY        ) ,
	   .USB30_RESET_DELAY  (USB_RESET_DELAY  ) 	
); 

//--FX3 in/out loop
LOOPBACK fx3(		
           .reset_n ( KEYY[0] &  USB_RESET_DELAY),                           //input reset active low
           .clk_100 ( CLK_100),                           //input clp 50 Mhz
           .fdata   ( USBFX3_DQ),                         //data bus
           .faddr   ( {USBFX3_CTL11_A1, USBFX3_CTL12_A0}),//output fifo address
           .slrd    ( USBFX3_CTL3_SLRD_n),                //output read select
           .slwr    ( USBFX3_CTL1_SLWR_n),                //output write select
           .flaga   ( USBFX3_CTL4_FLAGA),                 //full flag
           .flagb   ( USBFX3_CTL5_FLAGB),                 //partial full flag
           .flagc   ( USBFX3_CTL6),                       //empty flag
           .flagd   ( USBFX3_CTL8),                       //empty partial flag
           .sloe    ( USBFX3_CTL2_SLOE_n),                //output output enable select
           .clk_out ( USBFX3_PCLK),                       //output clk 100 Mhz and 180 phase shift
           .slcs    ( USBFX3_CTL0_SLCS_n),                //output chip select
           .pktend  ( USBFX3_CTL7_PKTEND_n),              //output pkt end
           .reset_n_out( USBFX3_RESET_n)                  //output reset
       ); 
		 
endmodule

