//module CLOCKMEM ( 
//input                CLK ,
//input [31:0]         CLK_FREQ ,
//output reg  			CK_1HZ
//) ;

////---50MHZ CLOCK1 TEST---
//reg  [31:0] CLK_DELAY ; 
////--
//always @(posedge CLK )  
//begin
//	if (CLK_DELAY> CLK_FREQ/2) 
//	begin 
//		CLK_DELAY <=0;  
//		CK_1HZ    <= ~CK_1HZ ;
//	end
//	else   
//		CLK_DELAY <=CLK_DELAY+1;
//end		
//

module CLOCKMEM ( 
input                RESET  , 
input                EN_CAL , 
input                CLK ,
input [31:0]         CLK_FREQ ,
output reg  			CK_1HZ

) ;

parameter  Error_Correction  = 170 ;  // 80 ok 90  , 80(80) .. 70 (4)  .. 60(0) error = 4  per 10(Error_Correction)

//---50MHZ CLOCK1 TEST---
reg  [31:0] CLK_DELAY ; 


//--
always @(posedge   RESET  or posedge CLK )  
if (RESET  ) begin 
     CK_1HZ    <=0; 
	  CLK_DELAY <=0; 
end 
else 
begin
	if ( CLK_DELAY <  CLK_FREQ/2  )  CLK_DELAY  <= CLK_DELAY+1; 
	else 	
	
	begin 
		CLK_DELAY  <= 0;  
		CK_1HZ     <= ~CK_1HZ ;
	end 	
end		
	
endmodule 


	
	