// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Fri Jul 25 14:12:09 2025
// ============================================================================

//`define ENABLE_DDR4A
//`define ENABLE_DDR4B
//`define ENABLE_XCVR
//`define ENABLE_HPS
//`define ENABLE_PCIE
//`define ENABLE_MCIO
//`define ENABLE_QSFPA
//`define ENABLE_QSFPB

module golden_top(

      ///////// CLOCK /////////
      input              CLK_100_B3A,
      input              CLK_100_B3L,
      input              CLK_25_B3L,

      ///////// Buttons /////////
      input    [ 1: 0]   BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   SW,

      ///////// LED /////////
      output   [ 1: 0]   LED, //LED is Low-Active

      ///////// Reset /////////
      input              FPGA_RST,
      input              HPS_RST,

`ifdef ENABLE_DDR4A
      ///////// DDR4A /////////
      input              DDR4A_REFCLK_p,
      output   [16: 0]   DDR4A_A,
      output   [ 1: 0]   DDR4A_BA,
      output   [ 0: 0]   DDR4A_BG,
      output             DDR4A_CK,
      output             DDR4A_CK_n,
      output             DDR4A_CKE,
      inout    [ 7: 0]   DDR4A_DQS,
      inout    [ 7: 0]   DDR4A_DQS_n,
      inout    [63: 0]   DDR4A_DQ,
      inout    [ 7: 0]   DDR4A_DBI_n,
      output             DDR4A_CS_n,
      output             DDR4A_RESET_n,
      output             DDR4A_ODT,
      output             DDR4A_PAR,
      input              DDR4A_ALERT_n,
      output             DDR4A_ACT_n,
      input              DDR4A_RZQ,
`endif /*ENABLE_DDR4A*/

`ifdef ENABLE_DDR4B
      ///////// DDR4B /////////
      input              DDR4B_REFCLK_p,
      output   [16: 0]   DDR4B_A,
      output   [ 1: 0]   DDR4B_BA,
      output   [ 0: 0]   DDR4B_BG,
      output             DDR4B_CK,
      output             DDR4B_CK_n,
      output             DDR4B_CKE,
      inout    [ 7: 0]   DDR4B_DQS,
      inout    [ 7: 0]   DDR4B_DQS_n,
      inout    [63: 0]   DDR4B_DQ,
      inout    [ 7: 0]   DDR4B_DBI_n,
      output             DDR4B_CS_n,
      output             DDR4B_RESET_n,
      output             DDR4B_ODT,
      output             DDR4B_PAR,
      input              DDR4B_ALERT_n,
      output             DDR4B_ACT_n,
      input              DDR4B_RZQ,
`endif /*ENABLE_DDR4B*/

      ///////// USBFX3 /////////
      output             USBFX3_RESET_n,
      output             USBFX3_PCLK,
      output             USBFX3_CTL0_SLCS_n,
      output             USBFX3_UART_TX,
      input              USBFX3_UART_RX,
      output             USBFX3_CTL10,
      output             USBFX3_CTL11_A1,
      output             USBFX3_CTL12_A0,
      input              USBFX3_CTL15_INT_n,
      output             USBFX3_CTL1_SLWR_n,
      output             USBFX3_CTL2_SLOE_n,
      output             USBFX3_CTL3_SLRD_n,
      input              USBFX3_CTL4_FLAGA,
      input              USBFX3_CTL5_FLAGB,
      input              USBFX3_CTL6_FLAGC,
      output             USBFX3_CTL7_PKTEND_n,
      input              USBFX3_CTL8_FLAGD,
      output             USBFX3_CTL9,
      inout    [31: 0]   USBFX3_DQ,
      inout              USBFX3_OTG_ID,
      output             USBFX3_USB_MODE,

      ///////// ENETB /////////
      input              ENETB_RX_CLK,
      input    [ 7: 0]   ENETB_RX_DATA,
      input              ENETB_RX_COL,
      input              ENETB_RX_CRS,
      input              ENETB_RX_DV,
      input              ENETB_RX_ER,
      output             ENETB_GTX_CLK,
      output   [ 7: 0]   ENETB_TX_DATA,
      output             ENETB_TX_EN,
      output             ENETB_TX_ER,
      input              ENETB_INT_n,
      output             ENETB_MDC,
      inout              ENETB_MDIO,
      output             ENETB_RESET_n,

      ///////// I2C for EEPROM (Si5341) /////////
      inout              FPGA_I2C_SCL,
      inout              FPGA_I2C_SDA,

      ///////// Power Monitor /////////
      inout              PM_I2C_SCL,
      inout              PM_I2C_SDA,
      input              PM_ALERT_n,

`ifdef ENABLE_PCIE
      ///////// PCIe Edge /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      input              PCIE_REFCLK_p, //CLK2_XCVR_1C_p
      output   [15: 0]   PCIE_TX_p,
      input    [15: 0]   PCIE_RX_p,
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFPA
      ///////// QSFPA /////////
      input              QSFPA_REFCLK_p, //LGBTCLK2_1L_p
      output   [ 3: 0]   QSFPA_TX_p,
      input    [ 3: 0]   QSFPA_RX_p,
      input              QSFPA_INTERRUPT_n,
      output             QSFPA_LP_MODE,
      input              QSFPA_MOD_PRS_n,
      output             QSFPA_MOD_SEL_n,
      output             QSFPA_RST_n,
      inout              QSFPA_SCL,
      inout              QSFPA_SDA,
`endif /*ENABLE_QSFPA*/

`ifdef ENABLE_QSFPB
      ///////// QSFPB /////////
      input              QSFPB_REFCLK_p, //LGBTCLK1_1M_p
      output   [ 3: 0]   QSFPB_TX_p,
      input    [ 3: 0]   QSFPB_RX_p,
      input              QSFPB_INTERRUPT_n,
      output             QSFPB_LP_MODE,
      input              QSFPB_MOD_PRS_n,
      output             QSFPB_MOD_SEL_n,
      output             QSFPB_RST_n,
      inout              QSFPB_SCL,
      inout              QSFPB_SDA,
`endif /*ENABLE_QSFPB*/

`ifdef ENABLE_XCVR
      ///////// Transceiver reference clock /////////
      input              XCVR_REFCLK1D_p,
      input              XCVR_REFCLK1E_p,
      input              XCVR_REFCLK1K_p,
      input              XCVR_REFCLK1L_p,
      input              XCVR_REFCLK1M_p,
`endif /*ENABLE_XCVR*/

`ifdef ENABLE_MCIO
      ///////// MCIO /////////
      inout              MCIO_SMBCLK,
      inout              MCIO_SMBDAT,
      input              MCIO_CONN_CLK_p, //RGBTCLK0_1K_p
      output   [ 7: 0]   MCIO_TX_p,
      input    [ 7: 0]   MCIO_RX_p,
      input              MCIO_PERST_n,
      input              MCIO_SMB_ALERT_n,
`endif /*ENABLE_MCIO*/

      ///////// EXP /////////
      input              EXP_EN,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_EMMC_CLK,
      inout              HPS_EMMC_CMD,
      inout    [ 3: 0]   HPS_EMMC_DATA,
      output             HPS_ENETA_MDC,
      inout              HPS_ENETA_MDIO,
      input              HPS_ENETA_RX_CLK,
      input              HPS_ENETA_RX_CTL,
      input    [ 3: 0]   HPS_ENETA_RX_DATA,
      output             HPS_ENETA_TX_CLK,
      output             HPS_ENETA_TX_CTL,
      output   [ 3: 0]   HPS_ENETA_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      input              HPS_OSC_CLK,
      input              HPS_UART_CTS,
      output             HPS_UART_RTS,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);


//=======================================================
//  REG/WIRE declarations
//=======================================================




//=======================================================
//  Structural coding
//=======================================================
//LTC2945 Monitor IP
//IP interface
wire       LTC2945_valid  ; 
wire [15:0]LTC2945_voltage;//unit : mv 
wire [15:0]LTC2945_current;//unit : mA 

reg  [15:0]rLTC2945_voltage;//unit : mv 
reg  [15:0]rLTC2945_current;//unit : mA

 LTC2945_INFO  u_LTC2945_INFO(    
    .reset_n(BUTTON[0] ),
    .clk_50 (CLK_50    ),

    // chip i2c interface
    .i2c_scl(PM_I2C_SCL),
    .i2c_sda(PM_I2C_SDA),
          
    // output voltage and current
    .valid  (LTC2945_valid  ),// high when Voltage and Current is valid
    .voltage(LTC2945_voltage),// unit: mV
    .current(LTC2945_current) // unit: mA
);//


always @(posedge CLK_50 ) begin
    if (LTC2945_valid) begin
      rLTC2945_voltage   <=LTC2945_voltage  ; 
      rLTC2945_current   <=LTC2945_current  ; 		   
    end
end

//=======================================================
//  REG/WIRE declarations
//=======================================================
//System Monitor IP
//IP interface
wire        Info_Valid;
wire [15:0] Board_Version	;//A~F.ex BOARD_VERSION = 16'h000b ,express to revB
wire [15:0] MaxCode_Version;//0~F.ex MAX10_VERSION = 16'h0004 ,express to rev4
wire [15:0] CORE_Voltage	;//unit : mv   
wire [15:0] CORE_Current	;//unit : 10mA  
wire [15:0] VOL_1P8        ;//unit : mv   
wire [15:0] CUR_1P8        ;//unit : 1mA  
wire [15:0] Fan_Speed	   ;//unit : rpm  
wire [15:0] Temp_FPGA	   ;//unit : Celsius degree 
wire [15:0] Temp_Board	   ;//unit : Celsius degree 
wire [15:0] PIN_STATUS	   ;//
wire [15:0] Shutdown_flag  ;//unit : Celsius degree
wire [15:0] VOL_3P3    ;//unit : mv  
wire [15:0] CUR_3P3    ;//unit : 1mA 
wire [15:0] VOL_0P9    ;//unit : mv  
wire [15:0] CUR_0P9    ;//unit : 1mA 
wire [15:0] VOL_1P03   ;//unit : mv  
wire [15:0] CUR_1P03   ;//unit : 1mA 
wire [15:0] VOL_1P2_PO ;//unit : mv  
wire [15:0] CUR_1P2_PO ;//unit : 1mA 


//----reg
reg [15:0] rBoard_Version	;
reg [15:0] rMaxCode_Version;
reg [15:0] rCORE_Voltage	;
reg [15:0] rCORE_Current	;
reg [15:0] rFan_Speed	   ;
reg [15:0] rTemp_FPGA	   ; 
reg [15:0] rTemp_Board	   ; 
reg [15:0] rPIN_STATUS	   ; 
reg [15:0] rVOL_1P8	      ;
reg [15:0] rCUR_1P8	      ;
reg [15:0] rShutdown_flag  ;
reg [15:0] rVOL_3P3    ;//unit : mv  
reg [15:0] rCUR_3P3    ;//unit : 1mA 
reg [15:0] rVOL_0P9    ;//unit : mv  
reg [15:0] rCUR_0P9    ;//unit : 1mA 
reg [15:0] rVOL_1P03   ;//unit : mv  
reg [15:0] rCUR_1P03   ;//unit : 1mA 
reg [15:0] rVOL_1P2_PO ;//unit : mv  
reg [15:0] rCUR_1P2_PO ;//unit : 1mA 




//=======================================================
//  Structural coding
//=======================================================
wire CLK_50;
wire locked  ; 

pll iopll_0 (
		.refclk   (CLK_100_B3A),   
		.locked   (locked     ),   
		.rst      (!BUTTON[1]         ),   
		.outclk_0 (CLK_50     )  
	);
                       
BOARD_INFO BOARD_INFO_i(    
             .RESET_N          (BUTTON[0]    ),  // input
             .CLK_50           (CLK_50       ),  // input

             // 4-pin SPI master interface
             .SCLK             (INFO_SPI_SCLK), // output
             .MISO             (INFO_SPI_MISO), // input
             .MOSI             (INFO_SPI_MOSI), // output
             .CS_n             (INFO_SPI_CS_n), // output			 
            // status report (output)
             .Info_Valid       ( Info_Valid     ), //1: following data is valid
             .Board_Version	 ( Board_Version	), //A~F.ex BOARD_VERSION = 16'h000b ,express to revB
             .MaxCode_Version  ( MaxCode_Version), //0~F.ex MAX10_VERSION = 16'h0004 ,express to rev4
             .CORE_Voltage	    ( CORE_Voltage	), //unit : mv   
             .CORE_Current	    ( CORE_Current	), //unit : 10mA 
             .VOL_1P8	       ( VOL_1P8	      ), //unit : mv   			
             .CUR_1P8	       ( CUR_1P8	      ), //unit : mA 			
				 .Fan_Speed	       ( Fan_Speed	   ), //unit : rpm                                     
             .Temp_FPGA	       ( Temp_FPGA	   ), //unit : Celsius degree 
				 .Temp_Board	    ( Temp_Board	   ), //unit : Celsius degree
				 .PIN_STATUS	    ( PIN_STATUS	   ),  
             .Shutdown_flag	 ( Shutdown_flag  ),
             .VOL_3P3          ( VOL_3P3         ),//unit : mv
             .CUR_3P3          ( CUR_3P3         ),//unit : mA
             .VOL_0P9          ( VOL_0P9         ),//unit : mv
             .CUR_0P9          ( CUR_0P9         ),//unit : mA
             .VOL_1P03         ( VOL_1P03        ),//unit : mv		  
             .CUR_1P03         ( CUR_1P03        ),//unit : mA		  
             .VOL_1P2_PO       ( VOL_1P2_PO      ),//unit : mv		  
             .CUR_1P2_PO       ( CUR_1P2_PO      )	//unit : mA	
		
				 
);


always @(posedge CLK_50 ) begin
    if (Info_Valid) begin

		  
      rBoard_Version	 <=Board_Version	;
      rMaxCode_Version<=MaxCode_Version;
      rCORE_Voltage	 <=CORE_Voltage	;
      rCORE_Current	 <=CORE_Current	;
      rFan_Speed	    <=Fan_Speed	   ;
      rTemp_FPGA	    <=Temp_FPGA	   ; 
      rTemp_Board	    <=Temp_Board	   ; 
      rPIN_STATUS	    <=PIN_STATUS	   ; 
      rVOL_1P8	       <=VOL_1P8	      ;
      rCUR_1P8	       <=CUR_1P8	      ;
      rShutdown_flag  <=Shutdown_flag  ;
      rVOL_3P3        <=VOL_3P3        ; 
      rCUR_3P3        <=CUR_3P3        ; 
      rVOL_0P9        <=VOL_0P9        ; 
      rCUR_0P9        <=CUR_0P9        ; 
      rVOL_1P03       <=VOL_1P03       ; 
      rCUR_1P03       <=CUR_1P03       ; 
      rVOL_1P2_PO     <=VOL_1P2_PO     ; 
      rCUR_1P2_PO     <=CUR_1P2_PO     ; 		  
		  
		   
    end
end




endmodule
