module BOARD_INFO (	
input               RESET_N , 
input				     CLK_50,
output 	reg	     MOSI,
input				     MISO,
output	reg 	     CS_n,
output	reg	     SCLK,
  


output	reg         Info_Valid     , 
output	reg  [15:0] Board_Version  ,
output	reg  [15:0] MaxCode_Version,
output	reg  [15:0] PowerIn_Voltage,
output	reg  [15:0] PowerIn_Current,
output	reg  [15:0] CORE_Voltage  , 
output	reg  [15:0] CORE_Current  , 
output	reg  [15:0] Fan_Speed	  , 
output	reg  [15:0] Fan_Speed2    ,
output	reg  [15:0] Temp_FPGA	  , 
output	reg  [15:0] Temp_Board	  ,
output	reg  [15:0] PIN_STATUS	  ,
output	reg  [15:0] Temp_SDM	     ,
output	reg  [15:0] Temp_FTILE12C ,
output	reg  [15:0] Temp_FTILE13A,
output	reg  [15:0] VOL_1P8	     ,
output	reg  [15:0] CUR_1P8	     ,
output	reg  [15:0] Temp_Board2	  ,
output	reg  [15:0] Shutdown_flag ,
output	reg  [15:0] PG_ErrorMask  ,
output   reg  [15:0] Temp_POWER    ,
output   reg  [15:0] VOL_3P3       ,
output   reg  [15:0] CUR_3P3       ,
output   reg  [15:0] VOL_0P9       ,
output   reg  [15:0] CUR_0P9       ,
output   reg  [15:0] VOL_1P03      ,
output   reg  [15:0] CUR_1P03      ,
output   reg  [15:0] VOL_1P2_PO    ,
output   reg  [15:0] CUR_1P2_PO    ,
//--test 
output            SPI_SYS_CLK,
output  reg [3:0]  ST,
output  reg [15:0] COUNTER , 
output  reg [15:0] DEV_NUN,
output  reg[23:0]  RDATA , 
output  reg        WR ,
output  reg [6:0]  REGI ,
output  reg        READY 

				);
					
parameter DEV_END          = 28; 

parameter [23:0]  P_Board_Version  ={1'b1 ,7'd0 ,16'h0} ;  
parameter [23:0]  P_MaxCode_Version={1'b1 ,7'd1 ,16'h0} ;  
parameter [23:0]  P_PowerIn_Voltage={1'b1 ,7'd2 ,16'h0} ;  
parameter [23:0]  P_PowerIn_Current={1'b1 ,7'd3 ,16'h0} ;  
parameter [23:0]  P_CORE_Voltage   ={1'b1 ,7'd4 ,16'h0} ;  
parameter [23:0]  P_CORE_Current   ={1'b1 ,7'd5 ,16'h0} ;  
parameter [23:0]  P_Fan_Speed	     ={1'b1 ,7'd6 ,16'h0} ;  
parameter [23:0]  P_Fan_Speed2     ={1'b1 ,7'd7 ,16'h0} ;  
parameter [23:0]  P_Temp_FPGA	     ={1'b1 ,7'd8 ,16'h0} ;  
parameter [23:0]  P_Temp_Board	  ={1'b1 ,7'd9 ,16'h0} ;  
parameter [23:0]  P_PIN_STATUS	  ={1'b1 ,7'd10 ,16'h0} ; 
parameter [23:0]  P_Temp_SDM	     ={1'b1 ,7'd11 ,16'h0} ; 
parameter [23:0]  P_Temp_FTILE12C  ={1'b1 ,7'd12 ,16'h0} ; 
parameter [23:0]  P_Temp_FTILE13A  ={1'b1 ,7'd13 ,16'h0} ; 
parameter [23:0]  P_VOL_1P8	     ={1'b1 ,7'd14 ,16'h0} ; //
parameter [23:0]  P_CUR_1P8	     ={1'b1 ,7'd15 ,16'h0} ; //
parameter [23:0]  P_Temp_Board2	  ={1'b1 ,7'd16 ,16'h0} ; 
parameter [23:0]  P_Shutdown_flag  ={1'b1 ,7'd17 ,16'h0} ; 
parameter [23:0]  P_PG_ErrorMask   ={1'b1 ,7'd18 ,16'h0} ; 
parameter [23:0]  P_Temp_POWER     ={1'b1 ,7'd19 ,16'h0} ; 
parameter [23:0]  P_VOL_3P3        ={1'b1 ,7'd20 ,16'h0} ; 
parameter [23:0]  P_CUR_3P3        ={1'b1 ,7'd21 ,16'h0} ; 
parameter [23:0]  P_VOL_0P9        ={1'b1 ,7'd22 ,16'h0} ; 
parameter [23:0]  P_CUR_0P9        ={1'b1 ,7'd23 ,16'h0} ; 
parameter [23:0]  P_VOL_1P03       ={1'b1 ,7'd24 ,16'h0} ; 
parameter [23:0]  P_CUR_1P03       ={1'b1 ,7'd25 ,16'h0} ; 
parameter [23:0]  P_VOL_1P2_PO     ={1'b1 ,7'd26 ,16'h0} ; 
parameter [23:0]  P_CUR_1P2_PO     ={1'b1 ,7'd27 ,16'h0} ; 

                                               

//		        if ( REG ==7'd00) { MISO, SPIo[23:9]}<=Board_Version  ; //read Board_Version  
//              if ( REG ==7'd01) { MISO, SPIo[23:9]}<=MaxCode_Version; //read MaxCode_Version
//              if ( REG ==7'd02) { MISO, SPIo[23:9]}<=PowerIn_Voltage; //read PowerIn_Voltage
//		        if ( REG ==7'd03) { MISO, SPIo[23:9]}<=PowerIn_Current; //read PowerIn_Current
//              if ( REG ==7'd04) { MISO, SPIo[23:9]}<=CORE_Voltage   ; //read CORE_Voltage   
//              if ( REG ==7'd05) { MISO, SPIo[23:9]}<=CORE_Current   ; //read CORE_Current   
//		        if ( REG ==7'd06) { MISO, SPIo[23:9]}<=Fan_Speed      ; //read Fan_Speed      
//		        if ( REG ==7'd07) { MISO, SPIo[23:9]}<=Fan_Speed2     ; //read Fan_Speed2     
//		        if ( REG ==7'd08) { MISO, SPIo[23:9]}<=Temp_FPGA      ; //read Temp_FPGA      
//		        if ( REG ==7'd09) { MISO, SPIo[23:9]}<=Temp_Board     ; //read Temp_Board     
//		        if ( REG ==7'd10) { MISO, SPIo[23:9]}<=PIN_STATUS     ; //read PIN_STATUS     
//		        if ( REG ==7'd11) { MISO, SPIo[23:9]}<=Temp_SDM       ; //read Temp_SDM       
//				  if ( REG ==7'd12) { MISO, SPIo[23:9]}<=Temp_ETILE     ; //readTemp_ETILE     
//				  if ( REG ==7'd13) { MISO, SPIo[23:9]}<=Temp_PTILE     ; //readTemp_PTILE     
//				  if ( REG ==7'd14) { MISO, SPIo[23:9]}<=CORE_Voltage2  ; //readCORE_Voltage2  
//				  if ( REG ==7'd15) { MISO, SPIo[23:9]}<=CORE_Current2  ; //readCORE_Current2  
//				  if ( REG ==7'd16) { MISO, SPIo[23:9]}<=Temp_Board2    ; //read Temp_Board2  
//				  if ( REG ==7'd17) { MISO, SPIo[23:9]}<=Shutdown_flag  ; //read Shutdown_flag				  
//				  if ( REG ==7'd18) { MISO, SPIo[23:9]}<=PG_ErrorMask    ; //read PG_ErrorMask         
//				  if ( REG ==7'd19) { MISO, SPIo[23:9]}<=Temp_POWER     ; //read Temp_POWER         
//				  if ( REG ==7'd20) { MISO, SPIo[23:9]}<=VOL_3P3        ; //read VOL_3P3            
//				  if ( REG ==7'd21) { MISO, SPIo[23:9]}<=CUR_3P3        ; //read CUR_3P3            
//				  if ( REG ==7'd22) { MISO, SPIo[23:9]}<=VOL_0P9        ; //read VOL_0P9            
//				  if ( REG ==7'd23) { MISO, SPIo[23:9]}<=CUR_0P9        ; //read CUR_0P9            
//				  if ( REG ==7'd24) { MISO, SPIo[23:9]}<=VOL_1P03       ; //read VOL_1P03           
//				  if ( REG ==7'd25) { MISO, SPIo[23:9]}<=CUR_1P03       ; //read CUR_1P03           
//				  if ( REG ==7'd26) { MISO, SPIo[23:9]}<=VOL_1P2_PO     ; //read VOL_1P2_PO         
//				  if ( REG ==7'd27) { MISO, SPIo[23:9]}<=CUR_1P2_PO     ; //read CUR_1P2_PO   
//
//=======================================================
//  REG/WIRE declarations
//=======================================================
				 
reg [23:0] CREG ;
reg [31:0] DELAY ;   
//=======================================================
// Structural coding
//=======================================================

CLOCKMEM CLOCKMEM_inst(  .RESET_n  (1),  .CLK (CLK_50),.CLK_FREQ (50),.CK_1HZ   (SPI_SYS_CLK) ) ;//1 MHZ

//--SPI Master
always@( negedge RESET_N or posedge SPI_SYS_CLK )
   if ( !RESET_N) begin 
	   ST              <=0; 
		DEV_NUN         <=0;
		CS_n            <=1; 
		SCLK            <=0;
		MOSI            <=0;

      Board_Version <=0;
      MaxCode_Version<=0;
      PowerIn_Voltage<=0;
      PowerIn_Current<=0;
      CORE_Voltage  <=0;
      CORE_Current  <=0;
      Fan_Speed	  <=0;	
      Fan_Speed2    <=0;
      Temp_FPGA	  <=0;	
      Temp_Board	  <=0;
      PIN_STATUS	  <=0;
      Temp_SDM	     <=0;
      Temp_FTILE12C <=0;
      Temp_FTILE13A <=0;
      VOL_1P8	     <=0;
      CUR_1P8	     <=0;
      Temp_Board2	  <=0;
      Shutdown_flag <=0;
      PG_ErrorMask  <=0;
      Temp_POWER    <=0;
      VOL_3P3       <=0;
      CUR_3P3       <=0;
      VOL_0P9       <=0;
      CUR_0P9       <=0;
      VOL_1P03      <=0;
      CUR_1P03      <=0;
      VOL_1P2_PO    <=0;
      CUR_1P2_PO    <=0;
      Info_Valid     <=0;
		
		
		
		
	end 
else 
begin
case (ST)
0:begin 
      Info_Valid <=0;
      ST         <=1;
		SCLK       <=0;
		COUNTER    <=24;
		RDATA      <=0;                                                  
		     if  (DEV_NUN ==0 )  {WR,REGI,CREG  } <= {P_Board_Version  [23],P_Board_Version  [22:16],P_Board_Version  [23:0]} ;
		else if  (DEV_NUN ==1 )  {WR,REGI,CREG  } <= {P_MaxCode_Version[23],P_MaxCode_Version[22:16],P_MaxCode_Version[23:0]} ;
		else if  (DEV_NUN ==2 )  {WR,REGI,CREG  } <= {P_PowerIn_Voltage[23],P_PowerIn_Voltage[22:16],P_PowerIn_Voltage[23:0]} ;
		else if  (DEV_NUN ==3 )  {WR,REGI,CREG  } <= {P_PowerIn_Current[23],P_PowerIn_Current[22:16],P_PowerIn_Current[23:0]} ;
		else if  (DEV_NUN ==4 )  {WR,REGI,CREG  } <= {P_CORE_Voltage   [23],P_CORE_Voltage   [22:16],P_CORE_Voltage   [23:0]} ;
		else if  (DEV_NUN ==5 )  {WR,REGI,CREG  } <= {P_CORE_Current   [23],P_CORE_Current   [22:16],P_CORE_Current   [23:0]} ;
		else if  (DEV_NUN ==6 )  {WR,REGI,CREG  } <= {P_Fan_Speed	   [23],P_Fan_Speed	    [22:16],P_Fan_Speed	     [23:0]} ;
		else if  (DEV_NUN ==7 )  {WR,REGI,CREG  } <= {P_Fan_Speed2     [23],P_Fan_Speed2     [22:16],P_Fan_Speed2     [23:0]} ;
		else if  (DEV_NUN ==8 )  {WR,REGI,CREG  } <= {P_Temp_FPGA	   [23],P_Temp_FPGA	    [22:16],P_Temp_FPGA	     [23:0]} ;
		else if  (DEV_NUN ==9 )  {WR,REGI,CREG  } <= {P_Temp_Board	   [23],P_Temp_Board	    [22:16],P_Temp_Board	  [23:0]} ;
		else if  (DEV_NUN ==10)  {WR,REGI,CREG  } <= {P_PIN_STATUS	   [23],P_PIN_STATUS	    [22:16],P_PIN_STATUS	  [23:0]} ;
		else if  (DEV_NUN ==11)  {WR,REGI,CREG  } <= {P_Temp_SDM	      [23],P_Temp_SDM	    [22:16],P_Temp_SDM	     [23:0]} ;
		else if  (DEV_NUN ==12)  {WR,REGI,CREG  } <= {P_Temp_FTILE12C  [23],P_Temp_FTILE12C  [22:16],P_Temp_FTILE12C  [23:0]} ;
		else if  (DEV_NUN ==13)  {WR,REGI,CREG  } <= {P_Temp_FTILE13A  [23],P_Temp_FTILE13A  [22:16],P_Temp_FTILE13A  [23:0]} ;
		else if  (DEV_NUN ==14)  {WR,REGI,CREG  } <= {P_VOL_1P8	     	[23],P_VOL_1P8	     	 [22:16],P_VOL_1P8	     [23:0]} ;
		else if  (DEV_NUN ==15)  {WR,REGI,CREG  } <= {P_CUR_1P8	     	[23],P_CUR_1P8	     	 [22:16],P_CUR_1P8	     [23:0]} ;
		else if  (DEV_NUN ==16)  {WR,REGI,CREG  } <= {P_Temp_Board2	   [23],P_Temp_Board2	 [22:16],P_Temp_Board2	  [23:0]} ;
		else if  (DEV_NUN ==17)  {WR,REGI,CREG  } <= {P_Shutdown_flag  [23],P_Shutdown_flag  [22:16],P_Shutdown_flag  [23:0]} ;
		else if  (DEV_NUN ==18)  {WR,REGI,CREG  } <= {P_PG_ErrorMask   [23],P_PG_ErrorMask   [22:16],P_PG_ErrorMask   [23:0]} ;
		else if  (DEV_NUN ==19)  {WR,REGI,CREG  } <= {P_Temp_POWER     [23],P_Temp_POWER     [22:16],P_Temp_POWER     [23:0]} ;
		else if  (DEV_NUN ==20)  {WR,REGI,CREG  } <= {P_VOL_3P3        [23],P_VOL_3P3        [22:16],P_VOL_3P3        [23:0]} ;
		else if  (DEV_NUN ==21)  {WR,REGI,CREG  } <= {P_CUR_3P3        [23],P_CUR_3P3        [22:16],P_CUR_3P3        [23:0]} ;
		else if  (DEV_NUN ==22)  {WR,REGI,CREG  } <= {P_VOL_0P9        [23],P_VOL_0P9        [22:16],P_VOL_0P9        [23:0]} ;
		else if  (DEV_NUN ==23)  {WR,REGI,CREG  } <= {P_CUR_0P9        [23],P_CUR_0P9        [22:16],P_CUR_0P9        [23:0]} ;
		else if  (DEV_NUN ==24)  {WR,REGI,CREG  } <= {P_VOL_1P03       [23],P_VOL_1P03       [22:16],P_VOL_1P03       [23:0]} ;
		else if  (DEV_NUN ==25)  {WR,REGI,CREG  } <= {P_CUR_1P03       [23],P_CUR_1P03       [22:16],P_CUR_1P03       [23:0]} ;
		else if  (DEV_NUN ==26)  {WR,REGI,CREG  } <= {P_VOL_1P2_PO     [23],P_VOL_1P2_PO     [22:16],P_VOL_1P2_PO     [23:0]} ;
		else if  (DEV_NUN ==27)  {WR,REGI,CREG  } <= {P_CUR_1P2_PO     [23],P_CUR_1P2_PO     [22:16],P_CUR_1P2_PO     [23:0]} ;
	                       
  end 
1:begin 
       CS_n  <= 0; 
       ST<=2;
  end 
2:begin 
			
         {MOSI,CREG[23:0]} <= {CREG[23:0], 1'b0} ; //write to slave
         ST<=3;
  end 
3:begin 
		   SCLK  <=1;
		   if ( WR )  RDATA[23:0]  <= {RDATA[22:0], MISO} ; //read from slave
         COUNTER<=COUNTER-1;
         ST<=4;
  end 
4:begin 
        SCLK  <=0;
        if    ( COUNTER!=0)  ST<=2 ; 
        else  begin 
		    ST<=5; 
			 CS_n   <=1;
		  end 
  end 
5:begin 
        if ( REGI[6:0] ==0 ) Board_Version  <= RDATA[15:0]; //read Board_Version  
        if ( REGI[6:0] ==1 ) MaxCode_Version<= RDATA[15:0]; //read MaxCode_Version
        if ( REGI[6:0] ==2 ) PowerIn_Voltage<= RDATA[15:0]; //read PowerIn_Voltage
        if ( REGI[6:0] ==3 ) PowerIn_Current<= RDATA[15:0]; //read PowerIn_Current
        if ( REGI[6:0] ==4 ) CORE_Voltage   <= RDATA[15:0]; //read CORE_Voltage   
        if ( REGI[6:0] ==5 ) CORE_Current   <= RDATA[15:0]; //read CORE_Current   
        if ( REGI[6:0] ==6 ) Fan_Speed	     <= RDATA[15:0]; //read Fan_Speed         
        if ( REGI[6:0] ==7 ) Fan_Speed2     <= RDATA[15:0]; //read Fan_Speed         
        if ( REGI[6:0] ==8 ) Temp_FPGA	     <= RDATA[15:0]; //read Temp_FPGA      
        if ( REGI[6:0] ==9 ) Temp_Board	  <= RDATA[15:0]; //read Temp_Board     
        if ( REGI[6:0] ==10) PIN_STATUS	  <= RDATA[15:0]; //read PIN_STATUS     
        if ( REGI[6:0] ==11) Temp_SDM	     <= RDATA[15:0]; //read Temp_SDM       
        if ( REGI[6:0] ==12) Temp_FTILE12C  <= RDATA[15:0]; //read Temp_FTILE12C     
        if ( REGI[6:0] ==13) Temp_FTILE13A  <= RDATA[15:0]; //read Temp_FTILE13A     
        if ( REGI[6:0] ==14) VOL_1P8	     <= RDATA[15:0]; //read CORE_Voltage2  
        if ( REGI[6:0] ==15) CUR_1P8	     <= RDATA[15:0]; //read CORE_Current2      
        if ( REGI[6:0] ==16) Temp_Board2	  <= RDATA[15:0]; //read Temp_Board2     
        if ( REGI[6:0] ==17) Shutdown_flag  <= RDATA[15:0]; //read Shutdown_flag		  
        if ( REGI[6:0] ==18) PG_ErrorMask   <= RDATA[15:0]; //read Temp_POWER
        if ( REGI[6:0] ==19) Temp_POWER     <= RDATA[15:0]; //read Board_Version  
        if ( REGI[6:0] ==20) VOL_3P3        <= RDATA[15:0]; //read MaxCode_Version
        if ( REGI[6:0] ==21) CUR_3P3        <= RDATA[15:0]; //read PowerIn_Voltage
        if ( REGI[6:0] ==22) VOL_0P9        <= RDATA[15:0]; //read PowerIn_Current
        if ( REGI[6:0] ==23) CUR_0P9        <= RDATA[15:0]; //read CORE_Voltage   
        if ( REGI[6:0] ==24) VOL_1P03       <= RDATA[15:0]; //read CORE_Current   
        if ( REGI[6:0] ==25) CUR_1P03       <= RDATA[15:0]; //read Fan_Speed         
        if ( REGI[6:0] ==26) VOL_1P2_PO     <= RDATA[15:0]; //read Fan_Speed         
        if ( REGI[6:0] ==27) CUR_1P2_PO     <= RDATA[15:0]; //read Temp_FPGA      
                             
		  DEV_NUN  <=DEV_NUN  +1 ; 		    
        ST<=6 ;		  
		  DELAY <=0;       
end
6: begin
         DELAY <=DELAY+1; 
           if  ( DELAY ==5 )   begin  
			  if ( DEV_NUN == DEV_END) ST<=7;
			  else ST<=0; 
			end 
	end		
		    
7: begin
			ST          <= 8;  
			Info_Valid  <= 1 ; 
        	DELAY       <= 0;       
		   DEV_NUN     <= 0 ;			  
   end 
8: begin

          DELAY <=DELAY+1; 
         if  ( DELAY == 1000 ) begin //delay 1ms 
			      ST <= 0;
			end			 
   end 	
	
endcase
end

endmodule
