module LTC2945_INFO ( 
   input   reset_n , 
	input   clk_50,
	
	
   // chip i2c interface
    inout    i2c_scl,
    inout    i2c_sda,

    // output voltage and current
    output      reg  valid=0,  // high when Voltage and Current is valid
    output    [15:0] voltage, // unit: mV
    output    [15:0] current // unit: mA
	 ,input  INT_n,

//----Test or ST-BUS --- 
   output reg [7:0] CONTROL , 
	output  [15:0]   DSENSE  , 
	output  [15:0]   VIN     , 
	output  [23:0]   POWER   , 
	
	output reg [7:0] STATUS , 
	
   
	//test
//	output      CLK_400K ,
   output reg  I2C_LO0P,
   output reg [5:0] ST ,
   output reg [2:0] CNT,
	output reg [2:0] WCNT,
   output reg [7:0] W_WORD_DATA,
   output reg [7:0] W_POINTER_REG,
	
	output           W_WORD_END ,
   output reg       W_WORD_GO ,
	
   output [7:0]     R_DATA,
	output           SDAI_W ,
	output           TR,
   output           CLK_400K
		
	
	);
	
	
CLOCKMEM CLOCKMEM_inst(  .RESET_n  (1),  .CLK (clk_50),.CLK_FREQ (125),.CK_1HZ (CLK_400K) ) ;//1 MHZ
		
// ADC with a full-scale sense voltage of 102.4mV for 12bitADC	
//ADC with a full-scale input range of 102.4V. for 12bitADC	
	
//----   I   = 411(Sense) *25uV/0.006 =1.71A  ----   
//-----  Vin = 476*25mV = 11.9V	 ----
 //assign DSENSE_V   =  (DSENSE * 25) ;//uV
 //--VIEW Power-Volt-Amp
 assign current    = (DSENSE*25)/3        ;//mA
 assign voltage    =  VIN * 25            ;//mV
 assign POWER_     = ((100 * current* voltage)/10000 );               //P*100
 
	
  
//======== Main-ST ======

//==Pointer NUM==
parameter    SLAVE_ADDR    =8'hD4;  


//-REGISTER-
parameter    P_POWER_MSB2      =8'h05; //Power MSB2 Data
parameter    P_POWER_MSB1      =8'h06; //Power MSB1 Data
parameter    P_POWER_LSB       =8'h07; //Power LSB Data
parameter    P_CONTROL         =8'h00; //Controls ADC Operation Mode and Test Mode
parameter    P_DSENSE_MSB      =8'h14;
parameter    P_DSENSE_LSB      =8'h15;
parameter    P_VIN_MSB         =8'h1e;
parameter    P_STATUS          =8'h02;

//----


reg [31:0] DELY ; 

always @(negedge reset_n or posedge CLK_400K )begin 
if (!reset_n  )  
 begin 
   ST   <=0;
   R_GO  <=1 ;		 
	W_WORD_GO <=1;
	WCNT <=0;  
	CNT        <=0;
	DELY       <=0 ;
	SENSE0_VIN1<=0;
	valid      <=0;
	
 end 	
else 
case (ST)
0: begin 
   ST        <=30; //to write register
   R_GO      <=1 ;		 
	W_WORD_GO <=1;
	WCNT      <=0;  
	CNT       <=0;
	DELY      <=0 ; 

	
   end
//<----------------READ -------	
1: begin 
   DELY  <=DELY +1; 
   if ( DELY ==5 )  ST<=5; //read 
	end	
5: begin 
         ST   <= 6; 
         valid<= 0; 
   end //delay
	
//read DATA 		 
6: begin 
	if ( R_END ) begin  R_GO  <=0; ST<=7 ; DELY<=0;end
	end                
7: begin 
    DELY  <=DELY +1;
    if ( DELY ==2 ) begin 	 
    R_GO  <=1;
    ST<=8 ; 
	 end
	 
	end       
8: begin 
   ST<=9 ; 
	end       
	
9: begin 
   if  ( R_END ) begin 
	  ST    <=10 ; 	
	  valid <=1;
	end 
  end	
10: begin  
           ST      <=29; 
		     DELY    <=0;			  
           R_GO         <=1 ;		 
	        W_WORD_GO    <=1;    
		  
		  
	 end //delay
//<----------------------------------READ-----------------------	  
//<----------------------------------WRITE WORD-----------------
29: begin 
    
    if (DELY < 10 ) DELY <=DELY+1; 
	 else  begin ST<=30;  SENSE0_VIN1<=~SENSE0_VIN1 ; end 
    end	

30: begin 
    ST     <=31; 
	 WCNT   <=0 ; 	 
	 CONTROL<= { 1'b1 , 1'b0 , SENSE0_VIN1  ,1'b0 , 4'h5 } ;   // Snapshot Mode Enabled
	 //CONTROL <= { 1'b0 , 1'b0 , SENSE0_VIN1  ,1'b0 , 4'h5 } ; // Continuous Scan Mode
	 
    end	
31: begin 
		   if ( ( CNT ==0 ) && ( WCNT==0)) begin {W_POINTER_REG[7:0] ,W_WORD_DATA[7:0]} <= {P_CONTROL  , CONTROL };  end	 			
	   if (  W_WORD_END ) begin  W_WORD_GO  <=0; ST<=32 ;  DELY<=0;  end
	end                // Write ID pointer 
32: begin 
    DELY  <=DELY +1;
    if  ( DELY ==3 ) begin 
       W_WORD_GO  <=1;
       ST<=33 ; 
	 end
	 
	end       
33: begin 
    ST<=34 ; 
	end       	
34: begin 
     if  ( W_WORD_END )  begin 	
			 WCNT<=WCNT+1 ;			 
			 ST<=35 ; 
	  end
	end              
35: begin 
     if (WCNT ==1)  begin 
	               ST<=1 ;  
					   WCNT <=0;  				 
		  end 
	 else  ST<=31 ; 	 
	 end 
endcase 
end
//<-----------------------------MAIN-ST END ------------------------------------------
//I2C-BUS
wire const_zero_sig/* synthesis keep */ ; 
assign const_zero_sig = 0 ;
wire   SDAO ,SCLO; 
assign SCLO          = W_WORD_SCL  & R_SCL;
assign SDAO          = W_WORD_SDAO & R_SDAO;
assign i2c_sda = (SDAO)?1'bz :const_zero_sig; 
assign i2c_scl = (SCLO)?1'bz :const_zero_sig; 



//==== I2C WRITE WORD ===

wire   W_WORD_SCL /* synthesis keep */; 
wire   W_WORD_SDAO /* synthesis keep */;  

I2C_WRITE_BYTE_LTC2945  u_I2C_WRITE_BYTE_LTC2945(
   .RESET_N      (reset_n),
	.PT_CK        (CLK_400K),
	.GO           (W_WORD_GO),
	.LIGHT_INT    (),
	.POINTER      (W_POINTER_REG),
   .WDATA8	     (W_WORD_DATA),
	.SLAVE_ADDRESS(SLAVE_ADDR ),
	.SDAI         (i2c_sda),
	.SDAO         (W_WORD_SDAO),
	.SCLO         (W_WORD_SCL ),
	.END_OK       (W_WORD_END)
	//--for test 
	//.ACK_OK()
//	.SDAI_W (SDAI_W )
);


//==== I2C READ ===

wire R_SCL/* synthesis keep */; 
wire R_END; 
reg  R_GO; 
wire R_SDAO/* synthesis keep */;  
reg  SENSE0_VIN1 ; 

 I2C_READ_PAGE_LTC2945  u_I2C_READ_PAGE_LTC2945 (
   .SENSE0_VIN1(SENSE0_VIN1),
   .RESET_N      (reset_n),
	.PT_CK        (CLK_400K    ),
	.GO           (R_GO        ),
	.SLAVE_ADDRESS(SLAVE_ADDR  ),
	.SDAI         (i2c_sda     ),
	.SDAO         (R_SDAO      ),
	.SCLO         (R_SCL),
	.END_OK       (R_END),
	.DATA8        (R_DATA),	

	
	//---add output 8 bit 
	.CONTROL  (),//00h CONTROL 
	.STATUS   (),//02h STATUS 
	.SENSE_MSB(),//14h SENSE_MSB
	.SENSE_LSB(),//15h SENSE_LSB
	.VIN_MSB  (),//1Eh VIN_MSB
	.VIN_LSB  (), //1Fh VIN_LSB
	//---add output 16 bit 
   .SENSE    (DSENSE),
   .VIN      (VIN   ),
	.POWER    (POWER),
	
	//-----add 
	.NO_COMPL(),
	//for TEST
	.ST    (),
	.ACK_OK(),
	.CNT   (),
	.A     (),
	.BYTE  (),
	.TR    (TR) //7.5HZ
	
	
);
	
endmodule
	