module I2C_READ_PAGE_LTC2945 (
   input             SENSE0_VIN1,
   input  				RESET_N ,
	input       		PT_CK,
	input       [7:0]	SLAVE_ADDRESS ,
	input       		GO,
	input       		SDAI,
	output reg  		SDAO,
	output reg  		SCLO,
	output reg  		END_OK , 
	output reg  [7:0] DATA8 , 
	//for TEST
	output reg  [3:0] ST ,
	output reg        ACK_OK,
	output reg  [3:0] CNT,
	output reg  [8:0] A ,
	output reg  [5:0] BYTE,
	
	//---add output 8 bit 
	output reg  [7:0] CONTROL,    //00h CONTROL 
	output reg  [7:0] STATUS,     //02h STATUS 
	output reg  [7:0] SENSE_MSB=0,//14h SENSE_MSB
	output reg  [7:0] SENSE_LSB=0,//15h SENSE_LSB
	output reg  [7:0] VIN_MSB=0,  //1Eh VIN_MSB
	output reg  [7:0] VIN_LSB=0,  //1Fh VIN_LSB
	output reg  [7:0] POWER_MSB2=0,
	output reg  [7:0] POWER_MSB1=0,
	output reg  [7:0] POWER_LSB =0,
	
	//---add output 16 bit 
   output reg  [15:0] SENSE=0,
   output reg  [15:0] VIN  =0,
	output reg  [23:0] POWER=0,	
	
	//-----add 
	output reg   NO_COMPL,
	output TR 
	
	
);

//==================================================
parameter  END_BYTE =8'h31 ;
//==================================================

reg     [2:0] DELY ;    //ST DELAY
assign  TR = CONTROL[3] ; 

always @( negedge RESET_N or posedge  PT_CK )begin
if (!RESET_N  ) begin 
            ST <=0;
	  		   SDAO     <=1; 
	         SCLO    <=1;
	         ACK_OK  <=0;
	         CNT     <=0;
	         END_OK  <=1;
	         BYTE    <=0;
			   DATA8   <=0;
			   NO_COMPL<=0; //<--- ADD
	         SENSE_MSB <=0;
	         SENSE_LSB <=0;
	         VIN_MSB   <=0;
	         VIN_LSB   <=0;
	         POWER_MSB2<=0;
	         POWER_MSB1<=0;
	         POWER_LSB <=0;
            SENSE     <=0;
            VIN       <=0;
	         POWER     <=0;	
				
	 end 
else 
	  case (ST)
	    0: begin  
		      SDAO      <=1; 
	         SCLO      <=1;
	         ACK_OK    <=0;
	         CNT       <=0;
	         END_OK    <=1;
	         BYTE      <=0;
			   DATA8     <=0;
			   NO_COMPL  <=0; //<--- ADD
	         SENSE_MSB <=0;
	         SENSE_LSB <=0;
	         VIN_MSB   <=0;
	         VIN_LSB   <=0;
	         POWER_MSB2<=0;
	         POWER_MSB1<=0;
	         POWER_LSB <=0;
            SENSE     <=0;
            VIN       <=0;
	         POWER     <=0;
	         if (GO) ST<=14 ;							
		    end		  
	  //----I2C READ-COMMAND---
	    1: begin  //start 
		      ST <=2 ; 
			   { SDAO,  SCLO } <= 2'b01; 
				A <= {SLAVE_ADDRESS | 1  ,1'b1 };//READ COMMAND
		    end
	    2: begin  //start
			   { SDAO,  SCLO } <= 2'b00;  
				ST <=3 ;				  
		    end				 
			 
	    3: begin  //start 
		      ST <=4 ; 
			   { SDAO, A } <= { A ,1'b0 }; 
		    end
	    4: begin
		      ST <=5 ; 
			   SCLO <= 1'b1 ; 
				CNT <= CNT +1 ;
		    end
			 
	    5: begin  
			   SCLO <= 1'b0 ; 
			   if (CNT ==9) begin
				     
					 if ( !SDAI ) begin ACK_OK <=1 ;  ST <= 6 ; end //<--add
					 else begin  ACK_OK <=0 ; ST <= 10 ;end //<--add
				 end
				 else ST <= 2;
		    end			 
     //-----DATA READ---
	    6: begin 
		      ST <=7 ; 
			   {SDAO , SCLO} <= 2'b10; 
				CNT <=0 ;
		    end
	    7: begin  
		      ST <=8 ;  
				DELY <=0;
			    SCLO <= 1'b1 ; 
				  if (CNT!=8) DATA8[7:0]  <= { DATA8[6:0], SDAI };
				CNT <= CNT +1 ;
		    end			 
	    8: begin  		 
		    DELY <=DELY+1 ;
			 SCLO <= 1'b0 ; 
			 if (DELY ==2)  begin 			    
			    if (CNT ==8) begin
				      ST <= 7;
				           //------
							       
									 // NO_COMPL<=0; //Continuous Scan Mode
				                if ((BYTE  == 0  ) && ( DATA8[3])) begin NO_COMPL<=1; SDAO <= 1'b1 ; end //Snapshot Mode Enabled
					       else if (BYTE  == END_BYTE )   SDAO <= 1'b1 ; 
					       else  SDAO <= 1'b0 ;
				 end
			    else if (CNT == 9)  
				    begin 
					    BYTE <= BYTE +1 ;   ST <= 9; 

	                if ( BYTE==8'h00)                     CONTROL  <=DATA8; //00h CONTROL
	                if ( BYTE==8'h02)                     STATUS   <=DATA8; //02h STATUS
	                if ((BYTE==8'h14) && (!SENSE0_VIN1))  SENSE_MSB<=DATA8; //14h SENSE_MSB
	                if ((BYTE==8'h15) && (!SENSE0_VIN1))  SENSE_LSB<=DATA8; //15h SENSE_LSB
	                if ((BYTE==8'h1E) && (SENSE0_VIN1))   VIN_MSB  <=DATA8; //1Eh VIN_MSB
	                if ((BYTE==8'h1F) && (SENSE0_VIN1))   VIN_LSB  <=DATA8; // 1Fh VIN_LSB	
                   if ( BYTE==8'h05)                     POWER_MSB2<=DATA8; //05h POWER MSB2 R/W** Power MSB2 Data XXh
                   if ( BYTE==8'h06)                     POWER_MSB1<=DATA8; //06h POWER MSB1 R/W** Power MSB1 Data XXh
                   if ( BYTE==8'h07)                     POWER_LSB<=DATA8; //07h POWER LSB				
					    
					 end
				 else ST <= 7;
			 end	 
		    end
	    9: begin
		     if  ( ( BYTE > END_BYTE ) || (NO_COMPL)) ST <=10 ;  //<--add
			   else ST <=6 ; 
			   
         end
	    10: begin          //stop
		      ST <=11 ; 
			   { SDAO,  SCLO } <= 2'b00; 
         end
	    11: begin          //stop
		      ST <=12 ; 
			   { SDAO,  SCLO } <= 2'b01; 
         end
	    12: begin          //stop
		      ST <=13 ; 
			   { SDAO,  SCLO } <= 2'b11; 
         end	
		 13:	 
			  begin
		             if ( !ACK_OK  ) begin ST<=1 ; end  //<--add
		        else if ( NO_COMPL ) begin NO_COMPL<=0 ; 
				                             ST<=1 ;ACK_OK<=0; DATA8  <=0; BYTE<=0; end  //<--add
		       else begin 
		       ST     <= 14;  END_OK <= 1; //<--add
		       end 
		      
		      { SDAO , SCLO }  <=2'b11;
	           CNT    <=0;
	           BYTE   <=0;	
				
				//--Output 12 bit
				 SENSE <= { SENSE_MSB [7:0], SENSE_LSB[7:4] } ; 
				 VIN   <= { VIN_MSB   [7:0], VIN_LSB  [7:4] } ; 
				 POWER <= {POWER_MSB2 , POWER_MSB1 ,POWER_LSB } ;		
		     end
		//--- END ---
		  14: begin
            if (!GO) ST  <=15;
          end
			
		  15: begin  //
		        END_OK<=0;
			     ST    <=1;
				  ACK_OK<=0;	
			end	
	
	 			  	  
	  endcase 
  end

endmodule

