// system.v

// Generated using ACDS version 24.3 212

`timescale 1 ps / 1 ps
module system (
		input  wire [15:0] board_info_core_current_export,      //      board_info_core_current.export
		input  wire [15:0] board_info_core_vol_export,          //          board_info_core_vol.export
		input  wire [15:0] fan_speed_export,                    //                    fan_speed.export
		input  wire [15:0] pin_status_export,                   //                   pin_status.export
		input  wire [15:0] temperature_board_export,            //            temperature_board.export
		input  wire [15:0] temperature_fpga_export,             //             temperature_fpga.export
		input  wire [15:0] temperature_power_export,            //            temperature_power.export
		input  wire [15:0] board_info_vcc0p9_current_export,    //    board_info_vcc0p9_current.export
		input  wire [15:0] board_info_vcc0p9_vol_export,        //        board_info_vcc0p9_vol.export
		input  wire [15:0] board_info_vcc12_current_export,     //     board_info_vcc12_current.export
		input  wire [15:0] board_info_vcc12_vol_export,         //         board_info_vcc12_vol.export
		input  wire [15:0] board_info_vcc1p03_current_export,   //   board_info_vcc1p03_current.export
		input  wire [15:0] board_info_vcc1p03_vol_export,       //       board_info_vcc1p03_vol.export
		input  wire [15:0] board_info_vcc1p2_io_current_export, // board_info_vcc1p2_io_current.export
		input  wire [15:0] board_info_vcc1p2_io_vol_export,     //     board_info_vcc1p2_io_vol.export
		input  wire [15:0] board_info_vcc1p8_current_export,    //    board_info_vcc1p8_current.export
		input  wire [15:0] board_info_vcc1p8_vol_export,        //        board_info_vcc1p8_vol.export
		input  wire [15:0] board_info_vcc3p3_current_export,    //    board_info_vcc3p3_current.export
		input  wire [15:0] board_info_vcc3p3_vol_export,        //        board_info_vcc3p3_vol.export
		input  wire        clock_in_clk,                        //                     clock_in.clk
		input  wire        reset_in0_reset,                     //                    reset_in0.reset
		input  wire        reset_in1_reset                      //                    reset_in1.reset
	);

	wire         clock_in_out_clk_clk;                                         // clock_in:out_clk -> [board_info_core_current:clk, board_info_core_vol:clk, board_info_fan_speed:clk, board_info_pin_status:clk, board_info_temperature_board:clk, board_info_temperature_fpga:clk, board_info_temperature_power:clk, board_info_vcc0p9_current:clk, board_info_vcc0p9_vol:clk, board_info_vcc12_current:clk, board_info_vcc12_vol:clk, board_info_vcc1p03_current:clk, board_info_vcc1p03_vol:clk, board_info_vcc1p2_io_current:clk, board_info_vcc1p2_io_vol:clk, board_info_vcc1p8_current:clk, board_info_vcc1p8_vol:clk, board_info_vcc3p3_current:clk, board_info_vcc3p3_vol:clk, intel_niosv_m:clk, intel_onchip_memory:clk, irq_mapper:clk, jtag_uart:clk, mm_interconnect_0:clock_in_out_clk_clk, reset_controller:clk, rst_controller:clk, sysid_qsys:clock, timer:clk]
	wire  [31:0] intel_niosv_m_data_manager_awaddr;                            // intel_niosv_m:data_manager_awaddr -> mm_interconnect_0:intel_niosv_m_data_manager_awaddr
	wire   [1:0] intel_niosv_m_data_manager_bresp;                             // mm_interconnect_0:intel_niosv_m_data_manager_bresp -> intel_niosv_m:data_manager_bresp
	wire         intel_niosv_m_data_manager_arready;                           // mm_interconnect_0:intel_niosv_m_data_manager_arready -> intel_niosv_m:data_manager_arready
	wire  [31:0] intel_niosv_m_data_manager_rdata;                             // mm_interconnect_0:intel_niosv_m_data_manager_rdata -> intel_niosv_m:data_manager_rdata
	wire   [3:0] intel_niosv_m_data_manager_wstrb;                             // intel_niosv_m:data_manager_wstrb -> mm_interconnect_0:intel_niosv_m_data_manager_wstrb
	wire         intel_niosv_m_data_manager_wready;                            // mm_interconnect_0:intel_niosv_m_data_manager_wready -> intel_niosv_m:data_manager_wready
	wire         intel_niosv_m_data_manager_awready;                           // mm_interconnect_0:intel_niosv_m_data_manager_awready -> intel_niosv_m:data_manager_awready
	wire         intel_niosv_m_data_manager_rready;                            // intel_niosv_m:data_manager_rready -> mm_interconnect_0:intel_niosv_m_data_manager_rready
	wire         intel_niosv_m_data_manager_bready;                            // intel_niosv_m:data_manager_bready -> mm_interconnect_0:intel_niosv_m_data_manager_bready
	wire         intel_niosv_m_data_manager_wvalid;                            // intel_niosv_m:data_manager_wvalid -> mm_interconnect_0:intel_niosv_m_data_manager_wvalid
	wire  [31:0] intel_niosv_m_data_manager_araddr;                            // intel_niosv_m:data_manager_araddr -> mm_interconnect_0:intel_niosv_m_data_manager_araddr
	wire   [2:0] intel_niosv_m_data_manager_arprot;                            // intel_niosv_m:data_manager_arprot -> mm_interconnect_0:intel_niosv_m_data_manager_arprot
	wire   [1:0] intel_niosv_m_data_manager_rresp;                             // mm_interconnect_0:intel_niosv_m_data_manager_rresp -> intel_niosv_m:data_manager_rresp
	wire   [2:0] intel_niosv_m_data_manager_awprot;                            // intel_niosv_m:data_manager_awprot -> mm_interconnect_0:intel_niosv_m_data_manager_awprot
	wire  [31:0] intel_niosv_m_data_manager_wdata;                             // intel_niosv_m:data_manager_wdata -> mm_interconnect_0:intel_niosv_m_data_manager_wdata
	wire         intel_niosv_m_data_manager_arvalid;                           // intel_niosv_m:data_manager_arvalid -> mm_interconnect_0:intel_niosv_m_data_manager_arvalid
	wire         intel_niosv_m_data_manager_bvalid;                            // mm_interconnect_0:intel_niosv_m_data_manager_bvalid -> intel_niosv_m:data_manager_bvalid
	wire         intel_niosv_m_data_manager_awvalid;                           // intel_niosv_m:data_manager_awvalid -> mm_interconnect_0:intel_niosv_m_data_manager_awvalid
	wire         intel_niosv_m_data_manager_rvalid;                            // mm_interconnect_0:intel_niosv_m_data_manager_rvalid -> intel_niosv_m:data_manager_rvalid
	wire  [31:0] intel_niosv_m_instruction_manager_awaddr;                     // intel_niosv_m:instruction_manager_awaddr -> mm_interconnect_0:intel_niosv_m_instruction_manager_awaddr
	wire   [1:0] intel_niosv_m_instruction_manager_bresp;                      // mm_interconnect_0:intel_niosv_m_instruction_manager_bresp -> intel_niosv_m:instruction_manager_bresp
	wire         intel_niosv_m_instruction_manager_arready;                    // mm_interconnect_0:intel_niosv_m_instruction_manager_arready -> intel_niosv_m:instruction_manager_arready
	wire  [31:0] intel_niosv_m_instruction_manager_rdata;                      // mm_interconnect_0:intel_niosv_m_instruction_manager_rdata -> intel_niosv_m:instruction_manager_rdata
	wire   [3:0] intel_niosv_m_instruction_manager_wstrb;                      // intel_niosv_m:instruction_manager_wstrb -> mm_interconnect_0:intel_niosv_m_instruction_manager_wstrb
	wire         intel_niosv_m_instruction_manager_wready;                     // mm_interconnect_0:intel_niosv_m_instruction_manager_wready -> intel_niosv_m:instruction_manager_wready
	wire         intel_niosv_m_instruction_manager_awready;                    // mm_interconnect_0:intel_niosv_m_instruction_manager_awready -> intel_niosv_m:instruction_manager_awready
	wire         intel_niosv_m_instruction_manager_rready;                     // intel_niosv_m:instruction_manager_rready -> mm_interconnect_0:intel_niosv_m_instruction_manager_rready
	wire         intel_niosv_m_instruction_manager_bready;                     // intel_niosv_m:instruction_manager_bready -> mm_interconnect_0:intel_niosv_m_instruction_manager_bready
	wire         intel_niosv_m_instruction_manager_wvalid;                     // intel_niosv_m:instruction_manager_wvalid -> mm_interconnect_0:intel_niosv_m_instruction_manager_wvalid
	wire  [31:0] intel_niosv_m_instruction_manager_araddr;                     // intel_niosv_m:instruction_manager_araddr -> mm_interconnect_0:intel_niosv_m_instruction_manager_araddr
	wire   [2:0] intel_niosv_m_instruction_manager_arprot;                     // intel_niosv_m:instruction_manager_arprot -> mm_interconnect_0:intel_niosv_m_instruction_manager_arprot
	wire   [1:0] intel_niosv_m_instruction_manager_rresp;                      // mm_interconnect_0:intel_niosv_m_instruction_manager_rresp -> intel_niosv_m:instruction_manager_rresp
	wire   [2:0] intel_niosv_m_instruction_manager_awprot;                     // intel_niosv_m:instruction_manager_awprot -> mm_interconnect_0:intel_niosv_m_instruction_manager_awprot
	wire  [31:0] intel_niosv_m_instruction_manager_wdata;                      // intel_niosv_m:instruction_manager_wdata -> mm_interconnect_0:intel_niosv_m_instruction_manager_wdata
	wire         intel_niosv_m_instruction_manager_arvalid;                    // intel_niosv_m:instruction_manager_arvalid -> mm_interconnect_0:intel_niosv_m_instruction_manager_arvalid
	wire         intel_niosv_m_instruction_manager_bvalid;                     // mm_interconnect_0:intel_niosv_m_instruction_manager_bvalid -> intel_niosv_m:instruction_manager_bvalid
	wire         intel_niosv_m_instruction_manager_awvalid;                    // intel_niosv_m:instruction_manager_awvalid -> mm_interconnect_0:intel_niosv_m_instruction_manager_awvalid
	wire         intel_niosv_m_instruction_manager_rvalid;                     // mm_interconnect_0:intel_niosv_m_instruction_manager_rvalid -> intel_niosv_m:instruction_manager_rvalid
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect;     // mm_interconnect_0:jtag_uart_avalon_jtag_slave_chipselect -> jtag_uart:av_chipselect
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata;       // jtag_uart:av_readdata -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_readdata
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest;    // jtag_uart:av_waitrequest -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_waitrequest
	wire   [0:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_address;        // mm_interconnect_0:jtag_uart_avalon_jtag_slave_address -> jtag_uart:av_address
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_read;           // mm_interconnect_0:jtag_uart_avalon_jtag_slave_read -> jtag_uart:av_read_n
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_write;          // mm_interconnect_0:jtag_uart_avalon_jtag_slave_write -> jtag_uart:av_write_n
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata;      // mm_interconnect_0:jtag_uart_avalon_jtag_slave_writedata -> jtag_uart:av_writedata
	wire  [31:0] mm_interconnect_0_sysid_qsys_control_slave_readdata;          // sysid_qsys:readdata -> mm_interconnect_0:sysid_qsys_control_slave_readdata
	wire   [0:0] mm_interconnect_0_sysid_qsys_control_slave_address;           // mm_interconnect_0:sysid_qsys_control_slave_address -> sysid_qsys:address
	wire  [31:0] mm_interconnect_0_intel_niosv_m_dm_agent_readdata;            // intel_niosv_m:dm_agent_readdata -> mm_interconnect_0:intel_niosv_m_dm_agent_readdata
	wire         mm_interconnect_0_intel_niosv_m_dm_agent_waitrequest;         // intel_niosv_m:dm_agent_waitrequest -> mm_interconnect_0:intel_niosv_m_dm_agent_waitrequest
	wire  [15:0] mm_interconnect_0_intel_niosv_m_dm_agent_address;             // mm_interconnect_0:intel_niosv_m_dm_agent_address -> intel_niosv_m:dm_agent_address
	wire         mm_interconnect_0_intel_niosv_m_dm_agent_read;                // mm_interconnect_0:intel_niosv_m_dm_agent_read -> intel_niosv_m:dm_agent_read
	wire         mm_interconnect_0_intel_niosv_m_dm_agent_readdatavalid;       // intel_niosv_m:dm_agent_readdatavalid -> mm_interconnect_0:intel_niosv_m_dm_agent_readdatavalid
	wire         mm_interconnect_0_intel_niosv_m_dm_agent_write;               // mm_interconnect_0:intel_niosv_m_dm_agent_write -> intel_niosv_m:dm_agent_write
	wire  [31:0] mm_interconnect_0_intel_niosv_m_dm_agent_writedata;           // mm_interconnect_0:intel_niosv_m_dm_agent_writedata -> intel_niosv_m:dm_agent_writedata
	wire  [31:0] mm_interconnect_0_intel_onchip_memory_s1_readdata;            // intel_onchip_memory:readdata -> mm_interconnect_0:intel_onchip_memory_s1_readdata
	wire  [16:0] mm_interconnect_0_intel_onchip_memory_s1_address;             // mm_interconnect_0:intel_onchip_memory_s1_address -> intel_onchip_memory:address
	wire         mm_interconnect_0_intel_onchip_memory_s1_read;                // mm_interconnect_0:intel_onchip_memory_s1_read -> intel_onchip_memory:read
	wire   [3:0] mm_interconnect_0_intel_onchip_memory_s1_byteenable;          // mm_interconnect_0:intel_onchip_memory_s1_byteenable -> intel_onchip_memory:byteenable
	wire         mm_interconnect_0_intel_onchip_memory_s1_write;               // mm_interconnect_0:intel_onchip_memory_s1_write -> intel_onchip_memory:write
	wire  [31:0] mm_interconnect_0_intel_onchip_memory_s1_writedata;           // mm_interconnect_0:intel_onchip_memory_s1_writedata -> intel_onchip_memory:writedata
	wire         mm_interconnect_0_timer_s1_chipselect;                        // mm_interconnect_0:timer_s1_chipselect -> timer:chipselect
	wire  [15:0] mm_interconnect_0_timer_s1_readdata;                          // timer:readdata -> mm_interconnect_0:timer_s1_readdata
	wire   [2:0] mm_interconnect_0_timer_s1_address;                           // mm_interconnect_0:timer_s1_address -> timer:address
	wire         mm_interconnect_0_timer_s1_write;                             // mm_interconnect_0:timer_s1_write -> timer:write_n
	wire  [15:0] mm_interconnect_0_timer_s1_writedata;                         // mm_interconnect_0:timer_s1_writedata -> timer:writedata
	wire  [31:0] mm_interconnect_0_board_info_vcc1p8_vol_s1_readdata;          // board_info_vcc1p8_vol:readdata -> mm_interconnect_0:board_info_vcc1p8_vol_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc1p8_vol_s1_address;           // mm_interconnect_0:board_info_vcc1p8_vol_s1_address -> board_info_vcc1p8_vol:address
	wire  [31:0] mm_interconnect_0_board_info_core_vol_s1_readdata;            // board_info_core_vol:readdata -> mm_interconnect_0:board_info_core_vol_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_core_vol_s1_address;             // mm_interconnect_0:board_info_core_vol_s1_address -> board_info_core_vol:address
	wire  [31:0] mm_interconnect_0_board_info_core_current_s1_readdata;        // board_info_core_current:readdata -> mm_interconnect_0:board_info_core_current_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_core_current_s1_address;         // mm_interconnect_0:board_info_core_current_s1_address -> board_info_core_current:address
	wire  [31:0] mm_interconnect_0_board_info_vcc1p2_io_vol_s1_readdata;       // board_info_vcc1p2_io_vol:readdata -> mm_interconnect_0:board_info_vcc1p2_io_vol_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc1p2_io_vol_s1_address;        // mm_interconnect_0:board_info_vcc1p2_io_vol_s1_address -> board_info_vcc1p2_io_vol:address
	wire  [31:0] mm_interconnect_0_board_info_vcc1p2_io_current_s1_readdata;   // board_info_vcc1p2_io_current:readdata -> mm_interconnect_0:board_info_vcc1p2_io_current_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc1p2_io_current_s1_address;    // mm_interconnect_0:board_info_vcc1p2_io_current_s1_address -> board_info_vcc1p2_io_current:address
	wire  [31:0] mm_interconnect_0_board_info_fan_speed_s1_readdata;           // board_info_fan_speed:readdata -> mm_interconnect_0:board_info_fan_speed_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_fan_speed_s1_address;            // mm_interconnect_0:board_info_fan_speed_s1_address -> board_info_fan_speed:address
	wire  [31:0] mm_interconnect_0_board_info_temperature_fpga_s1_readdata;    // board_info_temperature_fpga:readdata -> mm_interconnect_0:board_info_temperature_fpga_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_temperature_fpga_s1_address;     // mm_interconnect_0:board_info_temperature_fpga_s1_address -> board_info_temperature_fpga:address
	wire  [31:0] mm_interconnect_0_board_info_temperature_board_s1_readdata;   // board_info_temperature_board:readdata -> mm_interconnect_0:board_info_temperature_board_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_temperature_board_s1_address;    // mm_interconnect_0:board_info_temperature_board_s1_address -> board_info_temperature_board:address
	wire  [31:0] mm_interconnect_0_board_info_pin_status_s1_readdata;          // board_info_pin_status:readdata -> mm_interconnect_0:board_info_pin_status_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_pin_status_s1_address;           // mm_interconnect_0:board_info_pin_status_s1_address -> board_info_pin_status:address
	wire  [31:0] mm_interconnect_0_board_info_vcc3p3_current_s1_readdata;      // board_info_vcc3p3_current:readdata -> mm_interconnect_0:board_info_vcc3p3_current_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc3p3_current_s1_address;       // mm_interconnect_0:board_info_vcc3p3_current_s1_address -> board_info_vcc3p3_current:address
	wire  [31:0] mm_interconnect_0_board_info_temperature_power_s1_readdata;   // board_info_temperature_power:readdata -> mm_interconnect_0:board_info_temperature_power_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_temperature_power_s1_address;    // mm_interconnect_0:board_info_temperature_power_s1_address -> board_info_temperature_power:address
	wire  [31:0] mm_interconnect_0_board_info_vcc1p8_current_s1_readdata;      // board_info_vcc1p8_current:readdata -> mm_interconnect_0:board_info_vcc1p8_current_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc1p8_current_s1_address;       // mm_interconnect_0:board_info_vcc1p8_current_s1_address -> board_info_vcc1p8_current:address
	wire  [31:0] mm_interconnect_0_board_info_vcc3p3_vol_s1_readdata;          // board_info_vcc3p3_vol:readdata -> mm_interconnect_0:board_info_vcc3p3_vol_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc3p3_vol_s1_address;           // mm_interconnect_0:board_info_vcc3p3_vol_s1_address -> board_info_vcc3p3_vol:address
	wire  [31:0] mm_interconnect_0_board_info_vcc0p9_vol_s1_readdata;          // board_info_vcc0p9_vol:readdata -> mm_interconnect_0:board_info_vcc0p9_vol_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc0p9_vol_s1_address;           // mm_interconnect_0:board_info_vcc0p9_vol_s1_address -> board_info_vcc0p9_vol:address
	wire  [31:0] mm_interconnect_0_board_info_vcc0p9_current_s1_readdata;      // board_info_vcc0p9_current:readdata -> mm_interconnect_0:board_info_vcc0p9_current_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc0p9_current_s1_address;       // mm_interconnect_0:board_info_vcc0p9_current_s1_address -> board_info_vcc0p9_current:address
	wire  [31:0] mm_interconnect_0_board_info_vcc1p03_vol_s1_readdata;         // board_info_vcc1p03_vol:readdata -> mm_interconnect_0:board_info_vcc1p03_vol_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc1p03_vol_s1_address;          // mm_interconnect_0:board_info_vcc1p03_vol_s1_address -> board_info_vcc1p03_vol:address
	wire  [31:0] mm_interconnect_0_board_info_vcc1p03_current_s1_readdata;     // board_info_vcc1p03_current:readdata -> mm_interconnect_0:board_info_vcc1p03_current_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc1p03_current_s1_address;      // mm_interconnect_0:board_info_vcc1p03_current_s1_address -> board_info_vcc1p03_current:address
	wire  [31:0] mm_interconnect_0_board_info_vcc12_vol_s1_readdata;           // board_info_vcc12_vol:readdata -> mm_interconnect_0:board_info_vcc12_vol_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc12_vol_s1_address;            // mm_interconnect_0:board_info_vcc12_vol_s1_address -> board_info_vcc12_vol:address
	wire  [31:0] mm_interconnect_0_board_info_vcc12_current_s1_readdata;       // board_info_vcc12_current:readdata -> mm_interconnect_0:board_info_vcc12_current_s1_readdata
	wire   [1:0] mm_interconnect_0_board_info_vcc12_current_s1_address;        // mm_interconnect_0:board_info_vcc12_current_s1_address -> board_info_vcc12_current:address
	wire  [31:0] mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdata;      // intel_niosv_m:timer_sw_agent_readdata -> mm_interconnect_0:intel_niosv_m_timer_sw_agent_readdata
	wire         mm_interconnect_0_intel_niosv_m_timer_sw_agent_waitrequest;   // intel_niosv_m:timer_sw_agent_waitrequest -> mm_interconnect_0:intel_niosv_m_timer_sw_agent_waitrequest
	wire   [5:0] mm_interconnect_0_intel_niosv_m_timer_sw_agent_address;       // mm_interconnect_0:intel_niosv_m_timer_sw_agent_address -> intel_niosv_m:timer_sw_agent_address
	wire         mm_interconnect_0_intel_niosv_m_timer_sw_agent_read;          // mm_interconnect_0:intel_niosv_m_timer_sw_agent_read -> intel_niosv_m:timer_sw_agent_read
	wire   [3:0] mm_interconnect_0_intel_niosv_m_timer_sw_agent_byteenable;    // mm_interconnect_0:intel_niosv_m_timer_sw_agent_byteenable -> intel_niosv_m:timer_sw_agent_byteenable
	wire         mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdatavalid; // intel_niosv_m:timer_sw_agent_readdatavalid -> mm_interconnect_0:intel_niosv_m_timer_sw_agent_readdatavalid
	wire         mm_interconnect_0_intel_niosv_m_timer_sw_agent_write;         // mm_interconnect_0:intel_niosv_m_timer_sw_agent_write -> intel_niosv_m:timer_sw_agent_write
	wire  [31:0] mm_interconnect_0_intel_niosv_m_timer_sw_agent_writedata;     // mm_interconnect_0:intel_niosv_m_timer_sw_agent_writedata -> intel_niosv_m:timer_sw_agent_writedata
	wire         reset_controller_reset_out_reset;                             // reset_controller:reset_out -> [mm_interconnect_0:intel_niosv_m_reset_reset_bridge_in_reset_reset, mm_interconnect_0:jtag_uart_avalon_jtag_slave_translator_reset_reset_bridge_in_reset_reset, rst_controller:reset_in0]
	wire         irq_mapper_receiver0_irq;                                     // jtag_uart:av_irq -> irq_mapper:receiver0_irq
	wire         irq_mapper_receiver1_irq;                                     // timer:irq -> irq_mapper:receiver1_irq
	wire  [15:0] intel_niosv_m_platform_irq_rx_irq;                            // irq_mapper:sender_irq -> intel_niosv_m:platform_irq_rx_irq
	wire         rst_controller_reset_out_reset;                               // rst_controller:reset_out -> [board_info_core_current:reset_n, board_info_core_vol:reset_n, board_info_fan_speed:reset_n, board_info_pin_status:reset_n, board_info_temperature_board:reset_n, board_info_temperature_fpga:reset_n, board_info_temperature_power:reset_n, board_info_vcc0p9_current:reset_n, board_info_vcc0p9_vol:reset_n, board_info_vcc12_current:reset_n, board_info_vcc12_vol:reset_n, board_info_vcc1p03_current:reset_n, board_info_vcc1p03_vol:reset_n, board_info_vcc1p2_io_current:reset_n, board_info_vcc1p2_io_vol:reset_n, board_info_vcc1p8_current:reset_n, board_info_vcc1p8_vol:reset_n, board_info_vcc3p3_current:reset_n, board_info_vcc3p3_vol:reset_n, intel_niosv_m:reset_reset, intel_onchip_memory:reset, irq_mapper:reset, jtag_uart:rst_n, rst_translator:in_reset, sysid_qsys:reset_n, timer:reset_n]
	wire         rst_controller_reset_out_reset_req;                           // rst_controller:reset_req -> [intel_onchip_memory:reset_req, rst_translator:reset_req_in]

	board_info_pio board_info_core_current (
		.clk      (clock_in_out_clk_clk),                                  //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                       //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_core_current_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_core_current_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_core_current_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_core_vol (
		.clk      (clock_in_out_clk_clk),                              //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                   //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_core_vol_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_core_vol_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_core_vol_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_fan_speed (
		.clk      (clock_in_out_clk_clk),                               //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                    //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_fan_speed_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_fan_speed_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (fan_speed_export)                                    //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_pin_status (
		.clk      (clock_in_out_clk_clk),                                //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                     //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_pin_status_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_pin_status_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (pin_status_export)                                    //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_temperature_board (
		.clk      (clock_in_out_clk_clk),                                       //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                            //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_temperature_board_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_temperature_board_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (temperature_board_export)                                    //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_temperature_fpga (
		.clk      (clock_in_out_clk_clk),                                      //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                           //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_temperature_fpga_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_temperature_fpga_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (temperature_fpga_export)                                    //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_temperature_power (
		.clk      (clock_in_out_clk_clk),                                       //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                            //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_temperature_power_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_temperature_power_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (temperature_power_export)                                    //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc0p9_current (
		.clk      (clock_in_out_clk_clk),                                    //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                         //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc0p9_current_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc0p9_current_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc0p9_current_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc0p9_vol (
		.clk      (clock_in_out_clk_clk),                                //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                     //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc0p9_vol_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc0p9_vol_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc0p9_vol_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc12_current (
		.clk      (clock_in_out_clk_clk),                                   //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                        //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc12_current_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc12_current_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc12_current_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc12_vol (
		.clk      (clock_in_out_clk_clk),                               //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                    //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc12_vol_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc12_vol_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc12_vol_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc1p03_current (
		.clk      (clock_in_out_clk_clk),                                     //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                          //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc1p03_current_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc1p03_current_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc1p03_current_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc1p03_vol (
		.clk      (clock_in_out_clk_clk),                                 //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                      //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc1p03_vol_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc1p03_vol_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc1p03_vol_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc1p2_io_current (
		.clk      (clock_in_out_clk_clk),                                       //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                            //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc1p2_io_current_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc1p2_io_current_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc1p2_io_current_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc1p2_io_vol (
		.clk      (clock_in_out_clk_clk),                                   //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                        //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc1p2_io_vol_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc1p2_io_vol_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc1p2_io_vol_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc1p8_current (
		.clk      (clock_in_out_clk_clk),                                    //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                         //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc1p8_current_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc1p8_current_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc1p8_current_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc1p8_vol (
		.clk      (clock_in_out_clk_clk),                                //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                     //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc1p8_vol_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc1p8_vol_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc1p8_vol_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc3p3_current (
		.clk      (clock_in_out_clk_clk),                                    //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                         //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc3p3_current_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc3p3_current_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc3p3_current_export)                         //   input,  width = 16, external_connection.export
	);

	board_info_pio board_info_vcc3p3_vol (
		.clk      (clock_in_out_clk_clk),                                //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                     //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_board_info_vcc3p3_vol_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_board_info_vcc3p3_vol_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (board_info_vcc3p3_vol_export)                         //   input,  width = 16, external_connection.export
	);

	clock_in clock_in (
		.in_clk  (clock_in_clk),         //   input,  width = 1,  in_clk.clk
		.out_clk (clock_in_out_clk_clk)  //  output,  width = 1, out_clk.clk
	);

	system_intel_niosv_m_0 intel_niosv_m (
		.clk                          (clock_in_out_clk_clk),                                         //   input,   width = 1,                 clk.clk
		.reset_reset                  (rst_controller_reset_out_reset),                               //   input,   width = 1,               reset.reset
		.platform_irq_rx_irq          (intel_niosv_m_platform_irq_rx_irq),                            //   input,  width = 16,     platform_irq_rx.irq
		.instruction_manager_awaddr   (intel_niosv_m_instruction_manager_awaddr),                     //  output,  width = 32, instruction_manager.awaddr
		.instruction_manager_awprot   (intel_niosv_m_instruction_manager_awprot),                     //  output,   width = 3,                    .awprot
		.instruction_manager_awvalid  (intel_niosv_m_instruction_manager_awvalid),                    //  output,   width = 1,                    .awvalid
		.instruction_manager_awready  (intel_niosv_m_instruction_manager_awready),                    //   input,   width = 1,                    .awready
		.instruction_manager_wdata    (intel_niosv_m_instruction_manager_wdata),                      //  output,  width = 32,                    .wdata
		.instruction_manager_wstrb    (intel_niosv_m_instruction_manager_wstrb),                      //  output,   width = 4,                    .wstrb
		.instruction_manager_wvalid   (intel_niosv_m_instruction_manager_wvalid),                     //  output,   width = 1,                    .wvalid
		.instruction_manager_wready   (intel_niosv_m_instruction_manager_wready),                     //   input,   width = 1,                    .wready
		.instruction_manager_bresp    (intel_niosv_m_instruction_manager_bresp),                      //   input,   width = 2,                    .bresp
		.instruction_manager_bvalid   (intel_niosv_m_instruction_manager_bvalid),                     //   input,   width = 1,                    .bvalid
		.instruction_manager_bready   (intel_niosv_m_instruction_manager_bready),                     //  output,   width = 1,                    .bready
		.instruction_manager_araddr   (intel_niosv_m_instruction_manager_araddr),                     //  output,  width = 32,                    .araddr
		.instruction_manager_arprot   (intel_niosv_m_instruction_manager_arprot),                     //  output,   width = 3,                    .arprot
		.instruction_manager_arvalid  (intel_niosv_m_instruction_manager_arvalid),                    //  output,   width = 1,                    .arvalid
		.instruction_manager_arready  (intel_niosv_m_instruction_manager_arready),                    //   input,   width = 1,                    .arready
		.instruction_manager_rdata    (intel_niosv_m_instruction_manager_rdata),                      //   input,  width = 32,                    .rdata
		.instruction_manager_rresp    (intel_niosv_m_instruction_manager_rresp),                      //   input,   width = 2,                    .rresp
		.instruction_manager_rvalid   (intel_niosv_m_instruction_manager_rvalid),                     //   input,   width = 1,                    .rvalid
		.instruction_manager_rready   (intel_niosv_m_instruction_manager_rready),                     //  output,   width = 1,                    .rready
		.data_manager_awaddr          (intel_niosv_m_data_manager_awaddr),                            //  output,  width = 32,        data_manager.awaddr
		.data_manager_awprot          (intel_niosv_m_data_manager_awprot),                            //  output,   width = 3,                    .awprot
		.data_manager_awvalid         (intel_niosv_m_data_manager_awvalid),                           //  output,   width = 1,                    .awvalid
		.data_manager_awready         (intel_niosv_m_data_manager_awready),                           //   input,   width = 1,                    .awready
		.data_manager_wdata           (intel_niosv_m_data_manager_wdata),                             //  output,  width = 32,                    .wdata
		.data_manager_wstrb           (intel_niosv_m_data_manager_wstrb),                             //  output,   width = 4,                    .wstrb
		.data_manager_wvalid          (intel_niosv_m_data_manager_wvalid),                            //  output,   width = 1,                    .wvalid
		.data_manager_wready          (intel_niosv_m_data_manager_wready),                            //   input,   width = 1,                    .wready
		.data_manager_bresp           (intel_niosv_m_data_manager_bresp),                             //   input,   width = 2,                    .bresp
		.data_manager_bvalid          (intel_niosv_m_data_manager_bvalid),                            //   input,   width = 1,                    .bvalid
		.data_manager_bready          (intel_niosv_m_data_manager_bready),                            //  output,   width = 1,                    .bready
		.data_manager_araddr          (intel_niosv_m_data_manager_araddr),                            //  output,  width = 32,                    .araddr
		.data_manager_arprot          (intel_niosv_m_data_manager_arprot),                            //  output,   width = 3,                    .arprot
		.data_manager_arvalid         (intel_niosv_m_data_manager_arvalid),                           //  output,   width = 1,                    .arvalid
		.data_manager_arready         (intel_niosv_m_data_manager_arready),                           //   input,   width = 1,                    .arready
		.data_manager_rdata           (intel_niosv_m_data_manager_rdata),                             //   input,  width = 32,                    .rdata
		.data_manager_rresp           (intel_niosv_m_data_manager_rresp),                             //   input,   width = 2,                    .rresp
		.data_manager_rvalid          (intel_niosv_m_data_manager_rvalid),                            //   input,   width = 1,                    .rvalid
		.data_manager_rready          (intel_niosv_m_data_manager_rready),                            //  output,   width = 1,                    .rready
		.timer_sw_agent_address       (mm_interconnect_0_intel_niosv_m_timer_sw_agent_address),       //   input,   width = 6,      timer_sw_agent.address
		.timer_sw_agent_byteenable    (mm_interconnect_0_intel_niosv_m_timer_sw_agent_byteenable),    //   input,   width = 4,                    .byteenable
		.timer_sw_agent_read          (mm_interconnect_0_intel_niosv_m_timer_sw_agent_read),          //   input,   width = 1,                    .read
		.timer_sw_agent_readdata      (mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdata),      //  output,  width = 32,                    .readdata
		.timer_sw_agent_write         (mm_interconnect_0_intel_niosv_m_timer_sw_agent_write),         //   input,   width = 1,                    .write
		.timer_sw_agent_writedata     (mm_interconnect_0_intel_niosv_m_timer_sw_agent_writedata),     //   input,  width = 32,                    .writedata
		.timer_sw_agent_waitrequest   (mm_interconnect_0_intel_niosv_m_timer_sw_agent_waitrequest),   //  output,   width = 1,                    .waitrequest
		.timer_sw_agent_readdatavalid (mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdatavalid), //  output,   width = 1,                    .readdatavalid
		.dm_agent_address             (mm_interconnect_0_intel_niosv_m_dm_agent_address),             //   input,  width = 16,            dm_agent.address
		.dm_agent_read                (mm_interconnect_0_intel_niosv_m_dm_agent_read),                //   input,   width = 1,                    .read
		.dm_agent_readdata            (mm_interconnect_0_intel_niosv_m_dm_agent_readdata),            //  output,  width = 32,                    .readdata
		.dm_agent_write               (mm_interconnect_0_intel_niosv_m_dm_agent_write),               //   input,   width = 1,                    .write
		.dm_agent_writedata           (mm_interconnect_0_intel_niosv_m_dm_agent_writedata),           //   input,  width = 32,                    .writedata
		.dm_agent_waitrequest         (mm_interconnect_0_intel_niosv_m_dm_agent_waitrequest),         //  output,   width = 1,                    .waitrequest
		.dm_agent_readdatavalid       (mm_interconnect_0_intel_niosv_m_dm_agent_readdatavalid)        //  output,   width = 1,                    .readdatavalid
	);

	system_intel_onchip_memory_0 intel_onchip_memory (
		.clk        (clock_in_out_clk_clk),                                //   input,   width = 1,   clk1.clk
		.address    (mm_interconnect_0_intel_onchip_memory_s1_address),    //   input,  width = 17,     s1.address
		.read       (mm_interconnect_0_intel_onchip_memory_s1_read),       //   input,   width = 1,       .read
		.readdata   (mm_interconnect_0_intel_onchip_memory_s1_readdata),   //  output,  width = 32,       .readdata
		.byteenable (mm_interconnect_0_intel_onchip_memory_s1_byteenable), //   input,   width = 4,       .byteenable
		.write      (mm_interconnect_0_intel_onchip_memory_s1_write),      //   input,   width = 1,       .write
		.writedata  (mm_interconnect_0_intel_onchip_memory_s1_writedata),  //   input,  width = 32,       .writedata
		.reset      (rst_controller_reset_out_reset),                      //   input,   width = 1, reset1.reset
		.reset_req  (rst_controller_reset_out_reset_req)                   //   input,   width = 1,       .reset_req
	);

	jtag_uart jtag_uart (
		.clk            (clock_in_out_clk_clk),                                      //   input,   width = 1,               clk.clk
		.rst_n          (~rst_controller_reset_out_reset),                           //   input,   width = 1,             reset.reset_n
		.av_chipselect  (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),  //   input,   width = 1, avalon_jtag_slave.chipselect
		.av_address     (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),     //   input,   width = 1,                  .address
		.av_read_n      (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),       //   input,   width = 1,                  .read_n
		.av_readdata    (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),    //  output,  width = 32,                  .readdata
		.av_write_n     (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),      //   input,   width = 1,                  .write_n
		.av_writedata   (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),   //   input,  width = 32,                  .writedata
		.av_waitrequest (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest), //  output,   width = 1,                  .waitrequest
		.av_irq         (irq_mapper_receiver0_irq)                                   //  output,   width = 1,               irq.irq
	);

	reset_controller reset_controller (
		.reset_in0 (reset_in0_reset),                  //   input,  width = 1, reset_in0.reset
		.reset_in1 (reset_in1_reset),                  //   input,  width = 1, reset_in1.reset
		.clk       (clock_in_out_clk_clk),             //   input,  width = 1,       clk.clk
		.reset_out (reset_controller_reset_out_reset)  //  output,  width = 1, reset_out.reset
	);

	sysid_qsys sysid_qsys (
		.clock    (clock_in_out_clk_clk),                                //   input,   width = 1,           clk.clk
		.reset_n  (~rst_controller_reset_out_reset),                     //   input,   width = 1,         reset.reset_n
		.readdata (mm_interconnect_0_sysid_qsys_control_slave_readdata), //  output,  width = 32, control_slave.readdata
		.address  (mm_interconnect_0_sysid_qsys_control_slave_address)   //   input,   width = 1,              .address
	);

	timer timer (
		.clk        (clock_in_out_clk_clk),                  //   input,   width = 1,   clk.clk
		.reset_n    (~rst_controller_reset_out_reset),       //   input,   width = 1, reset.reset_n
		.address    (mm_interconnect_0_timer_s1_address),    //   input,   width = 3,    s1.address
		.writedata  (mm_interconnect_0_timer_s1_writedata),  //   input,  width = 16,      .writedata
		.readdata   (mm_interconnect_0_timer_s1_readdata),   //  output,  width = 16,      .readdata
		.chipselect (mm_interconnect_0_timer_s1_chipselect), //   input,   width = 1,      .chipselect
		.write_n    (~mm_interconnect_0_timer_s1_write),     //   input,   width = 1,      .write_n
		.irq        (irq_mapper_receiver1_irq)               //  output,   width = 1,   irq.irq
	);

	system_altera_mm_interconnect_1920_qi2gelq mm_interconnect_0 (
		.jtag_uart_avalon_jtag_slave_address                                      (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),        //  output,   width = 1,                                        jtag_uart_avalon_jtag_slave.address
		.jtag_uart_avalon_jtag_slave_write                                        (mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),          //  output,   width = 1,                                                                   .write
		.jtag_uart_avalon_jtag_slave_read                                         (mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),           //  output,   width = 1,                                                                   .read
		.jtag_uart_avalon_jtag_slave_readdata                                     (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),       //   input,  width = 32,                                                                   .readdata
		.jtag_uart_avalon_jtag_slave_writedata                                    (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),      //  output,  width = 32,                                                                   .writedata
		.jtag_uart_avalon_jtag_slave_waitrequest                                  (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest),    //   input,   width = 1,                                                                   .waitrequest
		.jtag_uart_avalon_jtag_slave_chipselect                                   (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),     //  output,   width = 1,                                                                   .chipselect
		.sysid_qsys_control_slave_address                                         (mm_interconnect_0_sysid_qsys_control_slave_address),           //  output,   width = 1,                                           sysid_qsys_control_slave.address
		.sysid_qsys_control_slave_readdata                                        (mm_interconnect_0_sysid_qsys_control_slave_readdata),          //   input,  width = 32,                                                                   .readdata
		.intel_niosv_m_dm_agent_address                                           (mm_interconnect_0_intel_niosv_m_dm_agent_address),             //  output,  width = 16,                                             intel_niosv_m_dm_agent.address
		.intel_niosv_m_dm_agent_write                                             (mm_interconnect_0_intel_niosv_m_dm_agent_write),               //  output,   width = 1,                                                                   .write
		.intel_niosv_m_dm_agent_read                                              (mm_interconnect_0_intel_niosv_m_dm_agent_read),                //  output,   width = 1,                                                                   .read
		.intel_niosv_m_dm_agent_readdata                                          (mm_interconnect_0_intel_niosv_m_dm_agent_readdata),            //   input,  width = 32,                                                                   .readdata
		.intel_niosv_m_dm_agent_writedata                                         (mm_interconnect_0_intel_niosv_m_dm_agent_writedata),           //  output,  width = 32,                                                                   .writedata
		.intel_niosv_m_dm_agent_readdatavalid                                     (mm_interconnect_0_intel_niosv_m_dm_agent_readdatavalid),       //   input,   width = 1,                                                                   .readdatavalid
		.intel_niosv_m_dm_agent_waitrequest                                       (mm_interconnect_0_intel_niosv_m_dm_agent_waitrequest),         //   input,   width = 1,                                                                   .waitrequest
		.intel_onchip_memory_s1_address                                           (mm_interconnect_0_intel_onchip_memory_s1_address),             //  output,  width = 17,                                             intel_onchip_memory_s1.address
		.intel_onchip_memory_s1_write                                             (mm_interconnect_0_intel_onchip_memory_s1_write),               //  output,   width = 1,                                                                   .write
		.intel_onchip_memory_s1_read                                              (mm_interconnect_0_intel_onchip_memory_s1_read),                //  output,   width = 1,                                                                   .read
		.intel_onchip_memory_s1_readdata                                          (mm_interconnect_0_intel_onchip_memory_s1_readdata),            //   input,  width = 32,                                                                   .readdata
		.intel_onchip_memory_s1_writedata                                         (mm_interconnect_0_intel_onchip_memory_s1_writedata),           //  output,  width = 32,                                                                   .writedata
		.intel_onchip_memory_s1_byteenable                                        (mm_interconnect_0_intel_onchip_memory_s1_byteenable),          //  output,   width = 4,                                                                   .byteenable
		.timer_s1_address                                                         (mm_interconnect_0_timer_s1_address),                           //  output,   width = 3,                                                           timer_s1.address
		.timer_s1_write                                                           (mm_interconnect_0_timer_s1_write),                             //  output,   width = 1,                                                                   .write
		.timer_s1_readdata                                                        (mm_interconnect_0_timer_s1_readdata),                          //   input,  width = 16,                                                                   .readdata
		.timer_s1_writedata                                                       (mm_interconnect_0_timer_s1_writedata),                         //  output,  width = 16,                                                                   .writedata
		.timer_s1_chipselect                                                      (mm_interconnect_0_timer_s1_chipselect),                        //  output,   width = 1,                                                                   .chipselect
		.board_info_vcc1p8_vol_s1_address                                         (mm_interconnect_0_board_info_vcc1p8_vol_s1_address),           //  output,   width = 2,                                           board_info_vcc1p8_vol_s1.address
		.board_info_vcc1p8_vol_s1_readdata                                        (mm_interconnect_0_board_info_vcc1p8_vol_s1_readdata),          //   input,  width = 32,                                                                   .readdata
		.board_info_core_vol_s1_address                                           (mm_interconnect_0_board_info_core_vol_s1_address),             //  output,   width = 2,                                             board_info_core_vol_s1.address
		.board_info_core_vol_s1_readdata                                          (mm_interconnect_0_board_info_core_vol_s1_readdata),            //   input,  width = 32,                                                                   .readdata
		.board_info_core_current_s1_address                                       (mm_interconnect_0_board_info_core_current_s1_address),         //  output,   width = 2,                                         board_info_core_current_s1.address
		.board_info_core_current_s1_readdata                                      (mm_interconnect_0_board_info_core_current_s1_readdata),        //   input,  width = 32,                                                                   .readdata
		.board_info_vcc1p2_io_vol_s1_address                                      (mm_interconnect_0_board_info_vcc1p2_io_vol_s1_address),        //  output,   width = 2,                                        board_info_vcc1p2_io_vol_s1.address
		.board_info_vcc1p2_io_vol_s1_readdata                                     (mm_interconnect_0_board_info_vcc1p2_io_vol_s1_readdata),       //   input,  width = 32,                                                                   .readdata
		.board_info_vcc1p2_io_current_s1_address                                  (mm_interconnect_0_board_info_vcc1p2_io_current_s1_address),    //  output,   width = 2,                                    board_info_vcc1p2_io_current_s1.address
		.board_info_vcc1p2_io_current_s1_readdata                                 (mm_interconnect_0_board_info_vcc1p2_io_current_s1_readdata),   //   input,  width = 32,                                                                   .readdata
		.board_info_fan_speed_s1_address                                          (mm_interconnect_0_board_info_fan_speed_s1_address),            //  output,   width = 2,                                            board_info_fan_speed_s1.address
		.board_info_fan_speed_s1_readdata                                         (mm_interconnect_0_board_info_fan_speed_s1_readdata),           //   input,  width = 32,                                                                   .readdata
		.board_info_temperature_fpga_s1_address                                   (mm_interconnect_0_board_info_temperature_fpga_s1_address),     //  output,   width = 2,                                     board_info_temperature_fpga_s1.address
		.board_info_temperature_fpga_s1_readdata                                  (mm_interconnect_0_board_info_temperature_fpga_s1_readdata),    //   input,  width = 32,                                                                   .readdata
		.board_info_temperature_board_s1_address                                  (mm_interconnect_0_board_info_temperature_board_s1_address),    //  output,   width = 2,                                    board_info_temperature_board_s1.address
		.board_info_temperature_board_s1_readdata                                 (mm_interconnect_0_board_info_temperature_board_s1_readdata),   //   input,  width = 32,                                                                   .readdata
		.board_info_pin_status_s1_address                                         (mm_interconnect_0_board_info_pin_status_s1_address),           //  output,   width = 2,                                           board_info_pin_status_s1.address
		.board_info_pin_status_s1_readdata                                        (mm_interconnect_0_board_info_pin_status_s1_readdata),          //   input,  width = 32,                                                                   .readdata
		.board_info_vcc3p3_current_s1_address                                     (mm_interconnect_0_board_info_vcc3p3_current_s1_address),       //  output,   width = 2,                                       board_info_vcc3p3_current_s1.address
		.board_info_vcc3p3_current_s1_readdata                                    (mm_interconnect_0_board_info_vcc3p3_current_s1_readdata),      //   input,  width = 32,                                                                   .readdata
		.board_info_temperature_power_s1_address                                  (mm_interconnect_0_board_info_temperature_power_s1_address),    //  output,   width = 2,                                    board_info_temperature_power_s1.address
		.board_info_temperature_power_s1_readdata                                 (mm_interconnect_0_board_info_temperature_power_s1_readdata),   //   input,  width = 32,                                                                   .readdata
		.board_info_vcc1p8_current_s1_address                                     (mm_interconnect_0_board_info_vcc1p8_current_s1_address),       //  output,   width = 2,                                       board_info_vcc1p8_current_s1.address
		.board_info_vcc1p8_current_s1_readdata                                    (mm_interconnect_0_board_info_vcc1p8_current_s1_readdata),      //   input,  width = 32,                                                                   .readdata
		.board_info_vcc3p3_vol_s1_address                                         (mm_interconnect_0_board_info_vcc3p3_vol_s1_address),           //  output,   width = 2,                                           board_info_vcc3p3_vol_s1.address
		.board_info_vcc3p3_vol_s1_readdata                                        (mm_interconnect_0_board_info_vcc3p3_vol_s1_readdata),          //   input,  width = 32,                                                                   .readdata
		.board_info_vcc0p9_vol_s1_address                                         (mm_interconnect_0_board_info_vcc0p9_vol_s1_address),           //  output,   width = 2,                                           board_info_vcc0p9_vol_s1.address
		.board_info_vcc0p9_vol_s1_readdata                                        (mm_interconnect_0_board_info_vcc0p9_vol_s1_readdata),          //   input,  width = 32,                                                                   .readdata
		.board_info_vcc0p9_current_s1_address                                     (mm_interconnect_0_board_info_vcc0p9_current_s1_address),       //  output,   width = 2,                                       board_info_vcc0p9_current_s1.address
		.board_info_vcc0p9_current_s1_readdata                                    (mm_interconnect_0_board_info_vcc0p9_current_s1_readdata),      //   input,  width = 32,                                                                   .readdata
		.board_info_vcc1p03_vol_s1_address                                        (mm_interconnect_0_board_info_vcc1p03_vol_s1_address),          //  output,   width = 2,                                          board_info_vcc1p03_vol_s1.address
		.board_info_vcc1p03_vol_s1_readdata                                       (mm_interconnect_0_board_info_vcc1p03_vol_s1_readdata),         //   input,  width = 32,                                                                   .readdata
		.board_info_vcc1p03_current_s1_address                                    (mm_interconnect_0_board_info_vcc1p03_current_s1_address),      //  output,   width = 2,                                      board_info_vcc1p03_current_s1.address
		.board_info_vcc1p03_current_s1_readdata                                   (mm_interconnect_0_board_info_vcc1p03_current_s1_readdata),     //   input,  width = 32,                                                                   .readdata
		.board_info_vcc12_vol_s1_address                                          (mm_interconnect_0_board_info_vcc12_vol_s1_address),            //  output,   width = 2,                                            board_info_vcc12_vol_s1.address
		.board_info_vcc12_vol_s1_readdata                                         (mm_interconnect_0_board_info_vcc12_vol_s1_readdata),           //   input,  width = 32,                                                                   .readdata
		.board_info_vcc12_current_s1_address                                      (mm_interconnect_0_board_info_vcc12_current_s1_address),        //  output,   width = 2,                                        board_info_vcc12_current_s1.address
		.board_info_vcc12_current_s1_readdata                                     (mm_interconnect_0_board_info_vcc12_current_s1_readdata),       //   input,  width = 32,                                                                   .readdata
		.intel_niosv_m_timer_sw_agent_address                                     (mm_interconnect_0_intel_niosv_m_timer_sw_agent_address),       //  output,   width = 6,                                       intel_niosv_m_timer_sw_agent.address
		.intel_niosv_m_timer_sw_agent_write                                       (mm_interconnect_0_intel_niosv_m_timer_sw_agent_write),         //  output,   width = 1,                                                                   .write
		.intel_niosv_m_timer_sw_agent_read                                        (mm_interconnect_0_intel_niosv_m_timer_sw_agent_read),          //  output,   width = 1,                                                                   .read
		.intel_niosv_m_timer_sw_agent_readdata                                    (mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdata),      //   input,  width = 32,                                                                   .readdata
		.intel_niosv_m_timer_sw_agent_writedata                                   (mm_interconnect_0_intel_niosv_m_timer_sw_agent_writedata),     //  output,  width = 32,                                                                   .writedata
		.intel_niosv_m_timer_sw_agent_byteenable                                  (mm_interconnect_0_intel_niosv_m_timer_sw_agent_byteenable),    //  output,   width = 4,                                                                   .byteenable
		.intel_niosv_m_timer_sw_agent_readdatavalid                               (mm_interconnect_0_intel_niosv_m_timer_sw_agent_readdatavalid), //   input,   width = 1,                                                                   .readdatavalid
		.intel_niosv_m_timer_sw_agent_waitrequest                                 (mm_interconnect_0_intel_niosv_m_timer_sw_agent_waitrequest),   //   input,   width = 1,                                                                   .waitrequest
		.intel_niosv_m_data_manager_awaddr                                        (intel_niosv_m_data_manager_awaddr),                            //   input,  width = 32,                                         intel_niosv_m_data_manager.awaddr
		.intel_niosv_m_data_manager_awprot                                        (intel_niosv_m_data_manager_awprot),                            //   input,   width = 3,                                                                   .awprot
		.intel_niosv_m_data_manager_awvalid                                       (intel_niosv_m_data_manager_awvalid),                           //   input,   width = 1,                                                                   .awvalid
		.intel_niosv_m_data_manager_awready                                       (intel_niosv_m_data_manager_awready),                           //  output,   width = 1,                                                                   .awready
		.intel_niosv_m_data_manager_wdata                                         (intel_niosv_m_data_manager_wdata),                             //   input,  width = 32,                                                                   .wdata
		.intel_niosv_m_data_manager_wstrb                                         (intel_niosv_m_data_manager_wstrb),                             //   input,   width = 4,                                                                   .wstrb
		.intel_niosv_m_data_manager_wvalid                                        (intel_niosv_m_data_manager_wvalid),                            //   input,   width = 1,                                                                   .wvalid
		.intel_niosv_m_data_manager_wready                                        (intel_niosv_m_data_manager_wready),                            //  output,   width = 1,                                                                   .wready
		.intel_niosv_m_data_manager_bresp                                         (intel_niosv_m_data_manager_bresp),                             //  output,   width = 2,                                                                   .bresp
		.intel_niosv_m_data_manager_bvalid                                        (intel_niosv_m_data_manager_bvalid),                            //  output,   width = 1,                                                                   .bvalid
		.intel_niosv_m_data_manager_bready                                        (intel_niosv_m_data_manager_bready),                            //   input,   width = 1,                                                                   .bready
		.intel_niosv_m_data_manager_araddr                                        (intel_niosv_m_data_manager_araddr),                            //   input,  width = 32,                                                                   .araddr
		.intel_niosv_m_data_manager_arprot                                        (intel_niosv_m_data_manager_arprot),                            //   input,   width = 3,                                                                   .arprot
		.intel_niosv_m_data_manager_arvalid                                       (intel_niosv_m_data_manager_arvalid),                           //   input,   width = 1,                                                                   .arvalid
		.intel_niosv_m_data_manager_arready                                       (intel_niosv_m_data_manager_arready),                           //  output,   width = 1,                                                                   .arready
		.intel_niosv_m_data_manager_rdata                                         (intel_niosv_m_data_manager_rdata),                             //  output,  width = 32,                                                                   .rdata
		.intel_niosv_m_data_manager_rresp                                         (intel_niosv_m_data_manager_rresp),                             //  output,   width = 2,                                                                   .rresp
		.intel_niosv_m_data_manager_rvalid                                        (intel_niosv_m_data_manager_rvalid),                            //  output,   width = 1,                                                                   .rvalid
		.intel_niosv_m_data_manager_rready                                        (intel_niosv_m_data_manager_rready),                            //   input,   width = 1,                                                                   .rready
		.intel_niosv_m_instruction_manager_awaddr                                 (intel_niosv_m_instruction_manager_awaddr),                     //   input,  width = 32,                                  intel_niosv_m_instruction_manager.awaddr
		.intel_niosv_m_instruction_manager_awprot                                 (intel_niosv_m_instruction_manager_awprot),                     //   input,   width = 3,                                                                   .awprot
		.intel_niosv_m_instruction_manager_awvalid                                (intel_niosv_m_instruction_manager_awvalid),                    //   input,   width = 1,                                                                   .awvalid
		.intel_niosv_m_instruction_manager_awready                                (intel_niosv_m_instruction_manager_awready),                    //  output,   width = 1,                                                                   .awready
		.intel_niosv_m_instruction_manager_wdata                                  (intel_niosv_m_instruction_manager_wdata),                      //   input,  width = 32,                                                                   .wdata
		.intel_niosv_m_instruction_manager_wstrb                                  (intel_niosv_m_instruction_manager_wstrb),                      //   input,   width = 4,                                                                   .wstrb
		.intel_niosv_m_instruction_manager_wvalid                                 (intel_niosv_m_instruction_manager_wvalid),                     //   input,   width = 1,                                                                   .wvalid
		.intel_niosv_m_instruction_manager_wready                                 (intel_niosv_m_instruction_manager_wready),                     //  output,   width = 1,                                                                   .wready
		.intel_niosv_m_instruction_manager_bresp                                  (intel_niosv_m_instruction_manager_bresp),                      //  output,   width = 2,                                                                   .bresp
		.intel_niosv_m_instruction_manager_bvalid                                 (intel_niosv_m_instruction_manager_bvalid),                     //  output,   width = 1,                                                                   .bvalid
		.intel_niosv_m_instruction_manager_bready                                 (intel_niosv_m_instruction_manager_bready),                     //   input,   width = 1,                                                                   .bready
		.intel_niosv_m_instruction_manager_araddr                                 (intel_niosv_m_instruction_manager_araddr),                     //   input,  width = 32,                                                                   .araddr
		.intel_niosv_m_instruction_manager_arprot                                 (intel_niosv_m_instruction_manager_arprot),                     //   input,   width = 3,                                                                   .arprot
		.intel_niosv_m_instruction_manager_arvalid                                (intel_niosv_m_instruction_manager_arvalid),                    //   input,   width = 1,                                                                   .arvalid
		.intel_niosv_m_instruction_manager_arready                                (intel_niosv_m_instruction_manager_arready),                    //  output,   width = 1,                                                                   .arready
		.intel_niosv_m_instruction_manager_rdata                                  (intel_niosv_m_instruction_manager_rdata),                      //  output,  width = 32,                                                                   .rdata
		.intel_niosv_m_instruction_manager_rresp                                  (intel_niosv_m_instruction_manager_rresp),                      //  output,   width = 2,                                                                   .rresp
		.intel_niosv_m_instruction_manager_rvalid                                 (intel_niosv_m_instruction_manager_rvalid),                     //  output,   width = 1,                                                                   .rvalid
		.intel_niosv_m_instruction_manager_rready                                 (intel_niosv_m_instruction_manager_rready),                     //   input,   width = 1,                                                                   .rready
		.intel_niosv_m_reset_reset_bridge_in_reset_reset                          (reset_controller_reset_out_reset),                             //   input,   width = 1,                          intel_niosv_m_reset_reset_bridge_in_reset.reset
		.jtag_uart_avalon_jtag_slave_translator_reset_reset_bridge_in_reset_reset (reset_controller_reset_out_reset),                             //   input,   width = 1, jtag_uart_avalon_jtag_slave_translator_reset_reset_bridge_in_reset.reset
		.clock_in_out_clk_clk                                                     (clock_in_out_clk_clk)                                          //   input,   width = 1,                                                   clock_in_out_clk.clk
	);

	system_altera_irq_mapper_2001_qylhc4a irq_mapper (
		.clk           (clock_in_out_clk_clk),              //   input,   width = 1,       clk.clk
		.reset         (rst_controller_reset_out_reset),    //   input,   width = 1, clk_reset.reset
		.receiver0_irq (irq_mapper_receiver0_irq),          //   input,   width = 1, receiver0.irq
		.receiver1_irq (irq_mapper_receiver1_irq),          //   input,   width = 1, receiver1.irq
		.sender_irq    (intel_niosv_m_platform_irq_rx_irq)  //  output,  width = 16,    sender.irq
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (reset_controller_reset_out_reset),   //   input,  width = 1, reset_in0.reset
		.clk            (clock_in_out_clk_clk),               //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_reset_out_reset),     //  output,  width = 1, reset_out.reset
		.reset_req      (rst_controller_reset_out_reset_req), //  output,  width = 1,          .reset_req
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

endmodule
