source [file join [file dirname [info script]] ./../../../ip/system/system_intel_onchip_memory_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/reset_controller/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/system_intel_niosv_m_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/board_info_pio/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/clock_in/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/sysid_qsys/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/timer/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/system/jtag_uart/sim/common/modelsim_files.tcl]

namespace eval system {
  proc get_design_libraries {} {
    set libraries [dict create]
    set libraries [dict merge $libraries [system_intel_onchip_memory_0::get_design_libraries]]
    set libraries [dict merge $libraries [reset_controller::get_design_libraries]]
    set libraries [dict merge $libraries [system_intel_niosv_m_0::get_design_libraries]]
    set libraries [dict merge $libraries [board_info_pio::get_design_libraries]]
    set libraries [dict merge $libraries [clock_in::get_design_libraries]]
    set libraries [dict merge $libraries [sysid_qsys::get_design_libraries]]
    set libraries [dict merge $libraries [timer::get_design_libraries]]
    set libraries [dict merge $libraries [jtag_uart::get_design_libraries]]
    dict set libraries altera_merlin_slave_translator_191 1
    dict set libraries altera_merlin_axi_master_ni_19100  1
    dict set libraries altera_merlin_slave_agent_1930     1
    dict set libraries altera_avalon_sc_fifo_1932         1
    dict set libraries altera_merlin_router_1921          1
    dict set libraries altera_merlin_traffic_limiter_1921 1
    dict set libraries altera_merlin_demultiplexer_1921   1
    dict set libraries altera_merlin_multiplexer_1922     1
    dict set libraries altera_mm_interconnect_1920        1
    dict set libraries altera_irq_mapper_2001             1
    dict set libraries altera_reset_controller_1924       1
    dict set libraries system                             1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR} {
    set memory_files [list]
    set memory_files [concat $memory_files [system_intel_onchip_memory_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/"]]
    set memory_files [concat $memory_files [reset_controller::get_memory_files "$QSYS_SIMDIR/../../ip/system/reset_controller/sim/"]]
    set memory_files [concat $memory_files [system_intel_niosv_m_0::get_memory_files "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_m_0/sim/"]]
    set memory_files [concat $memory_files [board_info_pio::get_memory_files "$QSYS_SIMDIR/../../ip/system/board_info_pio/sim/"]]
    set memory_files [concat $memory_files [clock_in::get_memory_files "$QSYS_SIMDIR/../../ip/system/clock_in/sim/"]]
    set memory_files [concat $memory_files [sysid_qsys::get_memory_files "$QSYS_SIMDIR/../../ip/system/sysid_qsys/sim/"]]
    set memory_files [concat $memory_files [timer::get_memory_files "$QSYS_SIMDIR/../../ip/system/timer/sim/"]]
    set memory_files [concat $memory_files [jtag_uart::get_memory_files "$QSYS_SIMDIR/../../ip/system/jtag_uart/sim/"]]
    return $memory_files
  }
  
  proc get_common_design_files {QSYS_SIMDIR} {
    set design_files [dict create]
    set design_files [dict merge $design_files [system_intel_onchip_memory_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/"]]
    set design_files [dict merge $design_files [reset_controller::get_common_design_files "$QSYS_SIMDIR/../../ip/system/reset_controller/sim/"]]
    set design_files [dict merge $design_files [system_intel_niosv_m_0::get_common_design_files "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_m_0/sim/"]]
    set design_files [dict merge $design_files [board_info_pio::get_common_design_files "$QSYS_SIMDIR/../../ip/system/board_info_pio/sim/"]]
    set design_files [dict merge $design_files [clock_in::get_common_design_files "$QSYS_SIMDIR/../../ip/system/clock_in/sim/"]]
    set design_files [dict merge $design_files [sysid_qsys::get_common_design_files "$QSYS_SIMDIR/../../ip/system/sysid_qsys/sim/"]]
    set design_files [dict merge $design_files [timer::get_common_design_files "$QSYS_SIMDIR/../../ip/system/timer/sim/"]]
    set design_files [dict merge $design_files [jtag_uart::get_common_design_files "$QSYS_SIMDIR/../../ip/system/jtag_uart/sim/"]]
    return $design_files
  }
  
  proc get_design_files {QSYS_SIMDIR} {
    set design_files [list]
    set design_files [concat $design_files [system_intel_onchip_memory_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/"]]
    set design_files [concat $design_files [reset_controller::get_design_files "$QSYS_SIMDIR/../../ip/system/reset_controller/sim/"]]
    set design_files [concat $design_files [system_intel_niosv_m_0::get_design_files "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_m_0/sim/"]]
    set design_files [concat $design_files [board_info_pio::get_design_files "$QSYS_SIMDIR/../../ip/system/board_info_pio/sim/"]]
    set design_files [concat $design_files [clock_in::get_design_files "$QSYS_SIMDIR/../../ip/system/clock_in/sim/"]]
    set design_files [concat $design_files [sysid_qsys::get_design_files "$QSYS_SIMDIR/../../ip/system/sysid_qsys/sim/"]]
    set design_files [concat $design_files [timer::get_design_files "$QSYS_SIMDIR/../../ip/system/timer/sim/"]]
    set design_files [concat $design_files [jtag_uart::get_design_files "$QSYS_SIMDIR/../../ip/system/jtag_uart/sim/"]]
    lappend design_files "-makelib altera_merlin_slave_translator_191 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_translator_191/sim/system_altera_merlin_slave_translator_191_xg7rzxi.sv"]\"   -end"                     
    lappend design_files "-makelib altera_merlin_axi_master_ni_19100 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_19100/sim/altera_merlin_address_alignment.sv"]\"   -end"                                         
    lappend design_files "-makelib altera_merlin_axi_master_ni_19100 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_19100/sim/system_altera_merlin_axi_master_ni_19100_y3ctica.sv"]\"   -end"                        
    lappend design_files "-makelib altera_merlin_slave_agent_1930 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1930/sim/system_altera_merlin_slave_agent_1930_jxauz3i.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_slave_agent_1930 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1930/sim/altera_merlin_burst_uncompressor.sv"]\"   -end"                                              
    lappend design_files "-makelib altera_avalon_sc_fifo_1932 \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_sc_fifo_1932/sim/system_altera_avalon_sc_fifo_1932_22gxxgi.v"]\"   -end"                                              
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_jc3ktgy.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_vudizdi.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_v2xgt3i.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/system_altera_merlin_router_1921_6gnrmly.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/system_altera_merlin_traffic_limiter_altera_avalon_sc_fifo_1921_jyjty3i.v"]\"   -end"
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_merlin_reorder_memory.sv"]\"   -end"                                          
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_avalon_st_pipeline_base.v"]\"   -end"                                         
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/system_altera_merlin_traffic_limiter_1921_2thi65i.sv"]\"   -end"                     
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_ovq52hi.sv"]\"   -end"                           
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_lj6qajy.sv"]\"   -end"                           
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_hc77obq.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                      
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_q6wcisi.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                      
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_4fkicii.sv"]\"   -end"                           
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/system_altera_merlin_demultiplexer_1921_pqcg3iq.sv"]\"   -end"                           
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_3gzcgsa.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                      
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/system_altera_merlin_multiplexer_1922_asryxuy.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                      
    lappend design_files "-makelib altera_mm_interconnect_1920 \"[normalize_path "$QSYS_SIMDIR/../altera_mm_interconnect_1920/sim/system_altera_mm_interconnect_1920_6o6jbei.v"]\"   -end"                                           
    lappend design_files "-makelib altera_irq_mapper_2001 \"[normalize_path "$QSYS_SIMDIR/../altera_irq_mapper_2001/sim/system_altera_irq_mapper_2001_qylhc4a.sv"]\"   -end"                                                         
    lappend design_files "-makelib altera_reset_controller_1924 \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_controller.v"]\"   -end"                                                            
    lappend design_files "-makelib altera_reset_controller_1924 \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_synchronizer.v"]\"   -end"                                                          
    lappend design_files "-makelib system \"[normalize_path "$QSYS_SIMDIR/system.v"]\"   -end"                                                                                                                                       
    return $design_files
  }
  
  proc get_non_duplicate_elab_option {ELAB_OPTIONS NEW_ELAB_OPTION} {
    set IS_DUPLICATE [string first $NEW_ELAB_OPTION $ELAB_OPTIONS]
    if {$IS_DUPLICATE == -1} {
      return $NEW_ELAB_OPTION
    } else {
      return ""
    }
  }
  
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_intel_onchip_memory_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [reset_controller::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [system_intel_niosv_m_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [board_info_pio::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [clock_in::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [sysid_qsys::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [timer::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [jtag_uart::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    append SIM_OPTIONS [system_intel_onchip_memory_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [reset_controller::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [system_intel_niosv_m_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [board_info_pio::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [clock_in::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [sysid_qsys::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [timer::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [jtag_uart::get_sim_options $SIMULATOR_TOOL_BITNESS]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_intel_onchip_memory_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [reset_controller::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [system_intel_niosv_m_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [board_info_pio::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [clock_in::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [sysid_qsys::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [timer::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [jtag_uart::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    set libraries [dict merge $libraries [system_intel_onchip_memory_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_intel_onchip_memory_0/sim/"]]
    set libraries [dict merge $libraries [reset_controller::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/reset_controller/sim/"]]
    set libraries [dict merge $libraries [system_intel_niosv_m_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/system_intel_niosv_m_0/sim/"]]
    set libraries [dict merge $libraries [board_info_pio::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/board_info_pio/sim/"]]
    set libraries [dict merge $libraries [clock_in::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/clock_in/sim/"]]
    set libraries [dict merge $libraries [sysid_qsys::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/sysid_qsys/sim/"]]
    set libraries [dict merge $libraries [timer::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/timer/sim/"]]
    set libraries [dict merge $libraries [jtag_uart::get_dpi_libraries "$QSYS_SIMDIR/../../ip/system/jtag_uart/sim/"]]
    
    return $libraries
  }
  
}
