// (C) 2001-2024 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera MegaCore Function License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// $Id: //acds/rel/24.3/ip/iconnect/merlin/altera_merlin_router/altera_merlin_router.sv.terp#1 $
// $Revision: #1 $
// $Date: 2024/08/01 $

// -------------------------------------------------------
// Merlin Router
//
// Asserts the appropriate one-hot encoded channel based on 
// the address.
//
// Also sets the binary-encoded destination id.
// -------------------------------------------------------

`timescale 1 ns / 1 ns

// ------------------------------------------
// Generation parameters:
//    decoder_type            0 (address decoder)
//    default_channel         3
//    default_destid          19
//    default_rd_channel      -1
//    default_wr_channel      -1
//    has_default_slave       0
//    memory_aliasing_decode  0
//    output_name             system_altera_merlin_router_1921_jc3ktgy
//    pkt_addr_h              67
//    pkt_addr_l              36
//    pkt_dest_id_h           96
//    pkt_dest_id_l           92
//    pkt_protection_h        100
//    pkt_protection_l        98
//    pkt_trans_read          71
//    pkt_trans_write         70
//    slaves_info             19:00000000000000000001000:0x0:0x80000:both:1:0:0:1,17:00000000000000000000100:0x80000:0x90000:both:1:0:0:1,18:10000000000000000000000:0x90000:0x90040:both:1:0:0:1,22:00000000000000000010000:0x90040:0x90060:both:1:0:0:1,9:01000000000000000000000:0x90060:0x90070:read:1:0:0:1,10:00100000000000000000000:0x90070:0x90080:read:1:0:0:1,7:00010000000000000000000:0x90080:0x90090:read:1:0:0:1,8:00001000000000000000000:0x90090:0x900a0:read:1:0:0:1,16:00000100000000000000000:0x900a0:0x900b0:read:1:0:0:1,13:00000010000000000000000:0x900b0:0x900c0:read:1:0:0:1,6:00000001000000000000000:0x900c0:0x900d0:read:1:0:0:1,15:00000000100000000000000:0x900d0:0x900e0:read:1:0:0:1,3:00000000010000000000000:0x900e0:0x900f0:read:1:0:0:1,4:00000000001000000000000:0x900f0:0x90100:read:1:0:0:1,5:00000000000100000000000:0x90100:0x90110:read:1:0:0:1,2:00000000000010000000000:0x90110:0x90120:read:1:0:0:1,11:00000000000001000000000:0x90120:0x90130:read:1:0:0:1,12:00000000000000100000000:0x90130:0x90140:read:1:0:0:1,0:00000000000000010000000:0x90140:0x90150:read:1:0:0:1,1:00000000000000001000000:0x90150:0x90160:read:1:0:0:1,14:00000000000000000100000:0x90160:0x90170:read:1:0:0:1,21:00000000000000000000010:0x90170:0x90178:read:1:0:0:1,20:00000000000000000000001:0x90178:0x90180:both:1:0:0:1
//    st_channel_w            23
//    st_data_w               134
// ------------------------------------------

module system_altera_merlin_router_1921_jc3ktgy_default_decode
  #(
     parameter DEFAULT_CHANNEL = 3,
               DEFAULT_WR_CHANNEL = -1,
               DEFAULT_RD_CHANNEL = -1,
               DEFAULT_DESTID = 19 
   )
  (output [96 - 92 : 0] default_destination_id,
   output [23-1 : 0] default_wr_channel,
   output [23-1 : 0] default_rd_channel,
   output [23-1 : 0] default_src_channel
  );

  assign default_destination_id = 
    DEFAULT_DESTID[96 - 92 : 0];

  generate
    if (DEFAULT_CHANNEL == -1) begin : no_default_channel_assignment
      assign default_src_channel = '0;
    end
    else begin : default_channel_assignment
      assign default_src_channel = 23'b1 << DEFAULT_CHANNEL;
    end
  endgenerate

  generate
    if (DEFAULT_RD_CHANNEL == -1) begin : no_default_rw_channel_assignment
      assign default_wr_channel = '0;
      assign default_rd_channel = '0;
    end
    else begin : default_rw_channel_assignment
      assign default_wr_channel = 23'b1 << DEFAULT_WR_CHANNEL;
      assign default_rd_channel = 23'b1 << DEFAULT_RD_CHANNEL;
    end
  endgenerate

endmodule


module system_altera_merlin_router_1921_jc3ktgy
(
    // -------------------
    // Clock & Reset
    // -------------------
    input clk,
    input reset,

    // -------------------
    // Command Sink (Input)
    // -------------------
    input                       sink_valid,
    input  [134-1 : 0]    sink_data,
    input                       sink_startofpacket,
    input                       sink_endofpacket,
    output                      sink_ready,

    // -------------------
    // Command Source (Output)
    // -------------------
    output                          src_valid,
    output reg [134-1    : 0] src_data,
    output reg [23-1 : 0] src_channel,
    output                          src_startofpacket,
    output                          src_endofpacket,
    input                           src_ready
);

    // -------------------------------------------------------
    // Local parameters and variables
    // -------------------------------------------------------
    localparam PKT_ADDR_H = 67;
    localparam PKT_ADDR_L = 36;
    localparam PKT_DEST_ID_H = 96;
    localparam PKT_DEST_ID_L = 92;
    localparam PKT_PROTECTION_H = 100;
    localparam PKT_PROTECTION_L = 98;
    localparam ST_DATA_W = 134;
    localparam ST_CHANNEL_W = 23;
    localparam DECODER_TYPE = 0;

    localparam PKT_TRANS_WRITE = 70;
    localparam PKT_TRANS_READ  = 71;

    localparam PKT_ADDR_W = PKT_ADDR_H-PKT_ADDR_L + 1;
    localparam PKT_DEST_ID_W = PKT_DEST_ID_H-PKT_DEST_ID_L + 1;



    // -------------------------------------------------------
    // Figure out the number of bits to mask off for each slave span
    // during address decoding
    // -------------------------------------------------------
    // -------------------------------------------------------
    // Work out which address bits are significant based on the
    // address range of the slaves. If the required width is too
    // large or too small, we use the address field width instead.
    // -------------------------------------------------------
    localparam ADDR_RANGE = 64'h90180;
    localparam RANGE_ADDR_WIDTH = log2ceil(ADDR_RANGE);
    localparam OPTIMIZED_ADDR_H = (RANGE_ADDR_WIDTH > PKT_ADDR_W) ||
                                  (RANGE_ADDR_WIDTH == 0) ?
                                        PKT_ADDR_H :
                                        PKT_ADDR_L + RANGE_ADDR_WIDTH - 1;

    localparam REAL_ADDRESS_RANGE = OPTIMIZED_ADDR_H - PKT_ADDR_L;

      reg [PKT_ADDR_W-1 : 0] address;
      always @* begin
        address = {PKT_ADDR_W{1'b0}};
        address [REAL_ADDRESS_RANGE:0] = sink_data[OPTIMIZED_ADDR_H : PKT_ADDR_L];
      end   

    // -------------------------------------------------------
    // Pass almost everything through, untouched
    // -------------------------------------------------------
    assign sink_ready        = src_ready;
    assign src_valid         = sink_valid;
    assign src_startofpacket = sink_startofpacket;
    assign src_endofpacket   = sink_endofpacket;
    wire [PKT_DEST_ID_W-1:0] default_destid;
    wire [23-1 : 0] default_src_channel;




    // -------------------------------------------------------
    // Write and read transaction signals
    // -------------------------------------------------------
    wire read_transaction;
    assign read_transaction  = sink_data[PKT_TRANS_READ];


    system_altera_merlin_router_1921_jc3ktgy_default_decode the_default_decode(
      .default_destination_id (default_destid),
      .default_wr_channel   (),
      .default_rd_channel   (),
      .default_src_channel  (default_src_channel)
    );

    always @* begin
        src_data    = sink_data;
        src_channel = default_src_channel;
        src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = default_destid;

        // --------------------------------------------------
        // Address Decoder
        // Sets the channel and destination ID based on the address
        // --------------------------------------------------

        // slave 0: [0x0, 0x80000) : sel [19:19]
        if ( {address[19:19],{19 {1'b0}}} == 20'h0   ) begin
            src_channel = 23'b00000000000000000001000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 19;
        end

        // slave 1: [0x80000, 0x90000) : sel [19:16]
        if ( {address[19:16],{16 {1'b0}}} == 20'h80000   ) begin
            src_channel = 23'b00000000000000000000100;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 17;
        end

        // slave 2: [0x90000, 0x90040) : sel [19:6]
        if ( {address[19:6],{6 {1'b0}}} == 20'h90000   ) begin
            src_channel = 23'b10000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 18;
        end

        // slave 3: [0x90040, 0x90060) : sel [19:5]
        if ( {address[19:5],{5 {1'b0}}} == 20'h90040   ) begin
            src_channel = 23'b00000000000000000010000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 22;
        end

        // slave 4: [0x90060, 0x90070) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90060  && read_transaction  ) begin
            src_channel = 23'b01000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 9;
        end

        // slave 5: [0x90070, 0x90080) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90070  && read_transaction  ) begin
            src_channel = 23'b00100000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 10;
        end

        // slave 6: [0x90080, 0x90090) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90080  && read_transaction  ) begin
            src_channel = 23'b00010000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 7;
        end

        // slave 7: [0x90090, 0x900a0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90090  && read_transaction  ) begin
            src_channel = 23'b00001000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 8;
        end

        // slave 8: [0x900a0, 0x900b0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h900a0  && read_transaction  ) begin
            src_channel = 23'b00000100000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 16;
        end

        // slave 9: [0x900b0, 0x900c0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h900b0  && read_transaction  ) begin
            src_channel = 23'b00000010000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 13;
        end

        // slave 10: [0x900c0, 0x900d0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h900c0  && read_transaction  ) begin
            src_channel = 23'b00000001000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 6;
        end

        // slave 11: [0x900d0, 0x900e0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h900d0  && read_transaction  ) begin
            src_channel = 23'b00000000100000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 15;
        end

        // slave 12: [0x900e0, 0x900f0) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h900e0  && read_transaction  ) begin
            src_channel = 23'b00000000010000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 3;
        end

        // slave 13: [0x900f0, 0x90100) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h900f0  && read_transaction  ) begin
            src_channel = 23'b00000000001000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 4;
        end

        // slave 14: [0x90100, 0x90110) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90100  && read_transaction  ) begin
            src_channel = 23'b00000000000100000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 5;
        end

        // slave 15: [0x90110, 0x90120) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90110  && read_transaction  ) begin
            src_channel = 23'b00000000000010000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 2;
        end

        // slave 16: [0x90120, 0x90130) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90120  && read_transaction  ) begin
            src_channel = 23'b00000000000001000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 11;
        end

        // slave 17: [0x90130, 0x90140) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90130  && read_transaction  ) begin
            src_channel = 23'b00000000000000100000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 12;
        end

        // slave 18: [0x90140, 0x90150) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90140  && read_transaction  ) begin
            src_channel = 23'b00000000000000010000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 0;
        end

        // slave 19: [0x90150, 0x90160) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90150  && read_transaction  ) begin
            src_channel = 23'b00000000000000001000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 1;
        end

        // slave 20: [0x90160, 0x90170) : sel [19:4]
        if ( {address[19:4],{4 {1'b0}}} == 20'h90160  && read_transaction  ) begin
            src_channel = 23'b00000000000000000100000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 14;
        end

        // slave 21: [0x90170, 0x90178) : sel [19:3]
        if ( {address[19:3],{3 {1'b0}}} == 20'h90170  && read_transaction  ) begin
            src_channel = 23'b00000000000000000000010;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 21;
        end

        // slave 22: [0x90178, 0x90180) : sel [19:3]
        if ( {address[19:3],{3 {1'b0}}} == 20'h90178   ) begin
            src_channel = 23'b00000000000000000000001;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 20;
        end
    end


    // --------------------------------------------------
    // Ceil(log2()) function
    // It's the 21st century. Consider using $clog2().
    // --------------------------------------------------
    function integer log2ceil;
        input reg[65:0] val;
        reg [65:0] i;

        begin
            i = 1;
            log2ceil = 0;

            while (i < val) begin
                log2ceil = log2ceil + 1;
                i = i << 1;
            end
        end
    endfunction

endmodule


