// ============================================================================
// Copyright (c) 2022 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================

#include "terasic_includes.h"
#include <stdbool.h>

typedef bool (*LP_VERIFY_FUNC)(void);

bool TEST_Board_Info(void);

typedef struct {
    LP_VERIFY_FUNC func;
    char szName[128];
} FUNC_INFO;

FUNC_INFO szFuncList[] = { { TEST_Board_Info, "Display Board Info" } };

void GUI_ShowMenu(void)
{
    int nNum, i;

    nNum = sizeof(szFuncList) / sizeof(szFuncList[0]);
    printf("======= Titan S10 Demo Program =======\n");
    for (i = 0; i < nNum; i++) {
        printf("[%d] %s\n", i, szFuncList[i].szName);
    }
    printf("Input your chioce:");
}

int GUI_QueryUser(void)
{
    int nChoice = 0;
    scanf("%d", &nChoice);
    printf("%d\n", nChoice);
    return nChoice;
}

//===============================================================
int main(void)
{
    int nChoice;
    int nNum;
    bool bPass;

    nNum = sizeof(szFuncList) / sizeof(szFuncList[0]);
    while (1) {
        GUI_ShowMenu();
        nChoice = GUI_QueryUser();
        if (nChoice >= 0 && nChoice < nNum) {
            bPass = szFuncList[nChoice].func();
            printf("%s Test:%s\n", szFuncList[nChoice].szName,
                   bPass ? "PASS" : "NG");
        }
    }

}

bool TEST_Board_Info(void)
{
	int i, power_num;
    uint16_t fan_speed;
    uint16_t temperature_fpga, temperature_board, temperature_power;

    typedef struct{
    	char szName[64];
    	uint32_t VolBaseAddr;
    	uint32_t CurBaseAddr;
    	float fVolDiv;
    	float fCurDiv;
    	//
    	float fVol;
    	float fCur;
    }POWER_INFO;

    POWER_INFO szPowerInfo[] = {
    		{"VCC12 (Carrier)", BOARD_INFO_VCC12_VOL_BASE, BOARD_INFO_VCC12_CURRENT_BASE, 1000.0, 1000.0, 0, 0},
    		{"FPGA Core (SOM)", BOARD_INFO_CORE_VOL_BASE, BOARD_INFO_CORE_CURRENT_BASE, 1000.0, 100.0, 0, 0}, // current unit: 10mA
    		{"VCC1P8 (SOM)", BOARD_INFO_VCC1P8_VOL_BASE, BOARD_INFO_VCC1P8_CURRENT_BASE, 1000.0, 1000.0, 0, 0},
    		{"VCC3P3 (SOM)", BOARD_INFO_VCC3P3_VOL_BASE, BOARD_INFO_VCC3P3_CURRENT_BASE, 1000.0, 1000.0, 0, 0}, // currnet unit: 1mA
    		{"VCC0P9 (SOM)", BOARD_INFO_VCC0P9_VOL_BASE, BOARD_INFO_VCC0P9_CURRENT_BASE, 1000.0, 1000.0, 0, 0},
    		{"VCC1P03 (SOM)", BOARD_INFO_VCC1P03_VOL_BASE, BOARD_INFO_VCC1P03_CURRENT_BASE, 1000.0, 1000.0, 0, 0},
    		{"VCC1P2_IO (SOM)", BOARD_INFO_VCC1P2_IO_VOL_BASE, BOARD_INFO_VCC1P2_IO_CURRENT_BASE, 1000.0, 1000.0, 0, 0},
    };

    // query power
    power_num = sizeof(szPowerInfo)/sizeof(szPowerInfo[0]);
    for(i=0;i<power_num;i++){
    	szPowerInfo[i].fVol = (float)(IORD_ALTERA_AVALON_PIO_DATA(szPowerInfo[i].VolBaseAddr) & 0xFFFF)/szPowerInfo[i].fVolDiv;
    	szPowerInfo[i].fCur = (float)(IORD_ALTERA_AVALON_PIO_DATA(szPowerInfo[i].CurBaseAddr) & 0xFFFF)/szPowerInfo[i].fCurDiv;

    }

    // query fan and temperature
    fan_speed = IORD_ALTERA_AVALON_PIO_DATA(BOARD_INFO_FAN_SPEED_BASE) & 0xFFFF;
    temperature_fpga = IORD_ALTERA_AVALON_PIO_DATA(BOARD_INFO_TEMPERATURE_FPGA_BASE) & 0xFFFF;
    temperature_board = IORD_ALTERA_AVALON_PIO_DATA(BOARD_INFO_TEMPERATURE_BOARD_BASE) & 0xFFFF;
    temperature_power = IORD_ALTERA_AVALON_PIO_DATA(BOARD_INFO_TEMPERATURE_POWER_BASE) & 0xFFFF;



    printf("==== Temperature ====\n");
    printf("\tFPGA: %d*C\n", temperature_fpga);
    printf("\tBoard: %d*C\n", temperature_board);
    printf("\tPower: %d*C\n", temperature_power);
    printf("\n");
    printf("==== Fan ====\n");
    printf("\tFan Speed (RPM): %d\n", fan_speed);
    printf("\n");
    printf("==== Power Monitor ====\n");
    for(i=0;i<power_num;i++){
        printf("%s:\n", szPowerInfo[i].szName);
        printf("\tVoltage       = %.3f V \n", szPowerInfo[i].fVol);
        printf("\tCurrent       = %.3f A \n", szPowerInfo[i].fCur);
        printf("\tConsumption   = %.3f W \n", szPowerInfo[i].fVol * szPowerInfo[i].fCur);

    }

    return true;
}
