// ============================================================================
// Copyright (c) 2025 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Fri Apr 11 16:25:12 2025
// ============================================================================

//`define ENABLE_DDR4A
//`define ENABLE_DDR4B
//`define ENABLE_XCVR
//`define ENABLE_HPS
//`define ENABLE_PCIE
//`define ENABLE_MCIO
//`define ENABLE_QSFPA
//`define ENABLE_QSFPB

module golden_top(

      ///////// CLOCK /////////
      input              CLK_100_B3A,
      input              CLK_100_B3L,
      input              CLK_25_B3L,

      ///////// Buttons /////////
      input    [ 1: 0]   BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   SW,

      ///////// LED /////////
      output   [ 1: 0]   LED, //LED is Low-Active

      ///////// Reset /////////
      input              FPGA_RST,
      input              HPS_RST,

`ifdef ENABLE_DDR4A
      ///////// DDR4A /////////
      input              DDR4A_REFCLK_p,
      output   [16: 0]   DDR4A_A,
      output   [ 1: 0]   DDR4A_BA,
      output   [ 0: 0]   DDR4A_BG,
      output             DDR4A_CK,
      output             DDR4A_CK_n,
      output             DDR4A_CKE,
      inout    [ 7: 0]   DDR4A_DQS,
      inout    [ 7: 0]   DDR4A_DQS_n,
      inout    [63: 0]   DDR4A_DQ,
      inout    [ 7: 0]   DDR4A_DBI_n,
      output             DDR4A_CS_n,
      output             DDR4A_RESET_n,
      output             DDR4A_ODT,
      output             DDR4A_PAR,
      input              DDR4A_ALERT_n,
      output             DDR4A_ACT_n,
      input              DDR4A_RZQ,
`endif /*ENABLE_DDR4A*/

`ifdef ENABLE_DDR4B
      ///////// DDR4B /////////
      input              DDR4B_REFCLK_p,
      output   [16: 0]   DDR4B_A,
      output   [ 1: 0]   DDR4B_BA,
      output   [ 0: 0]   DDR4B_BG,
      output             DDR4B_CK,
      output             DDR4B_CK_n,
      output             DDR4B_CKE,
      inout    [ 7: 0]   DDR4B_DQS,
      inout    [ 7: 0]   DDR4B_DQS_n,
      inout    [63: 0]   DDR4B_DQ,
      inout    [ 7: 0]   DDR4B_DBI_n,
      output             DDR4B_CS_n,
      output             DDR4B_RESET_n,
      output             DDR4B_ODT,
      output             DDR4B_PAR,
      input              DDR4B_ALERT_n,
      output             DDR4B_ACT_n,
      input              DDR4B_RZQ,
`endif /*ENABLE_DDR4B*/

      ///////// USBFX3 /////////
      output             USBFX3_RESET_n,
      output             USBFX3_PCLK,
      output             USBFX3_CTL0_SLCS_n,
      output             USBFX3_UART_TX,
      input              USBFX3_UART_RX,
      output             USBFX3_CTL10,
      output             USBFX3_CTL11_A1,
      output             USBFX3_CTL12_A0,
      input              USBFX3_CTL15_INT_n,
      output             USBFX3_CTL1_SLWR_n,
      output             USBFX3_CTL2_SLOE_n,
      output             USBFX3_CTL3_SLRD_n,
      input              USBFX3_CTL4_FLAGA,
      input              USBFX3_CTL5_FLAGB,
      input              USBFX3_CTL6_FLAGC,
      output             USBFX3_CTL7_PKTEND_n,
      input              USBFX3_CTL8_FLAGD,
      output             USBFX3_CTL9,
      inout    [31: 0]   USBFX3_DQ,
      inout              USBFX3_OTG_ID,
      output             USBFX3_USB_MODE,

      ///////// ENETB /////////
      input              ENETB_RX_CLK,
      input    [ 7: 0]   ENETB_RX_DATA,
      input              ENETB_RX_COL,
      input              ENETB_RX_CRS,
      input              ENETB_RX_DV,
      input              ENETB_RX_ER,
      output             ENETB_GTX_CLK,
      output   [ 7: 0]   ENETB_TX_DATA,
      output             ENETB_TX_EN,
      output             ENETB_TX_ER,
      input              ENETB_INT_n,
      output             ENETB_MDC,
      inout              ENETB_MDIO,
      output             ENETB_RESET_n,

      ///////// I2C for EEPROM (Si5341) /////////
      inout              FPGA_I2C_SCL,
      inout              FPGA_I2C_SDA,

      ///////// Power Monitor /////////
      inout              PM_I2C_SCL,
      inout              PM_I2C_SDA,
      input              PM_ALERT_n,

`ifdef ENABLE_PCIE
      ///////// PCIe Edge /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      input              PCIE_REFCLK_p, //CLK2_XCVR_1C_p
      output   [15: 0]   PCIE_TX_p,
      input    [15: 0]   PCIE_RX_p,
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFPA
      ///////// QSFPA /////////
      input              QSFPA_REFCLK_p, //LGBTCLK2_1L_p
      output   [ 3: 0]   QSFPA_TX_p,
      input    [ 3: 0]   QSFPA_RX_p,
      input              QSFPA_INTERRUPT_n,
      output             QSFPA_LP_MODE,
      input              QSFPA_MOD_PRS_n,
      output             QSFPA_MOD_SEL_n,
      output             QSFPA_RST_n,
      inout              QSFPA_SCL,
      inout              QSFPA_SDA,
`endif /*ENABLE_QSFPA*/

`ifdef ENABLE_QSFPB
      ///////// QSFPB /////////
      input              QSFPB_REFCLK_p, //LGBTCLK1_1M_p
      output   [ 3: 0]   QSFPB_TX_p,
      input    [ 3: 0]   QSFPB_RX_p,
      input              QSFPB_INTERRUPT_n,
      output             QSFPB_LP_MODE,
      input              QSFPB_MOD_PRS_n,
      output             QSFPB_MOD_SEL_n,
      output             QSFPB_RST_n,
      inout              QSFPB_SCL,
      inout              QSFPB_SDA,
`endif /*ENABLE_QSFPB*/

`ifdef ENABLE_XCVR
      ///////// Transceiver reference clock /////////
      input              XCVR_REFCLK1D_p,
      input              XCVR_REFCLK1E_p,
      input              XCVR_REFCLK1K_p,
      input              XCVR_REFCLK1L_p,
      input              XCVR_REFCLK1M_p,
`endif /*ENABLE_XCVR*/

`ifdef ENABLE_MCIO
      ///////// MCIO /////////
      inout              MCIO_SMBCLK,
      inout              MCIO_SMBDAT,
      input              MCIO_CONN_CLK_p, //RGBTCLK0_1K_p
      output   [ 7: 0]   MCIO_TX_p,
      input    [ 7: 0]   MCIO_RX_p,
      input              MCIO_PERST_n,
      input              MCIO_SMB_ALERT_n,
`endif /*ENABLE_MCIO*/

      ///////// EXP /////////
      input              EXP_EN,

`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_EMMC_CLK,
      inout              HPS_EMMC_CMD,
      inout    [ 3: 0]   HPS_EMMC_DATA,
      output             HPS_ENETA_MDC,
      inout              HPS_ENETA_MDIO,
      input              HPS_ENETA_RX_CLK,
      input              HPS_ENETA_RX_CTL,
      input    [ 3: 0]   HPS_ENETA_RX_DATA,
      output             HPS_ENETA_TX_CLK,
      output             HPS_ENETA_TX_CTL,
      output   [ 3: 0]   HPS_ENETA_TX_DATA,
      inout    [ 1: 0]   HPS_GPIO,
      inout              HPS_I2C_SCL,
      inout              HPS_I2C_SDA,
      input              HPS_OSC_CLK,
      input              HPS_UART_CTS,
      output             HPS_UART_RTS,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);

//=======================================================
//  REG/WIRE declarations
//=======================================================

assign SI5340B_OE_n = 1'bZ;
assign SI5340B_RST_n = 1'bZ;
assign SI5391B_OE_n = 1'bZ;
assign SI5391B_RST_n = 1'bZ;




//=======================================================
//  Structural coding
//=======================================================

wire clk_50;
wire sys_reset;

//System Monitor IP
//IP interface
wire Info_Valid;
wire [15: 0] Board_Version;     //A~F.ex BOARD_VERSION = 16'h000b ,express to revB
wire [15: 0] MaxCode_Version;   //0~F.ex MAX10_VERSION = 16'h0004 ,express to rev4
wire [15: 0] CORE_Voltage;      //unit : mV
wire [15: 0] CORE_Current;      //unit : 10mA
wire [15: 0] VCC3P3_Voltage;      //unit : mV
wire [15: 0] VCC3P3_Current;      //unit : 1mA
wire [15: 0] VCC1P8_Voltage;      //unit : mV
wire [15: 0] VCC1P8_Current;      //unit : 1mA
wire [15: 0] VCC0P9_Voltage;      //unit : mV
wire [15: 0] VCC0P9_Current;      //unit : 1mA
wire [15: 0] VCC1P03_Voltage;      //unit : mV
wire [15: 0] VCC1P03_Current;      //unit : 1mA
wire [15: 0] VCC1P2_IO_Voltage;      //unit : mV
wire [15: 0] VCC1P2_IO_Current;      //unit : 1mA
wire [15: 0] Fan_Speed;         //unit : rpm
wire [15: 0] Temp_FPGA;         //unit : Celsius degree
wire [15: 0] Temp_Board;        //unit : Celsius degree
//wire [15: 0] Temp_Board2;       //unit : Celsius degree
wire [15: 0] Temp_Power;       //unit : Celsius degree
wire [15: 0] PIN_STATUS;



//----reg
reg [15: 0] rBoard_Version;
reg [15: 0] rMaxCode_Version;
reg [15: 0] rCORE_Voltage;
reg [15: 0] rCORE_Current;
reg [15: 0] rVCC3P3_Voltage;
reg [15: 0] rVCC3P3_Current;
reg [15: 0] rVCC1P8_Voltage;
reg [15: 0] rVCC1P8_Current;
reg [15: 0] rVCC0P9_Voltage;
reg [15: 0] rVCC0P9_Current;
reg [15: 0] rVCC1P03_Voltage;
reg [15: 0] rVCC1P03_Current;
reg [15: 0] rVCC1P2_IO_Voltage;
reg [15: 0] rVCC1P2_IO_Current;
reg [15: 0] rFan_Speed;
reg [15: 0] rTemp_FPGA;
reg [15: 0] rTemp_Board;
//reg [15: 0] rTemp_Board2;
reg [15: 0] rTemp_Power;
reg [15: 0] rPIN_STATUS;
reg [15: 0] rShutdown_flag;



//=======================================================
//  Structural coding
//=======================================================


/////////////////////////// Reset Release IP ////////////////////////////////

wire ninit_done;
reset_release reset_release_int (
    .ninit_done (ninit_done)    //  output,  width = 1, ninit_done.ninit_done
);

wire pll_locked;
wire clk_50;
	sys_pll sys_pll_inst (
		.refclk   (CLK_100_B3A),   //   input,  width = 1,  refclk.clk
		.locked   (pll_locked),   //  output,  width = 1,  locked.export
		.rst      (ninit_done),      //   input,  width = 1,   reset.reset
		.outclk_0 (clk_50)  //  output,  width = 1, outclk0.clk
	);

assign sys_reset = ~pll_locked;


wire user_reset_n;
assign user_reset_n = BUTTON[0];

system u0 (
    .clock_in_clk                  (clk_50),      //   input,   width = 1,               clock_in.clk
    .reset_in0_reset               (~user_reset_n | sys_reset),      //   input,   width = 1,              reset_in0.reset
    .reset_in1_reset               (sys_reset),        //   input,   width = 1,              reset_in1.reset
	 
	 ////////////////////////////////////////////////////
	 // Monitor 12V input (on  Terasic PCIe carrier board)
    .board_info_vcc12_vol_export         (rLTC2945_voltage),         //   input,  width = 16,         board_info_vcc12_vol.export
    .board_info_vcc12_current_export     (rLTC2945_current),      //   input,  width = 16,     board_info_vcc12_current.export
	 
	 
	 ////////////////////////////////////////////////////
	 // interface to MAX10 SPI on SOM
		// six power
    .board_info_core_vol_export           (rCORE_Voltage),                                   //   input,  width = 16,                                   core_voltage.export
    .board_info_core_current_export       (rCORE_Current),                                   //   input,  width = 16,                                   core_current.export
    .board_info_vcc3p3_vol_export         (rVCC3P3_Voltage),      //   input,  width = 16,      board_info_vcc3p3_vol_external_connection.export
    .board_info_vcc3p3_current_export     (rVCC3P3_Current),  //   input,  width = 16,  board_info_vcc3p3_current_external_connection.export
    .board_info_vcc1p8_vol_export         (rVCC1P8_Voltage),  //   input,  width = 16,  board_info_vcc1p8_voltage_external_connection.export
    .board_info_vcc1p8_current_export     (rVCC1P8_Current),  //   input,  width = 16,  board_info_vcc1p8_current_external_connection.export
    .board_info_vcc0p9_vol_export         (rVCC0P9_Voltage),      //   input,  width = 16,      board_info_vcc0p9_vol_external_connection.export
    .board_info_vcc0p9_current_export     (rVCC0P9_Current),  //   input,  width = 16,  board_info_vcc0p9_current_external_connection.export
    .board_info_vcc1p03_vol_export        (rVCC1P03_Voltage),     //   input,  width = 16,     board_info_vcc1p03_vol_external_connection.export
    .board_info_vcc1p03_current_export    (rVCC1P03_Current),  //   input,  width = 16, board_info_vcc1p03_current_external_connection.export
    .board_info_vcc1p2_io_vol_export      (rVCC1P2_IO_Voltage),                              //   input,  width = 16,                              vcc1p2_io_voltage.export
    .board_info_vcc1p2_io_current_export  (rVCC1P2_IO_Current),                              //   input,  width = 16,                              vcc1p2_io_current.export
	 
		// fan adn temperature
    .fan_speed_export             (rFan_Speed),        //   input,  width = 16,             fan_speed1.export
    .temperature_fpga_export       (rTemp_FPGA),        //   input,  width = 16,       temperature_fpga.export
    .temperature_board_export     (rTemp_Board),       //   input,  width = 16,     temperature_board1.export
    .temperature_power_export     (rTemp_Power),      //   input,  width = 16,     temperature_board2.export
    .pin_status_export             (rPIN_STATUS)        //   input,  width = 16,             pin_status.export
);




BOARD_INFO BOARD_INFO_Inst(    
             .RESET_N          (user_reset_n & ~sys_reset    ),  // input
             .CLK_50           (clk_50       ),  // input

             // 4-pin SPI master interface
             .SCLK             (INFO_SPI_SCLK), // output
             .MISO             (INFO_SPI_MISO), // input
             .MOSI             (INFO_SPI_MOSI), // output
             .CS_n             (INFO_SPI_CS_n), // output			 
            // status report (output)
             .Info_Valid       ( Info_Valid     ), //1: following data is valid
             .Board_Version	 ( Board_Version	), //A~F.ex BOARD_VERSION = 16'h000b ,express to revB
             .MaxCode_Version  ( MaxCode_Version), //0~F.ex MAX10_VERSION = 16'h0004 ,express to rev4
             .CORE_Voltage	    ( CORE_Voltage	), //unit : mv   
             .CORE_Current	    ( CORE_Current	), //unit : 10mA 
             .VOL_1P8	       ( VCC1P8_Voltage	      ), //unit : mv   			
             .CUR_1P8	       ( VCC1P8_Current	      ), //unit : mA 			
				 .Fan_Speed	       ( Fan_Speed	   ), //unit : rpm                                     
				 
             .Temp_FPGA	       ( Temp_FPGA	   ), //unit : Celsius degree 
				 .Temp_Board	    ( Temp_Board	   ), //unit : Celsius degree
				 .Temp_POWER	    ( Temp_Power	   ), //unit : Celsius degree
				 .PIN_STATUS	    ( PIN_STATUS	   ),  
             .Shutdown_flag	 ( Shutdown_flag  ),
             .VOL_3P3          ( VCC3P3_Voltage         ),//unit : mv
             .CUR_3P3          ( VCC3P3_Current         ),//unit : mA
             .VOL_0P9          ( VCC0P9_Voltage         ),//unit : mv
             .CUR_0P9          ( VCC0P9_Current         ),//unit : mA
             .VOL_1P03         ( VCC1P03_Voltage        ),//unit : mv		  
             .CUR_1P03         ( VCC1P03_Current        ),//unit : mA		  
             .VOL_1P2_PO       ( VCC1P2_IO_Voltage      ),//unit : mv		  
             .CUR_1P2_PO       ( VCC1P2_IO_Current      )	//unit : mA	
		
				 
);






always @(posedge clk_50) begin
    if (Info_Valid) begin
        rBoard_Version      <= Board_Version;
        rMaxCode_Version    <= MaxCode_Version;
        rCORE_Voltage       <= CORE_Voltage;
        rCORE_Current       <= CORE_Current;
		  
        rVCC3P3_Voltage     <= VCC3P3_Voltage;
        rVCC3P3_Current     <= VCC3P3_Current;
        rVCC1P8_Voltage     <= VCC1P8_Voltage;
        rVCC1P8_Current     <= VCC1P8_Current;
        rVCC0P9_Voltage     <= VCC0P9_Voltage;
        rVCC0P9_Current     <= VCC0P9_Current;
        rVCC1P03_Voltage     <= VCC1P03_Voltage;
        rVCC1P03_Current     <= VCC1P03_Current;
        rVCC1P2_IO_Voltage     <= VCC1P2_IO_Voltage;
        rVCC1P2_IO_Current     <= VCC1P2_IO_Current;
		  
        rFan_Speed          <= Fan_Speed;
        rTemp_FPGA          <= Temp_FPGA;
        rTemp_Board         <= Temp_Board;
        rTemp_Power         <= Temp_Power;
        rPIN_STATUS         <= PIN_STATUS;
    end
end

/////////////////////////////////////////////////
// Monitor 12V input

//LTC2945 Monitor IP
//IP interface
wire       LTC2945_valid  ; 
wire [15:0]LTC2945_voltage;//unit : mv 
wire [15:0]LTC2945_current;//unit : mA 

reg  [15:0]rLTC2945_voltage;//unit : mv 
reg  [15:0]rLTC2945_current;//unit : mA

 LTC2945_INFO  LTC2945_INFO_Inst(    
    .reset_n(user_reset_n & ~sys_reset ),
    .clk_50 (clk_50    ),

    // chip i2c interface
    .i2c_scl(PM_I2C_SCL),
    .i2c_sda(PM_I2C_SDA),
          
    // output voltage and current
    .valid  (LTC2945_valid  ),// high when Voltage and Current is valid
    .voltage(LTC2945_voltage),// unit: mV
    .current(LTC2945_current) // unit: mA
);//


always @(posedge clk_50 ) begin
    if (LTC2945_valid) begin
      rLTC2945_voltage   <=LTC2945_voltage  ; 
      rLTC2945_current   <=LTC2945_current  ; 		   
    end
end




/////////////////////////////////////////////////
// User LED Blink

wire blink;

heart_beat led_blink(
	.clk(CLK_50_B5A),
	.led(blink)
);

assign LED = {4{blink}};


endmodule
